﻿// <summary>ソースコード：スクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemViewBase
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public class McSTGSysDotNetScreenFactoryBase : McDotNetScreenFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csScreen = null;

            //if (McSTGSysDefine.STG_SET_SCREEN.Equals(csScreenKind) == true)
            //{
            //    csScreen = new McSTGCalCtlScreen();
            //}
            if (McSTGSysDefine.STG_CAL_CTL_SCREEN.Equals(csScreenKind) == true)
            {
                csScreen = new McSTGCalCtlScreen();
            }
            else
            {
                csScreen = base.CreateScreen(csSimulatorKind,  csID, csScreenKind);
            }

            return csScreen;
        }
    }
}
