﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using CommonMP.HYMCO.Interface;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemViewBase
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public class McSTGSysDotNetViewerJobBase : McDotNetViewerJob
    {
        /// <summary>スクリーン識別管理ハッシュテーブル</summary>
        protected Hashtable m_csUserScreenTbl = new Hashtable();

        /// <summary>「TaskGroupControlプロジェクトファイル(*.tgc)|*.tgc」</summary>
        private static readonly string FILE_DLG_FILTER = Properties.HymcoSTGSystemViewBaseResource.FILE_DLG_FILTER_TASKGROUP;
        /// <summary>「開くファイルを選択してください」</summary>
        private static readonly string MSG_FILE_OPEN_DLG = Properties.HymcoSTGSystemViewBaseResource.FILE_OPEN_DLG_TITLE;
        /// <summary>「保存先のファイルを入力してください」</summary>
        private static readonly string MSG_FILE_SAVE_DLG = Properties.HymcoSTGSystemViewBaseResource.FILE_SAVE_DLG_TITLE;

        /// <summary>計算開始フラグ</summary>
        protected bool m_bCalStartFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            /*
            if (lCallBackNo == McSTGSysDefine.EVNO_NEW_STG)
            {   // STG新規作成ならば
                HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_CREATE_STGSET_DATA);
                csEventObject.SetToSimKind(m_csSimKindID);
                HySString csSTGFileName = null;
                csEventObject.SetData(csSTGFileName);
                if(m_csViewer.PutEvent(csEventObject) != true)
                {
                    lRtn = -1;
                }
            }
            */
            McSTGCalCtlScreen csSTGCtlScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
            if (lCallBackNo == McSTGSysDefine.EVNO_OPEN_STG)
            {
                McSTGSysManageData csSTGMngData = csSTGCtlScreen.GetSTGSysMngData();
                this.LoadSTGProject(csSTGMngData);
            }
            else if (lCallBackNo == McSTGSysDefine.EVNO_SAVE_STG)
            {
                McSTGSysManageData csSTGMngData = csSTGCtlScreen.GetSTGSysMngData();
                this.SaveSTGProject(csSTGMngData);
            }
            else if (lCallBackNo == McSTGSysDefine.EVNO_NEW_SAVE_STG)
            {
                McSTGSysManageData csSTGMngData = csSTGCtlScreen.GetSTGSysMngData();
                this.NewSaveSTGProject(csSTGMngData);
            }
            else if (lCallBackNo == McSTGSysDefine.EVNO_CMND_STG_CAL_START)
            {
                McSTGSysManageData csSTGMngData = csSTGCtlScreen.GetSTGSysMngData();
                this.STGCalStart(csSTGMngData);
            }
            else if (lCallBackNo == McSTGSysDefine.EVNO_CMND_STG_CAL_STOP)
            {
                McSTGSysManageData csSTGMngData = csSTGCtlScreen.GetSTGSysMngData();
                this.STGCalStop(csSTGMngData);
            }
            else if (lCallBackNo == McSTGSysDefine.EVNO_CMND_STG_CAL_RESET)
            {
                McSTGSysManageData csSTGMngData = csSTGCtlScreen.GetSTGSysMngData();
                this.STGCalReset(csSTGMngData);
            }
            else if (lCallBackNo == McSTGSysDefine.EVNO_CMND_DISP_HELP)
            {
                HySEventObject csEvnt = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_CMND_DISP_HELP);
                csEvnt.SetToSimKind(this.GetSimKind());
                this.PutEvent(csEvnt);
            }
            else if (lCallBackNo == McDefine.HYMCO_FILE_CLOSE)
            {
                // セーブ先を選択しないで上書き保存させる
                // アクティブなモデル管理画面を取得
                // アクティブなモデル管理画面のIDを取得
                HySID csKeyID = this.GetActiveProject();

                //HySID csKeyID = new HySID("Prj01");  //<-- ここはテスト用仮処理
                //McDotNetModelCtlScreen csActiveScreen = this.GetActiveScreen() as McDotNetModelCtlScreen;
                //HySSimulationDataContainer csDt = csActiveScreen.GetDataContainer();

                McSTGSysManageData csSTGMngData = csSTGCtlScreen.GetSTGSysMngData();

                // m_csSTGMngDataからセーブすべきファイル名とコンテナを取得し、コンテナをそのままファイルにセーブする
                //McSTGSysCtlInfo csCalInfo = csSTGMngData.GetCtlInfo(csKeyID);
                HySSimulationDataContainer csContainer = csSTGMngData.GetDataContainer(csKeyID);
                HySString csSaveFileName = csSTGMngData.GetSavePrjctFileNameWithPath(csKeyID);
                HySFile csSaveFile = new HySFile(csSaveFileName);
                if (csSaveFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
                {
                    csSaveFile.DataWrite(csContainer);
                    csSaveFile.Close();
                }

                //画面を消す
                HySEventObject csEvnt = new HySEventObject(HySSysEvent.OBJID_VIEWER,HySEventObject.CMND_DISPLY_COMMON,McDefine.HYM_MODEL_SCREEN_CLOSE);
                csEvnt.SetSuppID(csKeyID);
                csEvnt.SetToSimKind(this.GetSimKind());
                csEvnt.SetData(McDefine.HYM_MODELCTL_SCREEN);
                this.EventCallback(csEvnt);

            }
            else
            {
                lRtn = base.MenuCallBack(lCallBackNo, bCheckOnOff);
            }
            return lRtn;
        }
         
        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            long lSubEventNo = csHySEvent.GetSubEventNo();
            HySKind csSimKind = csHySEvent.GetToSimKind();
            HySID csID = csHySEvent.GetSuppID();


            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {
                if (lSubEventNo == McSTGSysDefine.EVNO_NOTICE_OPEN_STG)
                {
                    // STG読込み完了
                    McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                    if (csScreen != null)
                    {
                        csScreen.SetDispEventData(csEvent);
                    }
                }
                else
                {
                    bRtn = base.EventCallback(csEvent);
                }
            }
            else if (lEventNo == HySEventObject.CMND_CLOSE_SCREEN)
            {   // 画面消去指示ならば
                HySScreen csScreen = base.GetScreen(csSimKind, csID);
                if (csScreen != null)
                {
                    csScreen.CloseScreen();
                    base.DeleteScreen(csScreen);
                }
            }
            else if (lEventNo == McSTGSysDefine.EVNO_CREATE_STGSET_DATA)
            {   // STG作成ならば
                HySEventObject csDispEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN);
                csDispEvent.SetToSimKind(this.GetSimKind());
                csDispEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
                csDispEvent.SetData(McSTGSysDefine.STG_CAL_CTL_SCREEN);
                csDispEvent.SetSubData(csHySEvent.GetSubData());

                this.CmndShowScreen(csDispEvent);
            }
            //else if (lEventNo == McSTGSysDefine.EVNO_SET_STG_COMPLETE)
            //{   // ＳＴＧ設定完了ならば
            //    //csHySEvent.SetTo(HySSysEvent.OBJID_BUSIPROCEDURE);
            //    m_csViewer.PutEvent(csHySEvent);
            //}
            else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_RESTORE_NG ||
                lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION || 
                lEventNo == HySEventObject.NOTICE_SIMULATOR_CREATE_FAIL ||
                lEventNo == McSTGSysDefine.EVNO_NOTICE_NG_STG_MODELCONSTRUCTION )
            {   // シミュレーター作成に失敗（プロジェクトファイル不適）
                // フラグをセット
                m_bCalStartFlg = false;
                // 画面に通知
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.STGModelNG(csID, lEventNo);
                }
                base.EventCallback(csEvent);
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_MODELCONSTRUCTION)
            {   // シミュレーター生成完了ならば
                
                // メニューマスク等設定
                this.ChangeMenuStatus(csEvent);

                // 画面に通知
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.CompleteSTGModelConstruction();
                }
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_INITIALIZE)
            {   //初期化完了ならば
                // フラグをセット
                m_bCalStartFlg = false;

                // メニューマスク等設定
                this.ChangeMenuStatus(csEvent);

                // 画面に通知
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.NoticeSTGCalInitialize();
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION)
            {   // 計算開始不可ならば
                // 画面に通知
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.NoticeSTGCalStartNG(csID);
                }
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_CAL_START)
            {   // 計算開始ならば
                // フラグをセット
                m_bCalStartFlg = true;

                // メニューマスク等設定
                this.ChangeMenuStatus(csEvent);

                // 画面に通知
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.NoticeSTGCalStart();
                }
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_CAL_STOP)
            {   // 計算停止完了ならば
                // フラグをセット
                m_bCalStartFlg = false;

                // メニューマスク等設定
                this.ChangeMenuStatus(csEvent);

                // 画面に通知
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.NoticeSTGCalStop();
                }
            }
            else if (lEventNo == McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN)
            {   // ＳＴＧ設定画面再描画
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.DispReflesh();
                }
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_CAL_COMPLETE)
            {   // ＳＴＧ計算完了
                McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
                if (csScreen != null)
                {
                    csScreen.NoticeSTGCalComplete();
                }
            }
            else if (lEventNo == McSTGSysDefine.EVNO_CMND_DISP_USER_SYS_SCREEN)
            {   // ユーザー定義システム画面表示指示
                this.DispUserSysScreen(csHySEvent);
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NEW_SAVE_STG)
            {
                // 業務からの別名保存イベントはここで受ける
                McSTGSysManageData csSTGMngData = (McSTGSysManageData)csHySEvent.GetSubData();
                this.NewSaveSTGProject(csSTGMngData);
            }
            else if (lEventNo == McSTGSysDefine.EVNO_CMND_SHOW_MANUAL)
            {   // マニュアル表示指示
                this.ShowManual(csHySEvent);
            }
            //else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_OPEN_STG)
            //{
            //    // STG読込み完了
            //    McSTGCalCtlScreen csScreen = this.GetScreen(this.GetSimKind(), McSTGSysDefine.STG_CAL_CTL_SCREEN_ID) as McSTGCalCtlScreen;
            //    if (csScreen != null)
            //    {
            //        csScreen.SetDispEventData(csEvent);
            //    }
            //}
            else
            {
                bRtn = base.EventCallback(csEvent);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントに対応しメニューマスクを変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ChangeMenuStatus( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ChangeMenuStatus(HySSysEvent csEvent)
        {
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_MODELCONSTRUCTION)
            {
                // モデル生成完了
                // Do Nothing
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_INITIALIZE)
            {
                // 初期化完了
                ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.SYSTEMSTART);
                DispStatus((HySEventObject)csEvent);
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_CAL_START)
            {
                // 計算開始
                ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_START);
                DispStatus((HySEventObject)csEvent);
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_STG_CAL_STOP)
            {
                // 計算停止
                ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_STOP);
                DispStatus((HySEventObject)csEvent);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算中フラグ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = GetCalculationFlg( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 演算中、false : 非演算</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool GetCalculationFlg()
        {
            return m_bCalStartFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＳＴＧ設定完了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CompleteSTGSet( csSTGMngData ) </para>
        /// </example>
        /// <param name="csSTGMngData">設定データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void CompleteSTGSet(McSTGSysManageData csSTGMngData)
        {
            HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_SET_STG_COMPLETE);
            csNoticeEvent.SetToSimKind(this.GetSimKind());
            csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
            csNoticeEvent.SetSubData(csSTGMngData);

            m_csViewer.PutEvent(csNoticeEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> STGCalStart( csSTGMngData ) </para>
        /// </example>
        /// <param name="csSTGMngData">STG情報管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void STGCalStart(McSTGSysManageData csSTGMngData)
        {
            //m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_CMND_STG_CAL_START, true);
            HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_CMND_STG_CAL_START);
            csNoticeEvent.SetToSimKind(this.GetSimKind());
            csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
            csNoticeEvent.SetSubData(csSTGMngData);

            m_csViewer.PutEvent(csNoticeEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算停止処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> STGCalStop( csSTGMngData ) </para>
        /// </example>
        /// <param name="csSTGMngData">STG情報管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void STGCalStop(McSTGSysManageData csSTGMngData)
        {
            //m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_CMND_STG_CAL_STOP, true);
            HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_CMND_STG_CAL_STOP);
            csNoticeEvent.SetToSimKind(this.GetSimKind());
            csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
            csNoticeEvent.SetSubData(csSTGMngData);

            m_csViewer.PutEvent(csNoticeEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算リセット処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> STGCalReset( csSTGMngData ) </para>
        /// </example>
        /// <param name="csSTGMngData">STG情報管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void STGCalReset(McSTGSysManageData csSTGMngData)
        {
            //m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_CMND_STG_CAL_RESET, true);
            HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_CMND_STG_CAL_RESET);
            csNoticeEvent.SetToSimKind(this.GetSimKind());
            csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
            csNoticeEvent.SetSubData(csSTGMngData);

            m_csViewer.PutEvent(csNoticeEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト別名保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NewSaveSTGProject( csSTGMngData ) </para>
        /// </example>
        /// <param name="csSTGMngData">STG情報管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void NewSaveSTGProject(McSTGSysManageData csSTGMngData)
        {
            HySString csFileName = null;
            SaveFileDialog csSaveFileDlg = new SaveFileDialog();
            //csSaveFileDlg.FileName = this.STGNameTextBoxE.Text;
            // 初期表示ディレクトリを選択されたプロジェクトGrフォルダとする
            HySString csInitDir = new HySString("");
            HySDataLinkedList csList = csSTGMngData.GetKeyList();
            HySString csKeyStr = null;
            HySID csKeyID = null;
            McSTGSysCtlInfo csCtlInf = null;
            if (csList != null)
            {
                long lNum = csList.GetCount();
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csKeyStr = csList.GetData(lLp) as HySString;
                    csKeyID = new HySID(csKeyStr);
                    csCtlInf = csSTGMngData.GetCtlInfo(csKeyID);
                    csInitDir = csCtlInf.GetProjectGrName();
                }
            }
            csSaveFileDlg.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString() + "\\" + csInitDir.ToString();
            csSaveFileDlg.Filter = FILE_DLG_FILTER;
            csSaveFileDlg.Title = MSG_FILE_SAVE_DLG;
            csSaveFileDlg.RestoreDirectory = true;
            if (csSaveFileDlg.ShowDialog() == DialogResult.OK)
            {
                csFileName = new HySString(csSaveFileDlg.FileName);
                // ダイアログにてプロジェクトファイル拡張子以外で入力された場合には、".stg"を付加して保存処理を行う
                if (csSaveFileDlg.FileName.EndsWith(".tgc") == false)
                {
                    csFileName += ".tgc";
                }
                HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_NEW_SAVE_STG);
                csNoticeEvent.SetToSimKind(this.GetSimKind());
                csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
                csNoticeEvent.SetSubData(csSTGMngData);
                csNoticeEvent.SetData(csFileName);

                m_csViewer.PutEvent(csNoticeEvent);
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト上書保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveSTGProject( csSTGMngData ) </para>
        /// </example>
        /// <param name="csSTGMngData">STG情報管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void SaveSTGProject(McSTGSysManageData csSTGMngData)
        {
            HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_SAVE_STG);
            csNoticeEvent.SetToSimKind(this.GetSimKind());
            csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
            csNoticeEvent.SetSubData(csSTGMngData);
            m_csViewer.PutEvent(csNoticeEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト開く処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadSTGProject( csSTGMngData ) </para>
        /// </example>
        /// <param name="csSTGMngData">STG情報管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void LoadSTGProject(McSTGSysManageData csSTGMngData)
        {
            HySString csFileName = null;
            OpenFileDialog csOpenFileDlg = new OpenFileDialog();
            csOpenFileDlg.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString();
            csOpenFileDlg.Filter = FILE_DLG_FILTER;
            csOpenFileDlg.Title = MSG_FILE_OPEN_DLG;
            csOpenFileDlg.RestoreDirectory = true;
            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {
                csFileName = new HySString(csOpenFileDlg.FileName);
                HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_OPEN_STG);
                csNoticeEvent.SetToSimKind(this.GetSimKind());
                csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
                csNoticeEvent.SetSubData(csSTGMngData);
                csNoticeEvent.SetData(csFileName);

                m_csViewer.PutEvent(csNoticeEvent);
            }
            
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント送信処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PutEvent(csEvent) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void PutEvent(HySSysEvent csEvent)
        {
            m_csViewer.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザ作成画面表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DispUserSysScreen(csEvent) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void DispUserSysScreen(HySEventObject csEvent)
        {
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySID csScreenID = csEvent.GetSuppID();
            HySObjectKind csScreenKind = csEvent.GetData() as HySObjectKind;
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();

            McSTGSysScreenBase csScreen = GetUserScreen(csScreenKind, csScreenID);
            if (csScreen == null)
            {
                csScreen = m_csScreenFactory.CreateScreen(csSimKind, csScreenID, csScreenKind) as McSTGSysScreenBase;
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    csScreen.Initialize();
                    this.SetUserScreen(csScreen);
                }
            }
            if (csScreen != null)
            {  // スクリーンが有効の場合
                csScreen.SetDispEventData(csEvent);
                csScreen.ShowScreen();

                // 業務に表示完了を通知
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_DISPLY_OK);
                csEventObj.SetToSimKind(csSimKind);
                csEventObj.SetSuppID(csScreenID);
                csEventObj.SetSubEventNo(lEventSubNo);
                csEventObj.SetData(csScreenKind);
                m_csViewer.PutEvent(csEventObj);
            }
            //this.CmndShowScreen(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザ作成画面設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUserScreen(csScreen) </para>
        /// </example>
        /// <param name="csScreen">画面（Screen側）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void SetUserScreen(McSTGSysScreenBase csScreen)
        {
            csScreen.SetViewerJob(this);
            csScreen.SetViewer(m_csViewer);

            string sKye = csScreen.GetScreenKind().ToString() + csScreen.GetID().ToString();
            m_csUserScreenTbl[sKye] = csScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザ作成画面表示取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetUserScreen(csScreenKind, csScreenID) </para>
        /// </example>
        /// <param name="csScreenKind">種別</param>
        /// <param name="csScreenID">識別子</param>
        /// <returns>画面（Screen側）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal McSTGSysScreenBase GetUserScreen(HySObjectKind csScreenKind,HySID csScreenID)
        {
            McSTGSysScreenBase csRtn = null;
            string sKye = csScreenKind.ToString()+csScreenID.ToString();
            csRtn = m_csUserScreenTbl[sKye] as McSTGSysScreenBase;
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザ作成画面削除処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteUserScreen(csScreen) </para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void DeleteUserScreen(HySScreen csScreen)
        {
            try
            {
                string sKye = csScreen.GetScreenKind().ToString() + csScreen.GetID().ToString();
                m_csUserScreenTbl.Remove(sKye);
            }
            catch
            { 
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeUndoEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeUndoEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeRedoEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeRedoEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCutEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeCutEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCopyEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeCopyEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticePasteEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticePasteEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeDeleteEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeDeleteEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeAllSelectEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeAllSelectEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>マニュアル表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowManual(csHySEvent) </para>
        /// </example>
        /// <param name="csHySEvent">送付イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ShowManual(HySEventObject csHySEvent)
        {
            HySString csManualFileName = csHySEvent.GetSubData() as HySString;

            HySFile csFile = new HySFile(csManualFileName);
            if (csFile.Exist() == true)
            {
                Help.ShowHelp(new Control(), csManualFileName.ToString());
            }
        }
    }
}
