﻿//
//
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯデフォルト提供モデル共通定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/10][追加]
    /// </para>
    /// </remarks>
    public class HymcoStandardModelDefine
    {
        //****************************
        //===== サンプル用定義 ========
        //****************************
        /// <summary>モデルファクトリ</summary>
        public static readonly HySID HYMCO_STANDARD_MODEL_LIB = new HySID("Hymco.Prpr.StdMdl.Fctry");

        /// <summary>モデルプロパティ設定画面用ファクトリクラス（独自画面作成時に必要）</summary>
        public static HySID PROPERTY_SCREEN_FACTORY_LIB_ID = new HySID("Hymco.Prpr.StdMdl.PrptyScrnFactory");

        /// <summary>ＣＳＶファイル（時系列）入力モデル種別</summary>
        public static readonly HySObjectKind CSV_FILE_IN_KIND = new HySObjectKind("Hymco.Prpr.StdMdl.ReadCSVFileModel");
        /// <summary>ＣＳＶファイル（時系列）入力モデル名称</summary>
        public static readonly HySString CSV_FILE_IN_NAME = new HySString(Properties.HymcoStandardModelPrjResources.MODEL_INPUT_CSV_FILE_IN_NAME);//new HySString("ＣＳＶ時系列ファイル入力");
        /// <summary>ＣＳＶファイル（時系列）出力モデル種別</summary>
        public static readonly HySObjectKind CSV_FILE_OUT_KIND = new HySObjectKind("Hymco.Prpr.StdMdl.WriteCSVFileModel");
        /// <summary>ＣＳＶファイル（時系列）出力）モデル名称</summary>
        public static readonly HySString CSV_FILE_OUT_NAME = new HySString(Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_CSV_FILE_IN_NAME);//new HySString("ＣＳＶ時系列ファイル出力");
        //★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(マージ出力要素モデル)
        //★★★★★★★★★★★★★★★★★★
        /// <summary>ＣＳＶファイル（時系列）マージ出力モデル種別</summary>
        public static readonly HySObjectKind CSV_FILE_OUT_MERGE_KIND = new HySObjectKind("Hymco.Prpr.StdMdl.WriteCSVFileMergeModel");
        /// <summary>ＣＳＶファイル（時系列）出力）マージモデル名称</summary>
        public static readonly HySString CSV_FILE_OUT_MERGE_NAME = new HySString(Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_CSV_FILE_MERGE_IN_NAME);//new HySString("ＣＳＶ時系列ファイルマージ出力");

        /// <summary>２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデル種別：セル内全変数出力</summary>
        public static readonly HySObjectKind GIS_2DMESH_FILE_OUT_KIND = new HySObjectKind("Hymco.Prpr.StdMdl.GIS2DMeshAllOutModel");
        /// <summary>２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力）モデル名称：セル内全変数出力</summary>
        public static readonly HySString GIS_2DMESH_FILE_OUT_NAME = new HySString(Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_2DGIS_CSV_ALLCELL_FILE_IN_NAME);//new HySString("ＧＩＳ２次元メッシュ時系列ファイル出力（セル内全変数）");

        // ★
        /// <summary>２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデル種別：出力変数が１個</summary>
        public static readonly HySObjectKind GIS_2DMESH_1VAL_FILE_OUT_KIND = new HySObjectKind("Hymco.Prpr.StdMdl.GIS2DMesh1ValOutModel");
        /// <summary>２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力）モデル名称：出力変数が１個</summary>
        public static readonly HySString GIS_2DMESH_1VAL_FILE_OUT_NAME = new HySString(Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_2DGIS_CSV_ONECELL_FILE_IN_NAME);//new HySString("ＧＩＳ２次元メッシュ時系列ファイル出力（セル内１変数のみ出力）");


        //********************************
        //===== モデル個別定義 ========
        //********************************

        // ===============================
        // CSV_FILE_Read/Writeモデル用
        // ===============================
        /// <summary>入出力パターン：０次元</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY_D0 = new HySID("ANY_D0");
        /// <summary>入出力パターン：１次元</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY_D1 = new HySID("ANY_D1");
        /// <summary>入出力パターン：２次元</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY_D2 = new HySID("ANY_D2");
        /// <summary>入出力パターン：３次元</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY_D3 = new HySID("ANY_D3");

        // Property 設定のキー情報
        /// <summary>ＣＳＶ出力：上書き／別名ファイル選択（１ならば上書きモード：０ならば別名ファイルモード）</summary>
        public static readonly string OVER_WRITE_OR_OTHER_SWITCH = "Overwrite_or_OtherFile";
        /// <summary>ＣＳＶ出力：上書きファイル名</summary>
        public static readonly string OVER_WRITE_FILE_NAME = "OverWriteFileNameWithPath";
        /// <summary>ＣＳＶ出力：書き出し位置</summary>
        public static readonly string WRITE_DIRECTORY_NAME = "WriteDirectoryName";
        /// <summary>ＣＳＶ出力：書き出しファイル名</summary>
        public static readonly string WRITE_FILE_NAME = "AutoWriteFileName";
        //★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(マージ出力要素モデル)
        //★★★★★★★★★★★★★★★★★★
        /// <summary>ＣＳＶマージ出力：入力線の数</summary>
        public static readonly string INPUT_LINE_NUM = "InputLineNum";


        // ===============================
        // GIS_2DMesh_Writeモデル用
        // ===============================
        /// <summary>GIS ２次元メッシュ(時系列)</summary>
        public static readonly HySID OUT_PATTERN_GIS_2D_MESH_TM = new HySID("GIS_2D_MESH_TM");
        /// <summary>GIS ２次元メッシュ(時系列)</summary>
        public static readonly HySID OUT_PATTERN_GIS_3D_MESH_TM = new HySID("GIS_3D_MESH_TM");


        //--------------------------------
        // モデル設定定数
        //--------------------------------
        /// <summary> 任意入力キー </summary>
        public static readonly string ANY_VALUE_KEY = "Arbitrary Unit";
        /// <summary> 任意入力名称 </summary>
        public static readonly string ANY_VALUE_INPUT_NAME = Properties.HymcoStandardModelPrjResources.MODEL_ARBITRARY_INPUT_PATTERN;
        /// <summary> 任意出力名称 </summary>
        public static readonly string ANY_VALUE_OUTPUT_NAME = Properties.HymcoStandardModelPrjResources.MODEL_ARBITRARY_OUTPUT_PATTERN;
        /// <summary> ２次元メッシュ名称 </summary>
        public static readonly string ANY_VALUE_2D_MESH_NAME = Properties.HymcoStandardModelPrjResources.MODEL_2D_MESH_PATTERN;


    }
}
