﻿// <summary>ソースコード：ＨＹＭＣＯ標準モデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.CoreOptionl.HymcoStandardModel.HymcoStandardModelFactory();
        }
    }
}

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯ標準モデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/10][修正]
    /// </para>
    /// </remarks>
    public class HymcoStandardModelFactory : McModelFactoryBase //McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HymcoStandardModelFactory csFactory = new HymcoStandardModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HymcoStandardModelFactory( )
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return HymcoStandardModelDefine.HYMCO_STANDARD_MODEL_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;
            if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_IN_KIND) == true)
            {
                //ＣＳＶファイル（時系列）入力モデルならば
                csCalModel = new McCSVFileInCtlMdl();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_KIND) == true)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csCalModel = new McCSVFileOutCtlMdl();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                csCalModel = new McGISFileOutCtlMdl();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_1VAL_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                csCalModel = new McGISFileOutCell1ValMdl();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_MERGE_KIND) == true)
            {
                //★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(マージ出力要素モデル)
                //★★★★★★★★★★★★★★★★★★
                //ＣＳＶファイル（時系列）マージ出力モデルならば
                csCalModel = new McCSVFileOutMergeMdl();
            }
            else
            {
            }
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;
            if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_IN_KIND) == true)
            {
                //ＣＳＶファイル（時系列）入力モデルならば
                csCalInfoData = new McCSVFileInInfo();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_KIND) == true)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csCalInfoData = new McCSVFileOutInfo();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                csCalInfoData = new McGISFileOutInfo();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_1VAL_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                csCalInfoData = new McGISFileOutCell1ValInfo();
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_MERGE_KIND) == true)
            {
                //★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(マージ出力要素モデル)
                //★★★★★★★★★★★★★★★★★★
                //ＣＳＶファイル（時系列）マージ出力モデルならば
                csCalInfoData = new McCSVFileOutMergeMdlInfo();
            }
            else
            {
            }
            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }
            McModelPropertyInfo csRtnPrpertyData = null;
            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_IN_KIND) == true)
            {
                //ＣＳＶファイル（時系列）入力モデルならば
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnPrpertyData = csRtnCellPrptyDt;

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_INPUT_FILE, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "");


                csRtnCellPrptyDt.AddInfoType("m_lDataDim", Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_DIM_COUNT, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDataDim", 1);

                csRtnCellPrptyDt.AddInfoType("m_lDim1", Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_1D_DATA_ARRAY, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim1", 1);
                csRtnCellPrptyDt.AddInfoType("m_lDim2", Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_2D_DATA_ARRAY, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim2", 1);
                csRtnCellPrptyDt.AddInfoType("m_lDim3", Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_3D_DATA_ARRAY, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim3", 1);
                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                // 送信パターンの設定
                {
                    // 第０パターン（０次元データ）
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D0,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME) as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(50); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 第１パターン（１次元データ）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D1,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 第２パターン（２次元データ）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D2,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 第３パターン（３次元データ）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D3,
                        McTranInfoDefine.D3_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_OUTPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_KIND) == true)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnPrpertyData = csRtnCellPrptyDt;

                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為
                csRtnCellPrptyDt.AddInfoType("OUTTIME_LAG", Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_TIME_LAG, McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("OUTTIME_LAG", 1.0D * 3600.0D);

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, Properties.HymcoStandardModelPrjResources.MODEL_OVERRITE_FILE, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, 1); // デフォルトは上書き

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_OUTPUT_FILE, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ".\\OutputData\\OutputFile.csv");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_FOLDER, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, "OutputData");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_EXPORT_FILE_NAME, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, "OutputFile.csv");

                // 受信パターンの設定
                {
                    // 第０パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D0,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第１パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D1,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D2,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第３パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D3,
                        McTranInfoDefine.D3_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                //csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnPrpertyData = new McModelPropertyInfo(csLibraryID, csModelKind);

                csRtnPrpertyData.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為
                csRtnPrpertyData.AddInfoType("OUTTIME_LAG", Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_TIME_LAG, McDefine.ValKind.DOUBLE);
                csRtnPrpertyData.SetInfo("OUTTIME_LAG", 1.0D * 3600.0D);

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, Properties.HymcoStandardModelPrjResources.MODEL_OVERRITE_FILE, McDefine.ValKind.LONG);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, 1); // デフォルトは上書き

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_OUTPUT_FILE, McDefine.ValKind.STRING);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ".\\OutputFile.d2gis");

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_FOLDER, McDefine.ValKind.STRING);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, "OutputData");

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_EXPORT_FILE_NAME, McDefine.ValKind.STRING);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, "OutputFile.d2gis");

                // 受信パターンの設定
                {
                }
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_1VAL_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnPrpertyData = csRtnCellPrptyDt;

                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為
                csRtnCellPrptyDt.AddInfoType("OUTTIME_LAG", Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_TIME_LAG, McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("OUTTIME_LAG", 1.0D * 3600.0D);

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, Properties.HymcoStandardModelPrjResources.MODEL_OVERRITE_FILE, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, 1); // デフォルトは上書き

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_OUTPUT_FILE, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ".\\OutputFile.d2gis");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_FOLDER, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, "OutputData");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_EXPORT_FILE_NAME, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, "OutputFile.d2gis");

                // 受信パターンの設定
                {
                    // 第２パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.OUT_PATTERN_GIS_2D_MESH_TM,
                        McTranInfoDefine.D2_GIS_MESH_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_2D_MESH_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    /*  将来用
                    // 第３パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.OUT_PATTERN_GIS_3D_MESH_TM,
                        McTranInfoDefine.D3_GIS_MESH_SERIAL,
                        "３次元メッシュ") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意入力", HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    */
                }
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_MERGE_KIND) == true)
            {
                //★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(マージ出力要素モデル)
                //★★★★★★★★★★★★★★★★★★
                //ＣＳＶファイル（時系列）マージ出力モデルならば
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnPrpertyData = csRtnCellPrptyDt;

                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為
                csRtnCellPrptyDt.AddInfoType("OUTTIME_LAG", Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_TIME_LAG, McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("OUTTIME_LAG", 1.0D * 3600.0D);

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, Properties.HymcoStandardModelPrjResources.MODEL_OVERRITE_FILE, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, 1); // デフォルトは上書き

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_PROPERTY_OUTPUT_FILE, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ".\\OutputData\\OutputFile.csv");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, Properties.HymcoStandardModelPrjResources.MODEL_OUTPUT_FOLDER, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, "OutputData");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_FILE_NAME, Properties.HymcoStandardModelPrjResources.MODEL_EXPORT_FILE_NAME, McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, "OutputFile.csv");

                // 受信パターンの設定
                {
                    // 第０パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D0,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第１パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D1,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, HymcoStandardModelDefine.ANY_VALUE_INPUT_NAME, HySDataKindDefine.ANY_VALUE, HymcoStandardModelDefine.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
            }
            else
            {
            }

            return csRtnPrpertyData;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;
            if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_IN_KIND) == true)
            {
                //ＣＳＶファイル（時系列）入力モデルならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_KIND) == true)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.GIS_2DMESH_1VAL_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(HymcoStandardModelDefine.CSV_FILE_OUT_MERGE_KIND) == true)
            {
                //★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(マージ出力要素モデル)
                //★★★★★★★★★★★★★★★★★★
                //ＣＳＶファイル（時系列）マージ出力モデルならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
            }
            return csRtnDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;


            //ＣＳＶファイル（時系列）入力モデル
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL,
                McModelLibraryDefine.MODEL_CLASSIFICATION_INPUT_CSV_FILE,
                HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                HymcoStandardModelDefine.CSV_FILE_IN_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.HymcoStandardModelPrjResources.MODEL_SUMMARY_INPUT_CSV_FILE);//"時系列－ＣＳＶファイル読込み要素"
            csModelInfo.SetCreatorInf(Properties.HymcoStandardModelPrjResources.MODEL_CREATOR_MY_MODEL);//"CommonMP"
            csModelInfo.SetManualFileName(".\\SystemModel\\McCSVFileInCtlMdl.pdf"); 
            csModelInfo.SetIconName("csvRead");
            m_csCalModelInforList.AddLast(csModelInfo);

            
            //ＣＳＶファイル（時系列）出力モデルならば
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_CSV_FILE,
                    HymcoStandardModelDefine.CSV_FILE_OUT_KIND,
                    HymcoStandardModelDefine.CSV_FILE_OUT_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.HymcoStandardModelPrjResources.MODEL_SUMMARY_OUTPUT_CSV_FILE);//"時系列－ＣＳＶファイル書き出し要素"
            csModelInfo.SetCreatorInf(Properties.HymcoStandardModelPrjResources.MODEL_CREATOR_MY_MODEL);//"CommonMP"
            csModelInfo.SetManualFileName(".\\SystemModel\\McCSVFileOutCtlMdl.pdf"); 
            csModelInfo.SetIconName("csvWrite");
            m_csCalModelInforList.AddLast(csModelInfo);


               
            //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_GIS_FILE,
                HymcoStandardModelDefine.GIS_2DMESH_FILE_OUT_KIND,
                HymcoStandardModelDefine.GIS_2DMESH_FILE_OUT_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.HymcoStandardModelPrjResources.MODEL_SUMMARY_2DGIS_CSV_ALLCELL_FILE);//"２次元ＧＩＳメッシュファイル書出し要素（セル内の全変数を出力する）"
            csModelInfo.SetCreatorInf(Properties.HymcoStandardModelPrjResources.MODEL_CREATOR_MY_MODEL);//"CommonMP"
            csModelInfo.SetManualFileName(".\\SystemModel\\McGISFileOutCtlMdl.pdf"); 
            csModelInfo.SetIconName("DefaultOutput");
            m_csCalModelInforList.AddLast(csModelInfo);


            //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力(１変数のみ)モデルならば
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_GIS_FILE,
                HymcoStandardModelDefine.GIS_2DMESH_1VAL_FILE_OUT_KIND,
                HymcoStandardModelDefine.GIS_2DMESH_1VAL_FILE_OUT_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.HymcoStandardModelPrjResources.MODEL_SUMMARY_2DGIS_CSV_ONECELL_FILE);//"２次元ＧＩＳメッシュファイル書出し要素（セル内の１変数のみ出力する）"
            csModelInfo.SetCreatorInf(Properties.HymcoStandardModelPrjResources.MODEL_CREATOR_MY_MODEL);//"CommonMP"
            //csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); 
            csModelInfo.SetIconName("DefaultOutput");
            csModelInfo.SetLibraryDispMode(false);
            m_csCalModelInforList.AddLast(csModelInfo);

            //★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(マージ出力要素モデル)
            //★★★★★★★★★★★★★★★★★★
            //ＣＳＶファイル（時系列）マージ出力モデルならば
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_CSV_FILE,
                    HymcoStandardModelDefine.CSV_FILE_OUT_MERGE_KIND,
                    HymcoStandardModelDefine.CSV_FILE_OUT_MERGE_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.HymcoStandardModelPrjResources.MODEL_SUMMARY_OUTPUT_CSV_FILE_MERGE);//"時系列（ポイント時系列及び1次元配列）－ＣＳＶファイル書き出し要素（複数入力対応）"
            csModelInfo.SetCreatorInf(Properties.HymcoStandardModelPrjResources.MODEL_CREATOR_MY_MODEL);//"CommonMP"
            csModelInfo.SetManualFileName(".\\SystemModel\\McCSVFileOutMergeMdl.pdf");
            csModelInfo.SetIconName("csvWrite");
            m_csCalModelInforList.AddLast(csModelInfo);

            return m_csCalModelInforList;
        }

    }
}
