﻿// <summary>ソースコード：ＨＹＭＣＯ標準要素モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Model;


namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＣＳＶファイル入力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/01][新規作成]</para>
    /// </remarks>
    public class McCSVFileInCtlMdl : McBasicFileInCtl
    {
        /// <summary> 内部変数 </summary>
        McCSVFileInInfo m_csInFileInfo = null;

        //=========================
        // 演算実行前処理関連メソッド
        //=========================


        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf, lOutputDataNum, csOutputCellData)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;

            if (lOutputDataNum == 0)
            {
                // 警告（エラーではない）
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckWarningData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                    　Properties.HymcoStandardModelPrjResources.STATEMENT_NO_SND_PORT );
               // csErrorInf.AddCheckWarningData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND, "No send port.");
            }

            m_csInFileNameWithFullPath = this.GetDataHomeDirectory() + "\\" + this.GetProjectGroupName() + "\\" + new HySString(m_csInFileInfo.m_sInPutFile);

            // 接続線のチェックを行う
            for (long lP = 0; lP < lOutputDataNum; lP++)
            {   // 出力側接続線数分チェックを行う

                if (HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D0.Equals(csOutputCellData[lP].GetSendPatternID()) == true)
                {   // ０次元配列セル出力ならば
                    m_csInFileInfo.m_lOutPutPortNum += 1;
                    long lD1 = 0;
                    long lD2 = 0;
                    long lD3 = 0;
                    long lCellDataNum = 0;
                    long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                    if (m_csInFileInfo.m_lDim1 > lD1)
                    {
                        bRtn = false;
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                             Properties.HymcoStandardModelPrjResources.STATEMENT_CELLDIM_TOO_SHORT + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       //      "Cell Dimension is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                    }
                    else
                    {
                        bRtn = this.CheckReadFile1D(ref csErrorInf, lOutputDataNum, csOutputCellData);  // ファイルチェック
                    }
                }
                else if (HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D1.Equals(csOutputCellData[lP].GetSendPatternID()) == true)
                {   // １次元配列セル出力ならば
                    if (m_csInFileInfo.m_lDataDim == 1)
                    {
                        m_csInFileInfo.m_lOutPutPortNum += 1;
                        long lD1 = 0;
                        long lD2 = 0;
                        long lD3 = 0;
                        long lCellDataNum = 0;
                        long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                        if (this.m_csInFileInfo.m_lDim1 > lD1)
                        {
                            // エラー
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CELLDIM_TOO_SHORT + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                           // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           //      "Cell Dimension is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        }
                        else
                        {
                            bRtn = this.CheckReadFile1D(ref csErrorInf, lOutputDataNum, csOutputCellData);  // ファイルチェック
                        }
                    }
                    else
                    {
                        // エラー
                        bRtn = false;
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                             Properties.HymcoStandardModelPrjResources.STATEMENT_CELLDIM_TRANSPATTERN_MIS + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       //      "Cell Dimension and Transmission Pattern are mismatch. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                    }
                }
                else if (HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D2.Equals(csOutputCellData[lP].GetSendPatternID()) == true)
                {   // ２次元配列セル出力ならば
                    if (m_csInFileInfo.m_lDataDim == 2)
                    {
                        m_csInFileInfo.m_lOutPutPortNum += 1;
                        long lD1 = 0;
                        long lD2 = 0;
                        long lD3 = 0;
                        long lCellDataNum = 0;
                        long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                        if (this.m_csInFileInfo.m_lDim1 > lD1 || this.m_csInFileInfo.m_lDim2 > lD2)
                        {
                            // エラー
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CELLDIM_TOO_SHORT + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                           // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           //      "Cell Dimension is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        }
                        else
                        {
                            bRtn = this.CheckReadFile2D(ref csErrorInf, lOutputDataNum, csOutputCellData);  // ファイルチェック
                            
                        }
                    }
                    else
                    {
                        // エラー
                        bRtn = false;
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                             Properties.HymcoStandardModelPrjResources.STATEMENT_CELLDIM_TRANSPATTERN_MIS + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       //      "Cell Dimension and Transmission Pattern are mismatch. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                    }
                }
                else if (HymcoStandardModelDefine.IN_OUT_PATTERN_ANY_D3.Equals(csOutputCellData[lP].GetSendPatternID()) == true)
                {   // ３次元配列セル出力ならば
                    if (m_csInFileInfo.m_lDataDim == 3)
                    {
                        m_csInFileInfo.m_lOutPutPortNum += 1;
                        long lD1 = 0;
                        long lD2 = 0;
                        long lD3 = 0;
                        long lCellDataNum = 0;
                        long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                        if (this.m_csInFileInfo.m_lDim1 > lD1 || this.m_csInFileInfo.m_lDim2 > lD2 || this.m_csInFileInfo.m_lDim3 > lD3)
                        {
                            // エラー
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CELLDIM_TOO_SHORT + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                           // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           //      "Cell Dimension is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        }
                        else
                        {
                            bRtn = this.CheckReadFile3D(ref csErrorInf,  lOutputDataNum,  csOutputCellData); // ファイルチェック
                        }
                    }
                    else
                    {
                        // エラー
                        bRtn = false;
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                             Properties.HymcoStandardModelPrjResources.STATEMENT_CELLDIM_TRANSPATTERN_MIS + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       //      "Cell Dimension and Transmission Pattern are mismatch. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                    }
                }
                else
                {
                    // エラー
                    bRtn = false;
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                        Properties.HymcoStandardModelPrjResources.STATEMENT_UNEXPECT_DATA_TYPE );
                   // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                   //     "Unexpected send data type.");
                }
            }

            return bRtn;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = Initialize(csInitialData, lInputDataNum, csInputCellData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = false;
            if (m_csInFileInfo.m_lDataDim == 1)
            {
                bRtn = this.FileRead1D(ref csInitialData);
            }
            else if (m_csInFileInfo.m_lDataDim == 2)
            {
                bRtn = this.FileRead2D(ref csInitialData);
            }
            else if (m_csInFileInfo.m_lDataDim == 3)
            {
                bRtn = this.FileRead3D(ref csInitialData);
            }
            else
            {
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = OnlineInitialize(csInitialData, lInputDataNum, csInputCellData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool OnlineInitialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputDataList)</para>
        /// </example>
        /// <param name="csInputDataList">演算に必要な入力情報リスト</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long Calculate(ref HySDataLinkedList csInputDataList)
        {
            m_lCalculate_Call_Before_DataFution_Call += 1; // Calculate Call 回数カウントアップ
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion(lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            long lRtn = -1;
            if (m_csInFileInfo.m_lDataDim == 1)
            {
                lRtn = this.DataFusion1D(lOutputDataNum, ref  csOutputCellData);
            }
            else if (m_csInFileInfo.m_lDataDim == 2)
            {
                lRtn = this.DataFusion2D( lOutputDataNum, ref  csOutputCellData);
            }
            else if (m_csInFileInfo.m_lDataDim == 3)
            {
                lRtn = this.DataFusion3D(lOutputDataNum, ref  csOutputCellData);
            }
            else
            {
            }

            return lRtn;
        }

        //====================
        // 処理場のプライベートメソッド
        //====================

        // ＣＳＶヘッダーチェック
        /// <summary><para>method outline:</para>
        /// <para>（１Ｄデータ）ＣＳＶファイルチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckReadFile1D(ref csErrorInf,lOutputDataNum,csOutputCellData)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected virtual bool CheckReadFile1D(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;

            // CSV入力データの格納用クラス
            if (m_csInFileInfo.m_csRead1DCSVData == null)
            {
                m_csInFileInfo.m_csRead1DCSVData = new HySCSVFileDim1Data();
            }

            // 読み込むべきファイルの整合性チェックを行う
            string sFilePath = this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" + m_csInFileInfo.m_sInPutFile;
            //m_csInFile = new HySFile(m_csInFileInfo.m_sInPutFile);
            m_csInFile = new HySFile(sFilePath);
            if (m_csInFile.Exist() == true)
            {   // データの読み込み
                if (m_csInFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                {
                    long lRtn = m_csInFileInfo.m_csRead1DCSVData.HeadInfRead(m_csInFile);  // <-- ヘッダー情報だけ読めば良い                   
                    m_csInFile.Close();

                    if (lRtn == 0)
                    {
                        long lD1 = 0;
                        m_csInFileInfo.m_csRead1DCSVData.GetDimention(ref lD1);
                        if (this.m_csInFileInfo.m_lDim1 != lD1 )
                        {   // 伝送クラスが、読み込みデータを送信出来ない。
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CVS_DIM_MIS + "(" + lD1 + ") != " 
                               + Properties.HymcoStandardModelPrjResources.STATEMENT_SETDIM + "(" + this.m_csInFileInfo.m_lDim1  + ")");
                           // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           //      "CSV File Data Dimension mismatch.    "
                           //      + "CSVFileDim(" + lD1 + ") != SetDim(" +
                           //      +this.m_csInFileInfo.m_lDim1 + ")");
                        }
                    }
                    else
                    {   // フォーマット不一致
                        bRtn = false;
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           Properties.HymcoStandardModelPrjResources.STATEMENT_CVS_FILE_READ_NG + m_csInFileInfo.m_sInPutFile + ")  "
                           + Properties.HymcoStandardModelPrjResources.STATEMENT_CHECK_FORMAT );
                       // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       //    "CSV File read error. (File Name = " + m_csInFileInfo.m_sInPutFile + ")  === check format please ===");
                    }
                }
                else
                {   // ファイル読込エラー
                    bRtn = false;
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       Properties.HymcoStandardModelPrjResources.STATEMENT_CANT_OPEN_FILE + m_csInFileInfo.m_sInPutFile + ")");
                   // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                   //    "Cannot open the File. (File Name = " + m_csInFileInfo.m_sInPutFile + ")");
                }
            }
            else
            {   // 読み込みファイルが存在しない。
                bRtn = false;
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                   Properties.HymcoStandardModelPrjResources.STATEMENT_FILE_NOT_EXIST + m_csInFileInfo.m_sInPutFile + ")");
               // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
               //    "File not exist. (File Name = " + m_csInFileInfo.m_sInPutFile + ")");
            }
            return bRtn;
        }        
        /// <summary><para>method outline:</para>
        /// <para>（２Ｄデータ）ＣＳＶファイルチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckReadFile2D(ref csErrorInf,lOutputDataNum,csOutputCellData)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected virtual bool CheckReadFile2D(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;

            // CSV入力データの格納用クラス
            if (m_csInFileInfo.m_csRead2DCSVData == null)
            {
                m_csInFileInfo.m_csRead2DCSVData = new HySCSVFileDim2Data();
            }
            
            // 読み込むべきファイルの整合性チェックを行う
            string sFilePath = this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" + m_csInFileInfo.m_sInPutFile;
            //m_csInFile = new HySFile(m_csInFileInfo.m_sInPutFile);
            m_csInFile = new HySFile(sFilePath);
            if (m_csInFile.Exist() == true)
            {   // データの読み込み
                if (m_csInFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                {
                    long lRtn = m_csInFileInfo.m_csRead2DCSVData.HeadInfRead(m_csInFile);  // <-- ヘッダー情報だけ読めば良い                   
                    m_csInFile.Close();

                    if (lRtn == 0)
                    {
                        long lD1 = 0;
                        long lD2 = 0;
                        m_csInFileInfo.m_csRead2DCSVData.GetDimention(ref lD1, ref lD2);
                        if (this.m_csInFileInfo.m_lDim1 != lD1 || this.m_csInFileInfo.m_lDim2 != lD2 )
                        {   // 伝送クラスが、読み込みデータを送信出来ない。
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CVS_DIM_MIS + "(" + lD1 + "," + lD2 + ") != "
                               + Properties.HymcoStandardModelPrjResources.STATEMENT_SETDIM + "(" + this.m_csInFileInfo.m_lDim1 + "," + this.m_csInFileInfo.m_lDim2 + ")");
                           // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           //      "CSV File Data Dimension mismatch.    "
                           //      + "CSVFileDim(" + lD1 + "," + lD2 + ") != SetDim(" +
                           //      +this.m_csInFileInfo.m_lDim1 + "," + this.m_csInFileInfo.m_lDim2
                           //      + ")");
                        }
                    }
                    else
                    {   // フォーマット不一致
                        bRtn = false;
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           Properties.HymcoStandardModelPrjResources.STATEMENT_CVS_FILE_READ_NG + m_csInFileInfo.m_sInPutFile + ")  "
                           + Properties.HymcoStandardModelPrjResources.STATEMENT_CHECK_FORMAT );
                       // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       //    "CSV File read error. (File Name = " + m_csInFileInfo.m_sInPutFile + ")  === check format please ===");
                    }
                }
                else
                {   // ファイル読込エラー
                    bRtn = false;
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       Properties.HymcoStandardModelPrjResources.STATEMENT_CANT_OPEN_FILE + m_csInFileInfo.m_sInPutFile + ")");
                   // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                   //    "Cannot open the File. (File Name = " + m_csInFileInfo.m_sInPutFile + ")");
                }
            }
            else
            {   // 読み込みファイルが存在しない。
                bRtn = false;
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                   Properties.HymcoStandardModelPrjResources.STATEMENT_FILE_NOT_EXIST + m_csInFileInfo.m_sInPutFile + ")");
               // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
               //    "File not exist. (File Name = " + m_csInFileInfo.m_sInPutFile + ")");
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>（３Ｄデータ）ＣＳＶファイルチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckReadFile3D(ref csErrorInf,lOutputDataNum,csOutputCellData)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected virtual bool CheckReadFile3D(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;

            // CSV入力データの格納用クラス
            if (m_csInFileInfo.m_csRead3DCSVData == null)
            {
                m_csInFileInfo.m_csRead3DCSVData = new HySCSVFileDim3Data();
            }
            
            // 読み込むべきファイルの整合性チェックを行う
            string sFilePath = this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" + m_csInFileInfo.m_sInPutFile;
            //m_csInFile = new HySFile(m_csInFileInfo.m_sInPutFile);
            m_csInFile = new HySFile(sFilePath);
            if (m_csInFile.Exist() == true)
            {   // データの読み込み
                if( m_csInFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0 )
                {
                    long lRtn = m_csInFileInfo.m_csRead3DCSVData.HeadInfRead(m_csInFile);  // <-- ヘッダー情報だけ読めば良い                   
                    m_csInFile.Close();

                    if (lRtn == 0)
                    {
                        long lD1 = 0;
                        long lD2 = 0;
                        long lD3 = 0;
                        m_csInFileInfo.m_csRead3DCSVData.GetDimention(ref lD1, ref lD2, ref lD3);
                        if (this.m_csInFileInfo.m_lDim1 != lD1 || this.m_csInFileInfo.m_lDim2 != lD2 || this.m_csInFileInfo.m_lDim3 != lD3)
                        {   // 伝送クラスが、読み込みデータを送信出来ない。
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CVS_DIM_MIS +"(" + lD1 +","+lD2+","+lD3+") != "
                               + Properties.HymcoStandardModelPrjResources.STATEMENT_SETDIM +"("
                               + this.m_csInFileInfo.m_lDim1+","+ this.m_csInFileInfo.m_lDim2 +","+ this.m_csInFileInfo.m_lDim3 + ")");
                           // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           //      "CSV File Data Dimension mismatch.    "
                           //      + "CSVFileDim(" + lD1 + "," + lD2 + "," + lD3 + ") != SetDim(" +
                           //      +this.m_csInFileInfo.m_lDim1 + "," + this.m_csInFileInfo.m_lDim2 + "," + this.m_csInFileInfo.m_lDim3
                           //      + ")");
                        }
                    }
                    else
                    {   // フォーマット不一致
                        bRtn = false;
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                           Properties.HymcoStandardModelPrjResources.STATEMENT_CVS_FILE_READ_NG + m_csInFileInfo.m_sInPutFile + ")  === check format please ===");
                       // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       //    "CSV File read error. (File Name = " + m_csInFileInfo.m_sInPutFile + ")  === check format please ===");
                    }
                }
                else
                {   // ファイル読込エラー
                    bRtn = false;
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                       Properties.HymcoStandardModelPrjResources.STATEMENT_CANT_OPEN_FILE + m_csInFileInfo.m_sInPutFile + ")");
                   // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                   //    "Cannot open the File. (File Name = " + m_csInFileInfo.m_sInPutFile + ")");
                }
            }
            else
            {   // 読み込みファイルが存在しない。
                bRtn = false;
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                   Properties.HymcoStandardModelPrjResources.STATEMENT_FILE_NOT_EXIST + m_csInFileInfo.m_sInPutFile + ")");
               // csErrorInf.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
               //    "File not exist. (File Name = " + m_csInFileInfo.m_sInPutFile + ")");
            }
            return bRtn;
        }

        // データ読み込み
        
        /// <summary><para>method outline:</para>
        /// <para>（１Ｄデータ）ＣＳＶファイルを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileRead1D(ref csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual bool FileRead1D(ref McPropertyInfoRoot csInitialData)
        {
            bool bRtn = false;
            // 送信済み関連情報初期値
            m_csInFileInfo.m_csLastDataSendTime = HySTime.DEFAULT_TIME.Clone();
            m_csInFileInfo.m_lSndRcrdNum = 0;

            // CSV入力データの格納用クラス
            if (m_csInFileInfo.m_csRead1DCSVData == null)
            {
                m_csInFileInfo.m_csRead1DCSVData = new HySCSVFileDim1Data();
            }
            string sFilePath = this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" + m_csInFileInfo.m_sInPutFile;
            //m_csInFile = new HySFile(m_csInFileInfo.m_sInPutFile);
            m_csInFile = new HySFile(sFilePath);
            if (m_csInFile.Exist() == true)
            {   // データの読み込み
                m_csInFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                m_csInFileInfo.m_lRecNum = m_csInFileInfo.m_csRead1DCSVData.ReadCSVFile(m_csInFile);
                m_csInFile.Close();
                if (m_csInFileInfo.m_lRecNum > 0)
                {
                    bRtn = true;
                    HySDataLinkedList csHoldData = m_csInFileInfo.m_csRead1DCSVData.GetDataList();
                    csHoldData.SetCursorFirst(); // 読み出しカーソル位置を最初に持ってきておく
                    m_csInFileInfo.m_csNext1DSndRcrd = csHoldData.GetCursorData() as HySCSVFileDim1Data.CSVDim1Recorde;

                    m_csInFileInfo.m_csRead1DCSVData.GetDimention(ref m_csInFileInfo.m_lDim1);
                    for (long lP = 0; lP < m_lOutputDataNum; lP++)
                    {
                        long lD1 = 0;
                        long lD2 = 0;
                        long lD3 = 0;
                        long lCellDataNum = 0;
                        long lCellDim = m_OutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                        if (this.m_csInFileInfo.m_lDim1 > lD1)
                        {   // 伝送クラスが、読み込みデータを送信出来ない。
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize",
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CELL_SHORT + "("
                               + Properties.HymcoStandardModelPrjResources.STATEMENT_SEND_TO + m_OutputCellData[lP].GetLowerElementID().ToString() + ")");
                           // McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize",
                           //      "Cell Dimension is too short. (Send To " + m_OutputCellData[lP].GetLowerElementID().ToString() + ")");
                        }
                    }
                }
                else
                {   // ファイル読込エラー
                   // ver1.5 エラートレース日本語対応
                    McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
                        McLog.SYSTEM, "Initialize", Properties.HymcoStandardModelPrjResources.STATEMENT_READ_DATA_NO + "(" + m_csInFileInfo.m_sInPutFile + ")");
                   // McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
                   //     McLog.SYSTEM, "Initialize", "Cannot read data file(" + m_csInFileInfo.m_sInPutFile + ")");
                }
            }
            else
            {   // 読み込みファイルが存在しない。
               // ver1.5 エラートレース日本語対応
                McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
                    McLog.SYSTEM, "Initialize", Properties.HymcoStandardModelPrjResources.STATEMENT_OPEN_DATA_FILE_NO + "(" + m_csInFileInfo.m_sInPutFile + ")");
               // McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
               //     McLog.SYSTEM, "Initialize", "Cannot open data file(" + m_csInFileInfo.m_sInPutFile + ")");
            }

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>（２Ｄデータ）ＣＳＶファイルを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileRead2D(ref csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual bool FileRead2D(ref McPropertyInfoRoot csInitialData)
        {
            bool bRtn = false;
            // 送信済み関連情報初期値
            m_csInFileInfo.m_csLastDataSendTime = HySTime.DEFAULT_TIME.Clone();
            m_csInFileInfo.m_lSndRcrdNum = 0;

            // CSV入力データの格納用クラス
            if (m_csInFileInfo.m_csRead2DCSVData == null)
            {
                m_csInFileInfo.m_csRead2DCSVData = new HySCSVFileDim2Data();
            }

            string sFilePath = this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" + m_csInFileInfo.m_sInPutFile;
            //m_csInFile = new HySFile(m_csInFileInfo.m_sInPutFile);
            m_csInFile = new HySFile(sFilePath);
            if (m_csInFile.Exist() == true)
            {   // データの読み込み
                m_csInFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                m_csInFileInfo.m_lRecNum = m_csInFileInfo.m_csRead2DCSVData.ReadCSVFile(m_csInFile);
                m_csInFile.Close();
                if (m_csInFileInfo.m_lRecNum > 0)
                {
                    bRtn = true;
                    HySDataLinkedList csHoldData = m_csInFileInfo.m_csRead2DCSVData.GetDataList();
                    csHoldData.SetCursorFirst(); // 読み出しカーソル位置を最初に持ってきておく
                    m_csInFileInfo.m_csNext2DSndRcrd = csHoldData.GetCursorData() as HySCSVFileDim2Data.CSVDim2Recorde;

                    m_csInFileInfo.m_csRead2DCSVData.GetDimention(ref m_csInFileInfo.m_lDim1, ref m_csInFileInfo.m_lDim2);
                    for (long lP = 0; lP < m_lOutputDataNum; lP++)
                    {
                        long lD1 = 0;
                        long lD2 = 0;
                        long lD3 = 0;
                        long lCellDataNum = 0;
                        long lCellDim = m_OutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                        if (this.m_csInFileInfo.m_lDim1 > lD1 || this.m_csInFileInfo.m_lDim2 > lD2)
                        {   // 伝送クラスが、読み込みデータを送信出来ない。
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize",
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CELL_SHORT + "("
                               + Properties.HymcoStandardModelPrjResources.STATEMENT_SEND_TO + m_OutputCellData[lP].GetLowerElementID().ToString() + ")");
                           // McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize",
                           //      "Cell Dimension is too short. (Send To " + m_OutputCellData[lP].GetLowerElementID().ToString() + ")");
                        }
                    }
                }
                else
                {   // ファイル読込エラー
                   // ver1.5 エラートレース日本語対応
                    McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize", 
                        Properties.HymcoStandardModelPrjResources.STATEMENT_READ_DATA_NO + "(" + m_csInFileInfo.m_sInPutFile + ")");
                   // McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
                   //     McLog.SYSTEM, "Initialize", "Cannot read data file(" + m_csInFileInfo.m_sInPutFile + ")");
                }
            }
            else
            {   // 読み込みファイルが存在しない。
               // ver1.5 エラートレース日本語対応
                McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize", 
                    Properties.HymcoStandardModelPrjResources.STATEMENT_OPEN_DATA_FILE_NO + "(" + m_csInFileInfo.m_sInPutFile + ")");
               // McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
               //     McLog.SYSTEM, "Initialize", "Cannot open data file(" + m_csInFileInfo.m_sInPutFile + ")");
            }

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>（３Ｄデータ）ＣＳＶファイルを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileRead3D(ref csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual bool FileRead3D(ref McPropertyInfoRoot csInitialData)
        {
            bool bRtn = false;
            // 送信済み関連情報初期値
            m_csInFileInfo.m_csLastDataSendTime = HySTime.DEFAULT_TIME.Clone();
            m_csInFileInfo.m_lSndRcrdNum = 0;

            // CSV入力データの格納用クラス
            if (m_csInFileInfo.m_csRead3DCSVData == null)
            {
                m_csInFileInfo.m_csRead3DCSVData = new HySCSVFileDim3Data();
            }

            string sFilePath = this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" + m_csInFileInfo.m_sInPutFile;
            //m_csInFile = new HySFile(m_csInFileInfo.m_sInPutFile);
            m_csInFile = new HySFile(sFilePath);
            if (m_csInFile.Exist() == true)
            {   // データの読み込み
                m_csInFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                m_csInFileInfo.m_lRecNum = m_csInFileInfo.m_csRead3DCSVData.ReadCSVFile(m_csInFile);
                m_csInFile.Close();
                if (m_csInFileInfo.m_lRecNum > 0)
                {
                    bRtn = true;
                    HySDataLinkedList csHoldData = m_csInFileInfo.m_csRead3DCSVData.GetDataList();
                    csHoldData.SetCursorFirst(); // 読み出しカーソル位置を最初に持ってきておく
                    m_csInFileInfo.m_csNext3DSndRcrd = csHoldData.GetCursorData() as HySCSVFileDim3Data.CSVDim3Recorde;

                    m_csInFileInfo.m_csRead3DCSVData.GetDimention(ref m_csInFileInfo.m_lDim1, ref m_csInFileInfo.m_lDim2, ref m_csInFileInfo.m_lDim3);
                    for (long lP = 0; lP < m_lOutputDataNum; lP++)
                    {
                        long lD1 = 0;
                        long lD2 = 0;
                        long lD3 = 0;
                        long lCellDataNum = 0;
                        long lCellDim = m_OutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                        if (this.m_csInFileInfo.m_lDim1 > lD1 || this.m_csInFileInfo.m_lDim2 > lD2 || this.m_csInFileInfo.m_lDim3 > lD3)
                        {   // 伝送クラスが、読み込みデータを送信出来ない。
                            bRtn = false;
                           // ver1.5 エラートレース日本語対応
                            McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize",
                                 Properties.HymcoStandardModelPrjResources.STATEMENT_CELL_SHORT +"(" 
                               + Properties.HymcoStandardModelPrjResources.STATEMENT_SEND_TO + m_OutputCellData[lP].GetLowerElementID().ToString() + ")");
                           // McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize",
                           //      "Cell Dimension is too short. (Send To " + m_OutputCellData[lP].GetLowerElementID().ToString() + ")");
                        }
                    }
                }
                else
                {   // ファイル読込エラー
                   // ver1.5 エラートレース日本語対応
                    McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize",
                        Properties.HymcoStandardModelPrjResources.STATEMENT_READ_DATA_NO +"(" + m_csInFile + ")");
                   // McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
                   //     McLog.SYSTEM, "Initialize", "Cannot read data file(" + m_csInFile + ")");
                }
            }
            else
            {   // 読み込みファイルが存在しない。
               // ver1.5 エラートレース日本語対応
                McLog.DebugOut(this.GetSimulationTime(), this.GetID(), McLog.SYSTEM, "Initialize", 
                    Properties.HymcoStandardModelPrjResources.STATEMENT_OPEN_DATA_FILE_NO + "(" + m_csInFileInfo.m_sInPutFile + ")");
               // McLog.DebugOut(this.GetSimulationTime(), this.GetID(),
               //     McLog.SYSTEM, "Initialize", "Cannot open data file(" + m_csInFileInfo.m_sInPutFile + ")");
            }

            return bRtn;
        }

        // ＤａｔａＦｕｓｉｏｎ
        /// <summary><para>method outline:</para>
        /// <para>（１Ｄデータ）モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion1D( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>複数接続があった場合、全て同じ情報が出ることに注意（分配して出しているわけではない）</para>
        /// </remarks>
        protected virtual long DataFusion1D(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            long lRtn = 0;

            HySTime csCursTm = HySTime.DEFAULT_TIME.Clone();
            HySCellData[] csSndCellData = null;
            double[] dReadData = null;

            // 送信すべき時系列データリスト
            HySDataLinkedList csHoldData = m_csInFileInfo.m_csRead1DCSVData.GetDataList();
            csHoldData.SetCursorFirst();
            for (long lNum = 0; lNum < m_csInFileInfo.m_lRecNum; lNum++)
            {   // 時系列データ数分繰り返し
                if (lNum < m_csInFileInfo.m_lSndRcrdNum)
                {   // 既に送信した情報は空読み（なにもしない）
                    csHoldData.MoveCursorNext();
                    continue;
                }
                // 次に送信すべきレコード(カーソルデータ）
                m_csInFileInfo.m_csNext1DSndRcrd = csHoldData.GetCursorData() as HySCSVFileDim1Data.CSVDim1Recorde;

                if (m_csInFileInfo.m_csNext1DSndRcrd.GetTime().After(this.GetSimulationTime()) != true)
                {  // カーソルデータが現在時刻よりも前 or 同じならば 送信しなければならない
                    if (m_csInFileInfo.m_csNext1DSndRcrd.GetTime().After(m_csInFileInfo.m_csLastDataSendTime) == true)
                    {   // 送信済み時刻よりも後の情報ならば　送信しなければならない
                        dReadData = m_csInFileInfo.m_csNext1DSndRcrd.GetData();
                        for (long lP = 0; lP < lOutputDataNum; lP++)
                        {   // 送信接続数繰り返し
                            csOutputCellData[lP].SetCurrentTime(m_csInFileInfo.m_csNext1DSndRcrd.GetTime());
                            csSndCellData = csOutputCellData[lP].PrepareSendCellD1();  // 送信情報の準備
                            for (long lLp1 = 0; lLp1 < m_csInFileInfo.m_lDim1; lLp1++)
                            {   // 配列１
                                csSndCellData[lLp1].m_dData[0] = dReadData[lLp1];
                            }
                        }   // end of for(送信接続数）
                        m_csInFileInfo.m_csLastDataSendTime.SetTime(m_csInFileInfo.m_csNext1DSndRcrd.GetTime()); // 送信時刻の設定
                        m_csInFileInfo.m_lSndRcrdNum += 1;
                    }
                }
                else
                {
                    // 今回は送信しない
                    break;
                }
            }

            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>（２Ｄデータ）モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion2D( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>複数接続があった場合、全て同じ情報が出ることに注意（分配して出しているわけではない）</para>
        /// </remarks>
        protected virtual long DataFusion2D(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            long lRtn = 0;

            HySTime csCursTm = HySTime.DEFAULT_TIME.Clone();
            HySCellData[,] csSndCellData = null;
            HySCSVFileDim2Data.CSVDim2Recorde.CSVRowData[] csReadData = null;
            double[] dReadData = null;

            // 送信すべき時系列データリスト
            HySDataLinkedList csHoldData = m_csInFileInfo.m_csRead2DCSVData.GetDataList();
            csHoldData.SetCursorFirst();
            for (long lNum = 0; lNum < m_csInFileInfo.m_lRecNum; lNum++)
            {   // 時系列データ数分繰り返し
                if (lNum < m_csInFileInfo.m_lSndRcrdNum)
                {   // 既に送信した情報は空読み（なにもしない）
                    csHoldData.MoveCursorNext();
                    continue;
                }
                // 次に送信すべきレコード(カーソルデータ）
                m_csInFileInfo.m_csNext2DSndRcrd = csHoldData.GetCursorData() as HySCSVFileDim2Data.CSVDim2Recorde;

                if (m_csInFileInfo.m_csNext2DSndRcrd.GetTime().After(this.GetSimulationTime()) != true)
                {  // カーソルデータが現在時刻よりも前 or 同じならば 送信しなければならない
                    if (m_csInFileInfo.m_csNext2DSndRcrd.GetTime().After(m_csInFileInfo.m_csLastDataSendTime) == true)
                    {   // 送信済み時刻よりも後の情報ならば　送信しなければならない
                        csReadData = m_csInFileInfo.m_csNext2DSndRcrd.GetData();
                        for (long lP = 0; lP < lOutputDataNum; lP++)
                        {   // 送信接続数繰り返し
                            csOutputCellData[lP].SetCurrentTime(m_csInFileInfo.m_csNext2DSndRcrd.GetTime());
                            csSndCellData = csOutputCellData[lP].PrepareSendCellD2();  // 送信情報の準備
                            for (long lLp2 = 0; lLp2 < m_csInFileInfo.m_lDim2; lLp2++)
                            {   // 配列２
                                dReadData = csReadData[lLp2].GetData();
                                for (long lLp1 = 0; lLp1 < m_csInFileInfo.m_lDim1; lLp1++)
                                {   // 配列１
                                    csSndCellData[lLp1, lLp2].m_dData[0] = dReadData[lLp1];
                                }
                            }
                        }   // end of for(送信接続数）
                        m_csInFileInfo.m_csLastDataSendTime.SetTime(m_csInFileInfo.m_csNext2DSndRcrd.GetTime()); // 送信時刻の設定
                        m_csInFileInfo.m_lSndRcrdNum += 1;
                    }
                }
                else
                {
                    // 今回は送信しない
                    break;
                }
            }

            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>（３Ｄデータ）モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion3D( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long DataFusion3D(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            long lRtn = 0;

            HySTime csCursTm = HySTime.DEFAULT_TIME.Clone();
            HySCellData[, ,] csSndCellData = null;
            HySCSVFileDim3Data.CSVDim3Recorde.CSVDim2Recorde[] csReadDataD2 = null;
            HySCSVFileDim3Data.CSVDim3Recorde.CSVDim2Recorde.CSVRowData[] csReadData = null;
            double[] dReadData = null;

            // 送信すべき時系列データリスト
            HySDataLinkedList csHoldData = m_csInFileInfo.m_csRead3DCSVData.GetDataList();
            csHoldData.SetCursorFirst();
            for (long lNum = 0; lNum < m_csInFileInfo.m_lRecNum; lNum++)
            {   // 時系列データ数分繰り返し
                if (lNum < m_csInFileInfo.m_lSndRcrdNum)
                {   // 既に送信した情報は空読み（なにもしない）
                    csHoldData.MoveCursorNext();
                    continue;
                }
                // 次に送信すべきレコード(カーソルデータ）
                m_csInFileInfo.m_csNext3DSndRcrd = csHoldData.GetCursorData() as HySCSVFileDim3Data.CSVDim3Recorde;

                if (m_csInFileInfo.m_csNext3DSndRcrd.GetTime().After(this.GetSimulationTime()) != true)
                {  // カーソルデータが現在時刻よりも前 or 同じならば 送信しなければならない
                    if (m_csInFileInfo.m_csNext3DSndRcrd.GetTime().After(m_csInFileInfo.m_csLastDataSendTime) == true)
                    {   // 送信済み時刻よりも後の情報ならば　送信しなければならない

                        csReadDataD2 = m_csInFileInfo.m_csNext3DSndRcrd.GetData();
                        for (long lP = 0; lP < lOutputDataNum; lP++)
                        {   // 送信接続数繰り返し

                            csOutputCellData[lP].SetCurrentTime(m_csInFileInfo.m_csNext3DSndRcrd.GetTime());
                            csSndCellData = csOutputCellData[lP].PrepareSendCellD3();  // 送信情報の準備
                            for (long lLp3 = 0; lLp3 < m_csInFileInfo.m_lDim3; lLp3++)
                            {   // 配列３
                                csReadData = csReadDataD2[lLp3].GetData();
                                for (long lLp2 = 0; lLp2 < m_csInFileInfo.m_lDim2; lLp2++)
                                {   // 配列２
                                    dReadData = csReadData[lLp2].GetData();
                                    for (long lLp1 = 0; lLp1 < m_csInFileInfo.m_lDim1; lLp1++)
                                    {   // 配列１
                                        csSndCellData[lLp1, lLp2, lLp3].m_dData[0] = dReadData[lLp1];
                                    }
                                }
                            }

                            csOutputCellData[lP].SendData();
                        }   // end of for(送信接続数）
                        m_csInFileInfo.m_csLastDataSendTime.SetTime(m_csInFileInfo.m_csNext3DSndRcrd.GetTime()); // 送信時刻の設定
                        m_csInFileInfo.m_lSndRcrdNum += 1;
                    }
                }
                else
                {
                    // 今回は送信しない
                    break;
                }
            }

            return lRtn;
        }

        //====================
        // その他必要なメソッド
        //====================

        // Ver1.5 追加（ファイルの有無チェック）引数追加
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetProperty(csCellMdlPropertyInfo, ref csErrorInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <param name="csErrorInfo">エラー情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo, ref McStructErrorInfo csErrorInfo)
        {
            bool bRtn = true;   // Ver1.5 追加（ファイルの有無チェック）

            // 使用しやすいようにキャストしておく
            m_csInFileInfo = (McCSVFileInInfo)m_csCalInfo;

            McModelPropertyInfo csPropInf = csCellMdlPropertyInfo as McModelPropertyInfo;
            if (csPropInf != null)
            {
                csPropInf.GetInfo(new HySString("m_csInFileNameWithPath"), ref m_csInFileInfo.m_sInPutFile);  // パスは既に画面にて相対パス化されている
              //m_csInFileNameWithFullPath = this.GetDataHomeDirectory() + "\\" + new HySString(m_csInFileInfo.m_sInPutFile);
                m_csInFileNameWithFullPath = this.GetDataHomeDirectory() + "\\" + this.GetProjectGroupName() + "\\" + new HySString(m_csInFileInfo.m_sInPutFile);
                csPropInf.GetInfo("m_lDataDim", ref this.m_csInFileInfo.m_lDataDim);
                csPropInf.GetInfo("m_lDim1", ref this.m_csInFileInfo.m_lDim1);
                csPropInf.GetInfo("m_lDim2", ref this.m_csInFileInfo.m_lDim2);
                csPropInf.GetInfo("m_lDim3", ref this.m_csInFileInfo.m_lDim3);
            }
            else
            {
              //m_csInFileNameWithFullPath = this.GetDataHomeDirectory() + new HySString("\\dmy.csv");
                m_csInFileNameWithFullPath = this.GetDataHomeDirectory() + "\\" + this.GetProjectGroupName() + "\\" + new HySString("dmy.csv");
                m_csInFileInfo.m_sInPutFile = "dmy.csv";
                m_csInFileInfo.m_lDataDim = 1;
                m_csInFileInfo.m_lDim1 = 1;
                m_csInFileInfo.m_lDim2 = 1;
                m_csInFileInfo.m_lDim3 = 1;
            }

            // Ver1.5 追加（ファイルの有無チェック）
            HySFile csFile = new HySFile(m_csInFileNameWithFullPath);
            if (csFile.Exist() != true)
            {
               // ver1.5 エラートレース日本語対応
                csErrorInfo.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
                     Properties.HymcoStandardModelPrjResources.STATEMENT_FILE_NO_OR_INVALID + m_csInFileNameWithFullPath.ToString());
               // csErrorInfo.AddCheckErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_IN_KIND,
               //      "入力ファイルが未設定です。または不正なファイルです。" + m_csInFileNameWithFullPath.ToString());
                bRtn = false;
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">プロパティ情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        public override bool SetOnlineProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            // Do Nothing
            return true;
        }

        // Ver1.5 追加（プロジェクトプロパティ画面）
        /// <summary><para>method outline:</para>
        /// <para>モデルが読み込むデータファイル名を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>List csRtnList = GetReadFiles()</para>
        /// </example>
        /// <param name="">なし</param>
        /// <returns> データファイル名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override List<string> GetReadFiles()
        {
            List<string> csRtnList = new List<string>();
            csRtnList.Add(System.IO.Path.GetFileName(m_csInFileNameWithFullPath.ToString()));
            return csRtnList;
        }
    }
}
