﻿// <summary>ソースコード：ＨＹＭＣＯ標準要素モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＣＳＶファイル入力データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McCSVFileInInfo : McCalInfo
    {
        /// <summary> 出力数 </summary>
        public long m_lOutPutPortNum = 0;

        /// <summary> 最後にデータを出力した演算時刻 </summary>
        public HySTime m_csLastDataSendTime = null;
        /// <summary>送信したレコード数</summary>
        public long m_lSndRcrdNum = 0;

        // ０Ｄ＿CSV
        //// <summary> 読み出したデータ保管場所 </summary>
        //public HySCSVFileData m_csRead0DCSVData = null;

        // １Ｄ_CSV
        /// <summary> 読み出したデータ保管場所 </summary>
        public HySCSVFileDim1Data m_csRead1DCSVData = null;
        /// <summary>次に送信するデータ １次元 </summary>
        public HySCSVFileDim1Data.CSVDim1Recorde m_csNext1DSndRcrd = null;

        // ２Ｄ_CSV
        /// <summary> 読み出したデータ保管場所 </summary>
        public HySCSVFileDim2Data m_csRead2DCSVData = null;
        /// <summary>次に送信するデータ ２次元 </summary>
        public HySCSVFileDim2Data.CSVDim2Recorde m_csNext2DSndRcrd = null;

        // ３Ｄ_CSV
        /// <summary> 読み出したデータ保管場所 </summary>
        public HySCSVFileDim3Data m_csRead3DCSVData = null;
        /// <summary>次に送信するデータ ３次元 </summary>
        public HySCSVFileDim3Data.CSVDim3Recorde m_csNext3DSndRcrd = null;


        /// <summary> 読み出したレコードの数 </summary>
        public long m_lRecNum = 0;

        /// <summary>データの次元数</summary>
        public long m_lDataDim = 1;
        /// <summary>１レコードのデータ配列１</summary>
        public long m_lDim1 = 1;
        /// <summary>１レコードのデータ配列２</summary>
        public long m_lDim2 = 1;
        /// <summary>１レコードのデータ配列２</summary>
        public long m_lDim3 = 1;

        /// <summary> 入力ファイル </summary>
        public string m_sInPutFile;


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McCSVFileInInfo csRtn = new McCSVFileInInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McCSVFileInInfo csOrgDt = (McCSVFileInInfo)csOrgInfo;

            this.m_lOutPutPortNum = csOrgDt.m_lOutPutPortNum;
            this.m_csLastDataSendTime = csOrgDt.m_csLastDataSendTime.Clone();
            this.m_lSndRcrdNum = csOrgDt.m_lSndRcrdNum;

            // １次元
            if (csOrgDt.m_csNext1DSndRcrd != null)
            {
                this.m_csNext1DSndRcrd = HySDataDuplicate.DupliCateData(csOrgDt.m_csNext1DSndRcrd) as HySCSVFileDim1Data.CSVDim1Recorde;
            }
            if (csOrgDt.m_csRead1DCSVData != null)
            {
                this.m_csRead1DCSVData = HySDataDuplicate.DupliCateData(csOrgDt.m_csRead1DCSVData) as HySCSVFileDim1Data;
            }
            // ２次元
            if (csOrgDt.m_csNext2DSndRcrd != null)
            {
                this.m_csNext2DSndRcrd = HySDataDuplicate.DupliCateData(csOrgDt.m_csNext2DSndRcrd) as HySCSVFileDim2Data.CSVDim2Recorde;
            }
            if (csOrgDt.m_csRead2DCSVData != null)
            {
                this.m_csRead2DCSVData = HySDataDuplicate.DupliCateData(csOrgDt.m_csRead2DCSVData) as HySCSVFileDim2Data;
            }
            // ３次元
            if (csOrgDt.m_csNext3DSndRcrd != null)
            {
                this.m_csNext3DSndRcrd = HySDataDuplicate.DupliCateData(csOrgDt.m_csNext3DSndRcrd) as HySCSVFileDim3Data.CSVDim3Recorde;
            }
            if (csOrgDt.m_csRead3DCSVData != null)
            {
                this.m_csRead3DCSVData = HySDataDuplicate.DupliCateData(csOrgDt.m_csRead3DCSVData) as HySCSVFileDim3Data;
            }

            this.m_lRecNum = csOrgDt.m_lRecNum;

            this.m_lDataDim = csOrgDt.m_lDataDim;
            this.m_lDim1 = csOrgDt.m_lDim1;
            this.m_lDim2 = csOrgDt.m_lDim2;
            this.m_lDim3 = csOrgDt.m_lDim3;


            this.m_sInPutFile = csOrgDt.m_sInPutFile;

            return true;
        }

    }
}
