﻿// <summary>ソースコード：ＨＹＭＣＯ標準要素モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＣＳＶファイル出力データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McCSVFileOutInfo : McCalInfo
    {
        /// <summary> 最終入力時刻 </summary>
        public HySTime m_csLastINTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> 最終出力時刻 </summary>
        public HySTime m_csLastOutTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> データ一時保管 </summary>
        public LinkedList<McOutRecordBase> m_csDataList = new LinkedList<McOutRecordBase>();

        /// <summary>データ次元数 </summary>
        public long m_lDimNum = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDim1 = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDim2 = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDim3 = 0;
        
        /// <summary> ファイル出力時間間隔 </summary>
        public HySTime m_csOutTimeLag = new HySTime(2, 0, 0);
        /// <summary> ファイル出力するデータのセル内インデックス（０相対） </summary>
        
        public long m_lOutDataIdx = 0; // <-- ０固定

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCalInfo csRtn = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McCSVFileOutInfo csRtn = new McCSVFileOutInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McCSVFileOutInfo csOrgDt = (McCSVFileOutInfo)csOrgInfo;

            this.m_csLastINTime = csOrgDt.m_csLastINTime.Clone();
            this.m_csLastOutTime = csOrgDt.m_csLastOutTime.Clone();
            
            this.m_csDataList.Clear();
            int iDtNum = csOrgDt.m_csDataList.Count;
            LinkedListNode<McOutRecordBase> csNd = null;
            McOutRecordBase csDt = null;
            csNd = csOrgDt.m_csDataList.First;
            for (int iP = 0; iP < iDtNum; iP++)
            {
                csDt = csNd.Value;
                this.m_csDataList.AddLast(csDt.Clone());
                csNd = csNd.Next;
            }

            this.m_lDimNum = csOrgDt.m_lDimNum;
            this.m_lDtDim1 = csOrgDt.m_lDtDim1;
            this.m_lDtDim2 = csOrgDt.m_lDtDim2;
            this.m_lDtDim3 = csOrgDt.m_lDtDim3;
            this.m_csOutTimeLag = csOrgDt.m_csOutTimeLag.Clone();
            this.m_lOutDataIdx = csOrgDt.m_lOutDataIdx;

            this.m_lOverWriteSW = csOrgDt.m_lOverWriteSW;
            this.m_sOverWriteFileNameWithPath = csOrgDt.m_sOverWriteFileNameWithPath;
            this.m_sOutFileName = csOrgDt.m_sOutFileName;
            this.m_sOutDirPath = csOrgDt.m_sOutDirPath;

            return true;
        }

        /// <summary>上書き／別名ファイル選択</summary>
        public long m_lOverWriteSW = 1;
        /// <summary>上書きファイル名</summary>
        public string m_sOverWriteFileNameWithPath = ".\\OutputFile.csv";
        /// <summary>書き出しディレクトリ(別名ファイル選択の時有効)</summary>
        public string m_sOutFileName = "OutputFile.csv";
        /// <summary>書き出しファイル名</summary>
        public string m_sOutDirPath = ".\\";
    }

    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McOutRecordBase : HySDataRoot
    {
        /// <summary> 最終出力時刻 </summary>
        public HySTime m_csTime = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutRecordBase csRd = McOutRecordBase( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McOutRecordBase()
        {
            m_csTime = HySTime.DEFAULT_TIME.Clone();
        }

        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutRecordBase csRd = McOutRecordBase( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McOutRecordBase(McOutRecordBase csOrg)
        {
            m_csTime = csOrg.m_csTime.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutRecordBase csRd = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        virtual public McOutRecordBase Clone()
        {
            return new McOutRecordBase(this);
        }
    }

    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McOutD1Record : McOutRecordBase
    {
        /// <summary> データ一時保管 </summary>
        public double[] m_dDT=null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutD1Record csRd = McOutD1Record( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McOutD1Record()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutD1Record csRd = new McOutD1Record( lDim ) </para>
        /// </example>
        /// <param name="lDim">１レコードのデータ数</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McOutD1Record(long lDim)
        {
            m_dDT = new double[lDim];
        }

        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutD1Record csRd = new McOutD1Record( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McOutD1Record(McOutD1Record csOrg)
        {
            m_csTime = csOrg.m_csTime.Clone();
            m_dDT = new double[csOrg.m_dDT.Length];
            for (long lP = 0; lP < csOrg.m_dDT.Length; lP++)
            {
                m_dDT[lP] = csOrg.m_dDT[lP];
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutRecordBase csRd = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        override public McOutRecordBase Clone()
        {
            return new McOutD1Record(this);
        }
    }

    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McOutD2Record : McOutRecordBase
    {
        /// <summary> データ一時保管 </summary>
        public double[,] m_dD2DT;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutD2Record csRd = McOutD2Record( lDim1,lDim2 ) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McOutD2Record(long lDim1, long lDim2)
        {
            m_dD2DT = new double[lDim1,lDim2];
        }
        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutD2Record csRd = McOutD2Record( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McOutD2Record(McOutD2Record csOrg)
        {
            m_csTime = csOrg.m_csTime.Clone();

            long lDim1=csOrg.m_dD2DT.GetLength(0);
            long lDim2=csOrg.m_dD2DT.GetLength(1);
            m_dD2DT = new double[lDim1, lDim2];

            for (int iLp1 = 0; iLp1 < lDim1; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < lDim2; iLp2++)
                {
                    m_dD2DT[iLp1, iLp2] = csOrg.m_dD2DT[iLp1, iLp2];
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutRecordBase csRd = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        override public McOutRecordBase Clone()
        {
            return new McOutD2Record(this);
        }
    }

    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McOutD3Record : McOutRecordBase
    {
        /// <summary> データ一時保管 </summary>
        public double[,,] m_dD3DT;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutD3Record csRd = McOutD3Record( lDim1,lDim2,lDim3 ) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <param name="lDim3">第３配列数</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McOutD3Record(long lDim1, long lDim2, long lDim3)
        {
            m_dD3DT = new double[lDim1, lDim2, lDim3];
        }
        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutD3Record csRd = McOutD3Record( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McOutD3Record(McOutD3Record csOrg)
        {
            m_csTime = csOrg.m_csTime.Clone();

            long lDim1 = csOrg.m_dD3DT.GetLength(0);
            long lDim2 = csOrg.m_dD3DT.GetLength(1);
            long lDim3 = csOrg.m_dD3DT.GetLength(2);
            m_dD3DT = new double[lDim1, lDim2, lDim3];

            for (int iLp1 = 0; iLp1 < lDim1; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < lDim2; iLp2++)
                {
                    for (int iLp3 = 0; iLp3 < lDim3; iLp3++)
                    {
                        m_dD3DT[iLp1, iLp2,iLp3] = csOrg.m_dD3DT[iLp1, iLp2,iLp3];
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McOutRecordBase csRd = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        override public McOutRecordBase Clone()
        {
            return new McOutD3Record(this);
        }
    }
}
