﻿// <summary>ソースコード：ＨＹＭＣＯ標準要素モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>マージ出力要素モデルデータクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.4.0][2013/12/10][新規作成]</para>
    /// <para>remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McCSVFileOutMergeMdlInfo : McCalInfo
    {
        ///// <summary> 最終入力時刻 </summary>
        //public HySTime m_csLastINTime = HySTime.DEFAULT_TIME.Clone();
        ///// <summary> 最終出力時刻 </summary>
        //public HySTime m_csLastOutTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> データ一時保管（出力レコードの時系列管理） </summary>
        public LinkedList<McMergeOutRecordBase> m_csDataList = new LinkedList<McMergeOutRecordBase>();

        /// <summary>データ次元数 </summary>
        public long m_lDimNum = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDim1 = 0;
        
        /// <summary> ファイル出力時間間隔 </summary>
        public HySTime m_csOutTimeLag = new HySTime(2, 0, 0);
        /// <summary> ファイル出力するデータのセル内インデックス（０相対） </summary>
        
        public long m_lOutDataIdx = 0; // <-- ０固定

        /// <summary>CSV出力順序リスト</summary>
        public List<string> m_csCSVExportOrderList = new List<string>();

        /// <summary> 複数入力管理ハッシュ（key:要素ID、Val:出力レコードの時系列管理） </summary>
        public Hashtable m_csDataListTbl = new Hashtable();

        /// <summary> 入力データ種別管理ハッシュ（key:要素ID、Val:データ種別文字列） </summary>
        public Hashtable m_csDataKindTbl = new Hashtable();

        /// <summary> 最終入力時刻管理ハッシュ（key:要素ID、Val:最終入力時刻） </summary>
        public Hashtable m_csLastINTimeTbl = new Hashtable();

        /// <summary> 最終出力時刻管理ハッシュ（key:要素ID、Val:最終出力時刻） </summary>
        public Hashtable m_csLastOutTimeTbl = new Hashtable();

        /// <summary>入力時刻管理リスト</summary>
        public List<HySTime> m_csINTimeList = new List<HySTime>();

        /// <summary>入力時刻管理リスト重複追加防止フラグ</summary>
        public bool m_bListAddFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCalInfo csRtn = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McCSVFileOutMergeMdlInfo csRtn = new McCSVFileOutMergeMdlInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McCSVFileOutMergeMdlInfo csOrgDt = (McCSVFileOutMergeMdlInfo)csOrgInfo;

            //this.m_csLastINTime = csOrgDt.m_csLastINTime.Clone();
            //this.m_csLastOutTime = csOrgDt.m_csLastOutTime.Clone();
            
            this.m_csDataList.Clear();
            this.m_csCSVExportOrderList.Clear();
            this.m_csINTimeList.Clear();
            int iDtNum = csOrgDt.m_csDataList.Count;
            int iCSVListNum = csOrgDt.m_csCSVExportOrderList.Count;
            int iInTimeListNum = csOrgDt.m_csINTimeList.Count;
            LinkedListNode<McMergeOutRecordBase> csNd = null;
            McMergeOutRecordBase csDt = null;
            csNd = csOrgDt.m_csDataList.First;
            for (int iP = 0; iP < iDtNum; iP++)
            {
                csDt = csNd.Value;
                this.m_csDataList.AddLast(csDt.Clone());
                csNd = csNd.Next;
            }
            for (int iP = 0; iP < iCSVListNum; iP++)
            {
                this.m_csCSVExportOrderList.Add((string)csOrgDt.m_csCSVExportOrderList[iP].Clone());
            }
            for (int iP = 0; iP < iInTimeListNum; iP++)
            {
                this.m_csINTimeList.Add((HySTime)csOrgDt.m_csINTimeList[iP].Clone());
            }

            this.m_lDimNum = csOrgDt.m_lDimNum;
            this.m_lDtDim1 = csOrgDt.m_lDtDim1;
            this.m_csOutTimeLag = csOrgDt.m_csOutTimeLag.Clone();
            this.m_lOutDataIdx = csOrgDt.m_lOutDataIdx;

            this.m_lOverWriteSW = csOrgDt.m_lOverWriteSW;
            this.m_sOverWriteFileNameWithPath = csOrgDt.m_sOverWriteFileNameWithPath;
            this.m_sOutFileName = csOrgDt.m_sOutFileName;
            this.m_sOutDirPath = csOrgDt.m_sOutDirPath;
            this.m_csDataListTbl = (Hashtable)csOrgDt.m_csDataListTbl.Clone();
            this.m_csDataKindTbl = (Hashtable)csOrgDt.m_csDataKindTbl.Clone();
            this.m_csLastINTimeTbl = (Hashtable)csOrgDt.m_csLastINTimeTbl.Clone();
            this.m_csLastOutTimeTbl = (Hashtable)csOrgDt.m_csLastOutTimeTbl.Clone();
            this.m_bListAddFlg = csOrgDt.m_bListAddFlg;

            return true;
        }

        /// <summary>上書き／別名ファイル選択</summary>
        public long m_lOverWriteSW = 1;
        /// <summary>上書きファイル名</summary>
        public string m_sOverWriteFileNameWithPath = ".\\OutputFile.csv";
        /// <summary>書き出しディレクトリ(別名ファイル選択の時有効)</summary>
        public string m_sOutFileName = "OutputFile.csv";
        /// <summary>書き出しファイル名</summary>
        public string m_sOutDirPath = ".\\";
    }

    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McMergeOutRecordBase : HySDataRoot
    {
        /// <summary> 最終出力時刻 </summary>
        public HySTime m_csTime = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMergeOutRecordBase csRd = McMergeOutRecordBase( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McMergeOutRecordBase()
        {
            m_csTime = HySTime.DEFAULT_TIME.Clone();
        }

        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMergeOutRecordBase csRd = McMergeOutRecordBase( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMergeOutRecordBase(McMergeOutRecordBase csOrg)
        {
            m_csTime = csOrg.m_csTime.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMergeOutRecordBase csRd = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        virtual public McMergeOutRecordBase Clone()
        {
            return new McMergeOutRecordBase(this);
        }
    }

    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.4.0][2013/12/10][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McMergeOutD1Record : McMergeOutRecordBase
    {
        /// <summary> データ一時保管 </summary>
        public double[] m_dDT=null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMergeOutD1Record csRd = McMergeOutD1Record( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McMergeOutD1Record()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMergeOutD1Record csRd = new McMergeOutD1Record( lDim ) </para>
        /// </example>
        /// <param name="lDim">１レコードのデータ数</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMergeOutD1Record(long lDim)
        {
            m_dDT = new double[lDim];
        }

        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMergeOutD1Record csRd = new McMergeOutD1Record( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMergeOutD1Record(McMergeOutD1Record csOrg)
        {
            m_csTime = csOrg.m_csTime.Clone();
            m_dDT = new double[csOrg.m_dDT.Length];
            for (long lP = 0; lP < csOrg.m_dDT.Length; lP++)
            {
                m_dDT[lP] = csOrg.m_dDT[lP];
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMergeOutRecordBase csRd = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        override public McMergeOutRecordBase Clone()
        {
            return new McMergeOutD1Record(this);
        }
    }  
    
}
