﻿// <summary>ソースコード：ＨＹＭＣＯ標準要素モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳファイル出力データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス
    /// 本クラスは将来拡張用（Ver1.1.0 ではリリースしない）
    /// </para>
    /// </remarks>
    [Serializable]
    public class McGISFileOutCell1ValInfo : McCalInfo
    {
        /// <summary> 最終入力時刻 </summary>
        public HySTime m_csLastINTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> 最終出力時刻 </summary>
        public HySTime m_csLastOutTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> データ一時保管 </summary>
        public LinkedList<McOutRecordBase> m_csDataList = new LinkedList<McOutRecordBase>();

        /// <summary>データ次元数 </summary>
        public long m_lDimNum = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDimLon = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDimLat = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDimAlt = 0;
        
        /// <summary> ファイル出力時間間隔 </summary>
        public HySTime m_csOutTimeLag = new HySTime(2, 0, 0);
 
        /// <summary> ファイル出力するデータのセル内インデックス（０相対） </summary>
        public long m_lOutDataIdx = 0; // <-- ０固定
        /// <summary> データのセル内インデックスの数 </summary>
        public long m_lCellCharaIdxNum = 0;
        /// <summary>出力されるセルの情報 </summary>
        public HySDataCharacteristicInCell m_csCellCharactor = null; //new HySDataCharacteristicInCell(1);
        /// <summary>ファイルに出力するデータ （２次元）</summary>
        public HySGeoDim2MeshSerialData m_csFileOutGIS2DData = null;
        /// <summary>ファイルに出力するデータ （３次元）</summary>
        public HySGeoDim3MeshSerialData m_csFileOutGIS3DData = null;

        /// <summary>上書き／別名ファイル選択</summary>
        public long m_lOverWriteSW = 1;
        /// <summary>上書きファイル名</summary>
        public string m_sOverWriteFileNameWithPath = ".\\OutputFile.d2gis";
        /// <summary>書き出しディレクトリ(別名ファイル選択の時有効)</summary>
        public string m_sOutFileName = "OutputFile.d2gis";
        /// <summary>書き出しファイル名</summary>
        public string m_sOutDirPath = ".\\";

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csRtn = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McGISFileOutCell1ValInfo csRtn = new McGISFileOutCell1ValInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McGISFileOutCell1ValInfo csOrgDt = (McGISFileOutCell1ValInfo)csOrgInfo;

            m_csLastINTime = csOrgDt.m_csLastINTime.Clone();
            m_csLastOutTime = csOrgDt.m_csLastOutTime.Clone();
            m_csDataList.Clear();
            int iNum = csOrgDt.m_csDataList.Count;
            McOutRecordBase csRcd = null;
            LinkedListNode<McOutRecordBase> csNode=null;
            csNode = csOrgDt.m_csDataList.First;
            for (int iLp = 0; iLp < iNum; iLp++)
            {
                if (csNode == null)
                {
                    break;
                }
                csRcd = csNode.Value;
                m_csDataList.AddLast(csRcd.Clone());
                csNode = csNode.Next;
            }
            m_lDimNum = csOrgDt.m_lDimNum;
            m_lDtDimLon = csOrgDt.m_lDtDimLon;
            m_lDtDimLat = csOrgDt.m_lDtDimLat;
            m_lDtDimAlt = csOrgDt.m_lDtDimAlt;
            m_csOutTimeLag = csOrgDt.m_csOutTimeLag.Clone();
            m_lOutDataIdx = csOrgDt.m_lOutDataIdx;
            m_lCellCharaIdxNum = csOrgDt.m_lCellCharaIdxNum;
            if (csOrgDt.m_csCellCharactor != null)
            {
                m_csCellCharactor = csOrgDt.m_csCellCharactor.Clone();
            }
            else
            {
                m_csCellCharactor = null;
            }
            if (csOrgDt.m_csFileOutGIS2DData != null)
            {
                m_csFileOutGIS2DData = new HySGeoDim2MeshSerialData(csOrgDt.m_csFileOutGIS2DData);
            }
            else
            {
                m_csFileOutGIS2DData = null;
            }
            if (csOrgDt.m_csFileOutGIS3DData != null)
            {
                m_csFileOutGIS3DData = new HySGeoDim3MeshSerialData(csOrgDt.m_csFileOutGIS3DData);
            }
            else
            {
                m_csFileOutGIS3DData = null;
            }
            m_lOverWriteSW = csOrgDt.m_lOverWriteSW;
            m_sOverWriteFileNameWithPath = csOrgDt.m_sOverWriteFileNameWithPath;
            m_sOutFileName = csOrgDt.m_sOutFileName;
            m_sOutDirPath = csOrgDt.m_sOutDirPath;

            return true;
        }

        /*
        /// <summary><para>class outline:</para>
        /// <para>テスト用ＣＳＶファイル出力用レコード</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// <para>remarks</para>
        /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
        /// </remarks>
        [Serializable]
        public class McGISOutRecordBase : HySDataRoot
        {
            /// <summary> 最終出力時刻 </summary>
            public HySTime m_csTime = null;


            /// <summary><para>method outline:</para>
            /// <para>デフォルトコンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutRecordBase csRd = McOutRecordBase( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            protected McGISOutRecordBase()
            {
                m_csTime = HySTime.DEFAULT_TIME.Clone();
            }

            /// <summary><para>method outline:</para>
            /// <para>コピーコンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutRecordBase csRd = McOutRecordBase( csOrg ) </para>
            /// </example>
            /// <param name="csOrg">元データ</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McGISOutRecordBase(McGISOutRecordBase csOrg)
            {
                m_csTime = csOrg.m_csTime.Clone();
            }
            /// <summary><para>method outline:</para>
            /// <para>自己複製</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> Clone( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>同一内容で　別インスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
            /// </remarks>
            virtual public McGISOutRecordBase Clone()
            {
                return new McGISOutRecordBase(this);
            }
        }

        /// <summary><para>class outline:</para>
        /// <para>テスト用ＣＳＶファイル出力用レコード</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// <para>remarks</para>
        /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
        /// </remarks>
        [Serializable]
        public class McGISOutD1Record : McGISOutRecordBase
        {
            /// <summary> データ一時保管 </summary>
            public HySCellData[] m_dDT = null;

            /// <summary><para>method outline:</para>
            /// <para>デフォルトコンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutRecordBase csRd = McOutRecordBase( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            protected McGISOutD1Record()
            {
            }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutRecordBase csRd = new McOutRecordBase( lDim ) </para>
            /// </example>
            /// <param name="lDim">１レコードのデータ数</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McGISOutD1Record(long lDim)
            {
                m_dDT = new HySCellData[lDim];
            }

            /// <summary><para>method outline:</para>
            /// <para>コピーコンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutRecordBase csRd = new McOutD1Record( csOrg ) </para>
            /// </example>
            /// <param name="csOrg">元データ</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McGISOutD1Record(McGISOutD1Record csOrg)
            {
                m_csTime = csOrg.m_csTime.Clone();
                m_dDT = new HySCellData[csOrg.m_dDT.Length];
                for (long lP = 0; lP < csOrg.m_dDT.Length; lP++)
                {
                    m_dDT[lP] = csOrg.m_dDT[lP].Clone();
                }
            }
            /// <summary><para>method outline:</para>
            /// <para>自己複製</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> Clone( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>同一内容で　別インスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
            /// </remarks>
            override public McGISOutRecordBase Clone()
            {
                return new McGISOutD1Record(this);
            }
        }

        /// <summary><para>class outline:</para>
        /// <para>テスト用ＣＳＶファイル出力用レコード</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// <para>remarks</para>
        /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
        /// </remarks>
        [Serializable]
        public class McGISOutD2Record : McGISOutRecordBase
        {
            /// <summary> データ一時保管 </summary>
            public HySCellData[,] m_dD2DT;

            /// <summary><para>method outline:</para>
            /// <para>コンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutD2Record csRd = McOutD2Record( lDim1,lDim2 ) </para>
            /// </example>
            /// <param name="lDim1">第１配列数</param>
            /// <param name="lDim2">第２配列数</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McGISOutD2Record(long lDim1, long lDim2)
            {
                m_dD2DT = new HySCellData[lDim1, lDim2];
            }
            /// <summary><para>method outline:</para>
            /// <para>コピーコンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutRecordBase csRd = McOutRecordBase( csOrg ) </para>
            /// </example>
            /// <param name="csOrg">元データ</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McGISOutD2Record(McGISOutD2Record csOrg)
            {
                m_csTime = csOrg.m_csTime.Clone();

                long lDim1 = csOrg.m_dD2DT.GetLength(0);
                long lDim2 = csOrg.m_dD2DT.GetLength(1);

                for (int iLp1 = 0; iLp1 < lDim1; iLp1++)
                {
                    for (int iLp2 = 0; iLp2 < lDim2; iLp2++)
                    {
                        m_dD2DT[iLp1, iLp2] = csOrg.m_dD2DT[iLp1, iLp2].Clone();
                    }
                }
            }
            /// <summary><para>method outline:</para>
            /// <para>自己複製</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> Clone( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>同一内容で　別インスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
            /// </remarks>
            override public McGISOutRecordBase Clone()
            {
                return new McGISOutD2Record(this);
            }
        }

        /// <summary><para>class outline:</para>
        /// <para>テスト用ＣＳＶファイル出力用レコード</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// <para>remarks</para>
        /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
        /// </remarks>
        [Serializable]
        public class McGISOutD3Record : McGISOutRecordBase
        {
            /// <summary> データ一時保管 </summary>
            public HySCellData[, ,] m_dD3DT;

            /// <summary><para>method outline:</para>
            /// <para>コンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutD3Record csRd = McOutD3Record( lDim1,lDim2,lDim3 ) </para>
            /// </example>
            /// <param name="lDim1">第１配列数</param>
            /// <param name="lDim2">第２配列数</param>
            /// <param name="lDim3">第３配列数</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McGISOutD3Record(long lDim1, long lDim2, long lDim3)
            {
                m_dD3DT = new HySCellData[lDim1, lDim2, lDim3];
            }
            /// <summary><para>method outline:</para>
            /// <para>コピーコンストラクター</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McOutRecordBase csRd = McOutRecordBase( csOrg ) </para>
            /// </example>
            /// <param name="csOrg">元データ</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McGISOutD3Record(McGISOutD3Record csOrg)
            {
                m_csTime = csOrg.m_csTime.Clone();

                long lDim1 = csOrg.m_dD3DT.GetLength(0);
                long lDim2 = csOrg.m_dD3DT.GetLength(1);
                long lDim3 = csOrg.m_dD3DT.GetLength(2);

                for (int iLp1 = 0; iLp1 < lDim1; iLp1++)
                {
                    for (int iLp2 = 0; iLp2 < lDim2; iLp2++)
                    {
                        for (int iLp3 = 0; iLp3 < lDim3; iLp3++)
                        {
                            m_dD3DT[iLp1, iLp2, iLp3] = csOrg.m_dD3DT[iLp1, iLp2, iLp3].Clone();
                        }
                    }
                }
            }
            /// <summary><para>method outline:</para>
            /// <para>自己複製</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> Clone( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>同一内容で　別インスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
            /// </remarks>
            override public McGISOutRecordBase Clone()
            {
                return new McGISOutD3Record(this);
            }
        }
        */
    }

}
