﻿// <summary>ソースコード：ＨＹＭＣＯ標準要素モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Model;




namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳファイル出力(セル内１変数のみ選択して出力する)</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>
    /// 受信したＧＩＳ情報を、ＧＩＳメッシュ形式のファイルに出力する
    /// 但し、１変数のみ
    /// 本クラスは将来拡張用（Ver1.1.0 ではリリースしない）
    /// </para>
    /// </remarks>
    public class McGISFileOutCell1ValMdl : McBasicFileOutCtl
    {
        /// <summary> 内部変数 </summary>
        McGISFileOutCell1ValInfo m_csOutFileInfo = null;

        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf, lInputDataNum, csInputCellData)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = true;

            // 入力端子数のチェック
            if (lInputDataNum == 0)
            {
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND, 
                    Properties.HymcoStandardModelPrjResources.STATEMENT_NO_REC_PORT );
               // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND, "No Receive Port");
                bRtn = false;
            }
            else if (lInputDataNum > 1)
            {
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND, 
                    Properties.HymcoStandardModelPrjResources.STATEMENT_MULTI_REC_PORT );
               // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND, "Too many Receive Ports. (Not support multi-Receive Ports)");
                bRtn = false;
            }
            else if (lInputDataNum == 1)
            {
                McTimeSeriesGeoD2MeshTranInfo csCellD2Trn = null;
                McTimeSeriesGeoD3MeshTranInfo csCellD3Trn = null;

                csCellD2Trn = csInputCellData[0].GetTranInfo() as McTimeSeriesGeoD2MeshTranInfo;
                csCellD3Trn = csInputCellData[0].GetTranInfo() as McTimeSeriesGeoD3MeshTranInfo;

                if (csCellD2Trn != null)
                {   // セル２次元配列情報ならば
                    // Do Nothing
                }
                else if (csCellD3Trn != null)
                {   // セル３次元配列情報ならば
                    // Do Nothing
                }
                else
                {
                    bRtn = false;
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND
                        , Properties.HymcoStandardModelPrjResources.STATEMENT_UNEXPECT_REC_DATA_TYPE + m_csInputData[0].GetUpperElementID().ToString() + ")");
                   // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND
                   //     , "Unexpected receive data type. (Received from " + m_csInputData[0].GetUpperElementID().ToString() + ")");
                }
            }

            // 上書きファイル設定
            m_csOutFileNameWithFullPath = new HySString(this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" + m_csOutFileInfo.m_sOverWriteFileNameWithPath);

            if (m_csOutFileInfo.m_lOverWriteSW == 1)
            {   // 上書きの場合
                // 出力ファイル設定
                m_csOutFile = new HySFile(m_csOutFileNameWithFullPath.ToString());
                // 出力ファイル初期生成
                if (m_csOutFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) < 0)
                {
                    bRtn = false;
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND
                        , Properties.HymcoStandardModelPrjResources.STATEMENT_NO_CREATE_GIF );
                   // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND
                   //     , "Cannot Create GIS File.");
                }
                m_csOutFile.Close();
            }

            return bRtn;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = Initialize(csInitialData, lInputDataNum, ref csInputCellData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = true;

            // 初期化情報
            McInitialInfo csRtnDt = csInitialData as McInitialInfo;
            if (csRtnDt != null)
            {   // 初期化情報あり
                // 出力時間間隔を取得
                //double dDt = 0.0;
                //csRtnDt.GetInfo("OUTTIME_LAG", ref dDt);
                //m_csOutFileInfo.m_csOutTimeLag = new HySTime(dDt * 1.0);
            }

            // 情報の初期化
            m_csOutFileInfo.m_csLastINTime = HySTime.DEFAULT_TIME.Clone();
            m_csOutFileInfo.m_csLastOutTime = HySTime.DEFAULT_TIME.Clone();

            McTimeSeriesGeoD2MeshTranInfo csCellD2Trn = null;
            McTimeSeriesGeoD3MeshTranInfo csCellD3Trn = null;

            //McTimeSeriesD3CellArrayTranInfo csCellD3Trn = null;
            //McTimeSeriesD2CellArrayTranInfo csCellD2Trn = null;

            csCellD2Trn = csInputCellData[0].GetTranInfo() as McTimeSeriesGeoD2MeshTranInfo;
            csCellD3Trn = csInputCellData[0].GetTranInfo() as McTimeSeriesGeoD3MeshTranInfo;

            if (csCellD2Trn != null)
            {   // セル２次元配列情報ならば

                m_csOutFileInfo.m_lDimNum = 2;
                m_csOutFileInfo.m_lDtDimLon = csCellD2Trn.GetLonDimension();
                m_csOutFileInfo.m_lDtDimLat = csCellD2Trn.GetLatDimension();
                // 配列数を保持しておく

                // 配線の繋ぎ替え表を取得
                //HySCellDataGetter csGetter = csInputCellData[0].GetCellDataGetter();
                //m_csOutFileInfo.m_lOutDataIdx = csGetter.GetIdx(0); // 自分が０番目で欲しいデータの対応Index番号を取得して保持

                // 出力データ形式生成
                //m_csOutFileInfo.m_csFileOutGIS2DData = new HySGeoDim2MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, 1);

                // セル内の情報を取得
                HySDataCharacteristicInCell csCellCharactor = csCellD2Trn.GetCellDataCharacteristic();
                m_csOutFileInfo.m_lCellCharaIdxNum = csCellCharactor.m_lDim;
                m_csOutFileInfo.m_csCellCharactor = new HySDataCharacteristicInCell(m_csOutFileInfo.m_lCellCharaIdxNum);
                for (int iLp = 0; iLp < m_csOutFileInfo.m_lCellCharaIdxNum; iLp++)
                {
                    m_csOutFileInfo.m_csCellCharactor.m_csDataKind[iLp] = csCellCharactor.m_csDataKind[iLp].Clone();
                    m_csOutFileInfo.m_csCellCharactor.m_csUnit[iLp] = csCellCharactor.m_csUnit[iLp];
                    m_csOutFileInfo.m_csCellCharactor.m_csLabel[iLp] = csCellCharactor.m_csLabel[iLp];
                }
                // 出力データ形式生成
                m_csOutFileInfo.m_csFileOutGIS2DData = new HySGeoDim2MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lCellCharaIdxNum);

                m_csOutFileInfo.m_csFileOutGIS2DData.SetCellDataCharacteristic(m_csOutFileInfo.m_csCellCharactor);

                //m_csOutFileInfo.m_csCellCharactor = new HySDataCharacteristicInCell(1);
                //m_csOutFileInfo.m_csCellCharactor.m_csDataKind[0] = csCellCharactor.m_csDataKind[m_csOutFileInfo.m_lOutDataIdx].Clone();
                //m_csOutFileInfo.m_csCellCharactor.m_csUnit[0] = csCellCharactor.m_csUnit[m_csOutFileInfo.m_lOutDataIdx];
                //m_csOutFileInfo.m_csCellCharactor.m_csLabel[0] = csCellCharactor.m_csLabel[m_csOutFileInfo.m_lOutDataIdx];
                //m_csOutFileInfo.m_csFileOutGIS2DData.SetCellDataCharacteristic(m_csOutFileInfo.m_csCellCharactor);

                // 位置を取得
                double dSWLat = 0.0D;
                double dSWLon = 0.0D;
                double dNELat = 0.0D;
                double dNELon = 0.0D;
                csCellD2Trn.GetLocation(ref dSWLat, ref dSWLon, ref dNELat, ref dNELon);
                m_csOutFileInfo.m_csFileOutGIS2DData.SetLocation(dSWLat, dSWLon, dNELat, dNELon);

                // 高度を取得
                double dUpAlt = 0.0D;
                double dLwAlt = 0.0D;
                csCellD2Trn.GetAltitude(ref dUpAlt, ref dLwAlt);
                m_csOutFileInfo.m_csFileOutGIS2DData.SetAltitude(dUpAlt, dLwAlt);
            }
            else if (csCellD3Trn != null)
            {   // セル３次元配列情報ならば
                /* ３次元は将来用 
                
                m_csOutFileInfo.m_lDimNum = 3;
                m_csOutFileInfo.m_lDtDimLon = csCellD3Trn.GetLonDimension();
                m_csOutFileInfo.m_lDtDimLat = csCellD3Trn.GetLatDimension();
                m_csOutFileInfo.m_lDtDimAlt = csCellD3Trn.GetAltDimension();
                // 配列数を保持しておく

                // 配線の繋ぎ替え表を取得
                HySCellDataGetter csGetter = csInputCellData[0].GetCellDataGetter();
                m_csOutFileInfo.m_lOutDataIdx = csGetter.GetIdx(0); // 自分が０番目で欲しいデータの対応Index番号を取得して保持

                m_csOutFileInfo.m_csFileOutGIS3DData = new HySGeoDim3MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lDtDimAlt, 1);
                m_csOutFileInfo.m_csCellCharactor = new HySDataCharacteristicInCell(1);
                HySDataCharacteristicInCell csCellCharactor = csCellD3Trn.GetCellDataCharacteristic();
                m_csOutFileInfo.m_csCellCharactor.m_csDataKind[0] = csCellCharactor.m_csDataKind[m_csOutFileInfo.m_lOutDataIdx].Clone();
                m_csOutFileInfo.m_csCellCharactor.m_csUnit[0] = csCellCharactor.m_csUnit[m_csOutFileInfo.m_lOutDataIdx];
                m_csOutFileInfo.m_csCellCharactor.m_csLabel[0] = csCellCharactor.m_csLabel[m_csOutFileInfo.m_lOutDataIdx];
                m_csOutFileInfo.m_csFileOutGIS3DData.SetCellDataCharacteristic(m_csOutFileInfo.m_csCellCharactor);
                /* */
            }
            else
            {
            }

            if (m_csOutFileInfo.m_lOverWriteSW != 1)
            {   // 上書きではない場合
                // 出力ファイル名称設定
                m_csOutFileNameWithFullPath = new HySString( ".\\" + m_csOutFileInfo.m_sOutFileName);
            }

            // 出力ファイル設定
            m_csOutFile = new HySFile(m_csOutFileNameWithFullPath.ToString());
            // 出力ファイル初期生成
            if (m_csOutFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
            {
                if (m_csOutFileInfo.m_csFileOutGIS2DData != null)
                {
                    // ヘッダー情報を書き出しておく
                    m_csOutFileInfo.m_csFileOutGIS2DData.CSVHeaderWrite(m_csOutFile);
                }
                if (m_csOutFileInfo.m_csFileOutGIS3DData != null)
                {   // ３次元対応は将来
                    //m_csOutFileInfo.m_csFileOutGIS2DData.CSVHeaderWrite(m_csOutFile);
                }
                m_csOutFile.Close();
            }
            else
            {
                bRtn = false;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadyCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算開始の　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool ReadyCalculation()
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算終了時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CompleteCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算終了時　最後の最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool CompleteCalculation()
        {
            bool bRtn = true;
            /*
            // 計算が終わったところで、蓄積された情報を一気にファイルに書き出す

            // 出力ファイル設定
            m_csOutFile = new HySFile(m_csOutFileNameWithFullPath.ToString());
            // 出力ファイル初期生成
            if (m_csOutFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
            {
                if (m_csOutFileInfo.m_csFileOutGIS2DData != null)
                {
                    bRtn = m_csOutFile.DataWrite(m_csOutFileInfo.m_csFileOutGIS2DData);
                }
                if (m_csOutFileInfo.m_csFileOutGIS3DData != null)
                {
                    bRtn = m_csOutFile.DataWrite(m_csOutFileInfo.m_csFileOutGIS3DData);
                }
            }
            else
            {
                McLog.DebugOut(this.GetSimulationTime(), GetID(), McLog.SYSTEM, "CompleteCalculation", "Cannot Open File(" + m_csOutFileNameWithFullPath.ToString() + ") in " + this.ToString() + ".CompleteCalculation()");
                McStructErrorInfo csErrorInfo = HySCommonInfoHash.GetCorrespondData(McDefine.CALCULATION_ERROR_INF, this.m_csElement.GetOwnerProjectID()) as McStructErrorInfo;
                if (csErrorInfo != null)
                {
                    csErrorInfo.AddSimuErrorData(this.GetID(), HymcoStandardModelDefine.CSV_FILE_OUT_KIND,
                            "Cannot Open File(" + m_csOutFileNameWithFullPath.ToString() +") in " + this.ToString() + ".CompleteCalculation()");
                }
                bRtn = false;
            }
            */
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算中断時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SuspendCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算中断時　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool SuspendCalculation()
        {
            //return this.CompleteCalculation();
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputDataList)</para>
        /// </example>
        /// <param name="csInputDataList">演算に必要な入力情報リスト</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long Calculate(ref HySDataLinkedList csInputDataList)
        {
            m_lCalculate_Call_Before_DataFution_Call += 1; // Calculate Call 回数カウントアップ
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            // データ取得
            this.ReadDoubleData();


            long lDtNum = m_csOutFileInfo.m_csDataList.Count;  // 保管中の情報の数


            LinkedListNode<McOutRecordBase> csDtNode;

            McOutRecordBase csData = null;

            //McOutD2Record csD2Data = null;
            McOutD3Record csD3Data = null;

            HySTime csTm = null;

            if (m_csOutFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
            {
                for (int iLp = 0; iLp < lDtNum; iLp++)
                {   // 保管中の情報分繰り返す

                    // 保管情報を１レコードづつ取り出す
                    csDtNode = m_csOutFileInfo.m_csDataList.First;
                    csData = csDtNode.Value;
                    csTm = csData.m_csTime; // レコードの時刻
                    if ((m_csOutFileInfo.m_csLastOutTime + m_csOutFileInfo.m_csOutTimeLag).After(csTm) == false)
                    {   // 出力すべきレコード時刻か？

                        if (m_csOutFileInfo.m_lDimNum == 2)
                        {   // ２次元データならば
                            //csD2Data = csData as McOutD2Record;
                            csD3Data = csData as McOutD3Record;
                            HySGeoDim2MeshData csOutRcd = m_csOutFileInfo.m_csFileOutGIS2DData.CreateNewRecord() as HySGeoDim2MeshData;
                            HySCellData[,] csD2Cells = csOutRcd.GetMeshData();

                            for (long lDt = 0; lDt < m_csOutFileInfo.m_lDtDimLon; lDt++)
                            {
                                for (long lDt2 = 0; lDt2 < m_csOutFileInfo.m_lDtDimLat; lDt2++)
                                {
                                    // １レコード分の情報を　設定する
                                    //csD2Cells[lDt, lDt2].m_dData[0] = csD2Data.m_dD2DT[lDt, lDt2];
                                    for (int iIdx = 0; iIdx < m_csOutFileInfo.m_lCellCharaIdxNum; iIdx++)
                                    {
                                        csD2Cells[lDt, lDt2].m_dData[iIdx] = csD3Data.m_dD3DT[lDt, lDt2, iIdx];
                                    }
                                }
                            }
                            //csOutRcd.SetTime(csD2Data.m_csTime);
                            csOutRcd.SetTime(csD3Data.m_csTime);
                            // 書き出しデータに　書き出すレコードを追加する
                            //m_csOutFileInfo.m_csFileOutGIS2DData.AddData(csOutRcd);

                            // CSVに追加書き込みする
                            m_csOutFileInfo.m_csFileOutGIS2DData.CSVDataAppend(m_csOutFile, csOutRcd);

                        }
                        else if (m_csOutFileInfo.m_lDimNum == 3)
                        {   // ３次元データならば
                            /* ３次元は将来用
                            csD3Data = csData as McOutD3Record;
                            HySGeoDim3MeshData csOutRcd = m_csOutFileInfo.m_csFileOutGIS3DData.CreateNewRecord() as HySGeoDim3MeshData;
                            HySCellData[, ,] csD3Cells = csOutRcd.GetMeshData();

                            for (long lDt = 0; lDt < m_csOutFileInfo.m_lDtDimLon; lDt++)
                            {
                                for (long lDt2 = 0; lDt2 < m_csOutFileInfo.m_lDtDimLat; lDt2++)
                                {
                                    for (long lDt3 = 0; lDt3 < m_csOutFileInfo.m_lDtDimAlt; lDt3++)
                                    {
                                        // １レコード分の情報を　設定する
                                        csD3Cells[lDt, lDt2, lDt3].m_dData[m_csOutFileInfo.m_lOutDataIdx] = csD3Data.m_dD3DT[lDt, lDt2, lDt3];
                                    }
                                }
                            }
                            // 書き出しデータに　書き出すレコードを追加する
                            //m_csOutFileInfo.m_csFileOutGIS2DData.AddData(csOutRcd);

                            // CSVに追加書き込みする
                            */
                        }

                        m_csOutFileInfo.m_csLastOutTime.SetTime(csTm);
                        // 最終保管レコードの時刻を設定
                    }

                    // 読み出した情報は一時保管情報から削除する
                    m_csOutFileInfo.m_csDataList.RemoveFirst();
                }   // end of for(保管中の情報分繰り返す)

                m_csOutFile.Close();
            }   // end of FileOpen
            else
            {
            }
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>入力された伝送データのdouble型データを取得し一時保管しておく</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = ReadData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long ReadDoubleData()
        {
            McTimeSeriesGeoD2MeshTranInfo csCellD2Trn = null;
            McTimeSeriesGeoD3MeshTranInfo csCellD3Trn = null;

            // 入力された伝送情報を読み出す
            if ((csCellD2Trn = m_csInputData[0] as McTimeSeriesGeoD2MeshTranInfo) != null)
            {   // ２次元の場合

                //if (m_csOutFileInfo.m_csFileOutGIS2DData == null)
                //{
                //    m_csOutFileInfo.m_csFileOutGIS2DData = new HySGeoDim2MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, 1);
                //}
                //if (m_csOutFileInfo.m_csCellCharactor == null)
                //{
                //    m_csOutFileInfo.m_csCellCharactor = new HySDataCharacteristicInCell(1);
                //    HySDataCharacteristicInCell csCellCharactor = csCellD2Trn.GetCellDataCharacteristic();
                //    m_csOutFileInfo.m_csCellCharactor.m_csDataKind[0] = csCellCharactor.m_csDataKind[m_csOutFileInfo.m_lOutDataIdx].Clone();
                //    m_csOutFileInfo.m_csCellCharactor.m_csUnit[0] = csCellCharactor.m_csUnit[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csCellCharactor.m_csLabel[0] = csCellCharactor.m_csLabel[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csFileOutGIS2DData.SetCellDataCharacteristic(m_csOutFileInfo.m_csCellCharactor);
                //}

                McGeoDim2MeshTranInfo csDtD2Rcd = null;
                HySCellData[,] csD2Cells = null;
                //McOutD2Record csRcd = null;  // １レコード分のデータ
                McOutD3Record csRcd = null;  // １レコード分のデータ
                McReceiveCellDataIF csInputCellData = m_InputCellData[0];

                long lDtNum = csCellD2Trn.SetCursorPlus(m_csOutFileInfo.m_csLastINTime);// 最終時刻以後に情報が追加されているか？

                for (long lDtLp = 0; lDtLp < lDtNum; lDtLp++)
                {   // 追加された情報分処理を行う

                    csDtD2Rcd = (McGeoDim2MeshTranInfo)csCellD2Trn.GetCursorData();
                    csD2Cells = csDtD2Rcd.GetMeshData();
                    //csRcd = new McOutD2Record(m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat);  // １レコード情報格納クラスの生成
                    csRcd = new McOutD3Record(m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lCellCharaIdxNum);  // １レコード情報格納クラスの生成
                    for (long lDt = 0; lDt < m_csOutFileInfo.m_lDtDimLon; lDt++)
                    {
                        for (long lDt2 = 0; lDt2 < m_csOutFileInfo.m_lDtDimLat; lDt2++)
                        {
                            // １レコード分の情報を　設定する
                            //csRcd.m_dD2DT[lDt, lDt2] = csInputCellData.Data(csD2Cells[lDt, lDt2], m_csOutFileInfo.m_lOutDataIdx);
                            for (int iLp = 0; iLp < m_csOutFileInfo.m_lCellCharaIdxNum; iLp++)
                            {
                                csRcd.m_dD3DT[lDt, lDt2, iLp] = csD2Cells[lDt, lDt2].m_dData[iLp];
                            }

                        }
                    }
                    csRcd.m_csTime = csDtD2Rcd.GetLastTime();

                    // 読み出した情報を一時保管しておく
                    m_csOutFileInfo.m_csDataList.AddLast(csRcd);
                    m_csOutFileInfo.m_csLastINTime.SetTime(csRcd.m_csTime);

                    csCellD2Trn.MoveCursorNext();
                }
            }
            else if ((csCellD3Trn = m_csInputData[0] as McTimeSeriesGeoD3MeshTranInfo) != null)
            {   // ３次元の場合

                //if (m_csOutFileInfo.m_csFileOutGIS3DData == null)
                //{
                //    m_csOutFileInfo.m_csFileOutGIS3DData = new HySGeoDim3MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lDtDimAlt, 1);
                //}
                //if (m_csOutFileInfo.m_csCellCharactor == null)
                //{
                //    m_csOutFileInfo.m_csCellCharactor = new HySDataCharacteristicInCell(1);
                //    HySDataCharacteristicInCell csCellCharactor = csCellD3Trn.GetCellDataCharacteristic();
                //    m_csOutFileInfo.m_csCellCharactor.m_csDataKind[0] = csCellCharactor.m_csDataKind[m_csOutFileInfo.m_lOutDataIdx].Clone();
                //    m_csOutFileInfo.m_csCellCharactor.m_csUnit[0] = csCellCharactor.m_csUnit[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csCellCharactor.m_csLabel[0] = csCellCharactor.m_csLabel[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csFileOutGIS3DData.SetCellDataCharacteristic(m_csOutFileInfo.m_csCellCharactor);
                //}

                McGeoDim3MeshTranInfo csDtD3Rcd = null;
                HySCellData[, ,] csD3Cells = null;
                McOutD3Record csRcd = null;  // １レコード分のデータ
                McReceiveCellDataIF csInputCellData = m_InputCellData[0];

                long lDtNum = csCellD3Trn.SetCursorPlus(m_csOutFileInfo.m_csLastINTime);// 最終時刻以後に情報が追加されているか？

                for (long lDtLp = 0; lDtLp < lDtNum; lDtLp++)
                {   // 追加された情報分処理を行う

                    csDtD3Rcd = (McGeoDim3MeshTranInfo)csCellD3Trn.GetCursorData();
                    csD3Cells = csDtD3Rcd.GetMeshData();
                    csRcd = new McOutD3Record(m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lDtDimAlt);  // １レコード情報格納クラスの生成
                    for (long lDt = 0; lDt < m_csOutFileInfo.m_lDtDimLon; lDt++)
                    {
                        for (long lDt2 = 0; lDt2 < m_csOutFileInfo.m_lDtDimLat; lDt2++)
                        {
                            for (long lDt3 = 0; lDt3 < m_csOutFileInfo.m_lDtDimAlt; lDt3++)
                            {
                                // １レコード分の情報を　設定する
                                //csRcd.m_dD3DT[lDt, lDt2, lDt3] = csInputCellData.Data(csD3Cells[lDt, lDt2, lDt3], m_csOutFileInfo.m_lOutDataIdx);
                                csRcd.m_dD3DT[lDt, lDt2, lDt3] = csD3Cells[lDt, lDt2, lDt3].m_dData[m_csOutFileInfo.m_lOutDataIdx];
                            }
                        }
                    }
                    csRcd.m_csTime = csDtD3Rcd.GetLastTime();

                    // 読み出した情報を一時保管しておく
                    m_csOutFileInfo.m_csDataList.AddLast(csRcd);
                    m_csOutFileInfo.m_csLastINTime.SetTime(csRcd.m_csTime);

                    csCellD3Trn.MoveCursorNext();
                }
            }
            else
            {
            }

            return 0;
        }

        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            // 使用しやすいようにキャストしておく
            m_csOutFileInfo = (McGISFileOutCell1ValInfo)m_csCalInfo;

            McModelPropertyInfo csPropInf = csCellMdlPropertyInfo as McModelPropertyInfo;
            if (csPropInf != null)
            {   // プロパティ情報あり
                double dDt = 0.0D;
                csPropInf.GetInfo("OUTTIME_LAG", ref dDt);
                m_csOutFileInfo.m_csOutTimeLag = new HySTime(dDt * 1.0D);

                csPropInf.GetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, ref m_csOutFileInfo.m_lOverWriteSW);
                if (m_csOutFileInfo.m_lOverWriteSW == 1)
                {   // 上書き書き出し
                    string sFileName = "";
                    csPropInf.GetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ref sFileName);
                    m_csOutFileNameWithFullPath = new HySString(".\\" + sFileName);
                }
                else
                {   // 別名ファイル選択の場合
                    // パス名取得
                    csPropInf.GetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, ref m_csOutFileInfo.m_sOutDirPath);
                    // ファイル名取得
                    csPropInf.GetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, ref m_csOutFileInfo.m_sOutFileName);
                }
            }
            else
            {
                m_csOutFileNameWithFullPath = new HySString(".\\GIStFileOut.d2gis");
            }
            return true;
        }

    }
}
