﻿// <summary>ソースコード：ＣＳＶ時系列ファイル入力要素プロパティ詳細設定画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ＣＳＶ時系列ファイル入力要素プロパティ詳細設定画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/17][新規作成]</para>
    /// </remarks>
    public partial class McDotNetCSVFileINPropertyDetailForm : McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetCSVFileINPropertyDetailForm csPropertyDetailForm = new McDotNetCSVFileINPropertyDetailForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetCSVFileINPropertyDetailForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            string sVal = null;
            long lVal = 0;

            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                // プロパティ情報取得
                // 読み込みCSVファイル
                if (csModelPropertyInfo.GetInfo("m_csInFileNameWithPath", ref sVal) == true)
                {
                    FileName_TextBox.Text = sVal;
                }
                // データの次元数
                if (csModelPropertyInfo.GetInfo("m_lDataDim", ref lVal) == true)
                {
                    if (lVal == 1)
                    {// １次元
                        Dim1_RadioButton.Checked = true;
                    }
                    else if (lVal == 2)
                    {// ２次元
                        Dim2_RadioButton.Checked = true;
                    }
                    else if (lVal == 3)
                    {// ３次元
                        Dim3_RadioButton.Checked = true;
                    }
                    else
                    {// 指定なし⇒デフォルト１次元
                        Dim1_RadioButton.Checked = true;
                    }
                }
                else
                {// 指定なし⇒デフォルト１次元
                    Dim1_RadioButton.Checked = true;
                }
                // １次元データ配列数
                if (csModelPropertyInfo.GetInfo("m_lDim1", ref lVal) == true)
                {
                    Dim1_TextBox.Text = lVal.ToString();
                }
                else
                {// 設定データ無し⇒デフォルト 1
                    Dim1_TextBox.Text = "1";
                }
                // ２次元データ配列数
                if (csModelPropertyInfo.GetInfo("m_lDim2", ref lVal) == true)
                {
                    Dim2_TextBox.Text = lVal.ToString();
                }
                else
                {// 設定データ無し⇒デフォルト 1
                    Dim2_TextBox.Text = "1";
                }
                // ３次元データ配列数
                if (csModelPropertyInfo.GetInfo("m_lDim3", ref lVal) == true)
                {// 設定データ無し⇒デフォルト 1
                    Dim3_TextBox.Text = lVal.ToString();
                }
                else
                {
                    Dim3_TextBox.Text = "1";
                }
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「設定」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「設定」ボタンが押下された事を通知する</para>
        /// </remarks>
        public override void FinalOK()
        {
            return;
        }
        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「キャンセル」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「キャンセル」ボタンが押下された事を通知する</para>
        /// </remarks>
        public override void FinalCancel()
        {
            return;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル入力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileOpen_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileOpen_Click(object sender, EventArgs e)
        {
            // ファイル入力ボタン押下時の処理を記述する。
            if (m_csPropertyInfo != null || m_csInitialInfo != null)
            {// プロパティ情報・初期設定情報があった場合
                OpenFileDialog.FileName = "";
                OpenFileDialog.Filter = Properties.McStandardModelPropertyResources.FILE_DLG_FILTER_XML_CSV;//"ＣＳＶ ファイル (*.csv)|*.csv|すべてのファイル (*.*)|*.*"
                if (OpenFileDialog.ShowDialog(this) == DialogResult.OK)
                {// 入力ファイルを選択した場合
                    FileName.Text = OpenFileDialog.FileName;        // テキスト表示
                    // ファイル入力
                    string csFileName = OpenFileDialog.FileName;    // 入力ファイルフルパス名

                    HySFile csFile = new HySFile((new HySString(csFileName)));
                    if (csFile.Exist() == true)
                    {// 既存ファイルが有れば
                        string sFileName = "";
                        long lDataDim = 1;
                        string sDim1Val = "";
                        string sDim2Val = "";
                        string sDim3Val = "";
                        
                        if (csFileName.IndexOf(".csv", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                        {// CSVファイルの場合
                            HySString sOut = new HySString();
                            string[] sInWk;

                            if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                            {// 既存CSVファイルを正常に開ければ
                                //値を初期化                              
                                while (csFile.ReadText(ref sOut) != 0)
                                {// １行取得
                                    long lVal = new long();

                                    sInWk = sOut.ToString().Split(',');
                                    if (sInWk.LongLength == 4)
                                    {// パラメータ情報項目数と一致した場合
                                        if (sInWk[0] != "#")
                                        {// コメント行以外の場合
                                            if (sInWk[0] == "[P]")
                                            {//プロパティ情報
                                                if (sInWk[3].CompareTo("m_csInFileNameWithPath") == 0)
                                                {// 読み込みCSVファイル
                                                    sFileName = sInWk[2].ToString();
                                                }
                                                else if (sInWk[3].CompareTo("m_lDataDim") == 0)
                                                {// データの次元数
                                                    if (long.TryParse(sInWk[2].ToString(), out lVal) == true)
                                                    {
                                                        lDataDim = lVal;
                                                    }
                                                }
                                                else if (sInWk[3].CompareTo("m_lDim1") == 0)
                                                {// １次元データ配列数
                                                    sDim1Val = sInWk[2].ToString();
                                                }
                                                else if (sInWk[3].CompareTo("m_lDim2") == 0)
                                                {// ２次元データ配列数
                                                    sDim2Val = sInWk[2].ToString();
                                                }
                                                else if (sInWk[3].CompareTo("m_lDim3") == 0)
                                                {// ３次元データ配列数
                                                    sDim3Val = sInWk[2].ToString();
                                                }
                                            }
                                            else if (sInWk[0] == "[I]")
                                            {//初期設定情報
                                                // 無し
                                            }
                                        }
                                    }
                                }
                                csFile.Close();
                            }
                        }
                        else if (csFileName.IndexOf(".xml", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                        {// Xmlファイルの場合
                            HySXmlReader csXmlReader = new HySXmlReader(csFileName);
                            HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
                            HySXmlNodeList csXmlChildNodeList = null;

                            csXmlChildNodeList = csXmlRootNode.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
                            if (csXmlChildNodeList.GetCount() > 0)
                            {// ノード数が０より大きい場合
                                HySString csKey = new HySString();
                                HySString csPropertyName = new HySString();
                                long lVal = new long();
                                string sVal = "";

                                McPropertyInfo csXmlInWorkInfo = new McPropertyInfo(m_csPropertyInfo.GetFactoryID(), (HySObjectKind)m_csPropertyInfo.GetModelKind());
                                csXmlInWorkInfo.XmlIN(csXmlChildNodeList.GetNode(0));
                                if (csXmlInWorkInfo.GetInfo("m_csInFileNameWithPath", ref sVal) == true)
                                {// 読み込みCSVファイル
                                    sFileName = sVal;
                                }
                                if (csXmlInWorkInfo.GetInfo("m_lDataDim", ref lVal) == true)
                                {// データの次元数
                                    lDataDim = lVal;
                                }
                                if (csXmlInWorkInfo.GetInfo("m_lDim1", ref lVal) == true)
                                {// １次元データ配列数
                                    sDim1Val = lVal.ToString();
                                }
                                if (csXmlInWorkInfo.GetInfo("m_lDim2", ref lVal) == true)
                                {// ２次元データ配列数
                                    sDim2Val = lVal.ToString();
                                }
                                if (csXmlInWorkInfo.GetInfo("m_lDim3", ref lVal) == true)
                                {// ３次元データ配列数
                                    sDim3Val = lVal.ToString();
                                }

                            }
                        }

                        // 読み込みCSVファイル
                        FileName_TextBox.Text = sFileName;
                        // データ次元数
                        if (lDataDim == 1)
                        {
                            Dim1_RadioButton.Checked = true;
                        }
                        else if (lDataDim == 2)
                        {
                            Dim2_RadioButton.Checked = true;
                        }
                        else if (lDataDim == 3)
                        {
                            Dim3_RadioButton.Checked = true;
                        }
                        else
                        {
                            Dim1_RadioButton.Checked = true;
                        }
                        // １、２、３次元データ配列数
                        Dim1_TextBox.Text = sDim1Val;
                        Dim2_TextBox.Text = sDim2Val;
                        Dim3_TextBox.Text = sDim3Val;

                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル出力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileSave_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileSave_Click(object sender, EventArgs e)
        {
            // ファイル出力ボタン押下時の処理を記述する。
            if (ParaSet_Check() == true)
            {// 設定情報に異常がある場合
                return;
            }

            if (m_csPropertyInfo != null)
            {  // プロパティ情報・初期設定情報があった場合
                SaveFileDialog.FileName = FileName.Text;
                SaveFileDialog.Filter = Properties.McStandardModelPropertyResources.FILE_DLG_FILTER_XML;//"ＸＭＬ ファイル (*.xml)|*.xml"
                if (SaveFileDialog.ShowDialog(this) == DialogResult.OK)
                {// 出力ファイルを選択した場合
                    string csFileName = SaveFileDialog.FileName;    // 出力ファイルフルパス名

                    if (csFileName.Substring(csFileName.Length - 4, 4) != Properties.McStandardModelPropertyResources.FILE_DLG_EXTENSION_XML)
                    {// 拡張子が付いていない場合
                        csFileName += Properties.McStandardModelPropertyResources.FILE_DLG_EXTENSION_XML;
                    }

                    FileName.Text = csFileName;            // テキスト表示

                    HySXmlWriter csXmlWriter = new HySXmlWriter(csFileName);

                    HySXmlNode csRootNode = csXmlWriter.CreateRoot("PropertyRoot");

                    // プロパティ出力指定
                    McPropertyInfoBase.SetXmlOutFlg(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL);

                    McPropertyInfo csXmlOutWorkInfo = new McPropertyInfo(m_csPropertyInfo.GetFactoryID(), (HySObjectKind)m_csPropertyInfo.GetModelKind());

                    HySString csKey = new HySString();
                    HySString csPropertyName = new HySString();
                    McDefine.ValKind lObjKind = new McDefine.ValKind();
                    long lVal = new long();
                    string sVal = "";

                    // 読み込みＣＳＶファイル
                    csKey = new HySString("m_csInFileNameWithPath");
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        sVal = FileName_TextBox.Text;
                        csXmlOutWorkInfo.SetInfo(csKey, sVal);
                    }
                    // データの次元数
                    csKey = new HySString("m_lDataDim");
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        lVal = 1;
                        if(Dim2_RadioButton.Checked == true)
                        {
                            lVal = 2;
                        }
                        else if(Dim3_RadioButton.Checked == true)
                        {
                            lVal = 3;
                        }
                        csXmlOutWorkInfo.SetInfo(csKey, lVal);
                    }
                    // １次元データ配列数
                    csKey = new HySString("m_lDim1");
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        lVal = long.Parse(Dim1_TextBox.Text);
                        csXmlOutWorkInfo.SetInfo(csKey, lVal);
                    }
                    // ２次元データ配列数
                    csKey = new HySString("m_lDim2");
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        lVal = long.Parse(Dim2_TextBox.Text);
                        csXmlOutWorkInfo.SetInfo(csKey, lVal);
                    }
                    // ３次元データ配列数
                    csKey = new HySString("m_lDim3");
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        lVal = long.Parse(Dim3_TextBox.Text);
                        csXmlOutWorkInfo.SetInfo(csKey, lVal);
                    }
                    csRootNode.AppendChild(csXmlOutWorkInfo.XmlOUT(ref csXmlWriter));
                    csXmlWriter.Save();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            // 設定内容登録
            if (ParaRegist() == true)
            {// 変更がある場合
                DialogResult = DialogResult.OK;
            }
            else
            {// 変更がない場合
                DialogResult = DialogResult.Cancel;
            }

            Close();

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセルボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>１次元ラジオボタン変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Dim1_RadioButton_CheckedChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Dim1_RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked == true)
            {
                Dim1_TextBox.Enabled = true;
                Dim2_TextBox.Enabled = false;
                Dim3_TextBox.Enabled = false;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>２次元ラジオボタン変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Dim1_RadioButton_CheckedChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Dim2_RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked == true)
            {
                Dim1_TextBox.Enabled = true;
                Dim2_TextBox.Enabled = true;
                Dim3_TextBox.Enabled = false;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>３次元ラジオボタン変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Dim1_RadioButton_CheckedChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Dim3_RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked == true)
            {
                Dim1_TextBox.Enabled = true;
                Dim2_TextBox.Enabled = true;
                Dim3_TextBox.Enabled = true;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=false:正常、=true:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ParaSet_Check()
        {
            bool bBreakfg = false;
            long lVal = 0;

            //１次元データ配列
            if (long.TryParse(Dim1_TextBox.Text, out lVal) == true)
            {
                if (lVal > 0)
                {// 正常
                    Dim1_TextBox.BackColor = Color.Empty;
                }
                else
                {// 異常
                    Dim1_TextBox.BackColor = Color.Red;
                    bBreakfg = true;
                }
            }
            else
            {// 異常
                Dim1_TextBox.BackColor = Color.Red;
                bBreakfg = true;
            }

            //２次元データ配列
            if (long.TryParse(Dim2_TextBox.Text, out lVal) == true)
            {
                if (lVal >= 0)
                {// 正常
                    Dim2_TextBox.BackColor = Color.Empty;
                }
                else
                {// 異常
                    Dim2_TextBox.BackColor = Color.Red;
                    bBreakfg = true;
                }
            }
            else
            {// 異常
                Dim2_TextBox.BackColor = Color.Red;
                bBreakfg = true;
            }
 
            //３次元データ配列
            if (long.TryParse(Dim3_TextBox.Text, out lVal) == true)
            {
                if (lVal >= 0)
                {// 正常
                    Dim3_TextBox.BackColor = Color.Empty;
                }
                else
                {// 異常
                    Dim3_TextBox.BackColor = Color.Red;
                    bBreakfg = true;
                }
            }
            else
            {// 異常
                Dim3_TextBox.BackColor = Color.Red;
                bBreakfg = true;
            }

            string sErrCharacter = @"/:,;*?""<>|";
            if (FileName_TextBox.Text == "" || FileName_TextBox.Text.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
            {// 異常
                FileName_TextBox.BackColor = Color.Red;
                bBreakfg = true;
            }
            else
            {// 正常
                FileName_TextBox.BackColor = Color.Empty;
            }

            return bBreakfg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容登録処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaRegist();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=false:変更無し、=true:変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ParaRegist()
        {
            HySString csKey = null;
            HySString csPropatyName = new HySString();
            McDefine.ValKind lObjKind = new McDefine.ValKind();
            long lOrgVal = new long();
            long lNewVal;
            string sOrgVal = "";
            string sNewVal;
            bool bModifyFlg = false;

            if (m_csOriginalPropertyInfo != null)
            {// 登録プロパティ情報がある場合

                // 読み込みＣＳＶファイル
                csKey = new HySString("m_csInFileNameWithPath");
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    sNewVal = FileName_TextBox.Text;
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref sOrgVal);
                    if (sNewVal != sOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);
                        bModifyFlg = true;
                    }
                }

                // データの次元数
                csKey = new HySString("m_lDataDim");
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    lNewVal = 1;
                    if (Dim2_RadioButton.Checked == true)
                    {
                        lNewVal = 2;
                    }
                    else if (Dim3_RadioButton.Checked == true)
                    {
                        lNewVal = 3;
                    }
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref lOrgVal);
                    if (lNewVal != lOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, lNewVal);
                        bModifyFlg = true;
                    }
                }
                
                // １次元データ配列数
                csKey = new HySString("m_lDim1");
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    lNewVal = long.Parse(Dim1_TextBox.Text);
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref lOrgVal);
                    if (lNewVal != lOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, lNewVal);
                        bModifyFlg = true;
                    }
                }
                // ２次元データ配列数
                csKey = new HySString("m_lDim2");
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    lNewVal = long.Parse(Dim2_TextBox.Text);
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref lOrgVal);
                    if (lNewVal != lOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, lNewVal);
                        bModifyFlg = true;
                    }
                } 
                // ３次元データ配列数
                csKey = new HySString("m_lDim3");
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    lNewVal = long.Parse(Dim3_TextBox.Text);
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref lOrgVal);
                    if (lNewVal != lOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, lNewVal);
                        bModifyFlg = true;
                    }
                } 
            }

            return bModifyFlg;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            if (TabControl1.SelectedTab == TabPage2)
            {//初期設定タブを無効とする。
                TabControl1.SelectedTab = TabPage1;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {// タブが選択されている場合
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {// タブが選択されていない場合
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }

        /// <summary><para>method outline</para>
        /// <para>ファイル名参照ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SelectFileName_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectFileName_Click(object sender, EventArgs e)
        {
            string sDirectory = ((McDotNetCSVFileINScreen)m_csScreen).GetDataHomeDirectory().ToString() + "\\"
                              + ((McDotNetCSVFileINScreen)m_csScreen).GetProjectGroupName().ToString() + "\\InputData";
            if (Directory.Exists(sDirectory) == false)
            {
                sDirectory = ((McDotNetCSVFileINScreen)m_csScreen).GetDataHomeDirectory().ToString();
            }

            OpenFileDialog.InitialDirectory = sDirectory;

            if (FileName_TextBox.Text != "")
            {
                string sWriteFileName = ((McDotNetCSVFileINScreen)m_csScreen).GetDataHomeDirectory().ToString() + "\\"
                                       + ((McDotNetCSVFileINScreen)m_csScreen).GetProjectGroupName().ToString() + "\\"
                                       + FileName_TextBox.Text;
                sWriteFileName = Path.GetFullPath(sWriteFileName);
                if (Directory.Exists(Directory.GetParent(sWriteFileName).ToString()) == true)
                {
                    OpenFileDialog.FileName = Path.GetFullPath(sWriteFileName);
                }
            }

            OpenFileDialog.Filter = Properties.McStandardModelPropertyResources.FILE_DLG_FILTER_CSV;//"ＣＳＶ ファイル (*.csv)|*.csv"
            if (OpenFileDialog.ShowDialog(this) == DialogResult.OK)
            {// 出力ファイルを選択した場合
                HySString csFileName = new HySString(OpenFileDialog.FileName);    // 出力ファイルフルパス名
                HySString csRelativePath = new HySString();

                ((McDotNetCSVFileINScreen)m_csScreen).GetRelativePathBasedOnProjectGroup(csFileName, ref csRelativePath);
                FileName_TextBox.Text = csRelativePath.ToString();
            }

        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0022, this.Parent);
        }

    }
}