﻿// <summary>ソースコード：マージ出力要素モデルプロパティ詳細設定画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>マージ出力要素モデルプロパティ詳細設定画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.4.0][2013/12/11][新規作成]</para>
    /// </remarks>
    public partial class McDotNetCSVFileOUTMergePropertyDetailForm : McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {
        /// <summary>フォルダ選択画面説明</summary>
        static private readonly string FOLDER_DLG_DESCRIPTION =
            Properties.McStandardModelPropertyResources.ResourceManager.GetString("FILE_DLG_SELECT_FOLDER");

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetCSVFileOUTMergePropertyDetailForm csPropertyDetailForm = new McDotNetCSVFileOUTMergePropertyDetailForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetCSVFileOUTMergePropertyDetailForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            // 画面表示情報編集

            string sVal = null;
            long lVal = 0;
            double dVal = 0.0D;

            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                // プロパティ情報取得
                // 出力時間間隔（秒）
                if (csModelPropertyInfo.GetInfo("OUTTIME_LAG", ref dVal) == true)
                {
                    Interval_UpDown.Value = (decimal)dVal;
                }

                // 上書き／別名ファイル選択
                if (csModelPropertyInfo.GetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, ref lVal) == true)
                {
                    if (lVal == 0)
                    {// 自動作成
                        Auto_RadioButton.Checked = true;
                    }
                    else
                    {// 上書き
                        UpDate_RadioButton.Checked = true;
                    }
                }
                else
                {// 指定なし⇒上書き
                    UpDate_RadioButton.Checked = true;
                }

                // 出力ファイル名（パス付き）
                if (csModelPropertyInfo.GetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ref sVal) == true)
                {
                    OverWriteFileName_TextBox.Text = sVal;
                }

                // 書き出しディレクトリ
                if (csModelPropertyInfo.GetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, ref sVal) == true)
                {
                    WriteDirectory_TextBox.Text = sVal;
                }
                
                // 書き出しファイル名
                if (csModelPropertyInfo.GetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, ref sVal) == true)
                {
                    WriteFileName_TextBox.Text = sVal;
                }
                // ＣＳＶ出力順序
                // リストのクリア
                this.InputElementList.Items.Clear();
                HySDataLinkedList csInputInfoList = ((McCellModelPropertyInfo)csModelPropertyInfo).GetInputConnectionInfoList();
                csModelPropertyInfo.GetInfo(HymcoStandardModelDefine.INPUT_LINE_NUM, ref sVal);
                if (csInputInfoList.GetCount() == 0)
                {
                    // 現状の接続状況で初期表示
                    this.InputElementListInitialize(csModelPropertyInfo);
                }
                else if (csModelPropertyInfo.GetInfo(HymcoStandardModelDefine.INPUT_LINE_NUM, ref sVal) == true)
                {
                    if (csInputInfoList.GetCount().ToString().Equals(sVal) == false)
                    {
                        // 現状の接続状況で初期表示
                        this.InputElementListInitialize(csModelPropertyInfo);
                    }
                    else
                    {
                        int iNum = Int32.Parse(sVal);
                        for (int iLp = 0; iLp < iNum; iLp++)
                        {
                            HySString csKey = new HySString(iLp.ToString());
                            ((McModelPropertyInfo)csModelPropertyInfo).GetInfo(csKey, ref sVal);
                            // 要素が置き換わってないかチェック
                            bool bRtn = this.CheckElementID(csModelPropertyInfo, sVal);
                            if (bRtn == false)
                            {
                                // リストのクリア
                                this.InputElementList.Items.Clear();
                                // 現状の接続状況で初期表示
                                this.InputElementListInitialize(csModelPropertyInfo);
                                break;
                            }
                            else
                            {
                                this.InputElementList.Items.Add(sVal);
                            }
                        }
                    }
                }
                else
                {
                    // 現状の接続状況で初期表示
                    this.InputElementListInitialize(csModelPropertyInfo);
                }
                // 入力線の数が0でなければ、プロパティ情報を反映する必要がある。
                //if (csInputInfoList.GetCount() != 0 && csModelPropertyInfo.GetInfo(HymcoStandardModelDefine.INPUT_LINE_NUM, ref sVal) == true)
                //{
                //    int iNum = Int32.Parse(sVal);
                //    for (int iLp = 0; iLp < iNum; iLp++)
                //    {
                //        HySString csKey = new HySString(iLp.ToString());
                //        ((McModelPropertyInfo)csModelPropertyInfo).GetInfo(csKey, ref sVal);
                //        this.InputElementList.Items.Add(sVal);
                //        //InputElementList.Items[iLp] = sVal;
                //    }
                //}
                //else
                //{// エラー情報があり、再設定を行う場合は、プロパティ情報は無視。
                //    // 現状の接続状況で初期表示
                //    this.InputElementListInitialize(csModelPropertyInfo);
                //}
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ID存在チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckElementID(csModelPropertyInfo, sID);</para>
        /// </example>
        /// <param name="csModelPropertyInfo">プロパティ情報</param>
        /// <param name="sID">要素ID</param>
        /// <returns>true:IDが存在、false:IDが存在しない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CheckElementID(McModelPropertyInfo csModelPropertyInfo, string sID)
        {
            // 1.プロパティ情報から上流側要素ID
            HySDataLinkedList csInputInfoList = ((McCellModelPropertyInfo)csModelPropertyInfo).GetInputConnectionInfoList();
            HySString csCntID = null;
            for (long lLp = 0; lLp < csInputInfoList.GetCount(); lLp++)
            {
                McModelInfo csModelInfo = csInputInfoList.GetData(lLp) as McModelInfo;
                if (csModelInfo != null)
                {
                    McCellArrayTranInfoPropertyInfo csTranInfoPro = csModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                    if (csTranInfoPro != null)
                    {
                        csCntID = (HySString)csTranInfoPro.GetUpperModelInfo().GetElementID().GetString();
                        if (csCntID.ToString().IndexOf('-') != -1)
                        {// 分割出来る場合
                            csCntID = new HySString(csCntID.ToString().Substring(0, csCntID.ToString().IndexOf('-')));
                            // Start of 要素名称対応
                            HySString csUserName = csTranInfoPro.GetUpperModelInfo().GetUserName();
                            if (csUserName != "")
                            {
                                csUserName = new HySString("[") + csUserName + new HySString("]");
                                csCntID += csUserName;
                            }
                            // End of 要素名称対応
                            if (sID.Equals(csCntID.ToString()) == true)
                            {
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＣＳＶ出力順序リスト初期化処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>InputElementListInitialize(csModelPropertyInfo);</para>
        /// </example>
        /// <param name="csModelPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void InputElementListInitialize(McModelPropertyInfo csModelPropertyInfo)
        {
            // 1.プロパティ情報から上流側要素ID
            HySDataLinkedList csInputInfoList = ((McCellModelPropertyInfo)csModelPropertyInfo).GetInputConnectionInfoList();
            HySString csCntID = null;
            // Start of 要素名称対応
            HySString csUserName = null;
            // End of 要素名称対応
            for (long lLp = 0; lLp < csInputInfoList.GetCount(); lLp++)
            {
                McModelInfo csModelInfo = csInputInfoList.GetData(lLp) as McModelInfo;
                if (csModelInfo != null)
                {
                    McCellArrayTranInfoPropertyInfo csTranInfoPro = csModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                    if (csTranInfoPro != null)
                    {
                        csCntID = (HySString)csTranInfoPro.GetUpperModelInfo().GetElementID().GetString();
                        if (csCntID.ToString().IndexOf('-') != -1)
                        {// 分割出来る場合
                            csCntID = new HySString(csCntID.ToString().Substring(0, csCntID.ToString().IndexOf('-')));
                            // Start of 要素名称対応
                            csUserName = csTranInfoPro.GetUpperModelInfo().GetUserName();
                            if (csUserName != "")
                            {
                                csUserName = new HySString("[") + csUserName + new HySString("]");
                                csCntID += csUserName;
                            }
                            // End of 要素名称対応
                        }
                        // 2.リストへ追加
                        this.InputElementList.Items.Add(csCntID.ToString());
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＣＳＶ出力順序変更アップボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MoveUpMenuItemButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MoveUpMenuItemButton_Click(object sender, EventArgs e)
        {
            int iIndex = InputElementList.SelectedIndex;

            if (iIndex == -1)
            {
                return;
            }

            if (iIndex > 0)
            {
                string stext = InputElementList.Items[iIndex].ToString();
                InputElementList.Items.RemoveAt(iIndex);
                InputElementList.Items.Insert(iIndex - 1, stext);
                InputElementList.SelectedIndex = iIndex - 1;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＣＳＶ出力順序変更ダウンボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MoveDownMenuItemButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MoveDownMenuItemButton_Click(object sender, EventArgs e)
        {
            int iIndex = InputElementList.SelectedIndex;

            if (iIndex == -1)
            {
                return;
            }

            if (iIndex < InputElementList.Items.Count - 1)
            {
                string stext = InputElementList.Items[iIndex].ToString();
                InputElementList.Items.RemoveAt(iIndex);
                InputElementList.Items.Insert(iIndex + 1, stext);
                InputElementList.SelectedIndex = iIndex + 1;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「設定」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalOK()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「設定」ボタンが押下された事を通知する</para>
        /// </remarks>
        public override void FinalOK()
        {
            return;
        }
        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「キャンセル」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「キャンセル」ボタンが押下された事を通知する</para>
        /// </remarks>
        public override void FinalCancel()
        {
            return;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル入力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileOpen_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileOpen_Click(object sender, EventArgs e)
        {
            // ファイル入力ボタン押下時の処理を記述する。
            if (m_csPropertyInfo != null || m_csInitialInfo != null)
            {// プロパティ情報・初期設定情報があった場合
                OpenFileDialog.FileName = "";
                OpenFileDialog.Filter = Properties.McStandardModelPropertyResources.FILE_DLG_FILTER_XML_CSV;//"ＣＳＶ ファイル (*.csv)|*.csv|すべてのファイル (*.*)|*.*"
                if (OpenFileDialog.ShowDialog(this) == DialogResult.OK)
                {// 入力ファイルを選択した場合
                    FileName.Text = OpenFileDialog.FileName;        // テキスト表示
                    // ファイル入力
                    string csFileName = OpenFileDialog.FileName;    // 入力ファイルフルパス名

                    HySFile csFile = new HySFile((new HySString(csFileName)));
                    if (csFile.Exist() == true)
                    {// 既存ファイルが有れば
                        double dInterval = 0.0D;
                        long lOverOtherSwitch = 1;
                        string sOverFileName = "";
                        string sAutoDirectoryName = "";
                        string sAutoFileName = "";

                        if (csFileName.IndexOf(".csv", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                        {// CSVファイルの場合
                            HySString sOut = new HySString();
                            string[] sInWk;

                            if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                            {// 既存CSVファイルを正常に開ければ
                                //値を初期化                              
                                while (csFile.ReadText(ref sOut) != 0)
                                {// １行取得
                                    double dVal = new double();
                                    long lVal = new long();

                                    sInWk = sOut.ToString().Split(',');
                                    if (sInWk.LongLength == 4)
                                    {// パラメータ情報項目数と一致した場合
                                        if (sInWk[0] != "#")
                                        {// コメント行以外の場合
                                            if (sInWk[0] == "[P]")
                                            {//プロパティ情報
                                                if (sInWk[3].CompareTo("OUTTIME_LAG") == 0)
                                                {// 出力時間間隔（秒）
                                                    if (double.TryParse(sInWk[2].ToString(), out dVal) == true)
                                                    {
                                                        dInterval = dVal;
                                                    }
                                                }
                                                else if (sInWk[3].CompareTo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH) == 0)
                                                {// 上書き／別名ファイル選択
                                                    if (long.TryParse(sInWk[2].ToString(), out lVal) == true)
                                                    {
                                                        lOverOtherSwitch = lVal;
                                                    }
                                                }
                                                else if (sInWk[3].CompareTo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME) == 0)
                                                {// 出力ファイル名（パス付き）
                                                    sOverFileName = sInWk[2].ToString();
                                                }
                                                else if (sInWk[3].CompareTo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME) == 0)
                                                {// 書き出しディレクトリ
                                                    sAutoDirectoryName = sInWk[2].ToString();
                                                }
                                                else if (sInWk[3].CompareTo(HymcoStandardModelDefine.WRITE_FILE_NAME) == 0)
                                                {// 書き出しファイル名
                                                    sAutoFileName = sInWk[2].ToString();
                                                }
                                            }
                                            else if (sInWk[0] == "[I]")
                                            {//初期設定情報
                                                // 無し
                                            }
                                        }
                                    }
                                }
                                csFile.Close();
                            }
                        }
                        else if (csFileName.IndexOf(".xml", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                        {// Xmlファイルの場合
                            HySXmlReader csXmlReader = new HySXmlReader(csFileName);
                            HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
                            HySXmlNodeList csXmlChildNodeList = null;

                            csXmlChildNodeList = csXmlRootNode.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
                            if (csXmlChildNodeList.GetCount() > 0)
                            {// ノード数が０より大きい場合
                                HySString csKey = new HySString();
                                HySString csPropertyName = new HySString();
                                long lVal = new long();
                                double dVal = new double();
                                string sVal = "";

                                McPropertyInfo csXmlInWorkInfo = new McPropertyInfo(m_csPropertyInfo.GetFactoryID(), (HySObjectKind)m_csPropertyInfo.GetModelKind());
                                csXmlInWorkInfo.XmlIN(csXmlChildNodeList.GetNode(0));
                                if (csXmlInWorkInfo.GetInfo("OUTTIME_LAG", ref dVal) == true)
                                {// 出力時間間隔（秒）
                                    dInterval = dVal;
                                }
                                if (csXmlInWorkInfo.GetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, ref lVal) == true)
                                {// 上書き／別名ファイル選択
                                    lOverOtherSwitch = lVal;
                                }
                                if (csXmlInWorkInfo.GetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ref sVal) == true)
                                {// 出力ファイル名（パス付き）
                                    sOverFileName = sVal;
                                }
                                if (csXmlInWorkInfo.GetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, ref sVal) == true)
                                {// 書き出しディレクトリ
                                    sAutoDirectoryName = sVal;
                                }
                                if (csXmlInWorkInfo.GetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, ref sVal) == true)
                                {// 書き出しファイル名
                                    sAutoFileName = sVal;
                                }

                            }
                        }

                        // 出力時間間隔（秒）
                        if (dInterval <= 0)
                        {
                            dInterval = 1.0D;
                        }
                        else if (dInterval > (1.0D * 60 * 60 * 24 * 10))
                        {
                            dInterval = (1.0D * 60 * 60 * 24 * 10);
                        }
                        Interval_UpDown.Value = (decimal)dInterval;
                        //上書き／別名ファイル選択
                        if (lOverOtherSwitch == 0)
                        {// 自動作成
                            Auto_RadioButton.Checked = true;
                        }
                        else
                        {// 上書き
                            UpDate_RadioButton.Checked = true;
                        }
                        // 出力ファイル名（パス付き）
                        OverWriteFileName_TextBox.Text = sOverFileName;
                        // 書き出しディレクトリ
                        WriteDirectory_TextBox.Text = sAutoDirectoryName;
                        // 書き出しファイル名
                        WriteFileName_TextBox.Text = sAutoFileName;

                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル出力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileSave_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileSave_Click(object sender, EventArgs e)
        {
            // ファイル出力ボタン押下時の処理を記述する。
            if (ParaSet_Check() == true)
            {// 設定情報に異常がある場合
                return;
            }

            if (m_csPropertyInfo != null)
            {  // プロパティ情報・初期設定情報があった場合
                SaveFileDialog.FileName = FileName.Text;
                SaveFileDialog.Filter = Properties.McStandardModelPropertyResources.FILE_DLG_FILTER_XML;//"ＸＭＬ ファイル (*.xml)|*.xml"
                if (SaveFileDialog.ShowDialog(this) == DialogResult.OK)
                {// 出力ファイルを選択した場合
                    string csFileName = SaveFileDialog.FileName;    // 出力ファイルフルパス名

                    if (csFileName.Substring(csFileName.Length - 4, 4) != Properties.McStandardModelPropertyResources.FILE_DLG_EXTENSION_XML)
                    {// 拡張子が付いていない場合
                        csFileName += Properties.McStandardModelPropertyResources.FILE_DLG_EXTENSION_XML;
                    }

                    FileName.Text = csFileName;            // テキスト表示

                    HySXmlWriter csXmlWriter = new HySXmlWriter(csFileName);

                    HySXmlNode csRootNode = csXmlWriter.CreateRoot("PropertyRoot");

                    // プロパティ出力指定
                    McPropertyInfoBase.SetXmlOutFlg(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL);

                    McPropertyInfo csXmlOutWorkInfo = new McPropertyInfo(m_csPropertyInfo.GetFactoryID(), (HySObjectKind)m_csPropertyInfo.GetModelKind());

                    HySString csKey = new HySString();
                    HySString csPropertyName = new HySString();
                    McDefine.ValKind lObjKind = new McDefine.ValKind();
                    long lVal = new long();
                    double dVal = new double();
                    string sVal = "";

                    // 出力時間間隔（秒）
                    csKey = new HySString("OUTTIME_LAG");
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);

                        dVal = (double)Interval_UpDown.Value;
                        csXmlOutWorkInfo.SetInfo(csKey, dVal);
                    }
                    // 上書き／別名ファイル選択
                    csKey = new HySString(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH);
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        if (UpDate_RadioButton.Checked == true)
                        {// 上書き
                            lVal = 1;
                        }
                        else
                        {// 自動作成
                            lVal = 0;
                        }
                        csXmlOutWorkInfo.SetInfo(csKey, lVal);
                    }

                    // 出力ファイル名（パス付き）
                    csKey = new HySString(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME);
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        sVal = OverWriteFileName_TextBox.Text;
                        csXmlOutWorkInfo.SetInfo(csKey, sVal);
                    }

                    // 書き出しディレクトリ
                    csKey = new HySString(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME);
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        sVal = WriteDirectory_TextBox.Text;
                        csXmlOutWorkInfo.SetInfo(csKey, sVal);
                    }

                    // 書き出しファイル名
                    csKey = new HySString(HymcoStandardModelDefine.WRITE_FILE_NAME);
                    if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                    {// プロパティ情報型式の取得が出来た場合
                        csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                        sVal = WriteFileName_TextBox.Text;
                        csXmlOutWorkInfo.SetInfo(csKey, sVal);
                    }


                    csRootNode.AppendChild(csXmlOutWorkInfo.XmlOUT(ref csXmlWriter));
                    csXmlWriter.Save();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            // 設定内容登録
            if (ParaRegist() == true)
            {// 変更がある場合
                DialogResult = DialogResult.OK;
            }
            else
            {// 変更がない場合
                DialogResult = DialogResult.Cancel;
            }

            Close();

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセルボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=false:正常、=true:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ParaSet_Check()
        {
            string sErrCharacter = @"/:,;*?""<>|";
            bool bBreakfg = false;

            // 出力時間間隔（秒）
            double dVal = (double)Interval_UpDown.Value;
            if (dVal > 0 && dVal <= (1.0D * 60 * 60 * 24 * 10))
            {// 正常
                Interval_UpDown.BackColor = Color.Empty;
            }
            else
            {// 異常
                Interval_UpDown.BackColor = Color.Red;
                bBreakfg = true;
            }

            // 出力ファイル名（パス付き）
            if (UpDate_RadioButton.Checked == true)
            {// 上書きの場合
                if (OverWriteFileName_TextBox.Text == "" || OverWriteFileName_TextBox.Text.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
                {// 異常
                    OverWriteFileName_TextBox.BackColor = Color.Red;
                    bBreakfg = true;
                }
                else
                {// 正常
                    OverWriteFileName_TextBox.BackColor = Color.Empty;
                }
            }

            if (Auto_RadioButton.Checked == true)
            {
                // 書き出しディレクトリ
                if (WriteDirectory_TextBox.Text == "" || WriteDirectory_TextBox.Text.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
                {// 異常
                    WriteDirectory_TextBox.BackColor = Color.Red;
                    bBreakfg = true;
                }
                else
                {// 正常
                    WriteDirectory_TextBox.BackColor = Color.Empty;
                }

                // 書き出しファイル名
                if (WriteFileName_TextBox.Text == "" || WriteFileName_TextBox.Text.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
                {// 異常
                    WriteFileName_TextBox.BackColor = Color.Red;
                    bBreakfg = true;
                }
                else
                {// 正常
                    WriteFileName_TextBox.BackColor = Color.Empty;
                }
            }
            return bBreakfg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容登録処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaRegist();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=false:変更無し、=true:変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ParaRegist()
        {
            HySString csKey = null;
            HySString csPropatyName = new HySString();
            McDefine.ValKind lObjKind = new McDefine.ValKind();
            double dOrgVal = new double();
            double dNewVal;
            long lOrgVal = new long();
            long lNewVal;
            string sOrgVal = "";
            string sNewVal;
            bool bModifyFlg = false;

            if (m_csOriginalPropertyInfo != null)
            {// 登録プロパティ情報がある場合

                // 出力時間間隔（秒）
                csKey = new HySString("OUTTIME_LAG");
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    dNewVal = (double)Interval_UpDown.Value;
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref dOrgVal);
                    if (dNewVal != dOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, dNewVal);
                        bModifyFlg = true;
                    }
                }

                // 上書き／別名ファイル選択
                csKey = new HySString(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH);
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    lNewVal = 1;
                    if (Auto_RadioButton.Checked == true)
                    {
                        lNewVal = 0;
                    }
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref lOrgVal);
                    if (lNewVal != lOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, lNewVal);
                        bModifyFlg = true;
                    }
                }

                // 出力ファイル名（パス付き）
                csKey = new HySString(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME);
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    sNewVal = OverWriteFileName_TextBox.Text;
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref sOrgVal);
                    if (sNewVal != sOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);
                        bModifyFlg = true;
                    }
                }
                
                // 書き出しディレクトリ
                csKey = new HySString(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME);
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    sNewVal = WriteDirectory_TextBox.Text;
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref sOrgVal);
                    if (sNewVal != sOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);
                        bModifyFlg = true;
                    }
                }
                
                // 書き出しファイル名
                csKey = new HySString(HymcoStandardModelDefine.WRITE_FILE_NAME);
                if (((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    sNewVal = WriteFileName_TextBox.Text;
                    ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref sOrgVal);
                    if (sNewVal != sOrgVal)
                    {// 設定変更ありの場合
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);
                        bModifyFlg = true;
                    }
                }
                // ＣＳＶ出力順序
                csKey = new HySString(HymcoStandardModelDefine.INPUT_LINE_NUM);
                int InputNum = InputElementList.Items.Count;
                sNewVal = InputNum.ToString();
                ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref sOrgVal);
                if (sNewVal != sOrgVal)
                {// 設定変更ありの場合
                    ((McModelPropertyInfo)m_csPropertyInfo).AddInfoType(csKey, new HySString("Line"), McDefine.ValKind.STRING);
                    ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);// 入力線の数を追加
                    bModifyFlg = true;
                    // 線が増えた場合は、無条件で全てのインデックスと要素IDの文字列を追加する処理を此処で行う
                    for (int iLp = 0; iLp < InputNum; iLp++)
                    {
                        csKey = new HySString(iLp.ToString());
                        sNewVal = InputElementList.Items[iLp].ToString();
                        ((McModelPropertyInfo)m_csPropertyInfo).AddInfoType(csKey, new HySString("Item"), McDefine.ValKind.STRING);
                        ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);// リストのインデックスと要素IDの文字列を追加
                    }
                }
                else
                {
                    for (int iLp = 0; iLp < InputNum; iLp++)
                    {
                        csKey = new HySString(iLp.ToString());
                        sNewVal = InputElementList.Items[iLp].ToString();
                        ((McModelPropertyInfo)m_csOriginalPropertyInfo).GetInfo(csKey, ref sOrgVal);
                        if (sNewVal != sOrgVal)
                        {// 設定変更ありの場合
                            ((McModelPropertyInfo)m_csPropertyInfo).AddInfoType(csKey, new HySString("Item"), McDefine.ValKind.STRING);
                            ((McModelPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);// リストのインデックスと要素IDの文字列を追加
                            bModifyFlg = true;
                        }
                    }
                }
            }
            return bModifyFlg;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            if (TabControl1.SelectedTab == TabPage2)
            {//初期設定タブを無効とする。
                TabControl1.SelectedTab = TabPage1;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {// タブが選択されている場合
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {// タブが選択されていない場合
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0025, this.Parent);
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>ファイル選択ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SelectFileName_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectFileName_Click(object sender, EventArgs e)
        {

            string sDirectory = ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetDataHomeDirectory().ToString() + "\\"
                              + ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetProjectGroupName().ToString();

            // ver1.6 出力要素モデル出力パスの統一
            sDirectory += "\\OutputData";

            if (Directory.Exists(sDirectory) == false)
            {
                sDirectory = ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetDataHomeDirectory().ToString();
            }

            OpenFileDialog csOpenFileDialog = new OpenFileDialog();
            csOpenFileDialog.InitialDirectory = sDirectory;

            if (OverWriteFileName_TextBox.Text != "")
            {
                string sWriteFileName = ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetDataHomeDirectory().ToString() + "\\"
                                       + ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetProjectGroupName().ToString() + "\\"
                                       + OverWriteFileName_TextBox.Text;
                sWriteFileName = Path.GetFullPath(sWriteFileName);
                if (Directory.Exists(Directory.GetParent(sWriteFileName).ToString()) == true)
                {
                    csOpenFileDialog.FileName = Path.GetFullPath(sWriteFileName);
                }
            }

            csOpenFileDialog.Filter = Properties.McStandardModelPropertyResources.FILE_DLG_FILTER_CSV;//"ＣＳＶ ファイル (*.csv)|*.csv"
            if (csOpenFileDialog.ShowDialog(this) == DialogResult.OK)
            {// 出力ファイルを選択した場合
                HySString csFileName = new HySString(csOpenFileDialog.FileName);    // 出力ファイルフルパス名
                HySString csRelativePath = new HySString();

                ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetRelativePathBasedOnProjectGroup(csFileName, ref csRelativePath);
                OverWriteFileName_TextBox.Text = csRelativePath.ToString();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>フォルダ選択ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SelectFolder_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectFolder_Click(object sender, EventArgs e)
        {
            try
            {
                // フォルダ参照画面作成
                FolderBrowserDialog csFolderBrowserDlg = new FolderBrowserDialog();
                // 画面設定
                csFolderBrowserDlg.Description = FOLDER_DLG_DESCRIPTION;

                string sWriteDirectory = ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetDataHomeDirectory().ToString() + "\\"
                                       + ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetProjectGroupName().ToString();
                if (WriteDirectory_TextBox.Text != "")
                {
                    sWriteDirectory = sWriteDirectory + "\\" + WriteDirectory_TextBox.Text;
                    sWriteDirectory = Path.GetFullPath(sWriteDirectory);
                }
                csFolderBrowserDlg.SelectedPath = sWriteDirectory;

                // フォルダ参照画面表示
                if (csFolderBrowserDlg.ShowDialog(this) == DialogResult.OK)
                {
                    HySString csDirectoryPath = new HySString(csFolderBrowserDlg.SelectedPath);    // 出力ファイルフルパス名
                    HySString csRelativePath = new HySString();

                    ((McDotNetCSVFileOUTMergeScreen)m_csScreen).GetRelativePathBasedOnProjectGroup(csDirectoryPath, ref csRelativePath);
                    WriteDirectory_TextBox.Text = csRelativePath.ToString();
                }
            }
            catch
            {
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル上書きボタン変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpDate_RadioButton_CheckedChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpDate_RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked == true)
            {
                // ファイル上書きモード
                OverWriteFileName_TextBox.Enabled = true;
                SelectFileName.Enabled = true;

                // フォルダ自動作成モード
                WriteDirectory_TextBox.Enabled = false;
                SelectFolder.Enabled = false;
                WriteFileName_TextBox.Enabled = false;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フォルダ自動作成ボタン変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Auto_RadioButton_CheckedChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Auto_RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked == true)
            {
                // ファイル上書きモード
                OverWriteFileName_TextBox.Enabled = false;
                SelectFileName.Enabled = false;

                // フォルダ自動作成モード
                WriteDirectory_TextBox.Enabled = true;
                SelectFolder.Enabled = true;
                WriteFileName_TextBox.Enabled = true;
            }
        }
    }
}
