﻿// <summary>ソースコード：ＧＩＳファイル出力プロパティスクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYMCO.CoreOptionl.HymcoStandardModel
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ＧＩＳファイル出力プロパティスクリーンクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/17][新規作成]</para>
    /// </remarks>
    public class McDotNetGISFileOUTScreen : McDotNetModelPropertyScreenBase
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetGISFileOUTScreen csScreen = new McDotNetGISFileOUTScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetGISFileOUTScreen()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> RefreshmentForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RefreshmentForm()
        {
            ((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).EditParameter();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去前処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> BeforeCloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:画面クローズ可　false:画面クローズ不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool BeforeCloseScreen()
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).ParaSet_Check() == true)
            {// 設定値に異常がある場合
                m_csPropertyForm.Activate();

                return false;
            }

            if (((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                m_csPropertyForm.Activate();

                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定イベント送信要求
                        ReqPropertyInfoSetEvent();
                    }
                }
            }

            return true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csPropertyForm = new McDotNetGISFileOUTPropertyDetailForm();
            m_csPropertyForm.SetScreen(this);
            ((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).SetModelPropertyInfo(m_csModelPropertyInfo);
            ((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).SetModelInitialInfo(m_csModelIntialInfo);
            ((McDotNetGISFileOUTPropertyDetailForm)m_csPropertyForm).EditParameter();
            base.Initialize();
            m_csPropertyForm.Width = 360;
            m_csPropertyForm.Height = 509;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            return bRtn;
        }

    }
}
