// <summary>ソースコード：スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYMCO.OptionImpl.McStructureXmlFileEditorForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>スクリーンクラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/10/28][新規作成]</para>
    /// </remarks>
    public class McStructureXmlFileEditorScreen : HySDotNetScreen
    {
        /// <summary>.net画面フォーム</summary>
        protected McStructureXmlFileEditorForm m_csMainForm = null;
        /// <summary>ビューアジョブ</summary>
        protected McStructureXmlFileEditorViewerJob m_csJob = null;



        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructureXmlFileEditorScreen csScreen = new McStructureXmlFileEditorScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructureXmlFileEditorScreen()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csMainForm = new McStructureXmlFileEditorForm(this, McStructureXmlFileEditorForm.XmlEditMode.Parameter);
            m_csMainForm.Text = Properties.McStructureXmlFileEditorResources.CAPTION_CREATE_INPUT_DATA_SET;

            m_csMainForm.StartPosition = FormStartPosition.Manual;
            m_csMainForm.SetDesktopLocation(360 , 0);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            m_csMainForm = null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McStructureXmlFileEditorDefine.BUSINESS_KIND.GetString()));
            m_csMainForm.MdiParent = ( ( HySDotNetViewer )m_csDotNetVeiewer ).GetMainForm();
            m_csJob = csViewer.GetViewerJob(McStructureXmlFileEditorDefine.BUSINESS_KIND.GetString()) as McStructureXmlFileEditorViewerJob;
            
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csMainForm.Show();
        }    
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            //m_csMainForm.Close();
            m_csJob.DeleteScreen(this);
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            m_csMainForm.Hide();
        }       
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            //m_csMainForm.Width = DEFAULT_WIDTH;
            //m_csMainForm.Height = DEFAULT_HEIGHT;
            m_csMainForm.WindowState = FormWindowState.Normal;
            m_csMainForm.StartPosition = FormStartPosition.Manual;
            m_csMainForm.SetDesktopLocation(360 , 0);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csMainForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csMainForm.Activate();
        }
            
        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            /* Do Nothing
            HySEventObject csEvObj = csEvent as HySEventObject;
            if (csEvObj != null)
            {
                long lEvNo = csEvObj.GetEventNo();
                long lSubEvNo = csEvObj.GetSubEventNo();
            }
            */
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            /* Do Nothing
            ((HySEventObject)csEvent).SetToSimKind(HysAddinScreenDefineSample.BUSINESS_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
            */
            return true;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            // Do Nothing
        }

    }
}
