using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.OptionImpl.McStructureXmlFileEditorForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/10/28][新規作成]</para>
    /// </remarks>
    public class McStructureXmlFileEditorDefine
    {
        // ===========================
        // 種別識別子関係
        // ===========================
        /// <summary>業務種別識別子：システム内でユニークな値としてください</summary>
        static public readonly HySKind BUSINESS_KIND = new HySObjectKind("HsAddin.McStructureXmlFileEditorBusiProc");
        /// <summary>画面ファクトリーID：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier FACTORY_ID_SCREEN = new HySID("HsAddin.McStructureXmlFileEditor.Factory.Screen");
        /// <summary>ビューア内処理ファクトリー：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier FACTORY_ID_VIEWRJOB = new HySID("HsAddin.McStructureXmlFileEditor.Factory.ViewerJob");


        // ===========================
        // 画面識別子関係
        // ===========================
        /// <summary>入力データセット作成ツール画面：本業務内でユニークな値としてください</summary>
        static public readonly HySKind EDITOR_SCREEN = new HySObjectKind("Editor.McStructureXmlFileEditor.Screen");
        /// <summary>構造定義ファイル作成ツール画面：本業務内でユニークな値としてください</summary>
        static public readonly HySKind CREATOR_SCREEN = new HySObjectKind("Creator.McStructureXmlFileEditor.Screen");

        // ===========================
        // メニューコールバック番号定義関係
        // ===========================
        /// <summary>入力データセット作成ツール画面表示開始：本業務内でユニークな値としてください</summary>
        static public readonly long EDITOR_DISP_SCREEN = 10;
        /// <summary>構造定義ファイル作成ツール画面表示開始：本業務内でユニークな値としてください</summary>
        static public readonly long CREATOR_DISP_SCREEN = 20;

        // ===========================
        // その他個別関係
        // ===========================
        /// <summary> システムデータフォルダパス </summary>
        static public readonly string SYSTEMDATA_PATH = Properties.McStructureXmlFileEditorResources.SYSTEMDATA_PATH;
        /// <summary> Excelテンプレートファイル名 </summary>
        static public readonly string EXCEL_TEMPLATE_FILE = "StructXmlTemplate.xls";
        

    }
}
