﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYMCO.OptionImpl.McStructureXmlFileEditorForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>ビューアジョブクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/10/28][新規作成]</para>
    /// </remarks>
    public class McStructureXmlFileEditorViewerJob : HySDotNetViewerJob
    {
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructureXmlFileEditorViewerJob csViewerJob = new McStructureXmlFileEditorViewerJob( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetViewerJob 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructureXmlFileEditorViewerJob()
        {
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            HySID csID = null;
            HySScreen csScreen = null;

            if (lCallBackNo == McStructureXmlFileEditorDefine.EDITOR_DISP_SCREEN)
            {   // 入力データセット作成ツール画面表示開始

                csID = new HySID("ArbitraryCode");  // 画面が一枚の時にはこのようにユニークな値を一意に設定
                // 同じ種類の画面を同時に表示したいときには
                //csID = new HySID(m_lPrmNo.ToString()); // 例えば左記の通り、ＩＤを変更すると、異なる画面が表示される
                m_lPrmNo += 1;
                //
                // 注意：csID は　画面の種別によらずユニークである必要がある。(異なる種類画面であっても、ＩＤが同じは許されない)

                // 画面表示
                csScreen = this.CmndShowScreen((HySObjectKind)McStructureXmlFileEditorDefine.EDITOR_SCREEN, csID);

            }
            else if (lCallBackNo == McStructureXmlFileEditorDefine.CREATOR_DISP_SCREEN)
            {   // 構造定義ファイル作成ツール画面表示開始
                csID = new HySID("ArbitraryCode2");
                m_lPrmNo += 1;
                
                // 画面表示
                csScreen = this.CmndShowScreen((HySObjectKind)McStructureXmlFileEditorDefine.CREATOR_SCREEN, csID);
            }
            else
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            m_bWorkFlg = true; // 処理開始したことをフラグに覚えさせておく
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            // ToDo　最低限、内部で管理している画面を終了（Terminateをコール）させる
            m_bWorkFlg = false;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            // 全スクリーンの終了処理を実行
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    csScreen.Terminate();
                    csScreen = null;
                }
            }
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            // 処理中でなければ、本業務処理はＥｘｉｔしてもＯＫとしてtrue を返す
            if (m_bWorkFlg)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            //Do Nothing;
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーン生成ファクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csPrjID)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySScreenFactory スクリーンファクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySScreenFactory GetScreenFactory()
        { 
            return this.m_csScreenFactory;
        }

        // ★★
        // ToDo　コールバックに対応する処理が必要な場合に処理を追加する
        // ★★

        

        /// <summary>一貫番号 </summary>
        static protected long m_lPrmNo = 0;
    }
}
