﻿// <summary>ソースコード：ＨＹＭＣＯライブラリ管理ドラッグ＆ドロップデータ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer.Data
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ管理ドラッグ＆ドロップデータ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>ライブラリ管理画面からのドラッグ＆ドロップ操作時のドラッグデータを格納</para>
    /// <para>本クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/11/09][新規作成]</para>
    /// </remarks>
    [Serializable]
    internal class McDragData : HySDataRoot
    {
        /// <summary>モデル情報区分</summary>
        private DragModelKind m_eModelKind;

        /// <summary>モデル情報 </summary>
        private McModelInfo m_csModelInfo;

        /// <summary>モデル情報区分</summary>
        public enum DragModelKind
        {
            /// <summary>演算要素</summary>
            CALC_MODEL,
            /// <summary>入力要素</summary>
            INPUT_MODEL,
            /// <summary>出力要素</summary>
            OUTPUT_MODEL,
            /// <summary>要素接続</summary>
            TRANS_MODEL

        }

        /// <summary><para>property outline:</para>
        /// <para>モデル情報区分の取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csDragData.Kind</para>
        /// </example>
        /// <value>モデル情報区分</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public DragModelKind Kind
        {
            get
            {
                return m_eModelKind;
            }
            set
            {
                m_eModelKind = value;
            }
        }

        /// <summary><para>property outline:</para>
        /// <para>モデル情報の取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csDragData.Model</para>
        /// </example>
        /// <value>モデル情報</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelInfo Model
        {
            get
            {
                return m_csModelInfo;
            }
            set
            {
                m_csModelInfo = value;
            }
        }
    }
}
