﻿// <summary>ソースコード：ＨＹＭＣＯモデル管理画面ヒストリーデータ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer.Data
{
    /// <summary><para>class outline:</para>
    /// <para>モデル管理画面ヒストリーデータ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>モデル管理画面の画面操作時のUndo/Redo用復元情報を格納</para>
    /// <para>本クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/03][新規作成]</para>
    /// </remarks>
    [Serializable]
    internal class McHistoryData : HySDataRoot
    {
        /// <summary>操作区分</summary>
        private OperationKind m_eOperationKind = OperationKind.NON_CHANGE;

        /// <summary>操作親要素ID</summary>
        private HySIdentifier m_csParentID = null;

        /// <summary>ヒストリー情報</summary>
        private List<object> m_csHistoryData;

        /// <summary>操作区分</summary>
        public enum OperationKind
        {
            /// <summary>変更なし</summary>
            NON_CHANGE,
            /// <summary>削除・切り取り</summary>
            DELETE_CUT,
            /// <summary>要素名称設定</summary>
            CHANGE_NAME,
            /// <summary>貼り付け</summary>
            PASTE,
            /// <summary>要素配置</summary>
            PLACEMENT,
            /// <summary>要素接続</summary>
            ELEMENT_CONNECTION,
            /// <summary>要素移動</summary>
            ELEMENT_MOVE,
            /// <summary>端子移動</summary>
            PORT_MOVE,
            /// <summary>要素サイズ変更</summary>
            RESIZE,
            /// <summary>モデル設定（演算モデル）</summary>
            MODEL_SET_ELEMENT,
            /// <summary>モデル設定（入力モデル）</summary>
            MODEL_SET_INPUT,
            /// <summary>モデル設定（出力モデル）</summary>
            MODEL_SET_OUTPUT,
            /// <summary>モデル設定(伝送モデル）</summary>
            MODEL_SET_TRANS,
            /// <summary>モデル解除</summary>
            MODEL_CANCEL,
            /// <summary>要素回転</summary>
            ROTATION,
            /// <summary>グループ化</summary>
            GROUPING,
            /// <summary>グループ解除</summary>
            CANCELLATION_GROUPING,
            /// <summary>外部接続（受信）</summary>
            EXTERNAL_CONNECTION_RECEIVE,
            /// <summary>外部接続（送信）</summary>
            EXTERNAL_CONNECTION_SEND,
            /// <summary>プロパティ変更</summary>
            PROPERTY_CHANGE,
            /// <summary>最前面へ移動</summary>
            PILED_UP_TOP,
            /// <summary>最背面へ移動</summary>
            PILED_UP_BOTTOM,
            /// <summary>プロジェクト取り込み</summary>
            PROJECT_INCORPORATE,
            /// <summary>要素全回転</summary>
            ALLROTATION//[2010/01/07]追加
        }

        /// <summary><para>property outline:</para>
        /// <para>操作親要素IDの取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csHistoryData.ParentID</para>
        /// </example>
        /// <value>操作区分</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySIdentifier ParentID
        {
            get
            {
                return m_csParentID;
            }
            set
            {
                m_csParentID = value;
            }
        }

        /// <summary><para>property outline:</para>
        /// <para>操作区分の取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csHistoryData.Kind</para>
        /// </example>
        /// <value>操作区分</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public OperationKind Kind
        {
            get
            {
                return m_eOperationKind;
            }
            set
            {
                m_eOperationKind = value;
            }
        }

        /// <summary><para>property outline:</para>
        /// <para>ヒストリー情報の取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csHistoryData.HistoryData</para>
        /// </example>
        /// <value>ヒストリー情報</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<object> HistoryData
        {
            get
            {
                return m_csHistoryData;
            }
            set
            {
                m_csHistoryData = value;
            }
        }
    }
}
