﻿// <summary>ソースコード：ソースコード：ＨＹＭＣＯライブラリ管理画面フォームクラス</summary>
// <remarks>
// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
// </remarks>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer.Data;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ライブラリ管理画面フォーム</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetLibraryCtlForm : HySDotNetForm
    {
        //定数定義
        /// <summary>ライブラリプロパティ名称　「モデル名称」 </summary>
        static protected readonly String PROPERTY_MODELNAME = Properties.McDotNetViewerResources.PROPERTY_MODELNAME;
        /// <summary>ライブラリプロパティ名称　「作成者」 </summary>
        static protected readonly String PROPERTY_CREATOR = Properties.McDotNetViewerResources.PROPERTY_CREATOR;
        /// <summary>ライブラリプロパティ名称　「バージョン」 </summary>
        static protected readonly String PROPERTY_VERSION = Properties.McDotNetViewerResources.PROPERTY_VERSION;
        /// <summary>ライブラリプロパティ名称　「概要」 </summary>
        static protected readonly String PROPERTY_SUMMARY = Properties.McDotNetViewerResources.PROPERTY_SUMMARY;
        /// <summary>ライブラリプロパティ名称　「名称」 </summary>
        static protected readonly String PROPERTY_NAME = Properties.McDotNetViewerResources.PROPERTY_NAME;

        // ツリーノード生成用
        /// <summary>分類ノード名称</summary>
        static private readonly String NODE_CATEGORY = "Category";
        /// <summary>分類ノード名称</summary>
        static private readonly String NODE_LIBRARY = "Library";
        /// <summary>ライブラリID属性名称</summary>
        static private readonly String KEY_LIBRARY_ID = "LibraryID";
        /// <summary>モデル種別名称</summary>
        static private readonly String KEY_MODEL_KIND = "ModelKind";

        // アイコン関連
        /// <summary>アイコンファイル格納先パス　キー名称</summary>
        static private readonly String ENVINF_KEY_ICON_PATH = "ICON_FILE_PATH";
        /// <summary>フォルダクローズアイコン名　キー名称</summary>
        static private readonly String ENVINF_KEY_FOLDER_CLOSE_ICON = "FOLDER_CLOSE_ICON_FILE_NAME";
        /// <summary>フォルダオープンアイコン名　キー名称</summary>
        static private readonly String ENVINF_KEY_FOLDER_OPEN_ICON = "FOLDER_OPEN_ICON_FILE_NAME";
        /// <summary>アイコンファイル拡張子</summary>
        static private readonly String ICON_EXT = ".ico";
        /// <summary>デフォルトアイコン名</summary>
        static private readonly String ICON_DEFAULT = "Default";
        /// <summary>エラー用アイコン</summary>
        static private readonly String ICON_UNKNOWN = "Unknown";

        // 要素モデル詳細情報表示機能
        /// <summary>モデル解説書エラーメッセージ</summary>
        static private readonly String ERR_MSG_MODEL_MANUAL = McMessage.GetString("MC_MSG_ERROR_MODEL_MANUAL");
        /// <summary>モデル解説書エラーメッセージ</summary>
        static private readonly String ERR_MSG_MODEL_MANUAL_EXIST = McMessage.GetString("MC_MSG_ERROR_MANUAL_EXIST");
        /// <summary>要素モデル詳細表示機能メッセージタイトル</summary>
        static private readonly String TITLE_DISP_MODEL_MANUAL = McMessage.GetString("MC_MSG_TITLE_DISP_MODELMANUAL");

        /// <summary>ライブラリ管理 プロパティグリッド高さ</summary>
        static protected readonly int SUMMARY_ROW_HEIGHT = 48;
        ///// <summary>ライブラリ管理デフォルト画面 プロパティグリッド高さ</summary>
        //static protected readonly int DEFAULT_SUMMARY_ROW_HEIGHT = 48;

        /// <summary>ライブラリ管理 項目グリッド高さ</summary>
        //static protected readonly int ITEMROW_HEIGHT = 15;
        static protected readonly int ITEMROW_HEIGHT = 19;
        ///// <summary>ライブラリ管理デフォルト画面 項目グリッド高さ</summary>
        //static protected readonly int DEFAULT_ITEMROW_HEIGHT = 15;

        /// <summary>モデル情報 </summary>
        protected McModelInfo m_csModelInfo;
        /// <summary>付属イベント番号 </summary>
        protected long m_lSubEventNo;

        /// <summary>モデル名称プロパティ </summary>
        protected string m_sModelName;
        /// <summary>作成者プロパティ </summary>
        protected string m_sCreatorInf;
        /// <summary>バージョンプロパティ </summary>
        protected string m_sVersionInf;
        /// <summary>概要プロパティ </summary>
        protected string m_sSummaryInf;
        /// <summary>モデル設定/解除処理の有効/無効モード</summary>
        protected bool m_bModelAssignment;

        /// <summary>ライブラリインストール情報</summary>
        private McLibraryInstallInfoData m_csLibraryInstallInfoData;

        /// <summary>削除対象選択フラグ</summary>
        private bool m_bSelectedFlg = false;

        /// <summary>ライブラリ削除確認画面タイトル</summary>
        static private readonly string LIBDELETE_DLG_TITLE =
            Properties.McDotNetViewerResources.ResourceManager.GetString("LIBDELETE_DLG_TITLE");
        /// <summary>ライブラリ削除確認メッセージ「削除対象選択通知」 </summary>
        static private readonly string MSG_INFO_DELETE_LIBRARY_SELECT = McMessage.GetString("MC_MSG_INFO_DELETE_LIBRARY_SELECT");
        /// <summary>ライブラリ削除確認メッセージ「標準ライブラリ選択通知」 </summary>
        static private readonly string MSG_STOP_DELETE_LIBRARY_SELECT = McMessage.GetString("MC_MSG_STOP_DELETE_LIBRARY_SELECT");
        /// <summary>ライブラリ削除確認メッセージ「削除対象設定済み通知」 </summary>
        static private readonly string MSG_INFO_DELETE_LIBRARY_SELECTED = McMessage.GetString("MC_MSG_INFO_DELETE_LIBRARY_SELECTED");
        /// <summary>ライブラリ削除確認メッセージ「削除対象通知」 </summary>
        static private readonly string MSG_INFO_DELETE_LIBRARY_TARGET = McMessage.GetString("MC_MSG_INFO_DELETE_LIBRARY_TARGET");
        /// <summary>ライブラリ削除確認メッセージ「手動による削除依頼」 </summary>
        static private readonly string MSG_STOP_DELETE_LIBRARY_MANUAL = McMessage.GetString("MC_MSG_STOP_DELETE_LIBRARY_MANUAL");
        /// <summary>ライブラリ削除確認メッセージ「再起動後の削除確認」 </summary>
        static private readonly string MSG_INFO_DELETE_LIBRARY_AFTERREBOOT = McMessage.GetString("MC_MSG_INFO_DELETE_LIBRARY_AFTERREBOOT");
        /// <summary>ライブラリ削除確認メッセージ「CommonMP再起動依頼」 </summary>
        static private readonly string MSG_INFO_COMMONMP_REBOOT = McMessage.GetString("MC_MSG_INFO_COMMONMP_REBOOT");
        /// <summary>ライブラリ削除確認メッセージ「異常終了」 </summary>
        static private readonly string MSG_ERR_SETUP_DELETE_LIBRARY = McMessage.GetString("MC_MSG_ERR_SETUP_DELETE_LIBRARY");
        /// <summary>ライブラリ削除確認メッセージ「警告通知」 </summary>
        static private readonly string MSG_WARNING_DELETE_LIBRARY_FUNC = McMessage.GetString("MC_MSG_WARNING_DELETE_LIBRARY_FUNC");

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetLibraryCtlForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetLibraryCtlForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McDotNetLibraryCtlForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetLibraryCtlForm csDotNetForm = new McDotNetLibraryCtlForm(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetLibraryCtlForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetLibraryCtlForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            DataCompInit();                     // 概要説明欄初期化
            LibSetButton.Enabled = false;       // 設定ボタン
            Model_guide_button.Enabled = false; // モデル解説書ボタン
            m_lSubEventNo = McDefine.HYM_ELEMENT_MODEL_SET;//初期化
            this.ModelAssignment(false);   // モデル設定/解除処理無効
        }

        /// <summary><para>method outline:</para>
        /// <para>選択モデル情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelInfo csModelInfo = GetModelInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelInfo GetModelInfo()
        {
            McModelInfo csModel = null;

            if (LibSetButton.Enabled == true)
            {
                csModel= m_csModelInfo;
            }

            return csModel;

        }
        /// <summary><para>method outline:</para>
        /// <para>付属イベント番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lSubEventNo = GetSubEventNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>付属イベント番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetSubEventNo()
        {
            return m_lSubEventNo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>概要説明欄初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataCompInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataCompInit()
        {
            long lcount;
            DataGridViewRow row;

            /* 演算要素プロパティ初期表示 */
            for (lcount = 0; lcount < 4; lcount++)
            {
                DataGridView1.Rows.Add();
            }
            DataGridView1.Rows[0].Cells[0].Value = PROPERTY_MODELNAME;
            DataGridView1.Rows[1].Cells[0].Value = PROPERTY_CREATOR;
            DataGridView1.Rows[2].Cells[0].Value = PROPERTY_VERSION;
            DataGridView1.Rows[3].Cells[0].Value = PROPERTY_SUMMARY;
            row = DataGridView1.Rows[3];
            row.Height = SUMMARY_ROW_HEIGHT;
            DataGridView1.Rows[3].DefaultCellStyle.WrapMode = DataGridViewTriState.True;

            /* 入力方式プロパティ初期表示 */
            for (lcount = 0; lcount < 2; lcount++)
            {
                DataGridView2.Rows.Add();
            }
            DataGridView2.Rows[0].Cells[0].Value = PROPERTY_NAME;
            DataGridView2.Rows[1].Cells[0].Value = PROPERTY_SUMMARY;
            row = DataGridView2.Rows[1];
            row.Height = SUMMARY_ROW_HEIGHT + (ITEMROW_HEIGHT * 2);
            DataGridView2.Rows[1].DefaultCellStyle.WrapMode = DataGridViewTriState.True;

            /* 出力方式プロパティ初期表示 */
            for (lcount = 0; lcount < 2; lcount++)
            {
                DataGridView3.Rows.Add();
            }
            DataGridView3.Rows[0].Cells[0].Value = PROPERTY_NAME;
            DataGridView3.Rows[1].Cells[0].Value = PROPERTY_SUMMARY;
            row = DataGridView3.Rows[1];
            row.Height = SUMMARY_ROW_HEIGHT + (ITEMROW_HEIGHT * 2);
            DataGridView3.Rows[1].DefaultCellStyle.WrapMode = DataGridViewTriState.True;

            /* 伝送情報型プロパティ初期表示 */
            for (lcount = 0; lcount < 2; lcount++)
            {
                DataGridView4.Rows.Add();
            }
            DataGridView4.Rows[0].Cells[0].Value = PROPERTY_NAME;
            DataGridView4.Rows[1].Cells[0].Value = PROPERTY_SUMMARY;
            row = DataGridView4.Rows[1];
            row.Height = SUMMARY_ROW_HEIGHT + (ITEMROW_HEIGHT * 2);
            DataGridView4.Rows[1].DefaultCellStyle.WrapMode = DataGridViewTriState.True;

            // 選択解除
            DataGridView1.ClearSelection();
            DataGridView2.ClearSelection();
            DataGridView3.ClearSelection();
            DataGridView4.ClearSelection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素ツリー選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView1_AfterSelect( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
            //クリア処理
            PropertyDataCompInit();

            if (TreeView1.SelectedNode.Tag != null && e.Node.LastNode == null)
            {
                m_bSelectedFlg = true;
                //選択されたTreeNodeのTagからMcModelInfoを取得
                m_csModelInfo = (McModelInfo)TreeView1.SelectedNode.Tag;

                SetPropertyDataComp();
            }
            TreeView1.Refresh();
            DataGridView1.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
            DataGridView1.Rows[1].Cells[1].Value = m_sCreatorInf;   // 作成者プロパティ
            DataGridView1.Rows[2].Cells[1].Value = m_sVersionInf;   // バージョンプロパティ
            DataGridView1.Rows[3].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力方式ツリー選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView2_AfterSelect( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView2_AfterSelect(object sender, TreeViewEventArgs e)
        {
            //クリア処理
            PropertyDataCompInit();

            if (TreeView2.SelectedNode.Tag != null && e.Node.LastNode == null)
            {
                m_bSelectedFlg = true;
                //選択されたTreeNodeのTagからMcModelInfoを取得
                m_csModelInfo = (McModelInfo)TreeView2.SelectedNode.Tag;
                SetPropertyDataComp();
            }
            DataGridView2.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
            DataGridView2.Rows[1].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力方式ツリー選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView3_AfterSelect( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView3_AfterSelect(object sender, TreeViewEventArgs e)
        {
            //クリア処理
            PropertyDataCompInit();

            if (TreeView3.SelectedNode.Tag != null && e.Node.LastNode == null)
            {
                m_bSelectedFlg = true;
                //選択されたTreeNodeのTagからMcModelInfoを取得
                m_csModelInfo = (McModelInfo)TreeView3.SelectedNode.Tag;
                SetPropertyDataComp();
            }
            DataGridView3.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
            DataGridView3.Rows[1].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送情報型ツリー選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView4_AfterSelect( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView4_AfterSelect(object sender, TreeViewEventArgs e)
        {
            //クリア処理
            PropertyDataCompInit();

            if (TreeView4.SelectedNode.Tag != null && e.Node.LastNode == null)
            {
                m_bSelectedFlg = true;
                //選択されたTreeNodeのTagからMcModelInfoを取得
                m_csModelInfo = (McModelInfo)TreeView4.SelectedNode.Tag;
                SetPropertyDataComp();
            }
            DataGridView4.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
            DataGridView4.Rows[1].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素ツリーノードダブルクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView1_NodeMouseDoubleClick( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">TreeNodeMouseClickEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView1_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            Boolean bPutEvent = PutEventRequestSet(e);
            if (bPutEvent == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView1_NodeMouseDoubleClick",
                    Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" +
                    Properties.McDotNetViewerResources.STATEMENT_CONFIG + ")" );
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView1_NodeMouseDoubleClick", "イベント送信失敗(設定)");
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力方式ツリーノードダブルクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView2_NodeMouseDoubleClick( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">TreeNodeMouseClickEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView2_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            Boolean bPutEvent = PutEventRequestSet(e);
            if (bPutEvent == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView2_NodeMouseDoubleClick", 
                    Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" +
                    Properties.McDotNetViewerResources.STATEMENT_CONFIG + ")" );
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView2_NodeMouseDoubleClick", "イベント送信失敗(設定)");
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力方式ツリーノードダブルクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView3_NodeMouseDoubleClick( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">TreeNodeMouseClickEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView3_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            Boolean bPutEvent = PutEventRequestSet(e);
            if (bPutEvent == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView3_NodeMouseDoubleClick",
                    Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" +
                    Properties.McDotNetViewerResources.STATEMENT_CONFIG + ")" );
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView3_NodeMouseDoubleClick", "イベント送信失敗(設定)");
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送情報型ツリーノードダブルクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView4_NodeMouseDoubleClick( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">TreeNodeMouseClickEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView4_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            Boolean bPutEvent = PutEventRequestSet(e);
            if (bPutEvent == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView4_NodeMouseDoubleClick", 
                    Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" +
                    Properties.McDotNetViewerResources.STATEMENT_CONFIG + ")" );
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.TreeView4_NodeMouseDoubleClick", "イベント送信失敗(設定)");
            }
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>タブ切替</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl1_SelectedIndexChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (TabControl1.SelectedIndex)
            {
                case 0:     // 演算要素
                    m_lSubEventNo = McDefine.HYM_ELEMENT_MODEL_SET;
                    SetPropertyLibSetButton(DataGridView1.Rows[0].Cells[1].Value);
                    DataGridView1.ClearSelection();
                    SetSelectModelInfo(TreeView1);
                    break;
                case 1:     // 入力方式
                    m_lSubEventNo = McDefine.HYM_INPUT_DATA_SET;
                    SetPropertyLibSetButton(DataGridView2.Rows[0].Cells[1].Value);
                    DataGridView2.ClearSelection();
                    SetSelectModelInfo(TreeView2);
                    break;
                case 2:     // 出力方式
                    m_lSubEventNo = McDefine.HYM_OUTPUT_DATA_SET;
                    SetPropertyLibSetButton(DataGridView3.Rows[0].Cells[1].Value);
                    DataGridView3.ClearSelection();
                    SetSelectModelInfo(TreeView3);
                    break;
                case 3:     // 伝送情報型
                    m_lSubEventNo = McDefine.HYM_TRANSMISSION_INFORMATION_TYPE_SET;
                    SetPropertyLibSetButton(DataGridView4.Rows[0].Cells[1].Value);
                    DataGridView4.ClearSelection();
                    SetSelectModelInfo(TreeView4);
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LibSet( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LibSet(object sender, EventArgs e)
        {
            if (m_bModelAssignment == true)
            {
                // モデル設定/解除処理が有効
                Boolean bPutEvent = ((McDotNetLibraryCtlScreen)m_csScreen).PutEventRequestSet();
                if (bPutEvent == false)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.LibSet", 
                    Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" +
                    Properties.McDotNetViewerResources.STATEMENT_CONFIG + ")" );
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.LibSet", "イベント送信失敗(設定)");
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LibCancel( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LibCancel(object sender, EventArgs e)
        {
            if (m_bModelAssignment == true)
            {   // モデル設定/解除処理が有効
                Boolean bPutEvent = ((McDotNetLibraryCtlScreen)m_csScreen).PutEventRequestDel();
                if (bPutEvent == false)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.LibCancel", 
                    Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" +
                    Properties.McDotNetViewerResources.STATEMENT_CANCEL + ")" );
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.LibCancel", "イベント送信失敗(解除)");
                }
            }
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタンプロパティ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetPropertyLibSetButton(　)</para>
        /// </example>
        /// <param name="value">セルの値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetPropertyLibSetButton(object value)
        {
            //if (m_bModelAssignment == true)
            //{   // モデル設定/解除処理が有効
                if (value != null)
                {
                    LibSetButton.Enabled = true;        // [設定]ボタン有効
                }
                else
                {
                    LibSetButton.Enabled = false;       // [設定]ボタン無効
                }
            //}
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>概要説明欄プロパティ初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyDataCompInit(　)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropertyDataCompInit()
        {
            LibSetButton.Enabled = false;
            Model_guide_button.Enabled = false;
            m_sModelName = null;
            m_sCreatorInf = null;
            m_sVersionInf = null;
            m_sSummaryInf = null;
            m_bSelectedFlg = false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>概要説明欄プロパティ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetPropertyDataComp(　)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetPropertyDataComp()
        {
            //if (m_bModelAssignment == true)
            //{   // モデル設定/解除処理が有効
            LibSetButton.Enabled = true; // [設定]ボタン有効
            //}

            //プロパティ情報が設定されているかどうかチェック
            if (m_csModelInfo.GetModelName() != "") // モデル名称プロパティ格納
            {
                m_sModelName = m_csModelInfo.GetModelName().ToString();
            }
            if (m_csModelInfo.GetCreatorInf() != "") // 作成者プロパティ格納
            {
                m_sCreatorInf = m_csModelInfo.GetCreatorInf().ToString();
            }
            if (m_csModelInfo.GetVersionInf() != "") // バージョンプロパティ格納
            {
                m_sVersionInf = m_csModelInfo.GetVersionInf().ToString();
            }
            if (m_csModelInfo.GetSummaryInf() != "") // 概要プロパティ格納
            {
                m_sSummaryInf = m_csModelInfo.GetSummaryInf().ToString();
            }

            // 「モデル解説書」ボタンのマスク制御を行う
            SetPropertyModelGuideButton();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択モデル情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = SetSelectModelInfo( csTreeView )</para>
        /// </example>
        /// <param name="csTreeView">カレントTreeView</param>
        /// <returns>true:設定情報あり,false:設定情報なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean SetSelectModelInfo(TreeView csTreeView)
        {
            Model_guide_button.Enabled = false;
            if (csTreeView.SelectedNode == null)
            {
                return false;
            }

            if (csTreeView.SelectedNode.Tag != null)
            {
                m_csModelInfo = (McModelInfo)csTreeView.SelectedNode.Tag;
                SetPropertyModelGuideButton();
                return true;
            }
            return false;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ管理TreeView作成処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateTreeView( csDispLibTreeData )</para>
        /// </example>
        /// <param name="csDispLibTreeData">ライブラリ管理表示情報データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CreateTreeView(HySDataRoot csDispLibTreeData)
        {
            if (csDispLibTreeData == null)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.CreateTreeView", 
                    Properties.McDotNetViewerResources.STATEMENT_NO_TREEVIEW );
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm.CreateTreeView", "ツリービュー表示用のデータが存在しない");
                return;
            }

            // インストール情報の設定
            m_csLibraryInstallInfoData = ((McDispLibTreeData)csDispLibTreeData).GetLibraryInstallInfoData();

            //ライブラリ集約表示データからライブラリ分類データを取得する
            McLibCategoryData csLibCategoryData = ((McDispLibTreeData)csDispLibTreeData).GetLibCategoryData();

            //ライブラリ集約表示データから区分ごとのモデルリストを取得する
            McModelLibraryData csModelLibraryData = ((McDispLibTreeData)csDispLibTreeData).GetModelLibraryData();

            //--------取得したデータにて区分ごとのTreeViewを作成する処理--------//            

            //演算要素
            List<McLibInfoNode> csElementCategoryInfo =
                csLibCategoryData.GetChildNodeList((HySString)McModelLibraryDefine.DIVISION_CALCULATION_MODEL.GetString());
            HySDataLinkedList csCalModelInfo = csModelLibraryData.GetCalModelInfo();

            //TreeView表示用のデータnullでなければTreeViewにデータを追加する
            if (CheckDataList(csElementCategoryInfo, csCalModelInfo) == true)
            {
               AddTreeData(TreeView1, csElementCategoryInfo, csCalModelInfo);
            }

            //入力方式
            List<McLibInfoNode> csInputCategoryInfo =
                csLibCategoryData.GetChildNodeList((HySString)McModelLibraryDefine.DIVISION_INPUT_MODEL.GetString());
            HySDataLinkedList csInputModelnfo = csModelLibraryData.GetInputModelInfo();

            if (CheckDataList(csInputCategoryInfo, csInputModelnfo) == true)
            {
                AddTreeData(TreeView2, csInputCategoryInfo, csInputModelnfo);
            }

            //出力方式
            List<McLibInfoNode> csOutPutCategoryInfo =
                csLibCategoryData.GetChildNodeList((HySString)McModelLibraryDefine.DIVISION_OUTPUT_MODEL.GetString());
            HySDataLinkedList csOutputModelInfo = csModelLibraryData.GetOutputModelInfo();

            if (CheckDataList(csOutPutCategoryInfo, csOutputModelInfo) == true)
            {
                AddTreeData(TreeView3, csOutPutCategoryInfo, csOutputModelInfo);
            }

            //伝送情報
            List<McLibInfoNode> csTransCategoryInfo =
                csLibCategoryData.GetChildNodeList((HySString)McModelLibraryDefine.DIVISION_TRANSINFORMATION.GetString());
            HySDataLinkedList csTransModelInfo = csModelLibraryData.GetTranInfo();

            if (CheckDataList(csTransCategoryInfo, csTransModelInfo) == true)
            {
                AddTreeData(TreeView4, csTransCategoryInfo, csTransModelInfo);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>TreeView表示用データ追加処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddTreeData( csTreeView, csCategoryList, csModelList)
        /// </para>
        /// </example>
        /// <param name="csTreeView">ツリービュー</param>
        /// <param name="csCategoryList">ライブラリ分類データリスト</param>
        /// <param name="csModelList">各区分のモデルリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AddTreeData(TreeView csTreeView, List<McLibInfoNode> csCategoryList, HySDataLinkedList csModelList)
        {
            // ツリービューの初期化
            csTreeView.ImageList = new ImageList();
            csTreeView.Nodes.Clear();

            // カテゴリアイコンの追加
            AddCategoryIcon(csTreeView);

            HySDataLinkedList csAddModelList = new HySDataLinkedList();
            // ライブラリ分類データリストからカテゴリ、モデルライブラリのツリーノードを追加する
            AddLibInfoTreeData(csTreeView, csTreeView.Nodes, csModelList, csCategoryList, csAddModelList);

            // ライブラリ分類データリストに含まれていなかった各モデルライブラリのツリーノードを作成
            for (int iListCnt = 0; iListCnt < csModelList.GetCount(); iListCnt++)
            {
                McModelInfo csModelInfo = (McModelInfo)csModelList.GetData(iListCnt);
                // モデルの画面表示指定判定
                if (csModelInfo.GetLibraryDispMode() == false)
                {
                    continue;
                }

                // 既にノード生成済みかをチェック
                bool bTreeNodeCheck = IsCreatedModelTreeNode(csAddModelList, csModelInfo);
                if (bTreeNodeCheck)
                {
                    // 生成済みの場合にはスキップする
                    continue;
                }
                else
                {
                    TreeNode[] csCategoryTreeNodes = csTreeView.Nodes.Find(csModelInfo.GetClassification().ToString(), true);
                    int iNLength = csCategoryTreeNodes.Length;
                    //モデル情報のカテゴリに対応するツリーノードはあるか
                    if (iNLength == 0)
                    {
                        //ない場合･･･ルートの直下にモデルツリーノードを追加
                        AddModelNode(csTreeView, csTreeView.Nodes, csModelInfo, csAddModelList); 
                    }
                    else
                    {
                        //ある場合･･･カテゴリに対応するツリーノードの下にモデルツリーノードを追加
                        AddModelNode(csTreeView, csCategoryTreeNodes[0].Nodes, csModelInfo, csAddModelList);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>カテゴリアイコン追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCategoryIcon( csTreeView )
        /// </para>
        /// </example>
        /// <param name="csTreeView">アイコンを追加するノードコレクション</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AddCategoryIcon(TreeView csTreeView)
        {
            HySString csHomeDir = HySEnvInf.GetHomeDirectory();
            HySString csIconPath = HySEnvInf.GetEnvInf(ENVINF_KEY_ICON_PATH);
            HySString csFolderCloseIconName = HySEnvInf.GetEnvInf(ENVINF_KEY_FOLDER_CLOSE_ICON);
            HySString csFolderOpenIconName = HySEnvInf.GetEnvInf(ENVINF_KEY_FOLDER_OPEN_ICON);
            Icon csFolderCloseIcon = null;
            Icon csFolderOpenIcon = null;

            if ((object)csFolderCloseIconName == null || csFolderCloseIconName == string.Empty)
            {
                csFolderCloseIconName = new HySString(ICON_DEFAULT);
            }
            string sIconPath = csHomeDir.ToString() + csIconPath.ToString() + csFolderCloseIconName.ToString() + ICON_EXT;
            HySFile csFile = new HySFile(sIconPath);
            if (csFile.Exist() == true)
            {
                csFolderCloseIcon = new Icon(sIconPath);
            }
            else
            {
                sIconPath = null;
                sIconPath = csHomeDir.ToString() + csIconPath.ToString() + ICON_UNKNOWN + ICON_EXT;
                csFolderCloseIcon = new Icon(sIconPath);
            }
            if ((object)csFolderOpenIconName == null || csFolderOpenIconName == string.Empty)
            {
                csFolderOpenIconName = new HySString(ICON_DEFAULT);
            }
            sIconPath = csHomeDir.ToString() + csIconPath.ToString() + csFolderOpenIconName.ToString() + ICON_EXT;
            csFile = new HySFile(sIconPath);
            if (csFile.Exist() == true)
            {
                csFolderOpenIcon = new Icon(sIconPath);
            }
            else
            {
                sIconPath = null;
                sIconPath = csHomeDir.ToString() + csIconPath.ToString() + ICON_UNKNOWN + ICON_EXT;
                csFolderOpenIcon = new Icon(sIconPath);
            }

            csTreeView.ImageList.Images.Add(csFolderCloseIcon);
            csTreeView.ImageList.Images.Add(csFolderOpenIcon);
        }

        /// <summary><para>method method:</para>
        /// <para>ツリーノード生成確認処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Boolean IsCreateModelTreeNode(csAddModelList, csModelInfo)
        /// </para>
        /// </example>
        /// <param name="csAddModelList">追加したモデル情報リスト</param>
        /// <param name="csModelInfo">モデル情報</param>
        /// <returns>true:一致情報有, false:一致情報無</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean IsCreatedModelTreeNode(HySDataLinkedList csAddModelList, McModelInfo csModelInfo)
        {
            for (int iCount = 0; iCount < csAddModelList.GetCount(); iCount++)
            {
                McModelInfo csAddModel = (McModelInfo)csAddModelList.GetData(iCount);
                // ライブラリIDとモデル種別が一致した場合、等しいモデル情報である
                if ( (csAddModel.GetLibraryID().Equals(csModelInfo.GetLibraryID()) ) &&
                     (csAddModel.GetModelKind().Equals(csModelInfo.GetModelKind()) ) )
                {
                    return true;
                }
            }

            // 一致するモデルがない場合
            return false;
        }

        /// <summary>
        /// <para>method method:</para>
        /// <para>ライブラリ情報ツリーノード追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddLibInfoTreeData(csTreeView, csTreeNodeList, csModelList, csLibInfoNodeList, csAddModelList)
        /// </para>
        /// </example>
        /// <param name="csTreeView">ノードを追加するツリービュー</param>
        /// <param name="csTreeNodeList">ノードを追加するノードコレクション</param>
        /// <param name="csModelList">モデル情報リスト</param>
        /// <param name="csLibInfoNodeList">ライブラリ情報ノードリスト</param>
        /// <param name="csAddModelList">追加したモデル情報リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>
        /// ライブラリカテゴリ設定ファイルから読み込まれたカテゴリ、
        /// ライブラリの情報に対応するツリーノードを生成する
        /// </para>
        /// </remarks>
        private void AddLibInfoTreeData(TreeView csTreeView, TreeNodeCollection csTreeNodeList, HySDataLinkedList csModelList, List<McLibInfoNode> csLibInfoNodeList, HySDataLinkedList csAddModelList)
        {
            for (int iCount = 0; iCount < csLibInfoNodeList.Count; iCount++)
            {
                McLibInfoNode csChildNode = csLibInfoNodeList[iCount];
                // ノードがカテゴリノードの場合
                if (csChildNode.Type == NODE_CATEGORY)
                {
                    // カテゴリノードのツリーノードを追加
                    TreeNode csCategoryNode = AddCategoryNode(csTreeNodeList, csChildNode);
                    // カテゴリの子ノードリストをツリーノードに追加する
                    AddLibInfoTreeData(csTreeView, csCategoryNode.Nodes, csModelList, csChildNode.GetChildNodeList(), csAddModelList);
                }
                // ノードがライブラリノードの場合
                else if (csChildNode.Type == NODE_LIBRARY)
                {
                    HySString csLibraryID = csChildNode.GetAttribute(new HySString(KEY_LIBRARY_ID));
                    HySString csModelKind = csChildNode.GetAttribute(new HySString(KEY_MODEL_KIND));
                    // LibraryID,ModelKindが一致するモデル情報をモデル情報リストから検索
                    McModelInfo csModelInfo = FindModelInfo(csLibraryID, csModelKind, csModelList);
                    // モデルが見つかり、かつ表示対象ならばノードを追加
                    if ( (csModelInfo != null) && (csModelInfo.GetLibraryDispMode()) )
                    {
                        AddModelNode(csTreeView, csTreeNodeList, csModelInfo, csAddModelList);
                    }
                    
                }
            }
        }

        /// <summary><para>method method:</para>
        /// <para>モデル情報検索</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McModelInfo csModelInfo = FindModelInfo(csLibraryID, csModelKind, csModelList)
        /// </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリID文字列</param>
        /// <param name="csModelKind">モデル種別文字列</param>
        /// <param name="csModelList">モデル情報リスト</param>
        /// <returns>McModelInfo　モデル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// モデル情報リストから指定したライブラリID、モデル種別に対応するモデル情報を返却する。
        /// 見つからなかった場合はNullを返却する。
        /// </para>
        /// </remarks>
        private McModelInfo FindModelInfo(HySString csLibraryID, HySString csModelKind, HySDataLinkedList csModelList)
        {
            McModelInfo csRtnModel = null;

            // モデル情報リストからライブラリID、モデル種別が指定された文字列と一致するものを探す
            for (int iModelCount = 0; iModelCount < csModelList.GetCount(); iModelCount++)
            {
                McModelInfo csModelInfo = (McModelInfo)csModelList.GetData(iModelCount);
                
                // 一致するモデル情報があった場合
                if ((csLibraryID == csModelInfo.GetLibraryID().ToString()) &&
                     (csModelKind == csModelInfo.GetModelKind().ToString()))
                {
                    csRtnModel = csModelInfo;
                    break;
                }
            }

            return csRtnModel;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>カテゴリノード追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCategoryNode(csNodes, csCategoryNode)
        /// </para>
        /// </example>
        /// <param name="csNodes">ノードを追加するノードコレクション</param>
        /// <param name="csCategoryNode">カテゴリ情報</param>
        /// <returns>TreeNode 追加したカテゴリノード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private TreeNode AddCategoryNode(TreeNodeCollection csNodes, McLibInfoNode csCategoryNode)
        {
            //ライブラリ分類データのIDと名称を取得
            string sCategoryID = csCategoryNode.ID.ToString();
            string sCategoryName = csCategoryNode.Name.ToString();

            //ツリーにライブラリ分類ノードを追加
            TreeNode csNode = csNodes.Add(sCategoryID, sCategoryName);
            csNode.ImageIndex = 0;
            csNode.SelectedImageIndex = 0;

            return csNode;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルノード追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddModelIcon(TreeView csTreeView, McModelInfo csModelInfo)
        /// </para>
        /// </example>
        /// <param name="csTreeView">ノードを追加するツリービュー</param>
        /// <param name="csNodes">ノードを追加するツリーノードリスト</param>
        /// <param name="csModelInfo">モデル情報</param>
        /// <param name="csAddModelList">ノードを追加したモデル情報のリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AddModelNode(TreeView csTreeView, TreeNodeCollection csNodes, McModelInfo csModelInfo, HySDataLinkedList csAddModelList)
        {
            //ツリーにモデルのアイコンを追加後、ノードを追加
            string strIconKey = string.Empty;
            int iIndex = AddModelIcon(csTreeView, csModelInfo);

            string sModelKey = csModelInfo.GetModelKind().ToString();
            string sModelName = csModelInfo.GetModelName().ToString();

            TreeNode csNode = csNodes.Add(sModelKey, sModelName);
            csNode.ImageKey = csTreeView.ImageList.Images.Keys[iIndex];
            csNode.ImageIndex = iIndex;
            csNode.SelectedImageIndex = iIndex;

            //TagにModelInfoを持たせる（設定ボタン押下時にここからModelInfoを取得する）
            csNode.Tag = csModelInfo;

            // 追加モデルリストにモデル情報を追加
            csAddModelList.AddLast(csModelInfo);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルアイコン追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddModelIcon(TreeView csTreeView, McModelInfo csModelInfo)
        /// </para>
        /// </example>
        /// <param name="csTreeView">アイコンを追加するツリービュー</param>
        /// <param name="csModelInfo">モデル情報</param>
        /// <returns>int 追加したIconのリスト内インデックス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private int AddModelIcon(TreeView csTreeView, McModelInfo csModelInfo)
        {
            // モデル情報からアイコン名を取得して追加する
            HySString csHomeDir = HySEnvInf.GetHomeDirectory();
            HySString csIconPath = HySEnvInf.GetEnvInf(ENVINF_KEY_ICON_PATH);
            Icon csIcon = null;
            string sModelIcon = null;
            string sIconKey = csTreeView.ImageList.Images.Count.ToString();
            HySString csModelIcon = csModelInfo.GetIconName();
            if (((object)csModelIcon) == null)
            {
                sModelIcon = ICON_DEFAULT;
            }
            else
            {
                sModelIcon = csModelInfo.GetIconName().ToString();
                if (sModelIcon == null || sModelIcon == string.Empty)
                {
                    sModelIcon = ICON_DEFAULT;
                }
            }
            string sIconPath2 = csHomeDir.ToString() + csIconPath.ToString() + sModelIcon + ICON_EXT;
            HySFile csFile2 = new HySFile(sIconPath2);
            if (csFile2.Exist() == true)
            {
                try
                {
                    csIcon = new Icon(sIconPath2);
                }
                catch (Exception ex)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm", "AddModelIcon", 
                        ex.Message.ToString() + ": " + Properties.McDotNetViewerResources.STATEMENT_ICON_NAME + "{" + sIconPath2 + "}");
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm", "AddModelIcon", ex.Message.ToString() + ": Icon Name{" + sIconPath2 + "}");
                    sIconPath2 = null;
                    sIconPath2 = csHomeDir.ToString() + csIconPath.ToString() + ICON_UNKNOWN + ICON_EXT;
                    csIcon = new Icon(sIconPath2);
                }
            }
            else
            {
                sIconPath2 = null;
                sIconPath2 = csHomeDir.ToString() + csIconPath.ToString() + ICON_UNKNOWN + ICON_EXT;
                csIcon = new Icon(sIconPath2);
            }

            csTreeView.ImageList.Images.Add(sIconKey, csIcon);

            return csTreeView.ImageList.Images.Count - 1 ;
        }



        /// <summary><para>method outline:</para>
        /// <para>TreeView表示用データチェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Boolean bRtn = CheckDataList( csCategoryDataList, csDataLinkedList )
        /// </para>
        /// </example>
        /// <param name="csCategoryDataList">ライブラリ分類データリスト</param>
        /// <param name="csDataLinkedList">モデルデータリスト</param>
        /// <returns>true:正常データ, false:異常データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean CheckDataList(List<McLibInfoNode> csCategoryDataList, HySDataLinkedList csDataLinkedList)
        {
            if (csCategoryDataList == null || csDataLinkedList == null)
            {
                return false;
            }

            return true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面要求イベント送信（設定）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Boolean bRtn = PutEventRequestSet( csTreeView ) </para>
        /// </example>
        /// <param name="e">TreeNodeMouseClickEventArgs</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean PutEventRequestSet(TreeNodeMouseClickEventArgs e)
        {
            Boolean bRtn = false;
            if (m_bModelAssignment == true)
            {
                if ((e.Node.Tag != null) && (e.Node.IsSelected == true))
                {
                    bRtn = ((McDotNetLibraryCtlScreen)m_csScreen).PutEventRequestSet();
                }
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>モデル設定/解除の有効/無効設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelAssignment(bModelAssignment)</para>
        /// </example>
        /// <param name="bModelAssignment">モデル設定/解除処理の有効/無効フラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ModelAssignment(bool bModelAssignment)
        {
            // モデル設定/解除処理の有効/無効フラグ
            m_bModelAssignment = bModelAssignment;
            
            //// 設定ボタン
            //LibSetButton.Enabled = bModelAssignment;
            //// 解除ボタン
            //LibCancelButton.Enabled = bModelAssignment;

            ButtonPanel.Enabled = bModelAssignment;
            if (m_csModelInfo != null)
            {
                SetPropertyDataComp();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ツリー展開・折りたたみ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView_AfterExpandCollapse( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView_AfterExpandCollapse(object sender, TreeViewEventArgs e)
        {
            if (e.Node.IsExpanded == true)
            {
                e.Node.ImageIndex = 1;
                e.Node.SelectedImageIndex = 1;
            }
            else
            {
                e.Node.ImageIndex = 0;
                e.Node.SelectedImageIndex = 0;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ツリーアイテムドラッグ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TreeView_ItemDrag( sender, e )</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeView_ItemDrag(object sender, ItemDragEventArgs e)
        {
            if (LibSetButton.Enabled == true)
            {
                if (e.Button == MouseButtons.Left)
                {
                    McDragData csDragData = new McDragData();
                    if (TabControl1.SelectedIndex == 0)
                    {
                        csDragData.Kind = McDragData.DragModelKind.CALC_MODEL;
                        TreeView1.SelectedNode = (TreeNode)e.Item;
                    }
                    else if (TabControl1.SelectedIndex == 1)
                    {
                        csDragData.Kind = McDragData.DragModelKind.INPUT_MODEL;
                        TreeView2.SelectedNode = (TreeNode)e.Item;
                    }
                    else if (TabControl1.SelectedIndex == 2)
                    {
                        csDragData.Kind = McDragData.DragModelKind.OUTPUT_MODEL;
                        TreeView3.SelectedNode = (TreeNode)e.Item;
                    }
                    else if (TabControl1.SelectedIndex == 3)
                    {
                        csDragData.Kind = McDragData.DragModelKind.TRANS_MODEL;
                        TreeView3.SelectedNode = (TreeNode)e.Item;
                    }
                    csDragData.Model = m_csModelInfo;
                    DoDragDrop(csDragData, DragDropEffects.Copy);
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示中タブ変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispTabChange(iTabNo)</para>
        /// </example>
        /// <param name="iTabNo">表示タブNo</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DispTabChange(int iTabNo)
        {
            if ((iTabNo >= 0) && (iTabNo < 4))
            {
                // 表示中タブ変更
                TabControl1.SelectedIndex = iTabNo;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>ツリーデータ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McTreeData csTreeData = GetTreeData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTreeData  ツリーデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal McTreeData GetTreeData()
        {
            McTreeData csTreeData = new McTreeData();
            csTreeData.m_csTabName1 = new HySString(TabControl1.TabPages[0].Text);
            csTreeData.m_csTabName2 = new HySString(TabControl1.TabPages[1].Text);
            csTreeData.m_csTabName3 = new HySString(TabControl1.TabPages[2].Text);
            csTreeData.m_csTabName4 = new HySString(TabControl1.TabPages[3].Text);

            csTreeData.m_csTreeData1 = TreeView1;
            csTreeData.m_csTreeData2 = TreeView2;
            csTreeData.m_csTreeData3 = TreeView3;
            csTreeData.m_csTreeData4 = TreeView4;

            return csTreeData;
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_LIBRARY_0001,
                        ((HySDotNetViewer)((McDotNetLibraryCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル解説書ボタンプロパティ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetPropertyModelGuideButton()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetPropertyModelGuideButton()
        {
            // モデル解説書有無をチェックし、「モデル解説書」ボタンのマスク制御を行う
            if ((object)m_csModelInfo.GetManualFileName() != null)
            {
                Model_guide_button.Enabled = true;
            }
            else
            {
                Model_guide_button.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>モデル解説書クリックイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Model_guide_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Model_guide_button_Click(object sender, EventArgs e)
        {
            if (m_csModelInfo != null && (object)m_csModelInfo.GetManualFileName() != null)
            {
                string sModelGuideName = HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf("MODEL_MANUAL_FOLDER").ToString() + "\\" + m_csModelInfo.GetManualFileName().ToString();
                HySFile csModelGuideFile = new HySFile(sModelGuideName);
                if (csModelGuideFile.Exist() == false)
                {   // モデル解説書が存在しない場合
                    DispModelManualErrorMessage(
                        "McDotNetLibraryCtlForm.Model_guide_button_Click",
                        ERR_MSG_MODEL_MANUAL_EXIST + sModelGuideName
                        );
                    return;
                }

                try
                {   // モデル解説書オープン
                    Help.ShowHelp(((HySDotNetViewer)((McDotNetLibraryCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent, sModelGuideName);
                }
                catch
                {
                    DispModelManualErrorMessage( 
                        "McDotNetLibraryCtlForm.Model_guide_button_Click",
                        ERR_MSG_MODEL_MANUAL + sModelGuideName
                        );
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>モデル解説書エラーメッセージ出力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DispModelManualErrorMessage(methodName, message)</para>
        /// </example>
        /// <param name="methodName">メソッド名</param>
        /// <param name="message">エラーメッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispModelManualErrorMessage(string methodName, string message)
        {
            MessageBox.Show(
                message,
                TITLE_DISP_MODEL_MANUAL,
                MessageBoxButtons.OK,
                MessageBoxIcon.Error
                );
            HySLog.LogOut(
                HySLog.ONLINE,
                methodName,
                message); 
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリインストール情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLibraryInstallInfoData csLibraryInstallInfoData = GetLibraryInstallInfoData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリインストール情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLibraryInstallInfoData GetLibraryInstallInfoData()
        {
            return m_csLibraryInstallInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteLibrary() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DeleteLibrary()
        {
            HySString csDllName = null;
            HySDataLinkedList csModelInfoList = null;
            bool bRtn = false;
            try
            {
                // インストール情報が正常なデータであるかチェック
                if (m_csLibraryInstallInfoData.GetDataCheckFlg() == false)
                {
                    // 正常動作しない旨のメッセージ表示
                    MessageBox.Show(MSG_WARNING_DELETE_LIBRARY_FUNC, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
                }
                // 選択中のモデル情報取得
                bool bCheckSelected = this.CheckSelectedModelInfo();
                if (bCheckSelected == false)
                {
                    // 削除対象を選択する旨のメッセージ表示
                    DialogResult result = MessageBox.Show(MSG_INFO_DELETE_LIBRARY_SELECT, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                    if (result == DialogResult.OK)
                    {
                        return;
                    }
                }
                McModelInfo csDelModelInfo = this.GetSelectedModelInfo();
                HySString csModelKind = new HySString(csDelModelInfo.GetModelKind().ToString());
                // モデル識別子から対応するDLL名称を取得する
                m_csLibraryInstallInfoData.GetCalModelInfoLinkedDll(csModelKind, ref csDllName);
                // CommonMP標準ライブラリを選択しているかチェック
                bRtn = m_csLibraryInstallInfoData.CheckCMPStdDll(csDllName);
                if (bRtn == true)
                {
                    // 削除不可である旨のメッセージ表示
                    DialogResult result = MessageBox.Show(MSG_STOP_DELETE_LIBRARY_SELECT, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
                    if (result == DialogResult.OK)
                    {
                        return;
                    }
                }
                // 既に削除対象として設定されているかチェック
                bRtn = this.CheckTargetDllName(csDllName);
                if (bRtn == true)
                {
                    // 既に登録済みの場合
                    DialogResult result = MessageBox.Show(MSG_INFO_DELETE_LIBRARY_SELECTED, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                    if (result == DialogResult.OK)
                    {
                        return;
                    }

                }
                // DLLに含まれるモデル情報を取得する
                m_csLibraryInstallInfoData.GetDllIncludeCalModelInfo(csDllName, ref csModelInfoList);
                string sStr = "";
                for (long lLp = 0; lLp < csModelInfoList.GetCount(); lLp++)
                {
                    McModelInfo csWork = (McModelInfo)csModelInfoList.GetData(lLp);
                    sStr += csWork.GetModelName().ToString();
                    sStr += Environment.NewLine;
                }
                // ライブラリ入力機能にて登録していないモデルの場合
                HySDataLinkedList csImportFileInfo = null;
                m_csLibraryInstallInfoData.GetImportFileInfo(csDllName, ref csImportFileInfo);
                if (csImportFileInfo == null)
                {
                    // 手動削除する旨のメッセージを表示し、ライブラリ削除対象の設定は行わない
                    DialogResult result = MessageBox.Show(MSG_INFO_DELETE_LIBRARY_TARGET + Environment.NewLine + sStr + MSG_STOP_DELETE_LIBRARY_MANUAL,
                        LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
                    if (result == DialogResult.OK)
                    {
                        return;
                    }
                }
                // ライブラリ入力にて登録したモデルの場合
                DialogResult result2 = MessageBox.Show(MSG_INFO_DELETE_LIBRARY_TARGET + Environment.NewLine + sStr, LIBDELETE_DLG_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                if (result2 == DialogResult.OK)
                {
                    // 削除対象の設定
                    m_csLibraryInstallInfoData.SetTargetDllName(csDllName);
                    // 削除対象DLL名称の設定後、再起動を促すメッセージ表示
                    result2 = MessageBox.Show(MSG_INFO_DELETE_LIBRARY_AFTERREBOOT + Environment.NewLine + MSG_INFO_COMMONMP_REBOOT, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                    if (result2 == DialogResult.OK)
                    {
                        # region 再検討の為コメント化
                        //// 起動切り替えのメニューをマスク
                        //HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.NOTICE_LIBDEL_START);
                        //csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                        //if (false == this.PutEvent(csEvent))
                        //{
                        //    HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm", "DeleteLibrary", "PutEvent NOTICE_LIBDEL_START is failed.");
                        //    return;
                        //}
                        # endregion
                        return;
                    }
                }
                else
                {
                    // ユーザが削除処理を中止
                    return;
                }
            }
            catch (Exception ex)
            {
                // ログ出力/メッセージ表示
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm", "DeleteLibrary", 
                    Properties.McDotNetViewerResources.STATEMENT_LIB_DEL_EXCEP + Environment.NewLine + ex.ToString());
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlForm", "DeleteLibrary", "ライブラリ削除対象設定処理で例外発生:" + Environment.NewLine + ex.ToString());
                MessageBox.Show(MSG_ERR_SETUP_DELETE_LIBRARY, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>削除対象DLL名称の設定チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CheckTargetDllName(csDllName) </para>
        /// </example>
        /// <param name="csDllName">DLL名称</param>
        /// <returns>bool true:既に設定済み false:未設定</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CheckTargetDllName(HySString csDllName)
        {
            bool bRtn = false;
            // 既に削除対象として登録済みであるかチェック
            List<HySString> csList = m_csLibraryInstallInfoData.GetTargetDllName();
            for (int iLp = 0; iLp < csList.Count; iLp++)
            {
                HySString csRegistName = csList[iLp];
                if (csRegistName == csDllName)
                {
                    bRtn = true;
                    break;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>現在選択されているモデル情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ModelInfo csModelInfo = GetSelectedModelInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>現在選択されているモデル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelInfo GetSelectedModelInfo()
        {
            return m_csModelInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>削除対象モデルの選択チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CheckSelectedModelInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:選択済み false:未選択</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool CheckSelectedModelInfo()
        {
            return m_bSelectedFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面通知捕捉処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="m">Windowsメッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void WndProc(ref Message m)
        {
            const int WM_SYSCOMMAND = 0x0112;
            const int SC_MINIMIZE = 0xF020;
            const int SC_MAXIMIZE = 0xF030;
            // 最小化を検出し、最小化前の配置・形状情報を保存しておく
            if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MINIMIZE)
            {
                // 配置情報を保存
                Properties.Settings.Default.LibraryLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.LibraryClientSize = this.ClientSize;
            }
            else if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MAXIMIZE)
            {
                // Do Nothing
            }
            base.WndProc(ref m);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面クローズ時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.McDotNetLibraryCtlForm_FormClosing);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetLibraryCtlForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            // ウィンドウ情報を保存
            Properties.Settings.Default.LibraryWindowState = this.WindowState;
            if (this.WindowState == FormWindowState.Normal)
            {// 通常表示状態の場合(最小化状態の場合は、WndProc()にて保存済)
                // 配置情報を保存
                Properties.Settings.Default.LibraryLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.LibraryClientSize = this.ClientSize;
            }
            // 表示状態を保存
            if (this.Owner.WindowState != FormWindowState.Minimized)
            {
                Properties.Settings.Default.LibraryVisible = this.Visible;
            }
            // 外部ファイルに保存
            Properties.Settings.Default.Save();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ロード時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Load += new System.EventHandler(this.McDotNetLibraryCtlForm_Load);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetLibraryCtlForm_Load(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.LibraryLocation.X != -1 && Properties.Settings.Default.LibraryLocation.Y != -1)
            {
                // 保存情報をもとに配置情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.Location = Properties.Settings.Default.LibraryLocation;
            }
            if (Properties.Settings.Default.LibraryClientSize.Height != -1 && Properties.Settings.Default.LibraryClientSize.Width != -1)
            {
                // 保存情報をもとに形状情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.ClientSize = Properties.Settings.Default.LibraryClientSize;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Shown += new System.EventHandler(this.McDotNetLibraryCtlForm_Shown);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetLibraryCtlForm_Shown(object sender, EventArgs e)
        {
            long lCallBackNo = 70400;
            // 初回はデフォルト表示
            // 保存情報をもとに表示状態を復元
            this.Visible = Properties.Settings.Default.LibraryVisible;
            if (this.Visible == false)
            {
                // チェックオン状態の変更
                HySDotNetMainForm csMainForm = (HySDotNetMainForm)this.Owner;
                csMainForm.SetCheckOnFlg(lCallBackNo, false);
            }
            // 保存情報をもとにウィンドウ状態を復元
            //this.WindowState = Properties.Settings.Default.LibraryWindowState;
        }

    }
}
