﻿// <summary>ソースコード：ＨＹＭＣＯデータフォルダー格納先設定画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>データフォルダー格納先設定画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/09][新規作成]</para>
    /// </remarks>
    public partial class McDotNetDataFolderSetForm : HySDotNetForm
    {
        ///// <summary>ログ出力用クラス名称</summary>
        //static private readonly string CLASS_NAME = "McDotNetDataFolderSetForm";

        /// <summary>環境ファイル検索パス</summary>
        static private readonly HySString ENVFILE_PATH = new HySString("\\conf\\");
        /// <summary>環境ファイル検索パス</summary>
        static private readonly HySString DATA_IN_FILE = new HySString("CommonMPData.ini");

        /// <summary>
        /// メッセージボックスタイトル『プロジェクト管理機能』
        /// </summary>
        private static readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");

        /// <summary>フォルダ選択画面説明</summary>
        static private readonly string FOLDER_DLG_DESCRIPTION =
            Properties.McDotNetViewerResources.ResourceManager.GetString("FILE_DLG_SELECT_DATAFOLDER");

        ///// <summary>メッセージ「再起動」 </summary>
        //static private readonly string MSG_MSG_INFO_CHANGE_DATAFOLDER = "データフォルダが変更されました。本設定を有効にするには、再起動を行って下さい。";
        static private readonly string MSG_MSG_INFO_CHANGE_DATAFOLDER = McMessage.GetString("MC_MSG_INFO_CHANGE_DATAFOLDER");
        ///// <summary>メッセージ「保存失敗」 </summary>
        //static private readonly string MSG_MSG_ERROR_UPDATE_SETTINGFILE = "設定ファイルの更新に失敗いたしました。";
        static private readonly string MSG_MSG_ERROR_UPDATE_SETTINGFILE = McMessage.GetString("MC_MSG_ERROR_UPDATE_SETTINGFILE");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetDataFolderSetForm csDataFolderSetForm = new McDotNetDataFolderSetForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetDataFolderSetForm()
        {
            InitializeComponent();

            // ver1.6 データフォルダの履歴管理
            SetComboBox.Items.Add(HySEnvInf.GetDataHomeDirectory().ToString());
            for (int index = 1; index < 20; index++)
            {
                string item = HySEnvInf.GetDataHomeHistory(index);
                if (item == null || item.Length == 0)
                {
                    break;
                }
                SetComboBox.Items.Add(item);
            }
            SetComboBox.SelectedIndex = 0;
        }

        /// <summary><para>method outline</para>
        /// <para>「フォルダ参照」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FolderSet_Button.Click += new System.EventHandler(this.SelectFolder);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectFolder(object sender, EventArgs e)
        {
            // フォルダ参照画面作成
            FolderBrowserDialog csFolderBrowserDlg = new FolderBrowserDialog();
            // 画面設定
            csFolderBrowserDlg.Description = FOLDER_DLG_DESCRIPTION;

            // ver1.6 データフォルダの履歴管理
            if (SetComboBox.SelectedItem.ToString() == "")
            {
                csFolderBrowserDlg.SelectedPath = HySEnvInf.GetDataHomeDirectory().ToString();
            }
            else
            {
                csFolderBrowserDlg.SelectedPath = SetComboBox.SelectedItem.ToString();
            }
            csFolderBrowserDlg.ShowNewFolderButton = false;

            // フォルダ参照画面表示
            if (csFolderBrowserDlg.ShowDialog(this) == DialogResult.OK)
            {
                // ver1.6 データフォルダの履歴管理
                if (SetComboBox.SelectedItem.ToString() != csFolderBrowserDlg.SelectedPath)
                {
                    if (SetComboBox.Items[0].ToString() != HySEnvInf.GetDataHomeDirectory().ToString())
                    {
                        SetComboBox.Items.RemoveAt(0);
                    }
                    SetComboBox.Items.Insert(0, csFolderBrowserDlg.SelectedPath);
                    SetComboBox.SelectedIndex = 0;
                }
                // 設定ボタンの状態変更
                FolderSet_Button.Enabled = true;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>「設定」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FolderSet_Button.Click += new System.EventHandler(this.FolderSet);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FolderSet(object sender, EventArgs e)
        {
            // 定義ファイル更新
            // ver1.6 データフォルダの履歴管理
            if (SetComboBox.SelectedItem.ToString() != "")
            {
                // 新規データパス
                HySString csNewDataHomePath = new HySString(SetComboBox.SelectedItem.ToString());

                HySString csDataHomeIniFileName = HySEnvInf.GetHomeDirectory() + ENVFILE_PATH + DATA_IN_FILE;
                HySIniFile csIniFile = new HySIniFile(csDataHomeIniFileName);

                if (csIniFile.SetValue(new HySString("DATAHOME"), csNewDataHomePath, true) == 0)
                {// 更新成功
                    if (csNewDataHomePath.Equal(HySEnvInf.GetDataHomeDirectory()) == false)
                    {// データ変更有り、再起動メッセージ
                        MessageBox.Show(MSG_MSG_INFO_CHANGE_DATAFOLDER, MSGBOX_TITLE);
                    }
                }
                else
                {// 更新異常
                    MessageBox.Show(MSG_MSG_ERROR_UPDATE_SETTINGFILE, MSGBOX_TITLE);
                }
            }

            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>「キャンセル」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0011, null);
        }

        /// <summary><para>method outline</para>
        /// <para>プルダウン変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetComboBox_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            toolTip1.SetToolTip(SetComboBox, SetComboBox.Text);
        }
    }
}
