﻿// <summary>ソースコード：ＨＹＭＣＯライブラリ出力画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Diagnostics;
//★★★★★★★★★★★★★★★★★★★★★★★
// Ver1.4で追加(ライブラリ出力時のパス記憶機能)
//★★★★★★★★★★★★★★★★★★★★★★★
using System.Runtime.InteropServices;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ出力画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2009/12/09][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][修正]
    /// </para>
    /// </remarks>
    public partial class McDotNetLibraryExportForm : HySDotNetForm
    {
        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ出力時のパス記憶機能)
        //★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>class outline:</para>
        /// <para>FolderBrowser起動用クラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.4.0][2013/12/05][新規作成]</para>
        /// </remarks>
        public static class FolderBrowserLauncher
        {
            // 本クラスにより、選択済みのツリービュー項目へスクロールさせる
            const string _topLevelSearchString = "フォルダーの参照";// OSによって名称が異なるので要対策
            const int _dlgItemBrowseControl = 0;
            const int _dlgItemTreeView = 100;

            [DllImport("user32.dll", SetLastError = true)]
            static extern IntPtr FindWindow(string lpClassName, string LpWindowName);

            [DllImport("user32.dll")]
            static extern IntPtr GetDlgItem(IntPtr hDlg, int nIDDlgItem);

            [DllImport("user32.dll", CharSet = CharSet.Auto)]
            static extern IntPtr SendMessage(IntPtr hWnd, UInt32 Msg, IntPtr wParam, IntPtr lParam);

            private const int TV_FIRST = 0x1100;
            private const int TVM_SELECTITEM = (TV_FIRST + 11);
            private const int TVM_GETNEXTITEM = (TV_FIRST + 10);
            private const int TVM_GETITEM = (TV_FIRST + 12);
            private const int TVM_ENSUREVISIBLE = (TV_FIRST + 20);

            private const int TVGN_ROOT = 0x0;
            private const int TVGN_NEXT = 0x1;
            private const int TVGN_CHILD = 0x4;
            private const int TVGN_FIRSTVISIBLE = 0x5;
            private const int TVGN_NEXTVISIBLE = 0x6;
            private const int TVGN_CARET = 0x9;

            /// <summary><para>method outline</para>
            /// <para>FolderBrowserの表示処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>ShowFolderBrowser(dlg, parent);</para>
            /// </example>
            /// <param name="dlg">FolderBrowserDialogインスタンス</param>
            /// <param name="parent">親ウィンドウ</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public static DialogResult ShowFolderBrowser(FolderBrowserDialog dlg, IWin32Window parent)
            {
                DialogResult result = DialogResult.Cancel;
                int retries = 10;

                using (Timer t = new Timer())
                {
                    t.Tick += (s, a) =>
                    {
                        if (retries > 0)
                        {
                            --retries;
                            IntPtr hwndDlg = FindWindow((string)null, _topLevelSearchString);
                            if (hwndDlg != IntPtr.Zero)
                            {
                                IntPtr hwndFolderCtrl = GetDlgItem(hwndDlg, _dlgItemBrowseControl);
                                if (hwndFolderCtrl != IntPtr.Zero)
                                {
                                    IntPtr hwndTV = GetDlgItem(hwndFolderCtrl, _dlgItemTreeView);
                                    if (hwndTV != IntPtr.Zero)
                                    {
                                        IntPtr item = SendMessage(hwndTV, (uint)TVM_GETNEXTITEM, new IntPtr(TVGN_CARET), IntPtr.Zero);
                                        if (item != IntPtr.Zero)
                                        {
                                            SendMessage(hwndTV, TVM_ENSUREVISIBLE, IntPtr.Zero, item);
                                            retries = 0;
                                            t.Stop();
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {
                            t.Stop();
                            SendKeys.Send("{TAB}{TAB}{DOWN}{DOWN}{UP}{UP}");
                        }
                    };
                    t.Interval = 10;
                    t.Start();
                    result = dlg.ShowDialog(parent);
                }
                return result;
            }
        }

        /// <summary>クラス名文字列</summary>
        static private readonly string CLASS_NAME = "McDotNetLibraryExportForm";

        /// <summary>アーカイブ保存画面タイトル</summary>
        static private readonly string ARCHIVE_SAVE_DLG_TITLE = Properties.McDotNetViewerResources.ResourceManager.GetString("FILE_DLG_TITLE_SAVE_ARCHIVE");
        /// <summary>アーカイブ保存画面フィルター</summary>
        static private readonly string ACRHIVE_SAVE_DLG_FILTER = Properties.McDotNetViewerResources.ResourceManager.GetString("FILE_DLG_FILTER_ARCHIVE");
        /// <summary>フォルダ参照画面解説</summary>
        static private readonly string FOLDER_REF_DLG_DESCRIPTION = Properties.McDotNetViewerResources.ResourceManager.GetString("FILE_DLG_SELECT_PROJFLD");

        /// <summary>通常メッセージタイトル </summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_LIBRARY_REGISUT_SUPPORT");
        /// <summary>メッセージ「正常終了」 </summary>
        static private string MSG_COMPLETE_LIBRARY_EXPORT = McMessage.GetString("MC_MSG_INFO_COMPLETE_ARCHIVE");
        /// <summary>メッセージ「異常終了」 </summary>
        static private readonly string MSG_ERR_LIBRARY_EXPORT = McMessage.GetString("MC_MSG_ERROR_ARCHIVE");
        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ出力時のパス記憶機能)
        //★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary>識別フラグ</summary>
        private bool m_bPropertyFormFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetLibraryExportForm form = new McDotNetLibraryExportForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetLibraryExportForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetLibraryExportForm()
        {
            InitializeComponent();
            Archive_Button.Enabled = false;
            PropertyProjectInfoGroupBox.Enabled = false;
        }
        
        /// <summary><para>method outline</para>
        /// <para>「フォルダ参照」釦クリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FolderRef_Button.Click += new System.EventHandler(this.ReferFolder);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReferFolder(object sender, EventArgs e)
        {
            //★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ出力時のパス記憶機能)
            //★★★★★★★★★★★★★★★★★★★★★★★
            m_bPropertyFormFlg = false;
            // フォルダ参照画面作成
            FolderBrowserDialog folderBrowserDlg = CreateFolderBlowseDialog();

            // フォルダ参照画面表示
            //★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ出力時のパス記憶機能)
            //★★★★★★★★★★★★★★★★★★★★★★★
            if (FolderBrowserLauncher.ShowFolderBrowser(folderBrowserDlg, this) == DialogResult.OK)
            {
                ProjectFolderFullPath_TextBox.Text = folderBrowserDlg.SelectedPath;
                // プロジェクトフォルダ自体を取得
                string sPath = folderBrowserDlg.SelectedPath;
                // ファイル書出しによる前回値保存
                HySString homeDir = HySEnvInf.GetHomeDirectory();
                string sFilePath = homeDir.ToString() + "\\temp" + "\\SavePath.txt";
                HySFile csFile = new HySFile(sFilePath);
                csFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.READ_WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                csFile.WriteText(sPath);
                csFile.Close();
                // アーカイブ釦の状態変更
                UpdateArchiveButtonState();
            }
        }

        /// <summary><para>method outline</para>
        /// <para>「プロパティ画面プロジェクトをアーカイブに含める」チェックボックス変更時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.IncludePropertyPrjCheckBox.Click +=
        /// new System.EventHandler(this.IncludePropertyPrj_CheckedChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void IncludePropertyPrj_CheckedChanged(object sender, EventArgs e)
        {
            // プロパティ画面プロジェクトのフォルダ参照ボタンの状態を変更
            if (IncludePropertyPrjCheckBox.Checked == true)
            {   // チェック状態
                PropertyProjectInfoGroupBox.Enabled = true;
            }
            else
            {
                PropertyProjectInfoGroupBox.Enabled = false;
            }

            // 「アーカイブ」釦状態変更
            UpdateArchiveButtonState();
        }

        /// <summary><para>method outline</para>
        /// <para>プロパティ画面プロジェクト「フォルダ参照」釦押下時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.PropertyProjectFolderRef_Button.Click +=
        /// new System.EventHandler(this.ReferPropertyProjectFolder);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReferPropertyProjectFolder(object sender, EventArgs e)
        {
            //★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ出力時のパス記憶機能)
            //★★★★★★★★★★★★★★★★★★★★★★★
            m_bPropertyFormFlg = true;
            // フォルダ参照画面作成
            FolderBrowserDialog folderBrowserDlg = CreateFolderBlowseDialog();

            // フォルダ参照画面表示
            //★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ出力時のパス記憶機能)
            //★★★★★★★★★★★★★★★★★★★★★★★
            if (FolderBrowserLauncher.ShowFolderBrowser(folderBrowserDlg, this) == DialogResult.OK)
            {
                PropertyProjectFolderFullpath_TextBox.Text = folderBrowserDlg.SelectedPath;
                // プロジェクトフォルダ自体を取得
                string sPath = folderBrowserDlg.SelectedPath;
                // ファイル書出しによる前回値保存
                HySString homeDir = HySEnvInf.GetHomeDirectory();
                string sFilePath = homeDir.ToString() + "\\temp" + "\\SavePath_Property.txt";
                HySFile csFile = new HySFile(sFilePath);
                csFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.READ_WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                csFile.WriteText(sPath);
                csFile.Close();
                // アーカイブ釦の状態変更
                UpdateArchiveButtonState();
            }
        }
        
        /// <summary><para>method outline:</para>
        /// <para>「アーカイブ」釦クリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Archive_Button.Click += new System.EventHandler(this.Archive);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        private void Archive(object sender, EventArgs e)
        {
                // プロジェクト名称取得
                string projectName = GetProjectName();

                // アーカイブ保存画面設定
                SaveFileDialog saveFileDlg = new SaveFileDialog();
                saveFileDlg.FileName = projectName + ".zip";
                saveFileDlg.InitialDirectory = CreateSelectFolderFullPath();
                saveFileDlg.Title = ARCHIVE_SAVE_DLG_TITLE;
                saveFileDlg.Filter = ACRHIVE_SAVE_DLG_FILTER;
                saveFileDlg.RestoreDirectory = true; 

                // アーカイブ保存画面表示
                if (saveFileDlg.ShowDialog() == DialogResult.OK)
                {
                    // アーカイブ出力実行
                    Archive(saveFileDlg.FileName);
                    // 画面を閉じる
                    this.Close();
                }
        }
        
        /// <summary><para>method outline</para>
        /// <para>「キャンセル」釦クリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>アーカイブ出力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Archive(archiveFileFullPath)</para>
        /// </example>
        /// <param name="archiveFileFullPath">アーカイブファイル出力先パス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Archive(string archiveFileFullPath)
        {
            const string methodName = "Archive";

            try
            {
                // プロセス開始情報作成
                ProcessStartInfo processInfo = CreateProcessStartInfo(archiveFileFullPath);

                // ライブラリ出力CUI起動
                Process process = Process.Start(processInfo);
                StringBuilder stdMessage = new StringBuilder(process.StandardOutput.ReadToEnd());
                StringBuilder errMessage = new StringBuilder(process.StandardError.ReadToEnd());

                // プロセスが終了するまで無期限に待機する
                process.WaitForExit();

                // メッセージボックスの設定
                int returnVal = process.ExitCode;
                if (returnVal == 0)
                {   // 正常終了
                    MessageBox.Show(
                        MSG_COMPLETE_LIBRARY_EXPORT,
                        MSGBOX_TITLE,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Information
                        );
                }
                else
                {   // 異常終了
                    MessageBox.Show(
                        GetCUIResultErrorMessage(returnVal),
                        MSGBOX_TITLE,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error
                        );
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, methodName,
                        Properties.McDotNetViewerResources.STATEMENT_STANDARD_OUT + stdMessage.ToString() + "\r\n" 
                        + Properties.McDotNetViewerResources.STATEMENT_STANDARD_ERR_OUT + errMessage.ToString());
                   // HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, methodName,
                   //     "標準出力:" + stdMessage.ToString() + "\r\n" + "標準エラー出力:" + errMessage.ToString());
                }
            }
            catch (System.Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                ExceptionalCase(
                    methodName,
                    Properties.McDotNetViewerResources.STATEMENT_LIBINFO_OUTPUT_ERR + CreateCommandLine(archiveFileFullPath) + Environment.NewLine + ex.ToString()
                    );
               // ExceptionalCase(
               //     methodName,
               //     "ライブラリ出力で例外発生: " + CreateCommandLine(archiveFileFullPath) + Environment.NewLine + ex.ToString()
               //     );
            }
            finally
            {
                // 画面を閉じる
                this.Close();
            }
        }

        /// <summary><para>method outline</para>
        /// <para>プロジェクト名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string projectName = GetProjectName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロジェクト名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private string GetProjectName()
        {
            string projectName = "";
            string prjFolderFullPath = ProjectFolderFullPath_TextBox.Text;
            if (prjFolderFullPath.EndsWith(":\\"))
            {   // ドライブ名を指定された場合は空文字を返却する
                return projectName;
            }

            // プロジェクト名を取り出す
            // 「\xxx\yyy\」のようにパスの最後が"\"で指定された場合を考慮し、
            // splitPathの最後の要素が空白の場合は最後から2番目の要素を返却する
            string[] splitPath = prjFolderFullPath.Split('\\');
            if (splitPath[splitPath.Length - 1] == "")
            {   // 最後の要素が空白の場合
                projectName = splitPath[splitPath.Length - 2];
            }
            else
            {
                projectName = splitPath[splitPath.Length - 1];
            }

            return projectName;
        }

        /// <summary><para>method outline</para>
        /// <para>ライブラリ出力CUIパス作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string cuiPath = CreateLibraryExportCuiFullPath()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリ出力CUIパス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>CommonMPのホームディレクトリからの相対パスを作成する。</para>
        /// </remarks>
        private string CreateLibraryExportCuiFullPath()
        {
            return HySEnvInf.GetEnvInf("CUI_EXECUTE").ToString();
        }
        
        /// <summary><para>method outline</para>
        /// <para>コマンドライン引数作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string commnadLine = CreateCommandLine(archiveFileFullPath)</para>
        /// </example>
        /// <param name="archiveFileFullPath">アーカイブ出力先</param>
        /// <returns>コマンドライン引数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>引数間は半角スペースで区切られる</para>
        /// </remarks>
        private string CreateCommandLine(string archiveFileFullPath)
        {
            // 以下の順でコマンドラインを作成する
            // (1) "-a"
            // (2) プロジェクトフォルダフルパス
            // (3) アーカイブファイル出力先フルパス
            // (4) "--property-project"(プロパティ画面をアーカイブに含める場合指定)
            // (5) プロパティ画面プロジェクトフォルダパス((プロパティ画面をアーカイブに含める場合指定))
            // (6) "-os" (開発コードをアーカイブに含める場合に指定)
            StringBuilder commandLine = new StringBuilder();
            commandLine.Append("-a");
            commandLine.Append(" ");
            commandLine.Append(HySFileUtility.FormatPath(ProjectFolderFullPath_TextBox.Text));
            commandLine.Append(" ");
            commandLine.Append(HySFileUtility.FormatPath(archiveFileFullPath));

            if (IncludePropertyPrjCheckBox.Checked)
            {   // プロパティ画面をアーカイブに含める場合 
                commandLine.Append(" ");
                commandLine.Append("--property-project");
                commandLine.Append(" ");
                commandLine.Append(HySFileUtility.FormatPath(PropertyProjectFolderFullpath_TextBox.Text));
            }

            if (IncludeDevSourceCheckBox.Checked)
            {   // 開発コードをアーカイブに含める場合
                commandLine.Append(" ");
                commandLine.Append("-os");
            }

            return commandLine.ToString();
        }

        /// <summary><para>method outline</para>
        /// <para>プロセス開始情報作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ProcessStartInfo processInfo = CreateProcessStartInfo(archiveFileFullPath)</para>
        /// </example>
        /// <param name="archiveFileFullPath">アーカイブ出力先パス</param>
        /// <returns>プロセス開始情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private ProcessStartInfo CreateProcessStartInfo(string archiveFileFullPath)
        {
            //----------------------------------
            // プロセス開始情報のプロパティ設定
            //----------------------------------
            ProcessStartInfo processInfo = new ProcessStartInfo();
            // ファイル名
            processInfo.FileName = CreateLibraryExportCuiFullPath();
            // コンソールウィンドウを開かない
            processInfo.CreateNoWindow = true;
            // シェル機能を使用しない
            processInfo.UseShellExecute = false;
            // 標準入力をリダイレクトしない
            processInfo.RedirectStandardInput = false;
            // 標準出力をリダイレクトする
            processInfo.RedirectStandardOutput = true;
            // エラー出力をリダイレクトする
            processInfo.RedirectStandardError = true;
            // コマンドライン引数設定
            processInfo.Arguments = CreateCommandLine(archiveFileFullPath);

            return processInfo;
        }

        /// <summary><para>method outline</para>
        /// <para>選択フォルダパス作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string selectFolderPath = CreateSelectFolderFullPath()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>選択フォルダパス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private string CreateSelectFolderFullPath()
        {
            HySString homeDir = HySEnvInf.GetHomeDirectory();
            DirectoryInfo dirinfo = Directory.GetParent(homeDir.ToString());
            return dirinfo.ToString();
        }

        /// <summary><para>method outline</para>
        /// <para>例外発生時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ExceptionalCase(method, message)</para>
        /// </example>
        /// <param name="methodName">メソッド名</param>
        /// <param name="message">出力メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ExceptionalCase(string methodName, string message)
        {
            // エラー内容をログ出力
            HySLog.LogOut(
                HySLog.ONLINE,
                CLASS_NAME,
                methodName,
                message
                );

            // エラーメッセージ表示
            MessageBox.Show(
                MSG_ERR_LIBRARY_EXPORT,
                MSGBOX_TITLE,
                MessageBoxButtons.OK,
                MessageBoxIcon.Error
                );
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_LIBRARY_0003,null);
        }

        /// <summary><para>method outline</para>
        /// <para>フォルダ参照画面作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FolderBrowserDialog folderBrowserDlg = CreateFolderBlowseDialog()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>フォルダ参照画面</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private FolderBrowserDialog CreateFolderBlowseDialog()
        {
            // フォルダ参照画面生成
            FolderBrowserDialog folderBrowserDlg = new FolderBrowserDialog();
            // 画面設定
            folderBrowserDlg.Description = FOLDER_REF_DLG_DESCRIPTION;
            //★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ出力時のパス記憶機能)
            //★★★★★★★★★★★★★★★★★★★★★★★
            HySString homeDir = HySEnvInf.GetHomeDirectory();
            string sFilePath = "";
            if (m_bPropertyFormFlg == false)
            {
                sFilePath = homeDir.ToString() + "\\temp" + "\\SavePath.txt";
            }
            else
            {
                sFilePath = homeDir.ToString() + "\\temp" + "\\SavePath_Property.txt";
            }
            HySFile csFile = new HySFile(sFilePath);
            if (csFile.Exist() == true)
            {
                csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                string sSelectedPath = null;
                csFile.ReadText(ref sSelectedPath);
                csFile.Close();
                folderBrowserDlg.SelectedPath = sSelectedPath;
                // パスの存在確認を行う。無ければ、デフォルト値を与える。
            }
            else
            {
                // 初回
                folderBrowserDlg.SelectedPath = Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory);
            }

            folderBrowserDlg.ShowNewFolderButton = false;

            return folderBrowserDlg;
        }

        /// <summary><para>method outline</para>
        /// <para>「アーカイブ」釦状態更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ChangeButtonCtlState()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面の状態からボタンコントロールのマスク制御を行う</para>
        /// </remarks>
        protected void UpdateArchiveButtonState()
        {
            // プロジェクトフォルダパスが入力済みか判定
            if (ProjectFolderFullPath_TextBox.Text == "")
            {   // 空白の場合
                Archive_Button.Enabled = false;
            }
            else
            {
                // プロパティ画面をアーカイブに含むか判定
                if (IncludePropertyPrjCheckBox.Checked == true)
                {
                    // プロパティ画面プロジェクトフォルダパスが入力済みか判定
                    if (PropertyProjectFolderFullpath_TextBox.Text != "")
                    {
                        Archive_Button.Enabled = true;
                    }
                    else
                    {
                        Archive_Button.Enabled = false;
                    }
                }
                else
                {
                    Archive_Button.Enabled = true;
                }
            }
        }
        
        /// <summary><para>method outline</para>
        /// <para>CUI実行結果メッセージ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string message = GetCUIResultErrorMessage(result)</para>
        /// </example>
        /// <param name="result"></param>
        /// <returns>CUI実行結果メッセージ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private string GetCUIResultErrorMessage(int result)
        {
            string message = MSG_ERR_LIBRARY_EXPORT;
            switch (result)
            {
                case (1):
                    // オプション不正
                    message = McMessage.GetString("MC_MSG_ERROR_OPTION");
                    break;
                case (2):
                    // アーカイブファイルパス不正
                    message = McMessage.GetString("MC_MSG_ERROR_ARCHIVE_FILE_PATH");
                    break;
                case (3):
                    // コマンド構文不正
                    message = McMessage.GetString("MC_MSG_ERROR_COMMAND_SYNTAX");
                    break;
                case (4):
                    // モデルプロジェクトの実行形式ファイル無し
                    message = McMessage.GetString("MC_MSG_ERROR_NOT_BIN_FILE");
                    break;
                case (5):
                    // モデルプロジェクトのアイコンファイル無し
                    message = McMessage.GetString("MC_MSG_ERROR_NOT_MODELICON_FILE");
                    break;
                case (6):
                    // プロジェクトフォルダパス不正
                    message = McMessage.GetString("MC_MSG_ERROR_PROJECT_FOLDER_PATH");
                    break;
                case (7):
                    // ファイル入力異常
                    message = McMessage.GetString("MC_MSG_ERROR_FILE_INPUT");
                    break;
                case (8):
                    // ファイルアクセス異常
                    message = McMessage.GetString("MC_MSG_ERROR_FILE_ACCESS");
                    break;
                case (11):
                    // プロパティプロジェクトフォルダパス不正
                    message = McMessage.GetString("MC_MSG_ERROR_PRPTYPRJ_FLDPATH");
                    break;
                case (12):
                    // プロパティ画面プロジェクトの実行形式ファイル無し
                    message = McMessage.GetString("MC_MSG_ERROR_NOT_PRPTYPRJ_BIN_FILE");
                    break;
                default:
                    break;
            }
            return message;
        }
    }
}