﻿// <summary>ソースコード：ＨＹＭＣＯライブラリ入力画面クラス</summary>
// <author>CommonMP</author>using System;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ入力画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2009/12/09][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][修正]
    /// </para>
    /// </remarks>
    public partial class McDotNetLibraryImportForm : HySDotNetForm
    {
        /// <summary>クラス名文字列</summary>
        static private readonly string CLASS_NAME = "McDotNetLibraryImportForm";

        /// <summary>ホームディレクトリからのライブラリ入力情報ファイルパス</summary>
        static private readonly string LIBRARY_IMPORT_INFO_FILE = @"temp\LibraryImportInfo";

        /// <summary>アーカイブ選択画面タイトル</summary>
        static private readonly string ARCHIVE_DLG_TITLE =
            Properties.McDotNetViewerResources.ResourceManager.GetString("FILE_DLG_TITLE_SELECT_ARCHIVE");
        /// <summary>アーカイブ選択画面フィルター</summary>
        static private readonly string ACRHIVE_DLG_FILTER =
            Properties.McDotNetViewerResources.ResourceManager.GetString("FILE_DLG_FILTER_ARCHIVE");

        /// <summary>通常メッセージタイトル </summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_LIBRARY_REGISUT_SUPPORT");
        /// <summary>メッセージ「ライブラリ入力情報ファイル作成完了」</summary>
        static private readonly string MSG_COMPLETE_CREATE_LIBRALY_INFO_FILE = McMessage.GetString("MC_MSG_INFO_RESTARTUP");

        /// <summary>メッセージ「異常終了」 </summary>
        static private readonly string MSG_ERR_LIBRARY_INSTALL = McMessage.GetString("MC_MSG_ERROR_INSTALL");

        /// <summary>上書き確認画面タイトル</summary>
        static private readonly string OVERWRITE_DLG_TITLE =
            Properties.McDotNetViewerResources.ResourceManager.GetString("OVERWRITE_DLG_TITLE");
        /// <summary>上書き確認メッセージ「異常終了」 </summary>
        static private readonly string MSG_ERR_LIBRARY_OVERWRITE = McMessage.GetString("MC_MSG_ERR_LIBRARY_OVERWRITE");
        /// <summary>上書き確認メッセージ「更新確認」 </summary>
        static private readonly string MSG_INFO_LIBRARY_OVERWRITE = McMessage.GetString("MC_MSG_INFO_LIBRARY_OVERWRITE");
        /// <summary>上書き確認メッセージ「標準ライブラリ名称と重複通知」 </summary>
        static private readonly string MSG_STOP_LIBRARY_OVERWRITE = McMessage.GetString("MC_MSG_STOP_LIBRARY_OVERWRITE");

        /// <summary>ライブラリインストール情報</summary>
        private McLibraryInstallInfoData m_csLibraryInstallInfoData;

        /// <summary>ライブラリ上書きチェック処理関連戻り値：正常（重複無し）</summary>
        public static readonly long NO_DUPLICATE = 0;

        /// <summary>ライブラリ上書きチェック処理関連戻り値：正常（同一名称有り）</summary>
        public static readonly long DUPLICATE_LIBNAME = 1;

        /// <summary>ライブラリ上書きチェック処理関連戻り値：正常（標準ライブラリと重複有り）</summary>
        public static readonly long DUPLICATE_STDLIBNAME = 2;

        /// <summary>ライブラリ上書きチェック処理関連戻り値：異常</summary>
        public static readonly long FAILED = -1;

        /// <summary>アーカイブ内情報</summary>
        List<HySStringRoot> m_csEntryList = null;

        /// <summary>DLL名称(モデルとプロパティ画面用DLLの2種類)</summary>
        List<HySString> m_csDllName = null;

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary>アーカイブ内情報管理ハッシュ</summary>
        private Hashtable m_csEntryListTbl = new Hashtable();

        /// <summary>DLL名称(モデルとプロパティ画面用DLLの2種類)管理ハッシュ</summary>
        private Hashtable m_csDllNameTbl = new Hashtable();

        /// <summary>メッセージ「既に登録済みです。」 </summary>
        static private readonly string MSG_ALREADY_REGISTERED = McMessage.GetString("MC_MSG_ALREADY_REGISTERED");

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetLibraryImportForm form = new McDotNetLibraryImportForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetLibraryImportForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetLibraryImportForm()
        {
            InitializeComponent();
            Install_Button.Enabled = false;
        }

        /// <summary><para>method outline</para>
        /// <para>「ファイル選択」釦クリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FileSelect_Button.Click += new System.EventHandler(this.SelectFile);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectFile(object sender, EventArgs e)
        {
            // アーカイブ選択画面設定
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.Title = ARCHIVE_DLG_TITLE;
            openFileDialog.Filter = ACRHIVE_DLG_FILTER;
            openFileDialog.InitialDirectory = CreateSelectFolderFullPath();
            openFileDialog.RestoreDirectory = true;
            //★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ入力機能の改良)
            //★★★★★★★★★★★★★★★★★★★★
            // 複数ファイル選択
            openFileDialog.Multiselect = true;

            // アーカイブ選択画面表示
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                //ArchiveFileFullPath_TextBox.Text = openFileDialog.FileName;
                //Install_Button.Enabled = true;
                //★★★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(ライブラリ入力機能の改良)
                //★★★★★★★★★★★★★★★★★★★★
                // 重複登録のチェック
                foreach (string str in openFileDialog.FileNames)
                {
                    //HySString csCheck = HySFileUtility.GetFileName(new HySString(openFileDialog.FileName));
                    HySString csCheck = HySFileUtility.GetFileName(new HySString(str));

                    HySString homeDir = HySEnvInf.GetHomeDirectory();
                    string fileFullPath = Path.Combine(homeDir.ToString(), LIBRARY_IMPORT_INFO_FILE);
                    HySFile csImportInfoFile = new HySFile(fileFullPath);
                    if (csImportInfoFile.Exist() == false)
                    {
                        // ファイル存在なし（初回）
                        // Do Nothing
                    }
                    else
                    {
                        // ファイル存在
                        csImportInfoFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        HySString text = new HySString();
                        while (csImportInfoFile.ReadText(ref text) != 0)
                        {
                            // ファイルの最後まで読み込み
                            text.Remove(0, 3);
                            HySString csInfo = new HySString(text.ToString());
                            HySString csCheck2 = HySFileUtility.GetFileName(csInfo);
                            if (csCheck.ToString() == csCheck2.ToString())
                            {
                                // 既に登録済み
                                MessageBox.Show(MSG_ALREADY_REGISTERED, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
                                csImportInfoFile.Close();
                                return;
                            }
                        }
                        csImportInfoFile.Close();
                    }
                    //if (ArchiveFileFullPath_listBox.Items.Contains(openFileDialog.FileName) == false)
                    if (ArchiveFileFullPath_listBox.Items.Contains(str) == false)
                    {// 重複登録のチェック
                        //ArchiveFileFullPath_listBox.Items.Add(openFileDialog.FileName);
                        ArchiveFileFullPath_listBox.Items.Add(str);
                        Install_Button.Enabled = true;
                    }
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>「インストール」釦クリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.InstallButton.Click += new System.EventHandler(this.Install);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Install(object sender, EventArgs e)
        {
            //★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ入力機能の改良)
            //★★★★★★★★★★★★★★★★★★★★
            long lRtn = NO_DUPLICATE;
            // 上書きチェック処理
            lRtn = this.CheckOverWrite();
            // ↓↓ メッセージは繰り返し表示しない ↓↓
            if (lRtn == FAILED)
            {
                DialogResult result = MessageBox.Show(MSG_ERR_LIBRARY_OVERWRITE, OVERWRITE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Stop, MessageBoxDefaultButton.Button1);
                if (result == DialogResult.OK)
                {
                    this.Close();
                    return;
                }
            }
            else if (lRtn == DUPLICATE_LIBNAME)
            {
                DialogResult result = MessageBox.Show(MSG_INFO_LIBRARY_OVERWRITE, OVERWRITE_DLG_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                if (result == DialogResult.Cancel)
                {
                    this.Close();
                    return;
                }
            }
            else if (lRtn == DUPLICATE_STDLIBNAME)
            {
                DialogResult result = MessageBox.Show(MSG_STOP_LIBRARY_OVERWRITE, OVERWRITE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button1);
                if (result == DialogResult.OK)
                {
                    this.Close();
                    return;
                }
            }

            // ライブラリ入力情報ファイル作成
            CreateLibraryImportInfoFile();

            // 展開対象情報の設定
            this.SetImportFileInfo();
            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>「キャンセル」釦クリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>ライブラリ入力情報ファイル作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateLibraryImportInfoFile(text)</para>
        /// </example>
        /// <param name="text">出力テキスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CreateLibraryImportInfoFile(string text)
        {
            const string methodName = "CreateLibraryImportInfoFile";

            try
            {
                //-----------------------------
                // ライブラリ入力情報書き込み
                //-----------------------------
                HySString homeDir = HySEnvInf.GetHomeDirectory();
                string fileFullPath = Path.Combine(homeDir.ToString(), LIBRARY_IMPORT_INFO_FILE);
                File.WriteAllText(fileFullPath, text, Encoding.Default);
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, methodName,
                    Properties.McDotNetViewerResources.STATEMENT_LIBINFO_WRT_ERR + Environment.NewLine + ex.ToString());
               // HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, methodName,
               //     "ライブラリ情報入力書込み処理で例外発生:" + Environment.NewLine + ex.ToString());
                MessageBox.Show(
                    MSG_ERR_LIBRARY_INSTALL,
                    MSGBOX_TITLE,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error
                    );
                return;
            }

            // 正常終了
            MessageBox.Show(
                MSG_COMPLETE_CREATE_LIBRALY_INFO_FILE,
                MSGBOX_TITLE,
                MessageBoxButtons.OK,
                MessageBoxIcon.Information
                );
            return;
        }

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline</para>
        /// <para>ライブラリ入力情報ファイル作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateLibraryImportInfoFile()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CreateLibraryImportInfoFile()
        {
            const string methodName = "CreateLibraryImportInfoFile";
            HySString homeDir = HySEnvInf.GetHomeDirectory();
            string fileFullPath = Path.Combine(homeDir.ToString(), LIBRARY_IMPORT_INFO_FILE);
            HySFile csImportInfoFile = new HySFile(fileFullPath);
            for (int iLP = 0; iLP < ArchiveFileFullPath_listBox.Items.Count; iLP++)
            {
                // CUI起動時のコマンドライン作成
                string commandLine = CreateCommandLine((string)ArchiveFileFullPath_listBox.Items[iLP]);
                try
                {
                    //-----------------------------
                    // ライブラリ入力情報書き込み
                    //-----------------------------

                    //複数のコマンドラインを追記できるように改善する
                    if (csImportInfoFile.Exist() == false)
                    {
                        // ファイル存在なし（初回）
                        csImportInfoFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        csImportInfoFile.WriteText(commandLine);
                    }
                    else
                    {
                        // ファイル存在
                        csImportInfoFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        csImportInfoFile.WriteText(commandLine);
                    }
                }
                catch (Exception ex)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, methodName,
                        Properties.McDotNetViewerResources.STATEMENT_LIBINFO_WRT_ERR +Environment.NewLine + ex.ToString());
                   // HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, methodName,
                   //     "ライブラリ情報入力書込み処理で例外発生:" + Environment.NewLine + ex.ToString());
                    MessageBox.Show(
                        MSG_ERR_LIBRARY_INSTALL,
                        MSGBOX_TITLE,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error
                        );
                    csImportInfoFile.Close();
                    return;
                }
            }

            // 正常終了
            MessageBox.Show(
                MSG_COMPLETE_CREATE_LIBRALY_INFO_FILE,
                MSGBOX_TITLE,
                MessageBoxButtons.OK,
                MessageBoxIcon.Information
                );
            csImportInfoFile.Close();
            return;
        }

        /// <summary><para>method outline</para>
        /// <para>コマンドライン引数作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string commnadLine = CreateCommandLine()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>コマンドライン引数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>引数間は半角スペースで区切られる</para>
        /// </remarks>
        private string CreateCommandLine()
        {
            // 以下の内容でコマンドラインを作成
            // (1) "-e"
            // (2) アーカイブファイルパス
            StringBuilder commandLineArgs = new StringBuilder();
            commandLineArgs.Append("-e");
            commandLineArgs.Append(" ");
            commandLineArgs.Append(HySFileUtility.FormatPath(ArchiveFileFullPath_TextBox.Text));

            return commandLineArgs.ToString();
        }

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline</para>
        /// <para>コマンドライン引数作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string commnadLine = CreateCommandLine()</para>
        /// </example>
        /// <param name="fullpath">フルパス</param>
        /// <returns>コマンドライン引数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>引数間は半角スペースで区切られる</para>
        /// </remarks>
        private string CreateCommandLine(string fullpath)
        {
            // 以下の内容でコマンドラインを作成
            // (1) "-e"
            // (2) アーカイブファイルパス
            StringBuilder commandLineArgs = new StringBuilder();
            commandLineArgs.Append("-e");
            commandLineArgs.Append(" ");
            commandLineArgs.Append(HySFileUtility.FormatPath(fullpath));

            return commandLineArgs.ToString();
        }

        /// <summary><para>method outline</para>
        /// <para>選択フォルダパス作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string selectFolderPath = CreateSelectFolderFullPath()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>選択フォルダパス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private string CreateSelectFolderFullPath()
        {
            HySString homeDir = HySEnvInf.GetHomeDirectory();
            DirectoryInfo dirinfo = Directory.GetParent(homeDir.ToString());
            return dirinfo.ToString();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_LIBRARY_0002, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリインストール情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLibraryInstallInfoData( csLibraryInstallInfoData )</para>
        /// </example>
        /// <param name="csLibraryInstallInfoData">ライブラリインストール情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLibraryInstallInfoData(McLibraryInstallInfoData csLibraryInstallInfoData)
        {
            m_csLibraryInstallInfoData = csLibraryInstallInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>展開対象情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetImportFileInfo(  )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetImportFileInfo()
        {
            //★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ入力機能の改良)
            //★★★★★★★★★★★★★★★★★★★★
            for (int iLP = 0; iLP < ArchiveFileFullPath_listBox.Items.Count; iLP++)
            {
                string sFileName = (string)ArchiveFileFullPath_listBox.Items[iLP];
                m_csEntryList = (List<HySStringRoot>)m_csEntryListTbl[sFileName];
                m_csDllName = (List<HySString>)m_csDllNameTbl[sFileName];

                HySDataLinkedList csList = new HySDataLinkedList();
                HySString csHomeDir = HySEnvInf.GetHomeDirectory();
                for (int iLp = 0; iLp < m_csEntryList.Count; iLp++)
                {
                    HySString csStr = (HySString)m_csEntryList[iLp];
                    bool binResult = csStr.ToString().EndsWith("dll");// GetDllName()にて頭文字bin\は削除されている
                    bool modelIconResult = csStr.ToString().StartsWith("ModelIcon\\");
                    bool modelManualResult = csStr.ToString().StartsWith("ModelManual\\");

                    if (binResult == true || modelIconResult == true || modelManualResult == true)
                    {
                        if (binResult == true)
                        {
                            // GetDllName()にて頭文字bin\は削除されている為付加する
                            csStr = new HySString("bin\\") + csStr;
                        }
                        csStr = csHomeDir + "\\" + csStr;
                        csList.AddLast(csStr);
                    }
                }
                for (int iLp = 0; iLp < m_csDllName.Count; iLp++)
                {
                    // モデルと固有プロパティ画面のDLL2つ取得された場合、展開対象情報は2つ生成される
                    m_csLibraryInstallInfoData.SetImportFileInfo(m_csDllName[iLp], csList);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>上書きチェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CheckOverWrite()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// NO_DUPLICATE:重複無し
        /// DUPLICATE_LIBNAME:同一名称有り
        /// DUPLICATE_STDLIBNAME:標準ライブラリと重複有り
        /// FAILED:異常
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long CheckOverWrite()
        {
            //★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(ライブラリ入力機能の改良)
            //★★★★★★★★★★★★★★★★★★★★
            long lRtn = NO_DUPLICATE;
            for (int iLP = 0; iLP < ArchiveFileFullPath_listBox.Items.Count; iLP++)
            {
                // リストから一つずつ取り出し
                string sFileName = (string)ArchiveFileFullPath_listBox.Items[iLP];
                HySString csArchiveFileFullPath = new HySString(sFileName);
                //HySString csDllName = null;
                HySDataLinkedList csModelInfoList = null;
                bool bRtn = false;
                // Zip内情報取得
                try
                {
                    HySExpander zipExpander = new HySDotNetZipExpander(csArchiveFileFullPath);
                    // エントリ名取得
                    m_csEntryList = zipExpander.GetAllEntryName();
                    // DLL名称取得
                    m_csDllName = this.GetDllName(m_csEntryList);
                    // ハッシュを使用して複数ライブラリ管理
                    m_csEntryListTbl[sFileName] = m_csEntryList;
                    m_csDllNameTbl[sFileName] = m_csDllName;
                    // DLL名称の重複チェック
                    for (int iLp = 0; iLp < m_csDllName.Count; iLp++)
                    {
                        m_csLibraryInstallInfoData.GetDllIncludeCalModelInfo(m_csDllName[iLp], ref csModelInfoList);
                        if (csModelInfoList != null)
                        {
                            // 同一名称有り
                            lRtn = DUPLICATE_LIBNAME;
                        }
                    }
                    for (int iLp = 0; iLp < m_csDllName.Count; iLp++)
                    {
                        // DLL名称のCommonMP標準ライブラリ名称との重複チェック
                        bRtn = m_csLibraryInstallInfoData.CheckCMPStdDll(m_csDllName[iLp]);
                        if (bRtn == true)
                        {
                            // CommonMP標準ライブラリ名称と重複
                            lRtn = DUPLICATE_STDLIBNAME;
                            // 問答無用で返す
                            return lRtn;
                        }
                    }
                }
                catch
                {
                    lRtn = FAILED;
                    // 問答無用で返す
                    return lRtn;
                }
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>アーカイブに含まれるDLL名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csDllName = GetDllName(entryList) </para>
        /// </example>
        /// <param name="entryList">エントリ名リスト</param>
        /// <returns><para>DLL名称リスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private List<HySString> GetDllName(List<HySStringRoot> entryList)
        {
            List<HySString> csRtnStr = new List<HySString>();
            for (int i = 0; i < entryList.Count; i++)
            {
                // エントリ名の要素を確認する
                // DLL名称を検索する
                HySString entry = (HySString)entryList[i];
                bool binResult = entry.ToString().StartsWith("bin\\");

                if (binResult == true)
                {
                    entry.Remove(0, 4);
                    csRtnStr.Add(entry);
                }
            }
            // DLL名称はモデルと固有プロパティ画面の2つ取得される可能性がある為、対応関係を記憶しておく
            m_csLibraryInstallInfoData.SetModelDllLinkedPrtyDll(csRtnStr);
            return csRtnStr;
        }

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline</para>
        /// <para>ドラッグエンターイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DragEnterEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DragEnterEvent(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Copy;
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }
        }

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline</para>
        /// <para>ドラッグドロップイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DragDropEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DragDropEvent(object sender, DragEventArgs e)
        {
            string[] fileName = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            string[] fileZipName = new string[fileName.Length];
            int iNum = 0;
            bool bflg = false;
            for (int iLp = 0; iLp < fileName.Length; iLp++)
            {
                string sChek = fileName[iLp];
                if (sChek.EndsWith(".zip") == true)
                {// 拡張子のチェック
                    if (ArchiveFileFullPath_listBox.Items.Contains(sChek) == false)
                    {// 重複登録のチェック
                        HySString csCheck = HySFileUtility.GetFileName(new HySString(sChek));

                        HySString homeDir = HySEnvInf.GetHomeDirectory();
                        string fileFullPath = Path.Combine(homeDir.ToString(), LIBRARY_IMPORT_INFO_FILE);
                        HySFile csImportInfoFile = new HySFile(fileFullPath);
                        if (csImportInfoFile.Exist() == false)
                        {
                            // ファイル存在なし（初回）
                            // Do Nothing
                        }
                        else
                        {
                            // ファイル存在
                            csImportInfoFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                            HySString text = new HySString();
                            while (csImportInfoFile.ReadText(ref text) != 0)
                            {
                                // ファイルの最後まで読み込み
                                text.Remove(0, 3);
                                HySString csInfo = new HySString(text.ToString());
                                HySString csCheck2 = HySFileUtility.GetFileName(csInfo);
                                if (csCheck.ToString() == csCheck2.ToString())
                                {
                                    // 既に登録済みで再起動待ち
                                    bflg = true;
                                    break;
                                }
                            }
                            csImportInfoFile.Close();
                        }
                        if (bflg != true)
                        {
                            fileZipName[iNum] = sChek;
                            iNum++;
                            // インストールボタンの活性化
                            Install_Button.Enabled = true;
                        }
                    }
                }
            }
            if (bflg == true)
            {
                // 既に登録済みで再起動待ち
                MessageBox.Show(MSG_ALREADY_REGISTERED, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }
            ArchiveFileFullPath_listBox.Items.AddRange(fileZipName);
        }

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline</para>
        /// <para>リスト情報のクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ListClear(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListClear(object sender, EventArgs e)
        {
            ArchiveFileFullPath_listBox.Items.Clear();
            // インストールボタンの非活性化
            Install_Button.Enabled = false;
        }
    }
}