﻿// <summary>ソースコード：>ＨＹＭＣＯアプリケーション起動時ライブラリ入力クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Diagnostics;

using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>アプリケーション起動時ライブラリ入力</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2010/1/29][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][メソッド追加][修正]
    /// </para>
    /// </remarks>
    public class McStartupLibraryImport
    {

        /// <summary>通常メッセージタイトル </summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_LIBRARY_REGISUT_SUPPORT");
        /// <summary>メッセージ「インストール開始」</summary>
        static private readonly string MSG_START_MESSAGE = McMessage.GetString("MC_MSG_INFO_IMPORT_LIBRARY_START");
        /// <summary>メッセージ「ライブラリ入力完了」</summary>
        static private readonly string MSG_INFO_COMPLETE_IMPORT = McMessage.GetString("MC_MSG_COMPLETE_LIBRARY_IMPORT");

        /// <summary>メッセージ「異常終了」 </summary>
        static private readonly string MSG_ERR_LIBRARY_INSTALL = McMessage.GetString("MC_MSG_ERROR_INSTALL");
        /// <summary>メッセージ「ライブラリ入力情報ファイル読み込み異常」</summary>
        static private readonly string MSG_ERR_READ_FILE = McMessage.GetString("MC_MSG_ERROR_READ_LIBRARY_FILE");

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ入力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Importlibrary() </para>
        /// </example>
        /// <param name="libraryImportInfoFile">ライブラリ入力情報ファイル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本メソッドはアプリケーション起動時にコールされることを想定しているため
        /// 環境情報クラス(HySEnvInf),ログクラス(HySLog)は使用しないこと</para>
        /// </remarks>
        static public void ImportLibrary(HySFile libraryImportInfoFile)
        {
        
            try
            {
                // ライブラリ入力開始メッセージ表示
                MessageBox.Show(
                    MSG_START_MESSAGE,
                    MSGBOX_TITLE,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information
                    );

                //------------------------------------
                // ライブラリ入力情報ファイル読み込み
                //------------------------------------
                //★★★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(ライブラリ入力機能の改良)
                //★★★★★★★★★★★★★★★★★★★★
                // libraryImportInfoをリストとする
                List<HySString> libraryImportInfo = new List<HySString>();
                long rtn = ReadLibraryImportInfo(libraryImportInfoFile, ref libraryImportInfo);
                if (rtn != 0)
                {   // ライブラリ入力情報読み込み失敗
                    MessageBox.Show(
                        MSG_ERR_READ_FILE,
                        MSGBOX_TITLE,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error
                    );
                    return;
                }

                //------------------------
                // ライブラリ入力CUI起動
                //------------------------
                //★★★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(ライブラリ入力機能の改良)
                //★★★★★★★★★★★★★★★★★★★★
                // 複数回（リストの個数分）プロセス起動
                // 戻り値を設けて正常・異常のメッセージを出す必要有り
                int iRtn = 0;
                for (int iLp = 0; iLp < libraryImportInfo.Count; iLp++)
                {
                    iRtn = ExecuteLibraryImport(libraryImportInfo[iLp]);
                    // 異常の場合、以降処理をやめるかどうか検討
                }
                if (iRtn == 0)
                {   // 正常終了
                    MessageBox.Show(
                        MSG_INFO_COMPLETE_IMPORT,
                        MSGBOX_TITLE, MessageBoxButtons.OK,
                        MessageBoxIcon.Information
                        );
                }
                else
                {   // 異常終了
                    MessageBox.Show(
                        GetCUIResultErrorMessage(iRtn),
                        MSGBOX_TITLE,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error
                        );
                }
            }
            catch
            {
                MessageBox.Show(
                        MSG_ERR_LIBRARY_INSTALL,
                        MSGBOX_TITLE,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error
                        );
                return;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ入力情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string ReadLibraryImportInfo =
        /// GetLibraryImportInfo(libraryImportInfoFile, out HySString libraryImportInfo) </para>
        /// </example>
        /// <param name="libraryImportInfoFile">ライブラリ入力情報ファイル</param>
        /// <param name="libraryImportInfo">ライブラリ入力情報(CUI起動時のコマンドライン引数)</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ライブラリ入力情報ファイルからテキストを読み込み返却する</para>
        /// </remarks>
        static private long ReadLibraryImportInfo(HySFile libraryImportInfoFile, out HySString libraryImportInfo)
        {

            //------------------------------------
            // ライブラリ入力情報ファイルオープン
            //------------------------------------
            libraryImportInfo = new HySString();
            long rtn = libraryImportInfoFile.Open(
                HySFile.OPEN_MODE.OPEN,
                HySFile.READ_WRITE_MODE.READ,
                HySFile.DIRECTORY_MODE.NOT_MK_DIR
                );
            if (rtn != 0)
            {
                return -1;
            }

            //---------------------
            // ファイル読み込み
            //---------------------
            HySString text = new HySString();
            rtn = libraryImportInfoFile.ReadText(ref text);
            if (rtn < 0)
            {
                return -1;
            }

            //---------------------
            // ファイルクローズ
            //---------------------
            rtn = libraryImportInfoFile.Close();
            if (rtn != 0)
            {
                return -1;
            }

            libraryImportInfo = text;
            return 0;
        }

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>ライブラリ入力情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string ReadLibraryImportInfo =
        /// GetLibraryImportInfo(libraryImportInfoFile, out HySString libraryImportInfo) </para>
        /// </example>
        /// <param name="libraryImportInfoFile">ライブラリ入力情報ファイル</param>
        /// <param name="libraryImportInfo">ライブラリ入力情報(CUI起動時のコマンドライン引数)</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ライブラリ入力情報ファイルからテキストを読み込み返却する</para>
        /// </remarks>
        static private long ReadLibraryImportInfo(HySFile libraryImportInfoFile, ref List<HySString> libraryImportInfo)
        {

            //------------------------------------
            // ライブラリ入力情報ファイルオープン
            //------------------------------------
            //libraryImportInfo = new List<HySString>();
            long rtn = libraryImportInfoFile.Open(
                HySFile.OPEN_MODE.OPEN,
                HySFile.READ_WRITE_MODE.READ,
                HySFile.DIRECTORY_MODE.NOT_MK_DIR
                );
            if (rtn != 0)
            {
                return -1;
            }
            //-----------------------------
            // ファイルから複数行を読み込み
            //-----------------------------
            HySString text = new HySString();
            while (libraryImportInfoFile.ReadText(ref text) != 0)
            {
                // ファイルの最後まで読み込み
                // リストに追加
                HySString csInfo = new HySString(text.ToString());
                libraryImportInfo.Add(csInfo);
            }
            //---------------------
            // ファイルクローズ
            //---------------------
            rtn = libraryImportInfoFile.Close();
            if (rtn != 0)
            {
                return -1;
            }

            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>CUI起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ExecuteLibraryImportCUI(commandLine) </para>
        /// </example>
        /// <param name="commnadLine">コマンドライン引数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static private void ExecuteLibraryImportCUI(HySString commnadLine)
        {
            try
            {

                // ライブラリ入力CUI起動
                ProcessStartInfo processInfo = CreateProcessStartInfo(commnadLine);
                Process process = Process.Start(processInfo);

                // プロセスが終了するまで無期限に待機する
                process.WaitForExit();

                // メッセージボックス表示
                int returnVal = process.ExitCode;
                if (returnVal == 0)
                {   // 正常終了
                    MessageBox.Show(
                        MSG_INFO_COMPLETE_IMPORT,
                        MSGBOX_TITLE, MessageBoxButtons.OK,
                        MessageBoxIcon.Information
                        );
                }
                else
                {   // 異常終了
                    MessageBox.Show(
                        GetCUIResultErrorMessage(returnVal),
                        MSGBOX_TITLE,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error
                        );
                }
            }
            catch 
            {
                 // 異常終了
                MessageBox.Show(
                    MSG_ERR_LIBRARY_INSTALL,
                    MSGBOX_TITLE,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error
                    );
            }
        }

        //★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(ライブラリ入力機能の改良)
        //★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>CUI起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ExecuteLibraryImport(commandLine) </para>
        /// </example>
        /// <param name="commnadLine">コマンドライン引数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static private int ExecuteLibraryImport(HySString commnadLine)
        {
            int iRtn = -1;
            try
            {

                // ライブラリ入力CUI起動
                ProcessStartInfo processInfo = CreateProcessStartInfo(commnadLine);
                Process process = Process.Start(processInfo);

                // プロセスが終了するまで無期限に待機する
                process.WaitForExit();

                // メッセージボックス表示
                int returnVal = process.ExitCode;
                if (returnVal == 0)
                {   // 正常終了
                    return 0;
                }
                else
                {   // 異常終了
                    return iRtn;
                }
            }
            catch
            {
                // 異常終了
                return iRtn;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>プロセス開始情報作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ProcessStartInfo processInfo = CreateProcessStartInfo(commandLine)</para>
        /// </example>
        /// <param name="commandLine">コマンドライン引数</param>
        /// <returns>プロセス開始情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static private ProcessStartInfo CreateProcessStartInfo(HySString commandLine)
        {
            //----------------------------------
            // プロセス開始情報のプロパティ設定
            //----------------------------------
            ProcessStartInfo processInfo = new ProcessStartInfo();
            // ファイル名
            processInfo.FileName = "hymco.exe";
            // コンソールウィンドウを開かない
            processInfo.CreateNoWindow = true;
            // シェル機能を使用しない
            processInfo.UseShellExecute = false;
            // 標準入力をリダイレクトしない
            processInfo.RedirectStandardInput = false;
            // 標準出力をリダイレクトする
            processInfo.RedirectStandardOutput = true;
            // エラー出力をリダイレクトする
            processInfo.RedirectStandardError = true;
            // コマンドライン引数設定
            processInfo.Arguments = commandLine.ToString();

            return processInfo;
        }

        /// <summary><para>method outline</para>
        /// <para>CUI実行結果エラーメッセージ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string message = GetCUIResultErrorMessage(result)</para>
        /// </example>
        /// <param name="result">CUI実行結果エラーコード</param>
        /// <returns>CUI実行結果エラーメッセージ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static private string GetCUIResultErrorMessage(int result)
        {
            string message = MSG_ERR_LIBRARY_INSTALL;
            switch (result)
            {
                case (3):
                    // コマンド構文不正
                    message = McMessage.GetString("MC_MSG_ERROR_COMMAND_SYNTAX");
                    break;
                case (7):
                    // ファイル入力異常
                    message = McMessage.GetString("MC_MSG_ERROR_FILE_INPUT");
                    break;
                case (8):
                    // ファイルアクセス異常
                    message = McMessage.GetString("MC_MSG_ERROR_FILE_ACCESS");
                    break;
                case (9):
                    // 入力ファイルパス不正
                    message = McMessage.GetString("MC_MSG_ERROR_INPUT_FILE_PATH");
                    break;
                case (10):
                    // サポート対象外データ
                    message = McMessage.GetString("MC_MSG_ERROR_NON_SUPARCHIVE");
                    break;
                default:
                    break;
            }
            return message;
        }
    }
}
