﻿// <summary>ソースコード：ＨＹＭＣＯ計算結果表示画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.OptionImpl.DefaultModel;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>計算結果表示画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/01/09][新規作成]</para>
    /// </remarks>
    public partial class McDotNetCalcResultDispForm : HySDotNetForm
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetCalcResultDispForm csCalcResultDispForm = new McDotNetCalcResultDispForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetCalcResultDispForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>参照処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>this.ButtonRef.Click += new System.EventHandler(this.FileOpen);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileOpen(object sender, EventArgs e)
        {
            // ダイアログ表示
            FileOpenDialog.Filter = "テキスト ファイル (*.txt;*.csv)|*.txt;*.csv|すべてのファイル (*.*)|*.*";
            if (DialogResult.OK == FileOpenDialog.ShowDialog())
            {
                // ファイル名セット
                TextFileName.Text = FileOpenDialog.SafeFileName;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グラフ表示処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>this.ButtonRef.Click += new System.EventHandler(this.GraphDisp);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphDisp(object sender, EventArgs e)
        {
            HySDataRoot m_csDispData;
            long lNumData = 0;
            HySLineGraphDataPrototype csHySLineGraphData = null;

            // 画面表示データ生成
            m_csDispData = new HySLineGraphDataPrototype(HySLineGraphDataPrototype.GRAPH_KIND.TIME_SERIES_DATA,
                                               HySLineGraphDataPrototype.GRAPH_FORM_KIND.GRAPH_LINE_DATA,
                                               lNumData);
            csHySLineGraphData = m_csDispData as HySLineGraphDataPrototype;
            if (TextFileName.Text.Length > 0)
            {  // 入力ファイルがある場合
                string FileName = FileOpenDialog.FileName; // 入力ファイルフルパス名
                HySFile csFile = new HySFile((new HySString(FileName)));
                csHySLineGraphData.ReadCSVFile(csFile);
                csHySLineGraphData.SetFileName(new HySString(TextFileName.Text));
            }

            // 表示イベント生成
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE,
                                                        HySEventObject.GRAPH_NOTICE_DISPLY_START, m_csDispData);
            csEvent.SetSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetSuppID(McDefaultModelDefine.DEFAULT_MODEL_LIB);
            csEvent.SetFrom(HySSysEvent.OBJID_SIMULATOR);
            csEvent.SetSubData(m_csScreen.GetID());
            m_csScreen.PutEvent(csEvent);
            Close(); // 画面を閉じる
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>テーブル表示処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>this.ButtonRef.Click += new System.EventHandler(this.TableDisp);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TableDisp(object sender, EventArgs e)
        {
            HySDataRoot m_csDispData;
            long lNumData = 0;

            // 画面表示データ生成
            m_csDispData = new HySLineGraphDataPrototype(HySLineGraphDataPrototype.GRAPH_KIND.TIME_SERIES_DATA,
                                                HySLineGraphDataPrototype.GRAPH_FORM_KIND.GRAPH_LIST_DATA,
                                                lNumData);
            if (TextFileName.Text.Length > 0)
            {  // 入力ファイルがある場合
                string FileName = FileOpenDialog.FileName; // 入力ファイルフルパス名
                HySFile csFile = new HySFile((new HySString(FileName)));
                HySLineGraphDataPrototype csHySLineGraphData = m_csDispData as HySLineGraphDataPrototype;
                csHySLineGraphData.ReadCSVFile(csFile);
                csHySLineGraphData.SetFileName(new HySString(TextFileName.Text));
            }
            // 表示イベント生成
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE,
                                                        HySEventObject.GRAPH_NOTICE_DISPLY_START, m_csDispData);
            csEvent.SetSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetSuppID(McDefaultModelDefine.DEFAULT_MODEL_LIB);
            csEvent.SetFrom(HySSysEvent.OBJID_SIMULATOR);
            csEvent.SetSubData(m_csScreen.GetID());
            m_csScreen.PutEvent(csEvent);
            Close(); // 画面を閉じる
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>this.ButtonRef.Click += new System.EventHandler(this.Close);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Close(object sender, EventArgs e)
        {
            Close();
        }
    }
}