﻿// <summary>ソースコード：ＨＹＭＣＯデータマージモデルプロパティ画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>データマージモデルプロパティ画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/17][新規作成]</para>
    /// </remarks>
    public partial class McDotNetDataMergeModelPropertyForm : HySDotNetForm, McModelPropertyFormIF
    {
        /// <summary>パラメータ情報</summary>
        private McDataMergePropertyInfo m_csPropertyInfo = null;

        /// <summary>テンポラリパラメータ情報</summary>
        private McDataMergePropertyInfo m_csTempPropertyInfo = null;

        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;

        /// <summary>接続情報</summary>
        protected long[][] m_lConnect = null;

        /// <summary>入力情報グリッドビュー</summary>
        private DataGridView[] m_csInputItemDataGrid = null;

		///<summary>『名称未設定』</summary>>
		static protected readonly String PROPERTY_UNSET_NAME = Properties.McDotNetViewerResources.PROPERTY_UNSET_NAME;
		///<summary>『入力情報なし』</summary>
		static protected readonly String PROPERTY_UNSET_INPUT_INFORMATION = Properties.McDotNetViewerResources.PROPERTY_UNSET_INPUT_INFORMATION;
		///<summary>『モデル情報不明』</summary>>
		static protected readonly String PROPERTY_UNSET_NAME_MODELINFO = Properties.McDotNetViewerResources.PROPERTY_UNSET_NAME_MODELINFO;
		///<summary>『モデル未設定』</summary>>
		static protected readonly String PROPERTY_UNSET_MODEL = Properties.McDotNetViewerResources.PROPERTY_UNSET_MODEL;
		///<summary>『マージモデル出力情報編集』</summary>>
        static protected readonly String TEXT_OUTPUT_ITEM_EDIT_OF_MERGE_MODEL = Properties.McDotNetViewerResources.TEXT_OUTPUT_ITEM_EDIT_OF_MERGE_MODEL;

		

        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetDataMergeModelPropertyForm csPropertyDetailForm = new McDotNetDataMergeModelPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetDataMergeModelPropertyForm()
        {
            InitializeComponent();

            OutputLinePictureBox.Image = new Bitmap(OutputLinePictureBox.Width, OutputLinePictureBox.Height);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McDataMergePropertyInfo csInfo)
        {
            m_csPropertyInfo = csInfo;
            m_csTempPropertyInfo = (McDataMergePropertyInfo)HySDataDuplicate.DupliCateData(m_csPropertyInfo);
            if (m_csPropertyInfo != null)
            {// モデルプロパティ情報がある場合
                if (m_csPropertyInfo.GetInputConnectionInfoList() != null)
                {// 入力接続の情報がある場合
                    m_csTempPropertyInfo.SetInputConnectionInfoList((HySDataLinkedList)HySDataDuplicate.DupliCateData(m_csPropertyInfo.GetInputConnectionInfoList()));
                }
                if (m_csPropertyInfo.GetOutputConnectionInfoList() != null)
                {// 出力接続の情報がある場合
                    m_csTempPropertyInfo.SetOutputConnectionInfoList((HySDataLinkedList)HySDataDuplicate.DupliCateData(m_csPropertyInfo.GetOutputConnectionInfoList()));
                }
            }

            ConnectInfoSet();
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary><para>method outline:</para>
        /// <para>接続情報編集</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ConnectInfoSet()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ConnectInfoSet()
        {
            if (m_csTempPropertyInfo == null)
            {// モデルプロパティ情報がある場合
                return;
            }
            HySDataCharacteristicInCell csOutputCellChara = m_csTempPropertyInfo.GetOutputCellCharacteristic();
            if (csOutputCellChara != null)
            {// 出力セル内データがある場合
                m_lConnect = new long[m_csTempPropertyInfo.GetOutputCellCharacteristic().GetDataNumber()][];

                McDataMergePropertyInfo.McMergeConnection csMergeConnection = m_csTempPropertyInfo.GetMergeConnection();

                HySDataLinkedList csInputInfoList = m_csTempPropertyInfo.GetInputConnectionInfoList();

                McCellArrayTranInfoPropertyInfo csConnectionPropertyInfo = null;
                for (int iLp = 0; iLp < csOutputCellChara.GetDataNumber(); iLp++)
                {// セル内変数数ループ
                    m_lConnect[iLp] = new long[2];

                    m_lConnect[iLp][0] = -1;
                    m_lConnect[iLp][1] = -1;

                    if ((csMergeConnection != null) &&
                        (csInputInfoList != null))
                    {// マージモデル内接続設定値および入力接続の情報がある場合
                        if ((csMergeConnection.GetConnectIdx()[iLp] >= 0) &&
                            (csMergeConnection.GetIdx(iLp) >= 0))
                        {// 接続設定がある場合
                            if (csInputInfoList.GetCount() != 0)
                            {// 入力接続の情報が０以外の場合
                                for (int iLp2 = 0; iLp2 < csInputInfoList.GetCount(); iLp2++)
                                {// 入力接続の情報数ループ
                                    csConnectionPropertyInfo = ((McModelInfo)csInputInfoList.GetData(iLp2)).GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                                    if (csConnectionPropertyInfo != null)
                                    {// プロパティ情報がある場合
                                        if (csMergeConnection.GetConnectElementID()[iLp].Equals(csConnectionPropertyInfo.GetUpperModelInfo().GetElementID()) == true)
                                        {// IDが一致した場合
                                            m_lConnect[iLp][0] = iLp2;
                                            m_lConnect[iLp][1] = csMergeConnection.GetIdx(iLp);
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            int iHeaderHeight = 25;
            int iRowHeight = 21;
            int iNextTopY = 10;
            string sLabelWork = "";
            string sUnitWork = "";

            // 画面表示情報編集
            ModelName.Text = m_csElementName.ToString();
            if (m_csTempPropertyInfo != null)
            {// 登録プロパティ情報がある場合
                if ((object)m_csTempPropertyInfo.GetID() == null)
                {// IDが設定されていない場合
                    ModelId.Text = "";
                }
                else
                {// IDが設定されている場合
                    ModelId.Text = m_csTempPropertyInfo.GetID().ToString();
                }

                // マージ間隔表示編集
                MergeSpan.Text = m_csTempPropertyInfo.GetStepTime().ToString();
                MergeSpanUnitComboBox.SelectedIndex = 0;
                
                // 入力情報表示編集
                InputItemScrollPanel.Controls.Clear();
                int iInputCount = (int)m_csTempPropertyInfo.GetInputConnectionNumber();
                if (iInputCount > 0)
                {// 受信接続数が０より大きい場合
                    Label csLabel = null;
                    m_csInputItemDataGrid = new DataGridView[iInputCount];
                    HySDataCharacteristicInCell[] csCharacteristicInCell = m_csTempPropertyInfo.GetInputCellCharacteristic();
                    HySDataLinkedList InputConnectionInfoList = m_csTempPropertyInfo.GetInputConnectionInfoList();
                    iNextTopY = 10;
                    int iLabelHeigth = 12;
                    int iDefaultWidth = DefaultInputItemDataGridView.Size.Width;
                    int iHeight = 0;
                    McCellArrayTranInfoPropertyInfo csConnectionPropertyInfo = null;
                    for (int iLp = 0; iLp < iInputCount; iLp++)
                    {// 受信接続数ループ
                        csConnectionPropertyInfo = ((McModelInfo)InputConnectionInfoList.GetData(iLp)).GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                        csLabel = new Label();
                        if (csConnectionPropertyInfo != null)
                        {// プロパティ情報がある場合
                            if ((csConnectionPropertyInfo.GetUpperModelInfo() != null)&&
                                (csConnectionPropertyInfo.GetUpperModelInfo().GetLibraryID().ToString() != ""))
                            {// 上流要素にモデルが設定されている場合
                                if (csConnectionPropertyInfo.GetUpperModelInfo().GetUserName().ToString() == "")
                                {// 名称設定がない場合
									csLabel.Text = PROPERTY_UNSET_NAME;
                                }
                                else
                                {// 名称設定がある場合
                                    csLabel.Text = csConnectionPropertyInfo.GetUpperModelInfo().GetUserName().ToString();
                                }
                            }
                            else
                            {// 上流要素にモデルが設定されていない場合
								csLabel.Text = PROPERTY_UNSET_MODEL;
                            }
                        }
                        else
                        {// プロパティ情報がない場合
							csLabel.Text = PROPERTY_UNSET_NAME_MODELINFO;
                        }
                        csLabel.Size = new Size(csLabel.Size.Width, iLabelHeigth);
                        csLabel.Location = new Point(3, iNextTopY);
                        InputItemScrollPanel.Controls.Add(csLabel);
                        iNextTopY = iNextTopY + csLabel.Size.Height + 3;
                        csLabel = new Label();
                        if (csConnectionPropertyInfo != null)
                        {// プロパティ情報がある場合
                            if ((csConnectionPropertyInfo.GetUpperModelInfo() != null) &&
                                (csConnectionPropertyInfo.GetUpperModelInfo().GetLibraryID().ToString() != ""))
                            {// 上流要素にモデルが設定されている場合
                                csLabel.Text = csConnectionPropertyInfo.GetUpperModelInfo().GetElementID().ToString();
                            }
                            else
                            {// 上流要素にモデルが設定されていない場合
								csLabel.Text = PROPERTY_UNSET_MODEL;
                            }
                        }
                        else
                        {// プロパティ情報がない場合
							csLabel.Text = PROPERTY_UNSET_NAME_MODELINFO;
                        }
                        csLabel.Size = new Size(csLabel.Size.Width, iLabelHeigth);
                        csLabel.Location = new Point(3, iNextTopY);
                        InputItemScrollPanel.Controls.Add(csLabel);
                        iNextTopY = iNextTopY + csLabel.Size.Height + 3;

                        m_csInputItemDataGrid[iLp] = new DataGridView();
                        m_csInputItemDataGrid[iLp].Location = new Point(3, iNextTopY);
                        if (csCharacteristicInCell[iLp] != null)
                        {// 入力側セル内情報設定値がある場合
                            iHeight = (int)csCharacteristicInCell[iLp].GetDataNumber() * iRowHeight + iHeaderHeight;
                        }
                        else
                        {// 入力側セル内情報設定値がない場合
                            iHeight = iHeaderHeight;
                        }
                        m_csInputItemDataGrid[iLp].Size = new Size(iDefaultWidth, iHeight);
                        m_csInputItemDataGrid[iLp].AllowUserToAddRows = false;
                        m_csInputItemDataGrid[iLp].AllowUserToDeleteRows = false;
                        m_csInputItemDataGrid[iLp].AllowUserToResizeColumns = false;
                        m_csInputItemDataGrid[iLp].AllowUserToResizeRows = false;
                        m_csInputItemDataGrid[iLp].ColumnHeadersDefaultCellStyle = DefaultInputItemDataGridView.ColumnHeadersDefaultCellStyle;
                        m_csInputItemDataGrid[iLp].ColumnHeadersHeightSizeMode = DataGridViewColumnHeadersHeightSizeMode.DisableResizing;
                        m_csInputItemDataGrid[iLp].MultiSelect = false;
                        m_csInputItemDataGrid[iLp].ReadOnly = true;
                        m_csInputItemDataGrid[iLp].RowHeadersVisible = false;
                        m_csInputItemDataGrid[iLp].RowHeadersWidthSizeMode = DataGridViewRowHeadersWidthSizeMode.DisableResizing;
                        m_csInputItemDataGrid[iLp].RowTemplate = DefaultInputItemDataGridView.RowTemplate;
                        m_csInputItemDataGrid[iLp].ScrollBars = ScrollBars.None;
                        m_csInputItemDataGrid[iLp].SelectionMode = DataGridViewSelectionMode.FullRowSelect;
                        m_csInputItemDataGrid[iLp].StandardTab = true;
                        m_csInputItemDataGrid[iLp].TabStop = false;
                        for (int iLp2 = 0; iLp2 < DefaultInputItemDataGridView.ColumnCount; iLp2++)
                        {// デフォルトリスト項目数ループ
                            m_csInputItemDataGrid[iLp].Columns.Add((DataGridViewColumn)DefaultInputItemDataGridView.Columns[iLp2].Clone());
                        }

                        // 表内情報編集
                        if (csCharacteristicInCell[iLp] != null)
                        {// 入力側セル内情報設定値がある場合
                            for (int iLp2 = 0; iLp2 < csCharacteristicInCell[iLp].GetDataNumber(); iLp2++)
                            {// セル内変数数ループ
                                m_csInputItemDataGrid[iLp].Rows.Add();
                                m_csInputItemDataGrid[iLp].Rows[m_csInputItemDataGrid[iLp].Rows.Count - 1].Cells[0].Value = iLp2.ToString();
                                csCharacteristicInCell[iLp].GetDataKind((long)iLp2, ref sLabelWork, ref sUnitWork);
                                m_csInputItemDataGrid[iLp].Rows[m_csInputItemDataGrid[iLp].Rows.Count - 1].Cells[1].Value = sLabelWork;
                                m_csInputItemDataGrid[iLp].Rows[m_csInputItemDataGrid[iLp].Rows.Count - 1].Cells[2].Value = sUnitWork;
                            }
                        }
                        InputItemScrollPanel.Controls.Add(m_csInputItemDataGrid[iLp]);

                        // コネクタ描画
                        if (csCharacteristicInCell[iLp] != null)
                        {// 入力側セル内情報設定値がある場合
                            PictureBox csConnector = null;
                            for (int iLp2 = 0; iLp2 < csCharacteristicInCell[iLp].GetDataNumber(); iLp2++)
                            {// セル内変数数ループ
                                csConnector = new PictureBox();
                                csConnector.BackColor = DefaultInputConnectorPictureBox.BackColor;
                                csConnector.Image = DefaultInputConnectorPictureBox.Image;
                                csConnector.Size = DefaultInputConnectorPictureBox.Size;
                                csConnector.SizeMode = DefaultInputConnectorPictureBox.SizeMode;
                                csConnector.Location = new Point(m_csInputItemDataGrid[iLp].Size.Width + 4, iNextTopY + iHeaderHeight + iLp2 * iRowHeight + 3);
                                InputItemScrollPanel.Controls.Add(csConnector);
                            }
                        }

                        iNextTopY = iNextTopY + iHeight + 15;
                    }

                    csLabel = new Label();
                    csLabel.Location = new Point(3, iNextTopY);
                    InputItemScrollPanel.Controls.Add(csLabel);
                    iNextTopY = iNextTopY + csLabel.Size.Height;

                    InputItemScrollBar.Minimum = 0;
                    InputItemScrollBar.Maximum = iNextTopY - 1;
                    InputItemScrollBar.Value = 0;
                    InputItemScrollBar.LargeChange = InputItemScrollPanel.Size.Height;
                }
                else
                {// 受信接続数が０以下の場合
                    Label csLabel = new Label();
					csLabel.Text = PROPERTY_UNSET_INPUT_INFORMATION;
                    csLabel.Location = new Point(3, 10);
                    InputItemScrollPanel.Controls.Add(csLabel);

                    InputItemScrollBar.Minimum = 0;
                    InputItemScrollBar.Maximum = 0;
                }

                // 出力情報表示編集
                PictureBox[] csOutputConnector = { OutputConnectorPictureBox1, OutputConnectorPictureBox2, OutputConnectorPictureBox3, OutputConnectorPictureBox4, OutputConnectorPictureBox5 };
                for (int iLp = 0; iLp < 5; iLp++)
                {// コネクター数ループ
                    csOutputConnector[iLp].Visible = false;
                }
                OutputItemDataGridView.Rows.Clear();
                HySDataCharacteristicInCell csOutputCellChara = m_csTempPropertyInfo.GetOutputCellCharacteristic();
                if (csOutputCellChara != null)
                {// 出力セル内データがある場合
                    // 表内情報編集
                    for (int iLp = 0; iLp < csOutputCellChara.GetDataNumber(); iLp++)
                    {// セル内変数数ループ
                        OutputItemDataGridView.Rows.Add();
                        OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[0].Value = iLp.ToString();
                        csOutputCellChara.GetDataKind((long)iLp, ref sLabelWork, ref sUnitWork);
                        OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[1].Value = sLabelWork;
                        OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[2].Value = sUnitWork;
                        if (iLp >= 5)
                        {// ５行以上の場合
                            OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Visible = false;
                        }
                    }

                    // コネクタ描画
                    for (int iLp = 0; iLp < csOutputCellChara.GetDataNumber(); iLp++)
                    {// セル内変数数ループ
                        if (iLp < 5)
                        {// カウンターが５以下の場合
                            csOutputConnector[iLp].Visible = true;
                        }
                    }

                    OutputItemScrollBar.Minimum = 0;
                    int iMaximum = (int)csOutputCellChara.GetDataNumber() - 1;
                    if (iMaximum < 0)
                    {// Maxが０未満の場合
                        iMaximum = 0;
                    }
                    OutputItemScrollBar.Maximum = iMaximum;
                    OutputItemScrollBar.Value = 0;
                }
                else
                {// 出力セル内データがない場合
                    OutputItemScrollBar.Minimum = 0;
                    OutputItemScrollBar.Maximum = 0;
                    OutputItemScrollBar.Value = 0;
                }

                InputLineScrollPanel.HorizontalScroll.Value = 0;
                InputLineScrollPanel.PerformLayout();

                // 入力側接続線描画
                McDataMergePropertyInfo.McMergeConnection csMergeConnection = m_csTempPropertyInfo.GetMergeConnection();
                Graphics csGraphics = null;
                Point csStartPoint = new Point();
                Point csEndPoint = new Point();
                Pen csDrawPen = null;
                int iWidth = InputLinePanel.Width;

                InputLinePictureBox.Location = new Point(0, 0);

                if (InputLinePictureBox.Image != null)
                {// イメージがある場合
                    InputLinePictureBox.Image.Dispose();
                }

                if (csOutputCellChara != null)
                {// 出力セル内データがある場合
                    if (csOutputCellChara.GetDataNumber() > 5)
                    {// セル内変数数が５より大きい場合
                        iWidth = InputLinePanel.Width + ((int)csOutputCellChara.GetDataNumber() - 5) * 24 + 1;
                    }
                }

                if (iNextTopY < InputLinePanel.Height)
                {// パネル高さより小さい場合
                    iNextTopY = InputLinePanel.Height;
                }

                InputLinePictureBox.Image = new Bitmap(iWidth, iNextTopY);

                if (iInputCount > 0)
                {// 受信接続数が０より大きい場合
                    csGraphics = Graphics.FromImage(InputLinePictureBox.Image);
                    csGraphics.Clear(Color.Transparent);

                    bool bConnectFlg = false;
                    for (int iLp = 0; iLp < iInputCount; iLp++)
                    {// 受信接続数ループ
                        for (int iLp2 = 0; iLp2 < m_csInputItemDataGrid[iLp].Rows.Count; iLp2++)
                        {// 受信情報行数ループ
                            csStartPoint.X = 0;
                            csStartPoint.Y = m_csInputItemDataGrid[iLp].Location.Y + iHeaderHeight + iLp2 * iRowHeight + iRowHeight / 2 - 1;
                            csEndPoint.X = InputLinePictureBox.Width - 10;
                            csEndPoint.Y = csStartPoint.Y;
                            if (csMergeConnection != null)
                            {// マージモデル内接続設定値がある場合
                                bConnectFlg = false;
                                for (int iLp3 = 0; iLp3 < csMergeConnection.GetIdxNum(); iLp3++)
                                {// インデックス数ループ
                                    if ((m_lConnect[iLp3][0] == iLp) &&
                                        (m_lConnect[iLp3][1] == iLp2))
                                    {// 接続情報があった場合
                                        bConnectFlg = true;
                                        break;
                                    }
                                }
                                if (bConnectFlg == true)
                                {// 接続情報があった場合
                                    csDrawPen = new Pen(Color.Blue, 1);
                                }
                                else
                                {// 接続情報がない場合
                                    csDrawPen = new Pen(Color.Gray, 1);
                                }
                            }
                            else
                            {// マージモデル内接続設定値がない場合
                                csDrawPen = new Pen(Color.Gray, 1);
                            }
                            csGraphics.DrawLine(csDrawPen, csStartPoint, csEndPoint);
                            csDrawPen.Dispose();
                        }
                    }

                    csGraphics.Dispose();
                }

                // 接続マーク描画
                if (ConnectionPictureBox.Image != null)
                {// イメージがある場合
                    ConnectionPictureBox.Image.Dispose();
                }

                ConnectionPictureBox.Image = new Bitmap(InputLinePictureBox.Width, InputLinePictureBox.Height);

                csGraphics = Graphics.FromImage(ConnectionPictureBox.Image);
                csGraphics.Clear(Color.Transparent);

                if (csMergeConnection != null)
                {// マージモデル内接続設定値がある場合
                    int iOutputCount = (int)csMergeConnection.GetIdxNum();
                    if (iOutputCount < 5)
                    {// インデックス数が５未満の場合
                        iOutputCount = 5;
                    }
                    for (int iLp = 0; iLp < csMergeConnection.GetIdxNum(); iLp++)
                    {// インデックス数ループ
                        if ((m_lConnect[iLp][0] >= 0) &&
                            (m_lConnect[iLp][1] >= 0))
                        {// 接続設定がある場合
                            csStartPoint.X = 22 + (iOutputCount - iLp - 1) * 24 - 5;
                            csStartPoint.Y = m_csInputItemDataGrid[m_lConnect[iLp][0]].Location.Y + iHeaderHeight + (int)m_lConnect[iLp][1] * iRowHeight + iRowHeight / 2 - 6;
                            csGraphics.FillEllipse(Brushes.Blue, csStartPoint.X, csStartPoint.Y, 10, 10);
                            csGraphics.DrawEllipse(Pens.Black, csStartPoint.X, csStartPoint.Y, 10, 10);
                        }
                    }
                }

                csGraphics.Dispose();

                // スクロールパネルリサイズ
                int iScrollPanelWidth = InputLinePanel.Width;
                int iScrollPanelHeight = InputLinePanel.Height;
                if (InputLinePictureBox.Height > InputLinePanel.Height)
                {// ピクチャーボックス高さがパネル高さより大きい場合
                    iScrollPanelWidth += 17;
                }
                if (InputLinePictureBox.Width > InputLinePanel.Width)
                {// ピクチャーボックス幅がパネル幅より大きい場合
                    iScrollPanelHeight += 17;
                }
                InputLineScrollPanel.Size = new Size(iScrollPanelWidth, iScrollPanelHeight);

                // 出力側接続線描画
                if (csOutputCellChara != null)
                {// 出力セル内データがある場合
                    csGraphics = Graphics.FromImage(InputLinePictureBox.Image);

                    int iOutputCount = (int)csOutputCellChara.GetDataNumber();
                    if (iOutputCount < 5)
                    {// インデックス数が５未満の場合
                        iOutputCount = 5;
                    }
                    for (int iLp = 0; iLp < csOutputCellChara.GetDataNumber(); iLp++)
                    {// インデックス数ループ
                        csStartPoint.X = 22 + (iOutputCount - iLp - 1) * 24;
                        csStartPoint.Y = 10;
                        csEndPoint.X = csStartPoint.X;
                        csEndPoint.Y = InputLinePictureBox.Height;
                        if (csMergeConnection != null)
                        {// マージモデル内接続設定値がある場合
                            if ((m_lConnect[iLp][0] >= 0) &&
                                (m_lConnect[iLp][1] >= 0))
                            {// 接続設定がある場合
                                csDrawPen = new Pen(Color.Blue, 1);
                            }
                            else
                            {// 接続設定がない場合
                                csDrawPen = new Pen(Color.Gray, 1);
                            }
                        }
                        else
                        {// マージモデル内接続設定値がない場合
                            csDrawPen = new Pen(Color.Gray, 1);
                        }
                        csGraphics.DrawLine(csDrawPen, csStartPoint, csEndPoint);
                        csDrawPen.Dispose();
                    }

                    csGraphics.Dispose();

                    EditOutputLine();
                }
            }
            else
            {// 登録プロパティ情報がない場合
                Label csLabel = new Label();
				csLabel.Text = PROPERTY_UNSET_NAME_MODELINFO;
                csLabel.Location = new Point(3, 10);
                InputItemScrollPanel.Controls.Add(csLabel);

                InputItemScrollBar.Minimum = 0;
                InputItemScrollBar.Maximum = 0;

                OutputItemScrollBar.Minimum = 0;
                OutputItemScrollBar.Maximum = 0;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力側接続線描画編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditOutputLine( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EditOutputLine()
        {
            Graphics csGraphics = Graphics.FromImage(OutputLinePictureBox.Image);
            csGraphics.Clear(Color.Transparent);

            int iWidth = OutputLinePictureBox.Width;
            int iHeight = OutputLinePictureBox.Height;
            Point[] csStartPoint1 = { new Point(118, 0), new Point(94, 0), new Point(70, 0), new Point(46, 0), new Point(22, 0) };
            Point[] csEndPoint1 = { new Point(118, iHeight - 96), new Point(94, iHeight - 75), new Point(70, iHeight - 54), new Point(46, iHeight - 33), new Point(22, iHeight - 12) };
            Point[] csStartPoint2 = { new Point(118, csEndPoint1[0].Y), new Point(94, csEndPoint1[1].Y), new Point(70, csEndPoint1[2].Y), new Point(46, csEndPoint1[3].Y), new Point(22, csEndPoint1[4].Y) };
            Point[] csEndPoint2 = { new Point(iWidth, csStartPoint2[0].Y), new Point(iWidth, csStartPoint2[1].Y), new Point(iWidth, csStartPoint2[2].Y), new Point(iWidth, csStartPoint2[3].Y), new Point(iWidth, csStartPoint2[4].Y) };
            Pen csDrawPen = null;
            int iLineCount = 1;
            for (int iLp = OutputItemScrollBar.Value; iLp < OutputItemDataGridView.Rows.Count; iLp++)
            {// 表示行から出力情報行数ループ
                if (OutputItemDataGridView.Rows[iLp].Visible == true)
                {// 行が表示設定の場合
                    if ((m_lConnect[iLp][0] >= 0) &&
                        (m_lConnect[iLp][1] >= 0))
                    {// 接続設定がある場合
                        csDrawPen = new Pen(Color.Blue, 1);
                    }
                    else
                    {// 接続設定がない場合
                        csDrawPen = new Pen(Color.Gray, 1);
                    }
                    csGraphics.DrawLine(csDrawPen, csStartPoint1[iLineCount - 1], csEndPoint1[iLineCount - 1]);
                    csGraphics.DrawLine(csDrawPen, csStartPoint2[iLineCount - 1], csEndPoint2[iLineCount - 1]);
                    csDrawPen.Dispose();

                    iLineCount++;
                    if (iLineCount > 5)
                    {// ５行表示編集の場合
                        break;
                    }
                }
            }

            csGraphics.Dispose();
            OutputLinePictureBox.Refresh();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フォームが最初に表示されたときの処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Form_Shown(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Form_Shown(object sender, EventArgs e)
        {
            // 選択解除
            for (int iLp = 0; iLp < InputItemScrollPanel.Controls.Count; iLp++)
            {// コントロール数ループ
                if (InputItemScrollPanel.Controls[iLp] is DataGridView)
                {// グリッドビューの場合
                    ((DataGridView)InputItemScrollPanel.Controls[iLp]).ClearSelection();
                }
            }

            OutputItemDataGridView.ClearSelection();

            if (InputLineScrollPanel.HorizontalScroll.Visible == true)
            {// スクロールバーが表示の場合
                InputLineScrollPanel.HorizontalScroll.Value = InputLineScrollPanel.HorizontalScroll.Maximum - InputLinePanel.Width;
                InputLineScrollPanel.PerformLayout();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力側スクロールバー操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>InputItemScrollBar_ValueChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void InputItemScrollBar_ValueChanged(object sender, EventArgs e)
        {
            InputItemScrollPanel.VerticalScroll.Value = InputItemScrollBar.Value;
            InputItemScrollPanel.PerformLayout();
            InputLineScrollPanel.VerticalScroll.Value = InputItemScrollBar.Value;
            InputLineScrollPanel.PerformLayout();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力側スクロールバー操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OutputItemScrollBar_ValueChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OutputItemScrollBar_ValueChanged(object sender, EventArgs e)
        {
            int iScrollValue = InputLineScrollPanel.HorizontalScroll.Maximum - InputLinePanel.Width - OutputItemScrollBar.Value * 24;
            if (iScrollValue < 0)
            {// 計算結果が０未満の場合
                iScrollValue = 0;
            }
            InputLineScrollPanel.HorizontalScroll.Value = iScrollValue;
            InputLineScrollPanel.PerformLayout();

            // 出力側情報表示／非表示切り替え
            for (int iLp = 0; iLp < OutputItemDataGridView.Rows.Count; iLp++)
            {// 行数ループ
                if ((iLp < OutputItemScrollBar.Value) ||
                    (iLp >= OutputItemScrollBar.Value + OutputItemScrollBar.LargeChange))
                {// 表示行ではない場合
                    OutputItemDataGridView.Rows[iLp].Visible = false;
                }
                else
                {// 表示行の場合
                    OutputItemDataGridView.Rows[iLp].Visible = true;
                }
            }

            // コネクタ描画
            PictureBox[] csOutputConnector = { OutputConnectorPictureBox1, OutputConnectorPictureBox2, OutputConnectorPictureBox3, OutputConnectorPictureBox4, OutputConnectorPictureBox5 };
            int iLineCount = 0;
            for (int iLp = 0; iLp < OutputItemDataGridView.Rows.Count; iLp++)
            {// 行数ループ
                if (OutputItemDataGridView.Rows[iLp].Visible == true)
                {// 表示設定の場合
                    csOutputConnector[iLineCount].Visible = true;

                    iLineCount++;
                }
                if (iLineCount >= 5)
                {// ５行編集の場合
                    break;
                }
            }

            EditOutputLine();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>入力側スクロールパネルマウスホイール操作処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>InputItemScrollPanel_MouseWheel(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void InputItemScrollPanel_MouseWheel(object sender, MouseEventArgs e)
        {
            InputItemScrollBar.Value = InputItemScrollPanel.VerticalScroll.Value;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>マウスクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ConnectionPictureBox_MouseClick(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ConnectionPictureBox_MouseClick(object sender, MouseEventArgs e)
        {
            if (m_csTempPropertyInfo == null)
            {// プロパティ情報がない場合
                return;
            }

            int iHeaderHeight = 25;
            int iRowHeight = 21;

            McDataMergePropertyInfo.McMergeConnection csMergeConnection = m_csTempPropertyInfo.GetMergeConnection();

            if (csMergeConnection == null)
            {// マージモデル接続設定値がない場合
                return;
            }

            int iInputCount = (int)m_csTempPropertyInfo.GetInputConnectionNumber();

            int iOutputCount = (int)csMergeConnection.GetIdxNum();
            if (iOutputCount < 5)
            {// インデックス数が５未満の場合
                iOutputCount = 5;
            }

            bool bModifyFlg = false;
            for (int iLp = 0; iLp < csMergeConnection.GetIdxNum(); iLp++)
            {// インデックス数ループ
                if ((e.X >= 22 + (iOutputCount - iLp - 1) * 24 - 5) &&
                    (e.X <= 22 + (iOutputCount - iLp - 1) * 24 + 5))
                {// クリック位置が範囲内の場合
                    for (int iLp2 = 0; iLp2 < iInputCount; iLp2++)
                    {// 受信接続数ループ
                        for (int iLp3 = 0; iLp3 < m_csInputItemDataGrid[iLp2].Rows.Count; iLp3++)
                        {// 行数ループ
                            if ((e.Y >= m_csInputItemDataGrid[iLp2].Location.Y + InputItemScrollBar.Value + iHeaderHeight + iLp3 * iRowHeight + iRowHeight / 2 - 6) &&
                                (e.Y <= m_csInputItemDataGrid[iLp2].Location.Y + InputItemScrollBar.Value + iHeaderHeight + iLp3 * iRowHeight + iRowHeight / 2 + 4))
                            {// クリック位置が範囲内の場合
                                if ((m_lConnect[iLp][0] == iLp2) &&
                                    (m_lConnect[iLp][1] == iLp3))
                                {// 接続設定取り消しの場合
                                    m_lConnect[iLp][0] = -1;
                                    m_lConnect[iLp][1] = -1;
                                }
                                else
                                {// 接続設定変更の場合
                                    m_lConnect[iLp][0] = iLp2;
                                    m_lConnect[iLp][1] = iLp3;

                                    for (int iLp4 = 0; iLp4 < csMergeConnection.GetIdxNum(); iLp4++)
                                    {// インデックス数ループ
                                        if ((iLp != iLp4) &&
                                            (m_lConnect[iLp4][0] == iLp2) &&
                                            (m_lConnect[iLp4][1] == iLp3))
                                        {// 接続位置移動の場合
                                            m_lConnect[iLp4][0] = -1;
                                            m_lConnect[iLp4][1] = -1;
                                        }
                                    }
                                }
                                bModifyFlg = true;
                            }
                        }
                    }
                    break;
                }
            }

            if (bModifyFlg == true)
            {// 接続設定変更ありの場合
                InputLinePictureBox_Redraw();

                ConnectionPictureBox_Redraw();

                EditOutputLine();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>入力側接続線再描画処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>InputLinePictureBox_Redraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void InputLinePictureBox_Redraw()
        {
            int iHeaderHeight = 25;
            int iRowHeight = 21;

            McDataMergePropertyInfo.McMergeConnection csMergeConnection = m_csTempPropertyInfo.GetMergeConnection();

            int iInputCount = (int)m_csTempPropertyInfo.GetInputConnectionNumber();

            Graphics csGraphics = null;
            Point csStartPoint = new Point();
            Point csEndPoint = new Point();
            Pen csDrawPen = null;
            if (iInputCount > 0)
            {// 受信接続数が０より大きい場合
                csGraphics = Graphics.FromImage(InputLinePictureBox.Image);
                csGraphics.Clear(Color.Transparent);

                bool bConnectFlg = false;
                for (int iLp = 0; iLp < iInputCount; iLp++)
                {// 受信接続数ループ
                    for (int iLp2 = 0; iLp2 < m_csInputItemDataGrid[iLp].Rows.Count; iLp2++)
                    {// 行数ループ
                        csStartPoint.X = 0;
                        csStartPoint.Y = m_csInputItemDataGrid[iLp].Location.Y + InputItemScrollBar.Value + iHeaderHeight + iLp2 * iRowHeight + iRowHeight / 2 - 1;
                        csEndPoint.X = InputLinePictureBox.Width - 10;
                        csEndPoint.Y = csStartPoint.Y;
                        if (csMergeConnection != null)
                        {// マージモデル接続設定値がある場合
                            bConnectFlg = false;
                            for (int iLp3 = 0; iLp3 < csMergeConnection.GetIdxNum(); iLp3++)
                            {// インデックス数ループ
                                if ((m_lConnect[iLp3][0] == iLp) &&
                                    (m_lConnect[iLp3][1] == iLp2))
                                {// 接続設定がある場合
                                    bConnectFlg = true;
                                    break;
                                }
                            }
                            if (bConnectFlg == true)
                            {// 接続設定がある場合
                                csDrawPen = new Pen(Color.Blue, 1);
                            }
                            else
                            {// 接続設定がない場合
                                csDrawPen = new Pen(Color.Gray, 1);
                            }
                        }
                        else
                        {// マージモデル接続設定値がない場合
                            csDrawPen = new Pen(Color.Gray, 1);
                        }
                        csGraphics.DrawLine(csDrawPen, csStartPoint, csEndPoint);
                        csDrawPen.Dispose();
                    }
                }

                csGraphics.Dispose();
            }

            HySDataCharacteristicInCell csOutputCellChara = m_csTempPropertyInfo.GetOutputCellCharacteristic();
            if (csOutputCellChara != null)
            {// 出力セル内データがある場合
                csGraphics = Graphics.FromImage(InputLinePictureBox.Image);

                int iOutputCount = (int)csOutputCellChara.GetDataNumber();
                if (iOutputCount < 5)
                {// セル内変数数が５未満の場合
                    iOutputCount = 5;
                }

                for (int iLp = 0; iLp < csOutputCellChara.GetDataNumber(); iLp++)
                {// セル内変数数ループ
                    csStartPoint.X = 22 + (iOutputCount - iLp - 1) * 24;
                    csStartPoint.Y = 10;
                    csEndPoint.X = csStartPoint.X;
                    csEndPoint.Y = InputLinePictureBox.Height;
                    if (csMergeConnection != null)
                    {// マージモデル接続設定値がある場合
                        if ((m_lConnect[iLp][0] >= 0) &&
                            (m_lConnect[iLp][1] >= 0))
                        {// 接続設定がある場合
                            csDrawPen = new Pen(Color.Blue, 1);
                        }
                        else
                        {// 接続設定がない場合
                            csDrawPen = new Pen(Color.Gray, 1);
                        }
                    }
                    else
                    {// マージモデル接続設定値がない場合
                        csDrawPen = new Pen(Color.Gray, 1);
                    }
                    csGraphics.DrawLine(csDrawPen, csStartPoint, csEndPoint);
                    csDrawPen.Dispose();
                }

                csGraphics.Dispose();
            }

            InputLinePictureBox.Refresh();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>接続マーク再描画処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ConnectionPictureBox_Redraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ConnectionPictureBox_Redraw()
        {
            int iHeaderHeight = 25;
            int iRowHeight = 21;

            McDataMergePropertyInfo.McMergeConnection csMergeConnection = m_csTempPropertyInfo.GetMergeConnection();

            Point csStartPoint = new Point();

            Graphics csGraphics = Graphics.FromImage(ConnectionPictureBox.Image);
            csGraphics.Clear(Color.Transparent);

            if (csMergeConnection != null)
            {// マージモデル接続設定値がある場合
                int iOutputCount = (int)csMergeConnection.GetIdxNum();
                if (iOutputCount < 5)
                {// インデックス数が５未満の場合
                    iOutputCount = 5;
                }

                for (int iLp = 0; iLp < csMergeConnection.GetIdxNum(); iLp++)
                {// インデックス数ループ
                    if ((m_lConnect[iLp][0] >= 0) &&
                        (m_lConnect[iLp][1] >= 0))
                    {// 接続設定がある場合
                        csStartPoint.X = 22 + (iOutputCount - iLp - 1) * 24 - 5;
                        csStartPoint.Y = m_csInputItemDataGrid[m_lConnect[iLp][0]].Location.Y + InputItemScrollBar.Value + iHeaderHeight + (int)m_lConnect[iLp][1] * iRowHeight + iRowHeight / 2 - 6;
                        csGraphics.FillEllipse(Brushes.Blue, csStartPoint.X, csStartPoint.Y, 10, 10);
                        csGraphics.DrawEllipse(Pens.Black, csStartPoint.X, csStartPoint.Y, 10, 10);
                    }
                }
            }

            csGraphics.Dispose();
            ConnectionPictureBox.Refresh();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力項目編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OutputItemEditButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OutputItemEditButton_Click(object sender, EventArgs e)
        {
            if (m_csTempPropertyInfo == null)
            {// プロパティ情報がない場合
                return;
            }

            McDotNetDataMergeModelPropertyOutputItemEditForm csOutputItemEditForm = new McDotNetDataMergeModelPropertyOutputItemEditForm();

            csOutputItemEditForm.Text = TEXT_OUTPUT_ITEM_EDIT_OF_MERGE_MODEL;
            csOutputItemEditForm.Owner = this;
            csOutputItemEditForm.TopMost = false;
            csOutputItemEditForm.StartPosition = FormStartPosition.CenterScreen;
            csOutputItemEditForm.SetModelPropertyInfo(m_csTempPropertyInfo);
            csOutputItemEditForm.EditParameter();

            if (csOutputItemEditForm.ShowDialog() == DialogResult.OK)
            {// 出力編集画面にて設定の場合
                ConnectInfoSet();

                EditParameter();

                Refresh();

                Form_Shown(null, null);
            }

            csOutputItemEditForm.Dispose();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>全接続解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ClearToolStripMenuItem_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ClearToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (m_csTempPropertyInfo == null)
            {// プロパティ情報がない場合
                return;
            }

            for (int iLp = 0; iLp < m_lConnect.GetLength(0); iLp++)
            {// ケース数ループ
                m_lConnect[iLp][0] = -1;
                m_lConnect[iLp][1] = -1;
            }

            EditParameter();

            Refresh();

            Form_Shown(null, null);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            Close();
            ((McDotNetModelPropertyScreenBase)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (m_csTempPropertyInfo != null)
            {// プロパティ情報がある場合
                if (ParaSet_Check() == true)
                {// 設定値に異常がある場合
                    return;
                }

                ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);
            }

            Close();

            if (bChangeFlg2 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetModelPropertyScreenBase)m_csScreen).PropertyInfoSet(true);
            }
            else if (bChangeFlg1 == true)
            {// 変更がある場合
                // プロパティ情報設定イベント送信要求
                ((McDotNetModelPropertyScreenBase)m_csScreen).ReqPropertyInfoSetEvent();
            }

            ((McDotNetModelPropertyScreenBase)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaSet_Check()
        {
            bool bRtn = false;

            try
            {
                double dMergeSpan = double.Parse(MergeSpan.Text);

                if (dMergeSpan <= 0)
                {// 設定値が０以下の場合
                    MergeSpan.BackColor = Color.Red;
                    bRtn = true;
                }
                else
                {// 設定値が０より大きいの場合
                    MergeSpan.BackColor = Color.Empty;
                }
            }
            catch
            {
                MergeSpan.BackColor = Color.Red;
                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2)
        {
            bool bRtn = false;

            bChangeFlg1 = false;
            bChangeFlg2 = false;

            // マージ間隔
            double dMergeSpan = double.Parse(MergeSpan.Text);
            if (MergeSpanUnitComboBox.SelectedIndex >= 2)
            {// マージ間隔単位が時以上の場合
                dMergeSpan *= 60;
            }
            if (MergeSpanUnitComboBox.SelectedIndex >= 1)
            {// マージ間隔単位が分以上の場合
                dMergeSpan *= 60;
            }
            if (dMergeSpan != m_csPropertyInfo.GetStepTime())
            {// 設定値変更ありの場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    m_csTempPropertyInfo.SetStepTime(dMergeSpan);
                }
                bChangeFlg2 = true;
                bRtn = true;
            }

            // 出力情報
            bool bOutputItemChange = false;
            HySDataCharacteristicInCell csNewCharacteristicInCell = m_csTempPropertyInfo.GetOutputCellCharacteristic();
            HySDataCharacteristicInCell csOrgCharacteristicInCell = m_csPropertyInfo.GetOutputCellCharacteristic();

            if (csOrgCharacteristicInCell != null)
            {// 出力セル内データがある場合
                if (csNewCharacteristicInCell.GetDataNumber() != csOrgCharacteristicInCell.GetDataNumber())
                {// セル内変数数が変わった場合
                    bOutputItemChange = true;
                }
                else
                {// セル内変数数が同じ場合
                    string sNewLabelWork = "";
                    string sOrgLabelWork = "";
                    string sNewUnitWork = "";
                    string sOrgUnitWork = "";
                    for (int iLp = 0; iLp < csOrgCharacteristicInCell.GetDataNumber(); iLp++)
                    {// セル内変数数ループ
                        csNewCharacteristicInCell.GetDataKind((long)iLp, ref sNewLabelWork, ref sNewUnitWork);
                        csOrgCharacteristicInCell.GetDataKind((long)iLp, ref sOrgLabelWork, ref sOrgUnitWork);
                        if ((sNewLabelWork != sOrgLabelWork) ||
                            (sNewUnitWork != sOrgUnitWork) ||
                            (csNewCharacteristicInCell.GetDataKind((long)iLp).ToString() != csOrgCharacteristicInCell.GetDataKind((long)iLp).ToString()))
                        {// 設定値変更ありの場合
                            bOutputItemChange = true;
                            break;
                        }
                    }
                }
            }
            else if (csNewCharacteristicInCell != null)
            {// 出力セル内データがある場合
                bOutputItemChange = true;
            }
            if (bOutputItemChange == true)
            {// 出力セル内データに変更がある場合
                McModelInfo csOutputConnectionModelInfo = null;
                McCellArrayTranInfoPropertyInfo csOutputConnectionProperty = null;
                for (long lLp = 0; lLp < m_csPropertyInfo.GetOutputConnectionNumber(); lLp++)
                {// 送信接続数ループ
                    csOutputConnectionModelInfo = m_csPropertyInfo.GetOutputConnectionInfoList().GetData(lLp) as McModelInfo;
                    if (csOutputConnectionModelInfo == null)
                    {// モデル情報がない場合
                        continue;
                    }
                    csOutputConnectionProperty = csOutputConnectionModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                    if (csOutputConnectionProperty == null)
                    {// プロパティ情報がない場合
                        continue;
                    }
                    csOutputConnectionProperty.SetUpperConnectionPatternID(new HySID(""));
                }
                bChangeFlg2 = true;
                bRtn = true;
            }

            // 接続情報
            bool bConnectChange = false;
            McDataMergePropertyInfo.McMergeConnection csMergeConnection = m_csPropertyInfo.GetMergeConnection();
            HySDataLinkedList InputConnectionInfoList = m_csPropertyInfo.GetInputConnectionInfoList();
            McCellArrayTranInfoPropertyInfo csConnectionPropertyInfo = null;
            if (csMergeConnection != null)
            {// マージモデル内接続設定値がある場合
                long[] lConnectIdx = csMergeConnection.GetConnectIdx();
                HySID[] lConnectID = csMergeConnection.GetConnectElementID();
                if (lConnectIdx.GetLength(0) != m_lConnect.GetLength(0))
                {// ケース数が変わった場合
                    bConnectChange = true;
                }
                else
                {// ケース数が同じ場合
                    for (int iLp = 0; iLp < csMergeConnection.GetIdxNum(); iLp++)
                    {// インデックス数ループ
                        if ((lConnectIdx[iLp] != m_lConnect[iLp][0]) ||
                            (csMergeConnection.GetIdx((long)iLp) != m_lConnect[iLp][1]))
                        {// 接続情報が変更されている場合
                            bConnectChange = true;
                            break;
                        }
                        else if (InputConnectionInfoList == null)
                        {// 入力接続の情報がない場合
                            bConnectChange = true;
                            break;
                        }
                        else if (m_lConnect[iLp][0] >= 0)
                        {// 接続情報がある場合
                            csConnectionPropertyInfo = ((McModelInfo)InputConnectionInfoList.GetData(m_lConnect[iLp][0])).GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                            if (csConnectionPropertyInfo != null)
                            {// プロパティ情報がある場合
                                if ((lConnectID[iLp].Equals(csConnectionPropertyInfo.GetUpperModelInfo().GetElementID()) == false))
                                {// IDが一致しない場合
                                    bConnectChange = true;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            else
            {// マージモデル内接続設定値がない場合
                if (m_lConnect != null)
                {// 接続情報がある場合
                    bConnectChange = true;
                }
            }

            if (bConnectChange == true)
            {// 接続情報が変更されている場合
                HySID csID = null;
                csMergeConnection = m_csTempPropertyInfo.GetMergeConnection();
                for (int iLp = 0; iLp < m_lConnect.GetLength(0); iLp++)
                {// ケース数ループ
                    if (m_lConnect[iLp][0] >= 0)
                    {// 接続情報がある場合
                        csConnectionPropertyInfo = ((McModelInfo)InputConnectionInfoList.GetData(m_lConnect[iLp][0])).GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                        if (csConnectionPropertyInfo != null)
                        {// プロパティ情報がある場合
                            csID = csConnectionPropertyInfo.GetUpperModelInfo().GetElementID();
                        }
                        else
                        {// プロパティ情報がない場合
                            csID = new HySID("");
                        }
                    }
                    else
                    {// 接続情報がない場合
                        csID = new HySID("");
                    }
                    csMergeConnection.SetIdx((long)iLp, m_lConnect[iLp][0], csID, m_lConnect[iLp][1]);
                }
                bChangeFlg2 = true;
                bRtn = true;
            }

            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

            if (bRtn == true)
            {// 設定変更の場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    // プロパティ情報変更
                    csElement.GetModelInfo().SetPropertyInfo(m_csTempPropertyInfo);
                }
            }

            // 要素名称
            if (ModelName.Text != m_csElementName.ToString())
            {// 名称が変更されている場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    csElement.SetElementName(new HySString(ModelName.Text));
                }
                bChangeFlg1 = true;
                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル入力処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileOpen_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileOpen_Click(object sender, EventArgs e)
        {
            if (m_csPropertyInfo == null)
            {// プロパティ情報がない場合
                return;
            }

            openFileDialog1.FileName = "";
            openFileDialog1.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML_CSV;
            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
            {// 入力ファイルを選択した場合
                FileName.Text = openFileDialog1.FileName;        // テキスト表示
                // ファイル入力
                string csFileName = openFileDialog1.FileName;    // 入力ファイルフルパス名

                HySFile csFile = new HySFile((new HySString(csFileName)));
                if (csFile.Exist() == true)
                {// 既存ファイルが有れば
                    if (csFileName.IndexOf(".csv", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                    {// CSVファイルの場合
                        HySString sOut = new HySString();
                        string[] sInWk;
                        HySString csKey = null;
                        HySString csPropatyName = new HySString();
                        HySString csInitialName = new HySString();
                        McDefine.ValKind lObjKind = new McDefine.ValKind();
                        bool bVal = new bool();
                        long lVal = new long();
                        double dVal = new double();
                        string sVal = "";

                        if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                        {// 既存CSVファイルを正常に開ければ
                            while (csFile.ReadText(ref sOut) != 0)
                            {// １行取得
                                sInWk = sOut.ToString().Split(',');
                                if (sInWk.LongLength == 4)
                                {// パラメータ情報項目数と一致した場合
                                    if (sInWk[0] != "#")
                                    {// コメント行以外の場合
                                        if (sInWk[0] == "[P]")
                                        {//プロパティ情報
                                            csKey = new HySString(sInWk[3]);
                                            // 型式別に登録
                                            if (m_csTempPropertyInfo.GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                                            {// 情報が取得できた場合
                                                if (lObjKind == McDefine.ValKind.BOOL)
                                                {// 論理型の場合
                                                    bVal = bool.Parse(sInWk[2]);
                                                    m_csTempPropertyInfo.SetInfo(csKey, bVal);
                                                }
                                                else if (lObjKind == McDefine.ValKind.DOUBLE)
                                                {// 実数型の場合
                                                    dVal = double.Parse(sInWk[2]);
                                                    m_csTempPropertyInfo.SetInfo(csKey, dVal);
                                                }
                                                else if (lObjKind == McDefine.ValKind.LONG)
                                                {// 倍精度整数型の場合
                                                    lVal = long.Parse(sInWk[2]);
                                                    m_csTempPropertyInfo.SetInfo(csKey, lVal);
                                                }
                                                else if (lObjKind == McDefine.ValKind.STRING)
                                                {// 文字列型の場合
                                                    sVal = sInWk[2];
                                                    m_csTempPropertyInfo.SetInfo(csKey, sVal);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            csFile.Close();
                        }
                    }
                    else if (csFileName.IndexOf(".xml", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                    {// Xmlファイルの場合
                        HySXmlReader csXmlReader = new HySXmlReader(csFileName);
                        HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
                        HySXmlNodeList csXmlChildNodeList = csXmlRootNode.GetChildNodeList();

                        McDataMergePropertyInfo csXmlOutWorkInfo = new McDataMergePropertyInfo(m_csTempPropertyInfo.GetFactoryID(), (HySObjectKind)m_csTempPropertyInfo.GetModelKind());

                        csXmlOutWorkInfo.XmlIN(csXmlChildNodeList.GetNode(0));

                        m_csTempPropertyInfo.SetStepTime(csXmlOutWorkInfo.GetStepTime());
                        m_csTempPropertyInfo.SetOutputCellCharacteristic(csXmlOutWorkInfo.GetOutputCellCharacteristic());

                        if (m_csPropertyInfo.GetInputConnectionInfoList() != null)
                        {// 入力接続の情報がある場合
                            m_csTempPropertyInfo.SetInputConnectionInfoList((HySDataLinkedList)HySDataDuplicate.DupliCateData(m_csPropertyInfo.GetInputConnectionInfoList()));
                        }
                    }

                    ConnectInfoSet();

                    EditParameter();

                    Refresh();

                    Form_Shown(null, null);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル出力処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileSave_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileSave_Click(object sender, EventArgs e)
        {
            if (m_csPropertyInfo == null)
            {// プロパティ情報がない場合
                return;
            }

            if (ParaSet_Check() == true)
            {// 設定情報に異常がある場合
                return;
            }

            double dMergeSpan = double.Parse(MergeSpan.Text);
            m_csTempPropertyInfo.SetStepTime(dMergeSpan);

            saveFileDialog1.FileName = FileName.Text;
            saveFileDialog1.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML;
            if (saveFileDialog1.ShowDialog(this) == DialogResult.OK)
            {// 出力ファイルを選択した場合
                string csFileName = saveFileDialog1.FileName;    // 出力ファイルフルパス名

                if (csFileName.Substring(csFileName.Length - 4, 4) != Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_XML)
                {// 拡張子が付いていない場合
                    csFileName += Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_XML;
                }

                FileName.Text = csFileName;            // テキスト表示

                HySXmlWriter csXmlWriter = new HySXmlWriter(csFileName);

                HySXmlNode csRootNode = csXmlWriter.CreateRoot("PropertyRoot");

                // プロパティ出力指定
                McPropertyInfoBase.SetXmlOutFlg(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL);

                McDataMergePropertyInfo csXmlOutWorkInfo = new McDataMergePropertyInfo(m_csTempPropertyInfo.GetFactoryID(), (HySObjectKind)m_csTempPropertyInfo.GetModelKind());
                csXmlOutWorkInfo.SetStepTime(m_csTempPropertyInfo.GetStepTime());
                csXmlOutWorkInfo.SetOutputCellCharacteristic(m_csTempPropertyInfo.GetOutputCellCharacteristic());

                csRootNode.AppendChild(csXmlOutWorkInfo.XmlOUT(ref csXmlWriter));

                csXmlWriter.Save();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0020,
                        ((HySDotNetViewer)((HySDotNetScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}
