﻿// <summary>ソースコード：ＨＹＭＣＯデータマージモデルプロパティ出力項目編集画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>データマージモデルプロパティ出力項目編集画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/12][新規作成]</para>
    /// </remarks>
    public partial class McDotNetDataMergeModelPropertyOutputItemEditForm : HySDotNetForm
    {
        /// <summary>パラメータ情報</summary>
        private McDataMergePropertyInfo m_csPropertyInfo = null;

        /// <summary>リソース情報</summary>
        System.ComponentModel.ComponentResourceManager m_csResources;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetDataMergeModelPropertyOutputItemEditForm csOutputItemEditForm = new McDotNetDataMergeModelPropertyOutputItemEditForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetDataMergeModelPropertyOutputItemEditForm()
        {
            InitializeComponent();

            m_csResources = new System.ComponentModel.ComponentResourceManager(typeof(McDotNetDataMergeModelPropertyOutputItemEditForm));
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McDataMergePropertyInfo csInfo)
        {
            m_csPropertyInfo = csInfo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            string sLabelWork = "";
            string sUnitWork = "";

            OutputItemDataGridView.Rows.Clear();

            HySDataCharacteristicInCell csOutputCellChara = m_csPropertyInfo.GetOutputCellCharacteristic();
            if (csOutputCellChara != null)
            {// 出力セル内データがある場合
                // 表内情報編集
                for (int iLp = 0; iLp < csOutputCellChara.GetDataNumber(); iLp++)
                {// セル内変数数ループ
                    OutputItemDataGridView.Rows.Add();
                    OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[0].Value = iLp.ToString();
                    for (int iLp2 = 0; iLp2 < HySDataKindDefine.m_DataKindList.Length; iLp2++)
                    {// データ種別数ループ
                        if (csOutputCellChara.GetDataKind((long)iLp).Equals(HySDataKindDefine.m_DataKindList[iLp2]) == true)
                        {// データ種別が一致した場合
                            OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[1].Value = m_csResources.GetString("DivisionComboBox.Items");
                            DivisionComboBox.Items.Remove(m_csResources.GetString("DivisionComboBox.Items1"));
                            break;
                        }
                        if (csOutputCellChara.GetDataKind((long)iLp).Equals(HySDataKindDefine.m_GISDataKindList[iLp2]) == true)
                        {// データ種別が一致した場合
                            OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[1].Value = m_csResources.GetString("DivisionComboBox.Items1");
                            DivisionComboBox.Items.Remove(m_csResources.GetString("DivisionComboBox.Items"));
                            break;
                        }
                    }
                    csOutputCellChara.GetDataKind((long)iLp, ref sLabelWork, ref sUnitWork);
                    OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[2].Value = sLabelWork;
                    OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[3].Value = sUnitWork;
                    OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[4].Value = csOutputCellChara.GetDataKind((long)iLp).ToString();
                }
            }

            for (int iLp = 0; iLp < HySDataKindDefine.m_DataKindNameList.Length; iLp++)
            {// データ種別名称数ループ
                KindComboBox.Items.Add(HySDataKindDefine.m_DataKindNameList[iLp].ToString());
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>項目移動（上）処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ItemUpButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ItemUpButton_Click(object sender, EventArgs e)
        {
            if (OutputItemDataGridView.SelectedRows.Count <= 0)
            {// 行選択が無い場合
                return;
            }

            int iItemIdx = int.Parse(OutputItemDataGridView.SelectedRows[0].Cells[0].Value.ToString());
            if (iItemIdx <= 0)
            {// インデックスが０以下の場合
                return;
            }

            DataGridViewRow csRow = OutputItemDataGridView.Rows.SharedRow(iItemIdx);
            OutputItemDataGridView.Rows.RemoveAt(iItemIdx);
            OutputItemDataGridView.Rows.Insert(iItemIdx - 1, csRow);
            OutputItemDataGridView.Rows[iItemIdx - 1].Selected = true;
            OutputItemDataGridView.FirstDisplayedScrollingRowIndex = iItemIdx - 1;

            for (int iLp = iItemIdx - 1; iLp < OutputItemDataGridView.Rows.Count; iLp++)
            {// 行数ループ
                OutputItemDataGridView.Rows[iLp].Cells[0].Value = iLp.ToString();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>項目移動（下）処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ItemDownButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ItemDownButton_Click(object sender, EventArgs e)
        {
            if (OutputItemDataGridView.SelectedRows.Count <= 0)
            {// 行選択が無い場合
                return;
            }

            int iItemIdx = int.Parse(OutputItemDataGridView.SelectedRows[0].Cells[0].Value.ToString());
            if (iItemIdx >= OutputItemDataGridView.Rows.Count - 1)
            {// インデックスが行数以上の場合
                return;
            }

            DataGridViewRow csRow = OutputItemDataGridView.Rows.SharedRow(iItemIdx);
            OutputItemDataGridView.Rows.RemoveAt(iItemIdx);
            OutputItemDataGridView.Rows.Insert(iItemIdx + 1, csRow);
            OutputItemDataGridView.Rows[iItemIdx + 1].Selected = true;
            OutputItemDataGridView.FirstDisplayedScrollingRowIndex = iItemIdx + 1;

            for (int iLp = iItemIdx; iLp < OutputItemDataGridView.Rows.Count; iLp++)
            {// 行数ループ
                OutputItemDataGridView.Rows[iLp].Cells[0].Value = iLp.ToString();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>項目削除処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ItemDeleteButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ItemDeleteButton_Click(object sender, EventArgs e)
        {
            if (OutputItemDataGridView.SelectedRows.Count <= 0)
            {// 行選択が無い場合
                return;
            }

            int iItemIdx = int.Parse(OutputItemDataGridView.SelectedRows[0].Cells[0].Value.ToString());

            OutputItemDataGridView.Rows.RemoveAt(iItemIdx);

            for (int iLp = iItemIdx; iLp < OutputItemDataGridView.Rows.Count; iLp++)
            {// 行数ループ
                OutputItemDataGridView.Rows[iLp].Cells[0].Value = iLp.ToString();
            }

            if (OutputItemDataGridView.Rows.Count <= 0)
            {// 行数が０以下の場合
                DivisionComboBox.Items.Clear();
                DivisionComboBox.Items.AddRange(new object[] { m_csResources.GetString("DivisionComboBox.Items"), m_csResources.GetString("DivisionComboBox.Items1") });
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>項目追加処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ItemAddButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ItemAddButton_Click(object sender, EventArgs e)
        {
            if (DivisionComboBox.SelectedIndex < 0)
            {// 区分選択が無い場合
                return;
            }
            if (KindComboBox.SelectedIndex < 0)
            {// 種別選択が無い場合
                return;
            }

            OutputItemDataGridView.Rows.Add();
            OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[0].Value = ((int)(OutputItemDataGridView.Rows.Count - 1)).ToString();
            if ((string)DivisionComboBox.SelectedItem == m_csResources.GetString("DivisionComboBox.Items"))
            {// 区分が非GISの場合
                OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[1].Value = m_csResources.GetString("DivisionComboBox.Items");
            }
            else
            {// 区分がGISの場合
                OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[1].Value = m_csResources.GetString("DivisionComboBox.Items1");
            }
            OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[2].Value = LabelTextBox.Text;
            OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[3].Value = UnitTextBox.Text;
            if ((string)DivisionComboBox.SelectedItem == m_csResources.GetString("DivisionComboBox.Items"))
            {// 区分が非GISの場合
                OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[4].Value = HySDataKindDefine.m_DataKindList[KindComboBox.SelectedIndex].ToString();
            }
            else
            {// 区分がGISの場合
                OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Cells[4].Value = HySDataKindDefine.m_GISDataKindList[KindComboBox.SelectedIndex].ToString();
            }
            OutputItemDataGridView.Rows[OutputItemDataGridView.Rows.Count - 1].Selected = true;
            OutputItemDataGridView.FirstDisplayedScrollingRowIndex = OutputItemDataGridView.Rows.Count - 1;

            if ((string)DivisionComboBox.SelectedItem == m_csResources.GetString("DivisionComboBox.Items"))
            {// 区分が非GISの場合
                DivisionComboBox.Items.Remove(m_csResources.GetString("DivisionComboBox.Items1"));
            }
            else
            {// 区分がGISの場合
                DivisionComboBox.Items.Remove(m_csResources.GetString("DivisionComboBox.Items"));
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg = false;
            string sLabelWork = "";
            string sUnitWork = "";

            // 変更確認
            HySDataCharacteristicInCell csOutputCellChara = m_csPropertyInfo.GetOutputCellCharacteristic();
            if (csOutputCellChara != null)
            {// 出力セル内データがある場合
                if (csOutputCellChara.GetDataNumber() != OutputItemDataGridView.Rows.Count)
                {// 項目数が変更された場合
                    bChangeFlg = true;
                }
            }
            else if (OutputItemDataGridView.Rows.Count > 0)
            {// 項目がある場合
                bChangeFlg = true;
            }
            
            if (bChangeFlg == false)
            {// 項目の変更がない場合
                if (csOutputCellChara != null)
                {// 出力セル内データがある場合
                    for (int iLp = 0; iLp < csOutputCellChara.GetDataNumber(); iLp++)
                    {// セル内変数数ループ
                        csOutputCellChara.GetDataKind((long)iLp, ref sLabelWork, ref sUnitWork);
                        if (OutputItemDataGridView.Rows[iLp].Cells[2].Value.ToString() != sLabelWork)
                        {// 情報の意味が変更された場合
                            bChangeFlg = true;
                            break;
                        }
                        if (OutputItemDataGridView.Rows[iLp].Cells[3].Value.ToString() != sUnitWork)
                        {// 単位が変更された場合
                            bChangeFlg = true;
                            break;
                        }
                        if (OutputItemDataGridView.Rows[iLp].Cells[4].Value.ToString() != csOutputCellChara.GetDataKind((long)iLp).ToString())
                        {// 種別が変更された場合
                            bChangeFlg = true;
                            break;
                        }
                    }
                }
            }

            if (bChangeFlg == true)
            {// 項目の変更がある場合
                HySObjectKind csKindWork = null;
                HySDataCharacteristicInCell csOutCellChara = new HySDataCharacteristicInCell(OutputItemDataGridView.Rows.Count);
                for (int iLp = 0; iLp < OutputItemDataGridView.Rows.Count; iLp++)
                {// 行数ループ
                    sLabelWork = OutputItemDataGridView.Rows[iLp].Cells[2].Value.ToString();
                    sUnitWork = OutputItemDataGridView.Rows[iLp].Cells[3].Value.ToString();
                    csKindWork = new HySObjectKind(OutputItemDataGridView.Rows[iLp].Cells[4].Value.ToString());
                    csOutCellChara.SetDataKind((long)iLp, sLabelWork, csKindWork, sUnitWork);
                }
                m_csPropertyInfo.SetOutputCellCharacteristic(csOutCellChara);
            }

            Close();

            if (bChangeFlg == true)
            {// 変更がある場合
                // ダイアログ結果変更有り設定
                DialogResult = DialogResult.OK;
            }
            else
            {// 変更がない場合
                // ダイアログ結果変更無し設定
                DialogResult = DialogResult.Cancel;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0021, null);
        }
    }
}