﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクトプロパティ画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>プロジェクトプロパティ画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/26][新規作成]</para>
    /// </remarks>
    public partial class McDotNetFigUnityPropertyForm : HySDotNetForm, McModelPropertyFormIF
    {
        /// <summary>パラメータ情報</summary>
        private McPropertyInfoRoot m_csPropertyInfo = null;

        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetFigUnityPropertyForm csFigUnityPropertyForm = new McDotNetFigUnityPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetFigUnityPropertyForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイムステップ推奨値設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>this.Delta_Set_Button.Click += new System.EventHandler(this.Delta_Set_Button_Click);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Delta_Set_Button_Click(object sender, EventArgs e)
        {
            // 表示要素情報取得
            McStructInfo csStructInfo = (McStructInfo)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

            // タイムステップの推奨値を計算し設定
            TimeStep.Text = ((double)csStructInfo.RecommendDeltaTime().GetTime() * 2.0).ToString();

            // 秒 に設定する
            UnitComboBox.SelectedIndex = 0;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>this.Cancel.Click += new System.EventHandler(this.Cancel_Click);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            Close();
            ((McDotNetModelPropertyScreenBase)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (ParaSet_Check() == true)
            {// 設定値に異常があった場合
                return;
            }

            ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

            Close();

            if (bChangeFlg2 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetFigUnityPropertyScreen)m_csScreen).PropertyInfoSet(true);
            }

            ((McDotNetFigUnityPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaSet_Check()
        {
            bool bRtn = false;

            // タイムステップ最大値取得
            double dTimeStepMax = ((McDotNetFigUnityPropertyScreen)m_csScreen).GetTimeStepMaxValue();

            try
            {
                double dTimeStep = double.Parse(TimeStep.Text);

                if (UnitComboBox.SelectedIndex >= 3)
                {// 単位が日以上の場合
                    dTimeStep *= 24;
                }
                if (UnitComboBox.SelectedIndex >= 2)
                {// 単位が時以上の場合
                    dTimeStep *= 60;
                }
                if (UnitComboBox.SelectedIndex >= 1)
                {// 単位が分以上の場合
                    dTimeStep *= 60;
                }

                if ((dTimeStep > 0) && (dTimeStep <= dTimeStepMax))
                {// 設定可能範囲内の場合
                    TimeStep.BackColor = Color.Empty;
                }
                else
                {// 設定可能範囲外の場合
                    // 入力異常を出力する
                    TimeStep.BackColor = Color.Red;
                    bRtn = true;
                }
            }
            catch
            {
                // 入力異常を出力する
                TimeStep.BackColor = Color.Red;
                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2)
        {
            bool bRtn = false;

            bChangeFlg1 = false;
            bChangeFlg2 = false;

            // 演算制御
            if (((McFigUnityPropertyInfo)m_csPropertyInfo).GetDataFusionTiming() == McDefine.DataFusionTiming.SYNCHRONOUS)
            {// 演算制御が同期の場合
                if (DataFusionTimingComboBox.SelectedIndex == 1)
                {// 演算制御が非同期の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McFigUnityPropertyInfo)m_csPropertyInfo).SetDataFusionTiming(McDefine.DataFusionTiming.ASYNCHRONOUS);
                    }
                    bChangeFlg2 = true;
                    bRtn = true;
                }
            }
            else
            {
                if (DataFusionTimingComboBox.SelectedIndex == 0)
                {// 演算制御が同期の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McFigUnityPropertyInfo)m_csPropertyInfo).SetDataFusionTiming(McDefine.DataFusionTiming.SYNCHRONOUS);
                    }
                    bChangeFlg2 = true;
                    bRtn = true;
                }
            }
            if (DataFusionTimingComboBox.SelectedIndex == 1)
            {// 演算制御が非同期の場合
                // 非同期の場合
                // ループ接続許可
                if (LoopCheckBox.Checked == true)
                {// ループ接続許可が許可の場合
                    if (((McFigUnityPropertyInfo)m_csPropertyInfo).GetLoopPermission() == false)
                    {// ループ接続許可が不許可の場合
                        if (bSetFlg == true)
                        {// 設定反映の場合
                            ((McFigUnityPropertyInfo)m_csPropertyInfo).SetLoopPermission(true);
                        }
                        bChangeFlg2 = true;
                        bRtn = true;
                    }
                }
                else
                {// ループ接続許可が不許可の場合
                    if (((McFigUnityPropertyInfo)m_csPropertyInfo).GetLoopPermission() == true)
                    {// ループ接続許可が許可の場合
                        if (bSetFlg == true)
                        {// 設定反映の場合
                            ((McFigUnityPropertyInfo)m_csPropertyInfo).SetLoopPermission(false);
                        }
                        bChangeFlg2 = true;
                        bRtn = true;
                    }
                }

                // タイムステップ
                double dTimeStep = double.Parse(TimeStep.Text);

                if (UnitComboBox.SelectedIndex >= 3)
                {// 単位が日以上の場合
                    dTimeStep *= 24;
                }
                if (UnitComboBox.SelectedIndex >= 2)
                {// 単位が時以上の場合
                    dTimeStep *= 60;
                }
                if (UnitComboBox.SelectedIndex >= 1)
                {// 単位が分以上の場合
                    dTimeStep *= 60;
                }


                if (((McFigUnityPropertyInfo)m_csPropertyInfo).GetTimeStep() == null)
                {// タイムステップの設定がない場合
                    if (dTimeStep != 0)
                    {// タイムステップが０以外の場合
                        if (bSetFlg == true)
                        {// 設定反映の場合
                            ((McFigUnityPropertyInfo)m_csPropertyInfo).SetTimeStep(new HySTime(dTimeStep));
                        }
                        bChangeFlg2 = true;
                        bRtn = true;
                    }
                }
                else
                {// タイムステップの設定がある場合
                    if (dTimeStep != ((McFigUnityPropertyInfo)m_csPropertyInfo).GetTimeStep().GetTime())
                    {// タイムステップが変更されている場合
                        if (bSetFlg == true)
                        {// 設定反映の場合
                            ((McFigUnityPropertyInfo)m_csPropertyInfo).SetTimeStep(new HySTime(dTimeStep));
                        }
                        bChangeFlg2 = true;
                        bRtn = true;
                    }
                }
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算制御コンボチェンジ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataFusionTimingComboBox_SelectChange(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataFusionTimingComboBox_SelectChange(object sender, EventArgs e)
        {
            if (DataFusionTimingComboBox.SelectedIndex == 0)
            {// 演算制御が同期の場合
                TimeStep.Enabled = false;
                UnitComboBox.Enabled = false;
                Delta_Set_Button.Enabled = false;
                LoopCheckBox.Enabled = false;
            }
            else
            {// 演算制御が非同期の場合
                TimeStep.Enabled = true;
                UnitComboBox.Enabled = true;
                Delta_Set_Button.Enabled = true;
                LoopCheckBox.Enabled = true;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter()
        {
            // 要素名称
            ModelName.Text = m_csElementName.ToString();

            if (m_csPropertyInfo != null)
            {// 登録プロパティ情報がある場合
                // 演算制御
                if (((McFigUnityPropertyInfo)m_csPropertyInfo).GetDataFusionTiming() == McDefine.DataFusionTiming.SYNCHRONOUS)
                {// 演算制御が同期の場合
                    DataFusionTimingComboBox.SelectedIndex = 0;

                    TimeStep.Enabled = false;
                    UnitComboBox.Enabled = false;
                }
                else
                {// 演算制御が非同期の場合
                    DataFusionTimingComboBox.SelectedIndex = 1;

                    TimeStep.Enabled = true;
                    UnitComboBox.Enabled = true;
                }

                // ループ接続許可
                if (((McFigUnityPropertyInfo)m_csPropertyInfo).GetLoopPermission() == true)
                {// ループ接続許可が許可の場合
                    LoopCheckBox.Checked = true;
                }

                // タイムステップ
                if (((McFigUnityPropertyInfo)m_csPropertyInfo).GetTimeStep() == null)
                {// タイムステップの設定がない場合
                    TimeStep.Text = "60";
                }
                else
                {// タイムステップの設定がある場合
                    TimeStep.Text = ((double)((McFigUnityPropertyInfo)m_csPropertyInfo).GetTimeStep().GetTime()).ToString();
                }
                TimeStep.BackColor = Color.Empty;
                UnitComboBox.SelectedIndex = 0;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0006,
                        ((HySDotNetViewer)((HySDotNetScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}