﻿// <summary>ソースコード：ＨＹＭＣＯグループプロパティ画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>グループプロパティ画面クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/26][新規作成]</para>
    /// </remarks>
    public partial class McDotNetGroupPropertyForm : HySDotNetForm, McModelPropertyFormIF
    {
        /// <summary>パラメータ情報</summary>
        private McPropertyInfoRoot m_csPropertyInfo = null;

        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetGroupPropertyForm csGroupPropertyForm = new McDotNetGroupPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetGroupPropertyForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>this.Cancel.Click += new System.EventHandler(this.Cancel_Click);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            Close();
            ((McDotNetModelPropertyScreenBase)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

            Close();

            if (bChangeFlg2 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetGroupPropertyScreen)m_csScreen).PropertyInfoSet(true);
            }
            else if (bChangeFlg1 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetGroupPropertyScreen)m_csScreen).PropertyInfoSet(false);
            }

            ((McDotNetGroupPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaSet_Check()
        {
            return false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2)
        {
            bool bRtn = false;

            bChangeFlg1 = false;
            bChangeFlg2 = false;

            // 表示要素情報取得
            McGraphicsGroupElement csElement = (McGraphicsGroupElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

            // 要素名称
            if (ModelName.Text != m_csElementName.ToString())
            {// 要素名称に変更がある場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    csElement.SetElementName(new HySString(ModelName.Text));
                }
                bChangeFlg1 = true;
                bRtn = true;
            }

            // グループ解除許可
            if (((McGroupPropertyInfo)m_csPropertyInfo).CanDisband() == true)
            {// グループ解除が許可の場合
                if (GroupDisbandComboBox.SelectedIndex == 1)
                {// グループ解除が不許可の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McGroupPropertyInfo)m_csPropertyInfo).SetDisband(false);
                    }
                    bChangeFlg1 = true;
                    bRtn = true;
                }
            }
            else
            {// グループ解除が不許可の場合
                if (GroupDisbandComboBox.SelectedIndex == 0)
                {// グループ解除が許可の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McGroupPropertyInfo)m_csPropertyInfo).SetDisband(true);
                    }
                    bChangeFlg1 = true;
                    bRtn = true;
                }
            }

            // 演算制御
            if (((McGroupPropertyInfo)m_csPropertyInfo).GetDataFusionTiming() == McDefine.DataFusionTiming.SYNCHRONOUS)
            {// 演算制御が同期の場合
                if (DataFusionTimingComboBox.SelectedIndex == 1)
                {// 演算制御が非同期の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McGroupPropertyInfo)m_csPropertyInfo).SetDataFusionTiming(McDefine.DataFusionTiming.ASYNCHRONOUS);
                    }
                    bChangeFlg2 = true;
                    bRtn = true;
                }
            }
            else
            {// 演算制御が非同期の場合
                if (DataFusionTimingComboBox.SelectedIndex == 0)
                {// 演算制御が同期の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McGroupPropertyInfo)m_csPropertyInfo).SetDataFusionTiming(McDefine.DataFusionTiming.SYNCHRONOUS);
                    }
                    bChangeFlg2 = true;
                    bRtn = true;
                }
            }

            // ループ接続許可
            if (DataFusionTimingComboBox.SelectedIndex == 1)
            {// 演算制御が非同期の場合
                // ループ接続許可
                if (LoopCheckBox.Checked == true)
                {// ループ接続許可が許可の場合
                    if (((McGroupPropertyInfo)m_csPropertyInfo).GetLoopPermission() == false)
                    {// ループ接続許可が不許可の場合
                        if (bSetFlg == true)
                        {// 設定反映の場合
                            ((McGroupPropertyInfo)m_csPropertyInfo).SetLoopPermission(true);
                        }
                        bChangeFlg2 = true;
                        bRtn = true;
                    }
                }
                else
                {// ループ接続許可が不許可の場合
                    if (((McGroupPropertyInfo)m_csPropertyInfo).GetLoopPermission() == true)
                    {// ループ接続許可が許可の場合
                        if (bSetFlg == true)
                        {// 設定反映の場合
                            ((McGroupPropertyInfo)m_csPropertyInfo).SetLoopPermission(false);
                        }
                        bChangeFlg2 = true;
                        bRtn = true;
                    }
                }
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter()
        {
            // 要素名称
            ModelName.Text = m_csElementName.ToString();

            if (m_csPropertyInfo != null)
            {// 登録プロパティ情報がある場合
                // 要素ID
                if ((object)m_csPropertyInfo.GetID() == null)
                {// IDが設定されていない場合
                    ModelId.Text = "";
                }
                else
                {// IDが設定されている場合
                    ModelId.Text = m_csPropertyInfo.GetID().ToString();
                }

                // モデル種別
                if ((object)m_csPropertyInfo.GetModelName() == null)
                {// 名称設定がない場合
                    ModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    ModelKind.Text = m_csPropertyInfo.GetModelName().ToString();
                }

                // ファクトリID
                if ((object)m_csPropertyInfo.GetFactoryID() == null)
                {// IDが設定されていない場合
                    ModelKindID.Text = "";
                }
                else
                {// IDが設定されている場合
                    ModelKindID.Text = m_csPropertyInfo.GetFactoryID().ToString();
                }

                // グループ解除
                if (((McGroupPropertyInfo)m_csPropertyInfo).CanDisband() == true)
                {// グループ解除が許可の場合
                    GroupDisbandComboBox.SelectedIndex = 0;
                }
                else
                {// グループ解除が不許可の場合
                    GroupDisbandComboBox.SelectedIndex = 1;
                }

                // 演算制御
                if (((McGroupPropertyInfo)m_csPropertyInfo).GetDataFusionTiming() == McDefine.DataFusionTiming.SYNCHRONOUS)
                {// 演算制御が同期の場合
                    DataFusionTimingComboBox.SelectedIndex = 0;
                }
                else
                {// 演算制御が非同期の場合
                    DataFusionTimingComboBox.SelectedIndex = 1;
                }

                // ループ接続許可
                if (((McGroupPropertyInfo)m_csPropertyInfo).GetLoopPermission() == true)
                {// ループ接続許可が許可の場合
                    LoopCheckBox.Checked = true;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算制御コンボチェンジ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataFusionTimingComboBox_SelectChange(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataFusionTimingComboBox_SelectChange(object sender, EventArgs e)
        {
            if (DataFusionTimingComboBox.SelectedIndex == 0)
            {// 演算制御が同期の場合
                LoopCheckBox.Enabled = false;
            }
            else
            {// 演算制御が非同期の場合
                LoopCheckBox.Enabled = true;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0002,
                        ((HySDotNetViewer)((HySDotNetScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}