﻿// <summary>ソースコード：ＨＹＭＣＯセル型モデルプロパティ詳細設定画面基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯセル型モデルプロパティ詳細設定画面基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/03][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelCellPropertyDetailBaseForm : HySDotNetForm
    {
        //-------------------------------------------------------------------------------
        //　・詳細画面はモーダルで表示されます。
        //　・設定完了で画面クローズする際に、変更有りの場合はDialogResultに「OK」を設定すること。
        //　　　　　　　　　　　　　　　　　　変更無しの場合はDialogResultに「Cancel」を設定すること。
        //　・設定キャンセルで画面クローズする際は、DialogResultに「Cancel」を設定すること。
        //-------------------------------------------------------------------------------

        /// <summary>パラメータ情報</summary>
        protected McPropertyInfoRoot m_csPropertyInfo = null;
        /// <summary>初期設定情報</summary>
        protected McPropertyInfoRoot m_csInitialInfo = null;
        /// <summary>オリジナルパラメータ情報</summary>
        protected McPropertyInfoRoot m_csOriginalPropertyInfo = null;
        /// <summary>オリジナル初期設定情報</summary>
        protected McPropertyInfoRoot m_csOriginalInitialInfo = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCellPropertyDetailBaseForm csModelCellPropertyDetailBaseForm = new McDotNetModelCellPropertyDetailBaseForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCellPropertyDetailBaseForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = csInfo;
            //McDotNetModelPropertyScreenBase csScreen = this.GetScreen() as McDotNetModelPropertyScreenBase;
            //if (csScreen != null)
            //{
            //    csScreen.SetModelPropertyInfo(csInfo);
            //}
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelInitialInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデル初期情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelInitialInfo(McPropertyInfoRoot csInfo)
        {
            m_csInitialInfo = csInfo;
            //McDotNetModelPropertyScreenBase csScreen = this.GetScreen() as McDotNetModelPropertyScreenBase;
            //if (csScreen != null)
            //{
            //    csScreen.SetModelInitialInfo(csInfo);
            //}
        }

        /// <summary><para>method outline:</para>
        /// <para>オリジナルモデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetOriginalModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csOriginalPropertyInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>オリジナルモデル初期情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelInitialInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデル初期情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetOriginalModelInitialInfo(McPropertyInfoRoot csInfo)
        {
            m_csOriginalInitialInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「設定」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「設定」ボタンが押下された事を通知する</para>
        /// </remarks>
        public virtual void FinalOK()
        {
            return ;
        }
        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「キャンセル」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「キャンセル」ボタンが押下された事を通知する</para>
        /// </remarks>
        public virtual void FinalCancel()
        {
            return ;
        }
    }
}