﻿// <summary>ソースコード：ＨＹＭＣＯセル型モデルプロパティ画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>セル型モデルプロパティ画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/03][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelCellPropertyForm : HySDotNetForm, McModelPropertyFormIF
    {
        /// <summary>パラメータ情報</summary>
        private McCellModelPropertyInfo m_csPropertyInfo = null;
        /// <summary>初期設定情報</summary>
        private McInitialInfo m_csInitialInfo = null;
        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;
        /// <summary>テンポラリパラメータ情報</summary>
        private McCellModelPropertyInfo m_csTempPropertyInfo = null;
        /// <summary>テンポラリ初期設定情報</summary>
        private McInitialInfo m_csTempInitialInfo = null;
        /// <summary>詳細画面</summary>
        private McDotNetModelCellPropertyDetailBaseForm m_csPropertyDetailForm = null;

        /// <summary>詳細情報変更フラグ </summary>
        protected bool m_bDetailModifyFlg = false;
        /// <summary>端子詳細情報変更フラグ </summary>
        protected bool m_bPortDetailModifyFlg = false;
        /// <summary>端子詳細情報変更IDリスト</summary>
        private List<HySID> m_bPortDetailModifyIDList = null;

        //メッセージ定義
		/// <summary>メッセージタイトル『モデル管理機能』</summary>
		static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_MODEL_MANAGEMENT");
		/// <summary>保存確認メッセージ『設定内容が変更されています。\n保存しますか？』</summary>
		static private readonly string MSG_DATA_SET = McMessage.GetString("MC_MSG_QUESTION_CONFILM_DATA_SETUP");

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCellPropertyForm csModelCellPropertyForm = new McDotNetModelCellPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCellPropertyForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = (McCellModelPropertyInfo)csInfo;
            m_csTempPropertyInfo = (McCellModelPropertyInfo)HySDataDuplicate.DupliCateData(m_csPropertyInfo);
            if (m_csPropertyInfo.GetInputConnectionInfoList() != null)
            {// 入力接続の情報がある場合
                m_csTempPropertyInfo.SetInputConnectionInfoList((HySDataLinkedList)HySDataDuplicate.DupliCateData(m_csPropertyInfo.GetInputConnectionInfoList()));
            }
            if (m_csPropertyInfo.GetOutputConnectionInfoList() != null)
            {// 出力接続の情報がある場合
                m_csTempPropertyInfo.SetOutputConnectionInfoList((HySDataLinkedList)HySDataDuplicate.DupliCateData(m_csPropertyInfo.GetOutputConnectionInfoList()));
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelInitialInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデル初期情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelInitialInfo(McPropertyInfoRoot csInfo)
        {
            m_csInitialInfo = (McInitialInfo)csInfo;
            m_csTempInitialInfo = (McInitialInfo)m_csInitialInfo.Clone();
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter()
        {
            // 名称表示編集
            ModelName.Text = m_csElementName.ToString();
            if (m_csPropertyInfo != null)
            {// 登録プロパティ情報がある場合
                // ID表示編集
                if ((object)m_csPropertyInfo.GetID() == null)
                {// IDが設定されていない場合
                    ModelId.Text = "";
                }
                else
                {// IDが設定されている場合
                    ModelId.Text = m_csPropertyInfo.GetID().ToString();
                }

                // 種別表示編集
                if ((object)m_csPropertyInfo.GetModelName() == null)
                {// 名称設定がない場合
                    ModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    ModelKind.Text = m_csPropertyInfo.GetModelName().ToString();
                }

                // 種別ID表示編集
                if ((object)m_csPropertyInfo.GetFactoryID() == null)
                {// IDが設定されていない場合
                    ModelKindID.Text = "";
                }
                else
                {// IDが設定されている場合
                    ModelKindID.Text = m_csPropertyInfo.GetFactoryID().ToString();
                }
            }

            // 受信情報表示編集
            ReceiveDataScrollBar.Minimum = 0;
            if (m_csPropertyInfo.GetInputConnectionNumber() != 0)
            {// 受信接続数が０以外の場合
                ReceiveDataScrollBar.Maximum = (int)m_csPropertyInfo.GetInputConnectionNumber() - 1;
            }
            else
            {// 受信接続数が０の場合
                ReceiveDataScrollBar.Maximum = 0;
            }
            ReceiveDataScrollBar.Value = 0;

            ButtonStatusSet(5, 0, false);

            // 送信情報表示編集
            SendDataScrollBar.Minimum = 0;
            if (m_csPropertyInfo.GetOutputConnectionNumber() != 0)
            {// 受信接続数が０以外の場合
                SendDataScrollBar.Maximum = (int)m_csPropertyInfo.GetOutputConnectionNumber() - 1;
            }
            else
            {// 受信接続数が０の場合
                SendDataScrollBar.Maximum = 0;
            }
            SendDataScrollBar.Value = 0;

            ButtonStatusSet(6, 0, false);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ボタンステータス設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ButtonStatusSet(iKind, iButtonNo, bSetValue);</para>
        /// </example>
        /// <param name="iKind">設定区分</param>
        /// <param name="iButtonNo">ボタンNo</param>
        /// <param name="bSetValue">設定値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ButtonStatusSet(int iKind, int iButtonNo, bool bSetValue)
        {
            Button[] csReceiveTranProperty = { ReceiveTranProperty1, ReceiveTranProperty2, ReceiveTranProperty3 };
            Button[] csReceivePortProperty = { ReceivePortProperty1, ReceivePortProperty2, ReceivePortProperty3 };
            Label[] csReceiveIndex = { LabelReceiveIndex1, LabelReceiveIndex2, LabelReceiveIndex3 };
            Label[] csReceiveLine = { LabelReceiveLine1, LabelReceiveLine2, LabelReceiveLine3 };
            Button[] csSendTranProperty = { SendTranProperty1, SendTranProperty2, SendTranProperty3 };
            Button[] csSendPortProperty = { SendPortProperty1, SendPortProperty2, SendPortProperty3 };
            Label[] csSendIndex = { LabelSendIndex1, LabelSendIndex2, LabelSendIndex3 };
            Label[] csSendLine = { LabelSendLine1, LabelSendLine2, LabelSendLine3 };

            HySDataLinkedList csConnectionInfoList = null;
            string sTransName = null;
            string sPatternName = "";
            McModelInfo csModelInfo = null;
            McCellArrayTranInfoPropertyInfo csPropertyInfo = null;
            McTranInfoPattern csPattern = null;
            long lIndex = 0;

            if (iKind == 1)
            {// 受信側表示／非表示設定の場合
                // 受信側表示／非表示設定
                csReceiveTranProperty[iButtonNo].Visible = bSetValue;
                csReceivePortProperty[iButtonNo].Visible = bSetValue;
                csReceiveIndex[iButtonNo].Visible = bSetValue;
                csReceiveLine[iButtonNo].Visible = bSetValue;
            }
            else if (iKind == 2)
            {// 受信側活性／非活性設定の場合
                // 受信側活性／非活性設定
                csReceiveTranProperty[iButtonNo].Enabled = bSetValue;
                csReceivePortProperty[iButtonNo].Enabled = bSetValue;
                csReceiveIndex[iButtonNo].Enabled = bSetValue;
                csReceiveLine[iButtonNo].Enabled = bSetValue;
            }
            else if (iKind == 3)
            {// 送信側表示／非表示設定の場合
                // 送信側表示／非表示設定
                csSendTranProperty[iButtonNo].Visible = bSetValue;
                csSendPortProperty[iButtonNo].Visible = bSetValue;
                csSendIndex[iButtonNo].Visible = bSetValue;
                csSendLine[iButtonNo].Visible = bSetValue;
            }
            else if (iKind == 4)
            {// 送信側活性／非活性設定の場合
                // 送信側活性／非活性設定
                csSendTranProperty[iButtonNo].Enabled = bSetValue;
                csSendPortProperty[iButtonNo].Enabled = bSetValue;
                csSendIndex[iButtonNo].Enabled = bSetValue;
                csSendLine[iButtonNo].Enabled = bSetValue;
            }
            else if (iKind == 5)
            {// 受信側ボタンキャプション設定の場合
                // 受信側ボタンキャプション設定
                for (long lLp = 0; lLp < 3; lLp++)
                {// ３回ループ
                    if (m_csPropertyInfo.GetInputConnectionNumber() > lLp + ReceiveDataScrollBar.Value)
                    {// 編集情報がある場合
                        csConnectionInfoList = m_csPropertyInfo.GetInputConnectionInfoList();

                        ButtonStatusSet(1, (int)lLp, true);
                        lIndex = lLp + ReceiveDataScrollBar.Value;
                        csReceiveIndex[lLp].Text = lIndex.ToString();
                        csModelInfo = (McModelInfo)csConnectionInfoList.GetData(lLp + ReceiveDataScrollBar.Value);
                        if (csModelInfo.GetModelKind().ToString() != string.Empty)
                        {// モデル種別がある場合
                            ButtonStatusSet(2, (int)lLp, true);
                            sTransName = "　";
                            if ((object)csModelInfo.GetUserName() != null)
                            {// 名称設定がある場合
                                sTransName = csModelInfo.GetUserName().ToString();
                            }
                            csPropertyInfo = csModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                            if (csPropertyInfo != null)
                            {// プロパティ情報がある場合
                                sPatternName = Properties.McDotNetViewerResources.PROPERTY_TANGENT_NON_PATTERN; //"パターン未選択"
                                csReceiveTranProperty[lLp].ForeColor = Color.Red;
                                csPattern = (McTranInfoPattern)csPropertyInfo.GetReceiveTranInfoPattern();
                                if (csPattern != null)
                                {// セル伝送型パターンがある場合
                                    sPatternName = csPattern.GetName().ToString();
                                    csReceiveTranProperty[lLp].ForeColor = Color.Black;
                                }
                            }
                            else
                            {// プロパティ情報がない場合
                                sPatternName = Properties.McDotNetViewerResources.PROPERTY_TANGENT_UNCLEAR_PROPERTY;    //"プロパティ形式不明"
                                csReceiveTranProperty[lLp].ForeColor = Color.Red;
                            }
                            csReceiveTranProperty[lLp].Text = sTransName + "\r\n" + sPatternName;
                        }
                        else
                        {// モデル種別がない場合
                            ButtonStatusSet(2, (int)lLp, false);
                            csReceiveTranProperty[lLp].Text = Properties.McDotNetViewerResources.PROPERTY_TANGENT_MODEL_UNESTABLISHED;  //"モデル未設定"
                            csReceiveTranProperty[lLp].ForeColor = Color.Red;
                        }
                    }
                    else
                    {// 編集情報がない場合
                        ButtonStatusSet(1, (int)lLp, false);
                    }
                }
            }
            else if (iKind == 6)
            {// 送信側ボタンキャプション設定の場合
                // 送信側ボタンキャプション設定
                for (long lLp = 0; lLp < 3; lLp++)
                {// ３回ループ
                    if (m_csPropertyInfo.GetOutputConnectionNumber() > lLp + SendDataScrollBar.Value)
                    {// 編集情報がある場合
                        csConnectionInfoList = m_csPropertyInfo.GetOutputConnectionInfoList();

                        ButtonStatusSet(3, (int)lLp, true);
                        lIndex = lLp + SendDataScrollBar.Value;
                        csSendIndex[lLp].Text = lIndex.ToString();
                        csModelInfo = (McModelInfo)csConnectionInfoList.GetData(lLp + SendDataScrollBar.Value);
                        if (csModelInfo.GetModelKind().ToString() != string.Empty)
                        {// モデル種別がある場合
                            ButtonStatusSet(4, (int)lLp, true);
                            sTransName = "　";
                            if ((object)csModelInfo.GetUserName() != null)
                            {// 名称設定がある場合
                                sTransName = csModelInfo.GetUserName().ToString();
                            }
                            csPropertyInfo = csModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                            if (csPropertyInfo != null)
                            {// プロパティ情報がある場合
                                sPatternName = Properties.McDotNetViewerResources.PROPERTY_TANGENT_NON_PATTERN; //"パターン未選択"
                                csSendTranProperty[lLp].ForeColor = Color.Red;
                                csPattern = (McTranInfoPattern)csPropertyInfo.GetSendTranInfoPattern();
                                if (csPattern != null)
                                {// セル伝送型パターンがある場合
                                    sPatternName = csPattern.GetName().ToString();
                                    csSendTranProperty[lLp].ForeColor = Color.Black;
                                }
                            }
                            else
                            {// プロパティ情報がない場合
                                sPatternName = Properties.McDotNetViewerResources.PROPERTY_TANGENT_UNCLEAR_PROPERTY;    //"プロパティ形式不明"
                                csSendTranProperty[lLp].ForeColor = Color.Red;
                            }
                            csSendTranProperty[lLp].Text = sTransName + "\r\n" + sPatternName;
                        }
                        else
                        {// モデル種別がない場合
                            ButtonStatusSet(4, (int)lLp, false);
                            csSendTranProperty[lLp].Text = Properties.McDotNetViewerResources.PROPERTY_TANGENT_MODEL_UNESTABLISHED; //"モデル未設定"
                            csSendTranProperty[lLp].ForeColor = Color.Red;
                        }
                    }
                    else
                    {// 編集情報がない場合
                        ButtonStatusSet(3, (int)lLp, false);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>受信側スクロールバー操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReceiveDataScrollBar_ValueChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReceiveDataScrollBar_ValueChanged(object sender, EventArgs e)
        {
            ButtonStatusSet(5, 0, false);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>送信側スクロールバー操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SendDataScrollBar_ValueChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SendDataScrollBar_ValueChanged(object sender, EventArgs e)
        {
            ButtonStatusSet(6, 0, false);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送情報プロパティクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TranProperty_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TranProperty_Click(object sender, EventArgs e)
        {
            Button[] csTranProperty = { ReceiveTranProperty1, ReceiveTranProperty2, ReceiveTranProperty3, SendTranProperty1, SendTranProperty2, SendTranProperty3 };
            Label[] csIndex = { LabelReceiveIndex1, LabelReceiveIndex2, LabelReceiveIndex3, LabelSendIndex1, LabelSendIndex2, LabelSendIndex3 };
            long lIndex = 0;
            McModelInfo csModelInfo = null;

            for (int iLp = 0; iLp < 6; iLp++)
            {// ６回ループ
                if (((Button)sender).Name == csTranProperty[iLp].Name)
                {// ボタン名称が一致した場合
                    lIndex = long.Parse(csIndex[iLp].Text);
                    if (iLp < 3)
                    {// 受信側の場合
                        csModelInfo = (McModelInfo)m_csPropertyInfo.GetInputConnectionInfoList().GetData(lIndex);
                    }
                    else
                    {// 送信側の場合
                        csModelInfo = (McModelInfo)m_csPropertyInfo.GetOutputConnectionInfoList().GetData(lIndex);
                    }
                }
            }
            if (csModelInfo == null)
            {// モデル情報があった場合
                return;
            }

            if (csModelInfo.GetModelKind() == McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL || 
                csModelInfo.GetModelKind() == McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL ||
                csModelInfo.GetModelKind() == McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL ||
                csModelInfo.GetModelKind() == McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL)
            {
                // 連接要素選択表示要求
                ((McDotNetModelCellPropertyScreenBase)m_csScreen).JunctureElementSelectDispReq(csModelInfo.GetElementID());
            }
            else
            {
                // 連接要素選択表示要求
                ((McDotNetModelCellPropertyScreenBase)m_csScreen).JunctureElementSelectDispReq(csModelInfo.GetElementID());
            }
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>接続情報設定クリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ToolStripMenuItem_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem[] csMenuItem = { ReceiveTran1ToolStripMenuItem, ReceiveTran2ToolStripMenuItem, ReceiveTran3ToolStripMenuItem, SendTran1ToolStripMenuItem, SendTran2ToolStripMenuItem, SendTran3ToolStripMenuItem };
            Label[] csIndex = { LabelReceiveIndex1, LabelReceiveIndex2, LabelReceiveIndex3, LabelSendIndex1, LabelSendIndex2, LabelSendIndex3 };
            long lIndex = 0;
            McModelInfo csModelInfo = null;
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            // 設定変更確認
            if (ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 設定変更ありの場合
                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// Yes選択の場合
                    // 登録
                    ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetModelCellPropertyScreenBase)m_csScreen).PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定イベント送信要求
                        ((McDotNetModelCellPropertyScreenBase)m_csScreen).ReqPropertyInfoSetEvent();
                    }
                }
            }

            for (int iLp = 0; iLp < 6; iLp++)
            {// ６回ループ
                if (((ToolStripMenuItem)sender).Name == csMenuItem[iLp].Name)
                {// ボタン名称が一致した場合
                    lIndex = long.Parse(csIndex[iLp].Text);
                    if (iLp < 3)
                    {// 受信側の場合
                        csModelInfo = (McModelInfo)m_csPropertyInfo.GetInputConnectionInfoList().GetData(lIndex);
                    }
                    else
                    {// 送信側の場合
                        csModelInfo = (McModelInfo)m_csPropertyInfo.GetOutputConnectionInfoList().GetData(lIndex);
                    }
                }
            }
            if (csModelInfo == null)
            {// モデル情報があった場合
                return;
            }

            // 連接モデルプロパティ表示要求
            ((McDotNetModelCellPropertyScreenBase)m_csScreen).JunctureModelPropertyDispReq(csModelInfo.GetElementID());

            Close();
            ((McDotNetModelCellPropertyScreenBase)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>詳細設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DetailSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DetailSet_Click(object sender, EventArgs e)
        {
            if (m_csPropertyDetailForm == null)
            {// 詳細画面未生成の場合
                m_csPropertyDetailForm = null;
                // 詳細画面取得
                try
                {
                    m_csPropertyDetailForm = ((McDotNetModelCellPropertyScreenBase)m_csScreen).CreatePropertyDetailForm() as McDotNetModelCellPropertyDetailBaseForm;
                    if (m_csPropertyDetailForm != null)
                    {
                        m_csPropertyDetailForm.SetScreen(m_csScreen);// add ver1.1.0 フォームにスクリーンを認識させる
                    }
                }
                catch (Exception ex)
                {
                    // ログ出力
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCellPropertyForm::DetailSet_Click", 
                       Properties.McDotNetViewerResources.STATEMENT_PROP_DATAIL_FORM + Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH
                       + Properties.McDotNetViewerResources.STATEMENT_IN_CLASS + "(" + m_csScreen.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCellPropertyForm::DetailSet_Click", " PropertyDetailForm Exception Catch " + " in Class(" + m_csScreen.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                   // ver1.5 エラートレース日本語対応
                    McLog.DebugOut(new HySString(McLog.SYSTEM), new HySString("PropertyDetailForm")
                       , new HySString(Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH + "(" + m_csScreen.ToString() + ") :: " + ex.Message));
                   // McLog.DebugOut(new HySString(McLog.SYSTEM), new HySString("PropertyDetailForm")
                   //    , new HySString("Exception Catch in (" + m_csScreen.ToString() + ") :: " + ex.Message));
                    MessageBox.Show("Abnormal End in PropertyDetailScreen(" + ex.Message + ")");
                    m_csPropertyDetailForm = null;
                    // 異常通知
                    return;
                }

                if (m_csPropertyDetailForm == null)
                {// 詳細画面未生成の場合
                    return;
                }

                try
                {

                    // テンポラリプロパティ情報設定
                    m_csPropertyDetailForm.SetModelPropertyInfo(m_csTempPropertyInfo);
                    // テンポラリ初期設定情報設定
                    m_csPropertyDetailForm.SetModelInitialInfo(m_csTempInitialInfo);
                    // オリジナルプロパティ情報設定
                    m_csPropertyDetailForm.SetOriginalModelPropertyInfo(m_csPropertyInfo);
                    // オリジナル初期設定情報設定
                    m_csPropertyDetailForm.SetOriginalModelInitialInfo(m_csInitialInfo);

                    // 画面表示位置設定
                    m_csPropertyDetailForm.StartPosition = FormStartPosition.CenterScreen;

                    // オーナー設定
                    m_csPropertyDetailForm.Owner = this;

                    // 最上位表示設定
                    m_csPropertyDetailForm.TopMost = false;
                }
                catch (Exception ex)
                {
                    // ログ出力
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCellPropertyForm::DetailSet_Click", 
                       Properties.McDotNetViewerResources.STATEMENT_PROP_DATAIL_FORM + Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH
                       + Properties.McDotNetViewerResources.STATEMENT_IN_CLASS + "(" + m_csScreen.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCellPropertyForm::DetailSet_Click", " PropertyDetailForm Exception Catch " + " in Class(" + m_csPropertyDetailForm.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                   // ver1.5 エラートレース日本語対応
                    McLog.DebugOut(new HySString(McLog.SYSTEM), new HySString("PropertyDetailForm")
                       , new HySString(Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH + "(" + m_csPropertyDetailForm.ToString() + ") :: " + ex.Message));
                   // McLog.DebugOut(new HySString(McLog.SYSTEM), new HySString("PropertyDetailForm")
                   //    , new HySString("Exception Catch in (" + m_csPropertyDetailForm.ToString() + ") :: " + ex.Message));
                    MessageBox.Show("Abnormal End in PropertyDetailScreen(" + ex.Message + ")", MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
                    // 異常通知
                    m_csPropertyDetailForm = null;
                }
            }
            try
            {

                if (m_csPropertyDetailForm is McModelCellPropertyDetailFormIF)
                {// キャスト可能な場合
                    // 画面表示情報編集
                    ((McModelCellPropertyDetailFormIF)m_csPropertyDetailForm).EditParameter();
                }

                // 詳細画面表示
                if (m_csPropertyDetailForm.ShowDialog() == DialogResult.OK)
                {// 設定選択した場合
                    m_bDetailModifyFlg = true;

                    // オリジナルプロパティ情報設定
                    m_csPropertyDetailForm.SetOriginalModelPropertyInfo(m_csTempPropertyInfo);
                }
            }
            catch (Exception ex)
            {
                // ログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCellPropertyForm::DetailSet_Click", 
                       Properties.McDotNetViewerResources.STATEMENT_PROP_DATAIL_FORM + Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH
                       + Properties.McDotNetViewerResources.STATEMENT_IN_CLASS + "(" + m_csPropertyDetailForm.ToString() + ") :: " + ex.Message); //ex.StackTrace);
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCellPropertyForm::DetailSet_Click", " PropertyDetailForm Exception Catch " + " in Class(" + m_csPropertyDetailForm.ToString() + ") :: " + ex.Message); //ex.StackTrace);


               // ver1.5 エラートレース日本語対応
                McLog.DebugOut(new HySString(McLog.SYSTEM), new HySString("PropertyDetailForm")
                   , new HySString(Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH + "(" + m_csPropertyDetailForm.ToString() + ") :: " + ex.Message));
               // McLog.DebugOut(new HySString(McLog.SYSTEM), new HySString("PropertyDetailForm")
               //    , new HySString("Exception Catch in (" + m_csPropertyDetailForm.ToString() + ") :: " + ex.Message));
                MessageBox.Show("Abnormal End in PropertyDetailScreen(" + ex.Message + ")", MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
                // 異常通知
                m_csPropertyDetailForm = null;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>端子プロパティクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PortProperty_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PortProperty_Click(object sender, EventArgs e)
        {
            Button[] csTranProperty = { SendPortProperty1, SendPortProperty2, SendPortProperty3 };
            Label[] csIndex = { LabelSendIndex1, LabelSendIndex2, LabelSendIndex3 };
            long lIndex = 0;
            McModelInfo csModelInfo = null;

            for (int iLp = 0; iLp < 3; iLp++)
            {// ３回ループ
                if (((Button)sender).Name == csTranProperty[iLp].Name)
                {// ボタン名称が一致した場合
                    lIndex = long.Parse(csIndex[iLp].Text);
                    csModelInfo = (McModelInfo)m_csTempPropertyInfo.GetOutputConnectionInfoList().GetData(lIndex);
                }
            }
            if (csModelInfo == null)
            {// モデル情報があった場合
                return;
            }

            if (m_bPortDetailModifyIDList == null)
            {// 端子詳細情報変更IDリストがなければ
                m_bPortDetailModifyIDList = new List<HySID>();
            }

            McDotNetModelCellPropertyPortDetailForm csPortForm = new McDotNetModelCellPropertyPortDetailForm();
            csPortForm.SetCellPropertyScreen(m_csScreen as McDotNetModelCellPropertyScreenBase);

            // 画面表示位置設定
            csPortForm.StartPosition = FormStartPosition.CenterScreen;

            // オーナー設定
            csPortForm.Owner = this;

            // 最上位表示設定
            csPortForm.TopMost = false;

            HySString csXmlFileName = new HySString();
            if (csModelInfo.GetPropertyInfo().GetCellIDMngData() != null)
            {// セルと識別子の対応管理データがある場合
                if ((object)csModelInfo.GetPropertyInfo().GetCellIDMngData().GetXmlFileName() != null)
                {// 読み書き用XMLファイル設定がある場合
                    csXmlFileName = csModelInfo.GetPropertyInfo().GetCellIDMngData().GetXmlFileName();
                }
            }
            csPortForm.SetXmlFileName(csXmlFileName);

            if (csPortForm.ShowDialog() == DialogResult.OK)
            {// 設定選択した場合
                HySString csPassName = ((McDotNetModelCellPropertyScreenBase)m_csScreen).GetProjectGroupDirectory() + new HySString("\\");// + csXmlFileName;

                //HySXmlReader csReader = new HySXmlReader(csXmlFileName);
                HySXmlReader csReader = new HySXmlReader(csPassName+csXmlFileName);
                HySXmlNode csRootNode = csReader.GetRootNode();
                HySXmlNodeList csXmlVariableList = csRootNode.GetChildNodeListByTagName(McDefine.xml_TRAN_CELL_MANAGE_TABLE);
                HySObjectKind csKind = new HySObjectKind(csXmlVariableList.GetNode(0).GetAttribute(McDefine.xml_MODELKIND));
                McCellIDMngIF csCellIDMngData = McCellIDMngrFactory.CreateCellIDManageData(csKind);
                csCellIDMngData.SetXmlFileName(csXmlFileName);
                csCellIDMngData.SetXmlFileBasePath(csPassName);
                csCellIDMngData.XmlFileRead();
                csModelInfo.GetPropertyInfo().SetCellIDMngData(csCellIDMngData);

                m_bPortDetailModifyIDList.Remove(csModelInfo.GetElementID());
                m_bPortDetailModifyIDList.Add(csModelInfo.GetElementID());

                m_bPortDetailModifyFlg = true;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

            Close();

            if (m_csPropertyDetailForm != null)
            {// 詳細画面生成済みの場合
                if ((bChangeFlg1 == true) || (bChangeFlg2 == true))
                {// 変更がある場合
                    m_csPropertyDetailForm.FinalOK();
                }
                else
                {// 変更がない場合
                    m_csPropertyDetailForm.FinalCancel();
                }
            }

            if (bChangeFlg2 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetModelCellPropertyScreenBase)m_csScreen).PropertyInfoSet(true);
            }
            else if (bChangeFlg1 == true)
            {// 変更がある場合
                // プロパティ情報設定イベント送信要求
                ((McDotNetModelCellPropertyScreenBase)m_csScreen).ReqPropertyInfoSetEvent();
            }

            ((McDotNetModelCellPropertyScreenBase)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaSet_Check()
        {
            return false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2)
        {
            bool bRtn = false;

            bChangeFlg1 = false;
            bChangeFlg2 = false;

            HySString csKey = new HySString();
            HySString csPropertyName = new HySString();
            McDefine.ValKind lObjKind = new McDefine.ValKind();
            bool bVal = new bool();
            long lVal = new long();
            double dVal = new double();
            string sVal = "";
            bool bOrgVal = new bool();
            long lOrgVal = new long();
            double dOrgVal = new double();
            string sOrgVal = "";

            // 詳細情報（パラメータ）
            for (long lLp = 0; lLp < m_csTempPropertyInfo.GetInfoTypeNum(); lLp++)
            {// プロパティ情報形式数ループ
                // プロパティ情報型式の取得
                if (m_csTempPropertyInfo.GetInfoType(lLp + 1, ref csKey, ref csPropertyName, ref lObjKind) == true)
                {// プロパティ情報型式の取得が出来た場合
                    if (lObjKind == McDefine.ValKind.BOOL)
                    {// 論理型の場合
                        m_csTempPropertyInfo.GetInfo(csKey, ref bVal);
                        m_csPropertyInfo.GetInfo(csKey, ref bOrgVal);
                        if (bVal != bOrgVal)
                        {// 設定変更ありの場合
                            bChangeFlg1 = true;
                            bRtn = true;
                            break;
                        }
                    }
                    else if (lObjKind == McDefine.ValKind.DOUBLE)
                    {// 実数型の場合
                        m_csTempPropertyInfo.GetInfo(csKey, ref dVal);
                        m_csPropertyInfo.GetInfo(csKey, ref dOrgVal);
                        if (dVal != dOrgVal)
                        {// 設定変更ありの場合
                            bChangeFlg1 = true;
                            bRtn = true;
                            break;
                        }
                    }
                    else if (lObjKind == McDefine.ValKind.LONG)
                    {// 倍精度整数型の場合
                        m_csTempPropertyInfo.GetInfo(csKey, ref lVal);
                        m_csPropertyInfo.GetInfo(csKey, ref lOrgVal);
                        if (lVal != lOrgVal)
                        {// 設定変更ありの場合
                            bChangeFlg1 = true;
                            bRtn = true;
                            break;
                        }
                    }
                    else if (lObjKind == McDefine.ValKind.STRING)
                    {// 文字列型の場合
                        m_csTempPropertyInfo.GetInfo(csKey, ref sVal);
                        m_csPropertyInfo.GetInfo(csKey, ref sOrgVal);
                        if (sVal != sOrgVal)
                        {// 設定変更ありの場合
                            bChangeFlg1 = true;
                            bRtn = true;
                            break;
                        }
                    }
                }
            }

            if (bChangeFlg1 == false)
            {// 設定変更なしの場合
                // 詳細情報（初期設定）
                for (long lLp = 0; lLp < m_csTempInitialInfo.GetInfoTypeNum(); lLp++)
                {
                    // 初期設定情報型式の取得
                    if (m_csTempInitialInfo.GetInfoType(lLp + 1, ref csKey, ref csPropertyName, ref lObjKind) == true)
                    {
                        if (lObjKind == McDefine.ValKind.BOOL)
                        {// 論理型の場合
                            m_csTempInitialInfo.GetInfo(csKey, ref bVal);
                            m_csInitialInfo.GetInfo(csKey, ref bOrgVal);
                            if (bVal != bOrgVal)
                            {// 設定変更ありの場合
                                bChangeFlg1 = true;
                                bRtn = true;
                                break;
                            }
                        }
                        else if (lObjKind == McDefine.ValKind.DOUBLE)
                        {// 実数型の場合
                            m_csTempInitialInfo.GetInfo(csKey, ref dVal);
                            m_csInitialInfo.GetInfo(csKey, ref dOrgVal);
                            if (dVal != dOrgVal)
                            {// 設定変更ありの場合
                                bChangeFlg1 = true;
                                bRtn = true;
                                break;
                            }
                        }
                        else if (lObjKind == McDefine.ValKind.LONG)
                        {// 倍精度整数型の場合
                            m_csTempInitialInfo.GetInfo(csKey, ref lVal);
                            m_csInitialInfo.GetInfo(csKey, ref lOrgVal);
                            if (lVal != lOrgVal)
                            {// 設定変更ありの場合
                                bChangeFlg1 = true;
                                bRtn = true;
                                break;
                            }
                        }
                        else if (lObjKind == McDefine.ValKind.STRING)
                        {// 文字列型の場合
                            m_csTempInitialInfo.GetInfo(csKey, ref sVal);
                            m_csInitialInfo.GetInfo(csKey, ref sOrgVal);
                            if (sVal != sOrgVal)
                            {// 設定変更ありの場合
                                bChangeFlg1 = true;
                                bRtn = true;
                                break;
                            }
                        }
                    }
                }
            }

            if (m_bDetailModifyFlg == true)
            {// 詳細情報に変更がある場合
                bChangeFlg2 = true;
                bRtn = true;
            }

            if (m_bPortDetailModifyFlg == true)
            {// 端子詳細情報に変更がある場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    McModelInfo csModelInfo1 = null;
                    McModelInfo csModelInfo2 = null;
                    for (int iLp1 = 0; iLp1 < m_bPortDetailModifyIDList.Count; iLp1++)
                    {// コネクション数ループ
                        for (int iLp2 = 0; iLp2 < m_csPropertyInfo.GetOutputConnectionInfoList().GetCount(); iLp2++)
                        {// コネクション数ループ
                            csModelInfo1 = (McModelInfo)m_csPropertyInfo.GetOutputConnectionInfoList().GetData(iLp2);
                            if (csModelInfo1.GetElementID().Equals(m_bPortDetailModifyIDList[iLp1]) == true)
                            {
                                csModelInfo2 = (McModelInfo)m_csTempPropertyInfo.GetOutputConnectionInfoList().GetData(iLp2);
                                csModelInfo1.GetPropertyInfo().SetCellIDMngData(csModelInfo2.GetPropertyInfo().GetCellIDMngData());
                                break;
                            }
                        }
                    }
                }
                bChangeFlg2 = true;
                bRtn = true;
            }

            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

            if (bRtn == true)
            {// 設定変更の場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    // プロパティ情報変更
                    csElement.GetModelInfo().SetPropertyInfo(m_csTempPropertyInfo);
                    csElement.GetModelInfo().SetInitialInfo(m_csTempInitialInfo);
                }
            }

            // 要素名称
            if (ModelName.Text != m_csElementName.ToString())
            {// 名称が変更されている場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    csElement.SetElementName(new HySString(ModelName.Text));
                }
                bChangeFlg1 = true;
                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            if (m_csPropertyDetailForm != null)
            {// 詳細画面生成済みの場合
                m_csPropertyDetailForm.FinalCancel();
            }

            Close();
            ((McDotNetModelCellPropertyScreenBase)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0004,
                        ((HySDotNetViewer)((HySDotNetScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}