﻿// <summary>ソースコード：ＨＹＭＣＯセル型モデルプロパティ端子詳細設定画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯセル型モデルプロパティ端子詳細設定画面クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/14][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelCellPropertyPortDetailForm : HySDotNetForm
    {
        /// <summary>伝送セル識別情報設定ファイル名</summary>
        private HySString m_csXmlFileName = null;
        /// <summary>ディレクトリ相対化等を行うためのツールとしてのスクリーン </summary>
        McDotNetModelCellPropertyScreenBase m_csCllPrptyScreen = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCellPropertyPortDetailForm csModelCellPropertyPortDetailForm = new McDotNetModelCellPropertyPortDetailForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCellPropertyPortDetailForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>ディレクトリ相対化等を行うためのツールとしてのスクリーンインスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCellPropertyScreen(csCllPrptyScreen)</para>
        /// </example>
        /// <param name="csCllPrptyScreen">ディレクトリ相対化等を行うためのツールとしてのスクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellPropertyScreen(McDotNetModelCellPropertyScreenBase csCllPrptyScreen)
        {
            m_csCllPrptyScreen = csCllPrptyScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送セル識別情報設定ファイル名を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetXmlFileName(csXmlFileName)</para>
        /// </example>
        /// <param name="csXmlFileName">伝送セル識別情報設定ファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetXmlFileName(HySString csXmlFileName)
        {
            m_csXmlFileName = csXmlFileName;

            FilePathTextBox.Text = m_csXmlFileName.ToString();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileSelect_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = "";
            openFileDialog1.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML;    //"ＸＭＬ ファイル (*.xml)|*.xml"
            openFileDialog1.Multiselect = false;
            openFileDialog1.Title = Properties.McDotNetViewerResources.FILE_DLG_TITLE_TRANSMISSION_SEL; //"伝送セル識別情報設定ファイル選択"

            openFileDialog1.RestoreDirectory = true;  // <-- これが重要
            if (m_csXmlFileName.ToString() == "")
            {
                openFileDialog1.InitialDirectory = m_csCllPrptyScreen.GetProjectGroupDirectory().ToString() + "\\ParameterData\\";
            }
            else
            {
                openFileDialog1.InitialDirectory = m_csCllPrptyScreen.GetProjectGroupDirectory().ToString() + "\\" + m_csXmlFileName.ToString();
            }

            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
            {// 入力ファイルを選択した場合
            
                HySString csAbsolutePath = new HySString(openFileDialog1.FileName);
                HySString csRelativePath = new HySString("");
                m_csCllPrptyScreen.GetRelativePathBasedOnProjectGroup(csAbsolutePath, ref csRelativePath);
                FilePathTextBox.Text = csRelativePath.ToString();

                //FilePathTextBox.Text = openFileDialog1.FileName;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            string sFileName = openFileDialog1.InitialDirectory = m_csCllPrptyScreen.GetProjectGroupDirectory().ToString() + "\\" + FilePathTextBox.Text;
            //HySFile csFile = new HySFile(FilePathTextBox.Text);
            HySFile csFile = new HySFile(sFileName);
            if (csFile.Exist() == true)
            {// 既存ファイルが有れば
                //HySXmlReader csReader = new HySXmlReader(FilePathTextBox.Text);
                HySXmlReader csReader = new HySXmlReader(sFileName);

                HySXmlNode csRootNode = csReader.GetRootNode();
                if (csRootNode == null)
                {// ルートノードがない場合
                    FilePathTextBox.BackColor = Color.Red;
                    return;
                }

                HySXmlNode csXml = null;
                HySXmlNodeList csXmlVariableList = null;
                csXmlVariableList = csRootNode.GetChildNodeListByTagName(McDefine.xml_TRAN_CELL_MANAGE_TABLE);
                csXml = csXmlVariableList.GetNode(0);
                if (csXml == null)
                {// ノードがない場合
                    FilePathTextBox.BackColor = Color.Red;
                    return;
                }

                HySObjectKind csKind = new HySObjectKind(csXml.GetAttribute(McDefine.xml_MODELKIND));
                McCellIDMngIF csCellIDMngData = McCellIDMngrFactory.CreateCellIDManageData(csKind) as McCellIDMngIF;
                if (csCellIDMngData == null)
                {// セル識別子とセルの配列管理データが作成できた場合
                    FilePathTextBox.BackColor = Color.Red;
                    return;
                }

                DialogResult = DialogResult.OK;

                m_csXmlFileName.SetChar(FilePathTextBox.Text);
            }
            else
            {// 既存ファイルが無ければ
                FilePathTextBox.BackColor = Color.Red;
                return;
            }

            Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0005, this.Parent);
        }
    }
}