﻿// <summary>ソースコード：モデル管理カスタマイズ画面フォームクラス</summary>
// <remarks>
// <para>[CommonMP][ver 1.0.0][2009/04/16][新規作成]</para>
// </remarks>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデル管理カスタマイズ画面フォームクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/16][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelCtlCustomForm : HySDotNetForm
    {
        /// <summary>モデル編集画面カスタマイズ情報格納クラス</summary>
        private McCustomInfo m_csCustomInfo;

        /// <summary>カラーリスト</summary>
        private List<int> m_iColorList = new List<int>();

        /// <summary>移動量１</summary>
        private int m_iMovementRate1;

        /// <summary>移動量２</summary>
        private int m_iMovementRate2;

        /// <summary>接続線描画太さ</summary>
        private int m_iDrawingThickness;

        /// <summary>要素リサイズポイントサイズ</summary>
        private int m_iResizePointSize;

        /// <summary>ツールバー表示／非表示リスト</summary>
        private List<bool> m_bToolStripVisibleList = new List<bool>();

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCtlCustomForm csCustomForm = new McDotNetModelCtlCustomForm(csCustomInfo)</para>
        /// </example>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCtlCustomForm(McCustomInfo csCustomInfo)
        {
            InitializeComponent();

            m_csCustomInfo = csCustomInfo;

            m_iMovementRate1 = m_csCustomInfo.GetMovementRate1();
            m_iMovementRate2 = m_csCustomInfo.GetMovementRate2();
            m_iDrawingThickness = m_csCustomInfo.GetDrawingThickness();
            m_iResizePointSize = m_csCustomInfo.GetResizePointSize();

            textBox2.Text = m_iMovementRate1.ToString();
            textBox3.Text = m_iMovementRate2.ToString();
            textBox4.Text = m_iDrawingThickness.ToString();
            textBox5.Text = m_iResizePointSize.ToString();

            List<int> iTempColorList = m_csCustomInfo.GetColorList();
            foreach (int iColor in iTempColorList)
            {// カラー数ループ
                m_iColorList.Add(iColor);
            }

            List<HySString> sColorItemList = m_csCustomInfo.GetColorItemList();
            foreach (HySString sItem in sColorItemList)
            {// カラー項目数ループ
                listBox1.Items.Add(sItem.ToString());
            }
            listBox1.SelectedIndex = 0;

            List<HySString> sToolStripExplanationList = m_csCustomInfo.GetToolStripExplanationList();
            List<bool> bTempToolStripVisibleList = m_csCustomInfo.GetToolStripVisibleList();
            for (int iLoop = 0; iLoop < sToolStripExplanationList.Count; iLoop++)
            {// ツールバー説明数ループ
                m_bToolStripVisibleList.Add(bTempToolStripVisibleList[iLoop]);
                checkedListBox1.Items.Add(sToolStripExplanationList[iLoop].ToString(), bTempToolStripVisibleList[iLoop]);
            }
            checkedListBox1.SelectedIndex = 0;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>色選択リスト変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ListBox1_SelectChange(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListBox1_SelectChange(object sender, EventArgs e)
        {
            textBox1.BackColor = ColorTranslator.FromWin32(m_iColorList[listBox1.SelectedIndex]);
            listBox1.Refresh();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>色選択リスト描画編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ListBox1_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListBox1_DrawItem(object sender, DrawItemEventArgs e)
        {
            if (e.Index == -1)
            {// インデックス値がー１の場合
                return;
            }

            //リストボックス
            ListBox mylistBox = (ListBox)sender;
            //項目
            string myTextString = mylistBox.Items[e.Index].ToString();
            //ブラシ
            Brush myTextBrush = Brushes.Black;
            if (e.Index == listBox1.SelectedIndex)
            {// 選択項目の場合
                //ブラシ
                myTextBrush = Brushes.White;
            }
            //ブラシ
            Brush myDrawBrush = new SolidBrush(ColorTranslator.FromWin32(m_iColorList[e.Index]));
            //文字領域の設定
            RectangleF TextRect = new Rectangle(e.Bounds.X + 15, e.Bounds.Y, e.Bounds.Width, e.Bounds.Height);

            //文字領域の設定
            Rectangle DrawRect = new Rectangle(e.Bounds.X + 1, e.Bounds.Y + 1, 10, e.Bounds.Height - 2);

            //背景を描画する
            e.DrawBackground();

            //項目を描画
            e.Graphics.FillRectangle(myDrawBrush, e.Bounds.X + 1, e.Bounds.Y + 1, 10, e.Bounds.Height - 2);
            e.Graphics.DrawRectangle(Pens.Black, e.Bounds.X + 1, e.Bounds.Y + 1, 10, e.Bounds.Height - 2);
            e.Graphics.DrawString(myTextString, e.Font, myTextBrush, TextRect);

            //フォーカスを示す四角形を描画
            e.DrawFocusRectangle();

            //リソース解放
            myDrawBrush.Dispose();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>設定選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GISWaterLevelDataGenerationStart_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button1_Click(object sender, EventArgs e)
        {
            m_csCustomInfo.SetColorList(m_iColorList);
            m_csCustomInfo.SetMovementRate1(m_iMovementRate1);
            m_csCustomInfo.SetMovementRate2(m_iMovementRate2);
            m_csCustomInfo.SetDrawingThickness(m_iDrawingThickness);
            m_csCustomInfo.SetResizePointSize(m_iResizePointSize);
            m_csCustomInfo.SetToolStripVisibleList(m_bToolStripVisibleList);

            m_csCustomInfo.SaveCustomInfo();

            Close();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>キャンセル選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button2_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button2_Click(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>デフォルト選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button5_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button5_Click(object sender, EventArgs e)
        {
            // デフォルト設定
            m_csCustomInfo.SetDefaultColor();

            // 設定値再取り込み
            List<int> iTempColorList = m_csCustomInfo.GetColorList();
            m_iColorList.Clear();
            foreach (int iColor in iTempColorList)
            {// カラー数ループ
                m_iColorList.Add(iColor);
            }
            listBox1.Refresh();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>デフォルト選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button6_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button6_Click(object sender, EventArgs e)
        {
            // デフォルト設定
            m_csCustomInfo.SetDefaultValue();

            // 設定値再取り込み
            m_iMovementRate1 = m_csCustomInfo.GetMovementRate1();
            m_iMovementRate2 = m_csCustomInfo.GetMovementRate2();
            m_iDrawingThickness = m_csCustomInfo.GetDrawingThickness();
            m_iResizePointSize = m_csCustomInfo.GetResizePointSize();

            textBox2.Text = m_iMovementRate1.ToString();
            textBox3.Text = m_iMovementRate2.ToString();
            textBox4.Text = m_iDrawingThickness.ToString();
            textBox5.Text = m_iResizePointSize.ToString();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>要素移動量変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>textBox2_TextChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void textBox2_TextChanged(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(textBox2.Text) < 1)
                {// 設定値が１未満の場合
                    textBox2.Text = m_iMovementRate1.ToString();
                }
                else
                {// 設定値が１以上の場合
                    m_iMovementRate1 = Convert.ToInt32(textBox2.Text);
                }
            }
            catch
            {
                textBox2.Text = m_iMovementRate1.ToString();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示位置移動量変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>textBox3_TextChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(textBox3.Text) < 1)
                {// 設定値が１未満の場合
                    textBox3.Text = m_iMovementRate2.ToString();
                }
                else
                {// 設定値が１以上の場合
                    m_iMovementRate2 = Convert.ToInt32(textBox3.Text);
                }
            }
            catch
            {
                textBox3.Text = m_iMovementRate2.ToString();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>接続線描画太さ変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>textBox4_TextChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void textBox4_TextChanged(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(textBox4.Text) < 1)
                {// 設定値が１未満の場合
                    textBox4.Text = m_iDrawingThickness.ToString();
                }
                else
                {// 設定値が１以上の場合
                    m_iDrawingThickness = Convert.ToInt32(textBox4.Text);
                }
            }
            catch
            {
                textBox4.Text = m_iDrawingThickness.ToString();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>リサイズポイントサイズ変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>textBox5_TextChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void textBox5_TextChanged(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(textBox5.Text) < 1)
                {// 設定値が１未満の場合
                    textBox5.Text = m_iResizePointSize.ToString();
                }
                else
                {// 設定値が１以上の場合
                    m_iResizePointSize = Convert.ToInt32(textBox5.Text);
                }
            }
            catch
            {
                textBox5.Text = m_iResizePointSize.ToString();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>ツールバー設定変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>checkedListBox1_ItemCheck(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void checkedListBox1_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            if (checkedListBox1.SelectedIndex >= 0)
            {// 選択ありの場合
                if (checkedListBox1.GetItemChecked(checkedListBox1.SelectedIndex) == true)
                {// チェックONの場合
                    m_bToolStripVisibleList[checkedListBox1.SelectedIndex] = false;
                }
                else
                {// チェックOFFの場合
                    m_bToolStripVisibleList[checkedListBox1.SelectedIndex] = true;
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {// タブが選択されている場合
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {// タブが選択されていない場合
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>デフォルト選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button3_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button3_Click(object sender, EventArgs e)
        {
            // デフォルト設定
            m_csCustomInfo.SetDefaultLocation();

            // 設定値再取り込み
            List<HySString> sToolStripExplanationList = m_csCustomInfo.GetToolStripExplanationList();
            List<bool> bTempToolStripVisibleList = m_csCustomInfo.GetToolStripVisibleList();
            m_bToolStripVisibleList.Clear();
            checkedListBox1.Items.Clear();
            for (int iLoop = 0; iLoop < sToolStripExplanationList.Count; iLoop++)
            {// ツールバー説明数ループ
                m_bToolStripVisibleList.Add(bTempToolStripVisibleList[iLoop]);
                checkedListBox1.Items.Add(sToolStripExplanationList[iLoop].ToString(), bTempToolStripVisibleList[iLoop]);
            }
            checkedListBox1.SelectedIndex = 0;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>色選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button4_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button4_Click(object sender, EventArgs e)
        {
            ColorDialog csColorDialog = new ColorDialog();
            csColorDialog.CustomColors = new int[] { m_iColorList[listBox1.SelectedIndex] };
            csColorDialog.Color = ColorTranslator.FromWin32(m_iColorList[listBox1.SelectedIndex]);
            if (csColorDialog.ShowDialog() == DialogResult.OK)
            {// カラーの設定をした場合 
                m_iColorList[listBox1.SelectedIndex] = ColorTranslator.ToWin32(csColorDialog.Color);
                listBox1.Refresh();
                textBox1.BackColor = ColorTranslator.FromWin32(m_iColorList[listBox1.SelectedIndex]);
            }
            csColorDialog.Dispose();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0006, null);
        }
    }
}