﻿// <summary>ソースコード：モデル管理画面フォームクラス</summary>
// <remarks>
// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
// </remarks>
// <author>CommonMP</author>
using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.Serialization.Formatters.Binary;
using System.Reflection;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer.Data;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;     
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;
using CommonMP.HYMCO.CoreOptionl.HymcoStandardModel; 

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデル管理画面フォームクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][メソッド追加]
    /// </para>
    /// </remarks>
    public partial class McDotNetModelCtlForm : HySDotNetForm
    {
        /// <summary>タブ表示数</summary>
        private int m_iTabCount;

        /// <summary>表示スケール値</summary>
        private long m_lDispScale;

        /// <summary>表示スケール値（前回値）</summary>
        private long m_lDispScaleBefore;

        /// <summary>描画モード種別</summary>
        private McDefine.DrawModeKind m_eDrawMode;

        /// <summary>シンボル種別</summary>
        private McDefine.SymbolDrawKind m_eSymbolKind;

        /// <summary>シンボル描画サブ種別</summary>
        private HySObjectKind m_csDrawSubKind;

        /// <summary>グラフックオブジェクト管理クラス</summary>
        private McGraphicsManager m_csGraphicsManager;

        /// <summary>プロパティリストソートカラムインデックス</summary>
        private int[] m_iPropertyListSortColumnIndex = { 0, 0, 0, 0, 0 };

        /// <summary>追加エレメントIDリスト</summary>
        private List<HySIdentifier> m_csAddElementIdList;

        /// <summary>接続線用要素テンポラリ</summary>
        private McGraphicsElement m_csElementTemp;

        /// <summary>モデル編集領域（幅）</summary>
        private int m_iWidth;

        /// <summary>モデル編集領域（高さ）</summary>
        private int m_iHeight;

        /// <summary>マウスダウンフラグ</summary>
        private bool m_bMouseDownF;

        /// <summary>マウスダウン座標</summary>
        private Point m_pFirstClickPoint = new Point();

        /// <summary>マウス移動座標</summary>
        private Point m_pMovePoint = new Point();

        /// <summary>貼り付け座標</summary>
        private Point m_pPastePoint = new Point();

        /// <summary>貼り付け座標フラグ</summary>
        private bool m_bPastePointFlg = false;

        /// <summary>移動中フラグ</summary>
        private bool m_bMoveFlg;

        /// <summary>端子選択フラグ</summary>
        private bool m_bPortFlg;

        /// <summary>リサイズフラグ</summary>
        private bool m_bResizeFlg;

        /// <summary>クリップボードフラグ</summary>
        private bool m_bClipBoardFlg;

        /// <summary>選択要素</summary>
        private McGraphicsElement m_csSelectElm;

        /// <summary>演算モデルチェック結果情報クラス</summary>
        private McStructCheckData m_csStructCheckData;

        /// <summary>演算ログ情報クラス</summary>
        private McModelLogData m_csModelLogData;

        /// <summary>表示エレメントリスト</summary>
        private List<List<McGraphicsElement>> m_csDispElmList;

        /// <summary>表示接続線リスト</summary>
        private List<McGraphicsElement> m_csDispLineList;

        /// <summary>表示スケール値リスト</summary>
        private List<long> m_lDispScaleList;

        /// <summary>表示編集座標左上</summary>
        private Point m_pDispPoint;

        /// <summary>表示編集座標左上リスト</summary>
        private List<Point> m_pDispPointList;

        /// <summary>プロパティリストソートカラムインデックスリスト</summary>
        private List<int[]> m_iPropertyListSortColumnIndexList;     //必要ない？？

        /// <summary>クローズフラグ</summary>
        private bool m_bCloseScreenFlg = false;

        /// <summary>復元ポイント管理</summary>
        private List<McHistoryData> m_csReconstructionDataList;

        /// <summary>シミュレーション状態保持情報管理</summary>
        private List<McSimulationStatus> m_csSimulationStatusList;

        /// <summary>復元ポイントカレントポインタ</summary>
        private int m_iReconstructionPointPointer;

        /// <summary>復元情報ワーク</summary>
        private List<object> m_csHistoryDataWork;

        /// <summary>復元状態フラグ</summary>
        private bool m_bReconstructionUndoFlg = false;

        /// <summary>復元状態フラグ</summary>
        private bool m_bReconstructionRedoFlg = false;

        /// <summary>描画モード種別テンポラリ</summary>
        private McDefine.DrawModeKind m_eTempDrawMode;

        /// <summary>フォーム終了中状態フラグ</summary>
        private bool m_bFormClosingFlg = false;

        /// <summary>初期表示フラグ</summary>
        private bool m_bInitialIndicationFlg = true;

        /// <summary>イメージサイズ比率</summary>
        static private readonly double IMAGE_SIZE_RATIO = 3.0;

        /// <summary>表示設定(ID)</summary>
        private bool m_bDispKindID = false;

        /// <summary>表示設定(名称)</summary>
        private bool m_bDispKindName = false;

        /// <summary>編集座標左上</summary>
        private Point m_pReDrawPoint;

        /// <summary>モデル編集領域（幅）</summary>
        private int m_iReDrawWidth;

        /// <summary>モデル編集領域（高さ）</summary>
        private int m_iReDrawHeight;

        /// <summary>モデル編集画面カスタマイズ情報格納クラス</summary>
        private McCustomInfo m_csCustomInfo;

        /// <summary>モデル管理ガイドマップ画面</summary>
        private McDotNetModelCtlSimpleMapForm m_csSimpleMap = null;

        /// <summary>シミュレーション状態</summary>
        private McSimulationStatus.CalculationStatus m_eSimulationKind = McSimulationStatus.CalculationStatus.INITIAL;

        /// <summary>モデル管理ガイドマップ画面デフォルト幅</summary>
        static private readonly int SIMPLEMAP_WIDTH = 360;

        /// <summary>モデル管理ガイドマップ画面デフォルト高さ</summary>
        static private readonly int SIMPLEMA_HEIGHT = 310;

        /// <summary>モデル管理ガイドマップ 画面配置デスクトップ座標X</summary>
        static private int SIMPLEMAP_DESKTOP_LOCATION_X = 0;

        /// <summary>モデル管理ガイドマップ 画面配置デスクトップ座標X調整値</summary>
        static private readonly int SIMPLEMAP_DESKTOP_LOCATION_X_ADJUSTED_VALUE = 8;

        /// <summary>モデル管理ガイドマップ 画面配置デスクトップ座標Y調整値</summary>
        static private readonly int SIMPLEMAP_DESKTOP_LOCATION_Y_ADJUSTED_VALUE = 73;

        /// <summary>ユーザー設定IDのショートタイプ表示桁数</summary>
        static private readonly int USER_MAKE_ID_SHORT_LENGTH = 4;

        /// <summary>シミュレーション開始要求中</summary>
        private bool m_bSimStartReq = false;

        //メッセージ定義
		/// <summary>メッセージタイトル『モデル管理機能』 </summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_MODEL_MANAGEMENT");

		/// <summary>演算中メッセージ『シュミレーションモデルを計算中のため、閉じることはできません。』 </summary>   
        static private readonly string MSG_SIMULATION_EXECUTE = HysMessage.GetString("HYS_MSG_WARNING_SIMULATION_EXECUTE"); 
        
		/// <summary>中継端子削除メッセージ『 接続情報のある中継端子を削除しようとしています。\n削除しますか？　　　　　　　　　　　　　　　　　』
		///</summary>
        static private readonly string MSG_RELAY_TERMINAL_DELETE = McMessage.GetString("MC_MSG_QUESTION_CONFILM_RELAY_TERMINAL");

		///<summary>モデルチェックメッセージ『接続されていない中継端子{0}があります。』</summary>
		static private readonly string MSG_CHECK_RELAY_TERMINAL = McMessage.GetString("MC_MSG_CHECK_RELAY_TERMINAL");

		///<summary>モデルチェックメッセージ『入力方式が設定されていません。』</summary>
		static private readonly string MSG_CHECK_INPUT = McMessage.GetString("MC_MSG_CHECK_INPUT");

		///<summary>モデルチェックメッセージ『出力方式が設定されていません。』</summary>
		static private readonly string MSG_CHECK_OUTPUT = McMessage.GetString("MC_MSG_CHECK_OUTPUT");

		///<summary>モデルチェックメッセージ『演算モデルが設定されていません。』</summary>
		static private readonly string MSG_CHECK_OPERATION_MODEL = McMessage.GetString("MC_MSG_CHECK_OPERATION_MODEL");

		///<summary>モデルチェックメッセージ『伝送情報型が設定されていません。』</summary>
		static private readonly string MSG_CHECK_CHANNEL = McMessage.GetString("MC_MSG_CHECK_CHANNEL");

        /// <summary>移動操作間引き用前処理時間</summary>
        private DateTime m_csPreprocessingTime = DateTime.Now;

        /// <summary>移動操作間引き時間（Millisecond）</summary>
        //static private readonly int CULL_TIME = 250;
        static private readonly int CULL_TIME = 0;

        /// <summary>描画オフフラグ</summary>
        private bool m_bModelDispOffFlg = false;

        // バックグラウンド操作化
        /// <summary>外部データベースツール起動状態フラグ</summary>
        private bool m_bExtDBToolStateFlg = false;

        /// <summary>スクロール移動幅</summary>
        static private readonly int LARGECHANGE_DEFAULT = 10000;

        /// <summary>スクロール移動量</summary>
        static private readonly int SCROLL_MAXIMUM = 20000;

        /// <summary>縦スクロールバー設定値</summary>
        private int m_iVScroll;

        /// <summary>横スクロールバー設定値</summary>
        private int m_iHScroll;

        /// <summary>スクロール可能位置左</summary>
        private int m_iScrollLeft = 0;

        /// <summary>スクロール可能位置右</summary>
        private int m_iScrollRight = 0;

        /// <summary>スクロール可能位置上</summary>
        private int m_iScrollTop = 0;

        /// <summary>スクロール可能位置下</summary>
        private int m_iScrollBottom = 0;

        /// <summary>スクロール可能位置左上</summary>
        private List<Point> m_pScrollLeftTop;

        /// <summary>スクロール可能位置右下</summary>
        private List<Point> m_pScrollRightBottom;

        /// <summary>編集エリア左</summary>
        private int m_iEditLeft = 0;

        /// <summary>編集エリア右</summary>
        private int m_iEditRight = 0;

        /// <summary>編集エリア上</summary>
        private int m_iEditTop = 0;

        /// <summary>編集エリア下</summary>
        private int m_iEditBottom = 0;

        /// <summary>編集エリア左上</summary>
        private List<Point> m_pEditLeftTop;

        /// <summary>編集エリア右下</summary>
        private List<Point> m_pEditRightBottom;

        /// <summary>Gr内部のイメージハッシュ</summary>
        private Hashtable m_csGrImgTbl = new Hashtable();

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCtlForm csDotNetForm = new McDotNetModelCtlForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McDotNetModelCtlForm()
        {
            InitializeComponent();
            m_csGraphicsManager = new McGraphicsManager();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCtlForm csDotNetForm = new McDotNetModelCtlForm(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCtlForm(HySScreen csScreen)
        {
            InitializeComponent();
            KeyPreview = true;

            this.TabPage1Panel.BackgroundImage = new Bitmap(LayerRubberBand.Width, LayerRubberBand.Height);

            HySString sImageFolder = HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE_FOLDER"));
            HySString sImageName = HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE"));

            if (((object)sImageFolder != null) && ((object)sImageName != null))
            {// 情報取得できた場合
                HySFile csFile = new HySFile(HySEnvInf.GetHomeDirectory().ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE_FOLDER")).ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE")).ToString());
                if (csFile.Exist() == true)
                {// 背景画像があった場合
                    // 背景画像セット右下表示
                    Graphics csGraphics = Graphics.FromImage(TabPage1Panel.BackgroundImage);
                    Bitmap csBackgroundImage = new Bitmap(HySEnvInf.GetHomeDirectory().ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE_FOLDER")).ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE")).ToString());
                    csGraphics.DrawImage(csBackgroundImage, new Point(LayerRubberBand.Width - csBackgroundImage.Width, LayerRubberBand.Height - csBackgroundImage.Height));
                    csGraphics.Dispose();
                    csBackgroundImage.Dispose();
                }
            }

            this.SetStyle(ControlStyles.UserPaint |
                          ControlStyles.AllPaintingInWmPaint |
                          ControlStyles.OptimizedDoubleBuffer |
                          ControlStyles.SupportsTransparentBackColor,
                          true);

            this.TransparencyKey = Color.Transparent;

            PictureBox[] csPictBox = { LayerElement, LayerPort, LayerLine, LayerID, LayerName, LayerElementSelect, LayerPortSelect, LayerLineSelect, LayerMoveTemp };
            foreach (PictureBox csPB in csPictBox)
            {// レイヤー数ループ
                // 各レイヤービットマップ割り付け
                csPB.Image = new Bitmap(LayerRubberBand.Width, LayerRubberBand.Height);
            }
            LayerRubberBand.Image = new Bitmap(LayerRubberBand.Width, LayerRubberBand.Height);

            m_iTabCount = 1;
            m_csScreen = csScreen;
            m_csGraphicsManager = new McGraphicsManager();
            m_csDispElmList = new List<List<McGraphicsElement>>();
            m_lDispScaleList = new List<long>();
            m_pDispPointList = new List<Point>();
            m_iPropertyListSortColumnIndexList = new List<int[]>();
            m_csReconstructionDataList = new List<McHistoryData>();
            m_csSimulationStatusList = new List<McSimulationStatus>();
            m_iReconstructionPointPointer = 0;
            m_pEditLeftTop = new List<Point>();
            m_pEditRightBottom = new List<Point>();
            m_pScrollLeftTop = new List<Point>();
            m_pScrollRightBottom = new List<Point>();

            m_csAddElementIdList = new List<HySIdentifier>();

            Initial();

            IDTypeButton.Checked = false;
            // ID表示ロング／ショート表示設定
            TabPage1DataGridView1.Columns[TabPage1Column10.Name].Visible = false;
            TabPage1DataGridView1.Columns[TabPage1Column11.Name].Visible = true;
            TabPage1DataGridView2.Columns[TabPage1Column20.Name].Visible = false;
            TabPage1DataGridView2.Columns[TabPage1Column21.Name].Visible = true;
            TabPage1DataGridView3.Columns[TabPage1Column30.Name].Visible = false;
            TabPage1DataGridView3.Columns[TabPage1Column31.Name].Visible = true;
            TabPage1DataGridView4.Columns[TabPage1Column40.Name].Visible = false;
            TabPage1DataGridView4.Columns[TabPage1Column41.Name].Visible = true;
            TabPage1DataGridView4.Columns[TabPage1Column42.Name].Visible = false;
            TabPage1DataGridView4.Columns[TabPage1Column43.Name].Visible = true;
            TabPage1DataGridView4.Columns[TabPage1Column46.Name].Visible = false;
            TabPage1DataGridView4.Columns[TabPage1Column47.Name].Visible = true;
            TabPage1DataGridView5.Columns[TabPage1Column50.Name].Visible = false;
            TabPage1DataGridView5.Columns[TabPage1Column51.Name].Visible = true;

            TabPage1DataGridView1.Rows.Clear();
            TabPage1DataGridView2.Rows.Clear();
            TabPage1DataGridView3.Rows.Clear();
            TabPage1DataGridView4.Rows.Clear();
            TabPage1DataGridView5.Rows.Clear();

            CalcLogList.Items.Clear();
            CalcLogList.ClearSelected();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イニシャル</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Initial()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Initial()
        {
            m_lDispScale = 100;
            m_lDispScaleBefore = m_lDispScale;
            m_lDispScaleList.Add(m_lDispScale);
            ZoomSizeComboBox.Text = "100%";

            // 画面サイズ設定
            m_iWidth = LayerRubberBand.Width;
            m_iHeight = LayerRubberBand.Height;

            int[] iTemp = { 0, 0, 0, 0, 0 };
            m_iPropertyListSortColumnIndexList.Add(iTemp);

            // 画面座標（左上）設定
            m_pDispPoint = new Point();
            m_pDispPoint.X = 0 - m_iWidth / 2;
            m_pDispPoint.Y = 0 - m_iHeight / 2;
            m_pDispPointList.Add(m_pDispPoint);

            // 画面表示領域座標設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);

            ButtonSelectInit();

            // セレクトモード設定
            ObjectSelect(null, null);

            m_bMouseDownF = false;
            m_pFirstClickPoint.X = 0;
            m_pFirstClickPoint.Y = 0;
            m_bMoveFlg = false;

            m_bResizeFlg = false;

            SimStartButton.Enabled = true;              // 計算開始・再開
            SimPauseButton.Enabled = false;             // 計算中断
            SimStopButton.Enabled = false;              // 計算停止
            SimResetButton.Enabled = false;             // 計算リセット

            // クリップボードチェック
            if (CheckClipBoard() == false)
            {// クリップボード保存データ無効の場合
                m_bClipBoardFlg = false;
                PasteButton.Enabled = false;
            }
            else
            {// クリップボード保存データ有効の場合
                m_bClipBoardFlg = true;
                PasteButton.Enabled = true;
            }

            // 取込後の表示エリアの取得及びチェック
            Point pPointLeftTop = new Point();
            Point pPointRightBottom = new Point();
            if (m_csGraphicsManager.GetDispRect(ref pPointLeftTop, ref pPointRightBottom) == 0)
            {   // 表示エレメント有り
                CheckDispArea(pPointLeftTop, pPointRightBottom);
            }
            else
            {   // 表示エレメント無し
                SetDefaultRect();
            }

            // スクロールバーの再描画
            ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

            // 編集エリアスクロールエリアセット
            Point pPoint = new Point();
            pPoint.X = m_iScrollLeft;
            pPoint.Y = m_iScrollTop;
            m_pScrollLeftTop.Add(pPoint);
            pPoint = new Point();
            pPoint.X = m_iScrollRight;
            pPoint.Y = m_iScrollBottom;
            m_pScrollRightBottom.Add(pPoint);
            pPoint = new Point();
            pPoint.X = m_iEditLeft;
            pPoint.Y = m_iEditTop;
            m_pEditLeftTop.Add(pPoint);
            pPoint = new Point();
            pPoint.X = m_iEditRight;
            pPoint.Y = m_iEditBottom;
            m_pEditRightBottom.Add(pPoint);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素間接続情報セット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetStructInfo( csStruct )</para>
        /// </example>
        /// <param name="csStruct">要素間接続情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetStructInfo(McStructInfo csStruct)
        {
            LayerMoveTemp.Size = new Size(5, 5);
            LayerMoveTemp.Location = new Point(-10, -10);

            // グループ表示タブクローズ
            TabControl.SelectedIndex = 0;
            PartDispClose(null, null);

            m_csGraphicsManager = new McGraphicsManager();

            m_csDispElmList.Clear();
            m_lDispScaleList.Clear();
            m_iPropertyListSortColumnIndexList.Clear();
            m_pDispPointList.Clear();

            // ヒストリークリア
            ReconstructionPointDelete(0);

            Initial();

            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            // 要素間接続情報セット
            m_csGraphicsManager.SetStructInfo(csStruct);

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            // 全体構成情報設定
            m_csDispElmList.Add(m_csGraphicsManager.GetElementList());
            m_csDispLineList = m_csGraphicsManager.GetLineList();

            m_csGraphicsManager.SetDispScale(m_lDispScale);

            m_csGraphicsManager.SetCustomInfo(m_csCustomInfo);

            //要素名称・ID表示設定取得
            ((McDotNetModelCtlScreen)m_csScreen).GetDispKind();

            if (IDTypeButton.Checked == true)
            {// IDフル表示の場合
                m_csGraphicsManager.SetIDDispMode(true);
            }

            // リスト部編集
            PropertyListEdit(0, true);

            // プロジェクト内配置要素中心計算
            long lX = 0;
            long lY = 0;
            if (m_csDispElmList[0].Count != 0)
            {// 要素数が０以外の場合
                McViewTransFormer.ProjectCenterPositionCalc(m_csDispElmList[0], ref lX, ref lY);
                m_pDispPoint.X = (int)lX - m_iWidth / 2;
                m_pDispPoint.Y = (int)lY - m_iHeight / 2;
            }

            m_pDispPointList[TabControl.SelectedIndex] = m_pDispPoint;

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.PORT |
                        McDefine.LayerKind.LINE |
                        McDefine.LayerKind.ID |
                        McDefine.LayerKind.NAME |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            // グラフ画面クローズ
            ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenCloseEvent(new HySID(""));

            // プロパティ画面クローズ
            ((McDotNetModelCtlScreen)m_csScreen).PropetyScreenClose();

            m_bInitialIndicationFlg = true;

            //復元ポイント記録
            ReconstructionPointSave(true, new McHistoryData());

            m_bInitialIndicationFlg = false;

            // 取込後の表示エリアの取得及びチェック
            Point pPointLeftTop = new Point();
            Point pPointRightBottom = new Point();
            if (m_csGraphicsManager.GetDispRect(ref pPointLeftTop, ref pPointRightBottom) == 0)
            {   // 表示エレメント有り
                CheckDispArea(pPointLeftTop, pPointRightBottom);
            }

            // スクロールバーの再描画
            ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

            // 編集エリア及びスクロールエリアの記録
            Point pPoint = new Point();
            pPoint.X = m_iScrollLeft;
            pPoint.Y = m_iScrollTop;
            m_pScrollLeftTop[TabControl.SelectedIndex] = pPoint;
            pPoint = new Point(); ;
            pPoint.X = m_iScrollRight;
            pPoint.Y = m_iScrollBottom;
            m_pScrollRightBottom[TabControl.SelectedIndex] = pPoint;
            pPoint = new Point(); ;
            pPoint.X = m_iEditLeft;
            pPoint.Y = m_iEditTop;
            m_pEditLeftTop[TabControl.SelectedIndex] = pPoint;
            pPoint = new Point(); ;
            pPoint.X = m_iEditRight;
            pPoint.Y = m_iEditBottom;
            m_pEditRightBottom[TabControl.SelectedIndex] = pPoint;

            // モデル管理ガイドマップ再描画
            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            // 画面クローズ中かチェック
            if (m_bFormClosingFlg == false)
            {// 画面クローズ中ではない場合
                ((McDotNetModelCtlScreen)m_csScreen).NoticeActive();

                // クリップボードチェック
                if (CheckClipBoard() == false)
                {// クリップボード保存データ無効の場合
                    m_bClipBoardFlg = false;
                    PasteButton.Enabled = false;
                }
                else
                {// クリップボード保存データ有効の場合
                    m_bClipBoardFlg = true;
                    PasteButton.Enabled = true;
                }

                if (m_csCustomInfo == null)
                {// カスタマイズ情報がない場合
                    m_csCustomInfo = new McCustomInfo();
                    m_csGraphicsManager.SetCustomInfo(m_csCustomInfo);

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT |
                                McDefine.LayerKind.PORT |
                                McDefine.LayerKind.LINE |
                                McDefine.LayerKind.ID |
                                McDefine.LayerKind.NAME |
                                McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    // モードチェック
                    if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
                    {// 表示位置スクロールモードの場合
                        //編集領域設定
                        Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
                        m_pDispPoint.X = m_pDispPoint.X - (int)(m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                        m_pDispPoint.Y = m_pDispPoint.Y - (int)(m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                        m_pReDrawPoint.X = m_pDispPoint.X;
                        m_pReDrawPoint.Y = m_pDispPoint.Y;
                        m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / m_lDispScale);
                        m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / m_lDispScale);

                        // グラフィック部編集
                        LayerReDraw(McDefine.LayerKind.MOVE, true, true);

                        m_pDispPoint.X = pTempPoint.X;
                        m_pDispPoint.Y = pTempPoint.Y;
                    }

                    // ツールバーカスタマイズ情報復元
                    ToolbarCustomSet();
                }
                else
                {// カスタマイズ情報がある場合
                    // カスタマイズ情報変更チェック
                    McCustomInfo.CustomInfoModificationStatus eModificationStatus = m_csCustomInfo.ModificationCheck();

                    if (((eModificationStatus & McCustomInfo.CustomInfoModificationStatus.MODIFIED_COLOR) != 0) ||
                        ((eModificationStatus & McCustomInfo.CustomInfoModificationStatus.MODIFIED_VALUE) != 0))
                    {// カスタマイズ情報が変更されている場合
                        m_csGraphicsManager.SetCustomInfo(m_csCustomInfo);

                        // グラフィック部編集
                        LayerReDraw(McDefine.LayerKind.ELEMENT |
                                    McDefine.LayerKind.PORT |
                                    McDefine.LayerKind.LINE |
                                    McDefine.LayerKind.ID |
                                    McDefine.LayerKind.NAME |
                                    McDefine.LayerKind.ELEMENT_SELECT |
                                    McDefine.LayerKind.PORT_SELECT |
                                    McDefine.LayerKind.LINE_SELECT,
                                    true,
                                    true);

                        // モードチェック
                        if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
                        {// 表示位置スクロールモードの場合
                            //編集領域設定
                            Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
                            m_pDispPoint.X = m_pDispPoint.X - (int)(m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                            m_pDispPoint.Y = m_pDispPoint.Y - (int)(m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                            m_pReDrawPoint.X = m_pDispPoint.X;
                            m_pReDrawPoint.Y = m_pDispPoint.Y;
                            m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / m_lDispScale);
                            m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / m_lDispScale);

                            // グラフィック部編集
                            LayerReDraw(McDefine.LayerKind.MOVE, true, true);

                            m_pDispPoint.X = pTempPoint.X;
                            m_pDispPoint.Y = pTempPoint.Y;
                        }

                        // モデル管理ガイドマップ再描画
                        if (m_csSimpleMap != null)
                        {// モデル管理ガイドマップ表示中の場合
                            m_csSimpleMap.CustomInfoChange(m_csCustomInfo);
                        }
                    }

                    if ((eModificationStatus & McCustomInfo.CustomInfoModificationStatus.MODIFIED_TOOLBAR) != 0)
                    {// ツールバーカスタマイズ情報に変更がある場合
                        // ツールバーカスタマイズ情報復元
                        ToolbarCustomSet();
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面通知捕捉処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="m">Windowsメッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void WndProc(ref Message m)
        {
            const int WM_SYSCOMMAND = 0x0112;
            const int SC_MINIMIZE = 0xF020;
            const int SC_MAXIMIZE = 0xF030;
            // 最小化を検出し、最小化前の配置・形状情報を保存しておく
            if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MINIMIZE && this.WindowState == FormWindowState.Normal)
            {// 通常表示状態から最小化の場合
                // 配置情報を保存
                Properties.Settings.Default.ModelLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.ModelClientSize = this.ClientSize;
            }
            else if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MAXIMIZE && this.WindowState == FormWindowState.Normal)
            {// 通常表示状態から最大化の場合
                // 配置情報を保存
                Properties.Settings.Default.ModelLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.ModelClientSize = this.ClientSize;
            }
            base.WndProc(ref m);
        }

        /// <summary><para>method outline</para>
        /// <para>Formが閉じられる前に発生するイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FormClosingEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormClosingEvent(object sender, FormClosingEventArgs e)
        {
            // 画面クローズ中かチェック
            if (m_bCloseScreenFlg == false)
            {// 画面クローズ中ではない場合
                if (e.CloseReason == CloseReason.UserClosing)
                {   // オペレータがクローズ操作をした場合
                    e.Cancel = true;

                    // ViewerJobでクローズキャンセル時にメインフォームのウィンドウリストから外れないようにする。
                    typeof(Form).GetProperty("CloseReason", BindingFlags.NonPublic | BindingFlags.Instance).SetValue(this, CloseReason.None, null);

                    // シミュレーション中かチェック
                    if (m_eSimulationKind != McSimulationStatus.CalculationStatus.CALCULATING)
                    {// シミュレーション中以外の場合
                        ((McDotNetModelCtlScreen)m_csScreen).ModelFormUserClose();
                    }
                    else
                    {// シミュレーション中の場合
                        MessageBox.Show(MSG_SIMULATION_EXECUTE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    }
                }
            }
            // ウィンドウ情報を保存
            Properties.Settings.Default.ModelWindowState = this.WindowState;
            if (this.WindowState == FormWindowState.Normal)
            {// 通常表示状態の場合(最小化状態の場合は、WndProc()にて保存済)
                // 配置情報を保存
                Properties.Settings.Default.ModelLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.ModelClientSize = this.ClientSize;
            }
            // 外部ファイルに保存
            Properties.Settings.Default.Save();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ロード時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FormLoadEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormLoadEvent(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.ModelLocation.X != -1 && Properties.Settings.Default.ModelLocation.Y != -1)
            {
                // 保存情報をもとに配置情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.Location = Properties.Settings.Default.ModelLocation;
            }
            if (Properties.Settings.Default.ModelClientSize.Height != -1 && Properties.Settings.Default.ModelClientSize.Width != -1)
            {
                // 保存情報をもとに形状情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.ClientSize = Properties.Settings.Default.ModelClientSize;
            }
            // 保存情報をもとにウィンドウ状態を復元
            //this.WindowState = Properties.Settings.Default.ModelWindowState;// 最小化・最大化うまくいかない
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FormShownEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormShownEvent(object sender, EventArgs e)
        {
            // 保存情報をもとにウィンドウ状態を復元
            //this.WindowState = Properties.Settings.Default.ModelWindowState;// 最小化・最大化うまくいかない
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算マスク</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetMask(eCalcuStatus, bSimStart)</para>
        /// </example>
        /// <param name="eCalcuStatus">計算状態種別</param>
        /// <param name="bSimStart">シミュレーション開始要求中解除</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMask(McSimulationStatus.CalculationStatus eCalcuStatus, bool bSimStart)
        {
            m_eSimulationKind = eCalcuStatus;

            // シミュレーション中かチェック
            if (m_eSimulationKind == McSimulationStatus.CalculationStatus.CALCULATING)
            {// シミュレーション中の場合
                this.TabControl.Enabled = false;
                this.SplitContainer1.Enabled = false;
            }
            else
            {// シミュレーション中以外の場合
                this.TabControl.Enabled = true;
                this.SplitContainer1.Enabled = true;
            }

            // シミュレーション開始中かチェック
            if (bSimStart == true)
            {// シミュレーション開始中の場合
                m_bSimStartReq = false;
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>クローズフラグセット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCloseScreenFlg()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCloseScreenFlg()
        {
            // 画面クローズ中設定
            m_bCloseScreenFlg = true;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが閉じた後に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClosedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormClosedEvent(object sender, FormClosedEventArgs e)
        {
            m_bFormClosingFlg = true;

            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            //復元ポイント削除
            ReconstructionPointDelete(0);

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            // モデル管理ガイドマップクローズ
            if (m_csSimpleMap != null)
            {// モデル管理ガイドマップ表示中の場合
                m_csSimpleMap.Close();
            }

            ((McDotNetModelCtlScreen)m_csScreen).NoticeClosed();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示エリアチェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckDispArea( pPointLeftTop, pPointRightBottom )</para>
        /// </example>
        /// <param name="pPointLeftTop">表示座標左上</param>
        /// <param name="pPointRightBottom">表示座標右下</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CheckDispArea(Point pPointLeftTop, Point pPointRightBottom)
        {
            int iLeftAdd = 0;               // 左増分
            int iRightAdd = 0;              // 右増分
            int iTopAdd = 0;                // 上増分
            int iBottomAdd = 0;             // 下増分
            int iLeftEditWork = 0;          // 編集エリア左
            int iRightEditWork = 0;         // 編集エリア右
            int iTopEditWork = 0;           // 編集エリア上
            int iBottomEditWork = 0;        // 編集エリア下
            int iLeftScrollWork = 0;        // スクロールエリア左
            int iRightScrollWork = 0;       // スクロールエリア右
            int iTopScrollWork = 0;         // スクロールエリア上
            int iBottomScrollWork = 0;      // スクロールエリア下

            if (pPointLeftTop.X >= -(m_iWidth / 2) && pPointLeftTop.X <= m_iWidth / 2)
            {   // 座標は初期範囲内
                m_iEditLeft = -(m_iWidth / 2);
                m_iScrollLeft = -m_iWidth;
            }
            else
            {   // 座標は初期範囲外
                if (m_iEditLeft < pPointLeftTop.X && m_iEditLeft < -(m_iWidth / 2))
                {   // 編集エリア左端範囲内且つ左端初期値未満
                    iLeftEditWork = m_iEditLeft;
                    iLeftScrollWork = m_iScrollLeft;
                    for (; ; )
                    {   // 左編集エリアスクロールエリアチェック
                        iLeftAdd += m_iWidth / 2;
                        if (pPointLeftTop.X < m_iEditLeft + iLeftAdd)
                        {   // 加算後の編集エリアが左座標を越えている
                            m_iEditLeft = iLeftEditWork;
                            m_iScrollLeft = iLeftScrollWork;
                            break;
                        }
                        iLeftEditWork += m_iWidth / 2;
                        iLeftScrollWork += m_iWidth / 2;
                    }
                }
                else
                {   // 編集エリア左端範囲外
                    for (; ; )
                    {   // 編集エリアスクロールエリアチェック
                        if (m_iEditLeft - iLeftAdd < pPointLeftTop.X)
                        {   // エレメント座標左が編集エリア左を越えている
                            m_iEditLeft -= iLeftAdd;
                            m_iScrollLeft -= iLeftAdd;
                            break;
                        }
                        iLeftAdd += m_iWidth / 2;
                    }
                }
            }
            if (pPointRightBottom.X >= -(m_iWidth / 2) && pPointRightBottom.X <= m_iWidth / 2)
            {   // 座標は初期範囲内
                m_iEditRight = m_iWidth / 2;
                m_iScrollRight = m_iWidth;
            }
            else
            {   // 座標は初期範囲外
                if (m_iEditRight > pPointRightBottom.X && m_iEditRight > m_iWidth / 2)
                {   // 編集エリア右端範囲内且つ右端が初期値を越えている
                    iRightEditWork = m_iEditRight;
                    iRightScrollWork = m_iScrollRight;
                    for (; ; )
                    {   // 右編集エリアスクロールエリアチェック
                        iRightAdd += m_iWidth / 2;
                        if (pPointRightBottom.X > m_iEditRight - iRightAdd)
                        {   // エレメント座標右が減算後の編集エリア右を越えている
                            m_iEditRight = iRightEditWork;
                            m_iScrollRight = iRightScrollWork;
                            break;
                        }
                        iRightEditWork -= m_iWidth / 2;
                        iRightScrollWork -= m_iWidth / 2;
                    }
                }
                else
                {   // 編集エリア右端範囲外
                    for (; ; )
                    {   // 右編集エリアスクロールエリアチェック
                        if (m_iEditRight + iRightAdd > pPointRightBottom.X)
                        {   // エレメント座標右が編集エリア右未満
                            m_iEditRight += iRightAdd;
                            m_iScrollRight += iRightAdd;
                            break;
                        }
                        iRightAdd += m_iWidth / 2;
                    }
                }
            }
            if (pPointLeftTop.Y >= -(m_iHeight / 2) && pPointLeftTop.Y <= m_iHeight / 2)
            {   // 座標は初期範囲内
                m_iEditTop = -(m_iHeight / 2);
                m_iScrollTop = -m_iHeight;
            }
            else
            {   // 座標は初期範囲外
                if (m_iEditTop < pPointLeftTop.Y && m_iEditTop < -(m_iHeight / 2))
                {   // 編集エリア上端範囲内且つ上端初期値未満
                    iTopEditWork = m_iEditTop;
                    iTopScrollWork = m_iScrollTop;
                    for (; ; )
                    {   // 上編集エリアスクロールエリアチェック
                        iTopAdd += m_iHeight / 2;
                        if (pPointLeftTop.Y < m_iEditTop + iTopAdd)
                        {   // 加算後の編集エリアが座標上を越えている
                            m_iEditTop = iTopEditWork;
                            m_iScrollTop = iTopScrollWork;
                            break;
                        }
                        iTopEditWork += m_iHeight / 2;
                        iTopScrollWork += m_iHeight / 2;
                    }
                }
                else
                {  // 編集エリア上端範囲外
                    for (; ; )
                    {   // 上編集エリアスクロールエリアチェック
                        if (m_iEditTop - iTopAdd < pPointLeftTop.Y)
                        {   // エレメント座標上が編集エリア左を越えている
                            m_iEditTop -= iTopAdd;
                            m_iScrollTop -= iTopAdd;
                            break;
                        }
                        iTopAdd += m_iHeight / 2;
                    }
                }
            }
            if (pPointRightBottom.Y >= -(m_iHeight / 2) && pPointRightBottom.Y <= m_iHeight / 2)
            {   // 座標は初期範囲内
                m_iEditBottom = m_iHeight / 2;
                m_iScrollBottom = m_iHeight;
            }
            else
            {   // 座標は初期範囲外
                if (m_iEditBottom > pPointRightBottom.Y && m_iEditBottom > m_iHeight / 2)
                {   // 編集エリア下端範囲内且つ下端が初期値を越えている
                    iBottomEditWork = m_iEditBottom;
                    iBottomScrollWork = m_iScrollBottom;
                    for (; ; )
                    {   // 下編集エリアスクロールエリアチェック
                        iBottomAdd += m_iHeight / 2;
                        if (pPointRightBottom.Y > m_iEditBottom - iBottomAdd)
                        {   // エレメント座標下が減算後の編集エリア下を越えている
                            m_iEditBottom = iBottomEditWork;
                            m_iScrollBottom = iBottomScrollWork;
                            break;
                        }
                        iBottomEditWork -= m_iHeight / 2;
                        iBottomScrollWork -= m_iHeight / 2;
                    }
                }
                else
                {   // 編集エリア下端範囲外
                    for (; ; )
                    {   // 下編集エリアスクロールエリアチェック
                        if (m_iEditBottom + iBottomAdd > pPointRightBottom.Y)
                        {   // エレメント座標下が編集エリア右未満
                            m_iEditBottom += iBottomAdd;
                            m_iScrollBottom += iBottomAdd;
                            break;
                        }
                        iBottomAdd += m_iHeight / 2;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>編集スクロール範囲デフォルトセット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetDefaultRect( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetDefaultRect( )
        {
            m_iEditLeft = -(m_iWidth / 2);
            m_iEditRight = m_iWidth / 2;
            m_iEditTop = -(m_iHeight / 2);
            m_iEditBottom = m_iHeight / 2;
            m_iScrollLeft = -m_iWidth;
            m_iScrollRight = m_iWidth;
            m_iScrollTop = -m_iHeight;
            m_iScrollBottom = m_iHeight;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系表示タブ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartDisp( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartDisp(object sender, EventArgs e)
        {
            List<McGraphicsElement> csTempList = new List<McGraphicsElement>();

            //選択情報内のグループ要素取得
            McGraphicsElement csGroupElement = m_csGraphicsManager.GetGroupElement();
            if (csGroupElement == null)
            {// 選択情報内にグループ要素がない場合
                return;
            }

            // 追加前に同一部分系の存在チェック
            for (int iLp = 1; iLp < m_iTabCount; iLp++)
            {// グループ内部表示タブ数ループ
                if (csGroupElement.GetID().ToString() == m_csDispElmList[iLp][0].GetID().ToString())
                {// IDが一致した場合
                    TabControl.SelectedIndex = iLp;
                    return;
                }
            }

            csTempList.Add(csGroupElement);

            // 追加タブ名称(部分系名称とする)
            TabPage tab1 = null;
            if (csGroupElement.GetID().ToString().IndexOf('-') != -1)
            {// 分割出来る場合
                tab1 = new TabPage(Properties.McDotNetViewerResources.MODEL_TAB_PART + csGroupElement.GetElementName().ToString().Trim() + " " + csGroupElement.GetID().ToString().Substring(0, csGroupElement.GetID().ToString().IndexOf('-')) + "...");
            }
            else
            {// 分割出来ない場合
                if (csGroupElement.GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                {// IDの長さが既定値以下の場合
                    tab1 = new TabPage(Properties.McDotNetViewerResources.MODEL_TAB_PART + csGroupElement.GetElementName().ToString().Trim() + " " + csGroupElement.GetID().ToString() + "...");
                }
                else
                {// IDの長さが既定値より大きいの場合
                    tab1 = new TabPage(Properties.McDotNetViewerResources.MODEL_TAB_PART + csGroupElement.GetElementName().ToString().Trim() + " " + csGroupElement.GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH) + "...");
                }
            }

            // タブを追加する
            TabControl.TabPages.Add(tab1);
            m_iTabCount++;

            //新規タブ用リスト情報編集
            m_csDispElmList.Add(csTempList);
            m_lDispScale = 100;
            m_lDispScaleList.Add(m_lDispScale);
            int[] iTemp = { 0, 0, 0, 0, 0 };
            m_iPropertyListSortColumnIndexList.Add(iTemp);

            m_pDispPoint = new Point();
            m_pDispPoint.X = 0 - m_iWidth / 2;
            m_pDispPoint.Y = 0 - m_iHeight / 2;

            // プロジェクト内配置要素中心計算
            long lX = 0;
            long lY = 0;
            if (m_csDispElmList[TabControl.TabPages.Count - 1].Count != 0)
            {// 要素数が０以外の場合
                McViewTransFormer.ProjectCenterPositionCalc(((McGraphicsGroupElement)m_csDispElmList[TabControl.TabPages.Count - 1][0]).GetGroupElementList(), ref lX, ref lY);
                m_pDispPoint.X = (int)lX - m_iWidth / 2;
                m_pDispPoint.Y = (int)lY - m_iHeight / 2;
            }

            m_pDispPointList.Add(m_pDispPoint);

            // 取込後の表示エリアの取得及びチェック
            Point pPointLeftTop = new Point();
            Point pPointRightBottom = new Point();
            //if (m_csGraphicsManager.GetDispRect(ref pPointLeftTop, ref pPointRightBottom) == 0)
            if (((McGraphicsGroupElement)csGroupElement).GetDispRect(ref pPointLeftTop, ref pPointRightBottom) == 0)
            {   // 表示エレメント有り
                CheckDispArea(pPointLeftTop, pPointRightBottom);
            }
            else
            {   // 表示エレメント無し
                SetDefaultRect();
            }

            // スクロールバーの再描画
            ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

            // 編集エリアスクロールエリアセット
            Point pPoint = new Point();
            pPoint.X = m_iScrollLeft;
            pPoint.Y = m_iScrollTop;
            m_pScrollLeftTop.Add(pPoint);
            pPoint = new Point();
            pPoint.X = m_iScrollRight;
            pPoint.Y = m_iScrollBottom;
            m_pScrollRightBottom.Add(pPoint);
            pPoint = new Point();
            pPoint.X = m_iEditLeft;
            pPoint.Y = m_iEditTop;
            m_pEditLeftTop.Add(pPoint);
            pPoint = new Point();
            pPoint.X = m_iEditRight;
            pPoint.Y = m_iEditBottom;
            m_pEditRightBottom.Add(pPoint);

            TabControl.SelectedTab = tab1;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系表示タブ削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartDispClose( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartDispClose(object sender, EventArgs e)
        {
            if (TabControl.TabCount > 1)
            {// グループ内部表示タブがある場合
                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                if (TabControl.SelectedIndex == 0)
                {// 全体系タブ表示中の場合
                    // 全体タブ以外を削除する
                    for (; m_iTabCount > 1; )
                    {// グループ内部表示タブ数ループ
                        TabControl.TabPages.RemoveAt(m_iTabCount - 1);

                        //削除タブ情報をリストから削除
                        m_csDispElmList.RemoveAt(m_iTabCount - 1);
                        m_lDispScaleList.RemoveAt(m_iTabCount - 1);
                        m_iPropertyListSortColumnIndexList.RemoveAt(m_iTabCount - 1);
                        m_pDispPointList.RemoveAt(m_iTabCount - 1);

                        m_iTabCount--;
                    }

                    TabControl.SelectedIndex = 0;
                }
                else
                {// 全体系タブ以外を表示中の場合
                    //削除タブ情報をリストから削除
                    m_csDispElmList.RemoveAt(TabControl.SelectedIndex);
                    m_lDispScaleList.RemoveAt(TabControl.SelectedIndex);
                    m_iPropertyListSortColumnIndexList.RemoveAt(TabControl.SelectedIndex);
                    m_pDispPointList.RemoveAt(TabControl.SelectedIndex);

                    TabControl.TabPages.RemoveAt(TabControl.SelectedIndex);

                    m_iTabCount--;
                }

                //タブ切り替え時のカレント情報設定
                CurrentInformationSet();

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系表示タブ選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelTabChange( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ModelTabChange(object sender, EventArgs e)
        {
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.3では下記コードを追加する（Gr内表示） 
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            this.MakeGrImage();

            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            //タブ切り替え時のカレント情報設定
            CurrentInformationSet();

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.3では下記コードを追加する（Gr内表示） 
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary>
        /// <para>method outline:</para>
        /// <para>Gr要素内部のイメージ画像作成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MakeGrImage()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MakeGrImage()
        {
            // イメージ画像は要素IDと対で管理し、
            // 描画時は要素IDをkeyにする為タブ切り替え順序の意識不要
            // タブ切り替わり時
            int iImageX = m_pDispPoint.X * (int)m_lDispScale / 100;
            int iImageY = m_pDispPoint.Y * (int)m_lDispScale / 100;
            // イメージ画像に対応する要素IDを取得
            List<McGraphicsElement> csElemList = m_csGraphicsManager.GetElementList();
            HySID csGrElmId = new HySID("");
            Bitmap csGrImg = null;
            McGraphicsElement ParElm = m_csGraphicsManager.GetPossessionElement();
            if (ParElm != null)
            {
                csGrElmId = (HySID)ParElm.GetID();
            }
            else
            {
                // 取得できない場合（全体系→部分系表示時）
                for (int iLp = 0; iLp < csElemList.Count; iLp++)
                {
                    // 自分の親（グループ要素又は全体系のIDを取得する）
                    csGrElmId = (HySID)csElemList[iLp].GetViewerElm().GetOwnerElement().GetID();
                    if (csGrElmId.GetString().ToString() != "")
                    {
                        // 取得すれば、ループを抜ける（自分の親はみな同じ。要素数が膨大な場合遅延の原因となる）
                        break;
                    }
                }
            }
            if (csElemList.Count != 0)
            {
                // イメージ画像の生成
                csGrImg = new Bitmap((int)(m_iWidth), (int)(m_iHeight));
                Graphics csGraphics = Graphics.FromImage(csGrImg);
                m_csGraphicsManager.DrawObjectElement(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                m_csGraphicsManager.DrawObjectLine(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                m_csGraphicsManager.DrawObjectPort(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                m_csGraphicsManager.DrawObjectName(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
            }
            // 要素が存在しない場合イメージ画像はnull
            // ハッシュに追加（複数のGrタブを識別する為）
            //m_csGrImgTbl.Add(csGrElmId.ToString(), csGrImg);// Keyが重複すると例外発生
            m_csGrImgTbl[csGrElmId.ToString()] = csGrImg;// Keyが重複しても上書き
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タブ切り替え時のカレント情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CurrentInformationSet()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CurrentInformationSet()
        {
            // 切り替えタブチェック
            if (TabControl.SelectedIndex == 0)
            {// 全体系タブ表示中の場合
                m_csGraphicsManager.SetElementList(m_csDispElmList[TabControl.SelectedIndex]);
                m_csGraphicsManager.SetLineList(m_csDispLineList);
                m_csGraphicsManager.SetPossessionElement(null);
            }
            else
            {// 全体系タブ以外を表示中の場合
                m_csGraphicsManager.SetElementList(((McGraphicsGroupElement)m_csDispElmList[TabControl.SelectedIndex][0]).GetGroupElementList());
                m_csGraphicsManager.SetLineList(((McGraphicsGroupElement)m_csDispElmList[TabControl.SelectedIndex][0]).GetGroupLineElementList());
                m_csGraphicsManager.SetPossessionElement(m_csDispElmList[TabControl.SelectedIndex][0]);
            }

            // 切り替えタブ情報設定
            m_lDispScale = m_lDispScaleList[TabControl.SelectedIndex];
            m_lDispScaleBefore = m_lDispScale;
            ZoomSizeComboBox.Text = System.Convert.ToString(m_lDispScale) + '%';

            m_csGraphicsManager.SetDispScale(m_lDispScale);

            m_iPropertyListSortColumnIndex = m_iPropertyListSortColumnIndexList[TabControl.SelectedIndex];
            m_pDispPoint = m_pDispPointList[TabControl.SelectedIndex];

            // リスト部編集
            PropertyListEdit(0, true);

            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.3では下記コードを追加する（Gr内表示） 
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // Gr内部のイメージをセット
            m_csGraphicsManager.SetGrImage(m_csGrImgTbl);

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.PORT |
                        McDefine.LayerKind.LINE |
                        McDefine.LayerKind.ID |
                        McDefine.LayerKind.NAME |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);

            ButtonSelectInit();

            LayerMove.Visible = false;

            m_bMouseDownF = false;
            m_pFirstClickPoint.X = 0;
            m_pFirstClickPoint.Y = 0;
            m_bMoveFlg = false;

            m_bResizeFlg = false;

            // クリップボードチェック
            if (CheckClipBoard() == false)
            {// クリップボード保存データ無効の場合
                m_bClipBoardFlg = false;
                PasteButton.Enabled = false;
            }
            else
            {// クリップボード保存データ有効の場合
                m_bClipBoardFlg = true;
                PasteButton.Enabled = true;
            }

            if (SelectButton.Checked == false)
            {// セレクトモード以外の場合
                // セレクトモード設定
                ObjectSelect(null, null);
            }

            Point pPoint;
            pPoint = m_pScrollLeftTop[TabControl.SelectedIndex];
            m_iScrollLeft = pPoint.X;
            m_iScrollTop = pPoint.Y;
            pPoint = m_pScrollRightBottom[TabControl.SelectedIndex];
            m_iScrollRight = pPoint.X;
            m_iScrollBottom = pPoint.Y;
            pPoint = m_pEditLeftTop[TabControl.SelectedIndex];
            m_iEditLeft = pPoint.X;
            m_iEditTop = pPoint.Y;
            pPoint = m_pEditRightBottom[TabControl.SelectedIndex];
            m_iEditRight = pPoint.X;
            m_iEditBottom = pPoint.Y;

            // 取込後の表示エリアの取得及びチェック
            Point pPointLeftTop = new Point();
            Point pPointRightBottom = new Point();
            if (m_csGraphicsManager.GetDispRect(ref pPointLeftTop, ref pPointRightBottom) == 0)
            {   // 表示エレメント有り
                CheckDispArea(pPointLeftTop, pPointRightBottom);
            }
            else
            {   // 表示エレメント無し
                SetDefaultRect();
            }

            int iWorkX = m_pDispPoint.X - m_iEditLeft;
            int iWorkY = m_pDispPoint.Y - m_iEditTop;
            int iMoveX = 0;
            int iMoveY = 0;
            // 編集エリアの上端又は左端が変わる場合は、スクロールを行い
            // その後要素が上端又は左端に描画されるように再描画する。
            if ((iWorkX < 0 && iWorkX < -(m_iWidth / 2)) || (iWorkY < 0 && iWorkY < -(m_iHeight / 2)))
            {   // 編集エリア左上が更新される変更あり
                if (iWorkX < 0 && iWorkX < -(m_iWidth / 2))
                {   // 編集エリア左が更新される変更あり
                    iMoveX = m_pDispPoint.X - pPointLeftTop.X;
                }
                if (iWorkY < 0 && iWorkY < -(m_iHeight / 2))
                {   // 編集エリア上が更新される変更あり
                    iMoveY = m_pDispPoint.Y - pPointLeftTop.Y;
                }
                iMoveX = iMoveX * (int)m_lDispScale / 100;
                iMoveY = iMoveY * (int)m_lDispScale / 100;
                DisplayPositionScroll(iMoveX, iMoveY);
            }

            // スクロールバーの再描画
            ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

            // モデル管理ガイドマップ再描画
            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>一覧表示タブ選択前処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ListTabChangeBefore( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListTabChangeBefore(object sender, TabControlCancelEventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_MODEL_CHECK)
            {// モデルチェック中以外の場合
                m_eTempDrawMode = m_eDrawMode;
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>一覧表示タブ選択後処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ListTabChangeAfter( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListTabChangeAfter(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_MODEL_CHECK)
            {// モデルチェック中以外の場合
                //プロパティリスト選択同期
                ListSelectionMatching();
                m_eDrawMode = m_eTempDrawMode;

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ボタン選択初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ButtonSelectInit();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        private void ButtonSelectInit()
        {
            MoveButton.Checked = false;                 // 画面移動ボタンチェック状態
            SelectButton.Checked = false;               // 選択ボタンチェック状態解除
            CalcGrElementMenu.Checked = false;          // 収束演算系Gr要素メニューチェック状態解除
            CalcGrElementButton.Checked = false;        // 収束演算系Gr要素ボタンチェック状態解除
            PartGrElementMenu.Checked = false;          // 部分系Gr要素メニューチェック状態解除
            PartGrElementButton.Checked = false;        // 部分系Gr要素ボタンチェック状態解除
            LaneElementMenu.Checked = false;            // 河道要素メニューチェック状態解除
            LaneElementButton.Checked = false;          // 河道要素ボタンチェック状態解除
            BasinElementMenu.Checked = false;           // 流域要素メニューチェック状態解除
            BasinElementButton.Checked = false;         // 流域要素ボタンチェック状態解除
            OutputElementMenu.Checked = false;          // 出力要素メニューチェック状態解除
            OutputElementButton.Checked = false;        // 出力要素ボタンチェック状態解除
            InputElementMenu.Checked = false;           // 入力要素メニューチェック状態解除
            InputElementButton.Checked = false;         // 入力要素ボタンチェック状態解除
            UserElementMenu.Checked = false;            // ユーザ要素メニューチェック状態解除
            UserElementButton.Checked = false;          // ユーザ要素ボタンチェック状態解除
            JunctionElementMenu.Checked = false;        // データマージ要素メニューチェック状態解除
            JunctionElementButton.Checked = false;      // データマージ要素ボタンチェック状態解除
            ElementConnectButton.Checked = false;       // 要素接続ボタンチェック状態解除
            PasteButton.Checked = false;                // 貼り付けボタンチェック状態解除
        }

        // バックグラウンド操作化
        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブステータス変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ChangeSimulationButtonStatus();</para>
        /// </example>
        /// <param name="bflg">bool true:有効 false:無効</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ChangeSimulationButtonStatus(bool bflg)
        {
            if (bflg == true)
            {
                m_bExtDBToolStateFlg = false;
                this.ButtonEnabledSet();
            }
            else
            {
                m_bExtDBToolStateFlg = true;
                SimStartButton.Enabled = false;             // 計算開始・再開
                SimPauseButton.Enabled = false;              // 計算中断
                SimStopButton.Enabled = false;               // 計算停止
                SimResetButton.Enabled = false;             // 計算リセット
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ボタン活性／非活性設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ButtonEnabledSet();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        private void ButtonEnabledSet()
        {
            if (m_eSimulationKind == McSimulationStatus.CalculationStatus.CALCULATING)    //　計算開始・再開
            {// シミュレーション中の場合
                if (m_bExtDBToolStateFlg == false)
                {// バックグラウンド操作化
                    SimStartButton.Enabled = false;             // 計算開始・再開
                    SimPauseButton.Enabled = true;              // 計算中断
                    SimStopButton.Enabled = true;               // 計算停止
                    SimResetButton.Enabled = false;             // 計算リセット
                }

                SelectButton.Enabled = false;               // 選択
                MoveButton.Enabled = false;                 // 画面移動
                ZoomInButton.Enabled = false;               // ズームイン
                ZoomOutButton.Enabled = false;              // ズームアウト
                ZoomSizeComboBox.Enabled = false;           // 倍率
                SimpleMapButton.Enabled = false;            // モデル管理ガイドマップ

                CutButton.Enabled = false;                  // カットボタン
                CopyButton.Enabled = false;                 // コピーボタン
                m_bClipBoardFlg = false;                    // ペーストフラグ
                PasteButton.Enabled = false;                // ペーストボタン
                DeleteButton.Enabled = false;               // 削除ボタン
                UndoButton.Enabled = false;                 // UNDOボタン
                RedoButton.Enabled = false;                 // REDOボタン
                TopButton.Enabled = false;                  // Topボタン
                BottomButton.Enabled = false;               // Bottomボタン
                Left90degRotationButton.Enabled = false;    // 左回転ボタン
                Right90degRotationButton.Enabled = false;   // 右回転ボタン
                AllLeft90degRotationButton.Enabled = false; // 左全回転ボタン[2010/01/07]追加
                AllRight90degRotationButton.Enabled = false;// 右全回転ボタン[2010/01/07]追加
                IDTypeButton.Enabled = false;               // IDTypeボタン

                ElementDiagramMenu.Enabled = false;         // 要素配置ボタン
                ElementConnectButton.Enabled = false;       // 要素接続ボタン
                CalcGrButton.Enabled = false;               // グループ化(収束演算)ボタン
                PartGrButton.Enabled = false;               // グループ化(部分系)ボタン
                GrCancelButton.Enabled = false;             // グループ化解除ボタン
                ConnectCheckButton.Enabled = false;         // モデルチェックボタン
                TreeDisplayButton.Enabled = false;          // ツリー表示ボタン
                PartGrElementButton.Enabled = false;        // 部分系Gr要素ボタン
                CalcGrElementButton.Enabled = false;        // 収束演算系Gr要素ボタン
                BasinElementButton.Enabled = false;         // 流域要素ボタン
                LaneElementButton.Enabled = false;          // 河道要素ボタン
                UserElementButton.Enabled = false;          // ユーザ要素ボタン
                OutputElementButton.Enabled = false;        // 出力要素ボタン
                InputElementButton.Enabled = false;         // 入力要素ボタン
                JunctionElementButton.Enabled = false;      // データマージ要素ボタン

                ElementLineUpUpButton.Enabled = false;      // 要素整列（上方向）ボタン
                ElementLineUpBottomButton.Enabled = false;  // 要素整列（下方向）ボタン
                ElementLineUpLeftButton.Enabled = false;    // 要素整列（左方向）ボタン
                ElementLineUpRightButton.Enabled = false;   // 要素整列（右方向）ボタン
                ElementEqualDistanceLineUpVButton.Enabled = false;      // 要素等間隔整列（縦）ボタン
                ElementEqualDistanceLineUpHButton.Enabled = false;      // 要素等間隔整列（横）ボタン
            }
            else
            {// シミュレーション中以外の場合
                if (m_eSimulationKind == McSimulationStatus.CalculationStatus.INTERRUPTED)        // 計算中断
                {// シミュレーション中断の場合
                    if (m_bExtDBToolStateFlg == false)
                    {// バックグラウンド操作化
                        SimStartButton.Enabled = true;              // 計算開始・再開
                        SimPauseButton.Enabled = false;             // 計算中断
                        SimStopButton.Enabled = true;               // 計算停止
                        SimResetButton.Enabled = false;             // 計算リセット
                    }
                }
                else if (m_eSimulationKind == McSimulationStatus.CalculationStatus.FINISHED_STOP)         // 強制終了
                {// シミュレーション強制終了の場合
                    if (m_bExtDBToolStateFlg == false)
                    {// バックグラウンド操作化
                        SimStartButton.Enabled = true;              // 計算開始・再開
                        SimPauseButton.Enabled = false;             // 計算中断
                        SimStopButton.Enabled = false;              // 計算停止
                        SimResetButton.Enabled = true;              // 計算リセット
                    }
                }
                else if (m_eSimulationKind == McSimulationStatus.CalculationStatus.FINISHED)     // 計算終了
                {// シミュレーション計算終了の場合
                    if (m_bExtDBToolStateFlg == false)
                    {// バックグラウンド操作化
                        SimStartButton.Enabled = true;              // 計算開始・再開
                        SimPauseButton.Enabled = false;             // 計算中断
                        SimStopButton.Enabled = false;              // 計算停止
                        SimResetButton.Enabled = true;              // 計算リセット
                    }
                }
                else if (m_eSimulationKind == McSimulationStatus.CalculationStatus.INITIAL)  // 未計算
                {// シミュレーション未計算の場合
                    if (m_bSimStartReq != true)
                    {// シミュレーション開始中以外の場合
                        if (m_bExtDBToolStateFlg == false)
                        {// バックグラウンド操作化
                            SimStartButton.Enabled = true;              // 計算開始・再開
                            SimPauseButton.Enabled = false;             // 計算中断
                            SimStopButton.Enabled = false;              // 計算停止
                            SimResetButton.Enabled = false;             // 計算リセット
                        }
                    }
                }

                if (((McDotNetModelCtlScreen)m_csScreen).GetExtDBToolStatus() == true)
                {   // 外部ＤＢツール起動中
                    ChangeSimulationButtonStatus(false);
                }

                SelectButton.Enabled = true;                // 選択
                MoveButton.Enabled = true;                  // 画面移動
                ZoomInButton.Enabled = true;                // ズームイン
                ZoomOutButton.Enabled = true;               // ズームアウト
                ZoomSizeComboBox.Enabled = true;            // 倍率
                SimpleMapButton.Enabled = true;             // モデル管理ガイドマップ

                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)    // 選択モード
                {// 選択モードの場合
                    //選択中要素別カウンター取得
                    int[] iElementCounter = m_csGraphicsManager.GetSelectionCount();
                    int iElmCount = m_csGraphicsManager.GetElementList().Count;

                    CutButton.Enabled = false;                  // カットボタン
                    CopyButton.Enabled = false;                 // コピーボタン
                    DeleteButton.Enabled = false;               // 削除ボタン
                    TopButton.Enabled = false;                  // Topボタン
                    BottomButton.Enabled = false;               // Bottomボタン
                    Left90degRotationButton.Enabled = false;    // 左回転ボタン
                    Right90degRotationButton.Enabled = false;   // 右回転ボタン
                    AllLeft90degRotationButton.Enabled = false; // 左全回転ボタン[2010/01/07]追加
                    AllRight90degRotationButton.Enabled = false;// 右全回転ボタン[2010/01/07]追加
                    if ((iElementCounter[0] > 0) || (iElementCounter[1] > 0))   // 要素・Gr要素選択あり？
                    {// 要素またはGr要素が選択されている場合
                        CutButton.Enabled = true;                   // カットボタン
                        CopyButton.Enabled = true;                  // コピーボタン
                        DeleteButton.Enabled = true;                // 削除ボタン
                        TopButton.Enabled = true;                   // Topボタン
                        BottomButton.Enabled = true;                // Bottomボタン
                        Left90degRotationButton.Enabled = true;     // 左回転ボタン
                        Right90degRotationButton.Enabled = true;    // 右回転ボタン
                        AllLeft90degRotationButton.Enabled = true; // 左全回転ボタン[2010/01/11]追加
                        AllRight90degRotationButton.Enabled = true;// 右全回転ボタン[2010/01/11]追加
                    }
                    if (iElementCounter[3] > 0)                 // 中継端子選択あり？
                    {// 中継端子が選択されている場合
                        DeleteButton.Enabled = true;                // 削除ボタン
                    }
                    if (iElementCounter[4] > 0)                 //接続線選択あり？
                    {// 接続線が選択されている場合
                        DeleteButton.Enabled = true;                // 削除ボタン
                    }
                    if (CheckClipBoard() == false)                 // クリップボード空？
                    {// クリップボード保存データ無効の場合
                        m_bClipBoardFlg = false;                    // ペーストフラグ
                        PasteButton.Enabled = false;                // ペーストボタン
                    }
                    else
                    {// クリップボード保存データ有効の場合
                        m_bClipBoardFlg = true;                     // ペーストフラグ
                        PasteButton.Enabled = true;                 // ペーストボタン
                    }
                    if (m_iReconstructionPointPointer <= 1)      // Undo可能？
                    {// Undoが不可能な場合
                        UndoButton.Enabled = false;                 // UNDOボタン
                    }
                    else
                    {// Undoが可能な場合
                        UndoButton.Enabled = true;                  // UNDOボタン
                    }
                    if (m_csReconstructionDataList.Count <= m_iReconstructionPointPointer)    // Redo可能？
                    {// Redoが不可能な場合
                        RedoButton.Enabled = false;                 // REDOボタン
                    }
                    else
                    {// Redoが可能な場合
                        RedoButton.Enabled = true;                  // REDOボタン
                    }
                    IDTypeButton.Enabled = true;                // IDTypeボタン

                    ElementDiagramMenu.Enabled = true;          // 要素配置ボタン
                    ElementConnectButton.Enabled = true;        // 要素接続ボタン
                    if ((iElementCounter[0] > 0) || (iElementCounter[1] > 0))   // 要素・Gr要素選択あり？
                    {// 要素またはGr要素が選択されている場合
                        CalcGrButton.Enabled = true;                // グループ化(収束演算)ボタン
                        PartGrButton.Enabled = true;                // グループ化(部分系)ボタン
                    }
                    else
                    {// 要素またはGr要素の選択がない場合
                        CalcGrButton.Enabled = false;               // グループ化(収束演算)ボタン
                        PartGrButton.Enabled = false;               // グループ化(部分系)ボタン
                    }
                    if (iElementCounter[1] == 1)                 // Gr要素選択あり？
                    {// Gr要素が１つ選択されている場合
                        GrCancelButton.Enabled = true;              // グループ化解除ボタン
                    }
                    else
                    {// Gr要素が選択されていないまたは複数選択されている場合
                        GrCancelButton.Enabled = false;             // グループ化解除ボタン
                    }
                    ConnectCheckButton.Enabled = true;          // モデルチェックボタン
                    TreeDisplayButton.Enabled = true;           // ツリー表示ボタン
                    PartGrElementButton.Enabled = true;         // 部分系Gr要素ボタン
                    CalcGrElementButton.Enabled = true;         // 収束演算系Gr要素ボタン
                    BasinElementButton.Enabled = true;          // 流域要素ボタン
                    LaneElementButton.Enabled = true;           // 河道要素ボタン
                    UserElementButton.Enabled = true;           // ユーザ要素ボタン
                    OutputElementButton.Enabled = true;         // 出力要素ボタン
                    InputElementButton.Enabled = true;          // 入力要素ボタン
                    JunctionElementButton.Enabled = true;       // データマージ要素ボタン

                    ElementLineUpUpButton.Enabled = false;      // 要素整列（上方向）ボタン
                    ElementLineUpBottomButton.Enabled = false;  // 要素整列（下方向）ボタン
                    ElementLineUpLeftButton.Enabled = false;    // 要素整列（左方向）ボタン
                    ElementLineUpRightButton.Enabled = false;   // 要素整列（右方向）ボタン
                    ElementEqualDistanceLineUpVButton.Enabled = false;      // 要素等間隔整列（縦）ボタン
                    ElementEqualDistanceLineUpHButton.Enabled = false;      // 要素等間隔整列（横）ボタン
                    if (iElementCounter[0] + iElementCounter[1] + iElementCounter[5] > 1)   // 要素・Gr要素・内部中継端子選択あり？
                    {// 要素またはGr要素または内部中継端子が選択されている場合
                        ElementLineUpUpButton.Enabled = true;      // 要素整列（上方向）ボタン
                        ElementLineUpBottomButton.Enabled = true;  // 要素整列（下方向）ボタン
                        ElementLineUpLeftButton.Enabled = true;    // 要素整列（左方向）ボタン
                        ElementLineUpRightButton.Enabled = true;   // 要素整列（右方向）ボタン
                        ElementEqualDistanceLineUpVButton.Enabled = true;      // 要素等間隔整列（縦）ボタン
                        ElementEqualDistanceLineUpHButton.Enabled = true;      // 要素等間隔整列（横）ボタン
                    }
                }
                else if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)  // 画面移動モード
                {// 表示位置スクロールモードの場合
                    CutButton.Enabled = false;                  // カットボタン
                    CopyButton.Enabled = false;                 // コピーボタン
                    m_bClipBoardFlg = false;                    // ペーストフラグ
                    PasteButton.Enabled = false;                // ペーストボタン
                    DeleteButton.Enabled = false;               // 削除ボタン
                    UndoButton.Enabled = false;                 // UNDOボタン
                    RedoButton.Enabled = false;                 // REDOボタン
                    TopButton.Enabled = false;                  // Topボタン
                    BottomButton.Enabled = false;               // Bottomボタン
                    Left90degRotationButton.Enabled = false;    // 左回転ボタン
                    Right90degRotationButton.Enabled = false;   // 右回転ボタン
                    AllLeft90degRotationButton.Enabled = false; // 左全回転ボタン[2010/01/07]追加
                    AllRight90degRotationButton.Enabled = false;// 右全回転ボタン[2010/01/07]追加
                    IDTypeButton.Enabled = false;               // IDTypeボタン

                    ElementDiagramMenu.Enabled = false;         // 要素配置ボタン
                    ElementConnectButton.Enabled = false;       // 要素接続ボタン
                    CalcGrButton.Enabled = false;               // グループ化(収束演算)ボタン
                    PartGrButton.Enabled = false;               // グループ化(部分系)ボタン
                    GrCancelButton.Enabled = false;             // グループ化解除ボタン
                    ConnectCheckButton.Enabled = false;         // モデルチェックボタン
                    TreeDisplayButton.Enabled = false;          // ツリー表示ボタン
                    PartGrElementButton.Enabled = false;        // 部分系Gr要素ボタン
                    CalcGrElementButton.Enabled = false;        // 収束演算系Gr要素ボタン
                    BasinElementButton.Enabled = false;         // 流域要素ボタン
                    LaneElementButton.Enabled = false;          // 河道要素ボタン
                    UserElementButton.Enabled = false;          // ユーザ要素ボタン
                    OutputElementButton.Enabled = false;        // 出力要素ボタン
                    InputElementButton.Enabled = false;         // 入力要素ボタン
                    JunctionElementButton.Enabled = false;      // データマージ要素ボタン

                    ElementLineUpUpButton.Enabled = false;      // 要素整列（上方向）ボタン
                    ElementLineUpBottomButton.Enabled = false;  // 要素整列（下方向）ボタン
                    ElementLineUpLeftButton.Enabled = false;    // 要素整列（左方向）ボタン
                    ElementLineUpRightButton.Enabled = false;   // 要素整列（右方向）ボタン
                    ElementEqualDistanceLineUpVButton.Enabled = false;      // 要素等間隔整列（縦）ボタン
                    ElementEqualDistanceLineUpHButton.Enabled = false;      // 要素等間隔整列（横）ボタン
                }
                else
                {// 選択モード・表示位置スクロールモード以外の場合
                    CutButton.Enabled = false;                  // カットボタン
                    CopyButton.Enabled = false;                 // コピーボタン
                    m_bClipBoardFlg = false;                    // ペーストフラグ
                    PasteButton.Enabled = false;                // ペーストボタン
                    DeleteButton.Enabled = false;               // 削除ボタン
                    UndoButton.Enabled = false;                 // UNDOボタン
                    RedoButton.Enabled = false;                 // REDOボタン
                    TopButton.Enabled = false;                  // Topボタン
                    BottomButton.Enabled = false;               // Bottomボタン
                    Left90degRotationButton.Enabled = false;    // 左回転ボタン
                    Right90degRotationButton.Enabled = false;   // 右回転ボタン
                    AllLeft90degRotationButton.Enabled = false; // 左全回転ボタン[2010/01/07]追加
                    AllRight90degRotationButton.Enabled = false;// 右全回転ボタン[2010/01/07]追加
                    IDTypeButton.Enabled = true;                // IDTypeボタン

                    ElementDiagramMenu.Enabled = true;          // 要素配置ボタン
                    ElementConnectButton.Enabled = true;        // 要素接続ボタン
                    CalcGrButton.Enabled = false;               // グループ化(収束演算)ボタン
                    PartGrButton.Enabled = false;               // グループ化(部分系)ボタン
                    GrCancelButton.Enabled = false;             // グループ化解除ボタン
                    ConnectCheckButton.Enabled = false;         // モデルチェックボタン
                    TreeDisplayButton.Enabled = false;          // ツリー表示ボタン
                    PartGrElementButton.Enabled = true;         // 部分系Gr要素ボタン
                    CalcGrElementButton.Enabled = true;         // 収束演算系Gr要素ボタン
                    BasinElementButton.Enabled = true;          // 流域要素ボタン
                    LaneElementButton.Enabled = true;           // 河道要素ボタン
                    UserElementButton.Enabled = true;           // ユーザ要素ボタン
                    OutputElementButton.Enabled = true;         // 出力要素ボタン
                    InputElementButton.Enabled = true;          // 入力要素ボタン
                    JunctionElementButton.Enabled = true;       // データマージ要素ボタン

                    ElementLineUpUpButton.Enabled = false;      // 要素整列（上方向）ボタン
                    ElementLineUpBottomButton.Enabled = false;  // 要素整列（下方向）ボタン
                    ElementLineUpLeftButton.Enabled = false;    // 要素整列（左方向）ボタン
                    ElementLineUpRightButton.Enabled = false;   // 要素整列（右方向）ボタン
                    ElementEqualDistanceLineUpVButton.Enabled = false;      // 要素等間隔整列（縦）ボタン
                    ElementEqualDistanceLineUpHButton.Enabled = false;      // 要素等間隔整列（横）ボタン
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクトコピー</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectCopy( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectCopy(object sender, EventArgs e)
        {
            bool bFromFlag = false;
            bool bToFlag = false;

            //選択中要素リスト取得
            List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();
            if (csSelectionList.Count > 0)
            {// 選択要素数が０より大きい場合
                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                m_eDrawMode = McDefine.DrawModeKind.HYM_COPY;               // コピーモード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                // クリップボードワーク生成
                HySDataLinkedList csClipBoardList = new HySDataLinkedList();

                // コピー対象要素クリップボード保存
                for (int iLp1 = 0; iLp1 < csSelectionList.Count; iLp1++)
                {// 選択要素数ループ
                    if ((csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_LINE) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_RECEIVE) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_SEND) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 接続線・端子・中継端子以外の場合
                        //コピー要素セット
                        csClipBoardList.AddLast(csSelectionList[iLp1].CopyInfUsedByUndoRedoOnly(null));
                    }
                }

                // コピー対象接続線クリップボード保存
                for (int iLp1 = 0; iLp1 < csSelectionList.Count; iLp1++)
                {// 選択要素数ループ
                    if (csSelectionList[iLp1].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線の場合
                        bFromFlag = false;
                        bToFlag = false;
                        for (int iLp2 = 0; iLp2 < csClipBoardList.GetCount(); iLp2++)
                        {// クリップボード保存要素数ループ
                            if (csSelectionList[iLp1].GetPort(0).GetParentElm().GetID().Equals(((McGraphicsElement)csClipBoardList.GetData(iLp2)).GetID()) == true)
                            {// IDが一致した場合
                                bFromFlag = true;
                            }
                            if (csSelectionList[iLp1].GetPort(1).GetParentElm().GetID().Equals(((McGraphicsElement)csClipBoardList.GetData(iLp2)).GetID()) == true)
                            {// IDが一致した場合
                                bToFlag = true;
                            }
                            if ((bFromFlag == true) && (bToFlag == true))
                            {// 両方が一致した場合
                                break;
                            }
                        }
                        if ((bFromFlag == true) && (bToFlag == true))
                        {// 両方が一致した場合
                            //コピー要素セット
                            csClipBoardList.AddLast(csSelectionList[iLp1].CopyInfUsedByUndoRedoOnly(null));
                        }
                    }
                }

                //選択中要素リストクリア
                //m_csGraphicsManager.ClearSelectionList();

                //プロパティ一覧選択状態解除
                //PropertyListSelectionClear(0);

                // コピー可能要素有無チェック
                if (csClipBoardList.GetCount() > 0)
                {// クリップボード保存要素数が０より大きい場合
                    // 2011.07.02 処理改善
                    // コピー要素をSelectionListへ再設定してしまうとCtrl+C直後の移動にて描画要素の追従がうまくいかない
                    // オリジナルの選択中要素リストは保持し、コピー要素はクリップボードへ設定する
                    //McGraphicsElement csElement = null;

                    ////クリップボードセット要素選択状態
                    //for (int iLp = 0; iLp < csClipBoardList.GetCount(); iLp++)
                    //{// クリップボード保存要素数ループ
                    //    csElement = (McGraphicsElement)csClipBoardList.GetData(iLp);
                    //    m_csGraphicsManager.AddSelectionList(csElement);
                    //}

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_COPY;

                    //クリップボードセット
                    SetClipBoard(csClipBoardList);

                    // 貼り付け座標フラグセット
                    m_bPastePointFlg = false;
                }

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;     // 選択モード

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクト切り取り</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectCut( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectCut(object sender, EventArgs e)
        {
            bool bFromFlag = false;
            bool bToFlag = false;

            if (CutButton.Enabled == false)
            {// 切り取りボタンが無効な場合
                return;
            }

            //選択中要素リスト取得
            List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();
            if (csSelectionList.Count > 0)
            {// 選択要素数が０より大きい場合
                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                m_eDrawMode = McDefine.DrawModeKind.HYM_CUT;                // 切り取りモード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                // クリップボードワーク生成
                HySDataLinkedList csClipBoardList = new HySDataLinkedList();

                // 切り取り対象要素クリップボード保存
                for (int iLp1 = 0; iLp1 < csSelectionList.Count; iLp1++)
                {// 選択要素数ループ
                    if ((csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_LINE) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_RECEIVE) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_SEND) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSelectionList[iLp1].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {
                        //切り取り要素セット
                        csClipBoardList.AddLast(csSelectionList[iLp1].CopyInfUsedByUndoRedoOnly(null));
                    }
                }

                // 切り取り対象接続線クリップボード保存
                for (int iLp1 = 0; iLp1 < csSelectionList.Count; iLp1++)
                {// 選択要素数ループ
                    if (csSelectionList[iLp1].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線の場合
                        bFromFlag = false;
                        bToFlag = false;
                        for (int iLp2 = 0; iLp2 < csClipBoardList.GetCount(); iLp2++)
                        {
                            if (csSelectionList[iLp1].GetPort(0).GetParentElm().GetID().Equals(((McGraphicsElement)csClipBoardList.GetData(iLp2)).GetID()) == true)
                            {// IDが一致した場合
                                bFromFlag = true;
                            }
                            if (csSelectionList[iLp1].GetPort(1).GetParentElm().GetID().Equals(((McGraphicsElement)csClipBoardList.GetData(iLp2)).GetID()) == true)
                            {// IDが一致した場合
                                bToFlag = true;
                            }
                            if ((bFromFlag == true) && (bToFlag == true))
                            {// 両方が一致した場合
                                break;
                            }
                        }
                        if ((bFromFlag == true) && (bToFlag == true))
                        {// 両方が一致した場合
                            //コピー要素セット
                            csClipBoardList.AddLast(csSelectionList[iLp1].CopyInfUsedByUndoRedoOnly(null));
                        }
                    }
                }

                //選択中要素リストクリア
                m_csGraphicsManager.ClearSelectionList();

                //プロパティ一覧選択状態解除
                PropertyListSelectionClear(0);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                // 切り取り可能要素有無チェック
                if (csClipBoardList.GetCount() > 0)
                {// クリップボード保存要素数が０より大きい場合
                    // カーソルを砂時計にする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.WaitCursor;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.WaitCursor;
                    }

                    McGraphicsElement csElement = null;
                    //クリップボードセット要素選択状態
                    for (int iLp = 0; iLp < csClipBoardList.GetCount(); iLp++)
                    {// クリップボード保存要素数ループ
                        csElement = (McGraphicsElement)csClipBoardList.GetData(iLp);
                        m_csGraphicsManager.AddSelectionList(csElement);
                    }

                    //クリップボードセット
                    SetClipBoard(csClipBoardList);

                    // カーソルをデフォルトにする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.Default;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.Default;
                    }

                    //選択エレメント削除
                    ObjectDelete(null, null);

                    // 貼り付け座標フラグセット
                    m_bPastePointFlg = false;
                }

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;     // 選択モード

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクト貼り付け</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectPaste( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectPaste(object sender, EventArgs e)
        {
            if (m_bClipBoardFlg == true)
            {// クリップボード有効の場合
                //選択中要素リストクリア
                m_csGraphicsManager.ClearSelectionList();

                // 貼り付け
                ObjectPasteDraw();

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.PASTE;
                m_csHistoryDataWork = new List<object>();
                List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();
                List<McGraphicsElement> csElmList = new List<McGraphicsElement>();
                for (int iLp = 0; iLp < csSelectList.Count; iLp++)
                {// 選択要素数ループ
                    if ((csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_RECEIVE) &&
                        (csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_SEND) &&
                        (csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 端子・中継端子以外の場合
                        csElmList.Add(csSelectList[iLp].CopyInfUsedByUndoRedoOnly(null));
                    }
                }
                m_csHistoryDataWork.Add(csElmList);

                csHistoryData.HistoryData = m_csHistoryDataWork;

                Point pLeftTop = new Point();
                Point pRightBottom = new Point();
                if (m_csGraphicsManager.GetDispRect(ref pLeftTop, ref pRightBottom) == 0)
                {   // 表示エレメント有り
                    CheckDispArea(pLeftTop, pRightBottom);
                }

                ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                //復元ポイント記録
                ReconstructionPointSave(true, csHistoryData);

                // リスト部編集
                PropertyListEdit(0, false);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();

                ButtonSelectInit();                                         // ボタン選択初期化
                SelectButton.Checked = true;                                // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード
                SelectObjectText.Text = "";                                 // 選択描画オブジェクト名クリア
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                // モデル管理ガイドマップ再描画
                SimpleMapReDraw();

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクト貼り付け表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectPasteDraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectPasteDraw()
        {
            if (m_bClipBoardFlg == true)
            {// クリップボード有効の場合
                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                // 貼り付け要素取り出し
                HySDataLinkedList csOrgClipBoardList = GetClipBoard();
                if (csOrgClipBoardList == null)
                {// クリップボードがない場合
                    return;
                }
                if (csOrgClipBoardList.GetCount() == 0)
                {// クリップボードの保存要素数が０の場合
                    return;
                }

                HySDataLinkedList csClipBoardList = new HySDataLinkedList();
                for (long lLp = 0; lLp < csOrgClipBoardList.GetCount(); lLp++)
                {// クリップボード保存要素数ループ
                    csClipBoardList.AddLast(((McGraphicsElement)csOrgClipBoardList.GetData(lLp)).CopyInfUsedByUndoRedoOnly(null));
                }

                // 貼り付け元要素座標取得
                long lMinimumX = 0;
                long lMinimumY = 0;
                McViewTransFormer.PasteMinimumXYCheck(csClipBoardList, ref lMinimumX, ref lMinimumY);

                if (m_bPastePointFlg == false)
                {// 貼り付け位置設定なしの場合
                    // 貼り付け位置設定
                    m_pPastePoint.X = (int)lMinimumX + 20;
                    m_pPastePoint.Y = (int)lMinimumY + 20;

                    // 貼り付け位置フラグセット
                    m_bPastePointFlg = true;
                }
                else
                {// 貼り付け位置設定ありの場合
                    // 貼り付け位置設定
                    m_pPastePoint.X += 20;
                    m_pPastePoint.Y += 20;
                }

                // 貼り付け
                m_csGraphicsManager.ElementPaste(csClipBoardList, m_pPastePoint.X, m_pPastePoint.Y);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクト貼り付け表示（メニュークリック）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectPasteDrawMenuClick( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectPasteDrawMenuClick(object sender, EventArgs e)
        {
            if (m_bClipBoardFlg == true)
            {// クリップボード有効の場合
                //選択中要素リストクリア
                m_csGraphicsManager.ClearSelectionList();

                // 貼り付け
                ObjectPasteDraw();

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.PASTE;
                m_csHistoryDataWork = new List<object>();
                List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();
                List<McGraphicsElement> csElmList = new List<McGraphicsElement>();
                for (int iLp = 0; iLp < csSelectList.Count; iLp++)
                {// 選択要素数ループ
                    if ((csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_RECEIVE) &&
                        (csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_SEND) &&
                        (csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 端子・中継端子以外の場合
                        csElmList.Add(csSelectList[iLp].CopyInfUsedByUndoRedoOnly(null));
                    }
                }
                m_csHistoryDataWork.Add(csElmList);

                csHistoryData.HistoryData = m_csHistoryDataWork;

                Point pLeftTop = new Point();
                Point pRightBottom = new Point();
                if (m_csGraphicsManager.GetDispRect(ref pLeftTop, ref pRightBottom) == 0)
                {   // 表示エレメント有り
                    CheckDispArea(pLeftTop, pRightBottom);
                }

                ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                //復元ポイント記録
                ReconstructionPointSave(true, csHistoryData);

                // リスト部編集
                PropertyListEdit(0, false);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();

                ButtonSelectInit();                                         // ボタン選択初期化
                SelectButton.Checked = true;                                // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード
                SelectObjectText.Text = "";                                 // 選択描画オブジェクト名クリア
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                // モデル管理ガイドマップ再描画
                SimpleMapReDraw();

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクト削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectDelete( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectDelete(object sender, EventArgs e)
        {
            //選択中要素リスト取得
            List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();

            if (csSelectionList.Count > 0)
            {// 選択要素数が０より大きい場合
                List<HySIdentifier> csDelElmIDList = null;
                List<McGraphicsElement> csDelElmList = new List<McGraphicsElement>();
                List<McGraphicsElement> csTransPortList = new List<McGraphicsElement>();
                List<List<HySIdentifier>> csConnectionIDList = new List<List<HySIdentifier>>();

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                m_eDrawMode = McDefine.DrawModeKind.HYM_DELETE;             // 削除モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
                {// 選択要素数ループ
                    //部分系表示中グループはタブ消去
                    for (int iLp2 = 1; iLp2 < m_iTabCount; iLp2++)
                    {// 部分系表示中グループタブ数ループ
                        if (csSelectionList[iLp].GetID().ToString() == m_csDispElmList[iLp2][0].GetID().ToString())
                        {// IDが一致した場合
                            TabControl.TabPages.RemoveAt(iLp2);

                            //削除タブ情報をリストから削除
                            m_csDispElmList.RemoveAt(iLp2);
                            m_lDispScaleList.RemoveAt(iLp2);
                            m_iPropertyListSortColumnIndexList.RemoveAt(iLp2);
                            m_pDispPointList.RemoveAt(iLp2);

                            m_iTabCount--;
                            break;
                        }
                    }
                }

                // グラフ画面クローズ
                LineGraphScreenClose();

                // 削除
                csDelElmIDList = m_csGraphicsManager.DelElement(ref csDelElmList, ref csTransPortList, ref csConnectionIDList);

                for (int iLp = 0; iLp < csDelElmIDList.Count; iLp++)
                {// 削除要素数ループ
                    // プロパティ画面クローズ
                    PropetyScreenClose(csDelElmIDList[iLp]);
                }

                McGraphicsElement csGroupElement = null;
                //内部表示タブ表示中グループ有無チェック
                for (int iLp = TabControl.TabCount - 1; iLp >= 1; iLp--)
                {// 部分系表示中グループタブ数ループ
                    csGroupElement = m_csGraphicsManager.SearchGroupElement(m_csDispElmList[0], m_csDispElmList[iLp][0].GetID());
                    if (csGroupElement == null)
                    {// 要素があった場合
                        //削除タブ情報をリストから削除
                        m_csDispElmList.RemoveAt(iLp);
                        m_lDispScaleList.RemoveAt(iLp);
                        m_iPropertyListSortColumnIndexList.RemoveAt(iLp);
                        m_pDispPointList.RemoveAt(iLp);

                        TabControl.TabPages.RemoveAt(iLp);

                        m_iTabCount--;
                    }
                }

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                bool bDelFlg = true;

                //中継端子接続確認
                if (m_csGraphicsManager.TransPortConnectionCheck() == false)
                {// 接続情報のある中継端子の場合
                    DialogResult result = MessageBox.Show(MSG_RELAY_TERMINAL_DELETE, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (result == DialogResult.No)
                    {// NO選択の場合
                        bDelFlg = false;
                    }
                }

                if (bDelFlg == true)
                {// 削除の場合
                    // カーソルを砂時計にする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.WaitCursor;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.WaitCursor;
                    }

                    // 削除
                    csDelElmIDList = m_csGraphicsManager.DelTransPort(m_csDispLineList, ref csDelElmList, ref csTransPortList, ref csConnectionIDList);

                    for (int iLp = 0; iLp < csDelElmIDList.Count; iLp++)
                    {// 削除要素数ループ
                        // プロパティ画面クローズ
                        PropetyScreenClose(csDelElmIDList[iLp]);
                    }

                    // カーソルをデフォルトにする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.Default;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.Default;
                    }
                }

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                // リスト部編集
                PropertyListEdit(0, true);

                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;     // 選択モード

                if (csDelElmList.Count != 0)
                {// 削除要素数が０以外の場合
                    //復元データ編集
                    McHistoryData csHistoryData = new McHistoryData();
                    csHistoryData.Kind = McHistoryData.OperationKind.DELETE_CUT;
                    m_csHistoryDataWork = new List<object>();
                    m_csHistoryDataWork.Add(csDelElmList);
                    m_csHistoryDataWork.Add(csTransPortList);
                    m_csHistoryDataWork.Add(csConnectionIDList);
                    csHistoryData.HistoryData = m_csHistoryDataWork;

                    //復元ポイント記録
                    ReconstructionPointSave(true, csHistoryData);

                    // プロパティ画面リフレッシュ
                    PropetyScreenRefreshment(null);
                }

                Point pLeftTop = new Point();
                Point pRightBottom = new Point();
                if (m_csGraphicsManager.GetDispRect(ref pLeftTop, ref pRightBottom) == 0)
                {   // 表示エレメント有り
                    CheckDispArea(pLeftTop, pRightBottom);
                }
                else
                {   // エレメント無し
                    SetDefaultRect();
                }

                if (LayerMove.Image == null)
                {// 移動レイヤーにイメージがない場合
                    LayerMove.Image = new Bitmap((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                }
                LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));
 
                int iWorkX = m_pDispPoint.X - m_iEditLeft;
                int iWorkY = m_pDispPoint.Y - m_iEditTop;
                int iMoveX = 0;
                int iMoveY = 0;
                // 編集エリアの上端又は左端が変わる場合は、スクロールを行い
                // その後要素が上端又は左端に描画されるように再描画する。
                if ((iWorkX < 0 && iWorkX < -(m_iWidth / 2)) || (iWorkY < 0 && iWorkY < -(m_iHeight / 2)))
                {   // 編集エリア左上が更新される変更あり
                    if (iWorkX < 0 && iWorkX < -(m_iWidth / 2))
                    {   // 編集エリア左が更新される変更あり
                        iMoveX = m_pDispPoint.X - pLeftTop.X;
                    }
                    if (iWorkY < 0 && iWorkY < -(m_iHeight / 2))
                    {   // 編集エリア上が更新される変更あり
                        iMoveY = m_pDispPoint.Y - pLeftTop.Y;
                    }
                    iMoveX = iMoveX * (int)m_lDispScale / 100;
                    iMoveY = iMoveY * (int)m_lDispScale / 100;
                    DisplayPositionScroll(iMoveX, iMoveY);
                }

                ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

                // モデル管理ガイドマップ再描画
                SimpleMapReDraw();

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoProcess( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoProcess(object sender, EventArgs e)
        {
            if (m_iReconstructionPointPointer > 1)
            {// ヒストリー情報がある場合
                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                m_iReconstructionPointPointer--;
                if (m_iReconstructionPointPointer <= 1)
                {// ヒストリー情報がない場合
                    UndoButton.Enabled = false;
                }
                RedoButton.Enabled = true;

                // 復元処理
                ReconstructionProcess(true);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                // 後処理
                UndoRedoAfterProcess();
                m_bReconstructionUndoFlg = true;
                m_bReconstructionRedoFlg = false;
            }
            else
            {// ヒストリー情報がない場合
                UndoButton.Enabled = false;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>復元ポイント記録</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReconstructionPointSave(bSimStatFlg, csHistoryData)</para>
        /// </example>
        /// <param name="bSimStatFlg">シミュレーション状態変更フラグ</param>
        /// <param name="csHistoryData">ヒストリーデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void ReconstructionPointSave(bool bSimStatFlg, McHistoryData csHistoryData)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            // Undo中かチェック
            if (m_bReconstructionUndoFlg == true)
            {// Undo中の場合
                ReconstructionPointDelete(m_iReconstructionPointPointer);
                RedoButton.Enabled = false;
            }

            // Redo中かチェック
            if (m_bReconstructionRedoFlg == true)
            {// Redo中の場合
                if (m_csReconstructionDataList.Count > m_iReconstructionPointPointer)
                {// 現ポイント以降のヒストリーを削除
                    ReconstructionPointDelete(m_iReconstructionPointPointer);
                }
                RedoButton.Enabled = false;
            }

            // マックスチェック
            if (m_iReconstructionPointPointer >= 31)
            {// ヒストリー保存数が上限の場合
                m_csReconstructionDataList.RemoveAt(0);
                m_csSimulationStatusList.RemoveAt(0);
                m_iReconstructionPointPointer--;
            }

            // Rudo/Redoボタンステータス設定
            if (m_csReconstructionDataList.Count == 0)
            {// ヒストリー情報が０の場合
                UndoButton.Enabled = false;
                RedoButton.Enabled = false;
            }
            else if (m_iReconstructionPointPointer != 0)
            {// ヒストリー情報が０以外の場合
                UndoButton.Enabled = true;
            }

            m_iReconstructionPointPointer++;
            m_bReconstructionUndoFlg = false;
            m_bReconstructionRedoFlg = false;

            // 復元情報保存
            if (TabControl.SelectedIndex != 0)
            {// グループ内部表示タブ表示中の場合
                csHistoryData.ParentID = m_csDispElmList[TabControl.SelectedIndex][0].GetID();
            }
            m_csReconstructionDataList.Add(csHistoryData);

            // シミュレーションステータス設定
            McSimulationStatus csSimulationStatus = ((McDotNetModelCtlScreen)m_csScreen).GetSimulationStatusData();
            if (m_bInitialIndicationFlg == false)
            {// 初期表示以外の場合
                if (bSimStatFlg == true)
                {// シミュレーション状態変更の場合
                    csSimulationStatus.SetModelModStatus(McSimulationStatus.ModelModificationStatus.MODIFIED_CONSTRUCTION_REQUIRED);
                }
                else
                {// シミュレーション状態非変更の場合
                    if (csSimulationStatus.GetModelModStatus() == McSimulationStatus.ModelModificationStatus.UNMODIFIED)
                    {// モデル変更状態が変更なしの場合
                        csSimulationStatus.SetModelModStatus(McSimulationStatus.ModelModificationStatus.MODIFIED_CONSTRUCTION_NOT_REQUIRED);
                    }
                    else
                    {// モデル変更状態が変更なし以外の場合
                        csSimulationStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.UNSAVED);
                    }
                }
            }

            // シミュレーションステータス保存
            McSimulationStatus csHistorySimulationStatus = new McSimulationStatus();
            csHistorySimulationStatus.SetModelConStatus(csSimulationStatus.GetModelConStatus());
            csHistorySimulationStatus.SetModelModStatus(csSimulationStatus.GetModelModStatus());
            csHistorySimulationStatus.SetModelSaveStatus(csSimulationStatus.GetModelSaveStatus());
            csHistorySimulationStatus.SetCalcStatus(csSimulationStatus.GetCalcStatus());
            m_csSimulationStatusList.Add(csHistorySimulationStatus);

            //シミュレーション状態保持クラス変更通知イベント送信
            ((McDotNetModelCtlScreen)m_csScreen).SimulationStatusModifyInformation();

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ヒストリーファイル更新</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HistoryFileUpdate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void HistoryFileUpdate()
        {
            // シミュレーションステータス更新
            McSimulationStatus csSimulationStatus = ((McDotNetModelCtlScreen)m_csScreen).GetSimulationStatusData();
            m_csSimulationStatusList[m_iReconstructionPointPointer - 1].SetModelModStatus(csSimulationStatus.GetModelModStatus());
            m_csSimulationStatusList[m_iReconstructionPointPointer - 1].SetModelSaveStatus(csSimulationStatus.GetModelSaveStatus());
            m_csSimulationStatusList[m_iReconstructionPointPointer - 1].SetCalcStatus(csSimulationStatus.GetCalcStatus());
            m_csSimulationStatusList[m_iReconstructionPointPointer - 1].SetModelConStatus(csSimulationStatus.GetModelConStatus());
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>復元ポイント削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReconstructionPointDelete(iPointNo)</para>
        /// </example>
        /// <param name="iPointNo">削除開始ポイントNo</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReconstructionPointDelete(int iPointNo)
        {
            if (iPointNo == 0)
            {// 削除開始ポイントが０の場合
                m_csReconstructionDataList.Clear();
                m_csSimulationStatusList.Clear();
                m_iReconstructionPointPointer = 0;
            }
            else
            {// 削除開始ポイントが０以外の場合
                for (int iLp = m_csReconstructionDataList.Count - 1; iLp >= iPointNo; iLp--)
                {// 削除開始ポイントまでループ
                    m_csReconstructionDataList.RemoveAt(iLp);
                    m_csSimulationStatusList.RemoveAt(iLp);
                }
            }
            GC.Collect(); // 強制　ガベージコレクション
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>復元用情報削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReconstructionDataDelete(sDataName)</para>
        /// </example>
        /// <param name="sDataName">削除情報名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReconstructionPointDelete(string sDataName)
        {
            HySFile csFile = new HySFile(new HySString(sDataName));
            csFile.Delete();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoProcess( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoProcess(object sender, EventArgs e)
        {
            if (m_csReconstructionDataList.Count > m_iReconstructionPointPointer)
            {// Redo可能な場合
                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                m_iReconstructionPointPointer++;
                if (m_csReconstructionDataList.Count <= m_iReconstructionPointPointer)
                {// Redo可能な場合
                    RedoButton.Enabled = false;
                }
                UndoButton.Enabled = true;

                // 復元処理
                ReconstructionProcess(false);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                // 後処理
                UndoRedoAfterProcess();
                m_bReconstructionUndoFlg = false;
                m_bReconstructionRedoFlg = true;
            }
            else
            {// Redo不可能な場合
                RedoButton.Enabled = false;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>最前面へ移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectTop( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectTop(object sender, EventArgs e)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            List<HySIdentifier> csIDList = new List<HySIdentifier>();
            List<int> csBeforePositionList = new List<int>();
            List<int> csAfterPositionList = new List<int>();

            // 最前面へ移動
            m_csGraphicsManager.SetPiledUpTop(ref csIDList, ref csBeforePositionList, ref csAfterPositionList);

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.PILED_UP_TOP;
            m_csHistoryDataWork = new List<object>();
            m_csHistoryDataWork.Add(csIDList);
            m_csHistoryDataWork.Add(csBeforePositionList);
            m_csHistoryDataWork.Add(csAfterPositionList);
            csHistoryData.HistoryData = m_csHistoryDataWork;

            //復元ポイント記録
            ReconstructionPointSave(false, csHistoryData);

            // リスト部編集
            PropertyListEdit(0, false);

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT, true, true);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>最背面へ移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectBottom( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectBottom(object sender, EventArgs e)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            List<HySIdentifier> csIDList = new List<HySIdentifier>();
            List<int> csBeforePositionList = new List<int>();
            List<int> csAfterPositionList = new List<int>();

            // 最背面へ移動
            m_csGraphicsManager.SetPiledUpBottom(ref csIDList, ref csBeforePositionList, ref csAfterPositionList);

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.PILED_UP_BOTTOM;
            m_csHistoryDataWork = new List<object>();
            m_csHistoryDataWork.Add(csIDList);
            m_csHistoryDataWork.Add(csBeforePositionList);
            m_csHistoryDataWork.Add(csAfterPositionList);
            csHistoryData.HistoryData = m_csHistoryDataWork;

            //復元ポイント記録
            ReconstructionPointSave(false, csHistoryData);

            // リスト部編集
            PropertyListEdit(0, false);

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT, true, true);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面拡大</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ZoomIn( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ZoomIn(object sender, EventArgs e)
        {
            // 表示チェック
            if (LayerRubberBand.Image != null)
            {// ラバーバンドレイヤーにイメージがある場合
                double dWork = m_lDispScale * 1.41;
                m_lDispScale = (long)dWork;
                if (m_lDispScale > 800)
                {// スケールが８００より大きい場合
                    m_lDispScale = 800;
                }
                ZoomSizeComboBox.Text = System.Convert.ToString(m_lDispScale) + '%';
                ZoomChange(null, null);

                m_lDispScaleList[TabControl.SelectedIndex] = m_lDispScale;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面縮小</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ZoomOut( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ZoomOut(object sender, EventArgs e)
        {
            // 表示チェック
            if (LayerRubberBand.Image != null)
            {// ラバーバンドレイヤーにイメージがある場合
                double dWork = m_lDispScale * 0.7;
                m_lDispScale = (long)dWork;
                if (m_lDispScale < 10)
                {// スケールが１０より小さい場合
                    m_lDispScale = 10;
                }
                ZoomSizeComboBox.Text = System.Convert.ToString(m_lDispScale) + '%';
                ZoomChange(null, null);

                m_lDispScaleList[TabControl.SelectedIndex] = m_lDispScale;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面縮尺変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ZoomChange( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ZoomChange(object sender, EventArgs e)
        {
            string sZoom;
            long lScale = 0L;

            // 表示チェック
            if (LayerRubberBand.Image != null)
            {// ラバーバンドレイヤーにイメージがある場合
                sZoom = ZoomSizeComboBox.Text.Trim();
                sZoom = sZoom.TrimEnd('%');

                // 設定値取り出し
                try
                {
                    lScale = System.Convert.ToInt32(sZoom);
                    m_lDispScale = lScale;
                }
                catch
                {
                    ZoomSizeComboBox.Text = System.Convert.ToString(m_lDispScale) + '%';
                    return;
                }

                // 上下限チェック
                if (m_lDispScaleBefore == m_lDispScale)
                {// 前回値と同じ場合
                    return;
                }

                if (m_lDispScale < 10)
                {// スケールが１０より小さい場合
                    m_lDispScale = 10;
                }
                else if (m_lDispScale > 800)
                {// スケールが８００より大きい場合
                    m_lDispScale = 800;
                }

                // 表示座標計算
                int iTempWidth = m_iWidth * 100 / (int)m_lDispScaleBefore;
                int iTempHeight = m_iHeight * 100 / (int)m_lDispScaleBefore;
                int iTempPointX = m_pDispPoint.X + iTempWidth / 2;
                int iTempPointY = m_pDispPoint.Y + iTempHeight / 2;
                //m_pDispPoint.X = m_pDispPoint.X + iTempWidth / 2;
                //m_pDispPoint.Y = m_pDispPoint.Y + iTempHeight / 2;
                iTempWidth = m_iWidth * 100 / (int)m_lDispScale;
                iTempHeight = m_iHeight * 100 / (int)m_lDispScale;
                iTempPointX = iTempPointX - iTempWidth / 2;
                iTempPointY = iTempPointY - iTempHeight / 2;
                if (iTempPointX < m_iScrollLeft && iTempPointX + m_iWidth * 100 / m_lDispScale > m_iScrollRight ||
                    iTempPointY < m_iScrollTop && iTempPointY + m_iHeight * 100 / m_lDispScale > m_iScrollBottom ||
                    m_iWidth * 100 / m_lDispScale > m_iScrollRight - m_iScrollLeft ||
                    m_iHeight * 100 / m_lDispScale > m_iScrollBottom - m_iScrollTop)
                {   // 表示範囲がスクロール範囲を超えている
                    if (m_lDispScale < m_lDispScaleBefore)
                    {   // 縮小の時のみ処理を抜ける
                        m_lDispScale = m_lDispScaleBefore;
                        ZoomSizeComboBox.Text = System.Convert.ToString(m_lDispScale) + '%';
                        return;
                    }
                }

                if (iTempPointX < m_iScrollLeft)
                {   // 座標Xがスクロール左未満
                    iTempPointX = m_iScrollLeft;
                }
                else if (iTempPointX + m_iWidth * 100 / m_lDispScale > m_iScrollRight)
                {   // 座標Xがスクロール右を越える
                    iTempPointX = m_iScrollRight - m_iWidth * 100 / (int)m_lDispScale;
                    if (iTempPointX < m_iScrollLeft)
                    {   // 座標Xがスクロール左未満
                        iTempPointX = m_iScrollLeft;
                    }
                }
                if (iTempPointY < m_iScrollTop)
                {   // 座標Yがスクロール上未満
                    iTempPointY = m_iScrollTop;
                }
                else if (iTempPointY + m_iHeight * 100 / m_lDispScale > m_iScrollBottom)
                {   // 座標Yがスクロール下を越える
                    iTempPointY = m_iScrollBottom - m_iHeight * 100 / (int)m_lDispScale;
                    if (iTempPointY < m_iScrollTop)
                    {   // 座標Yがスクロール上未満
                        iTempPointY = m_iScrollTop;
                    }
                }
                //m_pDispPoint.X = m_pDispPoint.X - iTempWidth / 2;
                //m_pDispPoint.Y = m_pDispPoint.Y - iTempHeight / 2;
                m_pDispPoint.X = iTempPointX;
                m_pDispPoint.Y = iTempPointY;

                //ZoomSizeComboBox.Text = System.Convert.ToString(m_lDispScale) + '%';

                m_csGraphicsManager.SetDispScale(m_lDispScale);

                m_pDispPointList[TabControl.SelectedIndex] = m_pDispPoint;

                m_lDispScaleBefore = m_lDispScale;

                m_lDispScaleList[TabControl.SelectedIndex] = m_lDispScale;

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
                {// 表示位置スクロールモードの場合
                    LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));

                    //編集領域設定
                    Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
                    m_pDispPoint.X = m_pDispPoint.X - (int)(m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                    m_pDispPoint.Y = m_pDispPoint.Y - (int)(m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);

                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / m_lDispScale);
                    m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / m_lDispScale);

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.MOVE, true, true);

                    int iOffsetX = pTempPoint.X * (int)m_lDispScale / 100 - (m_pDispPoint.X * (int)m_lDispScale / 100 + (int)(m_iWidth * (IMAGE_SIZE_RATIO - 1) / 2));
                    int iOffsetY = pTempPoint.Y * (int)m_lDispScale / 100 - (m_pDispPoint.Y * (int)m_lDispScale / 100 + (int)(m_iHeight * (IMAGE_SIZE_RATIO - 1) / 2));
                    Point pWork = LayerMove.Location;
                    pWork.X -= iOffsetX;
                    pWork.Y -= iOffsetY;
                    LayerMove.Location = pWork;

                    m_pDispPoint.X = pTempPoint.X;
                    m_pDispPoint.Y = pTempPoint.Y;
                }

                ScrollRefresh(iTempPointX, iTempPointY);

                // モデル管理ガイドマップ再描画
                if (m_csSimpleMap != null)
                {// モデル管理ガイドマップ表示中の場合
                    m_csSimpleMap.ScaleChange(m_lDispScale);
                    m_csSimpleMap.DispPointChange(m_pDispPoint);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>接続チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ConnectCheck( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ConnectCheck(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                m_eDrawMode = McDefine.DrawModeKind.HYM_MODEL_CHECK;

                //モデルチェック結果タブ表示
                TabPage1TabPControl.SelectedIndex = 4;

                //モデルチェック
                bool bRtn = ModelCheck();

                if (bRtn == true)
                {// モデルチェック正常の場合
                    //ビルド要求イベント送信
                    ((McDotNetModelCtlScreen)m_csScreen).PutEventRequestBuild();
                }

                //選択中要素リストクリア
                m_csGraphicsManager.ClearSelectionList();

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                //プロパティ一覧選択状態解除
                PropertyListSelectionClear(0);

                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;     // 選択モード
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクト選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectSelect( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectSelect(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (SelectButton.Checked == false)
            {// セレクトモード以外の場合
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
                this.Cursor = Cursors.Default;

                LayerMove.Visible = false;
            }
            else
            {// セレクトモードの場合
                ButtonSelectInit();                         // ボタン選択初期化
                MoveButton.Checked = true;                  // 画面移動ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL;        // 画面移動モード
                this.Cursor = new Cursor(HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_CURSOR_FOLDER")).ToString() + "HArrow.cur");

                LayerMove.Visible = true;
                LayerMove.Size = new Size((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                if (LayerMove.Image != null)
                {// 移動レイヤーにイメージがある場合
                    LayerMove.Image.Dispose();
                }
                LayerMove.Image = new Bitmap((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));

                //編集領域設定
                Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
                m_pDispPoint.X = (int)(m_pDispPoint.X - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                m_pDispPoint.Y = (int)(m_pDispPoint.Y - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                int iOffsetX = pTempPoint.X * (int)m_lDispScale / 100 - (m_pDispPoint.X * (int)m_lDispScale / 100 + (int)(m_iWidth * (IMAGE_SIZE_RATIO - 1) / 2));
                int iOffsetY = pTempPoint.Y * (int)m_lDispScale / 100 - (m_pDispPoint.Y * (int)m_lDispScale / 100 + (int)(m_iHeight * (IMAGE_SIZE_RATIO - 1) / 2));
                Point pWork = LayerMove.Location;
                pWork.X -= iOffsetX;
                pWork.Y -= iOffsetY;
                LayerMove.Location = pWork;
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / m_lDispScale);
                m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / m_lDispScale);

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.MOVE, true, true);

                m_pDispPoint.X = pTempPoint.X;
                m_pDispPoint.Y = pTempPoint.Y;
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            SelectObjectText.Text = "";                               // 選択描画オブジェクト名クリア
            m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;    // 描画シンボル指定なし

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ScreenMove( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ScreenMove(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (MoveButton.Checked == false)
            {// 移動モード以外の場合
                ButtonSelectInit();                         // ボタン選択初期化
                MoveButton.Checked = true;                  // 画面移動ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL;        // 画面移動モード
                this.Cursor = new Cursor(HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_CURSOR_FOLDER")).ToString() + "HArrow.cur");

                LayerMove.Visible = true;
                LayerMove.Size = new Size((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                if (LayerMove.Image != null)
                {// 移動レイヤーにイメージがある場合
                    LayerMove.Image.Dispose();
                }
                LayerMove.Image = new Bitmap((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));

                //編集領域設定
                Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
                m_pDispPoint.X = m_pDispPoint.X - (int)(m_iWidth * (IMAGE_SIZE_RATIO - 1) / 2 * 100 / m_lDispScale);
                m_pDispPoint.Y = m_pDispPoint.Y - (int)(m_iHeight * (IMAGE_SIZE_RATIO - 1) / 2 * 100 / m_lDispScale);
                int iOffsetX = pTempPoint.X * (int)m_lDispScale / 100 - (m_pDispPoint.X * (int)m_lDispScale / 100 + (int)(m_iWidth * (IMAGE_SIZE_RATIO - 1) / 2));
                int iOffsetY = pTempPoint.Y * (int)m_lDispScale / 100 - (m_pDispPoint.Y * (int)m_lDispScale / 100 + (int)(m_iHeight * (IMAGE_SIZE_RATIO - 1) / 2));
                Point pWork = LayerMove.Location;
                pWork.X -= iOffsetX;
                pWork.Y -= iOffsetY;
                LayerMove.Location = pWork;
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / m_lDispScale);
                m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / m_lDispScale);

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.MOVE, true, true);

                m_pDispPoint.X = pTempPoint.X;
                m_pDispPoint.Y = pTempPoint.Y;
            }
            else
            {// 移動モードの場合
                ButtonSelectInit();                         // ボタン選択初期化
                SelectButton.Checked = true;                // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード
                this.Cursor = Cursors.Default;

                LayerMove.Visible = false;
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            SelectObjectText.Text = "";                                     // 選択描画オブジェクト名クリア
            m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;          // 描画シンボル指定なし

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>オブジェクト全選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ObjectAllSelect()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ObjectAllSelect()
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);

            //エレメントリスト取得
            List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();
            //ラインリスト取得
            List<McGraphicsElement> csLineList = m_csGraphicsManager.GetLineList();

            for (int iLP = 0; iLP < csElmList.Count; iLP++)
            {// 要素数ループ
                //選択中要素追加
                m_csGraphicsManager.AddSelectionList(csElmList[iLP]);

                for (int iLP2 = 0; iLP2 < csElmList[iLP].GetPortCount(); iLP2++)
                {// 端子数ループ
                    //選択中要素追加
                    m_csGraphicsManager.AddSelectionList(csElmList[iLP].GetPort(iLP2));
                }
            }
            for (int iLP = 0; iLP < csLineList.Count; iLP++)
            {// 接続線数ループ
                //選択中要素追加
                m_csGraphicsManager.AddSelectionList(csLineList[iLP]);
            }
            if (TabControl.SelectedIndex != 0)
            {// グループ内部表示タブが全体系以外の場合
                for (int iLP = 0; iLP < m_csDispElmList[TabControl.SelectedIndex][0].GetPortCount(); iLP++)
                {// 端子数ループ
                    //選択中要素追加
                    m_csGraphicsManager.AddSelectionList(m_csDispElmList[TabControl.SelectedIndex][0].GetPort(iLP));
                }
            }

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティリスト選択同期
            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
            ListSelectionMatching();
            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;

            // ボタン活性／非活性設定
            ButtonEnabledSet();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>収束演算系グループ要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalcGrElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalcGrElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (CalcGrElementButton.Checked == false)
            {// 収束演算系Gr要素配置モード以外の場合
                ButtonSelectInit();                         // ボタン選択初期化
                CalcGrElementMenu.Checked = true;           // 収束演算系Gr要素メニューチェック状態
                CalcGrElementButton.Checked = true;         // 収束演算系Gr要素ボタンチェック状態
                SelectObjectText.Text = CalcGrElementMenu.Text;            // 選択描画オブジェクト名クリア
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;             // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_CALC_GROUP;  // 収束演算系Grシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_NONSYMBOL;    // サブ種別シンボルなし指定
            }
            else
            {// 収束演算系Gr要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系グループ要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartGrElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartGrElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (PartGrElementButton.Checked == false)
            {// 部分系Gr要素配置モード以外の場合
                ButtonSelectInit();                         // ボタン選択初期化
                PartGrElementMenu.Checked = true;           // 部分系Gr要素メニューチェック状態
                PartGrElementButton.Checked = true;         // 部分系Gr要素ボタンチェック状態
                SelectObjectText.Text = PartGrElementMenu.Text;         // 選択描画オブジェクト名クリア
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;         // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_GROUP;    // 部分系Grシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_NONSYMBOL;    // サブ種別シンボルなし指定
            }
            else
            {// 部分系Gr要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>河道要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LaneElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LaneElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (LaneElementButton.Checked == false)
            {// 河道要素配置モード以外の場合
                ButtonSelectInit();                     // ボタン選択初期化
                LaneElementMenu.Checked = true;         // 河道要素メニューチェック状態
                LaneElementButton.Checked = true;       // 河道要素ボタンチェック状態
                SelectObjectText.Text = LaneElementMenu.Text;            // 選択描画オブジェクト名クリア
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;            // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_STD_ELEMENT; // スタンダードシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_LANE;       // サブ種別河道シンボル指定
            }
            else
            {// 河道要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>流域要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>BasinElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void BasinElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (BasinElementButton.Checked == false)
            {// 流域要素配置モード以外の場合
                ButtonSelectInit();                     // ボタン選択初期化
                BasinElementMenu.Checked = true;        // 流域要素メニューチェック状態
                BasinElementButton.Checked = true;      // 流域要素ボタンチェック状態
                SelectObjectText.Text = BasinElementMenu.Text;           // 選択描画オブジェクト名セット
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;            // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_STD_ELEMENT; // スタンダードシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_BASIN;      // サブ種別流域シンボル指定
            }
            else
            {// 流域要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OutputElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OutputElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (OutputElementButton.Checked == false)
            {// 出力要素配置モード以外の場合
                ButtonSelectInit();                     // ボタン選択初期化
                OutputElementMenu.Checked = true;       // 出力要素メニューチェック状態
                OutputElementButton.Checked = true;     // 出力要素ボタンチェック状態
                SelectObjectText.Text = OutputElementMenu.Text;          // 選択描画オブジェクト名セット
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;            // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_STD_ELEMENT; // スタンダードシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_OUTPUT;     // サブ種別出力シンボル指定
            }
            else
            {// 出力要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>InputElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void InputElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (InputElementButton.Checked == false)
            {// 入力要素配置モード以外の場合
                ButtonSelectInit();                     // ボタン選択初期化
                InputElementMenu.Checked = true;        // 入力要素メニューチェック状態
                InputElementButton.Checked = true;      // 入力要素ボタンチェック状態
                SelectObjectText.Text = InputElementMenu.Text;           // 選択描画オブジェクト名セット
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;            // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_STD_ELEMENT; // スタンダードシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_INPUT;      // サブ種別入力シンボル指定
            }
            else
            {// 入力要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ユーザ要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UserElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UserElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (UserElementButton.Checked == false)
            {// ユーザ要素配置モード以外の場合
                ButtonSelectInit();                     // ボタン選択初期化
                UserElementMenu.Checked = true;         // ユーザ要素メニューチェック状態
                UserElementButton.Checked = true;       // ユーザ要素ボタンチェック状態
                SelectObjectText.Text = UserElementMenu.Text;            // 選択描画オブジェクト名セット
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;            // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_STD_ELEMENT; // スタンダードシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_USER;       // サブ種別ユーザーシンボル指定
            }
            else
            {// ユーザ要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>合流要素選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>JunctionElement( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void JunctionElement(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (JunctionElementButton.Checked == false)
            {// データマージ要素配置モード以外の場合
                ButtonSelectInit();                                      // ボタン選択初期化
                JunctionElementMenu.Checked = true;                     // データマージ要素メニューチェック状態
                JunctionElementButton.Checked = true;                   // データマージ要素ボタンチェック状態
                SelectObjectText.Text = JunctionElementMenu.Text;       // 選択描画オブジェクト名セット
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW;            // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_STD_ELEMENT; // スタンダードシンボル指定
                m_csDrawSubKind = McDefine.HYM_DRAW_SUB_KIND_DATA_MERGE;  // サブ種別ユーザーシンボル指定
            }
            else
            {// データマージ要素配置モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                                     // ボタン選択初期化
                SelectButton.Checked = true;                            // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;         // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素接続選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ElementConnect( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ElementConnect(object sender, EventArgs e)
        {
            // ボタンステータスチェック
            if (ElementConnectButton.Checked == false)
            {// 要素接続モード以外の場合
                ButtonSelectInit();                     // ボタン選択初期化
                ElementConnectButton.Checked = true;    // 要素接続ボタンチェック状態
                SelectObjectText.Text = ElementConnectButton.Text;      // 選択描画オブジェクト名セット
                m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW_LINE;      // 作画モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_LINE;       // 接続線描画指定
            }
            else
            {// 要素接続モードの場合
                SelectObjectText.Text = "";
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;  // 描画シンボル指定なし
                ButtonSelectInit();                               // ボタン選択初期化
                SelectButton.Checked = true;                      // 選択ボタンチェック状態
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;   // 選択モード
            }

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            this.Cursor = Cursors.Default;

            //選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ一覧表編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyListEdit(EditKind, bSelectReset)</para>
        /// </example>
        /// <param name="EditKind">編集区分(0:全リスト,1:演算要素,2:入力要素,3:出力要素,4:接続一覧)</param>
        /// <param name="bSelectReset">選択情報リセット区分(true:リセット, false:リセットしない)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PropertyListEdit(int EditKind, bool bSelectReset)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_PROPETY_LIST_EDIT;

            //エレメントリスト取得
            List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();
            //ラインリスト取得
            List<McGraphicsElement> csLineList = m_csGraphicsManager.GetLineList();

            // 現在表示位置記憶
            int iScrollRowIndex1 = TabPage1DataGridView1.FirstDisplayedScrollingRowIndex;
            int iScrollRowIndex2 = TabPage1DataGridView2.FirstDisplayedScrollingRowIndex;
            int iScrollRowIndex3 = TabPage1DataGridView3.FirstDisplayedScrollingRowIndex;
            int iScrollRowIndex4 = TabPage1DataGridView4.FirstDisplayedScrollingRowIndex;

            // 全行削除
            if (EditKind == 1)
            {// 演算要素リスト編集指定の場合
                TabPage1DataGridView1.Rows.Clear();
            }
            if (EditKind == 2)
            {// 入力要素リスト編集指定の場合
                TabPage1DataGridView2.Rows.Clear();
            }
            if (EditKind == 3)
            {// 出力要素リスト編集指定の場合
                TabPage1DataGridView3.Rows.Clear();
            }
            if (EditKind == 4)
            {// 接続一覧リスト編集指定の場合
                TabPage1DataGridView4.Rows.Clear();
            }
            if (EditKind == 0)
            {// 全リスト編集指定の場合
                TabPage1DataGridView1.Rows.Clear();
                TabPage1DataGridView2.Rows.Clear();
                TabPage1DataGridView3.Rows.Clear();
                TabPage1DataGridView4.Rows.Clear();
            }

            // 編集区分にて対象タブの表示編集を行う
            if ((EditKind == 0) || (EditKind == 1) || (EditKind == 2) || (EditKind == 3))
            {// 演算要素リストまたは入力要素リストまたは出力要素リストまたは全リスト編集指定の場合
                McModelPropertyInfo csPrptyInf = null;

                for (int iLP = 0; iLP < csElmList.Count; iLP++)
                {// 要素数ループ
                    switch (csElmList[iLP].GetSymbolDrawKind())
                    {// シンボル描画種別にて分岐
                        case McDefine.SymbolDrawKind.HYM_STD_ELEMENT:   //スタンダードシンボル
                            if (((EditKind == 0) || (EditKind == 1)) &&
                                (csElmList[iLP].GetDrawSubKind() != McDefine.HYM_DRAW_SUB_KIND_INPUT) &&
                                (csElmList[iLP].GetDrawSubKind() != McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                            {// 演算要素リストまたは全リスト編集指定で入力および出力要素以外の場合
                                TabPage1DataGridView1.Rows.Add();
                                TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column10.Name].Value = csElmList[iLP].GetID().ToString();
                                if (csElmList[iLP].GetID().ToString().IndexOf('-') != -1)
                                {// 分割出来る場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column11.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, csElmList[iLP].GetID().ToString().IndexOf('-'));
                                }
                                else
                                {// 分割出来ない場合
                                    if (csElmList[iLP].GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                                    {// IDの長さが既定値以下の場合
                                        TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column11.Name].Value = csElmList[iLP].GetID().ToString();
                                    }
                                    else
                                    {// IDの長さが既定値より大きい場合
                                        TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column11.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                                    }
                                }
                                TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column12.Name].Value = csElmList[iLP].GetElementName().ToString();
                                TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column13.Name].Value = csElmList[iLP].GetDefaultName().ToString();
                                if (csElmList[iLP].GetModelInfo().GetLibraryID().ToString() == "")
                                {// モデル設定なしの場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column14.Name].Value = "";
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column15.Name].Value = "";
                                }
                                else
                                {// モデル設定ありの場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column14.Name].Value = csElmList[iLP].GetModelInfo().GetModelName().ToString();
                                    csPrptyInf = csElmList[iLP].GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                    if (csPrptyInf == null)
                                    {// プロパティ情報がない場合
                                        TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column15.Name].Value = "";
                                    }
                                    else
                                    {// プロパティ情報がある場合
                                        TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column15.Name].Value = csPrptyInf.GetStepTime().ToString();
                                    }
                                }
                                if (csElmList[iLP].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_DATA_MERGE)
                                {   // マージモデルの場合は両端の接続線のパターンをセットする。
                                    csElmList[iLP].SetDefaultPattern();
                                }
                            }
                            if (((EditKind == 0) || (EditKind == 2)) && (csElmList[iLP].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT))
                            {// 入力要素リストまたは全リスト編集指定で入力要素の場合
                                TabPage1DataGridView2.Rows.Add();
                                TabPage1DataGridView2.Rows[TabPage1DataGridView2.Rows.Count - 1].Cells[TabPage1Column20.Name].Value = csElmList[iLP].GetID().ToString();
                                if (csElmList[iLP].GetID().ToString().IndexOf('-') != -1)
                                {// 分割出来る場合
                                    TabPage1DataGridView2.Rows[TabPage1DataGridView2.Rows.Count - 1].Cells[TabPage1Column21.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, csElmList[iLP].GetID().ToString().IndexOf('-'));
                                }
                                else
                                {// 分割出来ない場合
                                    if (csElmList[iLP].GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                                    {// IDの長さが既定値以下の場合
                                        TabPage1DataGridView2.Rows[TabPage1DataGridView2.Rows.Count - 1].Cells[TabPage1Column21.Name].Value = csElmList[iLP].GetID().ToString();
                                    }
                                    else
                                    {// IDの長さが既定値より大きい場合
                                        TabPage1DataGridView2.Rows[TabPage1DataGridView2.Rows.Count - 1].Cells[TabPage1Column21.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                                    }
                                }
                                TabPage1DataGridView2.Rows[TabPage1DataGridView2.Rows.Count - 1].Cells[TabPage1Column22.Name].Value = csElmList[iLP].GetElementName().ToString();
                                if (csElmList[iLP].GetModelInfo().GetLibraryID().ToString() == "")
                                {// モデル設定なしの場合
                                    TabPage1DataGridView2.Rows[TabPage1DataGridView2.Rows.Count - 1].Cells[TabPage1Column23.Name].Value = "";
                                }
                                else
                                {// モデル設定ありの場合
                                    TabPage1DataGridView2.Rows[TabPage1DataGridView2.Rows.Count - 1].Cells[TabPage1Column23.Name].Value = ((McModelInfo)csElmList[iLP].GetModelInfo()).GetModelName().ToString();
                                }
                            }
                            if (((EditKind == 0) || (EditKind == 3)) && (csElmList[iLP].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                            {// 出力要素リストまたは全リスト編集指定で出力要素の場合
                                TabPage1DataGridView3.Rows.Add();
                                TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column30.Name].Value = csElmList[iLP].GetID().ToString();
                                if (csElmList[iLP].GetID().ToString().IndexOf('-') != -1)
                                {// 分割出来る場合
                                    TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column31.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, csElmList[iLP].GetID().ToString().IndexOf('-'));
                                }
                                else
                                {// 分割出来ない場合
                                    if (csElmList[iLP].GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                                    {// IDの長さが既定値以下の場合
                                        TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column31.Name].Value = csElmList[iLP].GetID().ToString();
                                    }
                                    else
                                    {// IDの長さが既定値より大きい場合
                                        TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column31.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                                    }
                                }
                                TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column32.Name].Value = csElmList[iLP].GetElementName().ToString();
                                if (csElmList[iLP].GetModelInfo().GetLibraryID().ToString() == "")
                                {// モデル設定なしの場合
                                    TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column33.Name].Value = "";
                                    TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column34.Name].Value = false;
                                    TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column34.Name].ReadOnly = true;
                                }
                                else
                                {// モデル設定ありの場合
                                    TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column33.Name].Value = ((McModelInfo)csElmList[iLP].GetModelInfo()).GetModelName().ToString();
                                    if (csElmList[iLP].GetModelInfo().GetAttachedScreenKind() == true)
                                    {// 付属画面ありの場合
                                        TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column34.Name].Value = csElmList[iLP].GetElementDisplayMode();
                                    }
                                    else
                                    {// 付属画面なしの場合
                                        TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column34.Name].Value = false;
                                        TabPage1DataGridView3.Rows[TabPage1DataGridView3.Rows.Count - 1].Cells[TabPage1Column34.Name].ReadOnly = true;
                                    }
                                }
                            }
                            break;
                        case McDefine.SymbolDrawKind.HYM_GROUP:         //部分系グループシンボル
                        case McDefine.SymbolDrawKind.HYM_CALC_GROUP:    //収束演算系グループシンボル
                            if ((EditKind == 0) || (EditKind == 1))
                            {// 演算要素リストまたは全リスト編集指定の場合
                                TabPage1DataGridView1.Rows.Add();
                                TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column10.Name].Value = csElmList[iLP].GetID().ToString();
                                if (csElmList[iLP].GetID().ToString().IndexOf('-') != -1)
                                {// 分割出来る場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column11.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, csElmList[iLP].GetID().ToString().IndexOf('-'));
                                }
                                else
                                {// 分割出来ない場合
                                    if (csElmList[iLP].GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                                    {// IDの長さが既定値以下の場合
                                        TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column11.Name].Value = csElmList[iLP].GetID().ToString();
                                    }
                                    else
                                    {// IDの長さが既定値より大きい場合
                                        TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column11.Name].Value = csElmList[iLP].GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                                    }
                                }
                                TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column12.Name].Value = csElmList[iLP].GetElementName().ToString();
                                if (csElmList[iLP].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP)
                                {// 部分系グループ要素の場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column13.Name].Value = csElmList[iLP].GetDefaultName().ToString();
                                }
                                else
                                {// 部分系グループ要素以外の場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column13.Name].Value = csElmList[iLP].GetDefaultName2().ToString();
                                }
                                if (csElmList[iLP].GetModelInfo().GetLibraryID().ToString() == "")
                                {// モデル設定なしの場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column14.Name].Value = "";
                                }
                                else
                                {// モデル設定ありの場合
                                    TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column14.Name].Value = csElmList[iLP].GetModelInfo().GetModelName().ToString();
                                }
                                TabPage1DataGridView1.Rows[TabPage1DataGridView1.Rows.Count - 1].Cells[TabPage1Column15.Name].Value = "";
                            }
                            break;
                    }
                }
            }
            if ((EditKind == 0) || (EditKind == 4))
            {// 接続一覧リストまたは全リスト編集指定の場合
                McGraphicsElement csFromPortElement = null;
                McGraphicsElement csToPortElement = null;
                McGraphicsElement csFromElement = null;
                McGraphicsElement csToElement = null;

                HySIdentifier csFromID = null;
                HySIdentifier csToID = null;

                string sFromPortElementIDWork = null;
                string sToPortElementIDWork = null;
                string sFromElementIDWork = null;
                string sToElementIDWork = null;
                string sFromPortElementSIDWork = null;
                string sToPortElementSIDWork = null;
                string sFromElementSIDWork = null;
                string sToElementSIDWork = null;

                for (int iLP = 0; iLP < csLineList.Count; iLP++)
                {// 接続線数ループ
                    csFromElement = null;
                    csToElement = null;
                    csLineList[iLP].GetPortID(ref csFromID, ref csToID);
                    csFromPortElement = csLineList[iLP].GetPort(csFromID);
                    csToPortElement = csLineList[iLP].GetPort(csToID);
                    csFromElement = csFromPortElement.GetParentElm();
                    csToElement = csToPortElement.GetParentElm();

                    if (csFromElement == null)
                    {// From要素がある場合
                        csFromElement = m_csDispElmList[TabControl.SelectedIndex][0];
                    }
                    if (csToElement == null)
                    {// To要素がある場合
                        csToElement = m_csDispElmList[TabControl.SelectedIndex][0];
                    }

                    // 表示用ID編集
                    sFromPortElementIDWork = csFromPortElement.GetID().ToString();
                    if (sFromPortElementIDWork.IndexOf('-') != -1)
                    {// 分割出来る場合
                        sFromPortElementSIDWork = sFromPortElementIDWork.Substring(0, sFromPortElementIDWork.IndexOf('-'));
                    }
                    else
                    {// 分割出来ない場合
                        if (sFromPortElementIDWork.Length <= USER_MAKE_ID_SHORT_LENGTH)
                        {// IDの長さが既定値以下の場合
                            sFromPortElementSIDWork = sFromPortElementIDWork;
                        }
                        else
                        {// IDの長さが既定値より大きい場合
                            sFromPortElementSIDWork = sFromPortElementIDWork.Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                        }
                    }
                    sToPortElementIDWork = csToPortElement.GetID().ToString();
                    if (sToPortElementIDWork.IndexOf('-') != -1)
                    {// 分割出来る場合
                        sToPortElementSIDWork = sToPortElementIDWork.Substring(0, sToPortElementIDWork.IndexOf('-'));
                    }
                    else
                    {// 分割出来ない場合
                        if (sToPortElementIDWork.Length <= USER_MAKE_ID_SHORT_LENGTH)
                        {// IDの長さが既定値以下の場合
                            sToPortElementSIDWork = sToPortElementIDWork;
                        }
                        else
                        {// IDの長さが既定値より大きい場合
                            sToPortElementSIDWork = sToPortElementIDWork.Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                        }
                    }
                    sFromElementIDWork = csFromElement.GetID().ToString();
                    if (sFromElementIDWork.IndexOf('-') != -1)
                    {// 分割出来る場合
                        sFromElementSIDWork = sFromElementIDWork.Substring(0, sFromElementIDWork.IndexOf('-'));
                    }
                    else
                    {// 分割出来ない場合
                        if (sFromElementIDWork.Length <= USER_MAKE_ID_SHORT_LENGTH)
                        {// IDの長さが既定値以下の場合
                            sFromElementSIDWork = sFromElementIDWork;
                        }
                        else
                        {// IDの長さが既定値より大きい場合
                            sFromElementSIDWork = sFromElementIDWork.Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                        }
                    }
                    sToElementIDWork = csToElement.GetID().ToString();
                    if (sToElementIDWork.IndexOf('-') != -1)
                    {// 分割出来る場合
                        sToElementSIDWork = sToElementIDWork.Substring(0, sToElementIDWork.IndexOf('-'));
                    }
                    else
                    {// 分割出来ない場合
                        if (sToElementIDWork.Length <= USER_MAKE_ID_SHORT_LENGTH)
                        {// IDの長さが既定値以下の場合
                            sToElementSIDWork = sToElementIDWork;
                        }
                        else
                        {// IDの長さが既定値より大きい場合
                            sToElementSIDWork = sToElementIDWork.Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                        }
                    }

                    TabPage1DataGridView4.Rows.Add();
                    TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column40.Name].Value = csLineList[iLP].GetID().ToString();
                    if (csLineList[iLP].GetID().ToString().IndexOf('-') != -1)
                    {// 分割出来る場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column41.Name].Value = csLineList[iLP].GetID().ToString().Substring(0, csLineList[iLP].GetID().ToString().IndexOf('-'));
                    }
                    else
                    {// 分割出来ない場合
                        if (csLineList[iLP].GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                        {// IDの長さが既定値以下の場合
                            TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column41.Name].Value = csLineList[iLP].GetID().ToString();
                        }
                        else
                        {// IDの長さが既定値より大きい場合
                            TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column41.Name].Value = csLineList[iLP].GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                        }
                    }
                    TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column411.Name].Value = csLineList[iLP].GetElementName().ToString();
                    if (csLineList[iLP].GetModelInfo().GetLibraryID().ToString() == "")
                    {// モデル設定なしの場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column410.Name].Value = "";
                    }
                    else
                    {// モデル設定ありの場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column410.Name].Value = csLineList[iLP].GetModelInfo().GetModelName().ToString();
                    }
                    if ((csFromPortElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csFromPortElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 中継端子以外の場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column42.Name].Value = sFromElementIDWork;
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column43.Name].Value = sFromElementSIDWork;
                    }
                    else
                    {// 中継端子の場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column42.Name].Value = sFromElementIDWork + "(" + sFromPortElementIDWork + ")";
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column43.Name].Value = sFromElementSIDWork + "(" + sFromPortElementSIDWork + ")";
                    }
                    TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column44.Name].Value = csFromElement.GetElementName().ToString();
                    if (csFromElement.GetModelInfo().GetLibraryID().ToString() == "")
                    {// モデル設定なしの場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column45.Name].Value = "";
                    }
                    else
                    {// モデル設定ありの場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column45.Name].Value = csFromElement.GetModelInfo().GetModelName().ToString();
                    }
                    if ((csToPortElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csToPortElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 中継端子以外の場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column46.Name].Value = sToElementIDWork;
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column47.Name].Value = sToElementSIDWork;
                    }
                    else
                    {// 中継端子の場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column46.Name].Value = sToElementIDWork + "(" + sToPortElementIDWork + ")";
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column47.Name].Value = sToElementSIDWork + "(" + sToPortElementSIDWork + ")";
                    }
                    TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column48.Name].Value = csToElement.GetElementName().ToString();
                    if (csToElement.GetModelInfo().GetLibraryID().ToString() == "")
                    {// モデル設定なしの場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column49.Name].Value = "";
                    }
                    else
                    {// モデル設定ありの場合
                        TabPage1DataGridView4.Rows[TabPage1DataGridView4.Rows.Count - 1].Cells[TabPage1Column49.Name].Value = csToElement.GetModelInfo().GetModelName().ToString();
                    }
                }
            }
            if (bSelectReset == true)
            {// 選択情報リセット指定の場合
                //プロパティ一覧選択状態解除
                PropertyListSelectionClear(0);

                m_csGraphicsManager.ClearSelectionList();
            }
            else
            {// 選択情報非リセット指定の場合
                //プロパティ一覧選択同期
                ListSelectionMatching();
            }

            //スクロール位置セット
            if ((EditKind == 1) || (EditKind == 0))
            {// 演算要素リストまたは全リスト編集指定の場合
                if ((iScrollRowIndex1 > 0) && (TabPage1DataGridView1.Rows.Count > 0))
                {// 編集前に選択行がありリストの行数が０より大きい場合
                    if (TabPage1DataGridView1.Rows.Count > iScrollRowIndex1)
                    {// 編集前の選択行が有効な場合
                        TabPage1DataGridView1.FirstDisplayedScrollingRowIndex = iScrollRowIndex1;
                    }
                    else
                    {// 編集前の選択行が無効な場合
                        TabPage1DataGridView1.FirstDisplayedScrollingRowIndex = TabPage1DataGridView1.Rows.Count - 1;
                    }
                }
            }
            if ((EditKind == 2) || (EditKind == 0))
            {// 入力要素リストまたは全リスト編集指定の場合
                if ((iScrollRowIndex2 > 0) && (TabPage1DataGridView2.Rows.Count > 0))
                {// 編集前に選択行がありリストの行数が０より大きい場合
                    if (TabPage1DataGridView2.Rows.Count > iScrollRowIndex2)
                    {// 編集前の選択行が有効な場合
                        TabPage1DataGridView2.FirstDisplayedScrollingRowIndex = iScrollRowIndex2;
                    }
                    else
                    {// 編集前の選択行が無効な場合
                        TabPage1DataGridView2.FirstDisplayedScrollingRowIndex = TabPage1DataGridView2.Rows.Count - 1;
                    }
                }
            }
            if ((EditKind == 3) || (EditKind == 0))
            {// 出力要素リストまたは全リスト編集指定の場合
                if ((iScrollRowIndex3 > 0) && (TabPage1DataGridView3.Rows.Count > 0))
                {// 編集前に選択行がありリストの行数が０より大きい場合
                    if (TabPage1DataGridView3.Rows.Count > iScrollRowIndex3)
                    {// 編集前の選択行が有効な場合
                        TabPage1DataGridView3.FirstDisplayedScrollingRowIndex = iScrollRowIndex3;
                    }
                    else
                    {// 編集前の選択行が無効な場合
                        TabPage1DataGridView3.FirstDisplayedScrollingRowIndex = TabPage1DataGridView3.Rows.Count - 1;
                    }
                }
            }
            if ((EditKind == 4) || (EditKind == 0))
            {// 接続一覧リストまたは全リスト編集指定の場合
                if ((iScrollRowIndex4 > 0) && (TabPage1DataGridView4.Rows.Count > 0))
                {// 編集前に選択行がありリストの行数が０より大きい場合
                    if (TabPage1DataGridView4.Rows.Count > iScrollRowIndex4)
                    {// 編集前の選択行が有効な場合
                        TabPage1DataGridView4.FirstDisplayedScrollingRowIndex = iScrollRowIndex4;
                    }
                    else
                    {// 編集前の選択行が無効な場合
                        TabPage1DataGridView4.FirstDisplayedScrollingRowIndex = TabPage1DataGridView4.Rows.Count - 1;
                    }
                }
            }

            m_eDrawMode = eTempDrawMode;

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティリスト選択変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ListSelectionChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListSelectionChanged(object sender, EventArgs e)
        {
            // モードチェック
            if ((m_eDrawMode != McDefine.DrawModeKind.HYM_MODEL_CHECK) &&
                (m_eDrawMode != McDefine.DrawModeKind.HYM_PROPETY_LIST_EDIT))
            {// モデルチェック中およびプロパティリスト編集中以外の場合
                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
                {// 選択モードの場合
                    // カーソルを砂時計にする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.WaitCursor;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.WaitCursor;
                    }

                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;

                    //選択中要素リストクリア
                    m_csGraphicsManager.ClearSelectionList();

                    DataGridView[] csGV = { TabPage1DataGridView1, TabPage1DataGridView2, TabPage1DataGridView3, TabPage1DataGridView4 };

                    int iLp = 0;
                    int iLpMax = 3;
                    //CONTROLかShiftキーが押されているかチェック
                    if (Control.ModifierKeys != Keys.Control && Control.ModifierKeys != Keys.Shift)
                    {// CONTROLおよびShiftキーが押されていない場合
                        iLp = TabPage1TabPControl.SelectedIndex;
                        iLpMax = TabPage1TabPControl.SelectedIndex;
                    }
                    if (iLpMax > 3)
                    {// ループMAXが３より大きい場合
                        iLpMax = 3;
                    }

                    for (; iLp <= iLpMax; iLp++)
                    {// ループMAXまでループ
                        for (int iLp2 = 0; iLp2 < csGV[iLp].Rows.Count; iLp2++)
                        {// 行数ループ
                            if (csGV[iLp].Rows[iLp2].Selected == true)
                            {// 選択中の場合
                                //選択中要素追加
                                m_csGraphicsManager.AddSelectionList(new HySString(csGV[iLp].Rows[iLp2].Cells[0].Value.ToString()));
                            }
                        }
                    }

                    // カーソルをデフォルトにする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.Default;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.Default;
                    }

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    //プロパティリスト選択同期
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
                }
                else
                {// 選択モード以外の場合
                    if ((m_eDrawMode != McDefine.DrawModeKind.HYM_SELECT_ELEMENT) &&
                        (m_eDrawMode != McDefine.DrawModeKind.HYM_DRAW_LINE) &&
                        (m_eDrawMode != McDefine.DrawModeKind.HYM_DRAW_LINE_CONTINU))
                    {// 選択モード（画面エレメント選択）および作画モード接続線および作画連続モード接続線以外の場合
                        //プロパティ一覧選択状態解除
                        PropertyListSelectionClear(0);
                    }
                }

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティリスト選択変更2</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ListSelectionChanged2( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListSelectionChanged2(object sender, EventArgs e)
        {
            // モードチェック
            if ((m_eDrawMode != McDefine.DrawModeKind.HYM_MODEL_CHECK) &&
                (m_eDrawMode != McDefine.DrawModeKind.HYM_PROPETY_LIST_EDIT))
            {// モデルチェック中およびプロパティリスト編集中以外の場合
                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
                {// 選択モードの場合
                    // カーソルを砂時計にする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.WaitCursor;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.WaitCursor;
                    }

                    //選択中要素リストクリア
                    m_csGraphicsManager.ClearSelectionList();

                    for (int iLp2 = 0; iLp2 < TabPage1DataGridView5.Rows.Count; iLp2++)
                    {// 行数ループ
                        if (TabPage1DataGridView5.Rows[iLp2].Selected == true)
                        {// 選択中の場合
                            if (m_csGraphicsManager.SearchSelectionList(new HySString(TabPage1DataGridView5.Rows[iLp2].Cells[TabPage1Column50.Name].Value.ToString())) == -1)
                            {// 未選択要素の場合
                                //選択中要素追加
                                m_csGraphicsManager.AddSelectionList(new HySString(TabPage1DataGridView5.Rows[iLp2].Cells[TabPage1Column50.Name].Value.ToString()));
                            }
                        }
                    }

                    // カーソルをデフォルトにする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.Default;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.Default;
                    }

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
                }
                else
                {// 選択モード以外の場合
                    if ((m_eDrawMode != McDefine.DrawModeKind.HYM_SELECT_ELEMENT) &&
                        (m_eDrawMode != McDefine.DrawModeKind.HYM_DRAW_LINE) &&
                        (m_eDrawMode != McDefine.DrawModeKind.HYM_DRAW_LINE_CONTINU))
                    {// 選択モード（画面エレメント選択）および作画モード接続線および作画連続モード接続線以外の場合
                        //プロパティ一覧選択状態解除
                        PropertyListSelectionClear(0);
                    }
                }

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティリスト選択同期</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ListSelectionMatching()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ListSelectionMatching()
        {
            bool bMatchFlg = false;

            //選択中要素リスト取得
            List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();

            //プロパティ一覧選択状態解除
            PropertyListSelectionClear(0);

            DataGridView[] csGV = { TabPage1DataGridView1, TabPage1DataGridView2, TabPage1DataGridView3, TabPage1DataGridView4 };

            for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
            {// 選択要素数ループ
                bMatchFlg = false;

                for (int iLp2 = 0; (iLp2 < 4) && (bMatchFlg == false); iLp2++)
                {// ４リストループ
                    for (int iLp3 = 0; iLp3 < csGV[iLp2].Rows.Count; iLp3++)
                    {// 行数ループ
                        if (csSelectionList[iLp].GetID().ToString() == csGV[iLp2].Rows[iLp3].Cells[0].Value.ToString())
                        {// IDが一致した場合
                            //プロパティ一覧選択状態設定
                            csGV[iLp2].Rows[iLp3].Selected = true;
                            bMatchFlg = true;
                            // 計算結果モニタへの選択イベント通知
                            if (csGV[iLp2].Equals(TabPage1DataGridView3) == true)
                            {  // 出力要素の場合
                                ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenActiveEvent(csSelectionList[iLp].GetID());
                            }
                            break;
                        }
                    }
                }
                for (int iLp2 = 0; iLp2 < TabPage1DataGridView5.Rows.Count; iLp2++)
                {// 行数ループ
                    if ("" != TabPage1DataGridView5.Rows[iLp2].Cells[TabPage1Column50.Name].Value.ToString())
                    {// IDがある場合
                        if (csSelectionList[iLp].GetID().ToString() == TabPage1DataGridView5.Rows[iLp2].Cells[TabPage1Column50.Name].Value.ToString())
                        {// IDが一致した場合
                            //プロパティ一覧選択状態設定
                            TabPage1DataGridView5.Rows[iLp2].Selected = true;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ一覧選択状態解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyListSelectionClear(ClearKind)</para>
        /// </example>
        /// <param name="ClearKind">編集区分(0:プロパティリスト＋チェックリスト,1:プロパティリスト)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropertyListSelectionClear(int ClearKind)
        {
            if (ClearKind == 0)
            {// 編集区分が０の場合
                TabPage1DataGridView1.ClearSelection();
                TabPage1DataGridView2.ClearSelection();
                TabPage1DataGridView3.ClearSelection();
                TabPage1DataGridView4.ClearSelection();
                TabPage1DataGridView5.ClearSelection();
            }
            else if (ClearKind == 1)
            {// 編集区分が１の場合
                TabPage1DataGridView1.ClearSelection();
                TabPage1DataGridView2.ClearSelection();
                TabPage1DataGridView3.ClearSelection();
                TabPage1DataGridView4.ClearSelection();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ一覧表ソート</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyListSort(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropertyListSort(object sender, DataGridViewCellMouseEventArgs e)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            DataGridView[] csGV = { TabPage1DataGridView1, TabPage1DataGridView2, TabPage1DataGridView3, TabPage1DataGridView4, TabPage1DataGridView5 };
            DataGridViewColumn newColumn = csGV[TabPage1TabPControl.SelectedIndex].Columns[e.ColumnIndex];
            DataGridViewColumn oldColumn = csGV[TabPage1TabPControl.SelectedIndex].Columns[m_iPropertyListSortColumnIndex[TabPage1TabPControl.SelectedIndex]];

            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_PROPETY_LIST_EDIT;

            //未ソート状態かチェック
            if (oldColumn.HeaderCell.SortGlyphDirection != SortOrder.None)
            {// ソート済みの場合
                //同じカラム選択かチェック
                if (oldColumn == newColumn)
                {// 同じカラムが選択された場合
                    if (oldColumn.HeaderCell.SortGlyphDirection == SortOrder.Descending)
                    {// ソート順が降順の場合
                        newColumn.HeaderCell.SortGlyphDirection = SortOrder.Ascending;
                    }
                    else
                    {// ソート順が昇順の場合
                        newColumn.HeaderCell.SortGlyphDirection = SortOrder.Descending;
                    }
                }
                else
                {// 違うカラムが選択された場合
                    newColumn.HeaderCell.SortGlyphDirection = SortOrder.Ascending;
                    oldColumn.HeaderCell.SortGlyphDirection = SortOrder.None;
                }
            }
            else
            {// 未ソートの場合
                newColumn.HeaderCell.SortGlyphDirection = SortOrder.Ascending;
            }

            //ソートルーチン
            for (int iLp1 = 0; iLp1 < csGV[TabPage1TabPControl.SelectedIndex].Rows.Count - 1; iLp1++)
            {// 行数－１ループ
                for (int iLp2 = csGV[TabPage1TabPControl.SelectedIndex].Rows.Count - 1; iLp2 > iLp1; iLp2--)
                {// チェック済み行までループ
                    if (newColumn.HeaderCell.SortGlyphDirection == SortOrder.Ascending)
                    {// ソート順が昇順の場合
                        if (csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2].Cells[e.ColumnIndex].Value.ToString().Length == csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[e.ColumnIndex].Value.ToString().Length)
                        {// 文字数が同じ場合
                            if (0 > csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2].Cells[e.ColumnIndex].Value.ToString().CompareTo(csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[e.ColumnIndex].Value.ToString()))
                            {// 前行が大きい場合
                                csGV[TabPage1TabPControl.SelectedIndex].Rows.Insert(iLp2 - 1, 1);
                                for (int iLp3 = 0; iLp3 < csGV[TabPage1TabPControl.SelectedIndex].ColumnCount; iLp3++)
                                {// カラム数ループ
                                    csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[iLp3].Value = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Cells[iLp3].Value;
                                }
                                csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Selected = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Selected;
                                csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].DefaultCellStyle.ForeColor = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].DefaultCellStyle.ForeColor;
                                csGV[TabPage1TabPControl.SelectedIndex].Rows.RemoveAt(iLp2 + 1);
                            }
                        }
                        else if (csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2].Cells[e.ColumnIndex].Value.ToString().Length < csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[e.ColumnIndex].Value.ToString().Length)
                        {// 前行の文字数が多い場合
                            csGV[TabPage1TabPControl.SelectedIndex].Rows.Insert(iLp2 - 1, 1);
                            for (int iLp3 = 0; iLp3 < csGV[TabPage1TabPControl.SelectedIndex].ColumnCount; iLp3++)
                            {// カラム数ループ
                                csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[iLp3].Value = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Cells[iLp3].Value;
                            }
                            csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Selected = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Selected;
                            csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].DefaultCellStyle.ForeColor = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].DefaultCellStyle.ForeColor;
                            csGV[TabPage1TabPControl.SelectedIndex].Rows.RemoveAt(iLp2 + 1);
                        }
                    }
                    else
                    {// ソート順が降順の場合
                        if (csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2].Cells[e.ColumnIndex].Value.ToString().Length == csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[e.ColumnIndex].Value.ToString().Length)
                        {// 文字数が同じ場合
                            if (0 < csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2].Cells[e.ColumnIndex].Value.ToString().CompareTo(csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[e.ColumnIndex].Value.ToString()))
                            {// 前行が小さい場合
                                csGV[TabPage1TabPControl.SelectedIndex].Rows.Insert(iLp2 - 1, 1);
                                for (int iLp3 = 0; iLp3 < csGV[TabPage1TabPControl.SelectedIndex].ColumnCount; iLp3++)
                                {// カラム数ループ
                                    csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[iLp3].Value = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Cells[iLp3].Value;
                                }
                                csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Selected = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Selected;
                                csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].DefaultCellStyle.ForeColor = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].DefaultCellStyle.ForeColor;
                                csGV[TabPage1TabPControl.SelectedIndex].Rows.RemoveAt(iLp2 + 1);
                            }
                        }
                        else if (csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2].Cells[e.ColumnIndex].Value.ToString().Length > csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[e.ColumnIndex].Value.ToString().Length)
                        {// 前行の文字数が少ない場合
                            csGV[TabPage1TabPControl.SelectedIndex].Rows.Insert(iLp2 - 1, 1);
                            for (int iLp3 = 0; iLp3 < csGV[TabPage1TabPControl.SelectedIndex].ColumnCount; iLp3++)
                            {// カラム数ループ
                                csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Cells[iLp3].Value = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Cells[iLp3].Value;
                            }
                            csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].Selected = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].Selected;
                            csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 - 1].DefaultCellStyle.ForeColor = csGV[TabPage1TabPControl.SelectedIndex].Rows[iLp2 + 1].DefaultCellStyle.ForeColor;
                            csGV[TabPage1TabPControl.SelectedIndex].Rows.RemoveAt(iLp2 + 1);
                        }
                    }
                }
            }
            m_iPropertyListSortColumnIndex[TabPage1TabPControl.SelectedIndex] = e.ColumnIndex;

            m_iPropertyListSortColumnIndexList[TabControl.SelectedIndex] = m_iPropertyListSortColumnIndex;

            //プロパティリスト選択同期
            ListSelectionMatching();

            m_eDrawMode = eTempDrawMode;

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ一覧表変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyListModify(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropertyListModify(object sender, DataGridViewCellEventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_PROPETY_LIST_EDIT)
            {// プロパティリスト編集中以外の場合
                DataGridView[] csGV = { TabPage1DataGridView1, TabPage1DataGridView2, TabPage1DataGridView3, TabPage1DataGridView4 };

                HySString csID = new HySString(csGV[TabPage1TabPControl.SelectedIndex].Rows[e.RowIndex].Cells[0].Value.ToString());
                HySString csElementName = null;
                HySString csElementNameOld = null;

                // 変更カラムチェック
                if (e.ColumnIndex == 2)
                {// 名称カラムの場合
                    if (csGV[TabPage1TabPControl.SelectedIndex].Rows[e.RowIndex].Cells[e.ColumnIndex].Value == null)
                    {// Nullの場合
                        csElementName = new HySString("");
                    }
                    else
                    {// Null以外の場合
                        csElementName = new HySString(csGV[TabPage1TabPControl.SelectedIndex].Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString());
                    }

                    McGraphicsElement csElment = m_csGraphicsManager.SetElementName(csElementName, ref csElementNameOld, csID);

                    // プロパティ画面リフレッシュ
                    PropetyScreenRefreshment(csElment.GetID());

                    // 接続線の場合、連接要素のプロパティ画面もリフレッシュする
                    if (csElment.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線の場合
                        // プロパティ画面リフレッシュ
                        PropetyScreenRefreshment(csElment.GetPort(0).GetParentElm().GetID());
                        PropetyScreenRefreshment(csElment.GetPort(1).GetParentElm().GetID());
                    }

                    // 部分系表示チェック
                    for (int iLp = 1; iLp < m_iTabCount; iLp++)
                    {// グループ内部表示タブ数ループ
                        if (csElment.GetID().ToString() == m_csDispElmList[iLp][0].GetID().ToString())
                        {// IDが一致した場合
                            if (csElment.GetID().ToString().IndexOf('-') != -1)
                            {// 分割出来る場合
                                TabControl.TabPages[iLp].Text = Properties.McDotNetViewerResources.MODEL_TAB_PART + csElementName.ToString().Trim() + " " + csElment.GetID().ToString().Substring(0, csElment.GetID().ToString().IndexOf('-')) + "...";
                            }
                            else
                            {// 分割出来ない場合
                                if (csElment.GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                                {// IDの長さが既定値以下の場合
                                    TabControl.TabPages[iLp].Text = Properties.McDotNetViewerResources.MODEL_TAB_PART + csElementName.ToString().Trim() + " " + csElment.GetID().ToString() + "...";
                                }
                                else
                                {// IDの長さが既定値より大きい場合
                                    TabControl.TabPages[iLp].Text = Properties.McDotNetViewerResources.MODEL_TAB_PART + csElementName.ToString().Trim() + " " + csElment.GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH) + "...";
                                }
                            }
                            break;
                        }
                    }

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.NAME, true, true);

                    if (TabPage1TabPControl.SelectedIndex < 3)
                    {// 表示中リストが接続一覧より小さい場合
                        // リスト部編集
                        PropertyListEdit(4, false);
                    }

                    //復元データ編集
                    McHistoryData csHistoryData = new McHistoryData();
                    csHistoryData.Kind = McHistoryData.OperationKind.CHANGE_NAME;
                    m_csHistoryDataWork = new List<object>();
                    m_csHistoryDataWork.Add(csElment.GetID());
                    m_csHistoryDataWork.Add(csElementNameOld);
                    m_csHistoryDataWork.Add(csElementName);
                    csHistoryData.HistoryData = m_csHistoryDataWork;

                    //復元ポイント記録
                    ReconstructionPointSave(false, csHistoryData);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ一覧表クリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyListClick(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropertyListClick(object sender, DataGridViewCellEventArgs e)
        {
            // クリック行チェック
            if (e.RowIndex > -1)
            {// クリック行が有効の場合
                if ((TabPage1TabPControl.SelectedIndex == 2) && (e.ColumnIndex == 4))
                {// 出力要素リストで画面表示カラムをクリックの場合
                    if (TabPage1DataGridView3.Rows[e.RowIndex].Cells[e.ColumnIndex].ReadOnly == false)
                    {// クリック行が有効の場合
                        HySString csID = new HySString(TabPage1DataGridView3.Rows[e.RowIndex].Cells[TabPage1Column30.Name].Value.ToString());
                        bool bDisplayMode = !(bool)TabPage1DataGridView3.Rows[e.RowIndex].Cells[e.ColumnIndex].Value;
                        if (bDisplayMode != m_csGraphicsManager.GetElementDisplayMode(csID))
                        {// 画面表示設定が変更された場合
                            HySIdentifier csElementID = m_csGraphicsManager.SetElementDisplayMode(bDisplayMode, csID);

                            if (bDisplayMode == true)
                            {  // 画面表示要求の場合
                                List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();
                                for (int iLP = 0; iLP < csElmList.Count; iLP++)
                                {// 要素数ループ
                                    if (csElementID.Equals(csElmList[iLP].GetID()) == true)
                                    {// IDが一致した場合
                                        McModelInfo csModelInf = csElmList[iLP].GetModelInfo();
                                        McCellModelPropertyInfo csPropertyInfo = csModelInf.GetPropertyInfo() as McCellModelPropertyInfo;
                                        HySDataLinkedList csInputList = csPropertyInfo.GetInputConnectionInfoList();
                                        if (csInputList.GetCount() > 0)
                                        {  // 入力接続データが有る場合
                                            HySDataLinkedList csPatternID = new HySDataLinkedList();
                                            for (long lP = 0; lP < csInputList.GetCount(); lP++)
                                            {  // 接続要素数分繰り返す
                                                McModelInfo csModelInfo = csInputList.GetData(lP) as McModelInfo;
                                                McCellArrayTranInfoPropertyInfo csCellModelPropertyInfo = csModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                                                if (csCellModelPropertyInfo is McCellArrayTranInfoPropertyInfo)
                                                {  // 接続要素が有効な場合
                                                    csPatternID.AddLast(csCellModelPropertyInfo.GetLowerConnectionPatternID()); // 接続要素パターンＩＤ設定
                                                }
                                            }
                                            ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenDispEvent(csElementID, csPatternID);
                                            if (csPatternID.GetCount() > 0)
                                            {  // 接続要素が有効な場合
                                                ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenDispEvent(csElementID, csPatternID);
                                            }
                                            else
                                            {  // 接続要素が無効な場合
                                                csPatternID = null;
                                            }
                                        }
                                        else
                                        {  // 入力接続データが無い場合
                                            HySDataLinkedList csPatternID = new HySDataLinkedList();
                                            ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenDispEvent(csElementID, csPatternID);
                                        }
                                        break;
                                    }
                                }
                            }
                            else
                            {  // 画面消去要求の場合
                                ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenCloseEvent(csElementID);
                            }

                            // リスト部編集
                            PropertyListEdit(3, false);
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウスダウンイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseDown(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseDown(object sender, MouseEventArgs e)
        {
            // タブコントロールにフォーカス設定
            TabControl.Focus();

            if (e.Button == MouseButtons.Right)
            {// 右クリックの場合
                return;
            }

            McGraphicsElement csElement = null;

            // 座標計算
            int iVirtualX = m_pDispPoint.X + (m_iWidth * 100 / (int)m_lDispScale) * e.X / m_iWidth;
            int iVirtualY = m_pDispPoint.Y + (m_iHeight * 100 / (int)m_lDispScale) * e.Y / m_iHeight;

            // 座標計算
            int iImageX = (int)((m_pDispPoint.X + e.X * 100.0 / m_lDispScale) * m_lDispScale / 100.0);
            int iImageY = (int)((m_pDispPoint.Y + e.Y * 100.0 / m_lDispScale) * m_lDispScale / 100.0);

            switch (m_eDrawMode)
            {// モードにより分岐
                case McDefine.DrawModeKind.HYM_DRAW:                // グラフィックスの新規作成
                case McDefine.DrawModeKind.HYM_DRAW_CONTINU:        // グラフィックスの連続新規作成
                    // モードチェック
                    if (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_CONTINU)
                    {// 作画連続モードの場合
                        //Shiftキーが押されているかチェック
                        if (Control.ModifierKeys != Keys.Shift)
                        {// Shiftキーが押されていない場合
                            ButtonSelectInit();                                         // ボタン選択初期化
                            SelectButton.Checked = true;                                // 選択ボタンチェック状態
                            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード
                            SelectObjectText.Text = "";                                 // 選択描画オブジェクト名クリア
                            m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし
                            break;
                        }
                    }
                    switch (m_eSymbolKind)
                    {// シンボル種別により分岐
                        case McDefine.SymbolDrawKind.HYM_STD_ELEMENT:     // 要素新規作成
                        case McDefine.SymbolDrawKind.HYM_GROUP:           // 部分系グループ要素新規作成
                        case McDefine.SymbolDrawKind.HYM_CALC_GROUP:      // 収束演算グループ要素新規作成

                            McGraphicsElement csNewElement = null;
                            csNewElement = m_csGraphicsManager.AddElement(m_eSymbolKind, m_csDrawSubKind);   // エレメント追加
                            csNewElement.SetPosition(iVirtualX, iVirtualY);
                            m_csGraphicsManager.ClearSelectionList();

                            if ((m_csDrawSubKind != McDefine.HYM_DRAW_SUB_KIND_INPUT) &&
                                (m_csDrawSubKind != McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                            {// 入力要素および出力要素以外の場合
                                // リスト部編集
                                PropertyListEdit(1, true);
                                TabPage1TabPControl.SelectedIndex = 0;
                            }
                            else if (m_csDrawSubKind == McDefine.HYM_DRAW_SUB_KIND_INPUT)
                            {// 入力要素の場合
                                // リスト部編集
                                PropertyListEdit(2, true);
                                TabPage1TabPControl.SelectedIndex = 1;
                            }
                            else if (m_csDrawSubKind == McDefine.HYM_DRAW_SUB_KIND_OUTPUT)
                            {// 出力要素の場合
                                // リスト部編集
                                PropertyListEdit(3, true);
                                TabPage1TabPControl.SelectedIndex = 2;
                            }

                            //新規作成要素を選択中要素リストに追加
                            m_csGraphicsManager.AddSelectionList(csNewElement);

                            //プロパティリスト選択同期
                            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                            ListSelectionMatching();
                            break;

                        default:
                            break;
                    }
                    m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW_ADD_ELEMENT;
                    break;

                case McDefine.DrawModeKind.HYM_DRAW_LINE:           // 接続線新規作成
                case McDefine.DrawModeKind.HYM_DRAW_LINE_CONTINU:   // 接続線連続新規作成
                    // モードチェック
                    if (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_LINE_CONTINU)
                    {// 作画連続モード接続線の場合
                        //Shiftキーが押されているかチェック
                        if (Control.ModifierKeys != Keys.Shift)
                        {// Shiftキーが押されていない場合
                            ButtonSelectInit();                                         // ボタン選択初期化
                            SelectButton.Checked = true;                                // 選択ボタンチェック状態
                            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード
                            SelectObjectText.Text = "";                                 // 選択描画オブジェクト名クリア
                            m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし
                            break;
                        }
                    }
                    // 指定位置エレメント有無チェック
                    csElement = m_csGraphicsManager.ElementPositionCheck(iImageX, iImageY, ref m_bPortFlg);
                    if (csElement != null)
                    {// 指定位置に要素があった場合
                        McDefine.SymbolDrawKind eDrawKind = csElement.GetSymbolDrawKind();
                        if ((eDrawKind == McDefine.SymbolDrawKind.HYM_LINE) ||
                            (eDrawKind == McDefine.SymbolDrawKind.HYM_RECEIVE) ||
                            (eDrawKind == McDefine.SymbolDrawKind.HYM_SEND))
                        {// 接続線および端子の場合
                            break;
                        }

                        m_csElementTemp = csElement;

                        m_csGraphicsManager.ClearSelectionList();

                        //選択要素を選択中要素リストに追加
                        m_csGraphicsManager.AddSelectionList(csElement);

                        //プロパティリスト選択同期
                        m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                        ListSelectionMatching();
                        m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW_LINE_FROM_SELECT;
                    }
                    break;

                case McDefine.DrawModeKind.HYM_DRAW_LINE_FROM_SELECT:   // 接続線新規作成
                    // 指定位置エレメント有無チェック
                    csElement = m_csGraphicsManager.ElementPositionCheck(iImageX, iImageY, ref m_bPortFlg);
                    if (csElement != null)
                    {// 指定位置に要素があった場合
                        if (csElement.Equals(m_csElementTemp.GetID()) == true)
                        {// IDが一致した場合
                            break;
                        }

                        McDefine.SymbolDrawKind eDrawKind = csElement.GetSymbolDrawKind();
                        if ((eDrawKind == McDefine.SymbolDrawKind.HYM_LINE) ||
                            (eDrawKind == McDefine.SymbolDrawKind.HYM_RECEIVE) ||
                            (eDrawKind == McDefine.SymbolDrawKind.HYM_SEND))
                        {// 接続線および端子の場合
                            break;
                        }

                        McGraphicsElement csNewLine = null;

                        // 接続生成
                        csNewLine = m_csGraphicsManager.CreateNewConnection(m_csElementTemp.GetID(), csElement.GetID());

                        if (csNewLine == null)
                        {// 接続線生成失敗の場合
                            break;
                        }

                        //復元データ編集
                        m_csHistoryDataWork = new List<object>();
                        List<HySIdentifier> csAddPortIDList = new List<HySIdentifier>();
                        HySIdentifier csFromPortID = null;
                        HySIdentifier csToPortID = null;
                        csNewLine.GetPortID(ref csFromPortID, ref csToPortID);
                        if (csFromPortID.Equals(m_csElementTemp.GetID()) != true)
                        {// IDが一致しない場合
                            csAddPortIDList.Add(csFromPortID);
                        }
                        if (csToPortID.Equals(csElement.GetID()) != true)
                        {// IDが一致しない場合
                            csAddPortIDList.Add(csToPortID);
                        }

                        m_csHistoryDataWork.Add(csNewLine.CopyInfUsedByUndoRedoOnly(null));
                        m_csHistoryDataWork.Add(csAddPortIDList);

                        m_csGraphicsManager.ClearSelectionList();

                        // リスト部編集
                        PropertyListEdit(4, true);

                        TabPage1TabPControl.SelectedIndex = 3;

                        //新規接続線を選択中要素リストに追加
                        m_csGraphicsManager.AddSelectionList(csNewLine);

                        //プロパティリスト選択同期
                        m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                        ListSelectionMatching();
                        m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW_LINE_TO_SELECT;
                    }
                    break;

                case McDefine.DrawModeKind.HYM_SELECT:     // 選択モード
                    // 指定位置エレメント有無チェック
                    csElement = m_csGraphicsManager.ElementPositionCheck(iImageX, iImageY, ref m_bPortFlg);
                    if (csElement != null)
                    {// 指定位置に要素があった場合
                        m_csSelectElm = csElement;

                        // 選択エレメントが未選択かチェック
                        if (m_csGraphicsManager.SearchSelectionList((HySString)m_csSelectElm.GetID().GetString()) == -1)
                        {// 未選択の場合
                            //CONTROLかShiftキーが押されているかチェック
                            if (Control.ModifierKeys != Keys.Control && Control.ModifierKeys != Keys.Shift)
                            {// CONTROLおよびShiftキーが押されていない場合
                                // 全選択解除
                                m_csGraphicsManager.ClearSelectionList();

                                //プロパティ一覧選択状態解除
                                PropertyListSelectionClear(0);
                            }

                            //選択要素を選択中要素リストに追加
                            m_csGraphicsManager.AddSelectionList(csElement);

                            if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP)||
                                (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                            {// グループ要素の場合
                                TabPage1TabPControl.SelectedIndex = 0;
                            }
                            else if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)&&
                                     (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT))
                            {// 入力要素の場合
                                TabPage1TabPControl.SelectedIndex = 1;
                            }
                            else if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                                     (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                            {// 出力要素の場合
                                TabPage1TabPControl.SelectedIndex = 2;
                            }
                            else if (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)
                            {// 通常要素の場合
                                TabPage1TabPControl.SelectedIndex = 0;
                            }
                            else if (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                            {// 接続線の場合
                                TabPage1TabPControl.SelectedIndex = 3;
                            }

                            // エレメントリサイズポイントクリックチェック
                            if (m_csGraphicsManager.ElementResizePointCheck(csElement, iImageX, iImageY) == true)
                            {// リサイズポイントをクリックの場合
                                m_bResizeFlg = true;
                            }
                            else
                            {// リサイズポイント以外をクリックの場合
                                m_bMoveFlg = true;

                                if (m_bPortFlg != true)
                                {// 端子以外選択の場合
                                    // 移動処理間引き用操作開始時間設定
                                    m_csPreprocessingTime = DateTime.Now;
                                }
                            }
                        }
                        else    // エレメント選択中
                        {// 選択済みの場合
                            if (Control.ModifierKeys == Keys.Control || Control.ModifierKeys == Keys.Shift)     // CONTROLかShiftキーが押されているかチェック
                            {// CONTROLおよびShiftキーが押されている場合
                                // 選択中要素リストから削除
                                m_csGraphicsManager.DelSelectionList((HySString)m_csSelectElm.GetID().GetString());
                            }
                            else
                            {// CONTROLおよびShiftキーが押されていない場合
                                // エレメントリサイズポイントクリックチェック
                                if (m_csGraphicsManager.ElementResizePointCheck(csElement, iImageX, iImageY) == true)
                                {// リサイズポイントをクリックの場合
                                    m_bResizeFlg = true;
                                }
                                else
                                {// リサイズポイント以外をクリックの場合
                                    m_bMoveFlg = true;

                                    if (m_bPortFlg != true)
                                    {// 端子以外選択の場合
                                        // 移動処理間引き用操作開始時間設定
                                        m_csPreprocessingTime = DateTime.Now;
                                    }
                                }
                            }
                        }
                    }
                    else    // 指定位置エレメント無
                    {// 指定位置に要素がなかった場合
                        // 全選択解除
                        m_csGraphicsManager.ClearSelectionList();

                        //プロパティ一覧選択状態解除
                        PropertyListSelectionClear(0);

                        // エレメントリサイズポイントクリックチェック
                        csElement = m_csGraphicsManager.ElementResizePointCheck(iImageX, iImageY);
                        if (csElement != null)
                        {// リサイズポイントをクリックの場合
                            m_csSelectElm = csElement;

                            m_bResizeFlg = true;

                            //選択要素を選択中要素リストに追加
                            m_csGraphicsManager.AddSelectionList(csElement);

                            if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP) ||
                                (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                            {// グループ要素の場合
                                TabPage1TabPControl.SelectedIndex = 0;
                            }
                            else if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                                     (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT))
                            {// 入力要素の場合
                                TabPage1TabPControl.SelectedIndex = 1;
                            }
                            else if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                                     (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                            {// 出力要素の場合
                                TabPage1TabPControl.SelectedIndex = 2;
                            }
                            else if (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)
                            {// 通常要素の場合
                                TabPage1TabPControl.SelectedIndex = 0;
                            }
                            else if (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                            {// 接続線の場合
                                TabPage1TabPControl.SelectedIndex = 3;
                            }

                            //編集領域設定
                            m_pReDrawPoint.X = m_pDispPoint.X;
                            m_pReDrawPoint.Y = m_pDispPoint.Y;
                            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                            // グラフィック部編集
                            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                        McDefine.LayerKind.PORT_SELECT |
                                        McDefine.LayerKind.LINE_SELECT,
                                        true,
                                        true);
                        }

                        // 貼り付け位置記憶
                        m_pPastePoint.X = iVirtualX;
                        m_pPastePoint.Y = iVirtualY;

                        // 貼り付け位置フラグセット
                        m_bPastePointFlg = true;
                    }

                    if (m_bMoveFlg == true)
                    {// 要素移動の場合
                        if (m_bPortFlg != true)
                        {// 端子以外選択の場合
                            // 選択要素内で移動対象要素の移動前位置保存
                            m_csHistoryDataWork = new List<object>();
                            List<HySIdentifier> csElmIDList = new List<HySIdentifier>();
                            List<Point> csPointList = new List<Point>();

                            // 移動前座標取得
                            m_csGraphicsManager.MoveObjectPositionGet(ref csElmIDList, ref csPointList);

                            m_csHistoryDataWork.Add(csElmIDList);
                            m_csHistoryDataWork.Add(csPointList);
                            m_csHistoryDataWork.Add(null);
                        }
                        else
                        {// 端子選択の場合
                            // 端子移動前向きおよび移動前位置保存
                            long lX = 0;
                            long lY = 0;
                            m_csHistoryDataWork = new List<object>();
                            List<HySIdentifier> csPortIDList = new List<HySIdentifier>();
                            List<Point> csPointList = new List<Point>();
                            List<double> csAngleList = new List<double>();
                            for (long lLp = 0; lLp < csElement.GetParentElm().GetPortCount(); lLp++)
                            {// 端子数ループ
                                csPortIDList.Add(csElement.GetParentElm().GetPort(lLp).GetID());
                                csElement.GetParentElm().GetPort(lLp).GetPosition(ref lX, ref lY);
                                csPointList.Add(new Point((int)lX, (int)lY));
                                csAngleList.Add(csElement.GetParentElm().GetPort(lLp).GetRotate());
                            }
                            m_csHistoryDataWork.Add(csPortIDList);
                            m_csHistoryDataWork.Add(csAngleList);
                            m_csHistoryDataWork.Add(null);
                            m_csHistoryDataWork.Add(csPointList);
                            m_csHistoryDataWork.Add(null);
                        }
                    }
                    if (m_bResizeFlg == true)
                    {// 要素リサイズの場合
                        // 変更前サイズ保存
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csElement.GetID());
                        long lWidth = 0;
                        long lHeight = 0;
                        long lX = 0;
                        long lY = 0;
                        csElement.GetElementSize(ref lWidth, ref lHeight);
                        m_csSelectElm.GetPosition(ref lX, ref lY);
                        m_csHistoryDataWork.Add(new Point((int)lX, (int)lY));
                        m_csHistoryDataWork.Add(lWidth);
                        m_csHistoryDataWork.Add(lHeight);
                        m_csHistoryDataWork.Add(null);
                        m_csHistoryDataWork.Add(null);
                        m_csHistoryDataWork.Add(null);
                    }

                    m_pFirstClickPoint.X = e.X;     // 座標の設定
                    m_pFirstClickPoint.Y = e.Y;     // 座標の設定
                    m_pMovePoint.X = e.X;           // 座標の設定
                    m_pMovePoint.Y = e.Y;           // 座標の設定
                    m_bMouseDownF = true;

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
                    break;

                case McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL:     // 表示位置スクロールモード
                    this.Cursor = new Cursor(HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_CURSOR_FOLDER")).ToString() + "HMove.cur");
                    m_pFirstClickPoint.X = e.X;     // 座標の設定
                    m_pFirstClickPoint.Y = e.Y;     // 座標の設定
                    m_pMovePoint.X = e.X;           // 座標の設定
                    m_pMovePoint.Y = e.Y;           // 座標の設定
                    m_bMouseDownF = true;

                    // 移動処理間引き用操作開始時間設定
                    m_csPreprocessingTime = DateTime.Now;

                    break;

                default:
                    break;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウス移動イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseMove(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseMove(object sender, MouseEventArgs e)
        {
            Point pPoint = new Point();
            int iWidth = 0;
            int iHeight = 0;

            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                // 選択領域
                if (m_bMouseDownF == true)
                {// マウスボタンクリック中の場合
                    if ((m_bResizeFlg != true) && (m_bMoveFlg != true))
                    {// リサイズおよび移動以外の場合
                        if (e.X < m_pFirstClickPoint.X)
                        {// クリック位置から左へ移動の場合
                            pPoint.X = e.X;
                            iWidth = m_pFirstClickPoint.X - e.X;
                        }
                        else
                        {// クリック位置から右へ移動の場合
                            pPoint.X = m_pFirstClickPoint.X;
                            iWidth = e.X - m_pFirstClickPoint.X;
                        }
                        if (e.Y < m_pFirstClickPoint.Y)
                        {// クリック位置から上へ移動の場合
                            pPoint.Y = e.Y;
                            iHeight = m_pFirstClickPoint.Y - e.Y;
                        }
                        else
                        {// クリック位置から下へ移動の場合
                            pPoint.Y = m_pFirstClickPoint.Y;
                            iHeight = e.Y - m_pFirstClickPoint.Y;
                        }
                        LayerRubberBand.Refresh();

                        // ラバーバンド描画
                        Graphics csGraphics = LayerRubberBand.CreateGraphics();
                        csGraphics.DrawRectangle(Pens.DarkGray, pPoint.X, pPoint.Y, iWidth, iHeight);
                        csGraphics.Dispose();
                    }
                    else
                    {// リサイズまたは移動の場合
                        if (e.X > 0 && e.X < m_iWidth &&
                            e.Y > 0 && e.Y < m_iHeight)
                        {// マウス位置が範囲内の場合
                            if (m_bResizeFlg == true)
                            {// リサイズの場合
                                // リサイズ
                                ResizeImageDisp(e.X, e.Y);
                            }
                            else if (m_bMoveFlg == true)
                            {// 移動の場合
                                if (m_bPortFlg == true)
                                {// 端子選択の場合
                                    int iPointX = m_pDispPoint.X + (m_iWidth * 100 / (int)m_lDispScale) * e.X / m_iWidth;
                                    int iPointY = m_pDispPoint.Y + (m_iHeight * 100 / (int)m_lDispScale) * e.Y / m_iHeight;
                                    if ((iPointX != 0) || (iPointY != 0))
                                    {// マウス位置移動の場合
                                        //端子移動
                                        m_csGraphicsManager.MovePortObject(m_csSelectElm.GetID(), iPointX, iPointY);

                                        m_pMovePoint.X = e.X;
                                        m_pMovePoint.Y = e.Y;

                                        //編集領域設定
                                        m_pReDrawPoint.X = m_pDispPoint.X;
                                        m_pReDrawPoint.Y = m_pDispPoint.Y;
                                        m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                                        m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                                        // グラフィック部編集
                                        LayerReDraw(McDefine.LayerKind.ELEMENT |
                                                    McDefine.LayerKind.PORT |
                                                    McDefine.LayerKind.LINE |
                                                    McDefine.LayerKind.ID |
                                                    McDefine.LayerKind.NAME |
                                                    McDefine.LayerKind.ELEMENT_SELECT |
                                                    McDefine.LayerKind.PORT_SELECT |
                                                    McDefine.LayerKind.LINE_SELECT,
                                                    true,
                                                    true);
                                    }
                                }
                                else
                                {// 端子以外選択の場合
                                    // 移動操作の時間間隔による間引き判定
                                    if (DateTime.Now.CompareTo(m_csPreprocessingTime.AddMilliseconds((double)CULL_TIME)) >= 0)
                                    {// 間引き間隔を過ぎている場合
                                        // 移動処理間引き用操作開始時間再設定
                                        m_csPreprocessingTime = DateTime.Now;

                                        // 移動量算出
                                        iWidth = e.X - m_pMovePoint.X;
                                        iHeight = e.Y - m_pMovePoint.Y;
                                        // 初回移動量チェック
                                        if (m_pFirstClickPoint.X != m_pMovePoint.X || m_pFirstClickPoint.Y != m_pMovePoint.Y)   // 移動開始済？
                                        {// 初期クリック位置から移動している場合
                                            // 移動済
                                            iWidth = (int)(iWidth * 100 / m_lDispScale);
                                            iHeight = (int)(iHeight * 100 / m_lDispScale);
                                            if ((iWidth != 0) || (iHeight != 0))
                                            {// 移動量が０以外の場合
                                                m_csGraphicsManager.MoveObject(iWidth, iHeight);        // 選択要素移動
                                                m_pMovePoint.X = e.X;
                                                m_pMovePoint.Y = e.Y;

                                                //編集領域設定
                                                m_pReDrawPoint.X = m_pDispPoint.X;
                                                m_pReDrawPoint.Y = m_pDispPoint.Y;
                                                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                                                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                                                // グラフィック部編集
                                                LayerReDraw(McDefine.LayerKind.ELEMENT |
                                                            McDefine.LayerKind.PORT |
                                                            McDefine.LayerKind.LINE |
                                                            McDefine.LayerKind.ID |
                                                            McDefine.LayerKind.NAME |
                                                            McDefine.LayerKind.ELEMENT_SELECT |
                                                            McDefine.LayerKind.PORT_SELECT |
                                                            McDefine.LayerKind.LINE_SELECT,
                                                            true,
                                                            true);
                                            }
                                        }
                                        else
                                        {// 初期クリック位置から移動していない場合
                                            // 未移動
                                            if (iWidth > 2 || iWidth < -2 || iHeight > 2 || iHeight < -2)   // 移動か？
                                            {// 移動量が範囲を超えていた場合
                                                iWidth = (int)(iWidth * 100 / m_lDispScale);
                                                iHeight = (int)(iHeight * 100 / m_lDispScale);
                                                if ((iWidth != 0) || (iHeight != 0))
                                                {// 移動量が０以外の場合
                                                    m_csGraphicsManager.MoveObject(iWidth, iHeight);    // 選択要素移動
                                                    m_pMovePoint.X = e.X;
                                                    m_pMovePoint.Y = e.Y;

                                                    //編集領域設定
                                                    m_pReDrawPoint.X = m_pDispPoint.X;
                                                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                                                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                                                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                                                    // グラフィック部編集
                                                    LayerReDraw(McDefine.LayerKind.ELEMENT |
                                                                McDefine.LayerKind.PORT |
                                                                McDefine.LayerKind.LINE |
                                                                McDefine.LayerKind.ID |
                                                                McDefine.LayerKind.NAME |
                                                                McDefine.LayerKind.ELEMENT_SELECT |
                                                                McDefine.LayerKind.PORT_SELECT |
                                                                McDefine.LayerKind.LINE_SELECT,
                                                                true,
                                                                true);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            else if ((m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_CONTINU) ||
                     (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_LINE_CONTINU))
            {// 作画連続モードまたは作画連続モード接続線の場合
                //Shiftキーが押されているかチェック
                if (Control.ModifierKeys != Keys.Shift)
                {// Shiftキーが押されていない場合
                    ButtonSelectInit();                                         // ボタン選択初期化
                    SelectButton.Checked = true;                                // 選択ボタンチェック状態
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード
                    SelectObjectText.Text = "";                                 // 選択描画オブジェクト名クリア
                    m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                    // ボタン活性／非活性設定
                    ButtonEnabledSet();
                }
            }
            else if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
            {// 表示位置スクロールモードの場合
                if (m_bMouseDownF == true)
                {// マウスボタンクリック中の場合
                    // 移動操作の時間間隔による間引き判定
                    if (DateTime.Now.CompareTo(m_csPreprocessingTime.AddMilliseconds((double)CULL_TIME)) >= 0)
                    {// 間引き間隔を過ぎている場合
                        // 移動処理間引き用操作開始時間再設定
                        m_csPreprocessingTime = DateTime.Now;

                        // 移動量算出
                        iWidth = e.X - m_pMovePoint.X;
                        iHeight = e.Y - m_pMovePoint.Y;

                        if ((iWidth != 0) || (iHeight != 0))
                        {// 移動量が０以外の場合
                            LayerMove.Location = new Point(LayerMove.Location.X + iWidth, LayerMove.Location.Y + iHeight);
                        }

                        m_pMovePoint.X = e.X;           // 座標の設定
                        m_pMovePoint.Y = e.Y;           // 座標の設定
                    }
                }
                else
                {// マウスボタンクリック中以外の場合
                    this.Cursor = new Cursor(HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_CURSOR_FOLDER")).ToString() + "HOpen.cur");
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウスアップイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseUp(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseUp(object sender, MouseEventArgs e)
        {
            if ((m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_ADD_ELEMENT) ||
                (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_LINE_FROM_SELECT) ||
                (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_LINE_TO_SELECT))
            {// 作画モード要素追加または作画モード接続線送信側選択または作画モード接続線受信側選択の場合
                // モードチェック
                if (m_eDrawMode != McDefine.DrawModeKind.HYM_DRAW_LINE_FROM_SELECT)
                {// 作画モード接続線送信側選択以外の場合
                    //復元データ編集
                    List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();
                    McHistoryData csHistoryData = new McHistoryData();

                    // モードチェック
                    if (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_ADD_ELEMENT)
                    {// 作画モード要素追加の場合
                        csHistoryData.Kind = McHistoryData.OperationKind.PLACEMENT;
                        m_csHistoryDataWork = new List<object>();
                        List<McGraphicsElement> csElmList = new List<McGraphicsElement>();
                        for (int iLp = 0; iLp < csSelectList.Count; iLp++)
                        {// 選択要素数ループ
                            csElmList.Add(csSelectList[iLp].CopyInfUsedByUndoRedoOnly(null));
                        }
                        m_csHistoryDataWork.Add(csElmList);

                        Point pPoinLeftTop = new Point();
                        Point pPointRightBottom = new Point();
                        if (m_csGraphicsManager.GetDispRect(ref pPoinLeftTop, ref pPointRightBottom) == 0)
                        {   // 表示エレメント有り
                            CheckDispArea(pPoinLeftTop, pPointRightBottom);
                        }

                        ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);
                    }
                    else
                    {// 作画モード要素追加以外の場合
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_CONNECTION;
                    }
                    csHistoryData.HistoryData = m_csHistoryDataWork;

                    //Shiftキーが押されているかチェック
                    if (Control.ModifierKeys == Keys.Shift)
                    {// Shiftキーが押されている場合
                        // モードチェック
                        if (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_ADD_ELEMENT)
                        {// 作画モード要素追加の場合
                            m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW_CONTINU;
                        }
                        else if (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_LINE_TO_SELECT)
                        {// 作画モード要素追加以外の場合
                            m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW_LINE_CONTINU;
                        }
                    }
                    else
                    {// Shiftキーが押されていない場合
                        ButtonSelectInit();                                         // ボタン選択初期化
                        SelectButton.Checked = true;                                // 選択ボタンチェック状態
                        m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード
                        SelectObjectText.Text = "";                                 // 選択描画オブジェクト名クリア
                        m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                        // ボタン活性／非活性設定
                        ButtonEnabledSet();
                    }

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT |
                                McDefine.LayerKind.PORT |
                                McDefine.LayerKind.LINE |
                                McDefine.LayerKind.ID |
                                McDefine.LayerKind.NAME |
                                McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    //復元ポイント記録
                    ReconstructionPointSave(true, csHistoryData);
                    // モデル管理ガイドマップ再描画
                    SimpleMapReDraw();

                    // プロパティ画面リフレッシュ
                    if (TabControl.SelectedIndex == 0)
                    {// 全体系タブ表示中の場合
                        PropetyScreenRefreshment(m_csGraphicsManager.GetStructInfo().GetID());
                    }
                    else
                    {// 全体系タブ以外表示中の場合
                        PropetyScreenRefreshment(m_csDispElmList[TabControl.SelectedIndex][0].GetID());
                    }
                }
                else
                {// 作画モード接続線送信側選択の場合
                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);
                }
            }
            else if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                if (m_bMouseDownF == true)
                {// マウスボタンクリック中の場合
                    if (m_bMoveFlg == true)     // 要素移動
                    {// 移動の場合
                        m_bMoveFlg = false;

                        // 間引きにて処理されないタイミングの救済処置
                        if (m_pFirstClickPoint.X != e.X || m_pFirstClickPoint.Y != e.Y)    // 要素移動有無チェック
                        {// 初期クリック位置と違う場合
                            // 最終移動場所設定
                            int iWidth = (int)((e.X - m_pMovePoint.X) * 100 / m_lDispScale);
                            int iHeight = (int)((e.Y - m_pMovePoint.Y) * 100 / m_lDispScale);
                            m_csGraphicsManager.MoveObject(iWidth, iHeight);        // 選択要素移動

                            //編集領域設定
                            m_pReDrawPoint.X = m_pDispPoint.X;
                            m_pReDrawPoint.Y = m_pDispPoint.Y;
                            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                            // グラフィック部編集
                            LayerReDraw(McDefine.LayerKind.ELEMENT |
                                        McDefine.LayerKind.PORT |
                                        McDefine.LayerKind.LINE |
                                        McDefine.LayerKind.ID |
                                        McDefine.LayerKind.NAME,
                                        true,
                                        true);

                            //復元データ編集
                            McHistoryData csHistoryData = new McHistoryData();
                            if (m_bPortFlg != true)
                            {// 端子以外選択の場合
                                csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                                List<HySIdentifier> csMoveElmIDList = new List<HySIdentifier>();
                                List<Point> csPointList = new List<Point>();

                                // 移動後座標取得
                                m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csPointList);

                                m_csHistoryDataWork[2] = csPointList;

                                Point pLeftTop = new Point();
                                Point pRightBottom = new Point();
                                if (m_csGraphicsManager.GetDispRect(ref pLeftTop, ref pRightBottom) == 0)
                                {   // 表示エレメント有り
                                    CheckDispArea(pLeftTop, pRightBottom);
                                }

                                int iWorkX = m_pDispPoint.X - m_iEditLeft;
                                int iWorkY = m_pDispPoint.Y - m_iEditTop;
                                int iMoveX = 0;
                                int iMoveY = 0;
                                // 編集エリアの上端又は左端が変わる場合は、スクロールを行い
                                // その後要素が上端又は左端に描画されるように再描画する。
                                if ((iWorkX < 0 && iWorkX < -((m_iWidth + 1) / 2)) || (iWorkY < 0 && iWorkY < -((m_iHeight + 1) / 2)))
                                {   // 編集エリア左上が更新される変更あり
                                    if (iWorkX < 0 && iWorkX < -((m_iWidth + 1) / 2))
                                    {   // 編集エリア左が更新される変更あり
                                        iMoveX = m_pDispPoint.X - pLeftTop.X;
                                    }
                                    if (iWorkY < 0 && iWorkY < -((m_iHeight + 1) / 2))
                                    {   // 編集エリア上が更新される変更あり
                                        iMoveY = m_pDispPoint.Y - pLeftTop.Y;
                                    }
                                    iMoveX = iMoveX * (int)m_lDispScale / 100;
                                    iMoveY = iMoveY * (int)m_lDispScale / 100;
                                    DisplayPositionScroll(iMoveX, iMoveY);
                                }

                                ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);
                            }
                            else
                            {// 端子選択の場合
                                //復元データ編集
                                csHistoryData.Kind = McHistoryData.OperationKind.PORT_MOVE;
                                List<Point> csPointList = new List<Point>();
                                List<double> csAngleList = new List<double>();
                                long lX = 0;
                                long lY = 0;
                                for (long lLp = 0; lLp < m_csSelectElm.GetParentElm().GetPortCount(); lLp++)
                                {// 端子数ループ
                                    m_csSelectElm.GetParentElm().GetPort(lLp).GetPosition(ref lX, ref lY);
                                    csPointList.Add(new Point((int)lX, (int)lY));
                                    csAngleList.Add(m_csSelectElm.GetParentElm().GetPort(lLp).GetRotate());
                                }
                                m_csHistoryDataWork[2] = csAngleList;
                                m_csHistoryDataWork[4] = csPointList;
                            }
                            csHistoryData.HistoryData = m_csHistoryDataWork;

                            //復元ポイント記録
                            ReconstructionPointSave(false, csHistoryData);

                            // モデル管理ガイドマップ再描画
                            SimpleMapReDraw();
                        }
                    }
                    else if (m_bResizeFlg == true)  // 要素サイズ変更
                    {// リサイズの場合
                        m_bResizeFlg = false;

                        if (m_pFirstClickPoint.X != e.X || m_pFirstClickPoint.Y != e.Y)    // 要素サイズ変更有無チェック
                        {// 初期クリック位置と違う場合
                            //復元データ編集
                            McHistoryData csHistoryData = new McHistoryData();
                            csHistoryData.Kind = McHistoryData.OperationKind.RESIZE;
                            long lWidth = 0;
                            long lHeight = 0;
                            long lX = 0;
                            long lY = 0;
                            m_csSelectElm.GetElementSize(ref lWidth, ref lHeight);
                            m_csSelectElm.GetPosition(ref lX, ref lY);
                            m_csHistoryDataWork[4] = new Point((int)lX, (int)lY);
                            m_csHistoryDataWork[5] = lWidth;
                            m_csHistoryDataWork[6] = lHeight;
                            csHistoryData.HistoryData = m_csHistoryDataWork;

                            //復元ポイント記録
                            ReconstructionPointSave(false, csHistoryData);

                            // モデル管理ガイドマップ再描画
                            SimpleMapReDraw();
                        }
                    }
                    else
                    {// その他の場合
                        if (m_pFirstClickPoint.X != e.X || m_pFirstClickPoint.Y != e.Y)
                        {// 初期クリック位置と違う場合
                            int iVirtualX1 = (int)((m_pDispPoint.X + m_pFirstClickPoint.X * 100.0 / m_lDispScale) * m_lDispScale / 100.0);
                            int iVirtualY1 = (int)((m_pDispPoint.Y + m_pFirstClickPoint.Y * 100.0 / m_lDispScale) * m_lDispScale / 100.0);
                            int iVirtualX2 = (int)((m_pDispPoint.X + e.X * 100.0 / m_lDispScale) * m_lDispScale / 100.0);
                            int iVirtualY2 = (int)((m_pDispPoint.Y + e.Y * 100.0 / m_lDispScale) * m_lDispScale / 100.0);
                            int iFromX = iVirtualX1;
                            int iFromY = iVirtualY1;
                            int iToX = iVirtualX2;
                            int iToY = iVirtualY2;

                            if (m_pFirstClickPoint.X > e.X)
                            {// 右方向へ移動の場合
                                iFromX = iVirtualX2;
                                iToX = iVirtualX1;
                            }
                            if (m_pFirstClickPoint.Y > e.Y)
                            {// 上方向へ移動の場合
                                iFromY = iVirtualY2;
                                iToY = iVirtualY1;
                            }

                            // 範囲選択
                            m_csGraphicsManager.RangeSelect(iFromX, iFromY, iToX, iToY);

                            if (m_csGraphicsManager.GetSelectionList().Count > 0)
                            {// 選択要素数が０より大きい場合
                                if ((m_csGraphicsManager.GetSelectionList()[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP) ||
                                    (m_csGraphicsManager.GetSelectionList()[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                                {// グループ要素の場合
                                    TabPage1TabPControl.SelectedIndex = 0;
                                }
                                else if ((m_csGraphicsManager.GetSelectionList()[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                                         (m_csGraphicsManager.GetSelectionList()[0].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT))
                                {// 入力要素の場合
                                    TabPage1TabPControl.SelectedIndex = 1;
                                }
                                else if ((m_csGraphicsManager.GetSelectionList()[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                                         (m_csGraphicsManager.GetSelectionList()[0].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                                {// 出力要素の場合
                                    TabPage1TabPControl.SelectedIndex = 2;
                                }
                                else if (m_csGraphicsManager.GetSelectionList()[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)
                                {// 通常要素の場合
                                    TabPage1TabPControl.SelectedIndex = 0;
                                }
                                else if (m_csGraphicsManager.GetSelectionList()[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                                {// 接続線の場合
                                    TabPage1TabPControl.SelectedIndex = 3;
                                }
                            }

                            LayerRubberBand.Refresh();

                            //プロパティリスト選択同期
                            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                            ListSelectionMatching();
                            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
                        }
                    }

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    m_csSelectElm = null;
                    m_pFirstClickPoint.X = 0;
                    m_pFirstClickPoint.Y = 0;
                    m_bMouseDownF = false;
                }

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
            else if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
            {// 表示位置スクロールモードの場合
                // 最終移動場所設定
                int iWidth = e.X - m_pMovePoint.X;
                int iHeight = e.Y - m_pMovePoint.Y;

                if ((iWidth != 0) || (iHeight != 0))
                {// 移動量が０以外の場合
                    LayerMove.Location = new Point(LayerMove.Location.X + iWidth, LayerMove.Location.Y + iHeight);
                }

                // 移動量算出
                iWidth = e.X - m_pFirstClickPoint.X;
                iHeight = e.Y - m_pFirstClickPoint.Y;

                if (m_pDispPoint.X - iWidth * 100 / m_lDispScale < m_iScrollLeft ||
                    m_pDispPoint.X + m_iReDrawWidth - iWidth * 100 / m_lDispScale > m_iScrollRight ||
                    m_pDispPoint.Y - iHeight * 100 / m_lDispScale < m_iScrollTop ||
                    m_pDispPoint.Y + m_iReDrawHeight - iHeight * 100 / m_lDispScale > m_iScrollBottom)
                {   // 表示エリアがスクロールエリアを越える
                    if ((m_pDispPoint.X - iWidth * 100 / m_lDispScale < m_iScrollLeft ||
                    m_pDispPoint.X + m_iReDrawWidth - iWidth * 100 / m_lDispScale > m_iScrollRight) &&
                    (m_pDispPoint.Y - iHeight * 100 / m_lDispScale > m_iScrollTop &&
                    m_pDispPoint.Y + m_iReDrawHeight - iHeight * 100 / m_lDispScale < m_iScrollBottom))
                    {   // 左右方向がスクロールエリアを越える
                        DisplayPositionScroll(0, iHeight);
                    }
                    else if ((m_pDispPoint.X - iWidth * 100 / m_lDispScale > m_iScrollLeft &&
                    m_pDispPoint.X + m_iReDrawWidth - iWidth * 100 / m_lDispScale < m_iScrollRight) &&
                    (m_pDispPoint.Y - iHeight * 100 / m_lDispScale < m_iScrollTop ||
                    m_pDispPoint.Y + m_iReDrawHeight - iHeight * 100 / m_lDispScale > m_iScrollBottom))
                    {   // 上下方向がスクロールエリアを越える
                        DisplayPositionScroll(iWidth, 0);
                    }
                    else
                    {   // 上下左右方向がスクロールエリアを越える
                        DisplayPositionScroll(0, 0);
                    }
                }
                else
                {
                    if ((iWidth != 0) || (iHeight != 0))
                    {// 移動量が０以外の場合
                        //表示位置スクロール
                        DisplayPositionScroll(iWidth, iHeight);
                    }
                }

                if ((m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale) != 0)
                {   // 縦スクロールスペースがない
                    m_iVScroll = (m_pDispPoint.Y - m_iScrollTop) * (VScrollBar.Maximum - VScrollBar.LargeChange) / (m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale);
                    VScrollBar.Value = m_iVScroll;
                }
                if ((m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale) != 0)
                {   // 横スクロールスペースがない
                    m_iHScroll = (m_pDispPoint.X - m_iScrollLeft) * (HScrollBar.Maximum - HScrollBar.LargeChange) / (m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale);
                    HScrollBar.Value = m_iHScroll;
                }

                this.Cursor = new Cursor(HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_CURSOR_FOLDER")).ToString() + "HOpen.cur");
                m_pFirstClickPoint.X = 0;
                m_pFirstClickPoint.Y = 0;
                m_pMovePoint.X = 0;
                m_pMovePoint.Y = 0;
                m_bMouseDownF = false;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示設定変更(ID)</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispKindChangeID(bDispKindID)</para>
        /// </example>
        /// <param name="bDispKindID">表示設定(ID)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DispKindChangeID(bool bDispKindID)
        {
            m_bDispKindID = bDispKindID;
            if (bDispKindID == true)
            {// ID表示の場合
                if (LayerID.Visible == false)
                {// IDレイヤー非表示の場合
                    LayerID.Visible = true;

                    LayerElementSelect.Parent = LayerID;
                    if (LayerName.Visible == true)
                    {// 名称レイヤー表示の場合
                        LayerID.Parent = LayerName;
                    }
                    else
                    {// 名称レイヤー非表示の場合
                        LayerID.Parent = LayerPort;
                    }

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ID, true, true);
                }
            }
            else
            {// ID非表示の場合
                if (LayerID.Visible == true)
                {// IDレイヤー表示の場合
                    if (LayerName.Visible == true)
                    {// 名称レイヤー表示の場合
                        LayerElementSelect.Parent = LayerName;
                    }
                    else
                    {// 名称レイヤー非表示の場合
                        LayerElementSelect.Parent = LayerPort;
                    }

                    LayerID.Visible = false;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示設定変更(名称)</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispKindChangeName(bDispKindName)</para>
        /// </example>
        /// <param name="bDispKindName">表示設定(名称)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DispKindChangeName(bool bDispKindName)
        {
            m_bDispKindName = bDispKindName;
            if (bDispKindName == true)
            {// 名称表示の場合
                if (LayerName.Visible == false)
                {// 名称レイヤー非表示の場合
                    LayerName.Visible = true;

                    LayerName.Parent = LayerPort;
                    if (LayerID.Visible == true)
                    {// IDレイヤー表示の場合
                        LayerID.Parent = LayerName;
                    }
                    else
                    {// IDレイヤー非表示の場合
                        LayerElementSelect.Parent = LayerName;
                    }

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.NAME, true, true);
                }
            }
            else
            {// 名称非表示の場合
                if (LayerName.Visible == true)
                {// 名称レイヤー表示の場合
                    if (LayerID.Visible == true)
                    {// IDレイヤー表示の場合
                        LayerID.Parent = LayerPort;
                    }
                    else
                    {// IDレイヤー非表示の場合
                        LayerElementSelect.Parent = LayerPort;
                    }

                    LayerName.Visible = false;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素モデル設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ElementModelSet(csElementModelData)</para>
        /// </example>
        /// <param name="csElementModelData">要素モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ElementModelSet(McModelInfo csElementModelData)
        {
            List<HySIdentifier> csElmIDList = new List<HySIdentifier>();
            List<McModelInfo> csModelList = new List<McModelInfo>();
            //m_csGraphicsManager.SetElementModel(csElementModelData, ref csElmIDList, ref csModelList);
            List<List<HySIdentifier>> csElmIDListList = new List<List<HySIdentifier>>();
            List<List<McModelInfo>> csTranListList = new List<List<McModelInfo>>();
            List<List<McModelInfo>> csModTranListList = new List<List<McModelInfo>>();
            m_csGraphicsManager.SetElementModel(csElementModelData, ref csElmIDList, ref csModelList, ref csElmIDListList, ref csTranListList, ref csModTranListList);

            // プロパティ画面クローズ
            PropetyScreenClose();

            // プロパティ画面リフレッシュ
            PropetyScreenRefreshment(null);

            // リスト部編集
            PropertyListEdit(1, false);
            PropertyListEdit(4, false);

            // 選択状態同期
            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
            ListSelectionMatching();
            m_eDrawMode = eTempDrawMode;

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.MODEL_SET_ELEMENT;
            m_csHistoryDataWork = new List<object>();
            m_csHistoryDataWork.Add(csElmIDList);
            m_csHistoryDataWork.Add(csModelList);
            m_csHistoryDataWork.Add(csElementModelData);
            m_csHistoryDataWork.Add(csElmIDListList);
            m_csHistoryDataWork.Add(csTranListList);
            m_csHistoryDataWork.Add(csModTranListList);
            csHistoryData.HistoryData = m_csHistoryDataWork;

            //復元ポイント記録
            ReconstructionPointSave(true, csHistoryData);

            // モデル管理ガイドマップ再描画
            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力データ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>InputDataSet(csElementModelData)</para>
        /// </example>
        /// <param name="csElementModelData">要素モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void InputDataSet(McModelInfo csElementModelData)
        {
            List<HySIdentifier> csElmIDList = new List<HySIdentifier>();
            List<McModelInfo> csModelList = new List<McModelInfo>();
            //m_csGraphicsManager.SetInputData(csElementModelData, ref csElmIDList, ref csModelList);
            List<List<HySIdentifier>> csElmIDListList = new List<List<HySIdentifier>>();
            List<List<McModelInfo>> csTranListList = new List<List<McModelInfo>>();
            List<List<McModelInfo>> csModTranListList = new List<List<McModelInfo>>();
            m_csGraphicsManager.SetInputData(csElementModelData, ref csElmIDList, ref csModelList, ref csElmIDListList, ref csTranListList, ref csModTranListList);

            // プロパティ画面クローズ
            PropetyScreenClose();

            // プロパティ画面リフレッシュ
            PropetyScreenRefreshment(null);

            // リスト部編集
            PropertyListEdit(1, false);
            PropertyListEdit(2, false);
            PropertyListEdit(4, false);

            // 選択状態同期
            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
            ListSelectionMatching();
            m_eDrawMode = eTempDrawMode;

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.MODEL_SET_INPUT;
            m_csHistoryDataWork = new List<object>();
            m_csHistoryDataWork.Add(csElmIDList);
            m_csHistoryDataWork.Add(csModelList);
            m_csHistoryDataWork.Add(csElementModelData);
            m_csHistoryDataWork.Add(csElmIDListList);
            m_csHistoryDataWork.Add(csTranListList);
            m_csHistoryDataWork.Add(csModTranListList);
            csHistoryData.HistoryData = m_csHistoryDataWork;

            //復元ポイント記録
            ReconstructionPointSave(true, csHistoryData);

            // モデル管理ガイドマップ再描画
            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力データ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OutputDataSet(csElementModelData)</para>
        /// </example>
        /// <param name="csElementModelData">要素モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void OutputDataSet(McModelInfo csElementModelData)
        {
            List<HySIdentifier> csElmIDList = new List<HySIdentifier>();
            List<McModelInfo> csModelList = new List<McModelInfo>();
            //m_csGraphicsManager.SetOutputData(csElementModelData, ref csElmIDList, ref csModelList);
            List<List<HySIdentifier>> csElmIDListList = new List<List<HySIdentifier>>();
            List<List<McModelInfo>> csTranListList = new List<List<McModelInfo>>();
            List<List<McModelInfo>> csModTranListList = new List<List<McModelInfo>>();
            m_csGraphicsManager.SetOutputData(csElementModelData, ref csElmIDList, ref csModelList, ref csElmIDListList, ref csTranListList, ref csModTranListList);

            List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();
            for (int iLp = 0; iLp < csSelectList.Count; iLp++)
            {// 選択要素数ループ
                if ((csSelectList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)&&
                    (csSelectList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                {// 出力要素の場合
                    // グラフ画面クローズ
                    ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenCloseEvent(csSelectList[iLp].GetID());
                }
            }

            // プロパティ画面クローズ
            PropetyScreenClose();

            // プロパティ画面リフレッシュ
            PropetyScreenRefreshment(null);

            // リスト部編集
            PropertyListEdit(1, false);
            PropertyListEdit(3, false);
            PropertyListEdit(4, false);

            // 選択状態同期
            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
            ListSelectionMatching();
            m_eDrawMode = eTempDrawMode;

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.NAME |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.MODEL_SET_OUTPUT;
            m_csHistoryDataWork = new List<object>();
            m_csHistoryDataWork.Add(csElmIDList);
            m_csHistoryDataWork.Add(csModelList);
            m_csHistoryDataWork.Add(csElementModelData);
            m_csHistoryDataWork.Add(csElmIDListList);
            m_csHistoryDataWork.Add(csTranListList);
            m_csHistoryDataWork.Add(csModTranListList);
            csHistoryData.HistoryData = m_csHistoryDataWork;

            //復元ポイント記録
            ReconstructionPointSave(true, csHistoryData);

            // モデル管理ガイドマップ再描画
            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送情報型設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TransInfoTypeSet(csElementModelData)</para>
        /// </example>
        /// <param name="csElementModelData">要素モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void TransInfoTypeSet(McModelInfo csElementModelData)
        {
            List<HySIdentifier> csElmIDList = new List<HySIdentifier>();
            List<McModelInfo> csModelList = new List<McModelInfo>();
            List<McModelInfo> csModModelList = new List<McModelInfo>();
            m_csGraphicsManager.SetTransInfoType(csElementModelData, ref csElmIDList, ref csModelList, ref csModModelList);

            // プロパティ画面クローズ
            PropetyScreenClose();

            // プロパティ画面リフレッシュ
            PropetyScreenRefreshment(null);

            // リスト部編集
            PropertyListEdit(4, false);

            // 選択状態同期
            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
            ListSelectionMatching();
            m_eDrawMode = eTempDrawMode;

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.LINE |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.MODEL_SET_TRANS;
            m_csHistoryDataWork = new List<object>();
            m_csHistoryDataWork.Add(csElmIDList);
            m_csHistoryDataWork.Add(csModelList);
            //m_csHistoryDataWork.Add(csElementModelData);
            m_csHistoryDataWork.Add(csModModelList);
            csHistoryData.HistoryData = m_csHistoryDataWork;

            //復元ポイント記録
            ReconstructionPointSave(true, csHistoryData);

            // モデル管理ガイドマップ再描画
            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ設定情報解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LibraryDataCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LibraryDataCancel()
        {
            List<HySIdentifier> csElmIDList = new List<HySIdentifier>();
            List<McModelInfo> csModelList = new List<McModelInfo>();
            m_csGraphicsManager.CancelLibraryData(ref csElmIDList, ref csModelList);

            // グラフ画面クローズ
            LineGraphScreenClose();

            // プロパティ画面クローズ
            PropetyScreenClose();

            // プロパティ画面リフレッシュ
            PropetyScreenRefreshment(null);

            // リスト部編集
            PropertyListEdit(0, false);

            // 選択状態同期
            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
            ListSelectionMatching();
            m_eDrawMode = eTempDrawMode;

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.LINE |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.MODEL_CANCEL;
            m_csHistoryDataWork = new List<object>();
            m_csHistoryDataWork.Add(csElmIDList);
            m_csHistoryDataWork.Add(csModelList);
            csHistoryData.HistoryData = m_csHistoryDataWork;

            //復元ポイント記録
            ReconstructionPointSave(true, csHistoryData);

            // モデル管理ガイドマップ再描画
            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formアクティブ化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Form.Activate();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public void ActiveModelForm()
        {
            this.Activate();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルチェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelCheck()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:異常無し　false:異常有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ModelCheck()
        {
            bool bError = false;
            bool bWarning = false;

            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            TabPage1DataGridView5.Rows.Clear();

            m_csStructCheckData = ((McDotNetModelCtlScreen)m_csScreen).GetCheckData();
            DelStructCheckData();

            //エレメントリスト取得
            List<McGraphicsElement> csElmList = m_csDispElmList[0];
            List<McGraphicsElement> csLineList = m_csDispLineList;

            McDefine.SymbolDrawKind eDrawKind;

            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                eDrawKind = csElmList[iLp].GetSymbolDrawKind();

                if (eDrawKind == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)
                {// 要素の場合
                    if (ModelCheckElementModel(csElmList[iLp]) == true)
                    {// モデルチェックで異常の場合
                        bError = true;
                    }
                    continue;
                }
                if ((eDrawKind == McDefine.SymbolDrawKind.HYM_GROUP) ||
                    (eDrawKind == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                {// グループ要素の場合
                    if (ModelCheckElementModel(csElmList[iLp]) == true)
                    {// モデルチェックで異常の場合
                        bError = true;
                    }
                    for (int iLp2 = 0; iLp2 < csElmList[iLp].GetPortCount(); iLp2++)
                    {// 端子数ループ
                        //中継端子チェック
                        if (ModelCheckRelayPort(csElmList[iLp].GetPort(iLp2)) == true)
                        {// モデルチェックで異常の場合
                            bWarning = true;
                        }
                    }

                    //グループメンバのチェック
                    ModelCheckGroup(csElmList[iLp], ref bWarning, ref bError);

                    continue;
                }
            }
            for (int iLp = 0; iLp < csLineList.Count; iLp++)
            {// 接続線数ループ
                if (ModelCheckLineModel(csLineList[iLp]) == true)
                {// モデルチェックで異常の場合
                    bError = true;
                }
            }

            TabPage1DataGridView5.ClearSelection();

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            bool bRtn = true;
            if (bError == true)
            {// 異常がある場合
                bRtn = false;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルチェック(グループ要素)</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelCheckGroup(csGroupElment, bWarning, bError)</para>
        /// </example>
        /// <param name="csGroupElment">グループ要素</param>
        /// <param name="bWarning">ワーニング有無</param>
        /// <param name="bError">エラー有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ModelCheckGroup(McGraphicsElement csGroupElment, ref bool bWarning, ref bool bError)
        {
            //エレメントリスト取得
            List<McGraphicsElement> csElmList = ((McGraphicsGroupElement)csGroupElment).GetGroupElementList();
            List<McGraphicsElement> csLineList = ((McGraphicsGroupElement)csGroupElment).GetGroupLineElementList();

            McDefine.SymbolDrawKind eDrawKind;

            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                eDrawKind = csElmList[iLp].GetSymbolDrawKind();

                if (eDrawKind == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)
                {// 要素の場合
                    if (ModelCheckElementModel(csElmList[iLp]) == true)
                    {// モデルチェックで異常の場合
                        bError = true;
                    }
                    continue;
                }
                if ((eDrawKind == McDefine.SymbolDrawKind.HYM_GROUP) ||
                    (eDrawKind == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                {// グループ要素の場合
                    if (ModelCheckElementModel(csElmList[iLp]) == true)
                    {// モデルチェックで異常の場合
                        bError = true;
                    }
                    for (int iLp2 = 0; iLp2 < csElmList[iLp].GetPortCount(); iLp2++)
                    {// 端子数ループ
                        //中継端子チェック
                        if (ModelCheckRelayPort(csElmList[iLp].GetPort(iLp2)) == true)
                        {// モデルチェックで異常の場合
                            bWarning = true;
                        }
                    }

                    //グループメンバのチェック
                    ModelCheckGroup(csElmList[iLp], ref bWarning, ref bError);

                    continue;
                }
            }
            for (int iLp = 0; iLp < csLineList.Count; iLp++)
            {// 接続線数ループ
                if (ModelCheckLineModel(csLineList[iLp]) == true)
                {// モデルチェックで異常の場合
                    bError = true;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルチェック（中継端子接続状態チェック）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelCheckRelayPort(csElement)</para>
        /// </example>
        /// <param name="csElement">チェック要素</param>
        /// <returns>bool　true:異常有り　false:異常無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ModelCheckRelayPort(McGraphicsElement csElement)
        {
            bool bRtn = false;
			string strMessage = string.Format(MSG_CHECK_RELAY_TERMINAL, csElement.GetID().ToString());
			HySString sMessage=new HySString(strMessage);

            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            ((McGraphicsTransElement)csElement).GetPortID(ref csFromID, ref csToID);
            if ((csFromID.ToString() == "") || (csToID.ToString() == ""))
            {// 接続情報がない場合
                TabPage1DataGridView5.Rows.Add();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column50.Name].Value = csElement.GetParentElm().GetID().ToString();
                if (csElement.GetParentElm().GetID().ToString().IndexOf('-') != -1)
                {// 分割出来る場合
                    TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetParentElm().GetID().ToString().Substring(0, csElement.GetParentElm().GetID().ToString().IndexOf('-'));
                }
                else
                {// 分割出来ない場合
                    if (csElement.GetParentElm().GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                    {// IDの長さが既定値以下の場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetParentElm().GetID().ToString();
                    }
                    else
                    {// IDの長さが既定値より大きい場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetParentElm().GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                    }
                }
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column52.Name].Value = sMessage.ToString();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].DefaultCellStyle.ForeColor = Color.DarkOrange;

                m_csStructCheckData.AddCheckData(csElement.GetID(), csElement.GetSymbolDrawKind(), McDefine.MessageLevel.HYM_MODELCHECK_WARNING, sMessage);

                bRtn = true;
            }

            ((McGraphicsTransElement)csElement).GetTransID(ref csFromID, ref csToID);
            if ((csFromID.ToString() == "") || (csToID.ToString() == ""))
            {// 接続情報がない場合
                TabPage1DataGridView5.Rows.Add();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column50.Name].Value = csElement.GetParentElm().GetID().ToString();
                if (csElement.GetParentElm().GetID().ToString().IndexOf('-') != -1)
                {// 分割出来る場合
                    TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetParentElm().GetID().ToString().Substring(0, csElement.GetParentElm().GetID().ToString().IndexOf('-'));
                }
                else
                {// 分割出来ない場合
                    if (csElement.GetParentElm().GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                    {// IDの長さが既定値以下の場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetParentElm().GetID().ToString();
                    }
                    else
                    {// IDの長さが既定値より大きい場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetParentElm().GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                    }
                }
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column52.Name].Value = sMessage.ToString();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].DefaultCellStyle.ForeColor = Color.DarkOrange;

                m_csStructCheckData.AddCheckData(csElement.GetID(), csElement.GetSymbolDrawKind(), McDefine.MessageLevel.HYM_MODELCHECK_WARNING, sMessage);

                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルチェック（要素モデル設定チェック）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelCheckElementModel(csElement)</para>
        /// </example>
        /// <param name="csElement">チェック要素</param>
        /// <returns>bool　true:異常有り　false:異常無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ModelCheckElementModel(McGraphicsElement csElement)
        {
            bool bRtn = false;
            HySString sMessage = null;

            if (csElement.GetModelInfo().GetLibraryID().ToString() == "")
            {// モデルの設定がない場合
                if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) ||
                    (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP) ||
                    (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                {// 要素またはグループ要素の場合
                    if (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT)
                    {// 入力要素の場合
						sMessage = new HySString(MSG_CHECK_INPUT);
                    }
                    else if (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT)
                    {// 出力要素の場合
						sMessage = new HySString(MSG_CHECK_OUTPUT);
                    }
                    else
                    {// その他の場合
						sMessage = new HySString(MSG_CHECK_OPERATION_MODEL);
                    }
                }
                TabPage1DataGridView5.Rows.Add();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column50.Name].Value = csElement.GetID().ToString();
                if (csElement.GetID().ToString().IndexOf('-') != -1)
                {// 分割出来る場合
                    TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetID().ToString().Substring(0, csElement.GetID().ToString().IndexOf('-'));
                }
                else
                {// 分割出来ない場合
                    if (csElement.GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                    {// IDの長さが既定値以下の場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetID().ToString();
                    }
                    else
                    {// IDの長さが既定値より大きい場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csElement.GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                    }
                }
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column52.Name].Value = sMessage.ToString();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].DefaultCellStyle.ForeColor = Color.Red;

                m_csStructCheckData.AddCheckData(csElement.GetID(), csElement.GetSymbolDrawKind(), McDefine.MessageLevel.HYM_MODELCHECK_ERROR, sMessage);

                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルチェック（伝送情報型種別設定チェック）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelCheckLineModel(csLineElement)</para>
        /// </example>
        /// <param name="csLineElement">チェック要素</param>
        /// <returns>bool　true:異常有り　false:異常無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ModelCheckLineModel(McGraphicsElement csLineElement)
        {
            bool bRtn = false;
			HySString sMessage = new HySString(MSG_CHECK_CHANNEL);

            if (csLineElement.GetModelInfo().GetLibraryID().ToString() == "")
            {// モデルの設定がない場合
                TabPage1DataGridView5.Rows.Add();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column50.Name].Value = csLineElement.GetID().ToString();
                if (csLineElement.GetID().ToString().IndexOf('-') != -1)
                {// 分割出来る場合
                    TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csLineElement.GetID().ToString().Substring(0, csLineElement.GetID().ToString().IndexOf('-'));
                }
                else
                {// 分割出来ない場合
                    if (csLineElement.GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                    {// IDの長さが既定値以下の場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csLineElement.GetID().ToString();
                    }
                    else
                    {// IDの長さが既定値より大きい場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = csLineElement.GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                    }
                }
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column52.Name].Value = sMessage.ToString();
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].DefaultCellStyle.ForeColor = Color.Red;

                m_csStructCheckData.AddCheckData(csLineElement.GetID(), csLineElement.GetSymbolDrawKind(), McDefine.MessageLevel.HYM_MODELCHECK_ERROR, sMessage);

                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>左90度回転</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Left90degRotation(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Left90degRotation(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                m_eDrawMode = McDefine.DrawModeKind.HYM_ROTATE;             // 回転モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                List<HySIdentifier> csElmIDList = new List<HySIdentifier>();

                // 要素回転
                m_csGraphicsManager.ElementRotate(McDefine.HYM_DRAW_ANGLE_M90, ref csElmIDList);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.ROTATION;
                m_csHistoryDataWork = new List<object>();
                m_csHistoryDataWork.Add(csElmIDList);
                m_csHistoryDataWork.Add(McDefine.HYM_DRAW_ANGLE_M90);
                csHistoryData.HistoryData = m_csHistoryDataWork;

                //復元ポイント記録
                ReconstructionPointSave(false, csHistoryData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>右90度回転</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Right90degRotation(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Right90degRotation(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                m_eDrawMode = McDefine.DrawModeKind.HYM_ROTATE;             // 回転モード
                m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

                List<HySIdentifier> csElmIDList = new List<HySIdentifier>();

                // 要素回転
                m_csGraphicsManager.ElementRotate(McDefine.HYM_DRAW_ANGLE_90, ref csElmIDList);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.ROTATION;
                m_csHistoryDataWork = new List<object>();
                m_csHistoryDataWork.Add(csElmIDList);
                m_csHistoryDataWork.Add(McDefine.HYM_DRAW_ANGLE_90);
                csHistoryData.HistoryData = m_csHistoryDataWork;

                //復元ポイント記録
                ReconstructionPointSave(false, csHistoryData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>パラメータ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParameterSet(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParameterSet(object sender, EventArgs e)
        {
            //選択中要素リスト取得
            List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();

            for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
            {// 選択要素数ループ
                if (csSelectionList[iLp].GetModelInfo().GetLibraryID().ToString() != "")
                {// モデルの設定がある場合
                    McGraphicsElement csElement = csSelectionList[iLp];

                    //選択中要素リストクリア
                    m_csGraphicsManager.ClearSelectionList();

                    //選択中要素リスト追加
                    m_csGraphicsManager.AddSelectionList(csElement);

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    ((McDotNetModelCtlScreen)m_csScreen).ShowModelPropertyScreen(csElement);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グループパラメータ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GroupParameterSet(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GroupParameterSet(object sender, EventArgs e)
        {
            if (TabControl.SelectedIndex == 0)
            {// 全体系タブ表示中の場合
                // プロジェクトパラメータ設定
                ((McDotNetModelCtlScreen)m_csScreen).ShowModelPropertyScreen(m_csGraphicsManager.GetStructInfo());
            }
            else
            {// 全体系タブ以外表示中の場合
                if (m_csDispElmList[TabControl.SelectedIndex][0].GetModelInfo().GetLibraryID().ToString() != "")
                {// モデルの設定がある場合
                    // グループパラメータ設定
                    ((McDotNetModelCtlScreen)m_csScreen).ShowModelPropertyScreen(m_csDispElmList[TabControl.SelectedIndex][0]);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>パラメータ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParameterSetList(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParameterSetList(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex < 0)
            {// 選択行が無効な場合
                return;
            }

            DataGridView[] csGV = { TabPage1DataGridView1, TabPage1DataGridView2, TabPage1DataGridView3, TabPage1DataGridView4 };

            HySString csID = new HySString(csGV[TabPage1TabPControl.SelectedIndex].Rows[e.RowIndex].Cells[0].Value.ToString());

            ParameterSetDialog(csID);

            if ((TabPage1TabPControl.SelectedIndex == 2) && (e.ColumnIndex == 4))
            {// 出力要素リストで画面表示カラムをクリックの場合
                if (TabPage1DataGridView3.Rows[e.RowIndex].Cells[e.ColumnIndex].ReadOnly == false)
                {// クリック行が有効の場合
                    // リスト部編集
                    PropertyListEdit(3, false);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>パラメータ設定ダイアログ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParameterSetDialog(csElementId)</para>
        /// </example>
        /// <param name="csElementId">設定要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParameterSetDialog(HySString csElementId)
        {
            //エレメントリスト取得
            List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();
            //ラインリスト取得
            List<McGraphicsElement> csLineList = m_csGraphicsManager.GetLineList();

            McGraphicsElement csElement = null;

            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if ((HySString)csElmList[iLp].GetID().GetString() == csElementId)
                {// IDが一致した場合
                    csElement = csElmList[iLp];
                    break;
                }
            }
            for (int iLp = 0; (iLp < csLineList.Count) && (csElement == null); iLp++)
            {// 接続線数ループ
                if ((HySString)csLineList[iLp].GetID().GetString() == csElementId)
                {// IDが一致した場合
                    csElement = csLineList[iLp];
                    break;
                }
            }

            if (csElement != null)
            {// 対象要素があった場合
                ((McDotNetModelCtlScreen)m_csScreen).ShowModelPropertyScreen(csElement);
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>メニューからのライブラリ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LibrarySet(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LibrarySet(object sender, EventArgs e)
        {
            ((McDotNetModelCtlScreen)m_csScreen).PutEventRequestSet();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>メニューからのライブラリ設定解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LibraryCancel(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LibraryCancel(object sender, EventArgs e)
        {
            // ライブラリ設定情報解除
            LibraryDataCancel();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>ポップアップメニュー制御</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ContextMenu_Opening( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ContextMenu_Opening(object sender, CancelEventArgs e)
        {
            ActiveModelForm();

            //選択中要素リスト取得
            List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();

            //選択中要素別カウンター取得
            int[] iElementCounter = m_csGraphicsManager.GetSelectionCount();

            if (((ContextMenuStrip)sender).Name == "contextMenuStrip1")
            {// グラフィック部用メニューの場合
                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
                {// 選択モードの場合
                    this.CutMenuItem.Enabled = false;
                    this.CopyMenuItem.Enabled = false;
                    // クリップボード保存チェック
                    if (m_bClipBoardFlg == true)
                    {// クリップボード有効の場合
                        this.PasteMenuItem.Enabled = true;
                    }
                    else
                    {// クリップボード無効の場合
                        this.PasteMenuItem.Enabled = false;
                    }
                    this.DeleteMenuItem.Enabled = false;
                    this.RotationMenuItem.Enabled = false;
                    this.Left90degRotationMenuItem.Enabled = false;
                    this.Right90degRotationMenuItem.Enabled = false;
                    this.OrderMenuItem.Enabled = false;
                    this.TopMenuItem.Enabled = false;
                    this.BottomMenuItem.Enabled = false;
                    this.GroupingMenuItem.Enabled = false;
                    this.PartGrMenuItem.Enabled = false;
                    this.CalcGrMenuItem.Enabled = false;
                    this.GrCancelMenuItem.Enabled = false;
                    this.LibraryMenuItem.Enabled = false;
                    this.LibrarySetMenuItem.Enabled = false;
                    this.LibraryCancelMenuItem.Enabled = false;
                    this.ParameterSetMenuItem.Enabled = false;
                    this.InternalDispOpenMenuItem.Enabled = false;
                    // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                    this.InternalDispMenuItemOpen.Enabled = false;
                    // グループ表示タブ数チェック
                    if (m_iTabCount > 1)
                    {// グループ内部表示タブ数が１より大きい場合
                        this.InternalDispMenuItem.Enabled = true;
                        this.InternalDispCloseMenuItem.Enabled = true;
                        // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                        this.InternalDispMenuItemClose.Enabled = true;
                    }
                    else
                    {// グループ内部表示タブ数が１以下場合
                        this.InternalDispMenuItem.Enabled = false;
                        this.InternalDispCloseMenuItem.Enabled = false;
                        // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                        this.InternalDispMenuItemClose.Enabled = false;
                    }
                    this.PopUpSeparator3.Visible = false;//[2011/01/17]セパレータ3非表示化
                    this.ScreenDispMenuItem.Enabled = true;
                    this.ScreenDispMenuItem.Visible = false;//[2011/01/17]計算結果表示非表示化
                    this.ExternalConnectionMenuItem.Enabled = false;
                    this.ConnectSendMenuItem.Enabled = false;
                    this.ConnectRecvMenuItem.Enabled = false;
                    this.GeneralEvaluationMenuItem.Enabled = false;
                    this.GeneralEvaluationMenuItem.Visible = false;//[2011/01/17]汎用評価画面非表示化
                    this.BasicScreenMenuItem.Enabled = false;
                    this.BasicScreenMenuItem.Visible = false;//
                    this.SpecificalEvaluationMenuItem.Enabled = false;
                    this.SpecificalEvaluationMenuItem.Visible = false;//[2011/01/17]特定評価画面非表示化
                    this.HydroHyetoMenuItem.Enabled = false;
                    this.HydroHyetoMenuItem.Visible = false;
                    this.RiverProfileMenuItem.Enabled = false;
                    this.RiverProfileMenuItem.Visible = false;
                    this.LibrarySetTopMenuItem.Enabled = false;
                    // ライブラリメニュー項目編集数チェック
                    if (this.LibrarySetTopMenuItem.DropDownItems.Count == 4)
                    {// ライブラリメニュー項目編集数が４の場合
                        this.LibrarySetTopMenuItem.DropDownItems[0].Visible = false;
                        this.LibrarySetTopMenuItem.DropDownItems[1].Visible = false;
                        this.LibrarySetTopMenuItem.DropDownItems[2].Visible = false;
                        this.LibrarySetTopMenuItem.DropDownItems[3].Visible = false;
                    }
                    this.LibraryReSetTopMenuItem.Enabled = false;

                    // 選択要素数チェック
                    if (iElementCounter[0] > 0)
                    {// 選択要素数が０より大きい場合
                        this.CutMenuItem.Enabled = true;
                        this.CopyMenuItem.Enabled = true;
                        this.DeleteMenuItem.Enabled = true;
                        this.RotationMenuItem.Enabled = true;
                        this.Left90degRotationMenuItem.Enabled = true;
                        this.Right90degRotationMenuItem.Enabled = true;
                        this.OrderMenuItem.Enabled = true;
                        this.TopMenuItem.Enabled = true;
                        this.BottomMenuItem.Enabled = true;
                        this.GroupingMenuItem.Enabled = true;
                        this.PartGrMenuItem.Enabled = true;
                        this.CalcGrMenuItem.Enabled = true;
                        if ((iElementCounter[0] == 1) && (iElementCounter[1] == 0) && (TabControl.SelectedIndex != 0))
                        {// 選択要素数が１で選択グループ要素数が０でグループ内部表示タブ表示の場合
                            this.ExternalConnectionMenuItem.Enabled = true;
                            this.ConnectSendMenuItem.Enabled = true;
                            this.ConnectRecvMenuItem.Enabled = true;
                        }
                        this.GeneralEvaluationMenuItem.Enabled = true;
                        this.BasicScreenMenuItem.Enabled = true;
                        this.SpecificalEvaluationMenuItem.Enabled = true;
                        this.HydroHyetoMenuItem.Enabled = true;
                        this.RiverProfileMenuItem.Enabled = true;
                    }
                    // 選択グループ数チェック
                    if (iElementCounter[1] > 0)
                    {// 選択グループ要素数が０より大きい場合
                        this.CutMenuItem.Enabled = true;
                        this.CopyMenuItem.Enabled = true;
                        this.DeleteMenuItem.Enabled = true;
                        this.RotationMenuItem.Enabled = true;
                        this.Left90degRotationMenuItem.Enabled = true;
                        this.Right90degRotationMenuItem.Enabled = true;
                        this.OrderMenuItem.Enabled = true;
                        this.TopMenuItem.Enabled = true;
                        this.BottomMenuItem.Enabled = true;
                        this.GroupingMenuItem.Enabled = true;
                        this.PartGrMenuItem.Enabled = true;
                        this.CalcGrMenuItem.Enabled = true;
                        if (iElementCounter[1] == 1)
                        {// 選択グループ要素数が１の場合
                            this.GrCancelMenuItem.Enabled = true;
                        }
                        if ((iElementCounter[1] == 1) && (iElementCounter[0] == 0) && (TabControl.SelectedIndex != 0))
                        {// 選択要素数が１で選択グループ要素数が０でグループ内部表示タブ表示の場合
                            this.ExternalConnectionMenuItem.Enabled = true;
                            this.ConnectSendMenuItem.Enabled = true;
                            this.ConnectRecvMenuItem.Enabled = true;
                        }
                        this.InternalDispMenuItem.Enabled = true;
                        this.InternalDispOpenMenuItem.Enabled = true;
                        // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                        this.InternalDispMenuItemOpen.Enabled = true;
                    }
                    // 選択中継端子数チェック
                    if (iElementCounter[3] > 0)
                    {// 選択中継端子数が０より大きい場合
                        this.DeleteMenuItem.Enabled = true;
                    }
                    // 選択接続線数チェック
                    if (iElementCounter[4] > 0)
                    {// 選択接続線数が０より大きい場合
                        this.DeleteMenuItem.Enabled = true;
                    }
                    if ((iElementCounter[0] > 0) || (iElementCounter[1] > 0) || (iElementCounter[4] > 0))
                    {// 選択要素数が０より大きいまたは選択グループ要素数が０より大きいまたは選択接続線数が０より大きい場合
                        this.LibraryMenuItem.Enabled = true;
                        this.LibrarySetMenuItem.Enabled = true;
                        this.LibrarySetTopMenuItem.Enabled = true;
                        for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
                        {// 選択要素数ループ
                            if (csSelectionList[iLp].GetModelInfo().GetLibraryID().ToString() != "")
                            {// モデル設定がある場合
                                this.LibraryCancelMenuItem.Enabled = true;
                                this.ParameterSetMenuItem.Enabled = true;
                                this.LibraryReSetTopMenuItem.Enabled = true;
                                break;
                            }
                        }
                        for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
                        {// 選択要素数ループ
                            if (csSelectionList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                            {// 接続線の場合
                                this.LibrarySetTopMenuItem.DropDownItems[3].Visible = true;
                            }
                            else if (csSelectionList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)
                            {// 要素の場合
                                if (csSelectionList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT)
                                {// 出力要素の場合
                                    this.LibrarySetTopMenuItem.DropDownItems[2].Visible = true;
                                }
                                else if (csSelectionList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT)
                                {// 入力要素の場合
                                    this.LibrarySetTopMenuItem.DropDownItems[1].Visible = true;
                                }
                                else if (csSelectionList[iLp].GetDrawSubKind() != McDefine.HYM_DRAW_SUB_KIND_DATA_MERGE)
                                {// マージ要素の場合
                                    this.LibrarySetTopMenuItem.DropDownItems[0].Visible = true;
                                }
                            }
                            else if (csSelectionList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
                            {// 収束演算系グループ要素の場合
                                this.LibrarySetTopMenuItem.DropDownItems[0].Visible = true;
                            }
                        }
                    }
                }
                else
                {// 選択モード以外の場合
                    // セレクトモード設定
                    ObjectSelect(null, null);
                    e.Cancel = true;
                }
            }
            else if (((ContextMenuStrip)sender).Name == "contextMenuStrip2")
            {// リスト部用メニューの場合
                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
                {// 選択モードの場合
                    this.DeleteMenuItemT1.Enabled = false;
                    this.LibraryMenuItemT1.Enabled = false;
                    this.LibrarySetMenuItemT1.Enabled = false;
                    this.LibraryCancelMenuItemT1.Enabled = false;
                    this.ParameterSetMenuItemT1.Enabled = false;
                    this.InternalDispOpenMenuItemT1.Enabled = false;
                    // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                    this.InternalDispMenuItemOpenT1.Enabled = false;
                    this.ElementCenterDispMenuItemT1.Enabled = false;
                    this.LibrarySetTopMenuItemT1.Enabled = false;
                    this.LibrarySetTopMenuItemT1.DropDownItems[0].Visible = false;
                    this.LibrarySetTopMenuItemT1.DropDownItems[1].Visible = false;
                    this.LibrarySetTopMenuItemT1.DropDownItems[2].Visible = false;
                    this.LibrarySetTopMenuItemT1.DropDownItems[3].Visible = false;
                    this.LibraryReSetTopMenuItemT1.Enabled = false;
                    // グループ表示タブ数チェック
                    if (m_iTabCount > 1)
                    {// グループ内部表示タブ数が１より大きい場合
                        this.InternalDispMenuItemT1.Enabled = true;
                        this.InternalDispCloseMenuItemT1.Enabled = true;
                        // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                        this.InternalDispMenuItemCloseT1.Enabled = true;
                    }
                    else
                    {// グループ内部表示タブ数が１以下場合
                        this.InternalDispMenuItemT1.Enabled = false;
                        this.InternalDispCloseMenuItemT1.Enabled = false;
                        // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                        this.InternalDispMenuItemCloseT1.Enabled = false;
                    }
                    this.ScreenDispMenuItemT1.Enabled = true;
                    this.ScreenDispMenuItemT1.Visible = false;//[2011/01/18]
                    this.PopUpSeparatorT2.Visible = false;

                    // 選択要素数チェック
                    if (iElementCounter[0] > 0)
                    {// 選択要素数が０より大きい場合
                        this.DeleteMenuItemT1.Enabled = true;
                    }
                    // 選択グループ数チェック
                    if (iElementCounter[1] > 0)
                    {// 選択グループ要素数が０より大きい場合
                        this.DeleteMenuItemT1.Enabled = true;
                        this.InternalDispMenuItemT1.Enabled = true;
                        this.InternalDispOpenMenuItemT1.Enabled = true;
                        // Ver1.3では下記コードを追加する（グループ内部表示のメニュー階層見直し）
                        this.InternalDispMenuItemOpenT1.Enabled = true;
                    }
                    // 選択中継端子数チェック
                    if (iElementCounter[3] > 0)
                    {// 選択中継端子数が０より大きい場合
                        this.DeleteMenuItemT1.Enabled = true;
                    }
                    // 選択接続線数チェック
                    if (iElementCounter[4] > 0)
                    {// 選択接続線数が０より大きい場合
                        this.DeleteMenuItemT1.Enabled = true;
                    }
                    if ((iElementCounter[0] > 0) || (iElementCounter[1] > 0) || (iElementCounter[4] > 0))
                    {// 選択要素数が０より大きいまたは選択グループ要素数が０より大きいまたは選択接続線数が０より多き場合
                        this.LibraryMenuItemT1.Enabled = true;
                        this.LibrarySetMenuItemT1.Enabled = true;
                        this.LibrarySetTopMenuItemT1.Enabled = true;
                        for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
                        {// 選択要素数ループ
                            if (csSelectionList[iLp].GetModelInfo().GetLibraryID().ToString() != "")
                            {// モデル設定がある場合
                                this.LibraryCancelMenuItemT1.Enabled = true;
                                this.ParameterSetMenuItemT1.Enabled = true;
                                this.LibraryReSetTopMenuItemT1.Enabled = true;
                                break;
                            }
                        }
                        for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
                        {// 選択要素数ループ
                            if (csSelectionList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                            {// 接続線の場合
                                this.LibrarySetTopMenuItemT1.DropDownItems[3].Visible = true;
                            }
                            else if (csSelectionList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT)
                            {// 要素の場合
                                if (csSelectionList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT)
                                {// 出力要素の場合
                                    this.LibrarySetTopMenuItemT1.DropDownItems[2].Visible = true;
                                }
                                else if (csSelectionList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT)
                                {// 入力要素の場合
                                    this.LibrarySetTopMenuItemT1.DropDownItems[1].Visible = true;
                                }
                                else if (csSelectionList[iLp].GetDrawSubKind() != McDefine.HYM_DRAW_SUB_KIND_DATA_MERGE)
                                {// マージ要素の場合
                                    this.LibrarySetTopMenuItemT1.DropDownItems[0].Visible = true;
                                }
                            }
                            else if (csSelectionList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
                            {// 収束演算系グループ要素の場合
                                this.LibrarySetTopMenuItemT1.DropDownItems[0].Visible = true;
                            }
                        }
                    }
                    if (((iElementCounter[0] > 0) || (iElementCounter[1] > 0)) && ((iElementCounter[0] + iElementCounter[1]) == 1))
                    {// 選択要素数が０より大きいまたは選択グループ要素数が０より大きいおよび選択要素数と選択グループ要素数の合計が１の場合
                        this.ElementCenterDispMenuItemT1.Enabled = true;
                    }
                }
                else
                {// 選択モード以外の場合
                    // セレクトモード設定
                    ObjectSelect(null, null);
                    e.Cancel = true;
                }
            }
            else if (((ContextMenuStrip)sender).Name == "contextMenuStrip3")
            {
                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
                {// 選択モードの場合
                    // 表示中グループ表示タブチェック
                    if (TabControl.SelectedIndex == 0)
                    {// 全体系タブ表示の場合
                        this.TabInternalDispLeftEndMenuItem.Enabled = false;
                        this.TabInternalDispLeftMenuItem.Enabled = false;
                        this.TabInternalDispRightMenuItem.Enabled = false;
                        this.TabInternalDispRightEndMenuItem.Enabled = false;
                    }
                    else
                    {// グループ内部表示タブ表示の場合
                        // グループ表示タブ数チェック
                        if (m_iTabCount > 2)
                        {// グループ内部表示タブ数が２より大きい場合
                            if (TabControl.SelectedIndex <= 1)
                            {// 表示中グループ内部表示タブが一番左のタブの場合
                                this.TabInternalDispLeftEndMenuItem.Enabled = false;
                                this.TabInternalDispLeftMenuItem.Enabled = false;
                            }
                            else
                            {// 表示中グループ内部表示タブが一番左のタブ以外の場合
                                this.TabInternalDispLeftEndMenuItem.Enabled = true;
                                this.TabInternalDispLeftMenuItem.Enabled = true;
                            }
                            if (TabControl.SelectedIndex >= m_iTabCount - 1)
                            {// 表示中グループ内部表示タブが一番右のタブの場合
                                this.TabInternalDispRightMenuItem.Enabled = false;
                                this.TabInternalDispRightEndMenuItem.Enabled = false;
                            }
                            else
                            {// 表示中グループ内部表示タブが一番右のタブ以外の場合
                                this.TabInternalDispRightMenuItem.Enabled = true;
                                this.TabInternalDispRightEndMenuItem.Enabled = true;
                            }
                        }
                        else
                        {// グループ内部表示タブ数が２以下場合
                            this.TabInternalDispLeftEndMenuItem.Enabled = false;
                            this.TabInternalDispLeftMenuItem.Enabled = false;
                            this.TabInternalDispRightMenuItem.Enabled = false;
                            this.TabInternalDispRightEndMenuItem.Enabled = false;
                        }
                    }
                    this.GroupParameterSetMenuItem.Enabled = true;

                    // グループ表示タブ数チェック
                    if (m_iTabCount == 1)
                    {// グループ内部表示タブ数が１の場合
                        this.TabInternalDispMenuItem.Enabled = false;
                    }
                    else
                    {// グループ内部表示タブ数が１以外の場合
                        this.TabInternalDispMenuItem.Enabled = true;
                    }
                }
                else
                {// 選択モード以外の場合
                    // セレクトモード設定
                    ObjectSelect(null, null);
                    e.Cancel = true;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>リサイズイメージ表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ResizeImageDisp(iPointX, iPointY)</para>
        /// </example>
        /// <param name="iPointX">ポインタ位置X</param>
        /// <param name="iPointY">ポインタ位置Y</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ResizeImageDisp(int iPointX, int iPointY)
        {
            int iMovementX = Math.Abs(m_pMovePoint.X - iPointX) * 100 / (int)m_lDispScale;
            int iMovementY = Math.Abs(m_pMovePoint.Y - iPointY) * 100 / (int)m_lDispScale;

            if ((iMovementX > 0) || (iMovementY > 0))
            {// サイズ変更量が０より大きい場合
                int iBeforeX = m_pDispPoint.X + (m_iWidth * 100 / (int)m_lDispScale) * m_pMovePoint.X / m_iWidth;
                int iBeforeY = m_pDispPoint.Y + (m_iHeight * 100 / (int)m_lDispScale) * m_pMovePoint.Y / m_iHeight;
                int iAfterX = m_pDispPoint.X + (m_iWidth * 100 / (int)m_lDispScale) * iPointX / m_iWidth;
                int iAfterY = m_pDispPoint.Y + (m_iHeight * 100 / (int)m_lDispScale) * iPointY / m_iHeight;

                // リサイズ
                m_csGraphicsManager.ResizeObject(m_csSelectElm.GetID(), iBeforeX, iBeforeY, iAfterX, iAfterY);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                m_pMovePoint.X = iPointX;
                m_pMovePoint.Y = iPointY;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ツリー表示ボタン画面からのツリー画面表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>TreeDisplay(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeDisplay(object sender, EventArgs e)
        {
            McDotNetModelTreeForm csModelTreeForm = new McDotNetModelTreeForm(m_csScreen, m_csDispElmList[0], IDTypeButton.Checked);
            csModelTreeForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_TREE;  //"ツリー表示"

            csModelTreeForm.Owner = this;
            csModelTreeForm.ShowDialog();   // モーダルダイアログで表示する。
            csModelTreeForm.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>カスタマイズボタン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CustomFormDisplay()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CustomFormDisplay()
        {
            McDotNetModelCtlCustomForm csCustomForm = new McDotNetModelCtlCustomForm(m_csCustomInfo);
            csCustomForm.Text = Properties.McDotNetViewerResources.FROM_TITLE_CUSTOMIZE;    //"カスタマイズ"

            csCustomForm.Owner = this;
            if (csCustomForm.ShowDialog() == DialogResult.OK)
            {// 設定を選択した場合
                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                // ツールバーカスタマイズ情報復元
                ToolbarCustomSet();

                // モデル管理ガイドマップ再描画
                if (m_csSimpleMap != null)
                {// モデル管理ガイドマップ表示中の場合
                    m_csSimpleMap.CustomInfoChange(m_csCustomInfo);
                }
            }
            csCustomForm.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル管理ガイドマップボタン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SimpleMapDisplay(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimpleMapDisplay(object sender, EventArgs e)
        {
            if (m_csSimpleMap == null)
            {// モデル管理ガイドマップ表示中ではない場合
                m_csSimpleMap = new McDotNetModelCtlSimpleMapForm(this);
                m_csSimpleMap.Text = Properties.McDotNetViewerResources.FORM_TITLE_GUIDEMAP;    //"モデル管理ガイドマップ"
                // 右端に表示
                Size desktopSize = System.Windows.Forms.SystemInformation.WorkingArea.Size;
                SIMPLEMAP_DESKTOP_LOCATION_X = desktopSize.Width - SIMPLEMAP_WIDTH;
                m_csSimpleMap.SetDesktopLocation(SIMPLEMAP_DESKTOP_LOCATION_X - SIMPLEMAP_DESKTOP_LOCATION_X_ADJUSTED_VALUE, SIMPLEMAP_DESKTOP_LOCATION_Y_ADJUSTED_VALUE);
                //m_csSimpleMap.SetDesktopLocation(0, 0);
                m_csSimpleMap.Width = SIMPLEMAP_WIDTH;
                m_csSimpleMap.Height = SIMPLEMA_HEIGHT;

                //m_csSimpleMap.Owner = this;
                m_csSimpleMap.Owner = this.MdiParent;
                // 常に最前面表示
                //m_csSimpleMap.MdiParent = this.MdiParent;
                m_csSimpleMap.BringToFront();
                m_csSimpleMap.Show();
            }
            else
            {// モデル管理ガイドマップ表示中の場合
                m_csSimpleMap.WindowState = FormWindowState.Normal;
                m_csSimpleMap.Activate();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算モデルチェック結果情報セット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetStructCheckData( csStructCheckData )</para>
        /// </example>
        /// <param name="csStructCheckData">演算モデルチェック結果情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetStructCheckData(McStructCheckData csStructCheckData)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            m_csStructCheckData = csStructCheckData;

            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_PROPETY_LIST_EDIT;

            TabPage1DataGridView5.Rows.Clear();

            // 演算モデルチェック結果表示編集
            for (int iLp = 0; iLp < m_csStructCheckData.GetCheckDataCount(); iLp++)
            {// チェックデータ数ループ
                TabPage1DataGridView5.Rows.Add();
                if (true == m_csStructCheckData.GetCheckData(iLp).IsDrawObject())
                {// モデルチェックエラーの場合
                    TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column50.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString();
                    if (m_csStructCheckData.GetCheckData(iLp).GetID().ToString().IndexOf('-') != -1)
                    {// 分割出来る場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString().Substring(0, m_csStructCheckData.GetCheckData(iLp).GetID().ToString().IndexOf('-'));
                    }
                    else
                    {// 分割出来ない場合
                        if (m_csStructCheckData.GetCheckData(iLp).GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                        {// IDの長さが既定値以下の場合
                            TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString();
                        }
                        else
                        {// IDの長さが既定値より大きい場合
                            TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                        }
                    }
                }
                else
                {// モデルチェックエラー以外の場合
                    if ((m_csStructCheckData.GetCheckData(iLp).GetID() == null) ||
                        (m_csStructCheckData.GetCheckData(iLp).GetID().ToString() == ""))
                    {// IDがない場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column50.Name].Value = "";
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = "";
                    }
                    else
                    {// IDがある場合
                        TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column50.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString();
                        if (m_csStructCheckData.GetCheckData(iLp).GetID().ToString().IndexOf('-') != -1)
                        {// 分割出来る場合
                            TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString().Substring(0, m_csStructCheckData.GetCheckData(iLp).GetID().ToString().IndexOf('-'));
                        }
                        else
                        {// 分割出来ない場合
                            if (m_csStructCheckData.GetCheckData(iLp).GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                            {// IDの長さが既定値以下の場合
                                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString();
                            }
                            else
                            {// IDの長さが既定値より大きい場合
                                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column51.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH);
                            }
                        }
                    }
                }
                TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].Cells[TabPage1Column52.Name].Value = m_csStructCheckData.GetCheckData(iLp).GetMessage().ToString();
                if ((m_csStructCheckData.GetCheckData(iLp).GetMessageLevel() == McDefine.MessageLevel.HYM_MODELCHECK_ERROR) ||
                    (m_csStructCheckData.GetCheckData(iLp).GetMessageLevel() == McDefine.MessageLevel.HYM_SIMULATION_ERROR))
                {// エラー情報の場合
                    TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].DefaultCellStyle.ForeColor = Color.Red;
                }
                else if (m_csStructCheckData.GetCheckData(iLp).GetMessageLevel() == McDefine.MessageLevel.HYM_MODELCHECK_WARNING ||
                          m_csStructCheckData.GetCheckData(iLp).GetMessageLevel() == McDefine.MessageLevel.HYM_MODELCHECK_INFORMATION
                         )
                {// ワーニングまたはインフォメーションの場合
                    TabPage1DataGridView5.Rows[TabPage1DataGridView5.Rows.Count - 1].DefaultCellStyle.ForeColor = Color.DarkOrange;
                }
            }

            if (TabPage1DataGridView5.Rows.Count != 0)
            {// 行数が０以外の場合
                TabPage1TabPControl.SelectedIndex = 4;
            }

            TabPage1DataGridView5.ClearSelection();

            m_eDrawMode = eTempDrawMode;

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算モデルチェック結果情報削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DelStructCheckData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DelStructCheckData()
        {
            for (int iLp = (int)m_csStructCheckData.GetCheckDataCount() - 1; iLp >= 0; iLp--)
            {// チェックデータ数ループ
                m_csStructCheckData.RemoveCheckData(iLp);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>収束演算グループ作成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalculationGrouping(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalculationGrouping(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                //選択中要素リスト取得
                List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();

                if (csSelectionList.Count <= 0)
                {// 選択要素数が０以下の場合
                    return;
                }

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                // グループ化
                McGraphicsElement csElement = m_csGraphicsManager.GroupObject(McDefine.SymbolDrawKind.HYM_CALC_GROUP);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                McGraphicsElement csGroupElement = null;
                //内部表示タブ表示中グループ有無チェック
                for (int iLp = TabControl.TabCount - 1; iLp >= 1; iLp--)
                {// グループ内部表示タブ数ループ
                    csGroupElement = m_csGraphicsManager.SearchGroupElement(m_csDispElmList[0], m_csDispElmList[iLp][0].GetID());
                    if (csGroupElement != null)
                    {// グループ要素があった場合
                        m_csDispElmList[iLp][0] = csGroupElement;
                    }
                }

                // リスト部編集
                PropertyListEdit(0, true);

                m_csGraphicsManager.AddSelectionList(csElement);

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.GROUPING;
                m_csHistoryDataWork = new List<object>();
                m_csHistoryDataWork.Add(csElement.CopyInfUsedByUndoRedoOnly(null));
                csHistoryData.HistoryData = m_csHistoryDataWork;

                //復元ポイント記録
                ReconstructionPointSave(true, csHistoryData);

                // モデル管理ガイドマップ再描画
                SimpleMapReDraw();

                // ボタン活性／非活性設定
                ButtonEnabledSet();

                // グラフ画面クローズ
                ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenCloseEvent(new HySID(""));

                // プロパティ画面リフレッシュ
                if (TabControl.SelectedIndex == 0)
                {// 全体系タブ表示の場合
                    PropetyScreenRefreshment(m_csGraphicsManager.GetStructInfo().GetID());
                }
                else
                {// 全体系タブ以外表示の場合
                    PropetyScreenRefreshment(m_csDispElmList[TabControl.SelectedIndex][0].GetID());
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系グループ作成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartGrouping(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartGrouping(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                //選択中要素リスト取得
                List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();

                if (csSelectionList.Count <= 0)
                {// 選択要素数が０以下の場合
                    return;
                }

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                // グループ化
                McGraphicsElement csElement = m_csGraphicsManager.GroupObject(McDefine.SymbolDrawKind.HYM_GROUP);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                McGraphicsElement csGroupElement = null;
                //内部表示タブ表示中グループ有無チェック
                for (int iLp = TabControl.TabCount - 1; iLp >= 1; iLp--)
                {// グループ内部表示タブ数ループ
                    csGroupElement = m_csGraphicsManager.SearchGroupElement(m_csDispElmList[0], m_csDispElmList[iLp][0].GetID());
                    if (csGroupElement != null)
                    {// グループ要素があった場合
                        m_csDispElmList[iLp][0] = csGroupElement;
                    }
                }

                // リスト部編集
                PropertyListEdit(0, true);

                m_csGraphicsManager.AddSelectionList(csElement);

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.GROUPING;
                m_csHistoryDataWork = new List<object>();
                m_csHistoryDataWork.Add(csElement.CopyInfUsedByUndoRedoOnly(null));
                csHistoryData.HistoryData = m_csHistoryDataWork;

                //復元ポイント記録
                ReconstructionPointSave(true, csHistoryData);

                // モデル管理ガイドマップ再描画
                SimpleMapReDraw();

                // ボタン活性／非活性設定
                ButtonEnabledSet();

                // グラフ画面クローズ
                ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenCloseEvent(new HySID(""));

                // プロパティ画面リフレッシュ
                if (TabControl.SelectedIndex == 0)
                {// 全体系タブ表示の場合
                    PropetyScreenRefreshment(m_csGraphicsManager.GetStructInfo().GetID());
                }
                else
                {// 全体系タブ以外表示の場合
                    PropetyScreenRefreshment(m_csDispElmList[TabControl.SelectedIndex][0].GetID());
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グループ解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CancellationGrouping(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CancellationGrouping(object sender, EventArgs e)
        {
            bool bDisbandFlg = false;

            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                //選択中要素リスト取得
                List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();

                if (csSelectionList.Count <= 0)
                {// 選択要素数が０以下の場合
                    return;
                }

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                McGraphicsElement csElement = null;
                List<HySIdentifier> csMoveElmIDList = new List<HySIdentifier>();
                List<Point> csBeforePointList = new List<Point>();
                List<Point> csAfterPointList = new List<Point>();
                List<McGraphicsElement> csDelOuterLineList = new List<McGraphicsElement>();
                for (int iLp = 0; iLp < csSelectionList.Count; iLp++)
                {// 選択要素数ループ
                    if ((csSelectionList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_CALC_GROUP) &&
                        (csSelectionList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_GROUP))
                    {// グループ要素以外の場合
                        continue;
                    }
                    if (csSelectionList[iLp].GetModelInfo().GetLibraryID().ToString() != "")
                    {// モデル設定があった場合
                        if (csSelectionList[iLp].GetModelInfo().GetPropertyInfo() is McGroupPropertyInfo)
                        {// キャスト可能な場合
                            if (((McGroupPropertyInfo)csSelectionList[iLp].GetModelInfo().GetPropertyInfo()).CanDisband() == false)
                            {// グループ解除不許可の場合
                                continue;
                            }
                        }
                    }

                    //部分系表示中グループはタブ消去
                    for (int iLp2 = 1; iLp2 < m_iTabCount; iLp2++)
                    {// グループ内部表示タブ数ループ
                        if (csSelectionList[iLp].GetID().ToString() == m_csDispElmList[iLp2][0].GetID().ToString())
                        {// IDが一致した場合
                            TabControl.TabPages.RemoveAt(iLp2);

                            //削除タブ情報をリストから削除
                            m_csDispElmList.RemoveAt(iLp2);
                            m_lDispScaleList.RemoveAt(iLp2);
                            m_iPropertyListSortColumnIndexList.RemoveAt(iLp2);
                            m_pDispPointList.RemoveAt(iLp2);
                            m_pScrollLeftTop.RemoveAt(iLp2);
                            m_pScrollRightBottom.RemoveAt(iLp2);
                            m_pEditLeftTop.RemoveAt(iLp2);
                            m_pEditRightBottom.RemoveAt(iLp2);

                            m_iTabCount--;
                        }
                    }

                    csElement = csSelectionList[iLp].CopyInfUsedByUndoRedoOnly(null);

                    // グループ解除
                    long lRtn = m_csGraphicsManager.DisbandObject(csElement.GetID(), ref csMoveElmIDList, ref csBeforePointList, ref csAfterPointList, ref csDelOuterLineList);
                    if (lRtn == 0)
                    {// グループ解除成功の場合
                        // プロパティ画面クローズ
                        PropetyScreenClose(csElement.GetID());

                        bDisbandFlg = true;
                    }
                    break;
                }

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                if (bDisbandFlg == true)
                {// グループ解除の場合
                    // リスト部編集
                    PropertyListEdit(0, false);

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT |
                                McDefine.LayerKind.PORT |
                                McDefine.LayerKind.LINE |
                                McDefine.LayerKind.ID |
                                McDefine.LayerKind.NAME |
                                McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    //復元データ編集
                    McHistoryData csHistoryData = new McHistoryData();
                    csHistoryData.Kind = McHistoryData.OperationKind.CANCELLATION_GROUPING;
                    m_csHistoryDataWork = new List<object>();
                    m_csHistoryDataWork.Add(csElement);
                    m_csHistoryDataWork.Add(csMoveElmIDList);
                    m_csHistoryDataWork.Add(csBeforePointList);
                    m_csHistoryDataWork.Add(csAfterPointList);
                    m_csHistoryDataWork.Add(csDelOuterLineList);
                    csHistoryData.HistoryData = m_csHistoryDataWork;

                    //復元ポイント記録
                    ReconstructionPointSave(true, csHistoryData);

                    // モデル管理ガイドマップ再描画
                    SimpleMapReDraw();

                    // ボタン活性／非活性設定
                    ButtonEnabledSet();

                    // プロパティ画面リフレッシュ
                    if (TabControl.SelectedIndex == 0)
                    {// 全体系タブ表示の場合
                        PropetyScreenRefreshment(m_csGraphicsManager.GetStructInfo().GetID());
                    }
                    else
                    {// 全体系タブ以外表示の場合
                        PropetyScreenRefreshment(m_csDispElmList[TabControl.SelectedIndex][0].GetID());
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ScreenDisp(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ScreenDisp(object sender, EventArgs e)
        {
            bool bScreenFlg = false;

            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                //エレメントリスト取得
                List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();
                for (int iLP = 0; iLP < csElmList.Count; iLP++)
                {// 要素数ループ
                    McModelInfo csModelInf = csElmList[iLP].GetModelInfo();
                    if (csModelInf.GetAttachedScreenKind() == true)
                    {// 付属画面ありの場合
                        McCellModelPropertyInfo csPropertyInfo = csModelInf.GetPropertyInfo() as McCellModelPropertyInfo;
                        HySDataLinkedList csInputList = csPropertyInfo.GetInputConnectionInfoList();
                        if (csInputList.GetCount() > 0)
                        {  // 入力接続データが有る場合
                            HySDataLinkedList csPatternID = new HySDataLinkedList();
                            for (long lP = 0; lP < csInputList.GetCount(); lP++)
                            {  // 接続要素数分繰り返す
                                McModelInfo csModelInfo = csInputList.GetData(lP) as McModelInfo;
                                McCellArrayTranInfoPropertyInfo csCellModelPropertyInfo = csModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                                if (csCellModelPropertyInfo is McCellArrayTranInfoPropertyInfo)
                                {  // 接続要素が有効な場合
                                    csPatternID.AddLast(csCellModelPropertyInfo.GetLowerConnectionPatternID()); // 接続要素パターンＩＤ設定
                                }
                            }
                            if (csPatternID.GetCount() > 0)
                            {  // 接続要素が有効な場合
                                ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenDispEvent(csElmList[iLP].GetID(), csPatternID);
                                csElmList[iLP].SetElementDisplayMode(true);
                                bScreenFlg = true;
                            }
                            else
                            {  // 接続要素が無効な場合
                                csPatternID = null;
                            }
                        }
                    }
                }

                if (bScreenFlg == true)
                {// 画面表示の場合
                    // リスト部編集
                    PropertyListEdit(3, false);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルログデータ表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetModelLogData(csModelLogData)</para>
        /// </example>
        /// <param name="csModelLogData">モデルログデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelLogData(McModelLogData csModelLogData)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            TabPage1TabPControl.SelectedIndex = 5;
            m_csModelLogData = csModelLogData;
            for (int iLp = 0; iLp < m_csModelLogData.GetLogDataListCount(); iLp++)
            {// ログデータ数ループ
                CalcLogList.Items.Add(m_csModelLogData.GetLogData(iLp).ToString());
            }
            CalcLogList.SelectedIndex = CalcLogList.Items.Count - 1;

            CalcLogList.ClearSelected();

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルログデータクリア</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ClearModelLogData()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearModelLogData()
        {
            CalcLogList.Items.Clear();
            CalcLogList.ClearSelected();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>構造定義ファイル：読み込み</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XmlFileRead()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XmlFileRead()
        {
            OpenFileDialog OpenFileDialog = new OpenFileDialog();
            OpenFileDialog.FileName = "";
            OpenFileDialog.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML; //"ＸＭＬ ファイル (*.xml)|*.xml"
            OpenFileDialog.Multiselect = false;
            OpenFileDialog.RestoreDirectory = true;
            OpenFileDialog.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString();
            OpenFileDialog.Title = Properties.McDotNetViewerResources.FILE_DLG_TITLE_READ_MODEL;    //"読み込みモデル構造定義ファイル選択"
            if (OpenFileDialog.ShowDialog(this) == DialogResult.OK)
            {// 入力ファイル選択の場合
                ((McDotNetModelCtlScreen)m_csScreen).PutEventRequestStructFileRead(new HySString(OpenFileDialog.FileName));
            }
            OpenFileDialog.Dispose();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>構造定義ファイル：書き出し</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>XmlFileWrite(lPropertyOutFlg)</para>
        /// </example>
        /// <param name="lPropertyOutFlg">プロパティ情報出力フラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void XmlFileWrite(long lPropertyOutFlg)
        {
            // プロパティ出力指定
            McPropertyInfoBase.SetXmlOutFlg(lPropertyOutFlg);

            SaveFileDialog SaveFileDialog = new SaveFileDialog();
            SaveFileDialog.FileName = ((McDotNetModelCtlScreen)m_csScreen).GetProjectName().ToString();
            SaveFileDialog.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML; //"ＸＭＬ ファイル (*.xml)|*.xml"
            SaveFileDialog.AddExtension = true;
            SaveFileDialog.RestoreDirectory = true;
            SaveFileDialog.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString() + "\\" + ((McDotNetModelCtlScreen)m_csScreen).GetProjectGroupName().ToString() + "\\SCF\\";
            SaveFileDialog.Title = Properties.McDotNetViewerResources.FILE_DLG_TITLE_WRITE_MODEL;   //"書き出しモデル構造定義ファイル選択"
            if (SaveFileDialog.ShowDialog(this) == DialogResult.OK)
            {// 出力ファイル選択の場合
                HySString csFileName = new HySString(SaveFileDialog.FileName);
                if (SaveFileDialog.FileName.Substring(SaveFileDialog.FileName.Length - 4, 4) != Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_XML)
                {// 拡張子がない場合
                    csFileName += Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_XML;
                }
                ((McDotNetModelCtlScreen)m_csScreen).PutEventRequestStructFileWrite(csFileName);
            }
            SaveFileDialog.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MenuCallBack(lCallBackNumber)</para>
        /// </example>
        /// <param name="lCallBackNumber">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MenuCallBack(long lCallBackNumber)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                if (lCallBackNumber == McDefine.HYMCO_EDIT_UNDO)
                {// 元に戻すの場合
                    if (UndoButton.Enabled == true)
                    {// Undo可能な場合
                        UndoProcess(null, null);            //元に戻す
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_REDO)
                {// やり直しの場合
                    if (RedoButton.Enabled == true)
                    {// Redo可能な場合
                        RedoProcess(null, null);            //やり直し
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_CUT)
                {// 切り取りの場合
                    if (this.ZoomSizeComboBox.Focused == true)
                    {
                        // 倍率表示ボックスにフォーカスがある場合
                        // textboxに対するショートカット処理
                        if (this.ZoomSizeComboBox.SelectedText != string.Empty)
                        {
                            Clipboard.SetText(this.ZoomSizeComboBox.SelectedText);
                            this.ZoomSizeComboBox.SelectedText = string.Empty;
                        }
                    }
                    else if (CutButton.Enabled == true)
                    {// 切り取り可能な場合
                        ObjectCut(null, null);              //切り取り
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_COPY)
                {// コピーの場合
                    if (this.ZoomSizeComboBox.Focused == true)
                    {
                        // 倍率表示ボックスにフォーカスがある場合
                        // textboxに対するショートカット処理
                        if (this.ZoomSizeComboBox.SelectedText != string.Empty)
                        {
                            Clipboard.SetText(this.ZoomSizeComboBox.SelectedText);
                        }
                    }
                    else if (CopyButton.Enabled == true)
                    {// コピー可能な場合
                        ObjectCopy(null, null);             //コピー
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_PASTE)
                {// 貼り付けの場合
                    if (this.ZoomSizeComboBox.Focused == true)
                    {
                        // 倍率表示ボックスにフォーカスがある場合
                        // textboxに対するショートカット処理
                        this.ZoomSizeComboBox.SelectedText = Clipboard.GetText();
                    }
                    else if (PasteButton.Enabled == true)
                    {// 貼り付け可能な場合
                        ObjectPaste(null, null);            //貼り付け
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_DELETE)
                {// 削除の場合
                    if (this.ZoomSizeComboBox.Focused == true)
                    {
                        // 倍率表示ボックスにフォーカスがある場合
                        // textboxに対するショートカット処理
                        if (this.ZoomSizeComboBox.SelectionLength == 0)
                        {
                            // カーソル直後の1文字削除処理
                            this.ZoomSizeComboBox.SelectionLength = 1;
                        }
                        // 選択済文字列の削除処理
                        this.ZoomSizeComboBox.SelectedText = string.Empty;
                    }
                    else if (DeleteButton.Enabled == true)
                    {// 削除可能な場合
                        ObjectDelete(null, null);           //削除
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_SELECTALL)
                {// すべて選択の場合
                    if (this.ZoomSizeComboBox.Focused == true)
                    {
                        // 倍率表示ボックスにフォーカスがある場合
                        // textboxに対するショートカット処理
                        this.ZoomSizeComboBox.SelectAll();
                    }
                    else if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        ObjectAllSelect();                  //すべて選択
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_MOVE_TOP)
                {// 最前面へ移動の場合
                    if (TopButton.Enabled == true)
                    {// 最前面へ移動可能な場合
                        ObjectTop(null, null);              //順序：最前面へ移動
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_MOVE_BOTTOM)
                {// 最背面へ移動の場合
                    if (BottomButton.Enabled == true)
                    {// 最背面へ移動可能な場合
                        ObjectBottom(null, null);           //順序：最背面へ移動
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_PART_GROUP)
                {// 部分系グループ化の場合
                    if (PartGrButton.Enabled == true)
                    {// 部分系グループ化可能な場合
                        PartGrouping(null, null);           //グループ化：部分系グループ化
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_CONVEGENT_CALC_GROUP)
                {// 収束演算系グループ化の場合
                    if (CalcGrButton.Enabled == true)
                    {// 収束演算系グループ化可能な場合
                        CalculationGrouping(null, null);    //グループ化：収束演算系グループ化
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_EDIT_DISBAND)
                {// グループ解除の場合
                    if (GrCancelButton.Enabled == true)
                    {// グループ解除可能な場合
                        CancellationGrouping(null, null);   //グループ化：グループ解除
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_LOAD_PROJECT)
                {// プロジェクト取り込みの場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        ProjectIncorporate();               //プロジェクト取り込み
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_PART_DISPLAY)
                {// グループ内部表示の場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        PartDisp(null, null);               //内部表示：表示
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_PART_CLOSE)
                {// グループ内部表示閉じるの場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        PartDispClose(null, null);          //内部表示：閉じる
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_CALCRESULT_VIEWERDISP)
                {// 画面表示の場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        ScreenDisp(null, null);            //計算結果表示：画面表示
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_CHECK)
                {// モデルチェックの場合
                    if (ConnectCheckButton.Enabled == true)
                    {// モデルチェック可能な場合
                        ConnectCheck(null, null);           //モデルチェック
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_DISP_ID_ON)
                {// ＩＤを表示(設定）の場合
                    DispKindChangeID(true);             //表示設定：ＩＤを表示(設定）
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_DISP_ID_OFF)
                {// ＩＤを表示（解除）の場合
                    DispKindChangeID(false);            //表示設定：ＩＤを表示（解除）
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_DISP_NAME_ON)
                {// 名前を表示（設定）の場合
                    DispKindChangeName(true);           //表示設定：名前を表示（設定）
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_DISP_NAME_OFF)
                {// 名前を表示（解除）の場合
                    DispKindChangeName(false);          //表示設定：名前を表示（解除）
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_STRUCTINFO_READ)
                {// 構造定義ファイル読み込みの場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        XmlFileRead();                      //構造定義ファイル：読み込み
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART)
                {// 構造定義ファイル書き出し(簡易)の場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        XmlFileWrite(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART);                //構造定義ファイル：書き出し(簡易)
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL)
                {// 構造定義ファイル書き出し(完全)の場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        XmlFileWrite(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL);                 //構造定義ファイル：書き出し(完全)
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE)
                {// 構造定義ファイル書き出し(完全&分割ファイル)の場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        XmlFileWrite(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE);            //構造定義ファイル：書き出し(完全&分割ファイル)
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_MODEL_CUSTUMIZE)
                {// カスタマイズの場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        CustomFormDisplay();                //カスタマイズ
                    }
                }
                else if (lCallBackNumber == McDefine.HYMCO_PROJECT_PARA_SET)
                {// プロジェクトパラメータ設定の場合
                    if (SelectButton.Enabled == true)
                    {// 選択可能な場合
                        // プロジェクトパラメータ設定
                        ((McDotNetModelCtlScreen)m_csScreen).ShowModelPropertyScreen(m_csGraphicsManager.GetStructInfo());
                    }
                }
            }

            if (lCallBackNumber == McDefine.HYMCO_MODEL_GUIDMAP)
            {// ガイドマップの場合
                if (SimpleMapButton.Enabled == true)
                {// ガイドマップ表示可能な場合
                    SimpleMapDisplay(null, null);       //ガイドマップ
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>クリップボードセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetClipBoard(csList)</para>
        /// </example>
        /// <param name="csList">セットデータリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetClipBoard(HySDataLinkedList csList)
        {
            Clipboard.Clear();
            DataFormats.Format myFormat = DataFormats.GetFormat("HySDataLinkedList");
            DataObject myDataObject = new DataObject(myFormat.Name, csList);

            // クリップボードに保存
            Clipboard.SetDataObject(myDataObject);
        }

        /// <summary><para>method outline:</para>
        /// <para>クリップボードゲット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csList = GetClipBoard()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList　コピー要素要素リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySDataLinkedList GetClipBoard()
        {
            DataFormats.Format myFormat = DataFormats.GetFormat("HySDataLinkedList");
            IDataObject myRetrievedObject = Clipboard.GetDataObject();
            HySDataLinkedList csWork = null;
            if (myRetrievedObject != null)
            {// クリップボードにデータがある場合
                if (myRetrievedObject.GetDataPresent(myFormat.Name) == true)
                {// クリップボードのデータが有効な場合
                    // クリップボード保存情報取得
                    csWork = myRetrievedObject.GetData(myFormat.Name) as HySDataLinkedList;
                    if (csWork != null)
                    {// データが取得できた場合
                        if (csWork.GetCount() > 0)
                        {// データ内件数が０より大きい場合
                            McGraphicsElement csElement = csWork.GetData(0) as McGraphicsElement;
                            if (csElement == null)
                            {// 要素が取得出来なかった場合
                                csWork = null;
                            }
                        }
                    }
                }
            }
            return csWork;
        }

        /// <summary><para>method outline:</para>
        /// <para>クリップボードチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckClipBoard()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:クリップボードデータ有効　false:クリップボードデータ無効</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CheckClipBoard()
        {
            DataFormats.Format myFormat = DataFormats.GetFormat("HySDataLinkedList");
            IDataObject myRetrievedObject = Clipboard.GetDataObject();
            bool bRtn = false;
            if (myRetrievedObject != null)
            {// クリップボードにデータがある場合
                if (myRetrievedObject.GetDataPresent(myFormat.Name) == true)
                {// クリップボードのデータが有効な場合
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>キーダウンイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>KeyDownEventControl(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void KeyDownEventControl(object sender, KeyEventArgs e)
        {
            if ((TabControl.Focused != true) &&
                (LayerRubberBand.Focused != true) &&
                (TabPage1TabPControl.Focused != true) &&
                (TabPage1DataGridView1.Focused != true) &&
                (TabPage1DataGridView2.Focused != true) &&
                (TabPage1DataGridView3.Focused != true) &&
                (TabPage1DataGridView4.Focused != true))
            {// フォーカスのあるコントロールが有効な場合
                return;
            }

            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();

                e.Handled = true;

                bool bReDraw = false;

                if (e.KeyCode == Keys.Delete)
                {// Deleteキーが押された場合
                    //選択要素削除
                    ObjectDelete(null, null);
                }
                else if (!e.Shift && e.KeyCode == Keys.Tab)
                {// Shiftキーが押されずTabキーが押された場合
                    //選択状態移動
                    SelectSkip();
                }
                else if (e.Shift && e.KeyCode == Keys.Tab)
                {// ShiftキーとTabキーが押された場合
                    //選択状態移動
                    SelectReverseSkip();
                }
                else if (e.Control && e.KeyCode == Keys.Up)
                {// Controlキーと上キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        //選択要素整列（上辺整列）
                        m_csGraphicsManager.ElementLineUp(0, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.Control && e.KeyCode == Keys.Right)
                {// Controlキーと右キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();
                        
                        //選択要素整列（右辺整列）
                        m_csGraphicsManager.ElementLineUp(1, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);
                        
                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }
                        
                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.Control && e.KeyCode == Keys.Down)
                {// Controlキーと下キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        //選択要素整列（下辺整列）
                        m_csGraphicsManager.ElementLineUp(2, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.Control && e.KeyCode == Keys.Left)
                {// Controlキーと左キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        //選択要素整列（左辺整列）
                        m_csGraphicsManager.ElementLineUp(3, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.Shift && e.KeyCode == Keys.Up)
                {// Shiftキーと上キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        //選択要素等間隔整列（上下等間隔整列）
                        m_csGraphicsManager.ElementEqualDistanceLineUp(0, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.Shift && e.KeyCode == Keys.Right)
                {// Shiftキーと右キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        //選択要素等間隔整列（左右等間隔整列）
                        m_csGraphicsManager.ElementEqualDistanceLineUp(1, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.Shift && e.KeyCode == Keys.Down)
                {// Shiftキーと下キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        //選択要素等間隔整列（上下等間隔整列）
                        m_csGraphicsManager.ElementEqualDistanceLineUp(0, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.Shift && e.KeyCode == Keys.Left)
                {// Shiftキーと左キーが押された場合
                    if (csSelectList.Count > 1)
                    {// 選択要素数が１より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        //選択要素等間隔整列（左右等間隔整列）
                        m_csGraphicsManager.ElementEqualDistanceLineUp(1, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.KeyCode == Keys.Up)
                {// 上キーが押された場合
                    if (csSelectList.Count > 0)
                    {// 選択要素数が０より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveElmIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        // 移動前座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csBeforePointList);

                        // 選択要素移動
                        m_csGraphicsManager.MoveObject(0, -m_csCustomInfo.GetMovementRate1());

                        // 移動後座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveElmIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.KeyCode == Keys.Right)
                {// 右キーが押された場合
                    if (csSelectList.Count > 0)
                    {// 選択要素数が０より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveElmIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        // 移動前座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csBeforePointList);

                        // 選択要素移動
                        m_csGraphicsManager.MoveObject(m_csCustomInfo.GetMovementRate1(), 0);

                        // 移動後座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveElmIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.KeyCode == Keys.Down)
                {// 下キーが押された場合
                    if (csSelectList.Count > 0)
                    {// 選択要素数が０より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveElmIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        // 移動前座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csBeforePointList);

                        // 選択要素移動
                        m_csGraphicsManager.MoveObject(0, m_csCustomInfo.GetMovementRate1());

                        // 移動後座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveElmIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.KeyCode == Keys.Left)
                {// 左キーが押された場合
                    if (csSelectList.Count > 0)
                    {// 選択要素数が０より大きい場合
                        // カーソルを砂時計にする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.WaitCursor;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.WaitCursor;
                        }

                        List<HySIdentifier> csMoveElmIDList = new List<HySIdentifier>();
                        List<Point> csBeforePointList = new List<Point>();
                        List<Point> csAfterPointList = new List<Point>();

                        // 移動前座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csBeforePointList);

                        // 選択要素移動
                        m_csGraphicsManager.MoveObject(-m_csCustomInfo.GetMovementRate1(), 0);

                        // 移動後座標取得
                        m_csGraphicsManager.MoveObjectPositionGet(ref csMoveElmIDList, ref csAfterPointList);

                        // カーソルをデフォルトにする。
                        if (this.MdiParent != null)
                        {// 親フォームがある場合
                            this.MdiParent.Cursor = Cursors.Default;
                        }
                        else
                        {// 親フォームがない場合
                            this.Cursor = Cursors.Default;
                        }

                        bReDraw = true;

                        //復元データ編集
                        McHistoryData csHistoryData = new McHistoryData();
                        csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                        m_csHistoryDataWork = new List<object>();
                        m_csHistoryDataWork.Add(csMoveElmIDList);
                        m_csHistoryDataWork.Add(csBeforePointList);
                        m_csHistoryDataWork.Add(csAfterPointList);
                        csHistoryData.HistoryData = m_csHistoryDataWork;

                        //復元ポイント記録
                        ReconstructionPointSave(false, csHistoryData);
                    }
                }
                else if (e.KeyCode == Keys.Escape)
                {// Escapeキーが押された場合
                    if (csSelectList.Count > 0)
                    {// 選択要素数が０より大きい場合
                        m_csGraphicsManager.ClearSelectionList();

                        //編集領域設定
                        m_pReDrawPoint.X = m_pDispPoint.X;
                        m_pReDrawPoint.Y = m_pDispPoint.Y;
                        m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                        m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                        // グラフィック部編集
                        LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                    McDefine.LayerKind.PORT_SELECT |
                                    McDefine.LayerKind.LINE_SELECT,
                                    true,
                                    true);

                        //プロパティ一覧選択状態解除
                        PropertyListSelectionClear(0);

                        //プロパティリスト選択同期
                        m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                        ListSelectionMatching();
                        m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
                    }
                }
                else
                {// その他の場合
                    e.Handled = false;
                }

                if (bReDraw == true)
                {// 表示編集要の場合
                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT |
                                McDefine.LayerKind.PORT |
                                McDefine.LayerKind.LINE |
                                McDefine.LayerKind.ID |
                                McDefine.LayerKind.NAME |
                                McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    // モデル管理ガイドマップ再描画
                    SimpleMapReDraw();
                }
            }
            else if (m_eDrawMode == McDefine.DrawModeKind.HYM_DRAW_LINE_FROM_SELECT)
            {// 作画モード接続線送信側選択の場合
                if (e.KeyCode == Keys.Escape)
                {// Escapeキーが押された場合
                    m_csGraphicsManager.ClearSelectionList();

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    //プロパティ一覧選択状態解除
                    PropertyListSelectionClear(0);

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_DRAW_LINE;

                    e.Handled = true;
                }
            }
            else if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
            {// 表示位置スクロールモードの場合
                if (e.KeyCode == Keys.Escape)
                {// Escapeキーが押された場合
                    // セレクトモード設定
                    ObjectSelect(null, null);

                    e.Handled = true;
                }
                else if (e.KeyCode == Keys.Up)
                {// 上キーが押された場合
                    //表示位置スクロール
                    DisplayPositionScroll(0, -m_csCustomInfo.GetMovementRate2());

                    e.Handled = true;
                }
                else if (e.KeyCode == Keys.Right)
                {// 右キーが押された場合
                    //表示位置スクロール
                    DisplayPositionScroll(m_csCustomInfo.GetMovementRate2(), 0);

                    e.Handled = true;
                }
                else if (e.KeyCode == Keys.Down)
                {// 下キーが押された場合
                    //表示位置スクロール
                    DisplayPositionScroll(0, m_csCustomInfo.GetMovementRate2());

                    e.Handled = true;
                }
                else if (e.KeyCode == Keys.Left)
                {// 左キーが押された場合
                    //表示位置スクロール
                    DisplayPositionScroll(-m_csCustomInfo.GetMovementRate2(), 0);

                    e.Handled = true;
                }
                m_iVScroll = (m_pDispPoint.Y - m_iScrollTop) * (VScrollBar.Maximum - VScrollBar.LargeChange) / (m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale);
                m_iHScroll = (m_pDispPoint.X - m_iScrollLeft) * (HScrollBar.Maximum - HScrollBar.LargeChange) / (m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale);
                VScrollBar.Value = m_iVScroll;
                HScrollBar.Value = m_iHScroll;
            }
            else
            {// その他の場合
                if (e.KeyCode == Keys.Escape)
                {// Escapeキーが押された場合
                    // セレクトモード設定
                    ObjectSelect(null, null);

                    e.Handled = true;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>キーダウンイベント前処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PreviewKeyDownEventControl(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PreviewKeyDownEventControl(object sender, PreviewKeyDownEventArgs e)
        {
            switch (e.KeyCode)
            {// キーにより分岐
                case Keys.Tab:
                    //TABキーを画面処理指定
                    e.IsInputKey = true;
                    break;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>セレクトスキップ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SelectSkip()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectSkip()
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();
            List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();

            if (csElmList.Count > 0)
            {// 要素数が０より大きい場合
                if (csSelectList.Count == 0)
                {// 選択要素数が０の場合
                    //選択要素無しはリストの最初を選択
                    m_csGraphicsManager.AddSelectionList(csElmList[0]);
                }
                else
                {// 選択要素数が０以外の場合
                    //選択中要素のひとつ後を選択
                    int iTemp = 0;
                    for (int iLp1 = 0; iLp1 < csSelectList.Count; iLp1++)
                    {// 選択要素数ループ
                        for (int iLp2 = 0; iLp2 < csElmList.Count; iLp2++)
                        {// 要素数ループ
                            if (csElmList[iLp2].GetID().Equals(csSelectList[iLp1].GetID()) == true)
                            {// IDが一致した場合
                                if (iLp2 > iTemp)
                                {// 記憶した選択位置が前の場合
                                    iTemp = iLp2;
                                }
                                break;
                            }
                        }
                    }

                    iTemp++;

                    if (iTemp >= csElmList.Count)
                    {// 記憶した選択位置が要素数より大きい場合
                        iTemp = 0;
                    }

                    m_csGraphicsManager.ClearSelectionList();

                    m_csGraphicsManager.AddSelectionList(csElmList[iTemp]);

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
                }
            }

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            // ボタン活性／非活性設定
            ButtonEnabledSet();
        }

        /// <summary><para>method outline:</para>
        /// <para>セレクトリバーススキップ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SelectReverseSkip()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectReverseSkip()
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();
            List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();

            if (csElmList.Count > 0)
            {// 要素数が０より大きい場合
                if (csSelectList.Count == 0)
                {// 選択要素数が０の場合
                    //選択要素無しはリストの最後を選択
                    m_csGraphicsManager.AddSelectionList(csElmList[csElmList.Count - 1]);
                }
                else
                {// 選択要素数が０以外の場合
                    //選択中要素のひとつ前を選択
                    int iTemp = csElmList.Count - 1;
                    for (int iLp1 = 0; iLp1 < csSelectList.Count; iLp1++)
                    {// 選択要素数ループ
                        for (int iLp2 = 0; iLp2 < csElmList.Count; iLp2++)
                        {// 要素数ループ
                            if (csElmList[iLp2].GetID().Equals(csSelectList[iLp1].GetID()) == true)
                            {// IDが一致した場合
                                if (iLp2 < iTemp)
                                {// 記憶した選択位置が後の場合
                                    iTemp = iLp2;
                                }
                                break;
                            }
                        }
                    }

                    iTemp--;

                    if (iTemp < 0)
                    {// 記憶した選択位置が０より小さい場合
                        iTemp = csElmList.Count - 1;
                    }

                    m_csGraphicsManager.ClearSelectionList();

                    m_csGraphicsManager.AddSelectionList(csElmList[iTemp]);

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
                }
            }

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            // ボタン活性／非活性設定
            ButtonEnabledSet();
        }

        /// <summary><para>method outline:</para>
        /// <para>外部接続受信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ExternalConnectionReceive(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ExternalConnectionReceive(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                if (TabControl.SelectedIndex == 0)
                {// 全体系タブ表示の場合
                    return;
                }

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                //中継端子生成
                McGraphicsElement csRelayPort = m_csGraphicsManager.AddRelayPort(McDefine.SymbolDrawKind.HYM_TRANS_IN);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                if (csRelayPort != null)
                {// 中継端子生成成功の場合
                    m_csGraphicsManager.ClearSelectionList();

                    m_csGraphicsManager.AddSelectionList(csRelayPort);

                    // リスト部編集
                    PropertyListEdit(4, false);

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.PORT |
                                McDefine.LayerKind.LINE |
                                McDefine.LayerKind.ID |
                                McDefine.LayerKind.NAME |
                                McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    //復元データ編集
                    McHistoryData csHistoryData = new McHistoryData();
                    csHistoryData.Kind = McHistoryData.OperationKind.EXTERNAL_CONNECTION_RECEIVE;
                    m_csHistoryDataWork = new List<object>();
                    csRelayPort = csRelayPort.CopyInfUsedByUndoRedoOnly(null);
                    m_csHistoryDataWork.Add(csRelayPort);
                    List<McGraphicsElement> csLineList = ((McGraphicsGroupElement)m_csDispElmList[TabControl.SelectedIndex][0]).GetGroupLineElementList();
                    HySIdentifier csFromPortID = null;
                    HySIdentifier csToPortID = null;
                    McGraphicsElement csLine = null;
                    McGraphicsElement csPort = null;
                    for (int iLp = 0; iLp < csLineList.Count; iLp++)
                    {// 接続線数ループ
                        csLine = csLineList[iLp];
                        csLine.GetPortID(ref csFromPortID, ref csToPortID);
                        if (csFromPortID.Equals(csRelayPort.GetID()) == true)
                        {// IDが一致した場合
                            csPort = csLine.GetPort(csToPortID);
                            break;
                        }
                    }
                    csLine = csLine.CopyInfUsedByUndoRedoOnly(null);
                    m_csHistoryDataWork.Add(csLine);
                    csPort = csPort.CopyInfUsedByUndoRedoOnly(null);
                    m_csHistoryDataWork.Add(csPort);
                    csHistoryData.HistoryData = m_csHistoryDataWork;

                    //復元ポイント記録
                    ReconstructionPointSave(true, csHistoryData);

                    // モデル管理ガイドマップ再描画
                    SimpleMapReDraw();

                    // ボタン活性／非活性設定
                    ButtonEnabledSet();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>外部接続送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ExternalConnectionSend(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ExternalConnectionSend(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                if (TabControl.SelectedIndex == 0)
                {// 全体系タブ表示の場合
                    return;
                }

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                //中継端子生成
                McGraphicsElement csRelayPort = m_csGraphicsManager.AddRelayPort(McDefine.SymbolDrawKind.HYM_TRANS_OUT);

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }

                if (csRelayPort != null)
                {// 中継端子生成成功の場合
                    m_csGraphicsManager.ClearSelectionList();

                    m_csGraphicsManager.AddSelectionList(csRelayPort);

                    // リスト部編集
                    PropertyListEdit(4, false);

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.PORT |
                                McDefine.LayerKind.LINE |
                                McDefine.LayerKind.ID |
                                McDefine.LayerKind.NAME |
                                McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    //復元データ編集
                    McHistoryData csHistoryData = new McHistoryData();
                    csHistoryData.Kind = McHistoryData.OperationKind.EXTERNAL_CONNECTION_SEND;
                    m_csHistoryDataWork = new List<object>();
                    csRelayPort = csRelayPort.CopyInfUsedByUndoRedoOnly(null);
                    m_csHistoryDataWork.Add(csRelayPort);
                    List<McGraphicsElement> csLineList = ((McGraphicsGroupElement)m_csDispElmList[TabControl.SelectedIndex][0]).GetGroupLineElementList();
                    HySIdentifier csFromPortID = null;
                    HySIdentifier csToPortID = null;
                    McGraphicsElement csLine = null;
                    McGraphicsElement csPort = null;
                    for (int iLp = 0; iLp < csLineList.Count; iLp++)
                    {// 接続線数ループ
                        csLine = csLineList[iLp];
                        csLine.GetPortID(ref csFromPortID, ref csToPortID);
                        if (csToPortID.Equals(csRelayPort.GetID()) == true)
                        {// IDが一致した場合
                            csPort = csLine.GetPort(csFromPortID);
                            break;
                        }
                    }
                    csLine = csLine.CopyInfUsedByUndoRedoOnly(null);
                    m_csHistoryDataWork.Add(csLine);
                    csPort = csPort.CopyInfUsedByUndoRedoOnly(null);
                    m_csHistoryDataWork.Add(csPort);
                    csHistoryData.HistoryData = m_csHistoryDataWork;

                    //復元ポイント記録
                    ReconstructionPointSave(true, csHistoryData);

                    // モデル管理ガイドマップ再描画
                    SimpleMapReDraw();

                    // ボタン活性／非活性設定
                    ButtonEnabledSet();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示クローズ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LineGraphScreenClose(csElmentID)</para>
        /// </example>
        /// <param name="csElmentID">表示要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LineGraphScreenClose(HySIdentifier csElmentID)
        {
            bool bMatchFlg = false;

            for (int iLp = 0; iLp < m_csDispElmList[0].Count; iLp++)
            {// 要素数ループ
                if (m_csDispElmList[0][iLp].GetID().Equals(csElmentID) == true)
                {// IDが一致した場合
                    if (m_csDispElmList[0][iLp].GetElementDisplayMode() == true)
                    {// 画面表示中の場合
                        m_csDispElmList[0][iLp].SetElementDisplayMode(false);
                        bMatchFlg = true;
                    }
                    break;
                }
                if ((m_csDispElmList[0][iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP) ||
                    (m_csDispElmList[0][iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                {// グループ要素の場合
                    // 画面表示クローズ要求
                    bMatchFlg = LineGraphScreenClose((McGraphicsGroupElement)m_csDispElmList[0][iLp], csElmentID);
                    if (bMatchFlg == true)
                    {//　クローズ対象があった場合
                        break;
                    }
                }
            }
            if (bMatchFlg == true)
            {// 画面クローズの場合
                // リスト部編集
                PropertyListEdit(3, false);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示クローズ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = LineGraphScreenClose(csElement, csElmentID)</para>
        /// </example>
        /// <param name="csElement">グループ要素</param>
        /// <param name="csElmentID">表示要素ID</param>
        /// <returns>bool　true：表示要素有り　false：表示要素無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool LineGraphScreenClose(McGraphicsGroupElement csElement, HySIdentifier csElmentID)
        {
            bool bRtnMatchFlg = false;

            for (int iLp = 0; iLp < csElement.GetElmCount(); iLp++)
            {// グループ内要素数ループ
                if (csElement.GetElement(iLp).GetID().Equals(csElmentID) == true)
                {// IDが一致した場合
                    if (csElement.GetElement(iLp).GetElementDisplayMode() == true)
                    {// 画面表示中の場合
                        csElement.GetElement(iLp).SetElementDisplayMode(false);
                        bRtnMatchFlg = true;
                    }
                    break;
                }
                if ((csElement.GetElement(iLp).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP) ||
                    (csElement.GetElement(iLp).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                {// グループ要素の場合
                    // 画面表示クローズ要求
                    bRtnMatchFlg = LineGraphScreenClose((McGraphicsGroupElement)csElement.GetElement(iLp), csElmentID);
                    if (bRtnMatchFlg == true)
                    {//　クローズ対象があった場合
                        break;
                    }
                }
            }
            return bRtnMatchFlg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示クローズ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LineGraphScreenClose()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LineGraphScreenClose()
        {
            List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();

            bool bChangeFlg = false;

            for (int iLp = 0; iLp < csSelectList.Count; iLp++)
            {// 選択要素数ループ
                if ((csSelectList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                    (csSelectList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                {// 出力要素の場合
                    if (csSelectList[iLp].GetElementDisplayMode() == true)
                    {// 画面表示中の場合
                        csSelectList[iLp].SetElementDisplayMode(false);

                        // 画面表示クローズ要求
                        ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenCloseEvent(csSelectList[iLp].GetID());

                        bChangeFlg = true;
                    }
                }
            }
            if (bChangeFlg == true)
            {// 画面クローズの場合
                // リスト部編集
                PropertyListEdit(3, false);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示クローズ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropetyScreenClose()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropetyScreenClose()
        {
            List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();

            for (int iLp = 0; iLp < csSelectList.Count; iLp++)
            {// 選択要素数ループ
                // 画面表示クローズ要求
                PropetyScreenClose(csSelectList[iLp].GetID());
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示クローズ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropetyScreenClose(csElmentID)</para>
        /// </example>
        /// <param name="csElmentID">表示要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropetyScreenClose(HySIdentifier csElmentID)
        {
            // 画面表示クローズ要求
            ((McDotNetModelCtlScreen)m_csScreen).PropetyScreenClose(csElmentID);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropetyScreenRefreshment(csElmentID)</para>
        /// </example>
        /// <param name="csElmentID">表示要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropetyScreenRefreshment(HySIdentifier csElmentID)
        {
            // 画面表示リフレッシュ要求
            ((McDotNetModelCtlScreen)m_csScreen).RefreshmentPropety(csElmentID);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ID表示タイプ変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>IDTypeChange(sender, e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void IDTypeChange(object sender, EventArgs e)
        {
            // ID表示タイプ変更
            if (IDTypeButton.Checked == false)
            {// IDショート表示の場合
                IDTypeButton.Checked = true;
                TabPage1DataGridView1.Columns[TabPage1Column10.Name].Visible = true;
                TabPage1DataGridView1.Columns[TabPage1Column11.Name].Visible = false;
                TabPage1DataGridView2.Columns[TabPage1Column20.Name].Visible = true;
                TabPage1DataGridView2.Columns[TabPage1Column21.Name].Visible = false;
                TabPage1DataGridView3.Columns[TabPage1Column30.Name].Visible = true;
                TabPage1DataGridView3.Columns[TabPage1Column31.Name].Visible = false;
                TabPage1DataGridView4.Columns[TabPage1Column40.Name].Visible = true;
                TabPage1DataGridView4.Columns[TabPage1Column41.Name].Visible = false;
                TabPage1DataGridView4.Columns[TabPage1Column42.Name].Visible = true;
                TabPage1DataGridView4.Columns[TabPage1Column43.Name].Visible = false;
                TabPage1DataGridView4.Columns[TabPage1Column46.Name].Visible = true;
                TabPage1DataGridView4.Columns[TabPage1Column47.Name].Visible = false;
                TabPage1DataGridView5.Columns[TabPage1Column50.Name].Visible = true;
                TabPage1DataGridView5.Columns[TabPage1Column51.Name].Visible = false;
                m_csGraphicsManager.SetIDDispMode(true);
            }
            else
            {// IDフル表示の場合
                IDTypeButton.Checked = false;
                TabPage1DataGridView1.Columns[TabPage1Column10.Name].Visible = false;
                TabPage1DataGridView1.Columns[TabPage1Column11.Name].Visible = true;
                TabPage1DataGridView2.Columns[TabPage1Column20.Name].Visible = false;
                TabPage1DataGridView2.Columns[TabPage1Column21.Name].Visible = true;
                TabPage1DataGridView3.Columns[TabPage1Column30.Name].Visible = false;
                TabPage1DataGridView3.Columns[TabPage1Column31.Name].Visible = true;
                TabPage1DataGridView4.Columns[TabPage1Column40.Name].Visible = false;
                TabPage1DataGridView4.Columns[TabPage1Column41.Name].Visible = true;
                TabPage1DataGridView4.Columns[TabPage1Column42.Name].Visible = false;
                TabPage1DataGridView4.Columns[TabPage1Column43.Name].Visible = true;
                TabPage1DataGridView4.Columns[TabPage1Column46.Name].Visible = false;
                TabPage1DataGridView4.Columns[TabPage1Column47.Name].Visible = true;
                TabPage1DataGridView5.Columns[TabPage1Column50.Name].Visible = false;
                TabPage1DataGridView5.Columns[TabPage1Column51.Name].Visible = true;
                m_csGraphicsManager.SetIDDispMode(false);
            }

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ID, true, true);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>レイヤークリア</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LayerClear(eClearKind)</para>
        /// </example>
        /// <param name="eClearKind">クリアー区分</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LayerClear(McDefine.LayerKind eClearKind)
        {
            Graphics csGraphics;

            if (eClearKind != McDefine.LayerKind.NONE)
            {// クリアレイヤーありの場合
                if ((eClearKind & McDefine.LayerKind.ELEMENT) != 0)
                {// 要素レイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerElement.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.LINE) != 0)
                {// 接続線レイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerLine.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.PORT) != 0)
                {// 端子レイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerPort.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.NAME) != 0)
                {// 名称レイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerName.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.ID) != 0)
                {// IDレイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerID.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.ELEMENT_SELECT) != 0)
                {// 要素セレクトレイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerElementSelect.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.LINE_SELECT) != 0)
                {// 接続線セレクトレイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerLineSelect.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.PORT_SELECT) != 0)
                {// 端子セレクトレイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerPortSelect.Image);
                    csGraphics.Clear(Color.Transparent);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.MOVE) != 0)
                {// 移動レイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerMove.Image);
                    csGraphics.Clear(Color.LightGoldenrodYellow);
                    csGraphics.Dispose();
                }
                if ((eClearKind & McDefine.LayerKind.MOVE_TEMP) != 0)
                {// 移動用テンプレイヤーの場合
                    // レイヤークリア
                    csGraphics = Graphics.FromImage(LayerMoveTemp.Image);
                    csGraphics.Clear(Color.LightGoldenrodYellow);
                    csGraphics.Dispose();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>描画処理ON/OFF判定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckModelDispOff( csStruct )</para>
        /// <param name="csStruct">モデル構造情報</param>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CheckModelDispOff(McStructInfo csStruct)
        {
            m_bModelDispOffFlg = false;
            if (csStruct != null)
            {
                HySString csString = HySEnvInf.GetEnvInf("HYMCO_MODEL_DISPLAY_OFF");
                if ((object)csString != null)
                {
                    if (csString.Equal(new HySString("true")) == true)
                    {
                        csString = HySEnvInf.GetEnvInf("HYMCO_MODEL_DISPLAY_OFF_ELEMENT_NUMBER");
                        long lMxElm = 500;
                        if ((object)csString != null)
                        {// 設定値有り
                            try
                            {
                                lMxElm = Convert.ToInt32(csString.ToString());
                            }
                            catch
                            {// 数値変換不可
                                lMxElm = 500;
                            }
                        }

                        if (csStruct.HowManyElement() >= lMxElm)
                        {
                            // 描画OFFが有効で指定要素数以上の場合、描画しない
                            m_bModelDispOffFlg = true;
                            LayerClear(McDefine.LayerKind.ELEMENT |
                                        McDefine.LayerKind.PORT |
                                        McDefine.LayerKind.LINE |
                                        McDefine.LayerKind.ID |
                                        McDefine.LayerKind.NAME |
                                        McDefine.LayerKind.ELEMENT_SELECT |
                                        McDefine.LayerKind.PORT_SELECT |
                                        McDefine.LayerKind.LINE_SELECT);
                            // 下記にて、描画エリアがリフレッシュされる
                            LayerRubberBand.Refresh();
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>レイヤー再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LayerReDraw(eReDrawKind, bClearFlg, bRefreshFlg)</para>
        /// </example>
        /// <param name="eReDrawKind">再描画区分</param>
        /// <param name="bClearFlg">クリアフラグ</param>
        /// <param name="bRefreshFlg">リフレッシュフラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LayerReDraw(McDefine.LayerKind eReDrawKind, bool bClearFlg, bool bRefreshFlg)
        {
            // 操作性改善（描画オフ処理）
            if (m_bModelDispOffFlg == true && eReDrawKind != McDefine.LayerKind.MOVE)
            {
                // 移動モード時は移動モードレイヤーのみ再描画
                return;
            }

            Graphics csGraphics;

            if (eReDrawKind != McDefine.LayerKind.NONE)
            {// 再描画レイヤーありの場合
                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.WaitCursor;
                }

                if (bClearFlg == true)
                {// クリア指定の場合
                    // レイヤークリア
                    LayerClear(eReDrawKind);
                }

                int iImageX = m_pDispPoint.X * (int)m_lDispScale / 100;
                int iImageY = m_pDispPoint.Y * (int)m_lDispScale / 100;

                if ((eReDrawKind & McDefine.LayerKind.ELEMENT) != 0)
                {// 要素レイヤーの場合
                    csGraphics = Graphics.FromImage(LayerElement.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawObjectElement(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.LINE) != 0)
                {// 接続線レイヤーの場合
                    csGraphics = Graphics.FromImage(LayerLine.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawObjectLine(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.PORT) != 0)
                {// 端子レイヤーの場合
                    csGraphics = Graphics.FromImage(LayerPort.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawObjectPort(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.NAME) != 0)
                {// 名称レイヤーの場合
                    csGraphics = Graphics.FromImage(LayerName.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawObjectName(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.ID) != 0)
                {// IDレイヤーの場合
                    csGraphics = Graphics.FromImage(LayerID.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawObjectID(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.ELEMENT_SELECT) != 0)
                {// 要素セレクトレイヤーの場合
                    csGraphics = Graphics.FromImage(LayerElementSelect.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawSelectElement(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.LINE_SELECT) != 0)
                {// 接続線セレクトレイヤーの場合
                    csGraphics = Graphics.FromImage(LayerLineSelect.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawSelectLine(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.PORT_SELECT) != 0)
                {// 端子セレクトレイヤーの場合
                    csGraphics = Graphics.FromImage(LayerPortSelect.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawSelectPort(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.MOVE) != 0)
                {// 移動レイヤーの場合
                    csGraphics = Graphics.FromImage(LayerMove.Image);

                    if (m_bModelDispOffFlg != true)
                    {// 移動モード時で描画OFFの場合、再描画実施しない
                        // グラフィックの再描画
                        m_csGraphicsManager.DrawObjectElement(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                        m_csGraphicsManager.DrawObjectLine(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                        m_csGraphicsManager.DrawObjectPort(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                        if (LayerName.Visible == true)
                        {// 名称レイヤー表示中の場合
                            m_csGraphicsManager.DrawObjectName(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                        }
                        if (LayerID.Visible == true)
                        {// IDレイヤー表示中の場合
                            m_csGraphicsManager.DrawObjectID(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                        }
                    }

                    csGraphics.Dispose();
                }
                if ((eReDrawKind & McDefine.LayerKind.MOVE_TEMP) != 0)
                {// 移動用テンプレイヤーの場合
                    csGraphics = Graphics.FromImage(LayerMoveTemp.Image);

                    // グラフィックの再描画
                    m_csGraphicsManager.DrawObjectElement(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                    m_csGraphicsManager.DrawObjectLine(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                    m_csGraphicsManager.DrawObjectPort(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                    if (LayerName.Visible == true)
                    {// 名称レイヤー表示中の場合
                        m_csGraphicsManager.DrawObjectName(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                    }
                    if (LayerID.Visible == true)
                    {// IDレイヤー表示中の場合
                        m_csGraphicsManager.DrawObjectID(csGraphics, iImageX, iImageY, m_pReDrawPoint.X, m_pReDrawPoint.Y, m_iReDrawWidth, m_iReDrawHeight);
                    }

                    csGraphics.Dispose();
                }

                // レイヤーリフレッシュ
                if (bRefreshFlg == true)
                {// リフレッシュ指定の場合
                    if ((eReDrawKind & McDefine.LayerKind.ELEMENT) != 0)
                    {// 要素レイヤーの場合
                        LayerElement.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.LINE) != 0)
                    {// 接続線レイヤーの場合
                        LayerLine.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.PORT) != 0)
                    {// 端子レイヤーの場合
                        LayerPort.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.NAME) != 0)
                    {// 名称レイヤーの場合
                        LayerName.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.ID) != 0)
                    {// IDレイヤーの場合
                        LayerID.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.ELEMENT_SELECT) != 0)
                    {// 要素セレクトレイヤーの場合
                        LayerElementSelect.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.LINE_SELECT) != 0)
                    {// 接続線セレクトレイヤーの場合
                        LayerLineSelect.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.PORT_SELECT) != 0)
                    {// 端子セレクトレイヤーの場合
                        LayerPortSelect.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.MOVE) != 0)
                    {// 移動レイヤーの場合
                        LayerMove.Refresh();
                    }
                    else if ((eReDrawKind & McDefine.LayerKind.MOVE_TEMP) != 0)
                    {// 移動用テンプレイヤーの場合
                        LayerMoveTemp.Refresh();
                    }
                }

                // カーソルをデフォルトにする。
                if (this.MdiParent != null)
                {// 親フォームがある場合
                    this.MdiParent.Cursor = Cursors.Default;
                }
                else
                {// 親フォームがない場合
                    this.Cursor = Cursors.Default;
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>コントロールリサイズ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ControlResize(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ControlResize(object sender, EventArgs e)
        {
            if (TabPage1Panel.BackgroundImage == null)
            {// TabPage1Panel未生成時には、処理無し
                return;
            }
            //背景画像セット右下表示
            if (LayerRubberBand.Width > 0 && LayerRubberBand.Height > 0)
            {
                TabPage1Panel.BackgroundImage.Dispose();
                TabPage1Panel.BackgroundImage = new Bitmap(LayerRubberBand.Width, LayerRubberBand.Height);
                HySFile csFile = new HySFile(HySEnvInf.GetHomeDirectory().ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE_FOLDER")).ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE")).ToString());
                if (csFile.Exist() == true)
                {// ファイルがある場合
                    Graphics csGraphics = Graphics.FromImage(TabPage1Panel.BackgroundImage);
                    Bitmap csBackgroundImage = new Bitmap(HySEnvInf.GetHomeDirectory().ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE_FOLDER")).ToString()
                        + HySEnvInf.GetEnvInf(new HySString("MCMODEL_BG_IMAGE")).ToString());
                    csGraphics.DrawImage(csBackgroundImage, new Point(LayerRubberBand.Width - csBackgroundImage.Width, LayerRubberBand.Height - csBackgroundImage.Height));
                    csGraphics.Dispose();
                    csBackgroundImage.Dispose();
                }

                // 各レイヤーのイメージ再設定
                m_iWidth = LayerRubberBand.Width;
                m_iHeight = LayerRubberBand.Height;
                PictureBox[] csPictBox = { LayerElement, LayerPort, LayerLine, LayerID, LayerName, LayerElementSelect, LayerPortSelect, LayerLineSelect, LayerMoveTemp };
                foreach (PictureBox csPB in csPictBox)
                {// レイヤー数ループ
                    csPB.Image.Dispose();
                    csPB.Image = new Bitmap(m_iWidth, m_iHeight);
                }
                LayerRubberBand.Image.Dispose();
                LayerRubberBand.Image = new Bitmap(m_iWidth, m_iHeight);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                // モードチェック
                if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
                {// 表示位置スクロールモードの場合
                    LayerMove.Size = new Size((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                    LayerMove.Image.Dispose();
                    LayerMove.Image = new Bitmap((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                    LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));

                    //編集領域設定
                    Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
                    m_pDispPoint.X = m_pDispPoint.X - (int)(m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                    m_pDispPoint.Y = m_pDispPoint.Y - (int)(m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                    int iOffsetX = pTempPoint.X * (int)m_lDispScale / 100 - (m_pDispPoint.X * (int)m_lDispScale / 100 + (int)(m_iWidth * (IMAGE_SIZE_RATIO - 1) / 2));
                    int iOffsetY = pTempPoint.Y * (int)m_lDispScale / 100 - (m_pDispPoint.Y * (int)m_lDispScale / 100 + (int)(m_iHeight * (IMAGE_SIZE_RATIO - 1) / 2));
                    Point pWork = LayerMove.Location;
                    pWork.X -= iOffsetX;
                    pWork.Y -= iOffsetY;
                    LayerMove.Location = pWork;
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / m_lDispScale);
                    m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / m_lDispScale);

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.MOVE, true, true);

                    m_pDispPoint.X = pTempPoint.X;
                    m_pDispPoint.Y = pTempPoint.Y;
                }

                // モデル管理ガイドマップ再描画
                if (m_csSimpleMap != null)
                {// モデル管理ガイドマップ表示中の場合
                    m_csSimpleMap.LayerSizeChange(m_iWidth, m_iHeight);
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示位置スクロール</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DisplayPositionScroll(iWidth, iHeight)</para>
        /// </example>
        /// <param name="iWidth">移動量幅</param>
        /// <param name="iHeight">移動量高さ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DisplayPositionScroll(int iWidth, int iHeight)
        {
            m_pDispPoint.X = m_pDispPoint.X - iWidth * 100 / (int)m_lDispScale;
            m_pDispPoint.Y = m_pDispPoint.Y - iHeight * 100 / (int)m_lDispScale;
            m_pDispPointList[TabControl.SelectedIndex] = m_pDispPoint;

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.MOVE_TEMP, true, true);

            LayerMoveTemp.Location = new Point(0, 0);
            LayerMoveTemp.Size = new Size(m_iWidth, m_iHeight);

            if (LayerMove.Image == null)
            {// 移動レイヤーにイメージがない場合
                LayerMove.Image = new Bitmap((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
            }
            LayerClear(McDefine.LayerKind.MOVE);
            LayerMove.Refresh();
            LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));

            //編集領域設定
            Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
            m_pDispPoint.X = m_pDispPoint.X - (int)(m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
            m_pDispPoint.Y = m_pDispPoint.Y - (int)(m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
            int iOffsetX = pTempPoint.X * (int)m_lDispScale / 100 - (m_pDispPoint.X * (int)m_lDispScale / 100 + (int)(m_iWidth * (IMAGE_SIZE_RATIO - 1) / 2));
            int iOffsetY = pTempPoint.Y * (int)m_lDispScale / 100 - (m_pDispPoint.Y * (int)m_lDispScale / 100 + (int)(m_iHeight * (IMAGE_SIZE_RATIO - 1) / 2));
            Point pWork = LayerMove.Location;
            pWork.X -= iOffsetX;
            pWork.Y -= iOffsetY;
            LayerMove.Location = pWork;
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / (int)m_lDispScale);
            m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / (int)m_lDispScale);

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.MOVE, true, true);

            LayerMoveTemp.Size = new Size(5, 5);
            LayerMoveTemp.Location = new Point(-10, -10);

            m_pDispPoint.X = pTempPoint.X;
            m_pDispPoint.Y = pTempPoint.Y;

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.PORT |
                        McDefine.LayerKind.LINE |
                        McDefine.LayerKind.ID |
                        McDefine.LayerKind.NAME |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            // モデル管理ガイドマップ再描画
            if (m_csSimpleMap != null)
            {// モデル管理ガイドマップ表示中の場合
                m_csSimpleMap.DispPointChange(m_pDispPoint);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウスポインタが離れた時のイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseLeave(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseLeave(object sender, EventArgs e)
        {
            // カーソル設定
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
            {// 表示位置スクロールモードの場合
                this.Cursor = new Cursor(HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_CURSOR_FOLDER")).ToString() + "HArrow.cur");
            }
            else
            {// 表示位置スクロールモード以外の場合
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系表示タブ左端へ移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartDispLeftEnd( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartDispLeftEnd(object sender, EventArgs e)
        {
            //選択インデックス取得
            int iIndex = TabControl.SelectedIndex;

            //入れ替えタブ名称取得
            String sTabName1 = TabControl.TabPages[iIndex].Text;

            for (int iLp = iIndex - 1; iLp > 0; iLp--)
            {// 入れ替えタブ数ループ
                TabControl.TabPages[iLp + 1].Text = TabControl.TabPages[iLp].Text;
            }
            TabControl.TabPages[1].Text = sTabName1;

            //タブ情報を移動先に挿入
            m_csDispElmList.Insert(1, m_csDispElmList[iIndex]);
            m_lDispScaleList.Insert(1, m_lDispScaleList[iIndex]);
            m_iPropertyListSortColumnIndexList.Insert(1, m_iPropertyListSortColumnIndexList[iIndex]);
            m_pDispPointList.Insert(1, m_pDispPointList[iIndex]);

            m_pScrollLeftTop.Insert(1, m_pScrollLeftTop[iIndex]);
            m_pScrollRightBottom.Insert(1, m_pScrollRightBottom[iIndex]);
            m_pEditLeftTop.Insert(1, m_pEditLeftTop[iIndex]);
            m_pEditRightBottom.Insert(1, m_pEditRightBottom[iIndex]);

            //移動元タブ情報を削除
            m_csDispElmList.RemoveAt(iIndex + 1);
            m_lDispScaleList.RemoveAt(iIndex + 1);
            m_iPropertyListSortColumnIndexList.RemoveAt(iIndex + 1);
            m_pDispPointList.RemoveAt(iIndex + 1);

            m_pScrollLeftTop.RemoveAt(iIndex + 1);
            m_pScrollRightBottom.RemoveAt(iIndex + 1);
            m_pEditLeftTop.RemoveAt(iIndex + 1);
            m_pEditRightBottom.RemoveAt(iIndex + 1);

            TabControl.SelectedIndex = 1;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系表示タブ左へ移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartDispLeft( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartDispLeft(object sender, EventArgs e)
        {
            //選択インデックス取得
            int iIndex = TabControl.SelectedIndex;

            //入れ替えタブ名称取得
            String sTabName1 = TabControl.TabPages[iIndex].Text;
            String sTabName2 = TabControl.TabPages[iIndex - 1].Text;

            TabControl.TabPages[iIndex].Text = sTabName2;
            TabControl.TabPages[iIndex - 1].Text = sTabName1;

            //タブ情報を移動先に挿入
            m_csDispElmList.Insert(iIndex - 1, m_csDispElmList[iIndex]);
            m_lDispScaleList.Insert(iIndex - 1, m_lDispScaleList[iIndex]);
            m_iPropertyListSortColumnIndexList.Insert(iIndex - 1, m_iPropertyListSortColumnIndexList[iIndex]);
            m_pDispPointList.Insert(iIndex - 1, m_pDispPointList[iIndex]);

            m_pScrollLeftTop.Insert(iIndex - 1, m_pScrollLeftTop[iIndex]);
            m_pScrollRightBottom.Insert(iIndex - 1, m_pScrollRightBottom[iIndex]);
            m_pEditLeftTop.Insert(iIndex - 1, m_pEditLeftTop[iIndex]);
            m_pEditRightBottom.Insert(iIndex - 1, m_pEditRightBottom[iIndex]);

            //移動元タブ情報を削除
            m_csDispElmList.RemoveAt(iIndex + 1);
            m_lDispScaleList.RemoveAt(iIndex + 1);
            m_iPropertyListSortColumnIndexList.RemoveAt(iIndex + 1);
            m_pDispPointList.RemoveAt(iIndex + 1);

            m_pScrollLeftTop.RemoveAt(iIndex + 1);
            m_pScrollRightBottom.RemoveAt(iIndex + 1);
            m_pEditLeftTop.RemoveAt(iIndex + 1);
            m_pEditRightBottom.RemoveAt(iIndex + 1);

            TabControl.SelectedIndex = iIndex - 1;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系表示タブ右へ移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartDispRight( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartDispRight(object sender, EventArgs e)
        {
            //選択インデックス取得
            int iIndex = TabControl.SelectedIndex;

            //入れ替えタブ名称取得
            String sTabName1 = TabControl.TabPages[iIndex].Text;
            String sTabName2 = TabControl.TabPages[iIndex + 1].Text;

            TabControl.TabPages[iIndex].Text = sTabName2;
            TabControl.TabPages[iIndex + 1].Text = sTabName1;

            //タブ情報を移動先に挿入
            m_csDispElmList.Insert(iIndex + 2, m_csDispElmList[iIndex]);
            m_lDispScaleList.Insert(iIndex + 2, m_lDispScaleList[iIndex]);
            m_iPropertyListSortColumnIndexList.Insert(iIndex + 2, m_iPropertyListSortColumnIndexList[iIndex]);
            m_pDispPointList.Insert(iIndex + 2, m_pDispPointList[iIndex]);

            m_pScrollLeftTop.Insert(iIndex + 2, m_pScrollLeftTop[iIndex]);
            m_pScrollRightBottom.Insert(iIndex + 2, m_pScrollRightBottom[iIndex]);
            m_pEditLeftTop.Insert(iIndex + 2, m_pEditLeftTop[iIndex]);
            m_pEditRightBottom.Insert(iIndex + 2, m_pEditRightBottom[iIndex]);

            //移動元タブ情報を削除
            m_csDispElmList.RemoveAt(iIndex);
            m_lDispScaleList.RemoveAt(iIndex);
            m_iPropertyListSortColumnIndexList.RemoveAt(iIndex);
            m_pDispPointList.RemoveAt(iIndex);

            m_pScrollLeftTop.RemoveAt(iIndex);
            m_pScrollRightBottom.RemoveAt(iIndex);
            m_pEditLeftTop.RemoveAt(iIndex);
            m_pEditRightBottom.RemoveAt(iIndex);

            TabControl.SelectedIndex = iIndex + 1;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>部分系表示タブ右端へ移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PartDispRightEnd( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PartDispRightEnd(object sender, EventArgs e)
        {
            //選択インデックス取得
            int iIndex = TabControl.SelectedIndex;

            //入れ替えタブ名称取得
            String sTabName1 = TabControl.TabPages[iIndex].Text;

            for (int iLp = iIndex + 1; iLp < TabControl.TabPages.Count; iLp++)
            {// 入れ替えタブ数ループ
                TabControl.TabPages[iLp - 1].Text = TabControl.TabPages[iLp].Text;
            }
            TabControl.TabPages[TabControl.TabPages.Count - 1].Text = sTabName1;

            //タブ情報を移動先に追加
            m_csDispElmList.Add(m_csDispElmList[iIndex]);
            m_lDispScaleList.Add(m_lDispScaleList[iIndex]);
            m_iPropertyListSortColumnIndexList.Add(m_iPropertyListSortColumnIndexList[iIndex]);
            m_pDispPointList.Add(m_pDispPointList[iIndex]);

            m_pScrollLeftTop.Insert(iIndex, m_pScrollLeftTop[iIndex]);
            m_pScrollRightBottom.Insert(iIndex, m_pScrollRightBottom[iIndex]);
            m_pEditLeftTop.Insert(iIndex, m_pEditLeftTop[iIndex]);
            m_pEditRightBottom.Insert(iIndex, m_pEditRightBottom[iIndex]);

            //移動元タブ情報を削除
            m_csDispElmList.RemoveAt(iIndex);
            m_lDispScaleList.RemoveAt(iIndex);
            m_iPropertyListSortColumnIndexList.RemoveAt(iIndex);
            m_pDispPointList.RemoveAt(iIndex);

            m_pScrollLeftTop.RemoveAt(iIndex);
            m_pScrollRightBottom.RemoveAt(iIndex);
            m_pEditLeftTop.RemoveAt(iIndex);
            m_pEditRightBottom.RemoveAt(iIndex);

            TabControl.SelectedIndex = TabControl.TabPages.Count - 1;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タブ右クリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabCtrl_MouseDown( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabCtrl_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {// マウス右クリックの場合
                for (int iLoop = 0; iLoop < TabControl.TabCount; iLoop++)
                {// グループ表示タブ数ループ
                    //タブとマウス位置を比較し、クリックしたタブを選択
                    if (TabControl.GetTabRect(iLoop).Contains(e.X, e.Y))
                    {// 座標が範囲内の場合
                        TabControl.SelectedTab = TabControl.TabPages[iLoop];
                        break;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル管理ガイドマップクローズ処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimpleMapClose( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimpleMapClose()
        {
            if (m_csSimpleMap != null)
            {// モデル管理ガイドマップ表示中の場合
                m_csSimpleMap.Dispose();
                m_csSimpleMap = null;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示編集座標取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Point pPoint = GetDisplyPoint( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Point 表示編集座標</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Point GetDisplyPoint()
        {
            return m_pDispPoint;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示スケール取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lScale = GetDisplyScale( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 表示スケール</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDisplyScale()
        {
            return m_lDispScale;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示レイヤー高さ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>int iLayerHeight = GetLayerHeight( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int 表示レイヤー高さ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int GetLayerHeight()
        {
            return LayerRubberBand.Height;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示レイヤー幅取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>int iLayerWidth = GetLayerWidth( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int 表示レイヤー幅</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int GetLayerWidth()
        {
            return LayerRubberBand.Width;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示エレメントリスト取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>List＜McGraphicsElement＞ csElementList = GetDisplyElementList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>List＜McGraphicsElement＞ 表示エレメントリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<McGraphicsElement> GetDisplyElementList()
        {
            return m_csDispElmList[TabControl.SelectedIndex];
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示ラインリスト取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>List＜McGraphicsElement＞ csLineList = GetDisplyLineList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>List＜McGraphicsElement＞ 表示ラインリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<McGraphicsElement> GetDisplyLineList()
        {
            if (TabControl.SelectedIndex != 0)
            {// グループ内部表示タブ表示中の場合
                return null;
            }

            return m_csDispLineList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル編集画面カスタマイズ情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCustomInfo csCustomInfo = GetCustomInfo( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCustomInfo モデル編集画面カスタマイズ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCustomInfo GetCustomInfo()
        {
            return m_csCustomInfo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示座標変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispPointChange(pDispPoint)</para>
        /// </example>
        /// <param name="pDispPoint">表示座標</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DispPointChange(Point pDispPoint)
        {
            if (pDispPoint.X < m_iScrollLeft)
            {   // 表示座標Xはスクロール左未満
                pDispPoint.X = m_iScrollLeft;
            }
            else if (pDispPoint.X + m_iWidth * 100 / m_lDispScale > m_iScrollRight)
            {   // 表示座標Xはスクロール右を越える
                pDispPoint.X = m_iScrollRight - m_iWidth * 100 / (int)m_lDispScale;
                if (pDispPoint.X < m_iScrollLeft)
                {   // 座標Xがスクロール左未満
                    pDispPoint.X = m_iScrollLeft;
                }
            }
            if (pDispPoint.Y < m_iScrollTop)
            {   // 表示座標Yはスクロール上未満
                pDispPoint.Y = m_iScrollTop;
            }
            else if (pDispPoint.Y + m_iHeight * 100 / m_lDispScale > m_iScrollBottom)
            {   // 表示座標Yはスクロール下を越える
                pDispPoint.Y = m_iScrollBottom - m_iHeight * 100 / (int)m_lDispScale;
                if (pDispPoint.Y < m_iScrollTop)
                {   // 座標Yがスクロール上未満
                    pDispPoint.Y = m_iScrollTop;
                }
            }
            m_pDispPoint = pDispPoint;
            m_pDispPointList[TabControl.SelectedIndex] = pDispPoint;

            // 移動モード確認
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_DISPLAY_POSITION_SCROLL)
            {// 表示位置スクロールモードの場合
                //編集領域設定
                Point pTempPoint = new Point(m_pDispPoint.X, m_pDispPoint.Y);
                m_pDispPoint.X = m_pDispPoint.X - (int)(m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                m_pDispPoint.Y = m_pDispPoint.Y - (int)(m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2) * 100 / m_lDispScale);
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = (int)(m_iWidth * IMAGE_SIZE_RATIO * 100 / m_lDispScale);
                m_iReDrawHeight = (int)(m_iHeight * IMAGE_SIZE_RATIO * 100 / m_lDispScale);

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.MOVE, true, true);

                m_pDispPoint.X = pTempPoint.X;
                m_pDispPoint.Y = pTempPoint.Y;
            }

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.ELEMENT |
                        McDefine.LayerKind.PORT |
                        McDefine.LayerKind.LINE |
                        McDefine.LayerKind.ID |
                        McDefine.LayerKind.NAME |
                        McDefine.LayerKind.ELEMENT_SELECT |
                        McDefine.LayerKind.PORT_SELECT |
                        McDefine.LayerKind.LINE_SELECT,
                        true,
                        true);

            ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

            SimpleMapReDraw();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル管理ガイドマップ画面再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimpleMapReDraw( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimpleMapReDraw()
        {
            // モデル管理ガイドマップ再描画
            if (m_csSimpleMap != null)
            {// モデル管理ガイドマップ表示中の場合
                if (TabControl.SelectedIndex == 0)
                {// 全体系タブ表示の場合
                    // 全体表示時
                    m_csSimpleMap.DisplyElementChange(m_csDispElmList[0], m_csDispLineList, m_pDispPoint, m_lDispScale);
                }
                else
                {// 全体系タブ以外表示の場合
                    // 内部表示時
                    m_csSimpleMap.DisplyElementChange(m_csDispElmList[TabControl.SelectedIndex], null, m_pDispPoint, m_lDispScale);
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>マウスホイール操作処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseWheel(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseWheel(object sender, MouseEventArgs e)
        {
            // 拡大／縮小
            if (e.Delta > 0)
            {// 拡大の場合
                ZoomIn(null, null);
            }
            else
            {// 縮小の場合
                ZoomOut(null, null);
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>マウスダブルクリック操作処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseDoubleClick(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseDoubleClick(object sender, MouseEventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                int iImageX = (int)((m_pDispPoint.X + e.X * 100.0 / m_lDispScale) * m_lDispScale / 100.0);
                int iImageY = (int)((m_pDispPoint.Y + e.Y * 100.0 / m_lDispScale) * m_lDispScale / 100.0);

                // 指定位置エレメント有無チェック
                bool bPortFlg = false;
                McGraphicsElement csElement = m_csGraphicsManager.ElementPositionCheck(iImageX, iImageY, ref bPortFlg);
                if ((csElement != null) && (bPortFlg == false))
                {// 指定位置に要素があった場合
                    int iTabNo = 0;
                    if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                        (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT))
                    {// 入力要素の場合
                        iTabNo = 1;
                    }
                    else if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                             (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                    {// 出力要素の場合
                        iTabNo = 2;
                    }
                    else if (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線の場合
                        iTabNo = 3;
                    }
                    ((McDotNetModelCtlScreen)m_csScreen).PutEventRequestLibraryTabChange(iTabNo);

                    //選択中要素リストクリア
                    m_csGraphicsManager.ClearSelectionList();

                    //選択中要素リスト追加
                    m_csGraphicsManager.AddSelectionList(csElement);

                    //プロパティリスト選択同期
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                    ListSelectionMatching();
                    m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    if (csElement.GetModelInfo().GetLibraryID().ToString() != "")
                    {// モデル設定がある場合
                        ((McDotNetModelCtlScreen)m_csScreen).ShowModelPropertyScreen(csElement);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>モデル管理ガイドマップ表示／非表示切替</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimpleMapVisibleChange(bVisibleFlg)</para>
        /// </example>
        /// <param name="bVisibleFlg">表示／非表示切替</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimpleMapVisibleChange(bool bVisibleFlg)
        {
            // モデル管理ガイドマップ表示／非表示切替
            if (m_csSimpleMap != null)
            {// モデル管理ガイドマップ表示中の場合
                m_csSimpleMap.Visible = bVisibleFlg;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>モデル管理ガイドマップ初期表示設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimpleMapDispInitial()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimpleMapDispInitial()
        {
            if (m_csSimpleMap != null)
            {// モデル管理ガイドマップ表示中の場合
                // モデル管理ガイドマップ初期表示設定
                // 右端に表示
                Size desktopSize = System.Windows.Forms.SystemInformation.WorkingArea.Size;
                SIMPLEMAP_DESKTOP_LOCATION_X = desktopSize.Width - SIMPLEMAP_WIDTH;
                m_csSimpleMap.SetDesktopLocation(SIMPLEMAP_DESKTOP_LOCATION_X - SIMPLEMAP_DESKTOP_LOCATION_X_ADJUSTED_VALUE, SIMPLEMAP_DESKTOP_LOCATION_Y_ADJUSTED_VALUE);
                //m_csSimpleMap.SetDesktopLocation(0, 0);
                m_csSimpleMap.Width = SIMPLEMAP_WIDTH;
                m_csSimpleMap.Height = SIMPLEMA_HEIGHT;
                m_csSimpleMap.WindowState = FormWindowState.Normal;
                m_csSimpleMap.Activate();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {// 選択項目の場合
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {// 選択項目以外の場合
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面縮尺変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ZoomKeyDown( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ZoomKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {// Enterキーの場合
                ZoomChange(null, null);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>倍率コンボアクティブ移動</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ZoomSizeComboBoxLeave( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ZoomSizeComboBoxLeave(object sender, EventArgs e)
        {
            ZoomChange(null, null);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ツールバー位置変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ToolBarMove( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ToolBarMove(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_TOOLBAR_EDIT)
            {// ツールバー編集中以外の場合
                List<HySString> sToolStripNameList = m_csCustomInfo.GetToolStripNameList();

                for (int iLp1 = 0; iLp1 < sToolStripNameList.Count; iLp1++)
                {// ツールバー名称数ループ
                    if (ToolStripPanel1.Controls[sToolStripNameList[iLp1].ToString()] != null)
                    {// ツールバーがある場合
                        ToolStrip csToolStrip = (ToolStrip)ToolStripPanel1.Controls[sToolStripNameList[iLp1].ToString()];
                        m_csCustomInfo.SetToolStripLocation(new HySString(csToolStrip.Name), csToolStrip.Location);
                    }
                }

                // カスタマイズ情報登録
                m_csCustomInfo.SaveCustomInfo();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ボタン位置変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ButtonMove( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ButtonMove(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_TOOLBAR_EDIT)
            {// ツールバー編集中以外の場合
                if (m_csCustomInfo != null)
                {// カスタマイズ情報がある場合
                    List<List<HySString>> sToolStripCollectionList = new List<List<HySString>>();
                    List<HySString> sToolStripNameList = m_csCustomInfo.GetToolStripNameList();

                    for (int iLp1 = 0; iLp1 < sToolStripNameList.Count; iLp1++)
                    {// ツールバー名称数ループ
                        sToolStripCollectionList.Add(new List<HySString>());
                        if (ToolStripPanel1.Controls[sToolStripNameList[iLp1].ToString()] != null)
                        {// ツールバーがある場合
                            ToolStrip csToolStrip = (ToolStrip)ToolStripPanel1.Controls[sToolStripNameList[iLp1].ToString()];
                            m_csCustomInfo.SetToolStripLocation(new HySString(csToolStrip.Name), csToolStrip.Location);
                            for (int iLp2 = 0; iLp2 < csToolStrip.Items.Count; iLp2++)
                            {// ツールバーアイテム数ループ
                                sToolStripCollectionList[iLp1].Add(new HySString(csToolStrip.Items[iLp2].Name));
                            }
                        }
                    }
                    m_csCustomInfo.SetToolStripCollectionList(sToolStripCollectionList);

                    // カスタマイズ情報登録
                    m_csCustomInfo.SaveCustomInfo();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ツールバーカスタマイズ情報復元</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ToolbarCustomSet()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ToolbarCustomSet()
        {
            McDefine.DrawModeKind eTempDrawMode = m_eDrawMode;
            m_eDrawMode = McDefine.DrawModeKind.HYM_TOOLBAR_EDIT;

            // ツールバー名称リスト取得
            List<HySString> sToolStripNameList = m_csCustomInfo.GetToolStripNameList();

            // ツールバーコレクションリスト取得
            List<List<HySString>> sToolStripCollectionList = m_csCustomInfo.GetToolStripCollectionList();

            // ツールバー及びツールバー内ボタン一時解除
            List<ToolStrip> csToolStripList = new List<ToolStrip>();
            List<ToolStripItem> csToolStripItemList = new List<ToolStripItem>();
            for (int iLp1 = 0; iLp1 < sToolStripNameList.Count; iLp1++)
            {// ツールバー名称数ループ
                if (ToolStripPanel1.Controls[sToolStripNameList[iLp1].ToString()] != null)
                {// ツールバーがある場合
                    // ツールバーコントロール取り出し
                    ToolStrip csToolStrip = (ToolStrip)ToolStripPanel1.Controls[sToolStripNameList[iLp1].ToString()];
                    for (int iLp2 = csToolStrip.Items.Count - 1; iLp2 >= 0; iLp2--)
                    {// ツールバーアイテム数ループ
                        csToolStripItemList.Add(csToolStrip.Items[iLp2]);
                        csToolStrip.Items.RemoveAt(iLp2);
                    }
                    csToolStripList.Add(csToolStrip);
                    ToolStripPanel1.Controls.Remove(csToolStrip);
                }
            }

            for (int iLp1 = 0; iLp1 < sToolStripNameList.Count; iLp1++)
            {// ツールバー名称数ループ
                for (int iLp2 = 0; iLp2 < csToolStripList.Count; iLp2++)
                {// ツールバー数ループ
                    if (sToolStripNameList[iLp1].ToString() == csToolStripList[iLp2].Name)
                    {// 名称が一致する場合
                        // ツールバーコントロール取り出し
                        ToolStrip csToolStrip = csToolStripList[iLp2];
                        csToolStripList.RemoveAt(iLp2);

                        // ツールバー表示位置設定
                        csToolStrip.Location = m_csCustomInfo.GetToolStripLocation(new HySString(csToolStrip.Name));

                        // ツールバー内ボタン配置設定
                        for (int iLp3 = 0; iLp3 < sToolStripCollectionList[iLp1].Count; iLp3++)
                        {// ツールバーコレクション数ループ
                            for (int iLp4 = 0; iLp4 < csToolStripItemList.Count; iLp4++)
                            {// ツールバーアイテム数ループ
                                if (sToolStripCollectionList[iLp1][iLp3] == csToolStripItemList[iLp4].Name)
                                {// 名称が一致する場合
                                    csToolStrip.Items.Add(csToolStripItemList[iLp4]);
                                    csToolStripItemList.RemoveAt(iLp4);
                                    break;
                                }
                            }
                        }

                        // ツールバー配置
                        ToolStripPanel1.Controls.Add(csToolStrip);

                        // ツールバー表示／非表示設定
                        csToolStrip.Visible = m_csCustomInfo.GetToolStripVisible(new HySString(csToolStrip.Name));

                        break;
                    }
                }
            }

            m_eDrawMode = eTempDrawMode;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>シミュレーション関連操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimulationOperate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimulationOperate(object sender, EventArgs e)
        {
            long lCallBackNo = 0;

            if (((ToolStripButton)sender).Name == "SimStartButton")
            {// 開始の場合
                lCallBackNo = McDefine.HYMCO_PROJECT_CALC_START;
                m_bSimStartReq = true;
            }
            else if (((ToolStripButton)sender).Name == "SimPauseButton")
            {// 中断の場合
                lCallBackNo = McDefine.HYMCO_PROJECT_CALC_PAUSE;
            }
            else if (((ToolStripButton)sender).Name == "SimStopButton")
            {// 停止の場合
                lCallBackNo = McDefine.HYMCO_PROJECT_CALC_STOP;
            }
            else if (((ToolStripButton)sender).Name == "SimResetButton")
            {// リセットの場合
                lCallBackNo = McDefine.HYMCO_PROJECT_CALC_RESET;
            }

            if (lCallBackNo != 0)
            {// コールバック番号が０以外の場合
                SimStartButton.Enabled = false;
                SimPauseButton.Enabled = false;
                SimStopButton.Enabled = false;
                SimResetButton.Enabled = false;
                ((McDotNetModelCtlScreen)m_csScreen).ModelFormSimulationOperate(lCallBackNo);

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト取り込み（メニュー選択）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ProjectIncorporate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectIncorporate()
        {
            ((McDotNetModelCtlScreen)m_csScreen).PutEventRequestProjectIncorporate();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト取り込み（プロジェクト読み込み完了）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ProjectIncorporateProjectLoad(csProjectName, csStructInfo, csModelFactory)</para>
        /// </example>
        /// <param name="csProjectName">取り込みプロジェクト名</param>
        /// <param name="csStructInfo">取り込みプロジェクト</param>
        /// <param name="csModelFactory">モデルファクトリー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ProjectIncorporateProjectLoad(HySString csProjectName, McStructInfo csStructInfo, McModelFactorySet csModelFactory)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                // 現表示画面中心座標計算
                long lPastePointX = m_pDispPoint.X + (m_iWidth * 100 / m_lDispScale / 2);
                long lPastePointY = m_pDispPoint.Y + (m_iHeight * 100 / m_lDispScale / 2);

                if (m_bPastePointFlg == true)
                {// 貼り付け座標が有効な場合
                    // 選択位置確認
                    if ((m_pPastePoint.X >= m_pDispPoint.X) &&
                        (m_pPastePoint.X <= m_pDispPoint.X + (m_iWidth * 100 / m_lDispScale))&&
                        (m_pPastePoint.Y >= m_pDispPoint.Y) &&
                        (m_pPastePoint.Y <= m_pDispPoint.Y + (m_iHeight * 100 / m_lDispScale)))
                    {// 貼り付け座標が表示範囲内の場合
                        // 貼り付け位置設定
                        lPastePointX = m_pPastePoint.X;
                        lPastePointY = m_pPastePoint.Y;
                    }
                }

                // プロジェクト取り込み
                McGraphicsElement csElement = m_csGraphicsManager.ProjectIncorporate(csProjectName, csStructInfo, csModelFactory, lPastePointX, lPastePointY);

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.PROJECT_INCORPORATE;
                m_csHistoryDataWork = new List<object>();
                m_csHistoryDataWork.Add(csElement.CopyInfUsedByUndoRedoOnly(null));

                csHistoryData.HistoryData = m_csHistoryDataWork;

                // 取込後の表示エリアの取得及びチェック
                Point pPointLeftTop = new Point();
                Point pPointRightBottom = new Point();
                if (m_csGraphicsManager.GetDispRect(ref pPointLeftTop, ref pPointRightBottom) == 0)
                {   // 表示エレメント有り
                    CheckDispArea(pPointLeftTop, pPointRightBottom);
                }
                // スクロールバー再描画
                ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);

                // 復元ポイント記録
                ReconstructionPointSave(true, csHistoryData);

                // モデル管理ガイドマップ再描画
                SimpleMapReDraw();

                int iTempSelectedIndex = TabControl.SelectedIndex;

                // 部分系表示タブ追加
                PartDisp(null, null);

                TabControl.SelectedIndex = iTempSelectedIndex;

                // プロパティ画面リフレッシュ
                if (TabControl.SelectedIndex == 0)
                {// 全体系タブ表示の場合
                    PropetyScreenRefreshment(m_csGraphicsManager.GetStructInfo().GetID());
                }
                else
                {// 全体系タブ以外表示の場合
                    PropetyScreenRefreshment(m_csDispElmList[TabControl.SelectedIndex][0].GetID());
                }

                // リスト部編集
                PropertyListEdit(1, false);

                m_csGraphicsManager.ClearSelectionList();
                m_csGraphicsManager.AddSelectionList(csElement);

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択要素画面中央表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ElementCenterDisp(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ElementCenterDisp(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();

                long lX = 0;
                long lY = 0;

                for (int iLp = 0; iLp < csSelectList.Count; iLp++)
                {// 選択要素数ループ
                    if (csSelectList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線以外の場合
                        csSelectList[iLp].GetPosition(ref lX, ref lY);
                        break;
                    }
                }

                // 表示座標計算
                m_pDispPoint.X = (int)(lX - (m_iWidth * 100 / m_lDispScale / 2));
                m_pDispPoint.Y = (int)(lY - (m_iHeight * 100 / m_lDispScale / 2));

                m_pDispPointList[TabControl.SelectedIndex] = m_pDispPoint;

                m_iVScroll = (m_pDispPoint.Y - m_iScrollTop) * (VScrollBar.Maximum - VScrollBar.LargeChange) / (m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale);
                m_iHScroll = (m_pDispPoint.X - m_iScrollLeft) * (HScrollBar.Maximum - HScrollBar.LargeChange) / (m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale);
                VScrollBar.Value = m_iVScroll;
                HScrollBar.Value = m_iHScroll;

                // モデル管理ガイドマップ再描画
                SimpleMapReDraw();

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                // ボタン活性／非活性設定
                ButtonEnabledSet();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル管理画面リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RefreshmentModelCtlForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RefreshmentModelCtlForm()
        {
            // タブ名称再編集
            for (int iLp = 1; iLp < m_iTabCount; iLp++)
            {// グループ内部表示タブ数ループ
                if (m_csDispElmList[iLp][0].GetID().ToString().IndexOf('-') != -1)
                {// 分割出来る場合
                    TabControl.TabPages[iLp].Text = Properties.McDotNetViewerResources.MODEL_TAB_PART + m_csDispElmList[iLp][0].GetElementName().ToString().Trim() + " " + m_csDispElmList[iLp][0].GetID().ToString().Substring(0, m_csDispElmList[iLp][0].GetID().ToString().IndexOf('-')) + "...";
                }
                else
                {// 分割出来ない場合
                    if (m_csDispElmList[iLp][0].GetID().ToString().Length <= USER_MAKE_ID_SHORT_LENGTH)
                    {// IDの長さが既定値以下の場合
                        TabControl.TabPages[iLp].Text = Properties.McDotNetViewerResources.MODEL_TAB_PART + m_csDispElmList[iLp][0].GetElementName().ToString().Trim() + " " + m_csDispElmList[iLp][0].GetID().ToString() + "...";
                    }
                    else
                    {// IDの長さが既定値より大きいの場合
                        TabControl.TabPages[iLp].Text = Properties.McDotNetViewerResources.MODEL_TAB_PART + m_csDispElmList[iLp][0].GetElementName().ToString().Trim() + " " + m_csDispElmList[iLp][0].GetID().ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH) + "...";
                    }
                }
            }

            //編集領域設定
            m_pReDrawPoint.X = m_pDispPoint.X;
            m_pReDrawPoint.Y = m_pDispPoint.Y;
            m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
            m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

            // グラフィック部編集
            LayerReDraw(McDefine.LayerKind.NAME, true, true);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素情報検索選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McGraphicsElement csElement = SearchSelectElement(csElementID)</para>
        /// </example>
        /// <param name="csElementID">検索要素ID</param>
        /// <returns>McGraphicsElement 検索要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphicsElement SearchSelectElement(HySIdentifier csElementID)
        {
            McGraphicsElement csElement = null;

            List<McGraphicsElement> csElmList = null;
            List<McGraphicsElement> csLineList = null;

            if (TabControl.SelectedIndex == 0)
            {// 全体系タブ表示の場合
                csElmList = m_csDispElmList[0];
                csLineList = m_csDispLineList;
            }
            else
            {// 全体系タブ以外表示の場合
                csElmList = ((McGraphicsGroupElement)m_csDispElmList[TabControl.SelectedIndex][0]).GetGroupElementList();
                csLineList = ((McGraphicsGroupElement)m_csDispElmList[TabControl.SelectedIndex][0]).GetGroupLineElementList();
            }

            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                csElement = csElmList[iLp].SearchElement(csElementID);
                if (csElement != null)
                {// 要素があった場合
                    break;
                }
            }

            if (csElement == null)
            {// 要素がなかった場合
                for (int iLp = 0; iLp < csLineList.Count; iLp++)
                {// 接続線数ループ
                    if (csLineList[iLp].GetID().Equals(csElementID) == true)
                    {// IDが一致した場合
                        csElement = csLineList[iLp];
                        break;
                    }
                }
            }

            if (csElement != null)
            {// 要素があった場合
                m_csGraphicsManager.ClearSelectionList();
                m_csGraphicsManager.AddSelectionList(csElement);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);
            }

            return csElement;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素整列</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ElementLineUp(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ElementLineUp(object sender, EventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                List<McGraphicsElement> csSelectList = m_csGraphicsManager.GetSelectionList();

                if (csSelectList.Count > 1)
                {// 選択要素数が１より大きい場合
                    // カーソルを砂時計にする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.WaitCursor;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.WaitCursor;
                    }

                    int iLineUPMode = 0;

                    List<HySIdentifier> csMoveIDList = new List<HySIdentifier>();
                    List<Point> csBeforePointList = new List<Point>();
                    List<Point> csAfterPointList = new List<Point>();

                    if ((((ToolStripButton)sender).Name == "ElementLineUpUpButton") ||
                        (((ToolStripButton)sender).Name == "ElementLineUpBottomButton") ||
                        (((ToolStripButton)sender).Name == "ElementLineUpLeftButton") ||
                        (((ToolStripButton)sender).Name == "ElementLineUpRightButton"))
                    {// 要素整列の場合
                        if (((ToolStripButton)sender).Name == "ElementLineUpUpButton")
                        {// 選択要素整列（上辺整列）の場合
                            iLineUPMode = 0;
                        }
                        if (((ToolStripButton)sender).Name == "ElementLineUpRightButton")
                        {// 選択要素整列（右辺整列）の場合
                            iLineUPMode = 1;
                        }
                        if (((ToolStripButton)sender).Name == "ElementLineUpBottomButton")
                        {// 選択要素整列（下辺整列）の場合
                            iLineUPMode = 2;
                        }
                        if (((ToolStripButton)sender).Name == "ElementLineUpLeftButton")
                        {// 選択要素整列（左辺整列）の場合
                            iLineUPMode = 3;
                        }
                        //選択要素整列
                        m_csGraphicsManager.ElementLineUp(iLineUPMode, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);
                    }
                    else if ((((ToolStripButton)sender).Name == "ElementEqualDistanceLineUpVButton") ||
                             (((ToolStripButton)sender).Name == "ElementEqualDistanceLineUpHButton"))
                    {// 選択要素等間隔整列の場合
                        if (((ToolStripButton)sender).Name == "ElementEqualDistanceLineUpVButton")
                        {// 選択要素等間隔整列（上下等間隔整列）の場合
                            iLineUPMode = 0;
                        }
                        if (((ToolStripButton)sender).Name == "ElementEqualDistanceLineUpHButton")
                        {// 選択要素等間隔整列（左右等間隔整列）の場合
                            iLineUPMode = 1;
                        }
                        //選択要素等間隔整列
                        m_csGraphicsManager.ElementEqualDistanceLineUp(iLineUPMode, ref csMoveIDList, ref csBeforePointList, ref csAfterPointList);
                    }

                    // カーソルをデフォルトにする。
                    if (this.MdiParent != null)
                    {// 親フォームがある場合
                        this.MdiParent.Cursor = Cursors.Default;
                    }
                    else
                    {// 親フォームがない場合
                        this.Cursor = Cursors.Default;
                    }

                    //復元データ編集
                    McHistoryData csHistoryData = new McHistoryData();
                    csHistoryData.Kind = McHistoryData.OperationKind.ELEMENT_MOVE;
                    m_csHistoryDataWork = new List<object>();
                    m_csHistoryDataWork.Add(csMoveIDList);
                    m_csHistoryDataWork.Add(csBeforePointList);
                    m_csHistoryDataWork.Add(csAfterPointList);
                    csHistoryData.HistoryData = m_csHistoryDataWork;

                    //復元ポイント記録
                    ReconstructionPointSave(false, csHistoryData);

                    //編集領域設定
                    m_pReDrawPoint.X = m_pDispPoint.X;
                    m_pReDrawPoint.Y = m_pDispPoint.Y;
                    m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                    m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                    // グラフィック部編集
                    LayerReDraw(McDefine.LayerKind.ELEMENT |
                                McDefine.LayerKind.PORT |
                                McDefine.LayerKind.LINE |
                                McDefine.LayerKind.ID |
                                McDefine.LayerKind.NAME |
                                McDefine.LayerKind.ELEMENT_SELECT |
                                McDefine.LayerKind.PORT_SELECT |
                                McDefine.LayerKind.LINE_SELECT,
                                true,
                                true);

                    // モデル管理ガイドマップ再描画
                    SimpleMapReDraw();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ツールバーパネルリサイズイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ToolStripPanel1_Resize(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ToolStripPanel1_Resize(object sender, EventArgs e)
        {
            if (TabControl.Location.Y != ToolStripPanel1.Size.Height)
            {// 位置が違う場合
                int iMoveHeight = ToolStripPanel1.Size.Height - TabControl.Location.Y;
                Point pLocation = TabControl.Location;
                pLocation.Y = ToolStripPanel1.Size.Height;
                TabControl.Location = pLocation;
                pLocation = SplitContainer1.Location;
                pLocation.Y += iMoveHeight;
                SplitContainer1.Location = pLocation;
                SplitContainer1.Height -= iMoveHeight;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>評価画面要求イベント発行処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = PutEvaluationMenuEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PutEvaluationMenuEvent(object sender, EventArgs e)
        {
            HySKind csDispKind = null;
            HySKind[,] csCntrolName = { 
                                       { new HySObjectKind("BasicScreenMenuItem") , HySDefine.DISP_FORM_LINE_GRAPH        },
                                       { new HySObjectKind("HydroHyetoMenuItem")  , HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH },
                                       { new HySObjectKind("RiverProfileMenuItem"), HySDefine.DISP_FORM_RIVERBED_SHAPE    },
                                       { new HySObjectKind("HQMenuItem")          , HySDefine.DISP_FORM_HQ_GRAPH          }
                                     };

            for (int iLp = 0; iLp < csCntrolName.GetLength(0); iLp++)
            {// ケース数ループ
                if (((ToolStripMenuItem)sender).Name.ToString() == csCntrolName[iLp, 0].ToString())
                {// 名称が一致した場合
                    csDispKind = csCntrolName[iLp, 1]; // 画面識別子設定
                    break;
                }
            }

            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                //選択中要素リスト取得
                List<McGraphicsElement> csSelectionList = m_csGraphicsManager.GetSelectionList();
                for (int iLP = 0; iLP < csSelectionList.Count; iLP++)
                {// 選択要素数ループ
                    McModelInfo csModelInf = csSelectionList[iLP].GetModelInfo();
                    if (csModelInf.GetModelKind().Equals(McModelLibraryDefine.HYM_MODEL_CALRESULT_DBA_OUT) == true ||
                        csModelInf.GetModelKind().Equals(HymcoStandardModelDefine.CSV_FILE_OUT_KIND) == true)
                    {  // ＤＢ出力要素の場合,CSV出力要素の場合
                        ((McDotNetModelCtlScreen)m_csScreen).PutEvaluationMenuEvent(csSelectionList[iLP].GetID(), csDispKind);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルチェック結果ダブルクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelCheckResultDoubleClick(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ModelCheckResultDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            // モードチェック
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モードの場合
                if (e.RowIndex < 0)
                {// 選択行が無効の場合
                    return;
                }

                HySString csID = new HySString(TabPage1DataGridView5.Rows[e.RowIndex].Cells[0].Value.ToString());

                //エレメントリスト取得
                List<McGraphicsElement> csElmList = m_csGraphicsManager.GetElementList();
                //ラインリスト取得
                List<McGraphicsElement> csLineList = m_csGraphicsManager.GetLineList();

                bool bMatchFlg = false;
                for (int iLp = 0; iLp < csElmList.Count; iLp++)
                {// 要素数ループ
                    if ((HySString)csElmList[iLp].GetID().GetString() == csID)
                    {// IDが一致した場合
                        if ((csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                            (csElmList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT))
                        {// 入力要素の場合
                            TabPage1TabPControl.SelectedIndex = 1;
                        }
                        else if ((csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                                 (csElmList[iLp].GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                        {// 出力要素の場合
                            TabPage1TabPControl.SelectedIndex = 2;
                        }
                        else
                        {// その他の場合
                            TabPage1TabPControl.SelectedIndex = 0;
                        }
                        bMatchFlg = true;
                        break;
                    }
                }
                for (int iLp = 0; (iLp < csLineList.Count) && (bMatchFlg == false); iLp++)
                {// 接続線数ループ
                    if ((HySString)csLineList[iLp].GetID().GetString() == csID)
                    {// IDが一致した場合
                        TabPage1TabPControl.SelectedIndex = 3;
                        break;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルドラッグ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelDragEnter(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ModelDragEnter(object sender, DragEventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モード以外の場合
                return;
            }

            // ドラッグデータチェック
            if (!e.Data.GetDataPresent(typeof(McDragData)))
            {// ドラッグデータが無効の場合
                return;
            }

            if (m_csGraphicsManager.GetSelectionList().Count > 0)
            {// 選択要素数が０より大きい場合
                // 全選択解除
                m_csGraphicsManager.ClearSelectionList();

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルドラッグ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelDragOver(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ModelDragOver(object sender, DragEventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モード以外の場合
                e.Effect = DragDropEffects.None;
                return;
            }

            // ドラッグデータチェック
            if (!e.Data.GetDataPresent(typeof(McDragData)))
            {// ドラッグデータが無効の場合
                e.Effect = DragDropEffects.None;
                return;
            }

            // ドラッグデータ取り出し
            McDragData csDragData = (McDragData)e.Data.GetData(typeof(McDragData));

            bool bSelectionChange = false;

            // マウス位置座標計算
            Point pClientPoint = LayerRubberBand.PointToClient(new Point(e.X, e.Y));
            int iImageX = (int)((m_pDispPoint.X + pClientPoint.X * 100.0 / m_lDispScale) * m_lDispScale / 100.0);
            int iImageY = (int)((m_pDispPoint.Y + pClientPoint.Y * 100.0 / m_lDispScale) * m_lDispScale / 100.0);

            // マウス位置要素有無チェック
            bool bPortFlg = false;
            bool bDropOk = false;
            McGraphicsElement csElement = m_csGraphicsManager.ElementPositionCheck(iImageX, iImageY, ref bPortFlg);
            if ((csElement != null) && (bPortFlg == false))
            {// 指定位置に要素があった場合
                // ドロップ可否チェック
                if (csDragData.Kind == McDragData.DragModelKind.CALC_MODEL)
                {// 演算要素の場合
                    if (csDragData.Model.GetModelType() == McDefine.MODEL_TYPE_STANDARD)
                    {// 標準モデルの場合
                        if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                            (csElement.GetDrawSubKind() != McDefine.HYM_DRAW_SUB_KIND_INPUT) &&
                            (csElement.GetDrawSubKind() != McDefine.HYM_DRAW_SUB_KIND_OUTPUT) &&
                            (csElement.GetDrawSubKind() != McDefine.HYM_DRAW_SUB_KIND_DATA_MERGE))
                        {// 入力要素および出力要素およびマージ要素以外の場合
                            bDropOk = true;
                        }
                    }
                    else if (csDragData.Model.GetModelType() == McDefine.MODEL_TYPE_GROUP)
                    {// グループモデルの場合
                        if (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
                        {// 収束演算系グループ要素の場合
                            bDropOk = true;
                        }
                    }
                }
                else if (csDragData.Kind == McDragData.DragModelKind.INPUT_MODEL)
                {// 入力要素の場合
                    if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                        (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_INPUT))
                    {// 入力要素の場合
                        bDropOk = true;
                    }
                }
                else if (csDragData.Kind == McDragData.DragModelKind.OUTPUT_MODEL)
                {// 出力要素の場合
                    if ((csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_STD_ELEMENT) &&
                        (csElement.GetDrawSubKind() == McDefine.HYM_DRAW_SUB_KIND_OUTPUT))
                    {// 出力要素の場合
                        bDropOk = true;
                    }
                }
                else if (csDragData.Kind == McDragData.DragModelKind.TRANS_MODEL)
                {// 要素接続の場合
                    if (csElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線の場合
                        bDropOk = true;
                    }
                }

                if (bDropOk == true)
                {// ドロップ可能な場合
                    if (m_csGraphicsManager.SearchSelectionList((HySString)csElement.GetID().GetString()) == -1)
                    {// 未選択の場合
                        // 全選択解除
                        m_csGraphicsManager.ClearSelectionList();

                        //選択要素を選択中要素リストに追加
                        m_csGraphicsManager.AddSelectionList(csElement);

                        bSelectionChange = true;

                        // ドラッグ状態設定
                        e.Effect = DragDropEffects.Copy;
                    }
                }
                else
                {// ドロップ不可能な場合
                    if (m_csGraphicsManager.GetSelectionList().Count > 0)
                    {// 選択要素数が０より大きい場合
                        // 全選択解除
                        m_csGraphicsManager.ClearSelectionList();

                        bSelectionChange = true;

                        e.Effect = DragDropEffects.None;
                    }
                }
            }
            else
            {// 指定位置に要素がなかった場合
                if (m_csGraphicsManager.GetSelectionList().Count > 0)
                {// 選択要素数が０より大きい場合
                    // 全選択解除
                    m_csGraphicsManager.ClearSelectionList();

                    bSelectionChange = true;

                    e.Effect = DragDropEffects.None;
                }
            }

            if (bSelectionChange == true)
            {// 表示編集要の場合
                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                //プロパティリスト選択同期
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT_ELEMENT;
                ListSelectionMatching();
                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルドロップ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelDragDrop(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ModelDragDrop(object sender, DragEventArgs e)
        {
            // モードチェック
            if (m_eDrawMode != McDefine.DrawModeKind.HYM_SELECT)
            {// 選択モード以外の場合
                return;
            }

            // ドラッグデータチェック
            if (!e.Data.GetDataPresent(typeof(McDragData)))
            {// ドラッグデータが無効の場合
                return;
            }

            // ドラッグ状態チェック
            if (e.Effect != DragDropEffects.Copy)
            {// ドラッグ状態がドロップ可以外の場合
                return;
            }

            // ドラッグデータ取り出し
            McDragData csDragData = (McDragData)e.Data.GetData(typeof(McDragData));

            // モデルセット
            if (csDragData.Kind == McDragData.DragModelKind.CALC_MODEL)
            {// 演算要素の場合
                ElementModelSet(csDragData.Model);
            }
            else if (csDragData.Kind == McDragData.DragModelKind.INPUT_MODEL)
            {// 入力要素の場合
                InputDataSet(csDragData.Model);
            }
            else if (csDragData.Kind == McDragData.DragModelKind.OUTPUT_MODEL)
            {// 出力要素の場合
                OutputDataSet(csDragData.Model);
            }
            else if (csDragData.Kind == McDragData.DragModelKind.TRANS_MODEL)
            {// 要素接続の場合
                TransInfoTypeSet(csDragData.Model);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ポップアップメニュー生成（ライブラリツリー）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PopupMenuMakeLibraryTree(csTreeData)</para>
        /// </example>
        /// <param name="csTreeData">ライブラリツリー情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void PopupMenuMakeLibraryTree(McTreeData csTreeData)
        {
            LibraryMenuItem.Visible = false;
            LibraryMenuItemT1.Visible = false;
            LibrarySetTopMenuItem.Visible = true;
            LibraryReSetTopMenuItem.Visible = true;
            LibrarySetTopMenuItemT1.Visible = true;
            LibraryReSetTopMenuItemT1.Visible = true;

            // ライブラリの設定－XXXXX部生成
            ToolStripMenuItem csAddItem1 = new ToolStripMenuItem(csTreeData.m_csTabName1.ToString());
            ToolStripMenuItem csAddItem2 = new ToolStripMenuItem(csTreeData.m_csTabName2.ToString());
            ToolStripMenuItem csAddItem3 = new ToolStripMenuItem(csTreeData.m_csTabName3.ToString());
            ToolStripMenuItem csAddItem4 = new ToolStripMenuItem(csTreeData.m_csTabName4.ToString());
            ToolStripMenuItem csAddItemT1_1 = new ToolStripMenuItem(csTreeData.m_csTabName1.ToString());
            ToolStripMenuItem csAddItemT1_2 = new ToolStripMenuItem(csTreeData.m_csTabName2.ToString());
            ToolStripMenuItem csAddItemT1_3 = new ToolStripMenuItem(csTreeData.m_csTabName3.ToString());
            ToolStripMenuItem csAddItemT1_4 = new ToolStripMenuItem(csTreeData.m_csTabName4.ToString());
            csAddItem1.Name = "Standard";
            csAddItem2.Name = "Input";
            csAddItem3.Name = "Output";
            csAddItem4.Name = "Trans";
            csAddItemT1_1.Name = "StandardT1";
            csAddItemT1_2.Name = "InputT1";
            csAddItemT1_3.Name = "OutputT1";
            csAddItemT1_4.Name = "TransT1";
            csAddItem1.Visible = false;
            csAddItem2.Visible = false;
            csAddItem3.Visible = false;
            csAddItem4.Visible = false;
            csAddItemT1_1.Visible = false;
            csAddItemT1_2.Visible = false;
            csAddItemT1_3.Visible = false;
            csAddItemT1_4.Visible = false;
            LibrarySetTopMenuItem.DropDownItems.Add(csAddItem1);
            LibrarySetTopMenuItem.DropDownItems.Add(csAddItem2);
            LibrarySetTopMenuItem.DropDownItems.Add(csAddItem3);
            LibrarySetTopMenuItem.DropDownItems.Add(csAddItem4);
            LibrarySetTopMenuItemT1.DropDownItems.Add(csAddItemT1_1);
            LibrarySetTopMenuItemT1.DropDownItems.Add(csAddItemT1_2);
            LibrarySetTopMenuItemT1.DropDownItems.Add(csAddItemT1_3);
            LibrarySetTopMenuItemT1.DropDownItems.Add(csAddItemT1_4);

            // ライブラリの設定－XXXXX1－以降生成
            for (int iLp = 0; iLp < csTreeData.m_csTreeData1.Nodes.Count; iLp++)
            {// ツリーコレクション数ループ
                PopupMenuMakeLibraryTreeChild(csAddItem1, csTreeData.m_csTreeData1.Nodes[iLp]);
                PopupMenuMakeLibraryTreeChild(csAddItemT1_1, csTreeData.m_csTreeData1.Nodes[iLp]);
            }

            // ライブラリの設定－XXXXX2－以降生成
            for (int iLp = 0; iLp < csTreeData.m_csTreeData2.Nodes.Count; iLp++)
            {// ツリーコレクション数ループ
                PopupMenuMakeLibraryTreeChild(csAddItem2, csTreeData.m_csTreeData2.Nodes[iLp]);
                PopupMenuMakeLibraryTreeChild(csAddItemT1_2, csTreeData.m_csTreeData2.Nodes[iLp]);
            }

            // ライブラリの設定－XXXXX3－以降生成
            for (int iLp = 0; iLp < csTreeData.m_csTreeData3.Nodes.Count; iLp++)
            {// ツリーコレクション数ループ
                PopupMenuMakeLibraryTreeChild(csAddItem3, csTreeData.m_csTreeData3.Nodes[iLp]);
                PopupMenuMakeLibraryTreeChild(csAddItemT1_3, csTreeData.m_csTreeData3.Nodes[iLp]);
            }

            // ライブラリの設定－XXXXX4－以降生成
            for (int iLp = 0; iLp < csTreeData.m_csTreeData4.Nodes.Count; iLp++)
            {// ツリーコレクション数ループ
                PopupMenuMakeLibraryTreeChild(csAddItem4, csTreeData.m_csTreeData4.Nodes[iLp]);
                PopupMenuMakeLibraryTreeChild(csAddItemT1_4, csTreeData.m_csTreeData4.Nodes[iLp]);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ポップアップメニュー生成（ライブラリツリー）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PopupMenuMakeLibraryTreeChild(csParentMenuItem, csTreeNode)</para>
        /// </example>
        /// <param name="csParentMenuItem">親メニュー項目</param>
        /// <param name="csTreeNode">ライブラリツリー情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PopupMenuMakeLibraryTreeChild(ToolStripMenuItem csParentMenuItem, TreeNode csTreeNode)
        {
            ToolStripMenuItem csChildMenuItem = new ToolStripMenuItem(csTreeNode.Text);
            csChildMenuItem.Name = csParentMenuItem.Name + "_" + csParentMenuItem.DropDownItems.Count.ToString();
            csParentMenuItem.DropDownItems.Add(csChildMenuItem);
            if (csTreeNode.LastNode != null)
            {// 子ツリーノードが取得出来た場合
                for (int iLp = 0; iLp < csTreeNode.Nodes.Count; iLp++)
                {// ツリーノード数ループ
                    PopupMenuMakeLibraryTreeChild(csChildMenuItem, csTreeNode.Nodes[iLp]);
                }
            }
            else if (csTreeNode.Tag != null)
            {// 子ツリーノードが取得出来ない場合
                McModelInfo csModelInfo = (McModelInfo)csTreeNode.Tag;
                csChildMenuItem.Tag = csModelInfo;

                HySString csHomeDir = HySEnvInf.GetHomeDirectory();
                HySString csIconPath = HySEnvInf.GetEnvInf("ICON_FILE_PATH");
                Icon csIcon = null;
                string sModelIcon = null;

                HySString csModelIcon = csModelInfo.GetIconName();
                if ((object)csModelIcon == null)
                {// アイコン設定がない場合
                    sModelIcon = "Default.ico";
                }
                else
                {// アイコン設定がある場合
                    sModelIcon = csModelInfo.GetIconName().ToString();
                    if (sModelIcon == null || sModelIcon == string.Empty)
                    {// アイコン設定がない場合
                        sModelIcon = "Default.ico";
                    }
                }
                string sIconPath2 = csHomeDir.ToString() + csIconPath.ToString() + sModelIcon;
                if (sModelIcon.LastIndexOf(".ico", StringComparison.CurrentCultureIgnoreCase) < 0)
                {// 拡張子がない場合
                    sIconPath2 += ".ico";
                }
                HySFile csFile = new HySFile(sIconPath2);
                if (csFile.Exist() == true)
                {// ファイルがある場合
                    try
                    {
                        csIcon = new Icon(sIconPath2);
                    }
                    catch
                    {
                        sIconPath2 = csHomeDir.ToString() + csIconPath.ToString() + "Unknown.ico";
                        csIcon = new Icon(sIconPath2);
                    }
                }
                else
                {// ファイルがない場合
                    sIconPath2 = csHomeDir.ToString() + csIconPath.ToString() + "Unknown.ico";
                    csIcon = new Icon(sIconPath2);
                }
                csChildMenuItem.Image = csIcon.ToBitmap();
                csIcon.Dispose();
                csChildMenuItem.Click += new EventHandler(LibrarySetMenuTreeClick);
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>ライブラリの設定メニュークリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LibrarySetMenuTreeClick(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LibrarySetMenuTreeClick(object sender, EventArgs e)
        {
            if (((ToolStripMenuItem)sender).Name.IndexOf("Standard") != -1)
            {// 演算要素の場合
                ElementModelSet((McModelInfo)((ToolStripMenuItem)sender).Tag);
            }
            else if (((ToolStripMenuItem)sender).Name.IndexOf("Input") != -1)
            {// 入力要素の場合
                InputDataSet((McModelInfo)((ToolStripMenuItem)sender).Tag);
            }
            else if (((ToolStripMenuItem)sender).Name.IndexOf("Output") != -1)
            {// 出力要素の場合
                OutputDataSet((McModelInfo)((ToolStripMenuItem)sender).Tag);
            }
            else if (((ToolStripMenuItem)sender).Name.IndexOf("Trans") != -1)
            {// 要素接続の場合
                TransInfoTypeSet((McModelInfo)((ToolStripMenuItem)sender).Tag);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0001,
                        ((HySDotNetViewer)((McDotNetModelCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ヒストリーファイル更新(シミュレーションモデル生成)</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HistoryFileUpdateModelConstruction()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void HistoryFileUpdateModelConstruction()
        {
            for (int iLp = 0; iLp < m_csSimulationStatusList.Count; iLp++)
            {// シミュレーション状態保持情報数ループ
                if (iLp != m_iReconstructionPointPointer - 1)
                {// 現在位置以外の場合
                    if (m_csSimulationStatusList[iLp].GetModelConStatus() == McSimulationStatus.ModelConstructionStatus.CONSTRUCTED)
                    {// モデル構築済みの場合
                        m_csSimulationStatusList[iLp].SetModelConStatus(McSimulationStatus.ModelConstructionStatus.NOT_CONSTRUCTED);
                    }
                }
            }
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>Undo/Redo後処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoRedoAfterProcess()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoRedoAfterProcess()
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            m_bMouseDownF = false;
            m_pFirstClickPoint.X = 0;
            m_pFirstClickPoint.Y = 0;
            m_bMoveFlg = false;

            m_bResizeFlg = false;

            McGraphicsElement csGroupElement = null;
            //内部表示タブ表示中グループ有無チェック
            for (int iLp = TabControl.TabCount - 1; iLp >= 1; iLp--)
            {// グループ内部表示タブ数ループ
                csGroupElement = m_csGraphicsManager.SearchGroupElement(m_csDispElmList[0], m_csDispElmList[iLp][0].GetID());
                if (csGroupElement != null)
                {// グループ要素があった場合
                    m_csDispElmList[iLp][0] = csGroupElement;
                }
                else
                {// グループ要素がなかった場合
                    //削除タブ情報をリストから削除
                    m_csDispElmList.RemoveAt(iLp);
                    m_lDispScaleList.RemoveAt(iLp);
                    m_iPropertyListSortColumnIndexList.RemoveAt(iLp);
                    m_pDispPointList.RemoveAt(iLp);

                    TabControl.TabPages.RemoveAt(iLp);

                    m_iTabCount--;
                }
            }

            //タブ切り替え時のカレント情報設定
            CurrentInformationSet();

            //要素名称・ID表示設定取得
            ((McDotNetModelCtlScreen)m_csScreen).GetDispKind();

            // グラフ画面クローズ
            ((McDotNetModelCtlScreen)m_csScreen).LineGraphScreenCloseEvent(new HySID(""));

            // プロパティ画面クローズ
            ((McDotNetModelCtlScreen)m_csScreen).PropetyScreenClose();

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>復元処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReconstructionProcess(bUndoRedoFlg)</para>
        /// </example>
        /// <param name="bUndoRedoFlg">Undo/Redoフラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReconstructionProcess(bool bUndoRedoFlg)
        {
            // カーソルを砂時計にする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.WaitCursor;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.WaitCursor;
            }

            int iReconstructionPoint = 0;
            if (bUndoRedoFlg == true)
            {// Undoの場合
                iReconstructionPoint = m_iReconstructionPointPointer;
            }
            else
            {// Redoの場合
                iReconstructionPoint = m_iReconstructionPointPointer - 1;
            }
            McHistoryData csHistory = m_csReconstructionDataList[iReconstructionPoint];
            McGraphicsGroupElement csParent = null;
            if (csHistory.ParentID != null)
            {// 操作親要素がある場合
                csParent = (McGraphicsGroupElement)m_csGraphicsManager.SearchGroupElement(m_csDispElmList[0], csHistory.ParentID);
            }
            if (csHistory.Kind == McHistoryData.OperationKind.DELETE_CUT)
            {// 削除・切り取りの場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（削除・切り取り）
                    UndoDeleteCut(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（削除・切り取り）
                    RedoDeleteCut(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.CHANGE_NAME)
            {// 要素名称設定の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（要素名称設定）
                    UndoChangeName(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（要素名称設定）
                    RedoChangeName(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.PASTE)
            {// 貼り付けの場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（貼り付け）
                    UndoPaste(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（貼り付け）
                    RedoPaste(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.PLACEMENT)
            {// 要素配置の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（要素配置）
                    UndoPlacement(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（要素配置）
                    RedoPlacement(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.ELEMENT_CONNECTION)
            {// 要素接続の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（要素接続）
                    UndoElementConnection(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（要素接続）
                    RedoElementConnection(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.ELEMENT_MOVE)
            {// 要素移動の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（要素移動）
                    UndoElementMove(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（要素移動）
                    RedoElementmove(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.PORT_MOVE)
            {// 端子移動の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（端子移動）
                    UndoPortMove(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（端子移動）
                    RedoPortmove(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.RESIZE)
            {// 要素サイズ変更の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（要素サイズ変更）
                    UndoResize(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（要素サイズ変更）
                    RedoResize(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.MODEL_SET_ELEMENT)
            {// モデル設定（演算モデル）の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（モデル設定（演算モデル））
                    UndoModelSetElement(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（モデル設定（演算モデル））
                    RedoModelSetElement(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.MODEL_SET_INPUT)
            {// モデル設定（入力モデル）の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（モデル設定（入力モデル））
                    UndoModelSetInput(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（モデル設定（入力モデル））
                    RedoModelSetInput(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.MODEL_SET_OUTPUT)
            {// モデル設定（出力モデル）の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（モデル設定（出力モデル））
                    UndoModelSetOutput(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（モデル設定（出力モデル））
                    RedoModelSetOutput(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.MODEL_SET_TRANS)
            {// モデル設定(伝送モデル）の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（モデル設定(伝送モデル））
                    UndoModelSetTrans(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（モデル設定(伝送モデル））
                    RedoModelSetTrans(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.MODEL_CANCEL)
            {// モデル解除の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（モデル解除）
                    UndoModelCancel(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（モデル解除）
                    RedoModelCancel(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.ROTATION)
            {// 要素回転の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（要素回転）
                    UndoRotation(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（要素回転）
                    RedoRotation(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.GROUPING)
            {// グループ化の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（グループ化）
                    UndoGrouping(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（グループ化）
                    RedoGrouping(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.CANCELLATION_GROUPING)
            {// グループ解除の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（グループ解除）
                    UndoCancelationGrouping(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（グループ解除）
                    RedoCancelationGrouping(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.EXTERNAL_CONNECTION_RECEIVE)
            {// 外部接続（受信）の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（外部接続（受信））
                    UndoExternalConnectionReceive(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（外部接続（受信））
                    RedoExternalConnectionReceive(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.EXTERNAL_CONNECTION_SEND)
            {// 外部接続（送信）の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（外部接続（送信））
                    UndoExternalConnectionSend(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（外部接続（送信））
                    RedoExternalConnectionSend(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.PROPERTY_CHANGE)
            {// プロパティ変更の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（プロパティ変更）
                    UndoPropertyChange(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（プロパティ変更）
                    RedoPropertyChange(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.PILED_UP_TOP)
            {// 最前面へ移動の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（最前面へ移動）
                    UndoPiledUpTop(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（最前面へ移動）
                    RedoPiledUpTop(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.PILED_UP_BOTTOM)
            {// 最背面へ移動の場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（最背面へ移動）
                    UndoPiledUpBottom(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（最背面へ移動）
                    RedoPiledUpBottom(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.PROJECT_INCORPORATE)
            {// プロジェクト取り込みの場合
                if (bUndoRedoFlg == true)
                {// Undoの場合
                    // 元に戻す（プロジェクト取り込み）
                    UndoProjectIncorporate(csParent, csHistory);
                }
                else
                {// Redoの場合
                    // やり直し（プロジェクト取り込み）
                    RedoProjectIncorporate(csParent, csHistory);
                }
            }
            else if (csHistory.Kind == McHistoryData.OperationKind.ALLROTATION)
            {//要素全回転の場合
                if (bUndoRedoFlg == true)
                {
                    //Undo処理
                    UndoAllRotation(csParent, csHistory);
                }
                else
                {
                    //Redo処理
                    RedoAllRotation(csParent, csHistory);
                }
            }

            ((McDotNetModelCtlScreen)m_csScreen).SetSimulationStatusData(m_csSimulationStatusList[m_iReconstructionPointPointer - 1]);

            //シミュレーション状態保持クラス変更通知イベント送信
            ((McDotNetModelCtlScreen)m_csScreen).SimulationStatusModifyInformation();

            m_eSimulationKind = m_csSimulationStatusList[m_iReconstructionPointPointer - 1].GetCalcStatus();

            // ボタン活性／非活性設定
            ButtonEnabledSet();

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {// 親フォームがある場合
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {// 親フォームがない場合
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（削除・切り取り）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoDeleteCut(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoDeleteCut(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<McGraphicsElement> csOrgElmList = csHistory.HistoryData[0] as List<McGraphicsElement>;
            List<McGraphicsElement> csTransPortList = csHistory.HistoryData[1] as List<McGraphicsElement>;
            List<List<HySIdentifier>> csConnectionIDList = csHistory.HistoryData[2] as List<List<HySIdentifier>>;
            if ((csOrgElmList == null) ||
                (csTransPortList == null) ||
                (csConnectionIDList == null))
            {// 保存情報異常の場合
                return;
            }

            List<McGraphicsElement> csElmList = new List<McGraphicsElement>();
            for (int iLp = 0; iLp < csOrgElmList.Count; iLp++)
            {// 要素数ループ
                csElmList.Add(csOrgElmList[iLp].CopyInfUsedByUndoRedoOnly(null));
            }

            // 要素の復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if ((csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE) ||
                    (csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN) ||
                    (csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT) ||
                    (csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_RECEIVE) ||
                    (csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_SEND))
                {// 接続線・端子・中継端子の場合
                    continue;
                }

                if (csParent == null)
                {// 処理対象親要素がない場合
                    m_csDispElmList[0].Add(csElmList[iLp]);
                    m_csGraphicsManager.GetStructInfo().AddElement(csElmList[iLp].GetViewerElm());
                }
                else
                {// 処理対象親要素がある場合
                    csSearchElement = SearchElement(csParent.GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        ((McGraphicsGroupElement)csSearchElement).AddElement(csElmList[iLp]);
                        ((McStructGroupElement)csSearchElement.GetViewerElm()).AddElement(csElmList[iLp].GetViewerElm());
                    }
                }
            }

            // 削除端子の復元
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if ((csElmList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                    (csElmList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT) &&
                    (csElmList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_RECEIVE) &&
                    (csElmList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_SEND))
                {// 端子・中継端子以外の場合
                    continue;
                }
                csSearchElement = SearchElement(csElmList[iLp].GetParentElm().GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    if (csSearchElement.GetPort(csElmList[iLp].GetID()) == null)
                    {// 端子がなかった場合
                        csSearchElement.AddPort(csElmList[iLp]);
                        m_csGraphicsManager.ReSetPortPosition(csSearchElement);
                    }
                    if (csSearchElement.GetViewerElm().GetPort(csElmList[iLp].GetViewerPort().GetID()) == null)
                    {// 端子がなかった場合
                        csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csElmList[iLp].GetViewerPort());
                    }
                }
            }

            // 設定変更中継端子の復元
            for (int iLp = 0; iLp < csTransPortList.Count; iLp++)
            {// 中継端子数ループ
                if ((csTransPortList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                    (csTransPortList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                {// 中継端子以外の場合
                    continue;
                }

                csSearchElement = SearchElement(csTransPortList[iLp].GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetPortID(csConnectionIDList[iLp][0], csConnectionIDList[iLp][1]);
                    ((McGraphicsTransElement)csSearchElement).SetTransID(csConnectionIDList[iLp][2], csConnectionIDList[iLp][3]);
                }
            }

            // 接続線の復元
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if (csElmList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_LINE)
                {// 接続線以外の場合
                    continue;
                }

                csElmList[iLp].GetPortID(ref csFromID, ref csToID);
                csFromPort = SearchElement(csFromID);
                csToPort = SearchElement(csToID);
                csElmList[iLp].DelPort(1);
                csElmList[iLp].DelPort(0);
                csElmList[iLp].AddPort(csFromPort);
                csElmList[iLp].AddPort(csToPort);

                if (csElmList[iLp].GetParentElm() == null)
                {// 親要素がない場合
                    m_csDispLineList.Add(csElmList[iLp]);
                    m_csGraphicsManager.GetStructInfo().AddConnectionUsedByUndoRedoOnly(csElmList[iLp].GetViewerConnect());
                }
                else
                {// 親要素がある場合
                    csSearchElement = SearchElement(csElmList[iLp].GetParentElm().GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        ((McGraphicsGroupElement)csSearchElement).AddLineElement(csElmList[iLp]);
                        ((McStructGroupElement)csSearchElement.GetViewerElm()).AddConnectionUsedByUndoRedoOnly(csElmList[iLp].GetViewerConnect());
                    }
                }
                csElmList[iLp].GetViewerConnect().SetConnectionTranInfo(csElmList[iLp].GetViewerConnect().GetTranInfo(), null);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（削除・切り取り）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoDeleteCut(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoDeleteCut(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<McGraphicsElement> csElmList = csHistory.HistoryData[0] as List<McGraphicsElement>;
            if (csElmList == null)
            {// 保存情報異常の場合
                return;
            }

            // 選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            // 削除要素選択
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmList[iLp].GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    m_csGraphicsManager.AddSelectionList(csSearchElement);
                }
            }

            // 要素削除
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    m_csGraphicsManager.DelElement(m_csDispElmList[0], m_csDispLineList, (McGraphicsGroupElement)csSearchElement);
                }
            }
            else
            {// 処理対象親要素がない場合
                m_csGraphicsManager.DelElement(m_csDispElmList[0], m_csDispLineList, null);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（要素名称設定）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoChangeName(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoChangeName(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            HySIdentifier csElementID = csHistory.HistoryData[0] as HySIdentifier;
            HySString csName = csHistory.HistoryData[1] as HySString;
            if ((csElementID == null) ||
                ((object)csName == null))
            {// 保存情報異常の場合
                return;
            }

            // 要素名称復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csElementID);
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.SetElementName(csName);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（要素名称設定）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoChangeName(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoChangeName(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            HySIdentifier csElementID = csHistory.HistoryData[0] as HySIdentifier;
            HySString csName = csHistory.HistoryData[2] as HySString;
            if ((csElementID == null) ||
                ((object)csName == null))
            {// 保存情報異常の場合
                return;
            }

            // 要素名称復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csElementID);
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.SetElementName(csName);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（貼り付け）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoPaste(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoPaste(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<McGraphicsElement> csElmList = csHistory.HistoryData[0] as List<McGraphicsElement>;
            if (csElmList == null)
            {// 保存情報異常の場合
                return;
            }

            // 要素削除
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if (csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                {// 接続線の場合
                    continue;
                }
                if (csParent == null)
                {// 処理対象親要素がない場合
                    for (int iLp2 = 0; iLp2 < m_csDispElmList[0].Count; iLp2++)
                    {// 要素数ループ
                        if (csElmList[iLp].GetID().Equals(m_csDispElmList[0][iLp2].GetID()) == true)
                        {// IDが一致した場合
                            m_csDispElmList[0].RemoveAt(iLp2);
                            m_csGraphicsManager.GetStructInfo().RemoveElement(csElmList[iLp].GetID());
                            break;
                        }
                    }
                }
                else
                {// 処理対象親要素がある場合
                    csSearchElement = SearchElement(csParent.GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        for (int iLp2 = 0; iLp2 < ((McGraphicsGroupElement)csSearchElement).GetElmCount(); iLp2++)
                        {// グループ内要素数ループ
                            if (csElmList[iLp].GetID().Equals(((McGraphicsGroupElement)csSearchElement).GetElement(iLp2).GetID()) == true)
                            {// IDが一致した場合
                                ((McGraphicsGroupElement)csSearchElement).DelElement(iLp2);
                                ((McStructGroupElement)csSearchElement.GetViewerElm()).RemoveElement(csElmList[iLp].GetID());
                                break;
                            }
                        }
                    }
                }
            }

            // 接続線削除
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if (csElmList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_LINE)
                {// 接続線以外の場合
                    continue;
                }
                if (csElmList[iLp].GetParentElm() == null)
                {// 親要素がない場合
                    for (int iLp2 = 0; iLp2 < m_csDispLineList.Count; iLp2++)
                    {// 接続線数ループ
                        if (csElmList[iLp].GetID().Equals(m_csDispLineList[iLp2].GetID()) == true)
                        {// IDが一致した場合
                            m_csDispLineList.RemoveAt(iLp2);
                            m_csGraphicsManager.GetStructInfo().DeleteConnection(csElmList[iLp].GetID());
                            break;
                        }
                    }
                }
                else
                {// 親要素がある場合
                    csSearchElement = SearchElement(csElmList[iLp].GetParentElm().GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        for (int iLp2 = 0; iLp2 < ((McGraphicsGroupElement)csSearchElement).GetLineElmCount(); iLp2++)
                        {// グループ内接続線数ループ
                            if (csElmList[iLp].GetID().Equals(((McGraphicsGroupElement)csSearchElement).GetLineElement(iLp2).GetID()) == true)
                            {// IDが一致した場合
                                ((McGraphicsGroupElement)csSearchElement).DelLineElement(iLp2);
                                ((McStructGroupElement)csSearchElement.GetViewerElm()).DeleteConnection(csElmList[iLp].GetID());
                                break;
                            }
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（貼り付け）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoPaste(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoPaste(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<McGraphicsElement> csOrgElmList = csHistory.HistoryData[0] as List<McGraphicsElement>;
            if (csOrgElmList == null)
            {// 保存情報異常の場合
                return;
            }

            List<McGraphicsElement> csElmList = new List<McGraphicsElement>();
            for (int iLp = 0; iLp < csOrgElmList.Count; iLp++)
            {// 要素数ループ
                csElmList.Add(csOrgElmList[iLp].CopyInfUsedByUndoRedoOnly(null));
            }

            // 要素の復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if (csElmList[iLp].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                {// 接続線の場合
                    continue;
                }
                if (csParent == null)
                {// 処理対象親要素がない場合
                    m_csDispElmList[0].Add(csElmList[iLp]);
                    m_csGraphicsManager.GetStructInfo().AddElement(csElmList[iLp].GetViewerElm());
                }
                else
                {// 処理対象親要素がある場合
                    csSearchElement = SearchElement(csParent.GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        ((McGraphicsGroupElement)csSearchElement).AddElement(csElmList[iLp]);
                        ((McStructGroupElement)csSearchElement.GetViewerElm()).AddElement(csElmList[iLp].GetViewerElm());
                    }
                }
            }

            // 接続線の復元
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if (csElmList[iLp].GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_LINE)
                {// 接続線以外の場合
                    continue;
                }

                csElmList[iLp].GetPortID(ref csFromID, ref csToID);
                csFromPort = SearchElement(csFromID);
                csToPort = SearchElement(csToID);
                csElmList[iLp].DelPort(1);
                csElmList[iLp].DelPort(0);
                csElmList[iLp].AddPort(csFromPort);
                csElmList[iLp].AddPort(csToPort);

                if (csElmList[iLp].GetParentElm() == null)
                {// 親要素がない場合
                    m_csDispLineList.Add(csElmList[iLp]);
                    m_csGraphicsManager.GetStructInfo().AddConnectionUsedByUndoRedoOnly(csElmList[iLp].GetViewerConnect());
                }
                else
                {// 親要素がある場合
                    csSearchElement = SearchElement(csElmList[iLp].GetParentElm().GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        ((McGraphicsGroupElement)csSearchElement).AddLineElement(csElmList[iLp]);
                        ((McStructGroupElement)csSearchElement.GetViewerElm()).AddConnectionUsedByUndoRedoOnly(csElmList[iLp].GetViewerConnect());
                    }
                }
                csElmList[iLp].GetViewerConnect().SetConnectionTranInfo(csElmList[iLp].GetViewerConnect().GetTranInfo(), null);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（要素配置）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoPlacement(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoPlacement(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<McGraphicsElement> csElmList = csHistory.HistoryData[0] as List<McGraphicsElement>;
            if (csElmList == null)
            {// 保存情報異常の場合
                return;
            }

            // 要素削除
            if (csParent == null)
            {// 処理対象親要素がない場合
                for (int iLp = 0; iLp < m_csDispElmList[0].Count; iLp++)
                {// 要素数ループ
                    if (csElmList[0].GetID().Equals(m_csDispElmList[0][iLp].GetID()) == true)
                    {// IDが一致した場合
                        m_csDispElmList[0].RemoveAt(iLp);
                        m_csGraphicsManager.GetStructInfo().RemoveElement(csElmList[0].GetID());
                        break;
                    }
                }
            }
            else
            {// 処理対象親要素がある場合
                McGraphicsElement csSearchElement = null;
                csSearchElement = SearchElement(csParent.GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    for (int iLp = 0; iLp < ((McGraphicsGroupElement)csSearchElement).GetElmCount(); iLp++)
                    {// グループ内要素数ループ
                        if (csElmList[0].GetID().Equals(((McGraphicsGroupElement)csSearchElement).GetElement(iLp).GetID()) == true)
                        {// IDが一致した場合
                            ((McGraphicsGroupElement)csSearchElement).DelElement(iLp);
                            ((McStructGroupElement)csSearchElement.GetViewerElm()).RemoveElement(csElmList[0].GetID());
                            break;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（要素配置）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoPlacement(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoPlacement(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<McGraphicsElement> csOrgElmList = csHistory.HistoryData[0] as List<McGraphicsElement>;
            if (csOrgElmList == null)
            {// 保存情報異常の場合
                return;
            }

            List<McGraphicsElement> csElmList = new List<McGraphicsElement>();
            for (int iLp = 0; iLp < csOrgElmList.Count; iLp++)
            {// 要素数ループ
                csElmList.Add(csOrgElmList[iLp].CopyInfUsedByUndoRedoOnly(null));
            }

            // 要素の復元
            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if (csParent == null)
                {// 処理対象親要素がない場合
                    m_csDispElmList[0].Add(csElmList[iLp]);
                    m_csGraphicsManager.GetStructInfo().AddElement(csElmList[iLp].GetViewerElm());
                }
                else
                {// 処理対象親要素がある場合
                    McGraphicsElement csSearchElement = null;
                    csSearchElement = SearchElement(csParent.GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        ((McGraphicsGroupElement)csSearchElement).AddElement(csElmList[iLp]);
                        ((McStructGroupElement)csSearchElement.GetViewerElm()).AddElement(csElmList[iLp].GetViewerElm());
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（要素接続）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoElementConnection(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoElementConnection(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csLine = csHistory.HistoryData[0] as McGraphicsElement;
            List<HySIdentifier> csAddPortIDList = csHistory.HistoryData[1] as List<HySIdentifier>;
            if ((csLine == null) ||
                (csAddPortIDList == null))
            {// 保存情報異常の場合
                return;
            }

            // 接続線削除
            McGraphicsElement csSearchElement = null;
            if (csParent == null)
            {// 処理対象親要素がない場合
                for (int iLp = 0; iLp < m_csDispLineList.Count; iLp++)
                {// 接続線数ループ
                    if (csLine.GetID().Equals(m_csDispLineList[iLp].GetID()) == true)
                    {// IDが一致した場合
                        m_csDispLineList.RemoveAt(iLp);
                        m_csGraphicsManager.GetStructInfo().DeleteConnection(csLine.GetID());
                        break;
                    }
                }
            }
            else
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
                for (int iLp = 0; iLp < ((McGraphicsGroupElement)csSearchElement).GetLineElmCount(); iLp++)
                {// グループ内接続線数ループ
                    if (csLine.GetID().Equals(((McGraphicsGroupElement)csSearchElement).GetLineElement((long)iLp).GetID()) == true)
                    {// IDが一致した場合
                        ((McGraphicsGroupElement)csSearchElement).DelLineElement((long)iLp);
                        ((McStructGroupElement)csSearchElement.GetViewerElm()).DeleteConnection(csLine.GetID());
                        break;
                    }
                }
            }

            // 作成端子削除
            for (int iLp = 0; iLp < csAddPortIDList.Count; iLp++)
            {// 追加端子数ループ
                csSearchElement = SearchElement(csAddPortIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.GetParentElm().DelPort(csAddPortIDList[iLp]);
                    csSearchElement.GetParentElm().GetViewerElm().DelPort(csAddPortIDList[iLp]);
                    m_csGraphicsManager.ReSetPortPosition(csSearchElement.GetParentElm());
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（要素接続）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoElementConnection(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoElementConnection(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csOrgLine = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csLine = csOrgLine.CopyInfUsedByUndoRedoOnly(null);
            if (csLine == null)
            {// 保存情報異常の場合
                return;
            }

            // 端子の復元
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            csLine.GetPortID(ref csFromID, ref csToID);
            csFromPort = csLine.GetPort(csFromID);
            csToPort = csLine.GetPort(csToID);

            McGraphicsElement csSearchElement = null;
            if ((csFromPort.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                (csFromPort.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
            {// 中継端子以外の場合
                csSearchElement = SearchElement(csFromPort.GetParentElm().GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.AddPort(csFromPort);
                    csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csFromPort.GetViewerPort());
                    m_csGraphicsManager.ReSetPortPosition(csSearchElement);
                }
            }
            else
            {// 中継端子の場合
                csSearchElement = SearchElement(csFromPort.GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    if (csSearchElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
                    {// 流入中継端子の場合
                        ((McGraphicsTransElement)csSearchElement).SetTransID(csFromID, csToID);
                    }
                    else
                    {// 流入中継端子以外の場合
                        csSearchElement.SetPortID(csFromID, csToID);
                    }
                }
                else
                {// 検索できなかった場合
                    csSearchElement = SearchElement(csFromPort.GetParentElm().GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.AddPort(csFromPort);
                        csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csFromPort.GetViewerPort());
                        m_csGraphicsManager.ReSetPortPosition(csSearchElement);
                    }
                }
            }
            if ((csToPort.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                (csToPort.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
            {// 中継端子以外の場合
                csSearchElement = SearchElement(csToPort.GetParentElm().GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.AddPort(csToPort);
                    csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csToPort.GetViewerPort());
                    m_csGraphicsManager.ReSetPortPosition(csSearchElement);
                }
            }
            else
            {// 中継端子の場合
                csSearchElement = SearchElement(csToPort.GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    if (csSearchElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
                    {// 流入中継端子の場合
                        csSearchElement.SetPortID(csFromID, csToID);
                    }
                    else
                    {// 流入中継端子以外の場合
                        ((McGraphicsTransElement)csSearchElement).SetTransID(csFromID, csToID);
                    }
                }
                else
                {// 検索できなかった場合
                    csSearchElement = SearchElement(csToPort.GetParentElm().GetID());
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.AddPort(csToPort);
                        csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csToPort.GetViewerPort());
                        m_csGraphicsManager.ReSetPortPosition(csSearchElement);
                    }
                }
            }

            // 接続線の復元
            csLine.GetPortID(ref csFromID, ref csToID);
            csFromPort = SearchElement(csFromID);
            csToPort = SearchElement(csToID);
            csLine.DelPort(1);
            csLine.DelPort(0);
            csLine.AddPort(csFromPort);
            csLine.AddPort(csToPort);

            if (csLine.GetParentElm() == null)
            {// 親要素がない場合
                m_csDispLineList.Add(csLine);
                m_csGraphicsManager.GetStructInfo().AddConnectionUsedByUndoRedoOnly(csLine.GetViewerConnect());
            }
            else
            {// 親要素がある場合
                csSearchElement = SearchElement(csLine.GetParentElm().GetID());
                if (csSearchElement != null)
                {// 検索できた場合
                    ((McGraphicsGroupElement)csSearchElement).AddLineElement(csLine);
                    ((McStructGroupElement)csSearchElement.GetViewerElm()).AddConnectionUsedByUndoRedoOnly(csLine.GetViewerConnect());
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（要素移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoElementMove(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoElementMove(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<Point> csBeforePointList = csHistory.HistoryData[1] as List<Point>;
            if ((csElmIDList == null) ||
                (csBeforePointList == null))
            {// 保存情報異常の場合
                return;
            }

            // 要素位置復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    if ((csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 中継端子以外の場合
                        csSearchElement.SetPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                    }
                    else
                    {// 中継端子の場合
                        if (csParent != null)
                        {// 処理対象親要素がある場合
                            if (csParent.GetID().Equals(csSearchElement.GetParentElm().GetID()) == true)
                            {// IDが一致した場合
                                ((McGraphicsTransElement)csSearchElement).SetInnerPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                            }
                            else
                            {// IDが一致しなかった場合
                                csSearchElement.SetPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                            }
                        }
                        else
                        {// 処理対象親要素がない場合
                            csSearchElement.SetPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（要素移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoElementmove(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoElementmove(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<Point> csAfterPointList = csHistory.HistoryData[2] as List<Point>;
            if ((csElmIDList == null) ||
                (csAfterPointList == null))
            {// 保存情報異常の場合
                return;
            }

            // 要素位置復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    if ((csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 中継端子以外の場合
                        csSearchElement.SetPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                    }
                    else
                    {// 中継端子の場合
                        if (csParent != null)
                        {// 処理対象親要素がある場合
                            if (csParent.GetID().Equals(csSearchElement.GetParentElm().GetID()) == true)
                            {// IDが一致した場合
                                ((McGraphicsTransElement)csSearchElement).SetInnerPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                            }
                            else
                            {// IDが一致しなかった場合
                                csSearchElement.SetPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                            }
                        }
                        else
                        {// 処理対象親要素がない場合
                            csSearchElement.SetPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（端子移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoPortMove(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoPortMove(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csPortIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<double> csBeforeAngleList = csHistory.HistoryData[1] as List<double>;
            List<Point> csBeforePointList = csHistory.HistoryData[3] as List<Point>;
            if ((csPortIDList == null) ||
                (csBeforeAngleList == null) ||
                (csBeforePointList == null))
            {// 保存情報異常の場合
                return;
            }

            // 端子位置・向き復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csPortIDList.Count; iLp++)
            {// 端子数ループ
                csSearchElement = SearchElement(csPortIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetRotate(csBeforeAngleList[iLp]);
                    csSearchElement.SetPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（端子移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoPortmove(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoPortmove(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csPortIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<double> csAfterAngleList = csHistory.HistoryData[2] as List<double>;
            List<Point> csAfterePointList = csHistory.HistoryData[4] as List<Point>;
            if ((csPortIDList == null) ||
                (csAfterAngleList == null) ||
                (csAfterePointList == null))
            {// 保存情報異常の場合
                return;
            }

            // 端子位置・向き復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csPortIDList.Count; iLp++)
            {// 端子数ループ
                csSearchElement = SearchElement(csPortIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetRotate(csAfterAngleList[iLp]);
                    csSearchElement.SetPosition((long)csAfterePointList[iLp].X, (long)csAfterePointList[iLp].Y);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（要素サイズ変更）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoResize(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoResize(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            HySIdentifier csElementID = csHistory.HistoryData[0] as HySIdentifier;
            Point csBeforePoint = (Point)csHistory.HistoryData[1];
            long csBeforeWidth = (long)csHistory.HistoryData[2];
            long csBeforeHeight = (long)csHistory.HistoryData[3];
            if ((csElementID == null) ||
                (csBeforePoint == null))
            {// 保存情報異常の場合
                return;
            }

            // 要素位置・サイズ復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csElementID);
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.SetPosition((long)csBeforePoint.X, (long)csBeforePoint.Y);
                csSearchElement.SetElementSize(csBeforeWidth, csBeforeHeight);
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（要素サイズ変更）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoResize(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoResize(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            HySIdentifier csElementID = csHistory.HistoryData[0] as HySIdentifier;
            Point csAfterPoint = (Point)csHistory.HistoryData[4];
            long csAfterWidth = (long)csHistory.HistoryData[5];
            long csAfterHeight = (long)csHistory.HistoryData[6];
            if ((csElementID == null) ||
                (csAfterPoint == null))
            {// 保存情報異常の場合
                return;
            }

            // 要素位置・サイズ復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csElementID);
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.SetPosition((long)csAfterPoint.X, (long)csAfterPoint.Y);
                csSearchElement.SetElementSize(csAfterWidth, csAfterHeight);
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（モデル設定（演算モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoModelSetElement(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoModelSetElement(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<McModelInfo> csBeforeModelList = csHistory.HistoryData[1] as List<McModelInfo>;
            List<List<HySIdentifier>> csElmIDListList = csHistory.HistoryData[3] as List<List<HySIdentifier>>;
            List<List<McModelInfo>> csTranListlList = csHistory.HistoryData[4] as List<List<McModelInfo>>;
            if ((csElmIDList == null) ||
                (csBeforeModelList == null) ||
                (csElmIDListList == null) ||
                (csTranListlList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csBeforeModelList[iLp]);
                }
            }

            // 接続情報復元
            for (int iLp1 = 0; iLp1 < csElmIDListList.Count; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < csElmIDListList[iLp1].Count; iLp2++)
                {
                    csSearchElement = SearchElement(csElmIDListList[iLp1][iLp2]);
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.SetModelInfo(csTranListlList[iLp1][iLp2]);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（モデル設定（演算モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoModelSetElement(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoModelSetElement(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            McModelInfo csAfterModel = csHistory.HistoryData[2] as McModelInfo;
            List<List<HySIdentifier>> csElmIDListList = csHistory.HistoryData[3] as List<List<HySIdentifier>>;
            List<List<McModelInfo>> csModTranListList = csHistory.HistoryData[5] as List<List<McModelInfo>>;
            if ((csElmIDList == null) ||
                (csAfterModel == null) ||
                (csElmIDListList == null) ||
                (csModTranListList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csAfterModel.Clone());
                }
            }

            // 接続情報復元
            for (int iLp1 = 0; iLp1 < csElmIDListList.Count; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < csElmIDListList[iLp1].Count; iLp2++)
                {
                    csSearchElement = SearchElement(csElmIDListList[iLp1][iLp2]);
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.SetModelInfo(csModTranListList[iLp1][iLp2]);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（モデル設定（入力モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoModelSetInput(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoModelSetInput(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<McModelInfo> csBeforeModelList = csHistory.HistoryData[1] as List<McModelInfo>;
            List<List<HySIdentifier>> csElmIDListList = csHistory.HistoryData[3] as List<List<HySIdentifier>>;
            List<List<McModelInfo>> csTranListlList = csHistory.HistoryData[4] as List<List<McModelInfo>>;
            if ((csElmIDList == null) ||
                (csBeforeModelList == null) ||
                (csElmIDListList == null) ||
                (csTranListlList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csBeforeModelList[iLp]);
                }
            }

            // 接続情報復元
            for (int iLp1 = 0; iLp1 < csElmIDListList.Count; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < csElmIDListList[iLp1].Count; iLp2++)
                {
                    csSearchElement = SearchElement(csElmIDListList[iLp1][iLp2]);
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.SetModelInfo(csTranListlList[iLp1][iLp2]);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（モデル設定（入力モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoModelSetInput(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoModelSetInput(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            McModelInfo csAfterModel = csHistory.HistoryData[2] as McModelInfo;
            List<List<HySIdentifier>> csElmIDListList = csHistory.HistoryData[3] as List<List<HySIdentifier>>;
            List<List<McModelInfo>> csModTranListList = csHistory.HistoryData[5] as List<List<McModelInfo>>;
            if ((csElmIDList == null) ||
                (csAfterModel == null) ||
                (csElmIDListList == null) ||
                (csModTranListList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csAfterModel.Clone());
                }
            }

            // 接続情報復元
            for (int iLp1 = 0; iLp1 < csElmIDListList.Count; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < csElmIDListList[iLp1].Count; iLp2++)
                {
                    csSearchElement = SearchElement(csElmIDListList[iLp1][iLp2]);
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.SetModelInfo(csModTranListList[iLp1][iLp2]);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（モデル設定（出力モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoModelSetOutput(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoModelSetOutput(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<McModelInfo> csBeforeModelList = csHistory.HistoryData[1] as List<McModelInfo>;
            List<List<HySIdentifier>> csElmIDListList = csHistory.HistoryData[3] as List<List<HySIdentifier>>;
            List<List<McModelInfo>> csTranListlList = csHistory.HistoryData[4] as List<List<McModelInfo>>;
            if ((csElmIDList == null) ||
                (csBeforeModelList == null) ||
                (csElmIDListList == null) ||
                (csTranListlList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csBeforeModelList[iLp]);
                }
            }

            // 接続情報復元
            for (int iLp1 = 0; iLp1 < csElmIDListList.Count; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < csElmIDListList[iLp1].Count; iLp2++)
                {
                    csSearchElement = SearchElement(csElmIDListList[iLp1][iLp2]);
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.SetModelInfo(csTranListlList[iLp1][iLp2]);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（モデル設定（出力モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoModelSetOutput(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoModelSetOutput(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            McModelInfo csAfterModel = csHistory.HistoryData[2] as McModelInfo;
            List<List<HySIdentifier>> csElmIDListList = csHistory.HistoryData[3] as List<List<HySIdentifier>>;
            List<List<McModelInfo>> csModTranListList = csHistory.HistoryData[5] as List<List<McModelInfo>>;
            if ((csElmIDList == null) ||
                (csAfterModel == null) ||
                (csElmIDListList == null) ||
                (csModTranListList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csAfterModel.Clone());
                }
            }

            // 接続情報復元
            for (int iLp1 = 0; iLp1 < csElmIDListList.Count; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < csElmIDListList[iLp1].Count; iLp2++)
                {
                    csSearchElement = SearchElement(csElmIDListList[iLp1][iLp2]);
                    if (csSearchElement != null)
                    {// 検索できた場合
                        csSearchElement.SetModelInfo(csModTranListList[iLp1][iLp2]);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（モデル設定（伝送モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoModelSetTrans(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoModelSetTrans(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<McModelInfo> csBeforeModelList = csHistory.HistoryData[1] as List<McModelInfo>;
            if ((csElmIDList == null) ||
                (csBeforeModelList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csBeforeModelList[iLp]);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（モデル設定（伝送モデル））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoModelSetTrans(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoModelSetTrans(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            //McModelInfo csAfterModel = csHistory.HistoryData[2] as McModelInfo;
            List<McModelInfo> csAfterModelList = csHistory.HistoryData[2] as List<McModelInfo>;
            if ((csElmIDList == null) ||
                //(csAfterModel == null))
                (csAfterModelList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    //csSearchElement.SetModelInfo(csAfterModel.Clone());
                    csSearchElement.SetModelInfo(csAfterModelList[iLp]);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（モデル解除）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoModelCancel(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoModelCancel(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<McModelInfo> csBeforeModelList = csHistory.HistoryData[1] as List<McModelInfo>;
            if ((csElmIDList == null) ||
                (csBeforeModelList == null))
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.SetModelInfo(csBeforeModelList[iLp]);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（モデル解除）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoModelCancel(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoModelCancel(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            if (csElmIDList == null)
            {// 保存情報異常の場合
                return;
            }

            // モデル復元
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    csSearchElement.CancelModelInfo();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（要素回転）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoRotation(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoRotation(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            double csRotation = (double)csHistory.HistoryData[1];
            if (csElmIDList == null)
            {// 保存情報異常の場合
                return;
            }

            // 選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            // 回転要素選択
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    m_csGraphicsManager.AddSelectionList(csSearchElement);
                }
            }

            List<HySIdentifier> csWorkList = new List<HySIdentifier>();

            // 向き復元
            if (csRotation == McDefine.HYM_DRAW_ANGLE_90)
            {// 向きが９０の場合
                m_csGraphicsManager.ElementRotate(McDefine.HYM_DRAW_ANGLE_M90, ref csWorkList);
            }
            else
            {// 向きが９０以外の場合
                m_csGraphicsManager.ElementRotate(McDefine.HYM_DRAW_ANGLE_90, ref csWorkList);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（要素回転）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoRotation(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoRotation(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            double csRotation = (double)csHistory.HistoryData[1];
            if (csElmIDList == null)
            {// 保存情報異常の場合
                return;
            }

            // 選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            // 回転要素選択
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    m_csGraphicsManager.AddSelectionList(csSearchElement);
                }
            }

            List<HySIdentifier> csWorkList = new List<HySIdentifier>();

            // 向き復元
            m_csGraphicsManager.ElementRotate(csRotation, ref csWorkList);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（グループ化）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoGrouping(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoGrouping(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csElement = csHistory.HistoryData[0] as McGraphicsElement;
            if (csElement == null)
            {// 保存情報異常の場合
                return;
            }

            // グループ化復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csElement.GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                m_csGraphicsManager.DisbandObject((McGraphicsGroupElement)csSearchElement, m_csDispElmList[0], m_csDispLineList);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（グループ化）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoGrouping(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoGrouping(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csOrgElement = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csElement = csOrgElement.CopyInfUsedByUndoRedoOnly(null);
            if (csElement == null)
            {// 保存情報異常の場合
                return;
            }

            // グループ化復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }
            m_csGraphicsManager.GroupObject((McGraphicsGroupElement)csElement, new List<McGraphicsElement>(), m_csDispElmList[0], m_csDispLineList, (McGraphicsGroupElement)csSearchElement);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（グループ解除）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoCancelationGrouping(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoCancelationGrouping(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csOrgElement = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csElement = csOrgElement.CopyInfUsedByUndoRedoOnly(null);
            List<HySIdentifier> csMoveElmIDList = csHistory.HistoryData[1] as List<HySIdentifier>;
            List<Point> csBeforePointList = csHistory.HistoryData[2] as List<Point>;
            List<McGraphicsElement> csDelOuterLineList = csHistory.HistoryData[4] as List<McGraphicsElement>;
            if ((csElement == null) ||
                (csMoveElmIDList == null) ||
                (csBeforePointList == null) ||
                (csDelOuterLineList == null))
            {// 保存情報異常の場合
                return;
            }

            // グループ化復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }
            m_csGraphicsManager.GroupObject((McGraphicsGroupElement)csElement, csDelOuterLineList, m_csDispElmList[0], m_csDispLineList, (McGraphicsGroupElement)csSearchElement);

            // 移動要素位置復元
            for (int iLp = csMoveElmIDList.Count - 1; iLp >= 0; iLp--)
            {// 要素数ループ
                csSearchElement = SearchElement(csMoveElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    if ((csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 中継端子以外の場合
                        csSearchElement.SetPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                    }
                    else
                    {// 中継端子の場合
                        if (csParent != null)
                        {// 処理対象親要素がある場合
                            if (csParent.GetID().Equals(csSearchElement.GetParentElm().GetID()) == true)
                            {// IDが一致した場合
                                ((McGraphicsTransElement)csSearchElement).SetInnerPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                            }
                            else
                            {// IDが一致しなかった場合
                                csSearchElement.SetPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                            }
                        }
                        else
                        {// 処理対象親要素がない場合
                            csSearchElement.SetPosition((long)csBeforePointList[iLp].X, (long)csBeforePointList[iLp].Y);
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（グループ解除）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoCancelationGrouping(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoCancelationGrouping(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csElement = csHistory.HistoryData[0] as McGraphicsElement;
            List<HySIdentifier> csMoveElmIDList = csHistory.HistoryData[1] as List<HySIdentifier>;
            List<Point> csAfterPointList = csHistory.HistoryData[3] as List<Point>;
            if ((csElement == null) ||
                (csMoveElmIDList == null) ||
                (csAfterPointList == null))
            {// 保存情報異常の場合
                return;
            }

            // グループ化復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csElement.GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                m_csGraphicsManager.DisbandObject((McGraphicsGroupElement)csSearchElement, m_csDispElmList[0], m_csDispLineList);
            }

            // 移動要素位置復元
            for (int iLp = 0; iLp < csMoveElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csMoveElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    if ((csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                        (csSearchElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
                    {// 中継端子以外の場合
                        csSearchElement.SetPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                    }
                    else
                    {// 中継端子の場合
                        if (csParent != null)
                        {// 処理対象親要素がある場合
                            if (csParent.GetID().Equals(csSearchElement.GetParentElm().GetID()) == true)
                            {// IDが一致した場合
                                ((McGraphicsTransElement)csSearchElement).SetInnerPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                            }
                            else
                            {// IDが一致しなかった場合
                                csSearchElement.SetPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                            }
                        }
                        else
                        {// 処理対象親要素がない場合
                            csSearchElement.SetPosition((long)csAfterPointList[iLp].X, (long)csAfterPointList[iLp].Y);
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（外部接続（受信））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoExternalConnectionReceive(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoExternalConnectionReceive(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csRelayPort = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csLine = csHistory.HistoryData[1] as McGraphicsElement;
            McGraphicsElement csPort = csHistory.HistoryData[2] as McGraphicsElement;
            if ((csRelayPort == null) ||
                (csLine == null) ||
                (csPort == null))
            {// 保存情報異常の場合
                return;
            }

            // 端子削除
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csPort.GetParentElm().GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.DelPort(csPort.GetID());
                csSearchElement.GetViewerElm().DelPort(csPort.GetID());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }

            // 接続線・中継端子削除
            csSearchElement = SearchElement(csParent.GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                for (int iLp = 0; iLp < ((McGraphicsGroupElement)csSearchElement).GetLineElmCount(); iLp++)
                {// グループ内接続線数ループ
                    if (csLine.GetID().Equals(((McGraphicsGroupElement)csSearchElement).GetLineElement(iLp).GetID()) == true)
                    {// IDが一致した場合
                        ((McGraphicsGroupElement)csSearchElement).DelLineElement(iLp);
                        break;
                    }
                }
                csSearchElement.DelPort(csRelayPort.GetID());
                csSearchElement.GetViewerElm().DelPort(csRelayPort.GetID());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（外部接続（受信））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoExternalConnectionReceive(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoExternalConnectionReceive(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csOrgRelayPort = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csRelayPort = csOrgRelayPort.CopyInfUsedByUndoRedoOnly(null);
            McGraphicsElement csOrgLine = csHistory.HistoryData[1] as McGraphicsElement;
            McGraphicsElement csLine = csOrgLine.CopyInfUsedByUndoRedoOnly(null);
            McGraphicsElement csOrgPort = csHistory.HistoryData[2] as McGraphicsElement;
            McGraphicsElement csPort = csOrgPort.CopyInfUsedByUndoRedoOnly(null);
            if ((csRelayPort == null) ||
                (csLine == null) ||
                (csPort == null))
            {// 保存情報異常の場合
                return;
            }

            // 端子の復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csPort.GetParentElm().GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.AddPort(csPort);
                csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csPort.GetViewerPort());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }

            // 中継端子・接続線の復元
            csSearchElement = SearchElement(csParent.GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.AddPort(csRelayPort);
                csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csRelayPort.GetViewerPort());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
                csLine.DelPort(1);
                csLine.DelPort(0);
                HySIdentifier csFromID = null;
                HySIdentifier csToID = null;
                csLine.GetPortID(ref csFromID, ref csToID);
                if (csFromID.Equals(csRelayPort.GetID()) == true)
                {// IDが一致した場合
                    csLine.AddPort(csRelayPort);
                    csLine.AddPort(csPort);
                }
                else
                {// IDが一致しなかった場合
                    csLine.AddPort(csPort);
                    csLine.AddPort(csRelayPort);
                }
                ((McGraphicsGroupElement)csSearchElement).AddLineElement(csLine);
                ((McStructGroupElement)csSearchElement.GetViewerElm()).AddConnectionUsedByUndoRedoOnly(csLine.GetViewerConnect());
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（外部接続（送信））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoExternalConnectionSend(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoExternalConnectionSend(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csRelayPort = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csLine = csHistory.HistoryData[1] as McGraphicsElement;
            McGraphicsElement csPort = csHistory.HistoryData[2] as McGraphicsElement;
            if ((csRelayPort == null) ||
                (csLine == null) ||
                (csPort == null))
            {// 保存情報異常の場合
                return;
            }

            // 端子削除
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csPort.GetParentElm().GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.DelPort(csPort.GetID());
                csSearchElement.GetViewerElm().DelPort(csPort.GetID());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }

            // 接続線・中継端子削除
            csSearchElement = SearchElement(csParent.GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                for (int iLp = 0; iLp < ((McGraphicsGroupElement)csSearchElement).GetLineElmCount(); iLp++)
                {// グループ内接続線数ループ
                    if (csLine.GetID().Equals(((McGraphicsGroupElement)csSearchElement).GetLineElement(iLp).GetID()) == true)
                    {// IDが一致した場合
                        ((McGraphicsGroupElement)csSearchElement).DelLineElement(iLp);
                        break;
                    }
                }
                csSearchElement.DelPort(csRelayPort.GetID());
                csSearchElement.GetViewerElm().DelPort(csRelayPort.GetID());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（外部接続（送信））</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoExternalConnectionSend(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoExternalConnectionSend(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csOrgRelayPort = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csRelayPort = csOrgRelayPort.CopyInfUsedByUndoRedoOnly(null);
            McGraphicsElement csOrgLine = csHistory.HistoryData[1] as McGraphicsElement;
            McGraphicsElement csLine = csOrgLine.CopyInfUsedByUndoRedoOnly(null);
            McGraphicsElement csOrgPort = csHistory.HistoryData[2] as McGraphicsElement;
            McGraphicsElement csPort = csOrgPort.CopyInfUsedByUndoRedoOnly(null);
            if ((csRelayPort == null) ||
                (csLine == null) ||
                (csPort == null))
            {// 保存情報異常の場合
                return;
            }

            // 端子の復元
            McGraphicsElement csSearchElement = null;
            csSearchElement = SearchElement(csPort.GetParentElm().GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.AddPort(csPort);
                csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csPort.GetViewerPort());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
            }

            // 中継端子・接続線の復元
            csSearchElement = SearchElement(csParent.GetID());
            if (csSearchElement != null)
            {// 検索できた場合
                csSearchElement.AddPort(csRelayPort);
                csSearchElement.GetViewerElm().AddPortUsedByUndoRedoOnly(csRelayPort.GetViewerPort());
                m_csGraphicsManager.ReSetPortPosition(csSearchElement);
                csLine.DelPort(1);
                csLine.DelPort(0);
                HySIdentifier csFromID = null;
                HySIdentifier csToID = null;
                csLine.GetPortID(ref csFromID, ref csToID);
                if (csFromID.Equals(csRelayPort.GetID()) == true)
                {// IDが一致した場合
                    csLine.AddPort(csRelayPort);
                    csLine.AddPort(csPort);
                }
                else
                {// IDが一致しなかった場合
                    csLine.AddPort(csPort);
                    csLine.AddPort(csRelayPort);
                }
                ((McGraphicsGroupElement)csSearchElement).AddLineElement(csLine);
                ((McStructGroupElement)csSearchElement.GetViewerElm()).AddConnectionUsedByUndoRedoOnly(csLine.GetViewerConnect());
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（プロパティ変更）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoPropertyChange(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoPropertyChange(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            HySID csElementID = csHistory.HistoryData[0] as HySID;
            McModelInfo csOrgBeforeModelInfo = csHistory.HistoryData[1] as McModelInfo;
            McModelInfo csBeforeModelInfo = (McModelInfo)HySDataDuplicate.DupliCateData(csOrgBeforeModelInfo);
            bool bStructInfoFlg = (bool)csHistory.HistoryData[3];
            bool bSimSendFlg = (bool)csHistory.HistoryData[4];
            if ((csElementID == null) ||
                (csBeforeModelInfo == null))
            {// 保存情報異常の場合
                return;
            }

            // プロパティの復元
            if (bStructInfoFlg == true)
            {// 要素タイプがMcStructInfoの場合
                if (m_csGraphicsManager.GetStructInfo().GetModelInfo().GetPropertyInfo() != null)
                {// プロパティ情報が取得できた場合
                    m_csGraphicsManager.GetStructInfo().GetModelInfo().SetPropertyInfo(csBeforeModelInfo.GetPropertyInfo());
                }
                if (m_csGraphicsManager.GetStructInfo().GetModelInfo().GetInitialInfo() != null)
                {// 初期化情報が取得できた場合
                    m_csGraphicsManager.GetStructInfo().GetModelInfo().SetInitialInfo(csBeforeModelInfo.GetInitialInfo());
                }
            }
            else
            {// 要素タイプがMcGraphicsElementの場合
                McGraphicsElement csSearchElement = null;
                csSearchElement = SearchElement(csElementID);
                if (csSearchElement != null)
                {// 検索できた場合
                    if (csSearchElement.GetModelInfo().GetPropertyInfo() != null)
                    {// プロパティ情報が取得できた場合
                        csSearchElement.GetModelInfo().SetPropertyInfo(csBeforeModelInfo.GetPropertyInfo());
                    }
                    if (csSearchElement.GetModelInfo().GetInitialInfo() != null)
                    {// 初期化情報が取得できた場合
                        csSearchElement.GetModelInfo().SetInitialInfo(csBeforeModelInfo.GetInitialInfo());
                    }
                    if (csSearchElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線の場合
                        csSearchElement.GetViewerConnect().SetTranInfoPropertyInfo(csBeforeModelInfo.GetPropertyInfo(), null);
                    }
                }
            }

            if (bSimSendFlg == true)
            {// シミュレーター通知済みの場合
                ((McDotNetModelCtlScreen)m_csScreen).PutEventParaSet(csElementID, csBeforeModelInfo);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（プロパティ変更）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoPropertyChange(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoPropertyChange(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            HySID csElementID = csHistory.HistoryData[0] as HySID;
            McModelInfo csOrgAfterModelInfo = csHistory.HistoryData[2] as McModelInfo;
            McModelInfo csAfterModelInfo = (McModelInfo)HySDataDuplicate.DupliCateData(csOrgAfterModelInfo);
            bool bStructInfoFlg = (bool)csHistory.HistoryData[3];
            bool bSimSendFlg = (bool)csHistory.HistoryData[4];
            if ((csElementID == null) ||
                (csAfterModelInfo == null))
            {// 保存情報異常の場合
                return;
            }

            // プロパティの復元
            if (bStructInfoFlg == true)
            {// 要素タイプがMcStructInfoの場合
                if (m_csGraphicsManager.GetStructInfo().GetModelInfo().GetPropertyInfo() != null)
                {// プロパティ情報が取得できた場合
                    m_csGraphicsManager.GetStructInfo().GetModelInfo().SetPropertyInfo(csAfterModelInfo.GetPropertyInfo());
                }
                if (m_csGraphicsManager.GetStructInfo().GetModelInfo().GetInitialInfo() != null)
                {// 初期化情報が取得できた場合
                    m_csGraphicsManager.GetStructInfo().GetModelInfo().SetInitialInfo(csAfterModelInfo.GetInitialInfo());
                }
            }
            else
            {// 要素タイプがMcGraphicsElementの場合
                McGraphicsElement csSearchElement = null;
                csSearchElement = SearchElement(csElementID);
                if (csSearchElement != null)
                {// 検索できた場合
                    if (csSearchElement.GetModelInfo().GetPropertyInfo() != null)
                    {// プロパティ情報が取得できた場合
                        csSearchElement.GetModelInfo().SetPropertyInfo(csAfterModelInfo.GetPropertyInfo());
                    }
                    if (csSearchElement.GetModelInfo().GetInitialInfo() != null)
                    {// 初期化情報が取得できた場合
                        csSearchElement.GetModelInfo().SetInitialInfo(csAfterModelInfo.GetInitialInfo());
                    }
                    if (csSearchElement.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_LINE)
                    {// 接続線の場合
                        csSearchElement.GetViewerConnect().SetTranInfoPropertyInfo(csAfterModelInfo.GetPropertyInfo(), null);
                    }
                }
            }

            if (bSimSendFlg == true)
            {// シミュレーター通知済みの場合
                ((McDotNetModelCtlScreen)m_csScreen).PutEventParaSet(csElementID, csAfterModelInfo);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（最前面へ移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoPiledUpTop(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoPiledUpTop(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<int> csBeforePositionList = csHistory.HistoryData[1] as List<int>;
            if ((csIDList == null) ||
                (csBeforePositionList == null))
            {// 保存情報異常の場合
                return;
            }

            // 最前面へ移動復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }

            ElementReloading((McGraphicsGroupElement)csSearchElement, csIDList, csBeforePositionList);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（最前面へ移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoPiledUpTop(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoPiledUpTop(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<int> csAfterPositionList = csHistory.HistoryData[2] as List<int>;
            if ((csIDList == null) ||
                (csAfterPositionList == null))
            {// 保存情報異常の場合
                return;
            }

            // 最前面へ移動復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }

            ElementReloading((McGraphicsGroupElement)csSearchElement, csIDList, csAfterPositionList);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（最背面へ移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoPiledUpBottom(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoPiledUpBottom(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<int> csBeforePositionList = csHistory.HistoryData[1] as List<int>;
            if ((csIDList == null) ||
                (csBeforePositionList == null))
            {// 保存情報異常の場合
                return;
            }

            // 最背面へ移動復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }

            ElementReloading((McGraphicsGroupElement)csSearchElement, csIDList, csBeforePositionList);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（最背面へ移動）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoPiledUpBottom(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoPiledUpBottom(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            List<HySIdentifier> csIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            List<int> csAfterPositionList = csHistory.HistoryData[2] as List<int>;
            if ((csIDList == null) ||
                (csAfterPositionList == null))
            {// 保存情報異常の場合
                return;
            }

            // 最背面へ移動復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }

            ElementReloading((McGraphicsGroupElement)csSearchElement, csIDList, csAfterPositionList);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（プロジェクト取り込み）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoProjectIncorporate(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoProjectIncorporate(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csElement = csHistory.HistoryData[0] as McGraphicsElement;
            if (csElement == null)
            {// 保存情報異常の場合
                return;
            }

            // プロジェクト取り込み復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }

            List<McGraphicsElement> csElmList = null;
            if (csSearchElement == null)
            {// 処理対象親要素がない場合
                csElmList = m_csDispElmList[0];
                m_csGraphicsManager.GetStructInfo().RemoveElement(csElement.GetID());
            }
            else
            {// 検索できた場合
                csElmList = ((McGraphicsGroupElement)csSearchElement).GetGroupElementList();
                ((McStructGroupElement)csSearchElement.GetViewerElm()).RemoveElement(csElement.GetID());
            }

            for (int iLp = 0; iLp < csElmList.Count; iLp++)
            {// 要素数ループ
                if (csElement.GetID().Equals(csElmList[iLp].GetID()) == true)
                {// IDが一致した場合
                    csElmList.RemoveAt(iLp);
                    break;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（プロジェクト取り込み）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoProjectIncorporate(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoProjectIncorporate(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            McGraphicsElement csOrgElement = csHistory.HistoryData[0] as McGraphicsElement;
            McGraphicsElement csElement = csOrgElement.CopyInfUsedByUndoRedoOnly(null);
            if (csElement == null)
            {// 保存情報異常の場合
                return;
            }

            // プロジェクト取り込み復元
            McGraphicsElement csSearchElement = null;
            if (csParent != null)
            {// 処理対象親要素がある場合
                csSearchElement = SearchElement(csParent.GetID());
            }

            if (csSearchElement == null)
            {// 処理対象親要素がない場合
                m_csDispElmList[0].Add(csElement);
                m_csGraphicsManager.GetStructInfo().AddElement(csElement.GetViewerElm());
            }
            else
            {// 検索できた場合
                ((McGraphicsGroupElement)csSearchElement).AddElement(csElement);
                ((McStructGroupElement)csSearchElement.GetViewerElm()).AddElement(csElement.GetViewerElm());
            }

            // 取込後の表示エリアの取得及びチェック
            Point pPointLeftTop = new Point();
            Point pPointRightBottom = new Point();
            if (m_csGraphicsManager.GetDispRect(ref pPointLeftTop, ref pPointRightBottom) == 0)
            {   // 表示エレメント有り
                CheckDispArea(pPointLeftTop, pPointRightBottom);
            }
            else
            {   // 表示エレメント無し
                SetDefaultRect();
            }

            // スクロールバーの再描画
            ScrollRefresh(m_pDispPoint.X, m_pDispPoint.Y);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素情報検索</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McGraphicsElement csElement = SearchElement(csElementID)</para>
        /// </example>
        /// <param name="csElementID">検索要素ID</param>
        /// <returns>McGraphicsElement 検索要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McGraphicsElement SearchElement(HySIdentifier csElementID)
        {
            McGraphicsElement csElement = null;

            for (int iLp = 0; iLp < m_csDispElmList[0].Count; iLp++)
            {// 要素数ループ
                csElement = m_csDispElmList[0][iLp].SearchElement(csElementID);
                if (csElement != null)
                {// 検索できた場合
                    break;
                }
            }

            if (csElement == null)
            {// 検索できなかった場合
                for (int iLp = 0; iLp < m_csDispLineList.Count; iLp++)
                {// 接続線数ループ
                    if (m_csDispLineList[iLp].GetID().Equals(csElementID) == true)
                    {// IDが一致した場合
                        csElement = m_csDispLineList[iLp];
                        break;
                    }
                }
            }

            return csElement;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素リスト積み直し</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ElementReloading(csParent, csElementIDList, csPositionList)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csElementIDList">積み直し要素IDリスト</param>
        /// <param name="csPositionList">積み直し位置リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ElementReloading(McGraphicsGroupElement csParent, List<HySIdentifier> csElementIDList, List<int> csPositionList)
        {
            if ((csElementIDList == null) ||
                (csPositionList == null))
            {// パラメータ異常の場合
                return;
            }
            if (csElementIDList.Count != csPositionList.Count)
            {// パラメータ異常の場合
                return;
            }

            List<McGraphicsElement> csTempElmList = new List<McGraphicsElement>();
            List<McGraphicsElement> csNowElmList = null;
            if (csParent == null)
            {// 処理対象親要素がない場合
                csNowElmList = m_csDispElmList[0];
            }
            else
            {// 処理対象親要素がある場合
                csNowElmList = csParent.GetGroupElementList();
            }

            if (csPositionList.Count > 0)
            {// 積み直し位置数が０より大きい場合
                List<HySIdentifier> csSortElementIDList = new List<HySIdentifier>();
                List<int> csSortPositionList = new List<int>();
                csSortElementIDList.Add(csElementIDList[0]);
                csSortPositionList.Add(csPositionList[0]);
                bool bSetFlg = false;
                for (int iLp = 1; iLp < csPositionList.Count; iLp++)
                {// 積み直し位置数ループ
                    bSetFlg = false;
                    for (int iLp2 = 0; iLp2 < csSortPositionList.Count; iLp2++)
                    {// 積み直し位置数ループ
                        if (csPositionList[iLp] < csSortPositionList[iLp2])
                        {// 積み直し位置が比較要素位置より小さい場合
                            csSortPositionList.Insert(iLp2, csPositionList[iLp]);
                            csSortElementIDList.Insert(iLp2, csElementIDList[iLp]);
                            bSetFlg = true;
                            break;
                        }
                    }
                    if (bSetFlg == false)
                    {// 未挿入の場合
                        csSortPositionList.Add(csPositionList[iLp]);
                        csSortElementIDList.Add(csElementIDList[iLp]);
                    }
                }

                for (int iLp = 0; iLp < csSortElementIDList.Count; iLp++)
                {// 要素数ループ
                    for (int iLp2 = 0; iLp2 < csNowElmList.Count; iLp2++)
                    {// 要素数ループ
                        if (csSortElementIDList[iLp].Equals(csNowElmList[iLp2].GetID()) == true)
                        {// IDが一致した場合
                            csTempElmList.Add(csNowElmList[iLp2]);
                            csNowElmList.RemoveAt(iLp2);
                            break;
                        }
                    }
                }
                for (int iLp = 0; iLp < csTempElmList.Count; iLp++)
                {// 要素数ループ
                    csNowElmList.Insert(csSortPositionList[iLp], csTempElmList[iLp]);
                }
            }
        }

        //★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(GIS起動及び表示操作の簡略化
        //★★★★★★★★★★★★★★★★★★★★★
        /// <summary>
        /// <para>method outline:</para>
        /// <para>GIS起動とアクティブ化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>StartorActiveGIS(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void StartorActiveGIS(object sender, EventArgs e)
        {
            // GIS起動
            ((McDotNetModelCtlScreen)(this.m_csScreen)).StartorActiveGIS();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択要素左90度グループ回転</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AllLeft90degRotation(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AllLeft90degRotation(object sender, EventArgs e)
        {
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {
                List<HySIdentifier> csElmIDList = new List<HySIdentifier>();


                m_csGraphicsManager.AllElementRotate(McDefine.HYM_DRAW_ANGLE_M90, ref csElmIDList);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.ALLROTATION;
                m_csHistoryDataWork = new List<object>();
                m_csHistoryDataWork.Add(csElmIDList);
                m_csHistoryDataWork.Add(McDefine.HYM_DRAW_ANGLE_M90);
                csHistoryData.HistoryData = m_csHistoryDataWork;

                //復元ポイント記録
                ReconstructionPointSave(false, csHistoryData);
                //ガイドマップ再描画
                SimpleMapReDraw();
            }
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択要素右90度グループ回転</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AllRight90degRotation(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AllRight90degRotation(object sender, EventArgs e)
        {
            if (m_eDrawMode == McDefine.DrawModeKind.HYM_SELECT)
            {
                List<HySIdentifier> csElmIDList = new List<HySIdentifier>();


                m_csGraphicsManager.AllElementRotate(McDefine.HYM_DRAW_ANGLE_90, ref csElmIDList);

                //編集領域設定
                m_pReDrawPoint.X = m_pDispPoint.X;
                m_pReDrawPoint.Y = m_pDispPoint.Y;
                m_iReDrawWidth = m_iWidth * 100 / (int)m_lDispScale;
                m_iReDrawHeight = m_iHeight * 100 / (int)m_lDispScale;

                // グラフィック部編集
                LayerReDraw(McDefine.LayerKind.ELEMENT |
                            McDefine.LayerKind.PORT |
                            McDefine.LayerKind.LINE |
                            McDefine.LayerKind.ID |
                            McDefine.LayerKind.NAME |
                            McDefine.LayerKind.ELEMENT_SELECT |
                            McDefine.LayerKind.PORT_SELECT |
                            McDefine.LayerKind.LINE_SELECT,
                            true,
                            true);

                m_eDrawMode = McDefine.DrawModeKind.HYM_SELECT;             // 選択モード

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.ALLROTATION;
                m_csHistoryDataWork = new List<object>();
                m_csHistoryDataWork.Add(csElmIDList);
                m_csHistoryDataWork.Add(McDefine.HYM_DRAW_ANGLE_90);
                csHistoryData.HistoryData = m_csHistoryDataWork;

                //復元ポイント記録
                ReconstructionPointSave(false, csHistoryData);
                //ガイドマップ再描画
                SimpleMapReDraw();
            }
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>元に戻す（選択要素全回転）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UndoAllRotation(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UndoAllRotation(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            m_eDrawMode = McDefine.DrawModeKind.HYM_ALLROTATE;             // 全回転モード
            m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            double csRotation = (double)csHistory.HistoryData[1];
            if (csElmIDList == null)
            {// 保存情報異常の場合
                return;
            }

            // 選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            // 回転要素選択
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    m_csGraphicsManager.AddSelectionList(csSearchElement);
                }
            }

            List<HySIdentifier> csWorkList = new List<HySIdentifier>();

            // 向き復元
            if (csRotation == McDefine.HYM_DRAW_ANGLE_90)
            {// 向きが９０の場合
                m_csGraphicsManager.AllElementRotate(McDefine.HYM_DRAW_ANGLE_M90, ref csWorkList);
            }
            else
            {// 向きが９０以外の場合
                m_csGraphicsManager.AllElementRotate(McDefine.HYM_DRAW_ANGLE_90, ref csWorkList);
            }
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>やり直し（選択要素全回転）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedoAllRotation(csParent, csHistory)</para>
        /// </example>
        /// <param name="csParent">処理対象親要素</param>
        /// <param name="csHistory">処理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedoAllRotation(McGraphicsGroupElement csParent, McHistoryData csHistory)
        {
            m_eDrawMode = McDefine.DrawModeKind.HYM_ALLROTATE;             // 全回転モード
            m_eSymbolKind = McDefine.SymbolDrawKind.HYM_NonSymbol;      // 描画シンボル指定なし

            List<HySIdentifier> csElmIDList = csHistory.HistoryData[0] as List<HySIdentifier>;
            double csRotation = (double)csHistory.HistoryData[1];
            if (csElmIDList == null)
            {// 保存情報異常の場合
                return;
            }

            // 選択中要素リストクリア
            m_csGraphicsManager.ClearSelectionList();

            // 回転要素選択
            McGraphicsElement csSearchElement = null;
            for (int iLp = 0; iLp < csElmIDList.Count; iLp++)
            {// 要素数ループ
                csSearchElement = SearchElement(csElmIDList[iLp]);
                if (csSearchElement != null)
                {// 検索できた場合
                    m_csGraphicsManager.AddSelectionList(csSearchElement);
                }
            }

            List<HySIdentifier> csWorkList = new List<HySIdentifier>();

            // 向き復元
            m_csGraphicsManager.AllElementRotate(csRotation, ref csWorkList);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>縦方向スクロール</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>VScrollBar_ValueChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void VScrollBar_ValueChanged(object sender, EventArgs e)
        {
            int iHeight = 0;    // 高さ
            int iWidth = 0;     // 幅

            int iVScrollMove = ((ScrollBar)sender).Value - m_iVScroll;

            if (iVScrollMove != 0)
            {   // スクロール有り
                if (LayerMove.Image == null)
                {// 移動レイヤーにイメージがない場合
                    LayerMove.Image = new Bitmap((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                }
                LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));

                iHeight = iVScrollMove * (m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale) / (VScrollBar.Maximum - VScrollBar.LargeChange);
                if(m_pDispPoint.Y + iHeight < m_iScrollTop)
                {   // 移動後の座標Yがスクロール上未満
                    iHeight = m_iScrollTop - m_pDispPoint.Y;
                }
                else if(m_pDispPoint.Y + iHeight + m_iHeight * 100 / m_lDispScale > m_iScrollBottom)
                {   // 移動後の座標Yがスクロール下を越える
                    iHeight = m_iScrollBottom - (m_pDispPoint.Y + m_iHeight * 100 / (int)m_lDispScale);
                    if (iHeight < m_iScrollTop)
                    {   // 移動後の座標Yがスクロール上未満
                        iHeight = m_iScrollTop;
                    }
                }
                iHeight = -iHeight * (int)m_lDispScale / 100;
                DisplayPositionScroll(iWidth, iHeight);

                m_iVScroll = ((ScrollBar)sender).Value;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>横方向スクロール</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HScrollBar_ValueChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HScrollBar_ValueChanged(object sender, EventArgs e)
        {
            int iHeight = 0;    // 高さ
            int iWidth = 0;     // 幅

            int iHScrollMove = ((ScrollBar)sender).Value - m_iHScroll;

            if (iHScrollMove != 0)
            {   // スクロール有り
                if (LayerMove.Image == null)
                {// 移動レイヤーにイメージがない場合
                    LayerMove.Image = new Bitmap((int)(m_iWidth * IMAGE_SIZE_RATIO), (int)(m_iHeight * IMAGE_SIZE_RATIO));
                }
                LayerMove.Location = new Point((int)(0 - m_iWidth * ((IMAGE_SIZE_RATIO - 1) / 2)), (int)(0 - m_iHeight * ((IMAGE_SIZE_RATIO - 1) / 2)));

                iWidth = iHScrollMove * (m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale) / (HScrollBar.Maximum - HScrollBar.LargeChange);
                if(m_pDispPoint.X + iWidth < m_iScrollLeft)
                {   // 移動後の座標がスクロール左未満
                    iWidth = m_iScrollLeft - m_pDispPoint.X;
                }
                else if(m_pDispPoint.X + iWidth + m_iWidth * 100 / m_lDispScale > m_iScrollRight)
                {   // 移動後の座標がスクロール右を越える
                    iWidth = m_iScrollRight - (m_pDispPoint.X + m_iWidth * 100 / (int)m_lDispScale);
                    if (iWidth < m_iScrollLeft)
                    {   // 移動後の座標がスクロール左未満
                        iWidth = m_iScrollLeft;
                    }
                }
                iWidth = -iWidth * (int)m_lDispScale / 100;
                DisplayPositionScroll(iWidth, iHeight);

                m_iHScroll = ((ScrollBar)sender).Value;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>スクロールバー再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ScrollRefresh(iDispX, iDispY)</para>
        /// </example>
        /// <param name="iDispX">描画座標Ｘ</param>
        /// <param name="iDispY">描画座標Ｙ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ScrollRefresh(int iDispX, int iDispY)
        {

            int iVNewMax;           // 縦方向最大値
            int iHNewMax;           // 横方向最大値
            int iVNewLargeChange;   // 縦方向大移動量
            int iHNewLargeChange;   // 横方向大移動量

            iVNewLargeChange = LARGECHANGE_DEFAULT * 100 / (int)m_lDispScale;
            iHNewLargeChange = LARGECHANGE_DEFAULT * 100 / (int)m_lDispScale;
            iVNewMax = SCROLL_MAXIMUM * (m_iScrollBottom - m_iScrollTop) / (m_iHeight * 2) - iVNewLargeChange;
            iHNewMax = SCROLL_MAXIMUM * (m_iScrollRight - m_iScrollLeft) / (m_iWidth * 2) - iHNewLargeChange;
            iVNewMax = iVNewMax + iVNewLargeChange;
            iHNewMax = iHNewMax + iHNewLargeChange;
            VScrollBar.Maximum = iVNewMax;
            VScrollBar.LargeChange = iVNewLargeChange;
            if ((m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale) != 0)
            {   // 縦スクロールスペースがない
                VScrollBar.SmallChange = (VScrollBar.Maximum - VScrollBar.LargeChange) / (100 * (m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale) / (m_iScrollBottom - m_iScrollTop));
                m_iVScroll = (iDispY - m_iScrollTop) * (VScrollBar.Maximum - VScrollBar.LargeChange) / (m_iScrollBottom - m_iScrollTop - m_iHeight * 100 / (int)m_lDispScale);
                VScrollBar.Value = m_iVScroll;
            }
            HScrollBar.Maximum = iHNewMax;
            HScrollBar.LargeChange = iHNewLargeChange;
            if ((m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale) != 0)
            {   // 横スクロールスペースがない
                HScrollBar.SmallChange = (HScrollBar.Maximum - HScrollBar.LargeChange) / (100 * (m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale) / (m_iScrollRight - m_iScrollLeft));
                m_iHScroll = (iDispX - m_iScrollLeft) * (HScrollBar.Maximum - HScrollBar.LargeChange) / (m_iScrollRight - m_iScrollLeft - m_iWidth * 100 / (int)m_lDispScale);
                HScrollBar.Value = m_iHScroll;
            }
        }
    }
}
