﻿// <summary>ソースコード：モデル管理簡易マップ画面フォームクラス</summary>
// <remarks>
// <para>[CommonMP][ver 1.0.0][2009/04/27][新規作成]</para>
// </remarks>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデル管理簡易マップ画面フォームクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/27][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelCtlSimpleMapForm : HySDotNetForm
    {
        /// <summary>モデル管理画面</summary>
        private McDotNetModelCtlForm m_csModelCtlForm = null;

        /// <summary>モデル編集画面カスタマイズ情報</summary>
        private McCustomInfo m_csCustomInfo = null;

        /// <summary>自表示編集座標左上</summary>
        private Point m_pMyDispPoint;

        /// <summary>モデル管理表示編集座標左上</summary>
        private Point m_pModelCtlDispPoint;

        /// <summary>自表示スケール値</summary>
        private long m_lMyDispScale;

        /// <summary>モデル管理表示スケール値</summary>
        private long m_lModelCtlDispScale;

        /// <summary>モデル管理表示レイヤー高さ</summary>
        private int m_iModelCtlLayerHeight;

        /// <summary>モデル管理表示レイヤー幅</summary>
        private int m_iModelCtlLayerWidth;

        /// <summary>表示エレメントリスト</summary>
        private List<McGraphicsElement> m_csDispElmList;

        /// <summary>表示接続線リスト</summary>
        private List<McGraphicsElement> m_csDispLineList;

        /// <summary>クリック座標</summary>
        private Point m_pMapLayerClickPoint;

        /// <summary>移動座標</summary>
        private Point m_pMapLayerMovePoint;

        /// <summary>移動モードフラグ</summary>
        private bool m_bMoveModeFlg = false;

        /// <summary>内部表示モードフラグ</summary>
        private bool m_bInnerDispModeFlg = false;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCtlSimpleMapForm csSimpleMapForm = new McDotNetModelCtlSimpleMapForm(csModelCtlForm)</para>
        /// </example>
        /// <param name="csModelCtlForm">モデル管理画面</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCtlSimpleMapForm(McDotNetModelCtlForm csModelCtlForm)
        {
            InitializeComponent();

            // モデル編集画面インスタンス保存
            m_csModelCtlForm = csModelCtlForm;

            // モデル編集画面カスタマイズ情報取得
            m_csCustomInfo = m_csModelCtlForm.GetCustomInfo();

            // モデル管理表示座標取得
            m_pModelCtlDispPoint = m_csModelCtlForm.GetDisplyPoint();

            // モデル管理表示レイヤー高さ取得
            m_iModelCtlLayerHeight = m_csModelCtlForm.GetLayerHeight();

            // モデル管理表示レイヤー幅取得
            m_iModelCtlLayerWidth = m_csModelCtlForm.GetLayerWidth();

            // モデル管理表示スケール取得
            m_lModelCtlDispScale = m_csModelCtlForm.GetDisplyScale();

            // モデル管理表示エレメントリスト取得
            m_csDispElmList = m_csModelCtlForm.GetDisplyElementList();

            // モデル管理表示接続線リスト取得
            List<McGraphicsElement> csDispLineList = m_csModelCtlForm.GetDisplyLineList();
            if (csDispLineList != null)
            {// モデル管理表示接続線リストが取得出来た場合
                // モデル管理表示接続線リスト設定
                m_csDispLineList = csDispLineList;

                // 内部表示モード設定
                m_bInnerDispModeFlg = false;
            }
            else
            {// モデル管理表示接続線リストが取得出来なかった場合
                // モデル管理表示接続線リスト設定
                m_csDispLineList = ((McGraphicsGroupElement)m_csDispElmList[0]).GetGroupLineElementList();

                // 内部表示モード設定
                m_bInnerDispModeFlg = true;
            }

            // 表示スケール設定
            int iWidth = 0;
            for (m_lMyDispScale = 50; m_lMyDispScale > 5; m_lMyDispScale -= 5)
            {// 表示スケール範囲ループ
                iWidth = m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale * (int)m_lMyDispScale / 100;
                if (iWidth <= MapLayer.Width)
                {// 幅がマップレイヤー幅以下の場合
                    break;
                }
            }

            // 表示座標計算
            m_pMyDispPoint.X = (m_pModelCtlDispPoint.X + m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Width * 100 / (int)m_lMyDispScale / 2);
            m_pMyDispPoint.Y = (m_pModelCtlDispPoint.Y + m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Height * 100 / (int)m_lMyDispScale / 2);

            // マップレイヤーイメージ設定
            MapLayer.Image = new Bitmap(MapLayer.Width, MapLayer.Height);

            // マップ描画
            MapDraw();

            // 移動レイヤー描画
            MoveLayerDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>フォームが閉じた後に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClose(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormClose(object sender, FormClosedEventArgs e)
        {
            m_csModelCtlForm.SimpleMapClose();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>フォームがアクティブになった時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormActivated(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormActivated(object sender, EventArgs e)
        {
            // フォーカスセット
            MapLayer.Focus();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>フォームリサイズ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormResize(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormResize(object sender, EventArgs e)
        {
            // 表示座標計算
            m_pMyDispPoint.X = (m_pModelCtlDispPoint.X + m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Width * 100 / (int)m_lMyDispScale / 2);
            m_pMyDispPoint.Y = (m_pModelCtlDispPoint.Y + m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Height * 100 / (int)m_lMyDispScale / 2);

            // マップレイヤーイメージ設定
            MapLayer.Image.Dispose();
            MapLayer.Image = new Bitmap(MapLayer.Width, MapLayer.Height);

            // マップ描画
            MapDraw();

            // 移動レイヤーをマップレイヤーの中心に設定
            MoveLayer.Location = new Point(MapLayer.Width / 2 - MoveLayer.Width / 2, MapLayer.Height / 2 - MoveLayer.Height / 2);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウスダウンイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseDown(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseDown(object sender, MouseEventArgs e)
        {
            // クリック位置設定
            m_pMapLayerClickPoint.X = e.X;
            m_pMapLayerClickPoint.Y = e.Y;
            m_pMapLayerMovePoint.X = e.X;
            m_pMapLayerMovePoint.Y = e.Y;

            // 移動レイヤー選択判定
            if ((e.X >= MoveLayer.Location.X) && (e.X <= MoveLayer.Location.X + MoveLayer.Width) &&
                (e.Y >= MoveLayer.Location.Y) && (e.Y <= MoveLayer.Location.Y + MoveLayer.Height))
            {// 移動レイヤー選択の場合
                // 移動モード
                m_bMoveModeFlg = true;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウスダブルクリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseDoubleClick(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseDoubleClick(object sender, MouseEventArgs e)
        {
            // クリック位置設定
            m_pMapLayerClickPoint.X = e.X;
            m_pMapLayerClickPoint.Y = e.Y;
            m_pMapLayerMovePoint.X = e.X;
            m_pMapLayerMovePoint.Y = e.Y;

            // 移動レイヤー選択判定
            if (m_bMoveModeFlg == true)
            {// 移動レイヤー選択の場合
                // 移動モード
                m_bMoveModeFlg = false;
            }

            // クリック位置を中心に表示する
            // 移動量算出
            int iMoveX = m_pMyDispPoint.X + (MapLayer.Width * 100 / (int)m_lMyDispScale) * e.X / MapLayer.Width;
            int iMoveY = m_pMyDispPoint.Y + (MapLayer.Height * 100 / (int)m_lMyDispScale) * e.Y / MapLayer.Height;

            // 表示座標計算
            m_pMyDispPoint.X = iMoveX - MapLayer.Width * 100 / (int)m_lMyDispScale / 2;
            m_pMyDispPoint.Y = iMoveY - MapLayer.Height * 100 / (int)m_lMyDispScale / 2;

            // マップ描画
            MapDraw();

            // モデル管理表示編集座標計算
            Point pModelDisp = new Point();
            pModelDisp.X = iMoveX - m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2;
            pModelDisp.Y = iMoveY - m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2;

            // モデル管理表示編集座標変更
            m_csModelCtlForm.DispPointChange(pModelDisp);
            m_pModelCtlDispPoint = pModelDisp;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウス移動イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseMove(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseMove(object sender, MouseEventArgs e)
        {
            // 移動モード判定
            if (m_bMoveModeFlg == true)
            {// 移動レイヤー選択の場合
                // 移動量算出
                int iMoveX = e.X - m_pMapLayerMovePoint.X;
                int iMoveY = e.Y - m_pMapLayerMovePoint.Y;

                if ((iMoveX != 0) || (iMoveY != 0))
                {// 移動量が０以外
                    // 移動レイヤー表示位置設定
                    MoveLayer.Location = new Point(MoveLayer.Location.X + iMoveX, MoveLayer.Location.Y + iMoveY);
                }

                // クリック位置更新
                m_pMapLayerMovePoint.X = e.X;
                m_pMapLayerMovePoint.Y = e.Y;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウスアップイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OnMouseUp(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OnMouseUp(object sender, MouseEventArgs e)
        {
            // 移動量算出
            int iMoveX = e.X - m_pMapLayerClickPoint.X;
            int iMoveY = e.Y - m_pMapLayerClickPoint.Y;
            if (m_bMoveModeFlg == false)
            {// 移動レイヤー選択の場合
                iMoveX = m_pMapLayerClickPoint.X - e.X;
                iMoveY = m_pMapLayerClickPoint.Y - e.Y;
            }

            // 移動判定
            if ((iMoveX != 0) || (iMoveY != 0))
            {// 移動量が０以外の場合
                // 表示座標計算
                m_pMyDispPoint.X = m_pMyDispPoint.X + iMoveX * 100 / (int)m_lMyDispScale;
                m_pMyDispPoint.Y = m_pMyDispPoint.Y + iMoveY * 100 / (int)m_lMyDispScale;

                // マップ描画
                MapDraw();

                // 移動レイヤーをマップレイヤーの中心に設定
                MoveLayer.Location = new Point(MapLayer.Width / 2 - MoveLayer.Width / 2, MapLayer.Height / 2 - MoveLayer.Height / 2);

                // センター座標計算
                int iCenterX = m_pMyDispPoint.X + (MapLayer.Width * 100 / (int)m_lMyDispScale) / 2;
                int iCenterY = m_pMyDispPoint.Y + (MapLayer.Height * 100 / (int)m_lMyDispScale) / 2;

                // モデル管理表示編集座標計算
                Point pModelDisp = new Point();
                pModelDisp.X = iCenterX - m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2;
                pModelDisp.Y = iCenterY - m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2;

                // モデル管理表示編集座標変更
                m_csModelCtlForm.DispPointChange(pModelDisp);
                m_pModelCtlDispPoint = pModelDisp;
            }

            m_pMapLayerClickPoint.X = 0;
            m_pMapLayerClickPoint.Y = 0;
            m_pMapLayerMovePoint.X = 0;
            m_pMapLayerMovePoint.Y = 0;
            m_bMoveModeFlg = false;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>マウスホイール操作処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MouseWheelMove(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MouseWheelMove(object sender, MouseEventArgs e)
        {
            if (e.Delta > 0)
            {// 拡大の場合
                DispScaleZoomIn(null, null);
            }
            else
            {// 縮小の場合
                DispScaleZoomOut(null, null);
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>センターボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CenterDisp(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CenterDisp(object sender, EventArgs e)
        {
            // センター表示中判定
            //if ((m_pMyDispPoint.X != 0 - MapLayer.Width * 100 / (int)m_lMyDispScale / 2) &&
            //    (m_pMyDispPoint.Y != 0 - MapLayer.Height * 100 / (int)m_lMyDispScale / 2))
            if ((m_pMyDispPoint.X != 0 - MapLayer.Width * 100 / (int)m_lMyDispScale / 2) ||
                (m_pMyDispPoint.Y != 0 - MapLayer.Height * 100 / (int)m_lMyDispScale / 2))
            {// センター以外の場合
                // 座標(0,0)を中心に表示する
                // 表示座標計算
                m_pMyDispPoint.X = 0 - MapLayer.Width * 100 / (int)m_lMyDispScale / 2;
                m_pMyDispPoint.Y = 0 - MapLayer.Height * 100 / (int)m_lMyDispScale / 2;

                // マップ描画
                MapDraw();

                // モデル管理表示編集座標変更
                Point pModelDisp = new Point(0 - m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2, 0 - m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2);
                m_csModelCtlForm.DispPointChange(pModelDisp);
                m_pModelCtlDispPoint = pModelDisp;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示スケール変更縮小ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispScaleZoomOut(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispScaleZoomOut(object sender, EventArgs e)
        {
            // 表示スケール設定
            m_lMyDispScale -= 5;
            if (m_lMyDispScale < 5)
            {// 表示スケールが５より小さい場合
                m_lMyDispScale = 5;
                return;
            }

            // 表示座標計算
            m_pMyDispPoint.X = (m_pModelCtlDispPoint.X + m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Width * 100 / (int)m_lMyDispScale / 2);
            m_pMyDispPoint.Y = (m_pModelCtlDispPoint.Y + m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Height * 100 / (int)m_lMyDispScale / 2);

            // マップ描画
            MapDraw();

            // 移動レイヤー描画
            MoveLayerDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示スケール変更拡大ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispScaleZoomIn(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispScaleZoomIn(object sender, EventArgs e)
        {
            // 表示スケール設定
            m_lMyDispScale += 5;
            if (m_lMyDispScale > 50)
            {// 表示スケールが５０より大きい場合
                m_lMyDispScale = 50;
                return;
            }

            // 表示座標計算
            m_pMyDispPoint.X = (m_pModelCtlDispPoint.X + m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Width * 100 / (int)m_lMyDispScale / 2);
            m_pMyDispPoint.Y = (m_pModelCtlDispPoint.Y + m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Height * 100 / (int)m_lMyDispScale / 2);

            // マップ描画
            MapDraw();

            // 移動レイヤー描画
            MoveLayerDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>スケール変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ScaleChange(lDispScale)</para>
        /// </example>
        /// <param name="lDispScale">表示スケール</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ScaleChange(long lDispScale)
        {
            // モデル管理表示スケール
            m_lModelCtlDispScale = lDispScale;

            // 移動レイヤー描画
            MoveLayerDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示座標変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispPointChange(pDispPoint)</para>
        /// </example>
        /// <param name="pDispPoint">表示座標</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DispPointChange(Point pDispPoint)
        {
            // モデル管理表示座標
            m_pModelCtlDispPoint = pDispPoint;

            // 表示座標計算
            m_pMyDispPoint.X = (m_pModelCtlDispPoint.X + m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Width * 100 / (int)m_lMyDispScale / 2);
            m_pMyDispPoint.Y = (m_pModelCtlDispPoint.Y + m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Height * 100 / (int)m_lMyDispScale / 2);

            // マップ描画
            MapDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示エレメント変更及び表示グループ変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DisplyElementChange(csDispElmList, csDispLineList, pDispPoint, lDispScale)</para>
        /// </example>
        /// <param name="csDispElmList">表示要素リスト</param>
        /// <param name="csDispLineList">表示接続線リスト</param>
        /// <param name="pDispPoint">表示座標</param>
        /// <param name="lDispScale">表示スケール</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DisplyElementChange(List<McGraphicsElement> csDispElmList, List<McGraphicsElement> csDispLineList, Point pDispPoint, long lDispScale)
        {
            // モデル管理表示エレメントリスト
            m_csDispElmList = csDispElmList;

            // モデル管理表示接続線リスト
            if (csDispLineList != null)
            {// モデル管理表示接続線リストがある場合
                // モデル管理表示接続線リスト設定
                m_csDispLineList = csDispLineList;

                // 内部表示モード設定
                m_bInnerDispModeFlg = false;
            }
            else
            {// モデル管理表示接続線リストがない場合
                // モデル管理表示接続線リスト設定
                m_csDispLineList = ((McGraphicsGroupElement)m_csDispElmList[0]).GetGroupLineElementList();

                // 内部表示モード設定
                m_bInnerDispModeFlg = true;
            }

            // モデル管理表示座標
            m_pModelCtlDispPoint = pDispPoint;

            // モデル管理表示スケール
            m_lModelCtlDispScale = lDispScale;

            // 表示座標計算
            m_pMyDispPoint.X = (m_pModelCtlDispPoint.X + m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Width * 100 / (int)m_lMyDispScale / 2);
            m_pMyDispPoint.Y = (m_pModelCtlDispPoint.Y + m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Height * 100 / (int)m_lMyDispScale / 2);

            // マップ描画
            MapDraw();

            // 移動レイヤー描画
            MoveLayerDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>表示レイヤーサイズ変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LayerSizeChange(iLayerWidth, iLayerHeight)</para>
        /// </example>
        /// <param name="iLayerWidth">表示レイヤー幅</param>
        /// <param name="iLayerHeight">表示レイヤー高さ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LayerSizeChange(int iLayerWidth, int iLayerHeight)
        {
            // モデル管理表示レイヤー幅
            m_iModelCtlLayerWidth = iLayerWidth;

            // モデル管理表示レイヤー高さ
            m_iModelCtlLayerHeight = iLayerHeight;

            // 表示座標計算
            m_pMyDispPoint.X = (m_pModelCtlDispPoint.X + m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Width * 100 / (int)m_lMyDispScale / 2);
            m_pMyDispPoint.Y = (m_pModelCtlDispPoint.Y + m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale / 2) - (MapLayer.Height * 100 / (int)m_lMyDispScale / 2);

            // マップ描画
            MapDraw();

            // 移動レイヤー描画
            MoveLayerDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>モデル編集画面カスタマイズ情報変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CustomInfoChange(csCustomInfo)</para>
        /// </example>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CustomInfoChange(McCustomInfo csCustomInfo)
        {
            // モデル編集画面カスタマイズ情報
            m_csCustomInfo = csCustomInfo;

            // マップ描画
            MapDraw();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>マップ描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MapDraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MapDraw()
        {
            // マップレイヤーグラフィックス取得
            Graphics csGraphics = Graphics.FromImage(MapLayer.Image);

            // 描画範囲計算
            int iReDrawWidth = MapLayer.Width * 100 / (int)m_lMyDispScale;
            int iReDrawHeight = MapLayer.Height * 100 / (int)m_lMyDispScale;

            // クリアー
            csGraphics.Clear(Color.White);

            // 接続線描画
            for (int iLp = 0; iLp < m_csDispLineList.Count; iLp++)
            {// 接続線数ループ
                // 描画対象判定
                if (m_csDispLineList[iLp].DrawCheck(m_pMyDispPoint.X, m_pMyDispPoint.Y, iReDrawWidth, iReDrawHeight) == true)
                {// 描画範囲該当の場合
                    MapDrawLine(csGraphics, m_csDispLineList[iLp]);
                }
            }

            // グループ内部表示判定
            if (m_bInnerDispModeFlg == false)
            {// グループ外部表示の場合
                // 演算要素・入出力要素・グループ要素描画
                for (int iLp = 0; iLp < m_csDispElmList.Count; iLp++)
                {
                    // 描画対象判定
                    if (m_csDispElmList[iLp].DrawCheck(m_pMyDispPoint.X, m_pMyDispPoint.Y, iReDrawWidth, iReDrawHeight) == true)
                    {// 描画範囲該当の場合
                        MapDrawElement(csGraphics, m_csDispElmList[iLp]);
                    }
                }
            }
            else
            {// グループ内部表示の場合
                // 演算要素・入出力要素・グループ要素描画
                List<McGraphicsElement> csDispGroupElmList = ((McGraphicsGroupElement)m_csDispElmList[0]).GetGroupElementList();
                for (int iLp = 0; iLp < csDispGroupElmList.Count; iLp++)
                {
                    // 描画対象判定
                    if (csDispGroupElmList[iLp].DrawCheck(m_pMyDispPoint.X, m_pMyDispPoint.Y, iReDrawWidth, iReDrawHeight) == true)
                    {// 描画範囲該当の場合
                        MapDrawElement(csGraphics, csDispGroupElmList[iLp]);
                    }
                }

                // グループ内中継端子描画
                for (int iLp = 0; iLp < m_csDispElmList[0].GetPortCount(); iLp++)
                {// 端子数ループ
                    // 描画対象判定
                    if (((McGraphicsTransElement)m_csDispElmList[0].GetPort(iLp)).DrawCheck(m_pMyDispPoint.X, m_pMyDispPoint.Y, iReDrawWidth, iReDrawHeight, true) == true)
                    {// 描画範囲該当の場合
                        MapDrawElement(csGraphics, m_csDispElmList[0].GetPort(iLp));
                    }
                }
            }

            // グラフィックス解放
            csGraphics.Dispose();

            // マップレイヤー再描画
            MapLayer.Refresh();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>マップ描画（演算要素・入出力要素・グループ要素・グループ内中継端子）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MapDrawElement(csGraphics, csElement)</para>
        /// </example>
        /// <param name="csGraphics">描画先グラフィックス</param>
        /// <param name="csElement">描画要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MapDrawElement(Graphics csGraphics, McGraphicsElement csElement)
        {
            long lElementX = 0;
            long lElementY = 0;
            long lDispX = 0;
            long lDispY = 0;
            int iElementWidth = 0;
            int iElementHeight = 0;
            long lElementWidth = 0;
            long lElementHeight = 0;

            // 演算モデル設定判定
            bool bModelFlg = false;
            if (csElement.GetModelInfo().GetLibraryID().ToString() != "")
            {// モデル設定がある場合
                bModelFlg = true;
            }

            // 要素座標取得
            if ((csElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                (csElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
            {// 中継端子以外の場合
                csElement.GetPosition(ref lElementX, ref lElementY);
            }
            else
            {// 中継端子の場合
                ((McGraphicsTransElement)csElement).GetInnerPosition(ref lElementX, ref lElementY);
            }

            // 要素座標を表示座標に変換
            McViewTransFormer.ViewTrans(m_lMyDispScale, lElementX, lElementY, ref lDispX, ref lDispY);
            lDispX -= m_pMyDispPoint.X * (int)m_lMyDispScale / 100;
            lDispY -= m_pMyDispPoint.Y * (int)m_lMyDispScale / 100;

            // 要素サイズ取得
            lElementWidth = 20;
            lElementHeight = 20;

            // 要素サイズを表示サイズに変換
            iElementWidth = (int)lElementWidth;
            iElementHeight = (int)lElementHeight;
            McViewTransFormer.SizeTrans(m_lMyDispScale, csElement.GetSymbolDrawKind(), ref iElementWidth, ref iElementHeight);

            // 要素描画色設定
            int iColor = 0;
            if ((csElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_IN) &&
                (csElement.GetSymbolDrawKind() != McDefine.SymbolDrawKind.HYM_TRANS_OUT))
            {// 中継端子以外の場合
                iColor = m_csCustomInfo.GetDrawingColor(csElement.GetSymbolDrawKind(), csElement.GetDrawSubKind(), bModelFlg, false);
            }
            else
            {// 中継端子の場合
                iColor = m_csCustomInfo.GetDrawingColor(csElement.GetSymbolDrawKind(), csElement.GetDrawSubKind(), bModelFlg, true);
            }
            Brush csDrawBrush = new SolidBrush(ColorTranslator.FromWin32(iColor));

            // 要素描画
            csGraphics.FillEllipse(csDrawBrush, (int)lDispX - iElementWidth / 2, (int)lDispY - iElementHeight / 2, iElementWidth, iElementHeight);
            csGraphics.DrawEllipse(Pens.Black, (int)lDispX - iElementWidth / 2, (int)lDispY - iElementHeight / 2, iElementWidth, iElementHeight);

            // ブラシ解放
            csDrawBrush.Dispose();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>マップ描画（接続線）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MapDrawLine(csGraphics, csElement)</para>
        /// </example>
        /// <param name="csGraphics">描画先グラフィックス</param>
        /// <param name="csElement">描画要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MapDrawLine(Graphics csGraphics, McGraphicsElement csElement)
        {
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            long lFromX = 0;
            long lFromY = 0;
            long lToX = 0;
            long lToY = 0;
            long lDispFromX = 0;
            long lDispFromY = 0;
            long lDispToX = 0;
            long lDispToY = 0;

            // 演算モデル設定判定
            bool bModelFlg = false;
            if (csElement.GetModelInfo().GetLibraryID().ToString() != "")
            {// モデル設定がある場合
                bModelFlg = true;
            }

            // ポートID取得
            csElement.GetPortID(ref csFromID, ref csToID);

            // From側座標取得
            if (csElement.GetPort(csFromID).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                // 中継端子座標取得
                ((McGraphicsTransElement)csElement.GetPort(csFromID)).GetInnerPosition(ref lFromX, ref lFromY);
            }
            else
            {// 流入中継端子以外の場合
                // 親要素座標取得
                csElement.GetPort(csFromID).GetParentElm().GetPosition(ref lFromX, ref lFromY);
            }

            // To側座標取得
            if (csElement.GetPort(csToID).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                // 中継端子座標取得
                ((McGraphicsTransElement)csElement.GetPort(csToID)).GetInnerPosition(ref lToX, ref lToY);
            }
            else
            {// 流出中継端子以外の場合
                // 親要素座標取得
                csElement.GetPort(csToID).GetParentElm().GetPosition(ref lToX, ref lToY);
            }

            // From側座標変換
            McViewTransFormer.ViewTrans(m_lMyDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            lDispFromX -= m_pMyDispPoint.X * (int)m_lMyDispScale / 100;
            lDispFromY -= m_pMyDispPoint.Y * (int)m_lMyDispScale / 100;

            // To側座標変換
            McViewTransFormer.ViewTrans(m_lMyDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            lDispToX -= m_pMyDispPoint.X * (int)m_lMyDispScale / 100;
            lDispToY -= m_pMyDispPoint.Y * (int)m_lMyDispScale / 100;

            // 接続線描画色設定
            int iColor = m_csCustomInfo.GetDrawingColor(csElement.GetSymbolDrawKind(), csElement.GetDrawSubKind(), bModelFlg, false);
            Pen csDrawPen = new Pen(ColorTranslator.FromWin32(iColor), (float)m_csCustomInfo.GetDrawingThickness());

            // 接続線描画
            csGraphics.DrawLine(csDrawPen, lDispFromX, lDispFromY, lDispToX, lDispToY);

            // ペン解放
            csDrawPen.Dispose();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>移動レイヤー描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MoveLayerDraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MoveLayerDraw()
        {
            // 移動レイヤーサイズ設定
            MoveLayer.Width = m_iModelCtlLayerWidth * 100 / (int)m_lModelCtlDispScale * (int)m_lMyDispScale / 100;
            MoveLayer.Height = m_iModelCtlLayerHeight * 100 / (int)m_lModelCtlDispScale * (int)m_lMyDispScale / 100;

            // 移動レイヤーをマップレイヤーの中心に設定
            MoveLayer.Location = new Point(MapLayer.Width / 2 - MoveLayer.Width / 2, MapLayer.Height / 2 - MoveLayer.Height / 2);

            // 移動レイヤーイメージ設定
            if (MoveLayer.Image != null)
            {// 移動レイヤーのイメージ設定がある場合
                MoveLayer.Image.Dispose();
            }
            MoveLayer.Image = new Bitmap(MoveLayer.Width, MoveLayer.Height);

            // 移動レイヤー描画
            Graphics csGrephics = Graphics.FromImage(MoveLayer.Image);
            //csGrephics.CompositingMode = CompositingMode.SourceCopy;
            csGrephics.Clear(Color.FromArgb(120, 230, 230, 230));
            csGrephics.DrawRectangle(Pens.Black, 0, 0, MoveLayer.Width - 1, MoveLayer.Height - 1);
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0007,null);
        }
    }
}