﻿// <summary>ソースコード：ＨＹＭＣＯモデル管理ツリー画面フォームクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>モデル管理ツリー画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/24][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelTreeForm : HySDotNetForm
    {
        /// <summary>要素リスト</summary>
        private List<McGraphicsElement> m_csElmList;

        /// <summary>ID表示種別</summary>
        private bool m_bIDDispKind = false;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetModelTreeForm csModelTreeForm = new McDotNetModelTreeForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public McDotNetModelTreeForm()
        {
            InitializeComponent();

            m_csElmList = new List<McGraphicsElement>();

            TreeViewCreate();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCtlForm csDotNetForm = new McDotNetModelCtlForm(csScreen, csElmList)</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <param name="csElmList">要素リスト</param>
        /// <param name="bIDDispKind">ＩＤ表示種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelTreeForm(HySScreen csScreen, List<McGraphicsElement> csElmList, bool bIDDispKind)
        {
            InitializeComponent();

            m_csScreen = csScreen;
            m_csElmList = csElmList;
            m_bIDDispKind = bIDDispKind;
            TreeViewCreate();
        }
        
        /// <summary><para>method outline</para>
        /// <para>閉じる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Close_Button.Click += new System.EventHandler(this.Disp_Close);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Disp_Close(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysUnit.PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            if (m_csScreen != null)
            {
                // 処理（スクリーンクラスのPutEventをコールする）
                return m_csScreen.PutEvent(csEvent);
            }
            else
            {
                return false;
            }

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ツリービュー作成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> TreeViewCreate() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TreeViewCreate()
        {
            TreeNode[] treeNodelevel;
            TreeView1.Nodes.Clear();
            TreeNode treeNodeRoot = new TreeNode(Properties.McDotNetViewerResources.MODEL_TAB_WHOLE);   //"全体系"
            TreeView1.Nodes.Add(treeNodeRoot);
            List<McGraphicsElement> csElmList = m_csElmList;
            List<McGraphicsElement> csTempElmList1 = new List<McGraphicsElement>();
            List<string> sIndexList1 = new List<string>();
            McGraphicsGroupElement csTempGrElm = null;
            string sTemp = "";
            for (int iLP = 0; iLP < csElmList.Count; iLP++)
            {
                csTempElmList1.Add(csElmList[iLP]);
                if (csElmList[iLP].GetElementName().ToString() == "")
                {
                    if(m_bIDDispKind == false)
                    {
                        sIndexList1.Add(((HySString)csElmList[iLP].GetID().GetString()).ToString().Substring(0, csElmList[iLP].GetID().GetString().ToString().IndexOf('-')));
                    }
                    else
                    {
                        sIndexList1.Add(((HySString)csElmList[iLP].GetID().GetString()).ToString());
                    }
                }
                else
                {
                    if(m_bIDDispKind == false)
                    {
                        sIndexList1.Add(((HySString)csElmList[iLP].GetID().GetString()).ToString().Substring(0, csElmList[iLP].GetID().GetString().ToString().IndexOf('-')) + "_" + csElmList[iLP].GetElementName().ToString());                    }
                    else
                    {
                        sIndexList1.Add(((HySString)csElmList[iLP].GetID().GetString()).ToString() + "_" + csElmList[iLP].GetElementName().ToString());
                    }
                }
                sTemp = sIndexList1[iLP];
                treeNodeRoot.Nodes.Add(sTemp, sTemp);
            }
            for (; ; )
            {
                if (csTempElmList1.Count <= 0)
                {
                    break;
                }
                if ((csTempElmList1[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_GROUP) ||
                    (csTempElmList1[0].GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_CALC_GROUP))
                {
                    csTempGrElm = (McGraphicsGroupElement)csTempElmList1[0];
                    sTemp = sIndexList1[0];
                    treeNodelevel = treeNodeRoot.Nodes.Find(sTemp, true);
                    for (int iLP = 0; iLP < csTempGrElm.GetElmCount(); iLP++)
                    {
                        csTempElmList1.Insert(iLP + 1, csTempGrElm.GetElement(iLP));
                        if (csTempGrElm.GetElement(iLP).GetElementName().ToString() == "")
                        {
                            if(m_bIDDispKind == false)
                            {
                                sIndexList1.Insert(iLP + 1, ((HySString)csTempGrElm.GetElement(iLP).GetID().GetString()).ToString().Substring(0, csTempGrElm.GetElement(iLP).GetID().GetString().ToString().IndexOf('-')));
                            }
                            else
                            {
                                sIndexList1.Insert(iLP + 1, ((HySString)csTempGrElm.GetElement(iLP).GetID().GetString()).ToString());
                            }
                        }
                        else
                        {
                            if(m_bIDDispKind == false)
                            {
                                sIndexList1.Insert(iLP + 1, ((HySString)csTempGrElm.GetElement(iLP).GetID().GetString()).ToString().Substring(0, csTempGrElm.GetElement(iLP).GetID().GetString().ToString().IndexOf('-')) + "_" + csTempGrElm.GetElement(iLP).GetElementName().ToString());
                            }
                            else
                            {
                                sIndexList1.Insert(iLP + 1, ((HySString)csTempGrElm.GetElement(iLP).GetID().GetString()).ToString() + "_" + csTempGrElm.GetElement(iLP).GetElementName().ToString());
                            }
                        }
                        sTemp = sIndexList1[iLP + 1];
                        treeNodelevel[0].Nodes.Add(sTemp, sTemp);
                    }
                }
                csTempElmList1.RemoveAt(0);
                sIndexList1.RemoveAt(0);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0009,
                        ((HySDotNetViewer)((McDotNetModelCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}