﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;


namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>相互結合セル型伝送データプロパティ画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>
    /// S.H. [2022/01/27][新規作成]
    /// </para>
    /// </remarks>
    public partial class McDotNetMutualTranforPropertyForm : HySDotNetForm, McModelPropertyFormIF
    {
        /// <summary>逆方向(下→上)パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csUpstreamPrpty = null;
        /// <summary>逆方向(下→上)の送信側：下モデルより送信：パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csUPSendPrpty = null;
        /// <summary>逆方向(下→上)の受け信側：上モデルが受信：パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csUpRecvPrpty = null;

        /// <summary>順方向（上→下）パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csDownstreamPrpty = null;
        /// <summary>順方向（上→下）送信側：上モデルより送信：パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csDOWNSendPrpty = null;
        /// <summary>順方向（上→下）の受け信側：下モデルが受信：パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csDOWNRecvPrpty = null;

        //------------------------------------------------
        /// <summary>パラメータ情報</summary>
        private McMutualTranInfoProperty m_csPropertyInfo = null;
        /// <summary>テンポラリパラメータ情報</summary>
        private McMutualTranInfoProperty m_csTempPropertyInfo = null;
        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;

        /// <summary>上流要素モデルプロパティ情報 </summary>
        protected McCellModelPropertyInfo m_csUpperElmPropertyInf = null;
        /// <summary>上流要素の送信情報パターンリスト</summary>
        protected HySDataLinkedList m_csUpperElmSendTranDataPatternList = null;

        /// <summary>下流要素モデルプロパティ情報</summary>
        protected McCellModelPropertyInfo m_csLowerElmPropertyInf = null;
        /// <summary>下流要素の期待受信情報パターンリスト </summary>
        protected HySDataLinkedList m_csLowerElmReceiveTranDataPatternList = null;

        /// <summary>結線情報変更フラグ </summary>
        protected bool m_bConnectionModifyFlg = false;

        //メッセージ定義
        /// <summary>メッセージタイトル 『モデル管理機能』</summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_MODEL_MANAGEMENT");
        /// <summary>保存確認メッセージ『設定内容が変更されています。\n保存しますか？』 </summary>
        static private readonly string MSG_DATA_SET = McMessage.GetString("MC_MSG_QUESTION_CONFILM_DATA_SETUP");


        // 画面表示項目
        /// <summary>画面表示「結線設定状況」 </summary>
        static private readonly string TEXT_CELLINFO_SETSTATE = Properties.McDotNetViewerResources.TEXT_CELLINFO_SETSTATE;
        /// <summary>画面表示「最大レコード保持数」 </summary>
        static private readonly string TEXT_MAXRECORD_SETSTATE = Properties.McDotNetViewerResources.TEXT_MAXRECORD_SETSTATE;
        /// <summary>画面表示「セル内送信情報」 </summary>
        static private readonly string TEXT_SENDINFO_SETSTATE = Properties.McDotNetViewerResources.TEXT_SENDINFO_SETSTATE;

        /// <summary>メッセージタイトル 『設定値エラー』</summary>
        static private readonly string MGSBOX_TITLE_PARAMSET_CHECK = Properties.McDotNetViewerResources.MGSBOX_TITLE_PARAMSET_CHECK;
        /// <summary>警告メッセージ 『セル数の設定が大きすぎます。』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_TOO_LARGE = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_TOO_LARGE;
        /// <summary>警告メッセージ 『セル接続数修正方法』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_ERR_MSG = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_ERR_MSG;
        /// <summary>警告メッセージ 『セル接続数修正方法(情報)』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_ERR_MSG_INFO = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_ERR_MSG_INFO;
        /// <summary>警告メッセージ 『セル接続数不整合』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_UNMATCH = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_UNMATCH;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetMutualTranforPropertyForm csTranInfoPropertyForm = new McDotNetMutualTranforPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetMutualTranforPropertyForm()
        {
            InitializeComponent();
            LabelModelName.Text = "名称：";
            LabelModelId.Text = "ＩＤ：";
            LabelModelKind.Text = "種別名称：";
            LabelModelKindID.Text = "種別：";
            UpperModel.Text = "上流モデル";
            LowerModel.Text = "下流モデル";
            ParaSet.Text = "設定";
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = csInfo as McMutualTranInfoProperty;
            if (m_csPropertyInfo != null)
            {
                m_csTempPropertyInfo = (McMutualTranInfoProperty)m_csPropertyInfo.Clone(); // (McMutualTranInfoProperty)HySDataDuplicate.DupliCateData(m_csPropertyInfo);

                (m_csDownstreamPrpty, m_csUpstreamPrpty) = m_csTempPropertyInfo.GetTranInfoProperty();
                if(m_csDownstreamPrpty != null)
                {
                    m_csDOWNRecvPrpty = m_csDownstreamPrpty.GetReceiveTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
                    m_csDOWNSendPrpty = m_csDownstreamPrpty.GetSendTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
                }
                if(m_csUpstreamPrpty != null)
                {
                    m_csUpRecvPrpty = m_csUpstreamPrpty.GetReceiveTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
                    m_csUPSendPrpty = m_csUpstreamPrpty.GetSendTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElmPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUpperElmPropertyInfo(McCellModelPropertyInfo csInfo)
        {
            m_csUpperElmPropertyInf = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素の送信情報パターンリストインスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElmSendTranDataPatternList(csPatternList)</para>
        /// </example>
        /// <param name="csPatternList">上流要素の送信情報パターンリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUpperElmSendTranDataPatternList(HySDataLinkedList csPatternList)
        {
            m_csUpperElmSendTranDataPatternList = csPatternList;
        }

        /// <summary><para>method outline:</para>
        /// <para>下流要素モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerElmPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLowerElmPropertyInfo(McCellModelPropertyInfo csInfo)
        {
            m_csLowerElmPropertyInf = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>下流要素の受信情報パターンリストインスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerElmReceiveTranDataPatternList(csPatternList)</para>
        /// </example>
        /// <param name="csPatternList">下流要素の受信情報パターンリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLowerElmReceiveTranDataPatternList(HySDataLinkedList csPatternList)
        {
            m_csLowerElmReceiveTranDataPatternList = csPatternList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter()
        {
            // 名称表示編集
            ModelName.Text = m_csElementName.ToString();
            if (m_csPropertyInfo != null)
            {// 登録プロパティ情報がある場合
                // 表示要素情報取得
                McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();
                ModelId.Text = csElement.GetID().ToString();

                // 種別名称表示編集
                if ((object)m_csPropertyInfo.GetModelName() == null)
                {// 名称設定がない場合
                    ModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    ModelKind.Text = m_csPropertyInfo.GetModelName().ToString();
                }

                // 種別表示編集
                if ((object)m_csPropertyInfo.GetModelKind() == null)
                {// 種別設定がある場合
                    ModelKindID.Text = "";
                }
                else
                {// 種別設定がある場合
                    ModelKindID.Text = m_csPropertyInfo.GetModelKind().ToString();
                }

                // セル配列数表示編集
                Dimensional1.Text = ((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetDim1().ToString();
                Dimensional2.Text = ((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetDim2().ToString();
                Dimensional3.Text = ((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetDim3().ToString();

            }

            if (m_csUpperElmPropertyInf == null)
            {// 上流要素モデルプロパティ情報がない場合
                // 上流モデル未設定時の表示編集
                UpperModel.Enabled = false;
                UpperModelKind.Text = "";
                UpperModelKind.Enabled = false;
            }
            else
            {// 上流要素モデルプロパティ情報がある場合
                // 上流モデルボタン活性
                UpperModel.Enabled = true;

                // 上流モデル　モデル種別活性・表示編集
                UpperModelKind.Enabled = true;
                if ((object)m_csUpperElmPropertyInf.GetModelName() == null)
                {// 名称設定がない場合
                    UpperModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    UpperModelKind.Text = m_csUpperElmPropertyInf.GetModelName().ToString();
                }

                // 上流モデル　選択接続パターン活性・表示編集
                UpperModelPattern.Enabled = true;
                UpperModelPattern.Items.Clear();
                UpperModelPattern.Items.Add("");
                if (m_csUpperElmSendTranDataPatternList != null)
                {// 送信情報パターンリストがある場合
                    List<string> csLabelPatternList = new List<string>();
                    McTranInfoPattern csPattern = null;
                    for (int lLp = 0; lLp < m_csUpperElmSendTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        csPattern = (McTranInfoPattern)m_csUpperElmSendTranDataPatternList.GetData(lLp);
                        if (csPattern.GetTranDataKind().Equals(((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetModelKind()) == true)
                        {// 種別が一致した場合
                            //UpperModelPattern.Items.Add(csPattern.GetName().ToString());
                            csLabelPatternList.Add(csPattern.GetName().ToString());
                        }
                    }
                    csLabelPatternList.Sort(); // sort
                    for (int iLp = 0; iLp < csLabelPatternList.Count; iLp++)
                    {
                        UpperModelPattern.Items.Add(csLabelPatternList[iLp]);
                    }


                    if(csLabelPatternList.Count > 0 )
                    {
                        bool bFix = false;
                        csPattern = (McTranInfoPattern)m_csTempPropertyInfo.GetSendTranInfoPattern();
                        if (csPattern != null)
                        {// セル型伝送パターンがある場合
                            //UpperModelPattern.SelectedItem = csPattern.GetName().ToString();
                            for (int kk = 0; kk < UpperModelPattern.Items.Count; kk++)
                            {
                                if (UpperModelPattern.Items[kk].ToString() == csPattern.GetName().ToString())
                                {
                                    UpperModelPattern.SelectedItem = csPattern.GetName().ToString();
                                    bFix = true;
                                    break;
                                }
                            }
                            //if( bFix != true )
                            //{
                            //    ConnectionDataInitial(1);
                            //}
                        }
                    }
                   

                }  // end of  if (m_csUpperElmSendTranDataPatternList != null)
            }

            if (m_csLowerElmPropertyInf == null)
            {// 下流要素モデルプロパティがない場合
                // 下流モデル未設定時の表示編集
                LowerModel.Enabled = false;
                LowerModelKind.Text = "";
                LowerModelKind.Enabled = false;

            }
            else
            {// 下流要素モデルプロパティがある場合
                // 下流モデルボタン活性
                LowerModel.Enabled = true;

                // 下流モデル　モデル種別活性・表示編集
                LowerModelKind.Enabled = true;
                if ((object)m_csLowerElmPropertyInf.GetModelName() == null)
                {// 名称設定がない場合
                    LowerModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    LowerModelKind.Text = m_csLowerElmPropertyInf.GetModelName().ToString();
                }

                // 下流モデル　選択接続パターン活性・表示編集
                LowerModelPattern.Enabled = true;
                LowerModelPattern.Items.Clear();
                LowerModelPattern.Items.Add("");
                if (m_csLowerElmReceiveTranDataPatternList != null)
                {// 受信情報パターンリストがある場合
                    List<string> csLabelPatternList = new List<string>();
                    McTranInfoPattern csPattern = null;
                    for (int lLp = 0; lLp < m_csLowerElmReceiveTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        csPattern = (McTranInfoPattern)m_csLowerElmReceiveTranDataPatternList.GetData(lLp);
                        if (csPattern.GetTranDataKind().Equals(((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetModelKind()) == true)
                        {// 種別が一致した場合
                            csLabelPatternList.Add(csPattern.GetName().ToString());
                        }
                    }
                    csLabelPatternList.Sort(); // sort
                    for (int iLp = 0; iLp < csLabelPatternList.Count; iLp++)
                    {
                        LowerModelPattern.Items.Add(csLabelPatternList[iLp]);
                    }

                    if (m_csPropertyInfo != null)
                    {// 登録プロパティ情報がある場合
                        if (csLabelPatternList.Count > 0)
                        {
                            csPattern = (McTranInfoPattern)m_csTempPropertyInfo.GetReceiveTranInfoPattern();
                            bool bFix = false;
                            if (csPattern != null)
                            {// セル型伝送パターンがある場合
                                for (int kk = 0; kk < LowerModelPattern.Items.Count; kk++)
                                {
                                    if (LowerModelPattern.Items[kk].ToString() == csPattern.GetName().ToString())
                                    {
                                        LowerModelPattern.SelectedItem = csPattern.GetName().ToString();
                                        bFix = true;
                                        break;
                                    }
                                }
                            }
                            if (bFix != true)
                            {
                                for (int iLp = 0; iLp < csLabelPatternList.Count; iLp++)
                                {
                                    if (UpperModelPattern.SelectedItem.ToString() == csLabelPatternList[iLp])
                                    {
                                        LowerModelPattern.SelectedItem = csLabelPatternList[iLp];
                                        SetLowerPttn();
                                        ConnectionDataInitial(2);
                                        bFix = true;
                                        break;
                                    }
                                }                                
                            }
                        }
                    }
                }   // end of   if (m_csLowerElmReceiveTranDataPatternList != null)
            }
            this.ShowConnectionParameter(0);
            this.ShowConnectionParameter(1);
        }

        /// <summary><para>method outline:</para>
        /// <para>設定状況を表示する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowConnectionParameter(csInfo)</para>
        /// </example>
        /// <param name="csInfo">伝送情報プロパティ設定情報</param>
        /// <param name="iUpDownSW"> =0:上流側, =1:下流側</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        //public void ShowConnectionParameter(McTranInfoPattern csInfo, int iUpDownSW)
        public void ShowConnectionParameter(int iUpDownSW ) 
        {
            if (iUpDownSW == 0)
            {   // 上側
                // スクロールバーを有効にする
                if (UpperModelSelectPattern.ScrollBars != ScrollBars.Both)
                {
                    UpperModelSelectPattern.ScrollBars = ScrollBars.Both;
                }
                //McTranInfoPattern csDwnPattern = m_csDownstreamPrpty.GetReceiveTranInfoPattern() as McTranInfoPattern;
                McTranInfoPattern csDwnPattern = m_csDownstreamPrpty.GetSendTranInfoPattern() as McTranInfoPattern;
                if (csDwnPattern is McMutualTranInfoPattern)
                {
                    csDwnPattern = ((McMutualTranInfoPattern)csDwnPattern).GetDwnPattern();
                    //ShowConnectionParameter(csDwnPattern, 0);
                }
                if (csDwnPattern != null)
                {
                    HySDataCharacteristicInCell csCell = csDwnPattern.GetCellDataCharacteristic();
                    UpperModelSelectPattern.Text = CreateConnectionParameterString(iUpDownSW, csDwnPattern, csCell);
                }
                else
                {
                    UpperModelSelectPattern.Text = "";
                }
            }
            else
            {
                // スクロールバーを有効にする
                if (LowerModelSelectPattern.ScrollBars != ScrollBars.Both)
                {
                    LowerModelSelectPattern.ScrollBars = ScrollBars.Both;
                }
                //McTranInfoPattern csUpPattern = m_csUpstreamPrpty.GetReceiveTranInfoPattern() as McTranInfoPattern;
                McTranInfoPattern csUpPattern = m_csUpstreamPrpty.GetSendTranInfoPattern() as McTranInfoPattern;
                if (csUpPattern is McMutualTranInfoPattern)
                {
                    csUpPattern = ((McMutualTranInfoPattern)csUpPattern).GetDwnPattern();
                    //ShowConnectionParameter(csUpPattern, 1);
                }
                if (csUpPattern != null)
                {
                    HySDataCharacteristicInCell csCell = csUpPattern.GetCellDataCharacteristic();
                    LowerModelSelectPattern.Text = CreateConnectionParameterString(iUpDownSW, csUpPattern, csCell);
                }
                else
                {
                    LowerModelSelectPattern.Text = "";
                }
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>設定状況の文字列を作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateConnectionParameterString(long,HySCellDataGetter,McTranInfoPattern)</para>
        /// </example>
        /// <param name="pattern">セル伝送情報プロパティパターン情報</param>
        /// <returns>設定状況の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected string CreateConnectionParameterString(
            int iUpDownSW,
            McTranInfoPattern pattern,
            HySDataCharacteristicInCell csCell
            )
        {
            string resultString = "";
            if (iUpDownSW == 0)
            {
                resultString += "■ → □(順方向)";
            }
            else
            {
                resultString += "□ → ■(逆方向)";
            }
            resultString += Environment.NewLine;

            //pattern.GetCellDataCharacteristic();

            resultString += CreateConnectionParameterString_sub2(
                                    csCell
                                    );

            return resultString;
        }


        /// <summary><para>method outline:</para>
        /// <para>結線設定状況の文字列を作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateConnectionParameterString_sub1(long)</para>
        /// </example>
        /// <param name="maxRecordNum">レコード保持最大数</param>
        /// <returns>結線設定状況の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected string CreateConnectionParameterString_sub1(
            long maxRecordNum
            )
        {
            string resultString = "";
            resultString += "【" + TEXT_CELLINFO_SETSTATE + "】" + Environment.NewLine + "■" + TEXT_MAXRECORD_SETSTATE + Environment.NewLine + maxRecordNum.ToString() + Environment.NewLine;
            return resultString;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内送信情報の文字列を作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateConnectionParameterString_sub2(HySCellDataGetter,McTranInfoPattern)</para>
        /// </example>
        /// <param name="cellDataGetter">セル内データのインデックス情報</param>
        /// <param name="pattern">伝送情報パターンプロパティ</param>
        /// <returns>セル内送信情報の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected string CreateConnectionParameterString_sub2(
            HySDataCharacteristicInCell csChara
            )
        {
            string resultString = "";

            //resultString += "■" + TEXT_SENDINFO_SETSTATE + Environment.NewLine;
            string[] csLabel = csChara.m_csLabel;
            for (long lLp = 0; lLp < csLabel.Length; lLp++)
            {
                string sLabelWork = "";
                string sUnitWork = "";
                csChara.GetDataKind(lLp, ref sLabelWork, ref sUnitWork);
                if (sLabelWork != "")
                {
                    resultString += //lLp.ToString() +
                        　　　　　"◎:" + sLabelWork + " [" + sUnitWork + "]" + Environment.NewLine;
                }
            }

            return resultString;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaSet_Check()
        {
            bool bRtn = false;
            return bRtn;
        }
  
        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2)
        {
            bool bRtn = false;

            // セル配列数
            long lDim1 = long.Parse(Dimensional1.Text);
            long lDim2 = long.Parse(Dimensional2.Text);
            long lDim3 = long.Parse(Dimensional3.Text);
            if ((lDim1 != ((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetDim1()) ||
                (lDim2 != ((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetDim2()) ||
                (lDim3 != ((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetDim3()))
            {// 配列数が変更された場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    if (lDim2 == 0)
                    {// ２次元目配列数が０の場合
                        ((McCellArrayTranInfoPropertyInfo)m_csTempPropertyInfo).SetDim(lDim1);
                    }
                    else if (lDim3 == 0)
                    {// ３次元目配列数が０の場合
                        ((McCellArrayTranInfoPropertyInfo)m_csTempPropertyInfo).SetDim(lDim1, lDim2);
                    }
                    else
                    {// その他の場合
                        ((McCellArrayTranInfoPropertyInfo)m_csTempPropertyInfo).SetDim(lDim1, lDim2, lDim3);
                    }
                }
            }


            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

            // 要素名称
            if (ModelName.Text != m_csElementName.ToString())
            {// 名称に変更がある場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    csElement.SetElementName(new HySString(ModelName.Text));
                }
                bChangeFlg1 = true;
                bRtn = true;
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg1 = true;
            bool bChangeFlg2 = true;

            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

            //============================================================
            m_csPropertyInfo.CopyData(m_csTempPropertyInfo);
            //=============================================================

            Close();

            if (bChangeFlg2 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetTranInfoCellPropertyScreen)m_csScreen).PropertyInfoSet(true);
            }
            else if (bChangeFlg1 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetTranInfoCellPropertyScreen)m_csScreen).PropertyInfoSet(false);
            }

            ((McDotNetTranInfoCellPropertyScreen)m_csScreen).ClosedForm();
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            Close();
            ((McDotNetTranInfoCellPropertyScreen)m_csScreen).ClosedForm();
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>上流モデルプロパティ表示処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpperModel_Click(object sender, EventArgs e)
        {
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();
            csElement.GetPortID(ref csFromID, ref csToID);
            if (csElement.GetPort(csFromID).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                return;
            }

            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            // 設定変更確認
            if (ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoCellPropertyScreen)m_csScreen).PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoCellPropertyScreen)m_csScreen).PropertyInfoSet(false);
                    }
                }
            }

            // 上流モデルプロパティ表示要求
            ((McDotNetTranInfoCellPropertyScreen)m_csScreen).JunctureModelPropertyDispReq(csElement.GetPort(csFromID).GetParentElm());

            Close();
            ((McDotNetTranInfoCellPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>下流モデルプロパティ表示処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LowerModel_Click(object sender, EventArgs e)
        {
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();
            csElement.GetPortID(ref csFromID, ref csToID);
            if (csElement.GetPort(csToID).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                return;
            }

            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            // 設定変更確認
            if (ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoCellPropertyScreen)m_csScreen).PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoCellPropertyScreen)m_csScreen).PropertyInfoSet(false);
                    }
                }
            }

            // 下流モデルプロパティ表示要求
            ((McDotNetTranInfoCellPropertyScreen)m_csScreen).JunctureModelPropertyDispReq(csElement.GetPort(csToID).GetParentElm());

            Close();
            ((McDotNetTranInfoCellPropertyScreen)m_csScreen).ClosedForm();
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択接続パターン（上流モデル）変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModelPattern_SelectedIndexChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpperModelPattern_SelectedIndexChanged(object sender, EventArgs e)
        {
            long lDim1 = 0;
            long lDim2 = 0;
            long lDim3 = 0;
            long lDataDimInCell = 0;
            string sPatternWork = "";

            McTranInfoPattern csUpperPattern = (McTranInfoPattern)m_csTempPropertyInfo.GetSendTranInfoPattern();
            if (UpperModelPattern.SelectedIndex == 0)
            {// パターン未選択の場合
                UpperModelSelectPattern.Text = "";
                UpperModelSelectPattern.Enabled = false;

                m_csTempPropertyInfo.SetUpperConnectionPatternID(new HySID(""));
            }
            else
            {// パターン選択の場合
                UpperModelSelectPattern.Enabled = true;
                if (m_csUpperElmSendTranDataPatternList != null)
                {// 送信情報パターンリストがある場合
                    McTranInfoPattern csPattern = null;
                    for (int lLp = 0; lLp < m_csUpperElmSendTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        csPattern = (McTranInfoPattern)m_csUpperElmSendTranDataPatternList.GetData(lLp);
                        if (csPattern.GetTranDataKind().Equals(((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetModelKind()) == true)
                        {// 種別が一致した場合
                            if (UpperModelPattern.SelectedItem.ToString() == csPattern.GetName().ToString())
                            {// 名称が一致した場合
                                csPattern.GetDimension(ref lDim1, ref lDim2, ref lDim3, ref lDataDimInCell);
                                sPatternWork = csPattern.GetName().ToString() + "\r\n" + csPattern.GetTranDataKind().ToString() + "\r\n" + "セル配列" + "\r\n" + "(１次元：" + lDim1.ToString() + ")";
                                if (lDim2 != 0)
                                {// ２次元目の配列数が０以外の場合
                                    //２次元：
                                    sPatternWork += "\r\n(" + Properties.McDotNetViewerResources.PROPERTY_PATTERN_2D + lDim2.ToString() + ")";
                                }
                                if (lDim3 != 0)
                                {// ３次元目の配列数が０以外の場合
                                    //３次元：
                                    sPatternWork += "\r\n(" + Properties.McDotNetViewerResources.PROPERTY_PATTERN_3D + lDim3.ToString() + ")";
                                }
                                if (UpperModelPattern.SelectedItem.ToString() != csUpperPattern.GetName().ToString())
                                {   // 設定中と異なる値に設定された
                                    m_csTempPropertyInfo.SetUpperConnectionPattern((McMutualTranInfoPattern)csPattern);
                                    SetUpperPttn();
                                    ConnectionDataInitial(1);
                                    m_csUpstreamPrpty = m_csTempPropertyInfo.GetUpstreamTranInfoProperty();
                                    this.checkBoxAutoConnect_CheckedChanged(sender, e);
                                }
                                break;
                            }
                        }
                    }
                }
            }
            m_csUpstreamPrpty = m_csTempPropertyInfo.GetUpstreamTranInfoProperty();
            this.ShowConnectionParameter(0);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択接続パターン（下流モデル）変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LowerModelPattern_SelectedIndexChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LowerModelPattern_SelectedIndexChanged(object sender, EventArgs e)
        {
            long lDim1 = 0;
            long lDim2 = 0;
            long lDim3 = 0;
            long lDataDimInCell = 0;
            string sPatternWork = "";

            McTranInfoPattern csNowLowerPattern = (McTranInfoPattern)m_csTempPropertyInfo.GetReceiveTranInfoPattern();

            if (LowerModelPattern.SelectedIndex == 0)
            {// パターン未選択の場合
                LowerModelSelectPattern.Text = "";
                LowerModelSelectPattern.Enabled = false;

                m_csTempPropertyInfo.SetLowerConnectionPatternID(new HySID(""));
            }
            else
            {// パターン選択の場合
                LowerModelSelectPattern.Enabled = true;

                if (m_csLowerElmReceiveTranDataPatternList != null)
                {// 受信情報パターンリストがある場合
                    McTranInfoPattern csPattern = null;
                    for (int lLp = 0; lLp < m_csLowerElmReceiveTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        csPattern = (McTranInfoPattern)m_csLowerElmReceiveTranDataPatternList.GetData(lLp);
                        if (csPattern.GetTranDataKind().Equals(((McCellArrayTranInfoPropertyInfo)m_csPropertyInfo).GetModelKind()) == true)
                        {// 種別が一致した場合
                            if (LowerModelPattern.SelectedItem.ToString() == csPattern.GetName().ToString())
                            {// 名称が一致した場合
                                csPattern.GetDimension(ref lDim1, ref lDim2, ref lDim3, ref lDataDimInCell);
                                sPatternWork = csPattern.GetName().ToString() + "\r\n" + csPattern.GetTranDataKind().ToString() + "\r\n" + "セル配列" + "\r\n" + "(１次元：" + lDim1.ToString() + ")";
                                if (lDim2 != 0)
                                {// ２次元目の配列数が０以外の場合
                                    //２次元：
                                    sPatternWork += "\r\n(" + Properties.McDotNetViewerResources.PROPERTY_PATTERN_2D + lDim2.ToString() + ")";
                                }
                                if (lDim3 != 0)
                                {// ３次元目の配列数が０以外の場合
                                    //３次元：
                                    sPatternWork += "\r\n(" + Properties.McDotNetViewerResources.PROPERTY_PATTERN_3D + lDim3.ToString() + ")";
                                }

                                if (LowerModelPattern.SelectedItem.ToString() != csNowLowerPattern.GetName().ToString())
                                {   // 設定中と異なる値に設定された
                                    m_csTempPropertyInfo.SetLowerConnectionPattern((McMutualTranInfoPattern)csPattern);
                                    SetLowerPttn();
                                    ConnectionDataInitial(2);
                                    m_csDownstreamPrpty = m_csTempPropertyInfo.GetDownstreamTranInfoProperty();
                                }
                                break;
                            }
                        }
                    }
                }
            }            
            m_csDownstreamPrpty = m_csTempPropertyInfo.GetDownstreamTranInfoProperty();
            this.ShowConnectionParameter(1);
        }

        protected void SetUpperPttn()
        {
            m_csUpstreamPrpty = m_csTempPropertyInfo.GetUpstreamTranInfoProperty();
            m_csUpRecvPrpty = m_csUpstreamPrpty.GetReceiveTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
            m_csUPSendPrpty = m_csUpstreamPrpty.GetSendTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
        }
        protected void SetLowerPttn()
        {
            m_csDownstreamPrpty = m_csTempPropertyInfo.GetDownstreamTranInfoProperty();
            m_csDOWNRecvPrpty = m_csDownstreamPrpty.GetReceiveTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
            m_csDOWNSendPrpty = m_csDownstreamPrpty.GetSendTranInfoPattern() as McCellArrayTranInfoPropertyInfo;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>接続情報イニシャル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ConnectionDataInitial();</para>
        /// </example>
        /// <param name="iInitSW">==1: Send 側、 ==2: Receve側 </param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ConnectionDataInitial(int iInitSW)
        {
            long lReceiveDataNumber = 8;
            long lSendDataNumber = 0;
            if (iInitSW == 2)
            {   // 受信側の初期化
                if (m_csTempPropertyInfo.GetReceiveTranInfoPattern() != null)
                {// セル型伝送パターンがある場合
                    lReceiveDataNumber = ((McTranInfoPattern)m_csTempPropertyInfo.GetReceiveTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
                }
                m_csTempPropertyInfo.SetCellDataGetter(new HySCellDataGetter(lReceiveDataNumber));
                //-- DownStream側の受信パターン設定
                {
                    lReceiveDataNumber = 8;
                    if (m_csDownstreamPrpty.GetReceiveTranInfoPattern() != null)
                    {
                        lReceiveDataNumber = ((McTranInfoPattern)m_csDownstreamPrpty.GetReceiveTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
                    }
                    m_csDownstreamPrpty.SetCellDataGetter(new HySCellDataGetter(lReceiveDataNumber));
                }
                //-- UpStream側の送信パターン設定
                {
                    lSendDataNumber = 0;
                    if (m_csUpstreamPrpty.GetSendTranInfoPattern() != null)
                    {// セル型伝送パターンがある場合
                        lSendDataNumber = ((McTranInfoPattern)m_csUpstreamPrpty.GetSendTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
                    }
                    for (long lLp = 0; lLp < lSendDataNumber; lLp++)
                    {// 不足情報数ループ
                        m_csUpstreamPrpty.GetCellDataGetter().SetIdx(lLp, lLp);
                    }
                    long lCounter = -1;
                    for (long lLp = lSendDataNumber; lLp < lReceiveDataNumber; lLp++, lCounter--)
                    {// 不足情報数ループ
                        m_csUpstreamPrpty.GetCellDataGetter().SetIdx(lLp, lCounter);
                    }
                }
            }
            if (iInitSW == 1)
            {   // 送信側の初期化
                if (m_csTempPropertyInfo.GetSendTranInfoPattern() != null)
                {// セル型伝送パターンがある場合
                    lSendDataNumber = ((McTranInfoPattern)m_csTempPropertyInfo.GetSendTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
                }
                long lCounter = -1;
                for (long lLp = lSendDataNumber; lLp < lReceiveDataNumber; lLp++, lCounter--)
                {// 不足情報数ループ
                    m_csTempPropertyInfo.GetCellDataGetter().SetIdx(lLp, lCounter);
                }
                // -- DownStream側の送信パターン設定
                {
                    lSendDataNumber = 0;
                    if (m_csDownstreamPrpty.GetSendTranInfoPattern() != null)
                    {// セル型伝送パターンがある場合
                        lSendDataNumber = ((McTranInfoPattern)m_csDownstreamPrpty.GetSendTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
                    }
                    for (long lLp = 0; lLp < lSendDataNumber; lLp++)
                    {// 不足情報数ループ
                        m_csDownstreamPrpty.GetCellDataGetter().SetIdx(lLp, lLp);
                    }
                    lCounter = -1;
                    for (long lLp = lSendDataNumber; lLp < lReceiveDataNumber; lLp++, lCounter--)
                    {// 不足情報数ループ
                        m_csDownstreamPrpty.GetCellDataGetter().SetIdx(lLp, lCounter);
                    }
                }
                // -- UpStream側の受信パターン設定
                {
                    lReceiveDataNumber = 8;
                    if (m_csUpstreamPrpty.GetReceiveTranInfoPattern() != null)
                    {
                        lReceiveDataNumber = ((McTranInfoPattern)m_csUpstreamPrpty.GetReceiveTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
                    }
                    m_csUpstreamPrpty.SetCellDataGetter(new HySCellDataGetter(lReceiveDataNumber));
                }
            }
        }


        private void Help_Button_Click(object sender, EventArgs e)
        {
        }

        private void buttonDownstreamPrpty_Click(object sender, EventArgs e)
        {
            McDotNetTranInfoCellPropertyConnectionForm csConnectionForm = new McDotNetTranInfoCellPropertyConnectionForm();

            csConnectionForm.Owner = this;
            csConnectionForm.TopMost = false;
            csConnectionForm.StartPosition = FormStartPosition.CenterScreen;
            csConnectionForm.SetModelPropertyInfo(m_csDownstreamPrpty);
            csConnectionForm.EditParameter();
            csConnectionForm.Text = "【上流】→【下流】　上流セル接続設定";
            csConnectionForm.SetModelLabelName(true);

            HySCellDataGetter csTempCellDataGetter = new HySCellDataGetter(m_csDownstreamPrpty.GetCellDataGetter());

            if (csConnectionForm.ShowDialog() == DialogResult.OK)
            {// 設定選択の場合
                m_bConnectionModifyFlg = true;
            }
            else
            {// キャンセル選択の場合
                m_csDownstreamPrpty.SetCellDataGetter(csTempCellDataGetter);
            }
            m_csTempPropertyInfo.SetDownstreamTranInfoProperty(m_csDownstreamPrpty);

            csConnectionForm.Dispose();

            //bool bChg = ((McDotNetMutualTranInfoPropertyScreen)(m_csScreen)).SetDownstreamProperty();
        }

        private void buttonUpstreamPrpty_Click(object sender, EventArgs e)
        {
            McDotNetTranInfoCellPropertyConnectionForm csConnectionForm = new McDotNetTranInfoCellPropertyConnectionForm();

            csConnectionForm.Owner = this;
            csConnectionForm.TopMost = false;
            csConnectionForm.StartPosition = FormStartPosition.CenterScreen;
            csConnectionForm.SetModelPropertyInfo(m_csUpstreamPrpty);
            csConnectionForm.EditParameter();
            csConnectionForm.Text = "【下流】→【上流】　逆方向セル接続設定";
            csConnectionForm.SetModelLabelName(false);

            HySCellDataGetter csTempCellDataGetter = new HySCellDataGetter(m_csUpstreamPrpty.GetCellDataGetter());

            if (csConnectionForm.ShowDialog() == DialogResult.OK)
            {// 設定選択の場合
                m_bConnectionModifyFlg = true;
            }
            else
            {// キャンセル選択の場合
                m_csUpstreamPrpty.SetCellDataGetter(csTempCellDataGetter);
            }
            m_csTempPropertyInfo.SetUpstreamTranInfoProperty(m_csUpstreamPrpty);

            csConnectionForm.Dispose();

            //bool bChg = ((McDotNetMutualTranInfoPropertyScreen)(m_csScreen)).SetUpstreamProperty();
        }

        /// <summary>
        /// 自動接続パターン設定
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void checkBoxAutoConnect_CheckedChanged(object sender, EventArgs e)
        {
            if(checkBoxAutoConnect.Checked == true )
            {
                for (int kk = 0; kk < LowerModelPattern.Items.Count; kk++)
                {
                    if (UpperModelPattern.SelectedItem == null) { continue; }
                    if (LowerModelPattern.Items[kk].ToString() == UpperModelPattern.SelectedItem.ToString())
                    {
                        LowerModelPattern.SelectedItem = UpperModelPattern.SelectedItem.ToString();
                        break;
                    }
                }
            }
        }

    } // end of class
}
