﻿// <summary>ソースコード：ＨＹＭＣＯセル型伝送データ結線画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>セル型伝送データ結線画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2009/09/02][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][修正]
    /// </para>
    /// </remarks>
    public partial class McDotNetTranInfoCellPropertyConnectionForm : HySDotNetForm
    {
        /// <summary>パラメータ情報</summary>
        private McCellArrayTranInfoPropertyInfo m_csPropertyInfo = null;
        /// <summary>テンポラリパラメータ情報</summary>
        private McCellArrayTranInfoPropertyInfo m_csTempPropertyInfo = null;

        /// <summary>初期表示フラグ</summary>
        private bool m_bInitialDisplayFlg = false;

        /// <summary>結線状態フラグ</summary>
        private bool[] m_bConnectionFlg = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTranInfoCellPropertyConnectionForm csTranInfoCellPropertyConnectionForm = new McDotNetTranInfoCellPropertyConnectionForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetTranInfoCellPropertyConnectionForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = (McCellArrayTranInfoPropertyInfo)csInfo;
            m_csTempPropertyInfo = (McCellArrayTranInfoPropertyInfo)m_csPropertyInfo.Clone();

            // 結線状態フラグ設定
            long lIdxNum = m_csPropertyInfo.GetCellDataGetter().GetIdxNum();
            m_bConnectionFlg = new bool[lIdxNum];
            for (long lLp = 0; lLp < lIdxNum; lLp++)
            {// インデックス数ループ
                m_bConnectionFlg[lLp] = true;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter()
        {
            // 上流モデル　モデル種別表示編集
            McCellModelPropertyInfo csUpperElmPropertyInf = (McCellModelPropertyInfo)m_csPropertyInfo.GetUpperModelProperty();
            if ((object)csUpperElmPropertyInf.GetModelName() == null)
            {// 名称設定がない場合
                UpperModelKind.Text = "";
            }
            else
            {// 名称設定がある場合
                UpperModelKind.Text = csUpperElmPropertyInf.GetModelName().ToString();
            }

            // 上流モデル　パターン名称表示編集
            McTranInfoPattern csPattern = (McTranInfoPattern)m_csPropertyInfo.GetSendTranInfoPattern();
            UpperModelPatternName.Text = csPattern.GetName().ToString();

            // 上流モデル　セル内情報表示編集
            HySDataCharacteristicInCell csCharacteristic = csPattern.GetCellDataCharacteristic();
            UpperModelDataGridView.Rows.Clear();
            string sLabelWork = "";
            string sUnitWork = "";
            for (long lLp = 0; lLp < csCharacteristic.GetDataNumber(); lLp++)
            {// セル内変数数ループ
                UpperModelDataGridView.Rows.Add();
                UpperModelDataGridView.Rows[UpperModelDataGridView.Rows.Count - 1].Cells[0].Value = lLp.ToString();
                csCharacteristic.GetDataKind(lLp, ref sLabelWork, ref sUnitWork);
                UpperModelDataGridView.Rows[UpperModelDataGridView.Rows.Count - 1].Cells[1].Value = sLabelWork;
                UpperModelDataGridView.Rows[UpperModelDataGridView.Rows.Count - 1].Cells[2].Value = sUnitWork;
                if (lLp >= 5)
                {// ５以上の場合
                    UpperModelDataGridView.Rows[UpperModelDataGridView.Rows.Count - 1].Visible = false;
                }
            }
            UpperModelScrollBar.Minimum = 0;
            UpperModelScrollBar.Maximum = (int)csCharacteristic.GetDataNumber() - 1;

            // 設定デフォルト値表示編集
            HySCellData csIndefiniteValue = (HySCellData)m_csPropertyInfo.GetCellDataGetter().GetIndefiniteValue();
            DefaultValueDataGridView.Rows.Clear();
            for (long lLp = 1; lLp < csIndefiniteValue.m_lDim; lLp++)
            {// 配列数ループ
                DefaultValueDataGridView.Rows.Add();
                DefaultValueDataGridView.Rows[DefaultValueDataGridView.Rows.Count - 1].Cells[0].Value = csIndefiniteValue.m_dData[lLp].ToString();
                DefaultValueDataGridView.Rows[DefaultValueDataGridView.Rows.Count - 1].Cells[1].Value = lLp.ToString();
                if (lLp > 3)
                {// ３より大きい場合
                    DefaultValueDataGridView.Rows[DefaultValueDataGridView.Rows.Count - 1].Visible = false;
                }
            }
            DefaultValueScrollBar.Minimum = 0;
            DefaultValueScrollBar.Maximum = (int)csIndefiniteValue.m_lDim - 2;

            // 下流モデル　モデル種別表示編集
            McCellModelPropertyInfo csLowerElmPropertyInf = (McCellModelPropertyInfo)m_csPropertyInfo.GetLowerModelProperty();
            if ((object)csLowerElmPropertyInf.GetModelName() == null)
            {// 名称設定がない場合
                LowerModelKind.Text = "";
            }
            else
            {// 名称設定がある場合
                LowerModelKind.Text = csLowerElmPropertyInf.GetModelName().ToString();
            }

            // 下流モデル　パターン名称表示編集
            csPattern = (McTranInfoPattern)m_csPropertyInfo.GetReceiveTranInfoPattern();
            LowerModelPatternName.Text = csPattern.GetName().ToString();

            // 下流モデル　セル内情報表示編集
            csCharacteristic = csPattern.GetCellDataCharacteristic();
            LowerModelDataGridView.Rows.Clear();
            for (long lLp = 0; lLp < csCharacteristic.GetDataNumber(); lLp++)
            {// セル内変数数ループ
                LowerModelDataGridView.Rows.Add();
                LowerModelDataGridView.Rows[LowerModelDataGridView.Rows.Count - 1].Cells[0].Value = lLp.ToString();
                csCharacteristic.GetDataKind(lLp, ref sLabelWork, ref sUnitWork);
                LowerModelDataGridView.Rows[LowerModelDataGridView.Rows.Count - 1].Cells[1].Value = sLabelWork;
                LowerModelDataGridView.Rows[LowerModelDataGridView.Rows.Count - 1].Cells[2].Value = sUnitWork;
                if (lLp >= 5)
                {// ５以上の場合
                    LowerModelDataGridView.Rows[LowerModelDataGridView.Rows.Count - 1].Visible = false;
                }
            }
            LowerModelScrollBar.Minimum = 0;
            LowerModelScrollBar.Maximum = (int)csCharacteristic.GetDataNumber() - 1;

            // 最大レコード保持数表示編集
            if (m_csPropertyInfo.GetMaxRecordDataNum() > 0)
            {// 最大レコード保持数が０より大きい場合
                MaxRec.Text = m_csPropertyInfo.GetMaxRecordDataNum().ToString();
                MaxRec.Enabled = true;
            }
            else
            {// 最大レコード保持数が０以下の場合
                MaxRec.Text = "1";
                MaxRec.Enabled = false;
            }

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="bUD_SW"> == true （上流→下流）、（下流→上流）</param>
        public void SetModelLabelName( bool bUD_SW )
        {
            if( bUD_SW == true )
            {
                LabelUpperModel.Text = "上流側モデル";
                LabelLowerModel.Text = "下流側モデル";
            }
            else
            {
                LabelUpperModel.Text = "下流側モデル";
                LabelLowerModel.Text = "上流側モデル";
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>結線状態表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditConnection( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EditConnection()
        {
            PictureBox[] csPictBoxS = { SendConnector1PictureBox, SendConnector2PictureBox, SendConnector3PictureBox, SendConnector4PictureBox, SendConnector5PictureBox };
            PictureBox[] csPictBoxR = { ReceiveConnector1PictureBox, ReceiveConnector2PictureBox, ReceiveConnector3PictureBox, ReceiveConnector4PictureBox, ReceiveConnector5PictureBox };
            PictureBox[] csPictBoxD = { SendConnector6PictureBox, SendConnector7PictureBox, SendConnector8PictureBox };

            if (ConnectionPictureBox.Image == null)
            {// イメージの設定がない場合
                ConnectionPictureBox.Image = new Bitmap(ConnectionPictureBox.Width, ConnectionPictureBox.Height);
            }

            // コネクター表示　上流リスト
            foreach (PictureBox csPB in csPictBoxS)
            {// コネクター数ループ
                csPB.Visible = false;
            }
            int iDrawCount = 0;
            for (long lLp = 0; lLp < UpperModelDataGridView.Rows.Count; lLp++)
            {// 行数ループ
                if (UpperModelDataGridView.Rows[(int)lLp].Visible == true)
                {// 表示の場合
                    csPictBoxS[iDrawCount].Visible = true;
                    iDrawCount++;
                }
            }

            // コネクター表示　デフォルト値リスト
            foreach (PictureBox csPB in csPictBoxD)
            {// コネクター数ループ
                csPB.Visible = false;
            }
            iDrawCount = 0;
            for (long lLp = 0; lLp < DefaultValueDataGridView.Rows.Count; lLp++)
            {// 行数ループ
                if (DefaultValueDataGridView.Rows[(int)lLp].Visible == true)
                {// 表示の場合
                    csPictBoxD[iDrawCount].Visible = true;
                    iDrawCount++;
                }
            }

            // コネクター表示　下流リスト
            foreach (PictureBox csPB in csPictBoxR)
            {// コネクター数ループ
                csPB.Visible = false;
            }
            iDrawCount = 0;
            for (long lLp = 0; lLp < LowerModelDataGridView.Rows.Count; lLp++)
            {// 行数ループ
                if (LowerModelDataGridView.Rows[(int)lLp].Visible == true)
                {// 表示の場合
                    csPictBoxR[iDrawCount].Visible = true;
                    iDrawCount++;
                }
            }

            // 接続線描画
            Graphics csGraphics = Graphics.FromImage(ConnectionPictureBox.Image);
            csGraphics.Clear(Color.Transparent);

            HySCellDataGetter csCellDataGetter = (HySCellDataGetter)m_csPropertyInfo.GetCellDataGetter();

            Point pSend = new Point();
            Point pReceive = new Point();
            long lSendIdx = 0;
            Pen csDrawPen = null;
            for (long lLp = 0; lLp < csCellDataGetter.GetIdxNum(); lLp++)
            {// インデックス数ループ
                if (m_bConnectionFlg[lLp] == true)
                {// 結線の場合
                    if (lLp >= LowerModelDataGridView.Rows.Count)
                    {// 行数以上の場合
                        continue;
                    } 

                    if (LowerModelDataGridView.Rows[(int)lLp].Visible == true)
                    {// 表示の場合
                        pReceive.X = 115;
                        pReceive.Y = 12 + ((int)lLp - LowerModelScrollBar.Value) * 21;
                    }
                    else
                    {// 非表示の場合
                        if (LowerModelScrollBar.Value > lLp)
                        {// 表示位置より小さい場合
                            pReceive.X = ConnectionPictureBox.Width;
                            pReceive.Y = 2;
                        }
                        else
                        {// 表示位置より大きい場合
                            pReceive.X = ConnectionPictureBox.Width;
                            pReceive.Y = 108;
                        }
                    }

                    lSendIdx = csCellDataGetter.GetIdx(lLp);
                    if (lSendIdx >= UpperModelDataGridView.Rows.Count)
                    {// 行数以上の場合
                        m_bConnectionFlg[lLp] = false;
                    }
                    else
                    {// 行数より小さい場合
                        if (lSendIdx >= 0)
                        {// インデックス値が０以上の場合
                            if (UpperModelDataGridView.Rows[(int)lSendIdx].Visible == true)
                            {// 表示の場合
                                pSend.X = 4;
                                pSend.Y = 12 + ((int)lSendIdx - UpperModelScrollBar.Value) * 21;
                            }
                            else
                            {// 非表示の場合
                                if (UpperModelScrollBar.Value > lSendIdx)
                                {// 表示位置より小さい場合
                                    pSend.X = 0;
                                    pSend.Y = 2;
                                }
                                else
                                {// 表示位置より大きい場合
                                    pSend.X = 0;
                                    pSend.Y = 108;
                                }
                            }
                            csDrawPen = new Pen(Color.Blue, 1);
                        }
                        else
                        {// インデックス値が０より小さい場合
                            if (DefaultValueDataGridView.Rows[(int)(-lSendIdx) - 1].Visible == true)
                            {// 表示の場合
                                pSend.X = 4;
                                pSend.Y = 145 + (((int)(-lSendIdx) - 1) - DefaultValueScrollBar.Value) * 21;
                            }
                            else
                            {// 非表示の場合
                                if (DefaultValueScrollBar.Value > ((int)(-lSendIdx) - 1))
                                {// 表示位置より小さい場合
                                    pSend.X = 0;
                                    pSend.Y = 135;
                                }
                                else
                                {// 表示位置より大きい場合
                                    pSend.X = 0;
                                    pSend.Y = 200;
                                }
                            }
                            csDrawPen = new Pen(Color.Red, 1);
                        }

                        csGraphics.DrawLine(csDrawPen, pSend, pReceive);
                        csDrawPen.Dispose();
                    }
                }
            }

            csGraphics.Dispose();

            ConnectionPictureBox.Refresh();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フォームが最初に表示されたときの処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Form_Shown(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Form_Shown(object sender, EventArgs e)
        {
            // 選択解除
            UpperModelDataGridView.ClearSelection();
            DefaultValueDataGridView.ClearSelection();
            LowerModelDataGridView.ClearSelection();

            // 初期表示完了設定
            m_bInitialDisplayFlg = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>上流側リスト選択変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModelDataGridView_SelectionChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpperModelDataGridView_SelectionChanged(object sender, EventArgs e)
        {
            // 初期表示確認
            if (m_bInitialDisplayFlg == false)
            {// 初期表示がまだの場合
                return;
            }

            // 選択行有無確認
            if (UpperModelDataGridView.SelectedRows.Count <= 0)
            {// 行選択されていない場合
                return;
            }

            // デフォルト値リスト選択解除
            DefaultValueDataGridView.ClearSelection();

            // 下流側リスト選択行有無確認
            if (LowerModelDataGridView.SelectedRows.Count <= 0)
            {// 行選択されていない場合
                return;
            }

            // 結線設定
            long lLowerIdx = long.Parse(LowerModelDataGridView.SelectedRows[0].Cells[0].Value.ToString());
            long lUpperIdx = long.Parse(UpperModelDataGridView.SelectedRows[0].Cells[0].Value.ToString());

            long[] lIdx = m_csPropertyInfo.GetCellDataGetter().GetIdx();
            for (long lLp = 0; lLp < m_csPropertyInfo.GetCellDataGetter().GetIdxNum(); lLp++)
            {// インデックス数ループ
                if (lIdx[lLp] == lUpperIdx)
                {// インデックス値が同じ場合
                    m_bConnectionFlg[lLp] = false;
                }
            }
            m_csPropertyInfo.GetCellDataGetter().SetIdx(lLowerIdx, lUpperIdx);
            m_bConnectionFlg[lLowerIdx] = true;

            // 選択解除
            UpperModelDataGridView.ClearSelection();
            LowerModelDataGridView.ClearSelection();

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルト値リスト選択変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DefaultValueDataGridView_SelectionChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DefaultValueDataGridView_SelectionChanged(object sender, EventArgs e)
        {
            // 初期表示確認
            if (m_bInitialDisplayFlg == false)
            {// 初期表示がまだの場合
                return;
            }

            // 選択行有無確認
            if (DefaultValueDataGridView.SelectedRows.Count <= 0)
            {// 行選択されていない場合
                return;
            }

            // 上流側リスト選択解除
            UpperModelDataGridView.ClearSelection();

            // 下流側リスト選択行有無確認
            if (LowerModelDataGridView.SelectedRows.Count <= 0)
            {// 行選択されていない場合
                return;
            }

            // 結線設定
            long lLowerIdx = long.Parse(LowerModelDataGridView.SelectedRows[0].Cells[0].Value.ToString());
            long lUpperIdx = -(long.Parse(DefaultValueDataGridView.SelectedRows[0].Cells[1].Value.ToString()));

            long[] lIdx = m_csPropertyInfo.GetCellDataGetter().GetIdx();
            for (long lLp = 0; lLp < m_csPropertyInfo.GetCellDataGetter().GetIdxNum(); lLp++)
            {// インデックス数ループ
                if (lIdx[lLp] == lUpperIdx)
                {// インデックス値が同じ場合
                    m_bConnectionFlg[lLp] = false;
                }
            }
            m_csPropertyInfo.GetCellDataGetter().SetIdx(lLowerIdx, lUpperIdx);
            m_bConnectionFlg[lLowerIdx] = true;

            // 選択解除
            DefaultValueDataGridView.ClearSelection();
            LowerModelDataGridView.ClearSelection();

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>下流側リスト選択変更</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LowerModelDataGridView_SelectionChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LowerModelDataGridView_SelectionChanged(object sender, EventArgs e)
        {
            // 初期表示確認
            if (m_bInitialDisplayFlg == false)
            {// 初期表示がまだの場合
                return;
            }

            // 選択行有無確認
            if (LowerModelDataGridView.SelectedRows.Count <= 0)
            {// 行選択されていない場合
                return;
            }

            // 上流側リスト・デフォルト値リスト選択行有無確認
            if ((UpperModelDataGridView.SelectedRows.Count <= 0) && (DefaultValueDataGridView.SelectedRows.Count <= 0))
            {// 行選択されていない場合
                return;
            }

            // 結線設定
            long lLowerIdx = long.Parse(LowerModelDataGridView.SelectedRows[0].Cells[0].Value.ToString());
            long lUpperIdx = 0;
            if (UpperModelDataGridView.SelectedRows.Count > 0)
            {// 選択数が０より大きい場合
                lUpperIdx = long.Parse(UpperModelDataGridView.SelectedRows[0].Cells[0].Value.ToString());
            }
            else
            {// 選択数が０以下の場合
                lUpperIdx = -(long.Parse(DefaultValueDataGridView.SelectedRows[0].Cells[1].Value.ToString()));
            }

            long[] lIdx = m_csPropertyInfo.GetCellDataGetter().GetIdx();
            for (long lLp = 0; lLp < m_csPropertyInfo.GetCellDataGetter().GetIdxNum(); lLp++)
            {// インデックス数ループ
                if (lIdx[lLp] == lUpperIdx)
                {// インデックス値が同じ場合
                    m_bConnectionFlg[lLp] = false;
                }
            }
            m_csPropertyInfo.GetCellDataGetter().SetIdx(lLowerIdx, lUpperIdx);
            m_bConnectionFlg[lLowerIdx] = true;

            // 選択解除
            UpperModelDataGridView.ClearSelection();
            DefaultValueDataGridView.ClearSelection();
            LowerModelDataGridView.ClearSelection();

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>上流側スクロールバー操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModelScrollBar_ValueChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpperModelScrollBar_ValueChanged(object sender, EventArgs e)
        {
            for (long lLp = 0; lLp < UpperModelDataGridView.Rows.Count; lLp++)
            {// 行数ループ
                if ((lLp < UpperModelScrollBar.Value) ||
                    (lLp >= UpperModelScrollBar.Value + UpperModelScrollBar.LargeChange))
                {// 表示範囲外の場合
                    UpperModelDataGridView.Rows[(int)lLp].Visible = false;
                }
                else
                {// 表示範囲内の場合
                    UpperModelDataGridView.Rows[(int)lLp].Visible = true;
                }
            }

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルト値スクロールバー操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModelScrollBar_ValueChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DefaultValueScrollBar_ValueChanged(object sender, EventArgs e)
        {
            for (long lLp = 0; lLp < DefaultValueDataGridView.Rows.Count; lLp++)
            {// 行数ループ
                if ((lLp < DefaultValueScrollBar.Value) ||
                    (lLp >= DefaultValueScrollBar.Value + DefaultValueScrollBar.LargeChange))
                {// 表示範囲外の場合
                    DefaultValueDataGridView.Rows[(int)lLp].Visible = false;
                }
                else
                {// 表示範囲内の場合
                    DefaultValueDataGridView.Rows[(int)lLp].Visible = true;
                }
            }

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>下流側スクロールバー操作</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LowerModelScrollBar_ValueChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LowerModelScrollBar_ValueChanged(object sender, EventArgs e)
        {
            for (long lLp = 0; lLp < LowerModelDataGridView.Rows.Count; lLp++)
            {// 行数ループ
                if ((lLp < LowerModelScrollBar.Value) ||
                    (lLp >= LowerModelScrollBar.Value + LowerModelScrollBar.LargeChange))
                {// 表示範囲外の場合
                    LowerModelDataGridView.Rows[(int)lLp].Visible = false;
                }
                else
                {// 表示範囲内の場合
                    LowerModelDataGridView.Rows[(int)lLp].Visible = true;
                }
            }

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg = false;

            // 選択解除
            UpperModelDataGridView.ClearSelection();
            DefaultValueDataGridView.ClearSelection();
            LowerModelDataGridView.ClearSelection();

            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            // 結線状態変更確認
            HySCellDataGetter csOrgCellDataGetter = (HySCellDataGetter)m_csTempPropertyInfo.GetCellDataGetter();
            HySCellDataGetter csNewCellDataGetter = (HySCellDataGetter)m_csPropertyInfo.GetCellDataGetter();
            for (long lLp = 0; lLp < csOrgCellDataGetter.GetIdxNum(); lLp++)
            {// インデックス数ループ
                if (csOrgCellDataGetter.GetIdx(lLp) != csNewCellDataGetter.GetIdx(lLp))
                {// インデックス値が違う場合
                    bChangeFlg = true;
                    break;
                }
            }

            // 最大レコード保持数変更確認
            if (MaxRec.Enabled == true)
            {// 編集可能の場合
                long lMaxRecWork = long.Parse(MaxRec.Text);

                if (m_csPropertyInfo.GetMaxRecordDataNum() != lMaxRecWork)
                {// 変更されている場合
                    m_csPropertyInfo.SetMaxRecordDataNum(lMaxRecWork);
                    bChangeFlg = true;
                }
            }

            // デフォルト値変更確認
            HySCellData csCellData = csNewCellDataGetter.GetIndefiniteValue();
            double dWork = 0;
            for (long lLp = 1; lLp < csCellData.m_lDim; lLp++)
            {// 配列数ループ
                dWork = double.Parse(DefaultValueDataGridView.Rows[(int)lLp - 1].Cells[0].Value.ToString());
                if (csCellData.m_dData[lLp] != dWork)
                {// 変更されている場合
                    csCellData.m_dData[lLp] = dWork;
                    bChangeFlg = true;
                }
            }

            Close();

            if (bChangeFlg == true)
            {// 変更がある場合
                // ダイアログ結果変更有り設定
                DialogResult = DialogResult.OK;
            }
            else
            {// 変更がない場合
                // ダイアログ結果変更無し設定
                DialogResult = DialogResult.Cancel;
            }
            //★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加（パラメータ設定画面の表示改善）
            //★★★★★★★★★★★★★★★★★★★★★★★
            // 結線画面から設定押下後に表示更新
            // パラメータ設定画面のインスタンス取得
            McDotNetTranInfoCellPropertyForm csMainForm = this.Owner as McDotNetTranInfoCellPropertyForm;
            McDotNetTranInfoGeoPropertyForm csMainGISForm = this.Owner as McDotNetTranInfoGeoPropertyForm;
            if (csMainForm != null)
            {
                csMainForm.ShowConnectionParameter(m_csPropertyInfo,0);
            }
            if (csMainGISForm != null)
            {
                csMainGISForm.ShowConnectionParameter(m_csPropertyInfo);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ParaSet_Check()
        {
            bool bRtn = false;

            // 未結線情報有無
            McTranInfoPattern csPattern = (McTranInfoPattern)m_csPropertyInfo.GetReceiveTranInfoPattern();
            HySDataCharacteristicInCell csCharacteristic = csPattern.GetCellDataCharacteristic();
            for (long lLp = csCharacteristic.GetDataNumber() - 1; lLp >= 0; lLp--)
            {// セル内変数数ループ
                if (m_bConnectionFlg[lLp] == false)
                {// 未結線の場合
                    LowerModelDataGridView.Rows[(int)lLp].DefaultCellStyle.BackColor = Color.Red;
                    if (LowerModelDataGridView.Rows.Count > 5)
                    {// 行数が５より大きい場合
                        if (lLp >= LowerModelDataGridView.Rows.Count - 5)
                        {// 下から５行内の場合
                            LowerModelScrollBar.Value = LowerModelDataGridView.Rows.Count - 5;
                        }
                        else
                        {// 下から５行外の場合
                            LowerModelScrollBar.Value = (int)lLp;
                        }
                    }
                    bRtn = true;
                }
                else
                {// 結線の場合
                    LowerModelDataGridView.Rows[(int)lLp].DefaultCellStyle.BackColor = Color.White;
                }
            }

            // 最大レコード保持数
            if (MaxRec.Enabled == true)
            {// 編集可能の場合
                try
                {
                    long lMaxRecWork = long.Parse(MaxRec.Text);

                    if (lMaxRecWork > 0)
                    {// 設定値が０より大きい場合
                        MaxRec.BackColor = Color.Empty;
                    }
                    else
                    {// 設定値が０以下の場合
                        // 入力異常を出力する
                        MaxRec.BackColor = Color.Red;
                        bRtn = true;
                    }
                }
                catch
                {
                    // 入力異常を出力する
                    MaxRec.BackColor = Color.Red;
                    bRtn = true;
                }
            }

            // デフォルト値
            HySCellDataGetter csCellDataGetter = (HySCellDataGetter)m_csPropertyInfo.GetCellDataGetter();
            double dWork = 0;
            //for (long lLp = 0; lLp < csCellDataGetter.GetIdxNum(); lLp++)
            for (long lLp = csCellDataGetter.GetIdxNum() - 1; lLp >= 0; lLp--)
            {// インデックス数ループ
                try
                {
                    dWork = double.Parse(DefaultValueDataGridView.Rows[(int)lLp].Cells[0].Value.ToString());
                    DefaultValueDataGridView.Rows[(int)lLp].DefaultCellStyle.BackColor = Color.White;
                }
                catch
                {
                    // 入力異常を出力する
                    DefaultValueDataGridView.Rows[(int)lLp].DefaultCellStyle.BackColor = Color.Red;
                    if (DefaultValueDataGridView.Rows.Count > 3)
                    {// 行数が３より大きい場合
                        if (lLp >= DefaultValueDataGridView.Rows.Count - 3)
                        {// 下から３行内の場合
                            DefaultValueScrollBar.Value = DefaultValueDataGridView.Rows.Count - 3;
                        }
                        else
                        {// 下から３行外の場合
                            DefaultValueScrollBar.Value = (int)lLp;
                        }
                    }
                    bRtn = true;
                }
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ポップアップメニュー表示処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ContextMenuStrip_Opening(sender,e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ContextMenuStrip_Opening(object sender, CancelEventArgs e)
        {
            if (((ContextMenuStrip)sender).Name == "UpperModelContextMenuStrip")
            {// 上流モデルリスト部の場合
                if (UpperModelDataGridView.SelectedRows.Count <= 0)
                {// 行数が０以下の場合
                    UpperModelSelectClearToolStripMenuItem.Enabled = false;
                }
                else
                {// 行数が０より大きい場合
                    UpperModelSelectClearToolStripMenuItem.Enabled = true;
                }
            }

            if (((ContextMenuStrip)sender).Name == "LowerModelContextMenuStrip")
            {// 下流モデルリスト部の場合
                if (LowerModelDataGridView.SelectedRows.Count <= 0)
                {// 行数が０以下の場合
                    LowerModelSelectClearToolStripMenuItem.Enabled = false;
                }
                else
                {// 行数が０より大きい場合
                    LowerModelSelectClearToolStripMenuItem.Enabled = true;
                }
            }

            if (((ContextMenuStrip)sender).Name == "DefaultValueContextMenuStrip")
            {// デフォルト値リスト部の場合
                if (DefaultValueDataGridView.SelectedRows.Count <= 0)
                {// 行数が０以下の場合
                    DefaultValueSelectClearToolStripMenuItem.Enabled = false;
                }
                else
                {// 行数が０より大きい場合
                    DefaultValueSelectClearToolStripMenuItem.Enabled = true;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>全接続の解除処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AllClearToolStripMenuItem_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AllClearToolStripMenuItem_Click(object sender, EventArgs e)
        {
            McTranInfoPattern csPattern = (McTranInfoPattern)m_csPropertyInfo.GetReceiveTranInfoPattern();
            HySDataCharacteristicInCell csCharacteristic = csPattern.GetCellDataCharacteristic();
            for (long lLp = 0; lLp < csCharacteristic.GetDataNumber(); lLp++)
            {// セル内変数数ループ
                m_bConnectionFlg[lLp] = false;
            }

            // 選択解除
            UpperModelDataGridView.ClearSelection();
            DefaultValueDataGridView.ClearSelection();
            LowerModelDataGridView.ClearSelection();

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択情報の接続解除処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SelectClearToolStripMenuItem_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectClearToolStripMenuItem_Click(object sender, EventArgs e)
        {
            HySCellDataGetter csCellDataGetter = (HySCellDataGetter)m_csPropertyInfo.GetCellDataGetter();

            long lIdx = 0;

            if (((ToolStripMenuItem)sender).Name == "UpperModelSelectClearToolStripMenuItem")
            {// 上流モデルリスト部の場合
                if (UpperModelDataGridView.SelectedRows.Count > 0)
                {// 行数が０より大きい場合
                    lIdx = long.Parse(UpperModelDataGridView.SelectedRows[0].Cells[0].Value.ToString());
                    for (long lLp = 0; lLp < csCellDataGetter.GetIdxNum(); lLp++)
                    {// インデックス数ループ
                        if (lIdx == csCellDataGetter.GetIdx(lLp))
                        {// インデックス値が一致した場合
                            m_bConnectionFlg[lLp] = false;
                        }
                    }
                }
            }

            if (((ToolStripMenuItem)sender).Name == "LowerModelSelectClearToolStripMenuItem")
            {// 下流モデルリスト部の場合
                if (LowerModelDataGridView.SelectedRows.Count > 0)
                {// 行数が０より大きい場合
                    lIdx = long.Parse(LowerModelDataGridView.SelectedRows[0].Cells[0].Value.ToString());
                    m_bConnectionFlg[lIdx] = false;
                }
            }

            if (((ToolStripMenuItem)sender).Name == "DefaultValueSelectClearToolStripMenuItem")
            {// デフォルト値リスト部の場合
                if (DefaultValueDataGridView.SelectedRows.Count > 0)
                {// 行数が０より大きい場合
                    lIdx = -(long.Parse(DefaultValueDataGridView.SelectedRows[0].Cells[1].Value.ToString()));
                    for (long lLp = 0; lLp < csCellDataGetter.GetIdxNum(); lLp++)
                    {// インデックス数ループ
                        if (lIdx == csCellDataGetter.GetIdx(lLp))
                        {// インデックス値が一致した場合
                            m_bConnectionFlg[lLp] = false;
                        }
                    }
                }
            }

            // 選択解除
            UpperModelDataGridView.ClearSelection();
            DefaultValueDataGridView.ClearSelection();
            LowerModelDataGridView.ClearSelection();

            // 結線状態表示編集
            EditConnection();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0010, null);
        }
    }
}