﻿// <summary>ソースコード：ＨＹＭＣＯGIS伝送データプロパティ画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>GIS伝送データプロパティ画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2009/10/04][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][メソッド追加][修正]
    /// </para>
    /// </remarks>
    public partial class McDotNetTranInfoGeoPropertyForm : HySDotNetForm, McModelPropertyFormIF
    {
        /// <summary>パラメータ情報</summary>
        private McPropertyInfoRoot m_csPropertyInfo = null;
        /// <summary>テンポラリパラメータ情報</summary>
        private McGeoMeshTranInfoPropertyInfo m_csTempPropertyInfo = null;
        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;

        /// <summary>上流要素モデルプロパティ情報 </summary>
        protected McCellModelPropertyInfo m_csUpperElmPropertyInf = null;
        /// <summary>上流要素の送信情報パターンリスト</summary>
        protected HySDataLinkedList m_csUpperElmSendTranDataPatternList = null;

        /// <summary>下流要素モデルプロパティ情報</summary>
        protected McCellModelPropertyInfo m_csLowerElmPropertyInf = null;
        /// <summary>下流要素の期待受信情報パターンリスト </summary>
        protected HySDataLinkedList m_csLowerElmReceiveTranDataPatternList = null;

        /// <summary>結線情報変更フラグ </summary>
        protected bool m_bConnectionModifyFlg = false;

        //メッセージ定義
		/// <summary>メッセージタイトル『モデル管理機能』 </summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_MODEL_MANAGEMENT");
		/// <summary>保存確認メッセージ『設定内容が変更されています。\n保存しますか？』 </summary>
		static private readonly string MSG_DATA_SET = McMessage.GetString("MC_MSG_QUESTION_CONFILM_DATA_SETUP");
        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加（パラメータ設定画面の表示改善）
        //★★★★★★★★★★★★★★★★★★★★★★★
        // 画面表示項目
        /// <summary>画面表示「結線設定状況」 </summary>
        static private readonly string TEXT_CELLINFO_SETSTATE = Properties.McDotNetViewerResources.TEXT_CELLINFO_SETSTATE;
        /// <summary>画面表示「最大レコード保持数」 </summary>
        static private readonly string TEXT_MAXRECORD_SETSTATE = Properties.McDotNetViewerResources.TEXT_MAXRECORD_SETSTATE;
        /// <summary>画面表示「セル内送信情報」 </summary>
        static private readonly string TEXT_SENDINFO_SETSTATE = Properties.McDotNetViewerResources.TEXT_SENDINFO_SETSTATE;

        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加（接続線セル数設定のメッセージスロー機能）
        //★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary>メッセージタイトル 『設定値エラー』</summary>
        static private readonly string MGSBOX_TITLE_PARAMSET_CHECK = Properties.McDotNetViewerResources.MGSBOX_TITLE_PARAMSET_CHECK;
        /// <summary>警告メッセージ 『セル数の設定が大きすぎます。』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_TOO_LARGE = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_TOO_LARGE;
        /// <summary>警告メッセージ 『セル接続数修正方法』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_ERR_MSG = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_ERR_MSG;
        /// <summary>警告メッセージ 『セル接続数修正方法(情報)』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_ERR_MSG_INFO = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_ERR_MSG_INFO;
        /// <summary>警告メッセージ 『セル接続数不整合』</summary>
        static private readonly string TEXT_CELL_ARRAY_PARAM_UNMATCH_GEO = Properties.McDotNetViewerResources.TEXT_CELL_ARRAY_PARAM_UNMATCH_GEO;


        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTranInfoGeoPropertyForm csTranInfoGeoPropertyForm = new McDotNetTranInfoGeoPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetTranInfoGeoPropertyForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = csInfo;
            m_csTempPropertyInfo = (McGeoMeshTranInfoPropertyInfo)HySDataDuplicate.DupliCateData(m_csPropertyInfo);
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElmPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUpperElmPropertyInfo(McCellModelPropertyInfo csInfo)
        {
            m_csUpperElmPropertyInf = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素の送信情報パターンリストインスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElmSendTranDataPatternList(csPatternList)</para>
        /// </example>
        /// <param name="csPatternList">上流要素の送信情報パターンリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUpperElmSendTranDataPatternList(HySDataLinkedList csPatternList)
        {
            m_csUpperElmSendTranDataPatternList = csPatternList;
        }

        /// <summary><para>method outline:</para>
        /// <para>下流要素モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerElmPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLowerElmPropertyInfo(McCellModelPropertyInfo csInfo)
        {
            m_csLowerElmPropertyInf = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>下流要素の受信情報パターンリストインスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerElmReceiveTranDataPatternList(csPatternList)</para>
        /// </example>
        /// <param name="csPatternList">下流要素の受信情報パターンリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLowerElmReceiveTranDataPatternList(HySDataLinkedList csPatternList)
        {
            m_csLowerElmReceiveTranDataPatternList = csPatternList;
        }

        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加（パラメータ設定画面の表示改善）
        //★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>設定状況を表示する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowConnectionParameter(csInfo)</para>
        /// </example>
        /// <param name="csInfo">伝送情報プロパティ設定情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowConnectionParameter(McCellArrayTranInfoPropertyInfo csInfo)
        {

            // スクロールバーを有効にする
            if (UpperModelSelectPattern.ScrollBars != ScrollBars.Both)
            {
                UpperModelSelectPattern.ScrollBars = ScrollBars.Both;
            }

            McCellArrayTranInfoPropertyInfo transInfoProperty;
            if (null == csInfo)
            {
                transInfoProperty = (McCellArrayTranInfoPropertyInfo)m_csPropertyInfo.Clone();
            }
            else
            {
                transInfoProperty = (McCellArrayTranInfoPropertyInfo)csInfo.Clone();
            }

            //---------------------------------
            //上流モデルの文字列を設定する
            //---------------------------------
            //　情報を正しく出力できるか判定する
            if (null == transInfoProperty.GetSendTranInfoPattern())
            {
                UpperModelSelectPattern.Text = "";
            }
            else
            {
                UpperModelSelectPattern.Text = CreateConnectionParameterString(
                                                    transInfoProperty
                                                    );
            }
        }

        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加（パラメータ設定画面の表示改善）
        //★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>設定状況の文字列を作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateConnectionParameterString(long,HySCellDataGetter,McTranInfoPattern)</para>
        /// </example>
        /// <param name="transInfoProperty">セル伝送情報プロパティ設定情報</param>
        /// <returns>設定状況の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected string CreateConnectionParameterString(
            McCellArrayTranInfoPropertyInfo transInfoProperty
            )
        {
            string resultString = "";

            resultString += CreateConnectionParameterString_sub1(
                                    transInfoProperty.GetMaxRecordDataNum()
                                    );
            resultString += CreateConnectionParameterString_sub2(
                                    transInfoProperty.GetCellDataGetter(),
                                    (McTranInfoPattern)transInfoProperty.GetSendTranInfoPattern()
                                    );

            return resultString;
        }


        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加（パラメータ設定画面の表示改善）
        //★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>結線設定状況の文字列を作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateConnectionParameterString_sub1(long)</para>
        /// </example>
        /// <param name="maxRecordNum">最大レコード保持数</param>
        /// <returns>結線設定状況の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected string CreateConnectionParameterString_sub1(
            long maxRecordNum
            )
        {
            string resultString = "";
            resultString += "【" + TEXT_CELLINFO_SETSTATE + "】" + Environment.NewLine + "■" + TEXT_MAXRECORD_SETSTATE + Environment.NewLine + maxRecordNum.ToString() + Environment.NewLine;
            return resultString;
        }


        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加（パラメータ設定画面の表示改善）
        //★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>セル内送信情報の文字列を作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateConnectionParameterString_sub2(HySCellDataGetter,McTranInfoPattern)</para>
        /// </example>
        /// <param name="cellDataGetter">セル内データのインデックス情報</param>
        /// <param name="pattern">伝送情報パターンプロパティ</param>
        /// <returns>セル内送信情報の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected string CreateConnectionParameterString_sub2(
            HySCellDataGetter cellDataGetter,
            McTranInfoPattern pattern
            )
        {
            string resultString = "";

            HySDataCharacteristicInCell csChara = pattern.GetCellDataCharacteristic();
            resultString += "■" + TEXT_SENDINFO_SETSTATE + Environment.NewLine;
            for (long lLp = 0; lLp < cellDataGetter.GetIdxNum(); lLp++)
            {
                long lDispItem = cellDataGetter.GetIdx(lLp);
                string sLabelWork = "";
                string sUnitWork = "";
                csChara.GetDataKind(lDispItem, ref sLabelWork, ref sUnitWork);
                if (sLabelWork != "")
                {
                    resultString += sLabelWork + "[" + sUnitWork + "]" + Environment.NewLine;
                }
            }

            return resultString;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter()
        {
            // 名称表示編集
            ModelName.Text = m_csElementName.ToString();
            if (m_csPropertyInfo != null)
            {// 登録プロパティ情報がある場合
                // 表示要素情報取得
                McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();
                ModelId.Text = csElement.GetID().ToString();

                // 種別名称表示編集
                if ((object)m_csPropertyInfo.GetModelName() == null)
                {// 名称設定がない場合
                    ModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    ModelKind.Text = m_csPropertyInfo.GetModelName().ToString();
                }

                // 種別表示編集
                if ((object)m_csPropertyInfo.GetModelKind() == null)
                {// 種別設定がある場合
                    ModelKindID.Text = "";
                }
                else
                {// 種別設定がある場合
                    ModelKindID.Text = m_csPropertyInfo.GetModelKind().ToString();
                }

                // セル配列数表示編集
                Latitude.Text = ((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetLatDim().ToString();
                Longitude.Text = ((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetLonDim().ToString();
                Altitude.Text = ((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetAltDim().ToString();

                // メッシュデータ種別
                if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetKind() == HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD)
                {// Double型データ配列の場合
                    MeshKind.SelectedIndex = 0;
                }
                else if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetKind() == HySGeoMesh.MESH_DATA_KIND.PATTARN_DATA_HOLD)
                {// パターン型の場合
                    MeshKind.SelectedIndex = 1;
                }
                else if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetKind() == HySGeoMesh.MESH_DATA_KIND.BOTH_DATA_HOLD)
                {// 両方のデータ型の場合
                    MeshKind.SelectedIndex = 2;
                }


            }

            // 結線ボタン非活性
            Connection.Enabled = false;

            if (m_csUpperElmPropertyInf == null)
            {// 上流要素モデルプロパティ情報がない場合
                // 上流モデル未設定時の表示編集
                UpperModel.Enabled = false;
                UpperModelKind.Text = "";
                UpperModelKind.Enabled = false;
                UpperModelPattern.Items.Clear();
                UpperModelPattern.Enabled = false;
                UpperModelSelectPattern.Text = "";
                UpperModelSelectPattern.Enabled = false;
            }
            else
            {// 上流要素モデルプロパティ情報がある場合
                // 上流モデルボタン活性
                UpperModel.Enabled = true;

                // 上流モデル　モデル種別活性・表示編集
                UpperModelKind.Enabled = true;
                if ((object)m_csUpperElmPropertyInf.GetModelName() == null)
                {// 名称設定がない場合
                    UpperModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    UpperModelKind.Text = m_csUpperElmPropertyInf.GetModelName().ToString();
                }

                // 上流モデル　選択接続パターン詳細クリア
                UpperModelSelectPattern.Text = "";
                UpperModelSelectPattern.Enabled = false;

                // 上流モデル　選択接続パターン活性・表示編集
                UpperModelPattern.Enabled = true;
                UpperModelPattern.Items.Clear();
                UpperModelPattern.Items.Add("");
                if (m_csUpperElmSendTranDataPatternList != null)
                {// 送信情報パターンリストがある場合
                    List<string> csLabelPatternList = new List<string>();
                    McTranInfoPattern csPattern = null;
                    for (int lLp = 0; lLp < m_csUpperElmSendTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        csPattern = (McTranInfoPattern)m_csUpperElmSendTranDataPatternList.GetData(lLp);
                        if (csPattern.GetTranDataKind().Equals(((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetModelKind()) == true)
                        {// 種別が一致した場合
                            //UpperModelPattern.Items.Add(csPattern.GetName().ToString());
                            csLabelPatternList.Add(csPattern.GetName().ToString());
                        }
                    }
                    csLabelPatternList.Sort(); // sort
                    for (int iLp = 0; iLp < csLabelPatternList.Count; iLp++)
                    {
                        UpperModelPattern.Items.Add(csLabelPatternList[iLp]);
                    }
                    if (m_csPropertyInfo != null)
                    {// 登録プロパティ情報がある場合
                        csPattern = (McTranInfoPattern)m_csTempPropertyInfo.GetSendTranInfoPattern();
                        if (csPattern != null)
                        {// セル型伝送パターンがある場合
                            UpperModelPattern.SelectedItem = csPattern.GetName().ToString();
                        }
                    }
                    //★★★★★★★★★★★★★★★★★★★★★★★
                    // Ver1.4で追加（パラメータ設定画面の表示改善）
                    //★★★★★★★★★★★★★★★★★★★★★★★
                    this.ShowConnectionParameter(null);
                }
            }

            if (m_csLowerElmPropertyInf == null)
            {// 下流要素モデルプロパティがない場合
                // 下流モデル未設定時の表示編集
                LowerModel.Enabled = false;
                LowerModelKind.Text = "";
                LowerModelKind.Enabled = false;
                LowerModelPattern.Items.Clear();
                LowerModelPattern.Enabled = false;
                LowerModelSelectPattern.Text = "";
                LowerModelSelectPattern.Enabled = false;
            }
            else
            {// 下流要素モデルプロパティがある場合
                // 下流モデルボタン活性
                LowerModel.Enabled = true;

                // 下流モデル　モデル種別活性・表示編集
                LowerModelKind.Enabled = true;
                if ((object)m_csLowerElmPropertyInf.GetModelName() == null)
                {// 名称設定がない場合
                    LowerModelKind.Text = "";
                }
                else
                {// 名称設定がある場合
                    LowerModelKind.Text = m_csLowerElmPropertyInf.GetModelName().ToString();
                }

                // 下流モデル　選択接続パターン詳細クリア
                LowerModelSelectPattern.Text = "";
                LowerModelSelectPattern.Enabled = false;

                // 下流モデル　選択接続パターン活性・表示編集
                LowerModelPattern.Enabled = true;
                LowerModelPattern.Items.Clear();
                LowerModelPattern.Items.Add("");
                if (m_csLowerElmReceiveTranDataPatternList != null)
                {// 受信情報パターンリストがある場合
                    List<string> csLabelPatternList = new List<string>();
                    McTranInfoPattern csPattern = null;
                    for (int lLp = 0; lLp < m_csLowerElmReceiveTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        csPattern = (McTranInfoPattern)m_csLowerElmReceiveTranDataPatternList.GetData(lLp);
                        if (csPattern.GetTranDataKind().Equals(((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetModelKind()) == true)
                        {// 種別が一致した場合
                            //LowerModelPattern.Items.Add(csPattern.GetName().ToString());
                            csLabelPatternList.Add(csPattern.GetName().ToString());
                        }
                    }
                    csLabelPatternList.Sort(); // sort
                    for (int iLp = 0; iLp < csLabelPatternList.Count; iLp++)
                    {
                        LowerModelPattern.Items.Add(csLabelPatternList[iLp]);
                    }
                    if (m_csPropertyInfo != null)
                    {// 登録プロパティ情報がある場合
                        csPattern = (McTranInfoPattern)m_csTempPropertyInfo.GetReceiveTranInfoPattern();
                        if (csPattern != null)
                        {// セル型伝送パターンがある場合
                            LowerModelPattern.SelectedItem = csPattern.GetName().ToString();
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択接続パターン（上流モデル）変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModelPattern_SelectedIndexChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpperModelPattern_SelectedIndexChanged(object sender, EventArgs e)
        {
            //long lDim1 = 0;
            //long lDim2 = 0;
            //long lDim3 = 0;
            //long lDataDimInCell = 0;
            //string sPatternWork = "";

            if (UpperModelPattern.SelectedIndex == 0)
            {// パターン未選択の場合
                UpperModelSelectPattern.Text = "";
                UpperModelSelectPattern.Enabled = false;

                m_csTempPropertyInfo.SetUpperConnectionPatternID(new HySID(""));

                ConnectionDataInitial();
            }
            else
            {// パターン選択の場合
                UpperModelSelectPattern.Enabled = true;

                if (m_csUpperElmSendTranDataPatternList != null)
                {// 送信情報パターンリストがある場合
                    for (int lLp = 0; lLp < m_csUpperElmSendTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        McTranInfoPattern csPattern = (McTranInfoPattern)m_csUpperElmSendTranDataPatternList.GetData(lLp);
                        if (UpperModelPattern.SelectedItem.ToString() == csPattern.GetName().ToString())
                        {// 名称が一致した場合
                            //csPattern.GetDimension(ref lDim1, ref lDim2, ref lDim3, ref lDataDimInCell);
                            //sPatternWork = csPattern.GetName().ToString() + "\r\n" + csPattern.GetTranDataKind().ToString() + "\r\n" + "セル配列" + "\r\n" + "(１次元：" + lDim1.ToString() + ")";
                            //if (lDim2 != 0)
                            //{
                            //    sPatternWork += "\r\n(２次元：" + lDim2.ToString() + ")";
                            //}
                            //if (lDim3 != 0)
                            //{
                            //    sPatternWork += "\r\n(３次元：" + lDim3.ToString() + ")";
                            //}
                            // 一時的に表示無し
                            //UpperModelSelectPattern.Text = sPatternWork;

                            if (m_csTempPropertyInfo.GetUpperConnectionPatternID().Equals(csPattern.GetPatternID()) != true)
                            {// IDが一致しない場合
                                m_csTempPropertyInfo.SetUpperConnectionPatternID(csPattern.GetPatternID());

                                ConnectionDataInitial();
                            }

                            //★★★★★★★★★★★★★★★★★★★★★★★
                            // Ver1.4で追加（パラメータ設定画面の表示改善）
                            //★★★★★★★★★★★★★★★★★★★★★★★
                            this.ShowConnectionParameter((McCellArrayTranInfoPropertyInfo)m_csTempPropertyInfo);

                            break;
                        }
                    }
                }
            }

            Connection.Enabled = false;
            if ((UpperModelPattern.SelectedIndex > 0) && (LowerModelPattern.SelectedIndex > 0))
            {// パターンが両方選択されている場合
                Connection.Enabled = true;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>選択接続パターン（下流モデル）変更処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LowerModelPattern_SelectedIndexChanged(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LowerModelPattern_SelectedIndexChanged(object sender, EventArgs e)
        {
            //long lDim1 = 0;
            //long lDim2 = 0;
            //long lDim3 = 0;
            //long lDataDimInCell = 0;
            //string sPatternWork = "";

            if (LowerModelPattern.SelectedIndex == 0)
            {// パターン未選択の場合
                LowerModelSelectPattern.Text = "";
                LowerModelSelectPattern.Enabled = false;

                m_csTempPropertyInfo.SetLowerConnectionPatternID(new HySID(""));

                ConnectionDataInitial();
            }
            else
            {// パターン選択の場合
                LowerModelSelectPattern.Enabled = true;

                if (m_csLowerElmReceiveTranDataPatternList != null)
                {// 受信情報パターンリストがある場合
                    for (int lLp = 0; lLp < m_csLowerElmReceiveTranDataPatternList.GetCount(); lLp++)
                    {// レコード数ループ
                        McTranInfoPattern csPattern = (McTranInfoPattern)m_csLowerElmReceiveTranDataPatternList.GetData(lLp);
                        if (LowerModelPattern.SelectedItem.ToString() == csPattern.GetName().ToString())
                        {// 名称が一致した場合
                            //csPattern.GetDimension(ref lDim1, ref lDim2, ref lDim3, ref lDataDimInCell);
                            //sPatternWork = csPattern.GetName().ToString() + "\r\n" + csPattern.GetTranDataKind().ToString() + "\r\n" + "セル配列" + "\r\n" + "(１次元：" + lDim1.ToString() + ")";
                            //if (lDim2 != 0)
                            //{
                            //    sPatternWork += "\r\n(２次元：" + lDim2.ToString() + ")";
                            //}
                            //if (lDim3 != 0)
                            //{
                            //    sPatternWork += "\r\n(３次元：" + lDim3.ToString() + ")";
                            //}
                            // 一時的に表示無し
                            //LowerModelSelectPattern.Text = sPatternWork;

                            if (m_csTempPropertyInfo.GetLowerConnectionPatternID().Equals(csPattern.GetPatternID()) != true)
                            {// IDが一致しない場合
                                m_csTempPropertyInfo.SetLowerConnectionPatternID(csPattern.GetPatternID());

                                ConnectionDataInitial();
                            }

                            break;
                        }
                    }
                }
            }

            Connection.Enabled = false;
            if ((UpperModelPattern.SelectedIndex > 0) && (LowerModelPattern.SelectedIndex > 0))
            {// パターンが両方選択されている場合
                Connection.Enabled = true;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>接続情報イニシャル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ConnectionDataInitial();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ConnectionDataInitial()
        {
            long lReceiveDataNumber = 8;
            long lSendDataNumber = 0;

            if (m_csTempPropertyInfo.GetReceiveTranInfoPattern() != null)
            {// セル型伝送パターンがある場合
                lReceiveDataNumber = ((McTranInfoPattern)m_csTempPropertyInfo.GetReceiveTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
            }
            m_csTempPropertyInfo.SetCellDataGetter(new HySCellDataGetter(lReceiveDataNumber));

            if (m_csTempPropertyInfo.GetSendTranInfoPattern() != null)
            {// セル型伝送パターンがある場合
                lSendDataNumber = ((McTranInfoPattern)m_csTempPropertyInfo.GetSendTranInfoPattern()).GetCellDataCharacteristic().GetDataNumber();
            }
            long lCounter = -1;
            for (long lLp = lSendDataNumber; lLp < lReceiveDataNumber; lLp++, lCounter--)
            {// 不足情報数ループ
                m_csTempPropertyInfo.GetCellDataGetter().SetIdx(lLp, lCounter);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>結線ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Connection_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Connection_Click(object sender, EventArgs e)
        {
            McDotNetTranInfoCellPropertyConnectionForm csConnectionForm = new McDotNetTranInfoCellPropertyConnectionForm();

            csConnectionForm.Owner = this;
            csConnectionForm.TopMost = false;
            csConnectionForm.StartPosition = FormStartPosition.CenterScreen;
            csConnectionForm.SetModelPropertyInfo(m_csTempPropertyInfo);
            csConnectionForm.EditParameter();

            HySCellDataGetter csTempCellDataGetter = new HySCellDataGetter(m_csTempPropertyInfo.GetCellDataGetter());

            if (csConnectionForm.ShowDialog() == DialogResult.OK)
            {// 設定選択の場合
                m_bConnectionModifyFlg = true;
            }
            else
            {// キャンセル選択の場合
                m_csTempPropertyInfo.SetCellDataGetter(csTempCellDataGetter);
            }

            csConnectionForm.Dispose();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

            Close();

            if (bChangeFlg2 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).PropertyInfoSet(true);
            }
            else if (bChangeFlg1 == true)
            {// 変更がある場合
                // プロパティ情報設定
                ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).PropertyInfoSet(false);
            }

            ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2)
        {
            bool bRtn = false;

            bChangeFlg1 = false;
            bChangeFlg2 = false;

            // セル配列数
            long lLat = long.Parse(Latitude.Text);
            long lLon = long.Parse(Longitude.Text);
            long lAlt = long.Parse(Altitude.Text);
            if ((lLat != ((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetLatDim()) ||
                (lLon != ((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetLonDim()) ||
                (lAlt != ((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetAltDim()))
            {// 配列数が変更された場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    ((McGeoMeshTranInfoPropertyInfo)m_csTempPropertyInfo).SetDim(lLon, lLat, lAlt);
                }
                bChangeFlg2 = true;
                bRtn = true;
            }

            // メッシュデータ種別
            if (MeshKind.SelectedIndex == 0)
            {// Double型データ配列の場合
                if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetKind() != HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD)
                {// Double型データ配列以外の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McGeoMeshTranInfoPropertyInfo)m_csTempPropertyInfo).SetKind(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD);
                    }
                    bChangeFlg2 = true;
                    bRtn = true;
                }
            }
            else if (MeshKind.SelectedIndex == 1)
            {// パターン型の場合
                if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetKind() != HySGeoMesh.MESH_DATA_KIND.PATTARN_DATA_HOLD)
                {// パターン型以外の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McGeoMeshTranInfoPropertyInfo)m_csTempPropertyInfo).SetKind(HySGeoMesh.MESH_DATA_KIND.PATTARN_DATA_HOLD);
                    }
                    bChangeFlg2 = true;
                    bRtn = true;
                }
            }
            else if (MeshKind.SelectedIndex == 2)
            {// 両方のデータ型の場合
                if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetKind() != HySGeoMesh.MESH_DATA_KIND.BOTH_DATA_HOLD)
                {// 両方のデータ型以外の場合
                    if (bSetFlg == true)
                    {// 設定反映の場合
                        ((McGeoMeshTranInfoPropertyInfo)m_csTempPropertyInfo).SetKind(HySGeoMesh.MESH_DATA_KIND.BOTH_DATA_HOLD);
                    }
                    bChangeFlg2 = true;
                    bRtn = true;
                }
            }

            // 上流モデルパターン
            if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetUpperConnectionPatternID().Equals(m_csTempPropertyInfo.GetUpperConnectionPatternID()) != true)
            {// パターンが変更された場合
                bChangeFlg2 = true;
                bRtn = true;
            }

            // 下流モデルパターン
            if (((McGeoMeshTranInfoPropertyInfo)m_csPropertyInfo).GetLowerConnectionPatternID().Equals(m_csTempPropertyInfo.GetLowerConnectionPatternID()) != true)
            {// パターンが変更された場合
                bChangeFlg2 = true;
                bRtn = true;
            }

            if (m_bConnectionModifyFlg == true)
            {// 結線情報変更の場合
                bChangeFlg2 = true;
                bRtn = true;
            }

            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

            if (bRtn == true)
            {// 変更がある場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    // プロパティ情報変更
                    csElement.GetModelInfo().SetPropertyInfo(m_csTempPropertyInfo);
                    // Gr内外の接続線に対して、プロパティ情報の設定
                    csElement.GetViewerConnect().SetTranInfoPropertyInfo(m_csTempPropertyInfo, null);
                }
            }

            // 要素名称
            if (ModelName.Text != m_csElementName.ToString())
            {// 名称に変更がある場合
                if (bSetFlg == true)
                {// 設定反映の場合
                    csElement.SetElementName(new HySString(ModelName.Text));
                }
                bChangeFlg1 = true;
                bRtn = true;
            }

            return bRtn;
        }

        //★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加（接続線セル数設定のメッセージスロー機能）
        //★★★★★★★★★★★★★★★★★★★★★★★
        enum CELL_ARREY_NUM_CHECK_KIND
        {
            CHECK_LAT = 0,
            CHECK_LON,
            CHECK_ALTITUDE,
            CHECK_LON_CONCENTENCY,
            TOTAL_NUM
        };

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaSet_Check()
        {
            bool bRtn = false;

            bool[] validParams = new bool[(int)CELL_ARREY_NUM_CHECK_KIND.TOTAL_NUM];
            for (int i = 0; i < (int)CELL_ARREY_NUM_CHECK_KIND.TOTAL_NUM; i++)
            {
                validParams[i] = true;
            }
            string[] labels = new string[(int)CELL_ARREY_NUM_CHECK_KIND.TOTAL_NUM]
                                                {
                                                    (string)this.LabelLatitude.Text.Clone(),
                                                    (string)this.LabelLongitude.Text.Clone(),
                                                    (string)this.LabelAltitude.Text.Clone(),
                                                    string.Empty
                                                };

            // セル配列数　緯度方向
            try
            {
                long lDimWork1 = long.Parse(Latitude.Text);

                //if ((lDimWork1 > 0) && (lDimWork1 <= 128))
                if ((lDimWork1 > 0) && (lDimWork1 <= McTranInfoDefine.TRNINF_DIM_MAX))
                {// 設定許可範囲内の場合
                    Latitude.BackColor = Color.Empty;
                }
                else
                {// 設定許可範囲外の場合
                    // 入力異常を出力する
                    Latitude.BackColor = Color.Red;
                    bRtn = true;
                    validParams[(int)CELL_ARREY_NUM_CHECK_KIND.CHECK_LAT] = false;
                }
            }
            catch
            {
                // 入力異常を出力する
                Latitude.BackColor = Color.Red;
                bRtn = true;
            }

            // セル配列数　経度方向
            try
            {
                long lDimWork1 = long.Parse(Latitude.Text);
                long lDimWork2 = long.Parse(Longitude.Text);

                //if ((lDimWork2 >= 0) && (lDimWork2 <= 128))
                if ((lDimWork2 >= 0) && (lDimWork1 * lDimWork2 <= McTranInfoDefine.TRNINF_DIM_MAX))
                {// 設定許可範囲内の場合
                    Longitude.BackColor = Color.Empty;
                }
                else
                {// 設定許可範囲外の場合
                    // 入力異常を出力する
                    Longitude.BackColor = Color.Red;
                    bRtn = true;
                    validParams[(int)CELL_ARREY_NUM_CHECK_KIND.CHECK_LON] = false;
                }
            }
            catch
            {
                // 入力異常を出力する
                Longitude.BackColor = Color.Red;
                bRtn = true;
            }

            // セル配列数　高度方向
            try
            {
                long lDimWork1 = long.Parse(Latitude.Text);
                long lDimWork2 = long.Parse(Longitude.Text);
                long lDimWork3 = long.Parse(Altitude.Text);

                //if ((lDimWork3 >= 0) && (lDimWork3 <= 128))
                if ((lDimWork3 >= 0) && (lDimWork1 * lDimWork2 * lDimWork3 <= McTranInfoDefine.TRNINF_DIM_MAX))
                {// 設定許可範囲内の場合
                    Altitude.BackColor = Color.Empty;
                }
                else
                {// 設定許可範囲外の場合
                    // 入力異常を出力する
                    Altitude.BackColor = Color.Red;
                    bRtn = true;
                    validParams[(int)CELL_ARREY_NUM_CHECK_KIND.CHECK_ALTITUDE] = false;
                }
            }
            catch
            {
                // 入力異常を出力する
                Altitude.BackColor = Color.Red;
                bRtn = true;
                validParams[(int)CELL_ARREY_NUM_CHECK_KIND.CHECK_ALTITUDE] = false;
            }

            // セル配列数合理性チェック
            try
            {
                long lDimWork2 = long.Parse(Longitude.Text);
                long lDimWork3 = long.Parse(Altitude.Text);

                if ((lDimWork2 == 0) && (lDimWork3 > 0))
                {// 合理性異常の場合
                    // 入力異常を出力する
                    Longitude.BackColor = Color.Red;
                    bRtn = true;
                    validParams[(int)CELL_ARREY_NUM_CHECK_KIND.CHECK_LON_CONCENTENCY] = false;
                }
            }
            catch
            {
            }


            //-------------------------------------
            // セル配列数が妥当かチェックを行い、
            // 不当なものがあればユーザに通知する
            //-------------------------------------
            for (int i = 0; i < (int)CELL_ARREY_NUM_CHECK_KIND.TOTAL_NUM; i++)
            {
                //-------------------------------------
                // セル配列数が妥当であれば何も行わない
                //-------------------------------------
                if (validParams[i])
                {
                    continue;
                }

                //-------------------------------------
                // セル配列数が不当であればメッセージボックスでユーザに通知する
                //-------------------------------------
                string message = string.Empty;
                if ((int)CELL_ARREY_NUM_CHECK_KIND.CHECK_LAT == i ||
                    (int)CELL_ARREY_NUM_CHECK_KIND.CHECK_LON == i ||
                    (int)CELL_ARREY_NUM_CHECK_KIND.CHECK_ALTITUDE == i)
                {
                    message = TEXT_CELL_ARRAY_PARAM_TOO_LARGE +
                                "(" +
                                labels[i] +
                                ")\r\n" +
                                TEXT_CELL_ARRAY_PARAM_ERR_MSG +
                                "\r\n\r\n" +
                                TEXT_CELL_ARRAY_PARAM_ERR_MSG_INFO;
                }
                else if ((int)CELL_ARREY_NUM_CHECK_KIND.CHECK_LON_CONCENTENCY == i)
                {
                    message = TEXT_CELL_ARRAY_PARAM_UNMATCH_GEO;
                }
                MessageBox.Show(
                            message,
                            MGSBOX_TITLE_PARAMSET_CHECK,
                            MessageBoxButtons.OK,
                            MessageBoxIcon.Warning
                            );

            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            Close();
            ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>上流モデルプロパティ表示処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpperModel_Click(object sender, EventArgs e)
        {
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();
            csElement.GetPortID(ref csFromID, ref csToID);
            if (csElement.GetPort(csFromID).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                return;
            }

            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            // 設定変更確認
            if (ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).PropertyInfoSet(false);
                    }
                }
            }

            // 上流モデルプロパティ表示要求
            ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).JunctureModelPropertyDispReq(csElement.GetPort(csFromID).GetParentElm());

            Close();
            ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>下流モデルプロパティ表示処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>UpperModel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LowerModel_Click(object sender, EventArgs e)
        {
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            // 表示要素情報取得
            McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();
            csElement.GetPortID(ref csFromID, ref csToID);
            if (csElement.GetPort(csToID).GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                return;
            }

            if (ParaSet_Check() == true)
            {// 設定値に異常がある場合
                return;
            }

            // 設定変更確認
            if (ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).PropertyInfoSet(false);
                    }
                }
            }

            // 下流モデルプロパティ表示要求
            ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).JunctureModelPropertyDispReq(csElement.GetPort(csToID).GetParentElm());

            Close();
            ((McDotNetTranInfoGeoPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0012,
                        ((HySDotNetViewer)((HySDotNetScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}