﻿// <summary>ソースコード：ＨＹＭＣＯ伝送データプロパティ画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>伝送データプロパティ画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/07/14][新規作成]</para>
    /// </remarks>
    public partial class McDotNetTranInfoPropertyForm : HySDotNetForm, McModelPropertyFormIF
    {
        /// <summary>パラメータ情報</summary>
        private McPropertyInfoRoot m_csPropertyInfo = null;
        /// <summary>初期設定情報</summary>
        private McPropertyInfoRoot m_csInitialInfo = null;
        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTranInfoPropertyForm csTranInfoPropertyForm = new McDotNetTranInfoPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetTranInfoPropertyForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csPropertyInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelInitialInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデル初期情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelInitialInfo(McPropertyInfoRoot csInfo)
        {
            m_csInitialInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter( )
        {
            McPropertyInfo csModelPrptyInf = null;
            McPropertyInfo csModelInitInf = null;
            ModelName.Text = m_csElementName.ToString();
            if (m_csPropertyInfo != null)       // 登録プロパティ情報有無
            {
                // 表示要素情報取得
                McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();
                ModelId.Text = csElement.GetID().ToString();

                if ((object)m_csPropertyInfo.GetModelName() == null)
                {
                    ModelKind.Text = "";
                }
                else
                {
                    ModelKind.Text = m_csPropertyInfo.GetModelName().ToString();
                }
                if ((object)m_csPropertyInfo.GetFactoryID() == null)
                {
                    ModelKindID.Text = "";
                }
                else
                {
                    ModelKindID.Text = m_csPropertyInfo.GetFactoryID().ToString();
                }
            }
            else
            {
                if (m_csInitialInfo != null)        // 登録初期設定情報有無
                {
                    if ((object)m_csInitialInfo.GetID() == null)
                    {
                        ModelId.Text = "";
                    }
                    else
                    {
                        ModelId.Text = m_csInitialInfo.GetID().ToString();
                    }
                    if ((object)m_csInitialInfo.GetModelName() == null)
                    {
                        ModelKind.Text = "";
                    }
                    else
                    {
                        ModelKind.Text = m_csInitialInfo.GetModelName().ToString();
                    }
                    if ((object)m_csInitialInfo.GetFactoryID() == null)
                    {
                        ModelKindID.Text = "";
                    }
                    else
                    {
                        ModelKindID.Text = m_csInitialInfo.GetFactoryID().ToString();
                    }
                }
            }

            if (m_csPropertyInfo != null)       // 登録プロパティ情報有無
            {
                HySString csKey = new HySString();
                HySString csPropatyName = new HySString();
                McDefine.ValKind lObjKind = new McDefine.ValKind();
                long lPropatyTypeNum = 0;
                int lPropatyTypeCnt = 0;
                bool bVal = new bool();
                long lVal = new long();
                double dVal = new double();
                string sVal = "";

                csModelPrptyInf = m_csPropertyInfo as McPropertyInfo;

                if (csModelPrptyInf != null)
                {
                    // プロパティ情報取得
                    lPropatyTypeNum = csModelPrptyInf.GetInfoTypeNum();    // 登録プロパティ情報数取得
                    for (long lP = 1; lP <= lPropatyTypeNum; lP++)
                    {
                        // プロパティ情報型式の取得
                        if (csModelPrptyInf.GetInfoType(lP, ref csKey, ref csPropatyName, ref lObjKind) == true)
                        {
                            if (lObjKind == McDefine.ValKind.BOOL)
                            {   // 論理型の場合
                                if (csModelPrptyInf.GetInfo(csKey, ref bVal) == true)
                                {
                                    ModelPropertyDataGridView.Rows.Add();   // 行追加
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[0].Value = csPropatyName.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[1].Value = bVal.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[2].Value = csKey.ToString();
                                    lPropatyTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.DOUBLE)
                            {   // 実数型の場合
                                if (csModelPrptyInf.GetInfo(csKey, ref dVal) == true)
                                {
                                    ModelPropertyDataGridView.Rows.Add();   // 行追加
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[0].Value = csPropatyName.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[1].Value = dVal.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[2].Value = csKey.ToString();
                                    lPropatyTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.LONG)
                            {   // 倍精度整数型の場合
                                if (csModelPrptyInf.GetInfo(csKey, ref lVal) == true)
                                {
                                    ModelPropertyDataGridView.Rows.Add();   // 行追加
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[0].Value = csPropatyName.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[1].Value = lVal.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[2].Value = csKey.ToString();
                                    lPropatyTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.STRING)
                            {   // 文字列型の場合
                                if (csModelPrptyInf.GetInfo(csKey, ref sVal) == true)
                                {
                                    ModelPropertyDataGridView.Rows.Add();   // 行追加
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[0].Value = csPropatyName.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[1].Value = sVal.ToString();
                                    ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[2].Value = csKey.ToString();
                                    lPropatyTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else
                            {
                                continue;
                            }
                        }
                    }
                }
            }
            if (m_csInitialInfo != null)        // 登録初期設定情報有無
            {
                HySString csKey = new HySString();
                HySString csInitialName = new HySString();
                McDefine.ValKind lObjKind = new McDefine.ValKind();
                long lInitialTypeNum = 0;
                int lInitialTypeCnt = 0;
                bool bVal = new bool();
                long lVal = new long();
                double dVal = new double();
                string sVal = "";

                csModelInitInf = m_csInitialInfo as McPropertyInfo;

                if (csModelInitInf != null)
                {
                    // 初期設定情報取得
                    lInitialTypeNum = csModelInitInf.GetInfoTypeNum();     // 登録初期設定情報数取得
                    for (long lP = 1; lP <= lInitialTypeNum; lP++)
                    {
                        // プロパティ情報型式の取得
                        if (csModelInitInf.GetInfoType(lP, ref csKey, ref csInitialName, ref lObjKind) == true)
                        {
                            if (lObjKind == McDefine.ValKind.BOOL)
                            {   // 論理型の場合
                                if (csModelInitInf.GetInfo(csKey, ref bVal) == true)
                                {
                                    ModelInitialDataGridView.Rows.Add();    // 行追加
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[0].Value = csInitialName.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[1].Value = bVal.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[2].Value = csKey.ToString();
                                    lInitialTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.DOUBLE)
                            {   // 実数型の場合
                                if (csModelInitInf.GetInfo(csKey, ref dVal) == true)
                                {
                                    ModelInitialDataGridView.Rows.Add();    // 行追加
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[0].Value = csInitialName.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[1].Value = dVal.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[2].Value = csKey.ToString();
                                    lInitialTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.LONG)
                            {   // 倍精度整数型の場合
                                if (csModelInitInf.GetInfo(csKey, ref lVal) == true)
                                {
                                    ModelInitialDataGridView.Rows.Add();    // 行追加
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[0].Value = csInitialName.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[1].Value = lVal.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[2].Value = csKey.ToString();
                                    lInitialTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.STRING)
                            {   // 文字列型の場合
                                if (csModelInitInf.GetInfo(csKey, ref sVal) == true)
                                {
                                    ModelInitialDataGridView.Rows.Add();    // 行追加
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[0].Value = csInitialName.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[1].Value = sVal.ToString();
                                    ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[2].Value = csKey.ToString();
                                    lInitialTypeCnt++;                      // 行数カウンタ更新
                                }
                            }
                            else
                            {
                                continue;
                            }
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaSet_Check()
        {
            HySString csKey;
            HySString csPropatyName = new HySString();
            HySString csInitialName = new HySString();
            McDefine.ValKind lObjKind = new McDefine.ValKind();
            long lP = 0;
            long lPropatyTypeNum = 0;　
            long lInitialTypeNum = 0;　
            bool bVal;
            long lVal;
            double dVal;
            string sVal;
            bool bBrakefg = false;

            if (m_csPropertyInfo != null)   // 登録プロパティ情報有無
            {
                lPropatyTypeNum = ModelPropertyDataGridView.Rows.Count;     // 登録プロパティ情報数取得
                for (lP = 0; lP < lPropatyTypeNum; lP++)
                {
                    // プロパティ情報型式の取得
                    if (ModelPropertyDataGridView.Rows[(int)lP].Cells[2].Value != null)
                    {
                        csKey = new HySString(ModelPropertyDataGridView.Rows[(int)lP].Cells[2].Value.ToString());
                        // 型式別に登録
                        if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                        {
                            try
                            {
                                if (lObjKind == McDefine.ValKind.BOOL)
                                {   // 論理型の場合
                                    bVal = bool.Parse(ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                }
                                else if (lObjKind == McDefine.ValKind.DOUBLE)
                                {   // 実数型の場合
                                    dVal = double.Parse(ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                }
                                else if (lObjKind == McDefine.ValKind.LONG)
                                {   // 倍精度整数型の場合
                                    lVal = long.Parse(ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                }
                                else if (lObjKind == McDefine.ValKind.STRING)
                                {   // 文字列型の場合
                                    sVal = ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString();
                                }
                                // セルスタイルを戻す
                                ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Style.BackColor = Color.Empty;
                                ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Style.SelectionBackColor = Color.Empty;
                            }
                            catch
                            {
                                // 入力異常を出力する
                                ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Style.BackColor = Color.Red;
                                ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Style.SelectionBackColor = Color.Red;
                                ModelPropertyDataGridView.FirstDisplayedScrollingRowIndex = (int)lP;
                                bBrakefg = true;
                                TabControl1.SelectedIndex = 0;
                            }
                        }
                    }
                }
            }

            if (m_csInitialInfo != null)    // 登録初期設定情報
            {
                lInitialTypeNum = ModelInitialDataGridView.Rows.Count;      // 登録初期設定情報数取得
                for (lP = 0; lP < lInitialTypeNum; lP++)
                {
                    // プロパティ情報型式の取得
                    if (ModelInitialDataGridView.Rows[(int)lP].Cells[2].Value != null)
                    {
                        csKey = new HySString(ModelInitialDataGridView.Rows[(int)lP].Cells[2].Value.ToString());
                        // 型式別に登録
                        if (((McPropertyInfo)m_csInitialInfo).GetInfoType(csKey, ref csInitialName, ref lObjKind) == true)
                        {
                            try
                            {
                                if (lObjKind == McDefine.ValKind.BOOL)
                                {   // 論理型の場合
                                    bVal = bool.Parse(ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                }
                                else if (lObjKind == McDefine.ValKind.DOUBLE)
                                {   // 実数型の場合
                                    dVal = double.Parse(ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                }
                                else if (lObjKind == McDefine.ValKind.LONG)
                                {   // 倍精度整数型の場合
                                    lVal = long.Parse(ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                }
                                else if (lObjKind == McDefine.ValKind.STRING)
                                {   // 文字列型の場合
                                    sVal = ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString();
                                }
                                // セルスタイルを戻す
                                ModelInitialDataGridView.Rows[(int)lP].Cells[1].Style.BackColor = Color.Empty;
                                ModelInitialDataGridView.Rows[(int)lP].Cells[1].Style.SelectionBackColor = Color.Empty;
                            }
                            catch
                            {
                                // 入力異常を出力する
                                ModelInitialDataGridView.Rows[(int)lP].Cells[1].Style.BackColor = Color.Red;
                                ModelInitialDataGridView.Rows[(int)lP].Cells[1].Style.SelectionBackColor = Color.Red;
                                ModelInitialDataGridView.FirstDisplayedScrollingRowIndex = (int)lP;
                                bBrakefg = true;
                                TabControl1.SelectedIndex = 1;
                            }
                        }
                    }
                }
            }

            return bBrakefg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (ParaSet_Check() == true)
            {
                return;
            }

            // 設定内容登録
            if (ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2) == true)
            {
                // プロパティ情報設定イベント送信要求
                ((McDotNetTranInfoPropertyScreen)m_csScreen).ReqPropertyInfoSetEvent();
            }

            Close();
            ((McDotNetTranInfoPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2)
        {
            HySString csKey = null;
            HySString csPropatyName = new HySString();
            HySString csInitialName = new HySString();
            McDefine.ValKind lObjKind = new McDefine.ValKind();
            long lPropatyTypeNum = 0;
            long lInitialTypeNum = 0;
            bool bOrgVal = new bool();
            bool bNewVal;
            long lOrgVal = new long();
            long lNewVal;
            double dOrgVal = new double();
            double dNewVal;
            string sOrgVal = "";
            string sNewVal;
            bool bRtn = false;

            // 要素名称
            if (m_csElementName.ToString() != ModelName.Text)
            {
                if (bSetFlg == true)
                {
                    // 表示要素情報取得
                    McGraphicsElement csElement = (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

                    csElement.SetElementName(new HySString(ModelName.Text));
                }
                bRtn = true;
                bChangeFlg1 = true;
            }

            if (m_csPropertyInfo != null)   // 登録プロパティ情報有無
            {
                lPropatyTypeNum = ModelPropertyDataGridView.Rows.Count;     // 登録プロパティ情報数取得
                for (long lP = 0; lP < lPropatyTypeNum; lP++)
                {
                    // プロパティ情報型式の取得
                    if (ModelPropertyDataGridView.Rows[(int)lP].Cells[2].Value != null)
                    {
                        csKey = new HySString(ModelPropertyDataGridView.Rows[(int)lP].Cells[2].Value.ToString());
                        // 型式別に登録
                        if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                        {
                            if (lObjKind == McDefine.ValKind.BOOL)
                            {   // 論理型の場合
                                bNewVal = bool.Parse(ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                ((McPropertyInfo)m_csPropertyInfo).GetInfo(csKey, ref bOrgVal);
                                if (bNewVal != bOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csPropertyInfo).SetInfo(csKey, bNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.DOUBLE)
                            {   // 実数型の場合
                                dNewVal = double.Parse(ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                ((McPropertyInfo)m_csPropertyInfo).GetInfo(csKey, ref dOrgVal);
                                if (dNewVal != dOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csPropertyInfo).SetInfo(csKey, dNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.LONG)
                            {   // 倍精度整数型の場合
                                lNewVal = long.Parse(ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                ((McPropertyInfo)m_csPropertyInfo).GetInfo(csKey, ref lOrgVal);
                                if (lNewVal != lOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csPropertyInfo).SetInfo(csKey, lNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.STRING)
                            {   // 文字列型の場合
                                sNewVal = ModelPropertyDataGridView.Rows[(int)lP].Cells[1].Value.ToString();
                                ((McPropertyInfo)m_csPropertyInfo).GetInfo(csKey, ref sOrgVal);
                                if (sNewVal != sOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csPropertyInfo).SetInfo(csKey, sNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                        }
                    }
                }
            }
            if (m_csInitialInfo != null)    // 登録初期設定情報
            {
                lInitialTypeNum = ModelInitialDataGridView.Rows.Count;      // 登録初期設定情報数取得
                for (long lP = 0; lP < lInitialTypeNum; lP++)
                {
                    // 初期設定情報型式の取得
                    if (ModelInitialDataGridView.Rows[(int)lP].Cells[2].Value != null)
                    {
                        csKey = new HySString(ModelInitialDataGridView.Rows[(int)lP].Cells[2].Value.ToString());
                        // 型式別に登録
                        if (((McPropertyInfo)m_csInitialInfo).GetInfoType(csKey, ref csPropatyName, ref lObjKind) == true)
                        {
                            if (lObjKind == McDefine.ValKind.BOOL)
                            {   // 論理型の場合
                                bNewVal = bool.Parse(ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                ((McPropertyInfo)m_csInitialInfo).GetInfo(csKey, ref bOrgVal);
                                if (bNewVal != bOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csInitialInfo).SetInfo(csKey, bNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.DOUBLE)
                            {   // 実数型の場合
                                dNewVal = double.Parse(ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                ((McPropertyInfo)m_csInitialInfo).GetInfo(csKey, ref dOrgVal);
                                if (dNewVal != dOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csInitialInfo).SetInfo(csKey, dNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.LONG)
                            {   // 倍精度整数型の場合
                                lNewVal = long.Parse(ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString());
                                ((McPropertyInfo)m_csInitialInfo).GetInfo(csKey, ref lOrgVal);
                                if (lNewVal != lOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csInitialInfo).SetInfo(csKey, lNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                            else if (lObjKind == McDefine.ValKind.STRING)
                            {   // 文字列型の場合
                                sNewVal = ModelInitialDataGridView.Rows[(int)lP].Cells[1].Value.ToString();
                                ((McPropertyInfo)m_csInitialInfo).GetInfo(csKey, ref sOrgVal);
                                if (sNewVal != sOrgVal)
                                {
                                    if (bSetFlg == true)
                                    {
                                        ((McPropertyInfo)m_csInitialInfo).SetInfo(csKey, sNewVal);
                                    }
                                    bRtn = true;
                                    bChangeFlg1 = true;
                                }
                            }
                        }
                    }
                }
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            Close();
            ((McDotNetTranInfoPropertyScreen)m_csScreen).ClosedForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル入力処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileOpen_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileOpen_Click(object sender, EventArgs e)
        {
            if (m_csPropertyInfo != null || m_csInitialInfo != null)
            {  // プロパティ情報・初期設定情報があった場合
                OpenFileDialog.FileName = "";
                OpenFileDialog.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML_CSV; //"ＣＳＶ ファイル (*.csv)|*.csv|すべてのファイル (*.*)|*.*"
                if (OpenFileDialog.ShowDialog(this) == DialogResult.OK)
                {
                    FileName.Text = OpenFileDialog.FileName;        // テキスト表示
                    // ファイル入力
                    string csFileName = OpenFileDialog.FileName;    // 入力ファイルフルパス名

                    HySFile csFile = new HySFile((new HySString(csFileName)));
                    if (csFile.Exist() == true)
                    {  // 既存ファイルが有れば
                        if (csFileName.IndexOf(".csv", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                        {
                            HySString sOut = new HySString();
                            string[] sInWk;
                            int lPropatyTypeCnt = 0;
                            int lInitialTypeCnt = 0;

                            if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                            {   // 既存CSVファイルを正常に開ければ
                                lPropatyTypeCnt = ModelPropertyDataGridView.Rows.Count; // 登録プロパティ情報数取得
                                for (long lP = 0; lP < lPropatyTypeCnt; lP++)
                                {   // 行がある場合
                                    ModelPropertyDataGridView.Rows.RemoveAt(0);         // 先頭行削除
                                }
                                lPropatyTypeCnt = 0;

                                lInitialTypeCnt = ModelInitialDataGridView.Rows.Count;  // 登録初期設定情報数取得
                                for (long lP = 0; lP < lInitialTypeCnt; lP++)
                                {   // 行がある場合
                                    ModelInitialDataGridView.Rows.RemoveAt(0);          // 先頭行削除
                                }
                                lInitialTypeCnt = 0;

                                while (csFile.ReadText(ref sOut) != 0)
                                {   // １行取得
                                    sInWk = sOut.ToString().Split(',');
                                    if (sInWk.LongLength == 4)
                                    {   // パラメータ情報項目数と一致した場合
                                        if (sInWk[0] != "#")
                                        {   // コメント行以外の場合
                                            if (sInWk[0] == "[P]")
                                            {   //プロパティ情報
                                                ModelPropertyDataGridView.Rows.Add();       // 行追加
                                                ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[0].Value = sInWk[1];
                                                ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[1].Value = sInWk[2];
                                                ModelPropertyDataGridView.Rows[lPropatyTypeCnt].Cells[2].Value = sInWk[3];
                                                lPropatyTypeCnt++;
                                            }
                                            else if (sInWk[0] == "[I]")
                                            {   //初期設定情報
                                                ModelInitialDataGridView.Rows.Add();        // 行追加
                                                ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[0].Value = sInWk[1];
                                                ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[1].Value = sInWk[2];
                                                ModelInitialDataGridView.Rows[lInitialTypeCnt].Cells[2].Value = sInWk[3];
                                                lInitialTypeCnt++;
                                            }
                                        }
                                    }
                                }
                                csFile.Close();
                            }
                        }
                        else if (csFileName.IndexOf(".xml", csFileName.Length - 4, StringComparison.CurrentCultureIgnoreCase) >= 0)
                        {
                            HySXmlReader csXmlReader = new HySXmlReader(csFileName);
                            HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
                            HySXmlNodeList csXmlChildNodeList = null;

                            csXmlChildNodeList = csXmlRootNode.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
                            if (csXmlChildNodeList.GetCount() > 0)
                            {
                                HySString csKey = new HySString();
                                HySString csPropertyName = new HySString();
                                McDefine.ValKind lObjKind = new McDefine.ValKind();
                                bool bVal = new bool();
                                long lVal = new long();
                                double dVal = new double();
                                string sVal = "";

                                McPropertyInfo csXmlInWorkInfo = new McPropertyInfo(m_csPropertyInfo.GetFactoryID(), (HySObjectKind)m_csPropertyInfo.GetModelKind());
                                csXmlInWorkInfo.XmlIN(csXmlChildNodeList.GetNode(0));
                                for (int iLp = 0; iLp < ModelPropertyDataGridView.Rows.Count; iLp++)
                                {
                                    csKey = new HySString(ModelPropertyDataGridView.Rows[iLp].Cells[2].Value.ToString());
                                    if (csXmlInWorkInfo.GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                                    {
                                        if (lObjKind == McDefine.ValKind.BOOL)
                                        {   // 論理型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref bVal);
                                            ModelPropertyDataGridView.Rows[iLp].Cells[0].Value = csPropertyName.ToString();
                                            ModelPropertyDataGridView.Rows[iLp].Cells[1].Value = bVal.ToString();
                                        }
                                        else if (lObjKind == McDefine.ValKind.DOUBLE)
                                        {   // 実数型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref dVal);
                                            ModelPropertyDataGridView.Rows[iLp].Cells[0].Value = csPropertyName.ToString();
                                            ModelPropertyDataGridView.Rows[iLp].Cells[1].Value = dVal.ToString();
                                        }
                                        else if (lObjKind == McDefine.ValKind.LONG)
                                        {   // 倍精度整数型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref lVal);
                                            ModelPropertyDataGridView.Rows[iLp].Cells[0].Value = csPropertyName.ToString();
                                            ModelPropertyDataGridView.Rows[iLp].Cells[1].Value = lVal.ToString();
                                        }
                                        else if (lObjKind == McDefine.ValKind.STRING)
                                        {   // 文字列型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref sVal);
                                            ModelPropertyDataGridView.Rows[iLp].Cells[0].Value = csPropertyName.ToString();
                                            ModelPropertyDataGridView.Rows[iLp].Cells[1].Value = sVal;
                                        }
                                    }
                                }
                            }

                            csXmlChildNodeList = csXmlRootNode.GetChildNodeListByTagName(McDefine.xml_INITIAL_SET);
                            if (csXmlChildNodeList.GetCount() > 0)
                            {
                                HySString csKey = new HySString();
                                HySString csInitialName = new HySString();
                                McDefine.ValKind lObjKind = new McDefine.ValKind();
                                bool bVal = new bool();
                                long lVal = new long();
                                double dVal = new double();
                                string sVal = "";

                                McInitialInfo csXmlInWorkInfo = new McInitialInfo(m_csInitialInfo.GetFactoryID(), (HySObjectKind)m_csInitialInfo.GetModelKind());
                                csXmlInWorkInfo.XmlIN(csXmlChildNodeList.GetNode(0));
                                for (int iLp = 0; iLp < ModelInitialDataGridView.Rows.Count; iLp++)
                                {
                                    csKey = new HySString(ModelInitialDataGridView.Rows[iLp].Cells[2].Value.ToString());
                                    if (csXmlInWorkInfo.GetInfoType(csKey, ref csInitialName, ref lObjKind) == true)
                                    {
                                        if (lObjKind == McDefine.ValKind.BOOL)
                                        {   // 論理型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref bVal);
                                            ModelInitialDataGridView.Rows[iLp].Cells[0].Value = csInitialName.ToString();
                                            ModelInitialDataGridView.Rows[iLp].Cells[1].Value = bVal.ToString();
                                        }
                                        else if (lObjKind == McDefine.ValKind.DOUBLE)
                                        {   // 実数型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref dVal);
                                            ModelInitialDataGridView.Rows[iLp].Cells[0].Value = csInitialName.ToString();
                                            ModelInitialDataGridView.Rows[iLp].Cells[1].Value = dVal.ToString();
                                        }
                                        else if (lObjKind == McDefine.ValKind.LONG)
                                        {   // 倍精度整数型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref lVal);
                                            ModelInitialDataGridView.Rows[iLp].Cells[0].Value = csInitialName.ToString();
                                            ModelInitialDataGridView.Rows[iLp].Cells[1].Value = lVal.ToString();
                                        }
                                        else if (lObjKind == McDefine.ValKind.STRING)
                                        {   // 文字列型の場合
                                            csXmlInWorkInfo.GetInfo(csKey, ref sVal);
                                            ModelInitialDataGridView.Rows[iLp].Cells[0].Value = csInitialName.ToString();
                                            ModelInitialDataGridView.Rows[iLp].Cells[1].Value = sVal;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル出力処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileSave_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileSave_Click(object sender, EventArgs e)
        {
            if (ParaSet_Check() == true)
            {
                return;
            }

            if (m_csPropertyInfo != null || m_csInitialInfo != null)
            {  // プロパティ情報・初期設定情報があった場合
                SaveFileDialog.FileName = FileName.Text;
                SaveFileDialog.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML; //"ＣＳＶ ファイル (*.csv)|*.csv|すべてのファイル (*.*)|*.*"
                if (SaveFileDialog.ShowDialog(this) == DialogResult.OK)
                {
                    string csFileName = SaveFileDialog.FileName;    // 出力ファイルフルパス名

                    if (csFileName.Substring(csFileName.Length - 4, 4) != Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_XML)
                    {
                        csFileName += Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_XML;
                    }

                    FileName.Text = csFileName;            // テキスト表示

                    HySXmlWriter csXmlWriter = new HySXmlWriter(csFileName);

                    HySXmlNode csRootNode = csXmlWriter.CreateRoot("PropertyRoot");

                    // プロパティ出力指定
                    McPropertyInfoBase.SetXmlOutFlg(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL);

                    if (ModelPropertyDataGridView.Rows.Count > 0)
                    {
                        McPropertyInfo csXmlOutWorkInfo = new McPropertyInfo(m_csPropertyInfo.GetFactoryID(), (HySObjectKind)m_csPropertyInfo.GetModelKind());

                        HySString csKey = new HySString();
                        HySString csPropertyName = new HySString();
                        McDefine.ValKind lObjKind = new McDefine.ValKind();
                        bool bVal = new bool();
                        long lVal = new long();
                        double dVal = new double();
                        string sVal = "";

                        for (int iLp = 0; iLp < ModelPropertyDataGridView.Rows.Count; iLp++)
                        {
                            if (ModelPropertyDataGridView.Rows[iLp].Cells[2].Value != null)
                            {
                                csKey = new HySString(ModelPropertyDataGridView.Rows[iLp].Cells[2].Value.ToString());
                                if (((McPropertyInfo)m_csPropertyInfo).GetInfoType(csKey, ref csPropertyName, ref lObjKind) == true)
                                {
                                    csXmlOutWorkInfo.AddInfoType(csKey, csPropertyName, lObjKind);
                                    if (lObjKind == McDefine.ValKind.BOOL)
                                    {   // 論理型の場合
                                        bVal = bool.Parse(ModelPropertyDataGridView.Rows[iLp].Cells[1].Value.ToString());
                                        csXmlOutWorkInfo.SetInfo(csKey, bVal);
                                    }
                                    else if (lObjKind == McDefine.ValKind.DOUBLE)
                                    {   // 実数型の場合
                                        dVal = double.Parse(ModelPropertyDataGridView.Rows[iLp].Cells[1].Value.ToString());
                                        csXmlOutWorkInfo.SetInfo(csKey, dVal);
                                    }
                                    else if (lObjKind == McDefine.ValKind.LONG)
                                    {   // 倍精度整数型の場合
                                        lVal = long.Parse(ModelPropertyDataGridView.Rows[iLp].Cells[1].Value.ToString());
                                        csXmlOutWorkInfo.SetInfo(csKey, lVal);
                                    }
                                    else if (lObjKind == McDefine.ValKind.STRING)
                                    {   // 文字列型の場合
                                        sVal = ModelPropertyDataGridView.Rows[iLp].Cells[1].Value.ToString();
                                        csXmlOutWorkInfo.SetInfo(csKey, sVal);
                                    }
                                }
                            }
                        }
                        csRootNode.AppendChild(csXmlOutWorkInfo.XmlOUT(ref csXmlWriter));
                    }

                    if (ModelInitialDataGridView.Rows.Count > 0)
                    {
                        McInitialInfo csXmlOutWorkInfo = new McInitialInfo(m_csInitialInfo.GetFactoryID(), (HySObjectKind)m_csInitialInfo.GetModelKind());

                        HySString csKey = new HySString();
                        HySString csInitialName = new HySString();
                        McDefine.ValKind lObjKind = new McDefine.ValKind();
                        bool bVal = new bool();
                        long lVal = new long();
                        double dVal = new double();
                        string sVal = "";

                        for (int iLp = 0; iLp < ModelInitialDataGridView.Rows.Count; iLp++)
                        {
                            if (ModelInitialDataGridView.Rows[iLp].Cells[2].Value != null)
                            {
                                csKey = new HySString(ModelInitialDataGridView.Rows[iLp].Cells[2].Value.ToString());
                                if (((McPropertyInfo)m_csInitialInfo).GetInfoType(csKey, ref csInitialName, ref lObjKind) == true)
                                {
                                    csXmlOutWorkInfo.AddInfoType(csKey, csInitialName, lObjKind);
                                    if (lObjKind == McDefine.ValKind.BOOL)
                                    {   // 論理型の場合
                                        bVal = bool.Parse(ModelInitialDataGridView.Rows[iLp].Cells[1].Value.ToString());
                                        csXmlOutWorkInfo.SetInfo(csKey, bVal);
                                    }
                                    else if (lObjKind == McDefine.ValKind.DOUBLE)
                                    {   // 実数型の場合
                                        dVal = double.Parse(ModelInitialDataGridView.Rows[iLp].Cells[1].Value.ToString());
                                        csXmlOutWorkInfo.SetInfo(csKey, dVal);
                                    }
                                    else if (lObjKind == McDefine.ValKind.LONG)
                                    {   // 倍精度整数型の場合
                                        lVal = long.Parse(ModelInitialDataGridView.Rows[iLp].Cells[1].Value.ToString());
                                        csXmlOutWorkInfo.SetInfo(csKey, lVal);
                                    }
                                    else if (lObjKind == McDefine.ValKind.STRING)
                                    {   // 文字列型の場合
                                        sVal = ModelInitialDataGridView.Rows[iLp].Cells[1].Value.ToString();
                                        csXmlOutWorkInfo.SetInfo(csKey, sVal);
                                    }
                                }
                            }
                        }
                        csRootNode.AppendChild(csXmlOutWorkInfo.XmlOUT(ref csXmlWriter));
                    }

                    csXmlWriter.Save();
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeActive();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>非アクティブ時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeActiveEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeActiveEvent(object sender, EventArgs e)
        {
            ((HySDotNetScreen)m_csScreen).NoticeDeActive();
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODEL_0013,
                        ((HySDotNetViewer)((HySDotNetScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}