﻿// <summary>ソースコード：ＨＹＭＣＯ描画要素</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Drawing;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>描画要素クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/27][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    [Serializable]
    public class McGraphicsLineElement : McGraphicsElement
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphicsLineElement csElement = new McGraphicsLineElement()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphicsLineElement() : base(McDefine.SymbolDrawKind.HYM_LINE, new HySObjectKind())
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>描画要素端子追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRet = AddPort( csPort )</para>
        /// </example>
        /// <param name="csPort">描画要素端子</param>
        /// <returns>long  0:成功，-1:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long AddPort(McGraphicsElement csPort)
        {
            if (csPort == null)
            {// パラメータ異常
                return -1L;
            }

            m_csPortList.Add(csPort);

            return 0L;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定位置エレメント有無チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ElementPositionCheck(Position_x, Position_y, lDispScale, csCustomInfo)</para>
        /// </example>
        /// <param name="Position_x">チェック位置X</param>
        /// <param name="Position_y">チェック位置Y</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <returns>bool　true：指定位置該当　false：指定位置非該当</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ElementPositionCheck(int Position_x, int Position_y, long lDispScale, McCustomInfo csCustomInfo)
        {
            bool bRtnFlg = false;
            long lFromX = 0;
            long lFromY = 0;
            long lToX = 0;
            long lToY = 0;
            long lFromWidth = 0;
            long lFromHeight = 0;
            long lToWidth = 0;
            long lToHeight = 0;
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            GetPortID(ref csFromID, ref csToID);
            csFromPort = GetPort(csFromID);
            csToPort = GetPort(csToID);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McGraphicsTransElement)csFromPort).GetInnerPosition(ref lFromX, ref lFromY);
            }
            else
            {// 流入中継端子以外の場合
                csFromPort.GetPosition(ref lFromX, ref lFromY);
            }

            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                ((McGraphicsTransElement)csToPort).GetInnerPosition(ref lToX, ref lToY);
            }
            else
            {// 流出中継端子以外の場合
                csToPort.GetPosition(ref lToX, ref lToY);
            }
            csFromPort.GetElementSize(ref lFromWidth, ref lFromHeight);
            csToPort.GetElementSize(ref lToWidth, ref lToHeight);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lFromX, lFromY, ref lFromX, ref lFromY);
            }
            else
            {// 流入中継端子以外の場合
                McViewTransFormer.ViewTrans(csFromPort.GetSymbolDrawKind(), lFromHeight, csFromPort.GetRotate(), lDispScale, lFromX, lFromY, ref lFromX, ref lFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lToX, lToY, ref lToX, ref lToY);
            }
            else
            {// 流出中継端子以外の場合
                McViewTransFormer.ViewTrans(csToPort.GetSymbolDrawKind(), lToHeight, csToPort.GetRotate(), lDispScale, lToX, lToY, ref lToX, ref lToY);
            }

            int iOffset = 6 + csCustomInfo.GetDrawingThickness() / 2;

            //if (((lFromX - Position_x) * (lToX - Position_x) <= 0.0) &&
            //    ((lFromY - Position_y) * (lToY - Position_y) <= 0.0))
            if (((lFromX - Position_x) * (lToX - Position_x) <= iOffset) &&
                ((lFromY - Position_y) * (lToY - Position_y) <= iOffset))
            {
                double dX1 = (double)lToX - (double)lFromX;         //　辺ベクトル設定（Ｘ）
                double dY1 = (double)lToY - (double)lFromY;         //　辺ベクトル設定（Ｙ）
                double dRxy = Math.Sqrt(dX1 * dX1 + dY1 * dY1+0.00000000001); //　ベクトルの大きさを求める
                double dRx = dX1 / dRxy;                //　単位ベクトル（Ｘ）を求める
                double dRy = dY1 / dRxy;                //　単位ベクトル（Ｙ）を求める
                double dTx = -dRy;                  //　法線の単位ベクトル（Ｘ）を求める
                double dTy = dRx;                       //　法線の単位ベクトル（Ｙ）を求める

                double xAC = (double)Position_x - (double)lFromX;
                double yAC = (double)Position_y - (double)lFromY;

                double D = dTx * xAC + dTy * yAC;

                if (Math.Abs(D) <= iOffset)
                {// 指定位置該当の場合
                    bRtnFlg = true;
                }
            }
            /*
            if ((lFromX != lToX) && (lFromY != lToY))
            {// 斜めの場合
                if (((lFromX <= lToX && lFromX <= Position_x && Position_x <= lToX) ||
                     (lFromX > lToX && lToX <= Position_x && Position_x <= lFromX)) &&
                    ((lFromY <= lToY && lFromY <= Position_y && Position_y <= lToY) ||
                     (lFromY > lToY && lToY <= Position_y && Position_y <= lFromY)))
                {// 外接範囲内の場合

                    double dX1 = (double)lToX - (double)lFromX;         //　辺ベクトル設定（Ｘ）
                    double dY1 = (double)lToY - (double)lFromY;         //　辺ベクトル設定（Ｙ）
                    double dRxy = Math.Sqrt(dX1 * dX1 + dY1 * dY1); //　ベクトルの大きさを求める
                    double dRx = dX1 / dRxy;                //　単位ベクトル（Ｘ）を求める
                    double dRy = dY1 / dRxy;                //　単位ベクトル（Ｙ）を求める
                    double dTx = -dRy;                  //　法線の単位ベクトル（Ｘ）を求める
                    double dTy = dRx;                       //　法線の単位ベクトル（Ｙ）を求める

                    double xAC = (double)Position_x - (double)lFromX;
                    double yAC = (double)Position_y - (double)lFromY;

                    double D = dTx * xAC + dTy * yAC;

                    if (Math.Abs(D) <= iOffset)
                    {// 指定位置該当の場合
                        bRtnFlg = true;
                    }
                }
            }
            else
            {// 垂直または水平の場合
                if (lFromX == lToX)
                {// 垂直の場合
                    if (lFromY < lToY)
                    {// 始点が上の場合
                        if ((Position_x >= lFromX - iOffset) && (Position_y >= lFromY) &&
                            (Position_x <= lToX + iOffset) && (Position_y <= lToY))
                        {// 指定位置該当の場合
                            bRtnFlg = true;
                        }
                    }
                    else
                    {// 始点が下の場合
                        if ((Position_x >= lFromX - iOffset) && (Position_y >= lToY) &&
                            (Position_x <= lToX + iOffset) && (Position_y <= lFromY))
                        {// 指定位置該当の場合
                            bRtnFlg = true;
                        }
                    }
                }
                else
                {// 水平の場合
                    if (lFromX < lToX)
                    {// 始点が左の場合
                        if ((Position_x >= lFromX) && (Position_y >= lFromY - iOffset) &&
                            (Position_x <= lToX) && (Position_y <= lToY + iOffset))
                        {// 指定位置該当の場合
                            bRtnFlg = true;
                        }
                    }
                    else
                    {// 始点が右の場合
                        if ((Position_x >= lToX) && (Position_y >= lFromY - iOffset) &&
                            (Position_x <= lFromX) && (Position_y <= lToY + iOffset))
                        {// 指定位置該当の場合
                            bRtnFlg = true;
                        }
                    }
                }
            }
            */
            return bRtnFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定範囲該当チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SelectedRangeCheck(iFromX, iFromY, iToX, iToY, lDispScale)</para>
        /// </example>
        /// <param name="iFromX">指定範囲FromX</param>
        /// <param name="iFromY">指定範囲FromY</param>
        /// <param name="iToX">指定範囲ToX</param>
        /// <param name="iToY">指定範囲ToY</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <returns>bool　true：指定範囲該当　false：指定範囲非該当</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SelectedRangeCheck(int iFromX, int iFromY, int iToX, int iToY, long lDispScale)
        {
            bool bRtnFlg = false;
            long lElementFromX = 0;
            long lElementFromY = 0;
            long lElementToX = 0;
            long lElementToY = 0;
            long lTempXY = 0;
            long lFromWidth = 0;
            long lFromHeight = 0;
            long lToWidth = 0;
            long lToHeight = 0;
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            GetPortID(ref csFromID, ref csToID);
            csFromPort = GetPort(csFromID);
            csToPort = GetPort(csToID);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McGraphicsTransElement)csFromPort).GetInnerPosition(ref lElementFromX, ref lElementFromY);
            }
            else
            {// 流入中継端子以外の場合
                csFromPort.GetPosition(ref lElementFromX, ref lElementFromY);
            }

            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                ((McGraphicsTransElement)csToPort).GetInnerPosition(ref lElementToX, ref lElementToY);
            }
            else
            {// 流出中継端子以外の場合
                csToPort.GetPosition(ref lElementToX, ref lElementToY);
            }
            csFromPort.GetElementSize(ref lFromWidth, ref lFromHeight);
            csToPort.GetElementSize(ref lToWidth, ref lToHeight);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lElementFromX, lElementFromY, ref lElementFromX, ref lElementFromY);
            }
            else
            {// 流入中継端子以外の場合
                McViewTransFormer.ViewTrans(csFromPort.GetSymbolDrawKind(), lFromHeight, csFromPort.GetRotate(), lDispScale, lElementFromX, lElementFromY, ref lElementFromX, ref lElementFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lElementToX, lElementToY, ref lElementToX, ref lElementToY);
            }
            else
            {// 流出中継端子以外の場合
                McViewTransFormer.ViewTrans(csToPort.GetSymbolDrawKind(), lToHeight, csToPort.GetRotate(), lDispScale, lElementToX, lElementToY, ref lElementToX, ref lElementToY);
            }

            if (lElementFromX > lElementToX)
            {// 始点が左にある場合
                lTempXY = lElementFromX;
                lElementFromX = lElementToX;
                lElementToX = lTempXY;
            }
            if (lElementFromY > lElementToY)
            {// 始点が下にある場合
                lTempXY = lElementFromY;
                lElementFromY = lElementToY;
                lElementToY = lTempXY;
            }

            if ((iFromX <= lElementFromX) && (iFromY <= lElementFromY) && (iToX >= lElementToX) && (iToY >= lElementToY))
            {// 指定範囲内の場合
                bRtnFlg = true;
            }

            return bRtnFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>描画範囲該当チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bFlg = DrawCheck(iX, iY, iWidth, iHeight)</para>
        /// </example>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <returns>bool　true：描画範囲該当　false：描画範囲非該当</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool DrawCheck(int iX, int iY, int iWidth, int iHeight)
        {
            bool bRtnFlg = false;
            long lElementWidth = 0;
            long lElementHeight = 0;
            long lX = 0;
            long lY = 0;
            long lElementFromX = 0;
            long lElementFromY = 0;
            long lElementToX = 0;
            long lElementToY = 0;
            long lTempXY = 0;
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            GetPortID(ref csFromID, ref csToID);
            csFromPort = GetPort(csFromID);
            csToPort = GetPort(csToID);

            csFromPort.GetElementSize(ref lElementWidth, ref lElementHeight);
            csFromPort.GetPosition(ref lX, ref lY);
            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McGraphicsTransElement)csFromPort).GetInnerPosition(ref lX, ref lY);
            }
            lElementFromX = lX;
            lElementFromY = lY;

            csToPort.GetElementSize(ref lElementWidth, ref lElementHeight);
            csToPort.GetPosition(ref lX, ref lY);
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                ((McGraphicsTransElement)csToPort).GetInnerPosition(ref lX, ref lY);
            }
            lElementToX = lX;
            lElementToY = lY;

            if (lElementFromX > lElementToX)
            {// 始点が左にある場合
                lTempXY = lElementFromX;
                lElementFromX = lElementToX;
                lElementToX = lTempXY;
            }
            if (lElementFromY > lElementToY)
            {// 始点が下にある場合
                lTempXY = lElementFromY;
                lElementFromY = lElementToY;
                lElementToY = lTempXY;
            }

            if ((iX < lElementToX) && (iY < lElementToY) && (iX + iWidth > lElementFromX) && (iY + iHeight > lElementFromY))
            {// 描画範囲該当の場合
                bRtnFlg = true;
            }

            return bRtnFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObject(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void DrawObject(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight)
        {
            long lFromX = 0L;
            long lFromY = 0L;
            long lToX = 0L;
            long lToY = 0L;
            long lFromWidth = 0;
            long lFromHeight = 0;
            long lToWidth = 0;
            long lToHeight = 0;
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            if (false == DrawCheck(iX, iY, iWidth, iHeight))
            {// 描画範囲外の場合
                return;
            }

            GetPortID(ref csFromID, ref csToID);
            csFromPort = GetPort(csFromID);
            csToPort = GetPort(csToID);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McGraphicsTransElement)csFromPort).GetInnerPosition(ref lFromX, ref lFromY);
            }
            else
            {// 流入中継端子以外の場合
                csFromPort.GetPosition(ref lFromX, ref lFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                ((McGraphicsTransElement)csToPort).GetInnerPosition(ref lToX, ref lToY);
            }
            else
            {// 流出中継端子以外の場合
                csToPort.GetPosition(ref lToX, ref lToY);
            }
            csFromPort.GetElementSize(ref lFromWidth, ref lFromHeight);
            csToPort.GetElementSize(ref lToWidth, ref lToHeight);

            long lDispFromX = 0;
            long lDispFromY = 0;
            long lDispToX = 0;
            long lDispToY = 0;

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            else
            {// 流入中継端子以外の場合
                McViewTransFormer.ViewTrans(csFromPort.GetSymbolDrawKind(), lFromHeight, csFromPort.GetRotate(), lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }
            else
            {// 流出中継端子以外の場合
                McViewTransFormer.ViewTrans(csToPort.GetSymbolDrawKind(), lToHeight, csToPort.GetRotate(), lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }

            bool bModelFlg = false;
            if (this.GetModelInfo().GetLibraryID().ToString() != "")
            {// モデル設定ありの場合
                bModelFlg = true;
            }

            McDefine.SymbolDrawKind eDrawKind = GetSymbolDrawKind();
            HySObjectKind csDrawSubKind = GetDrawSubKind();
            int iColor = csCustomInfo.GetDrawingColor(eDrawKind, csDrawSubKind, bModelFlg, false);
            Pen csDrawPen = new Pen(ColorTranslator.FromWin32(iColor), (float)csCustomInfo.GetDrawingThickness());

            ((McLineSymbolDraw)m_csDrawObject).DrawObject(csGraphics, lDispFromX - iImageX, lDispFromY - iImageY, lDispToX - iImageX, lDispToY - iImageY, csDrawPen);

            csDrawPen.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクトID描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObjectID(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight, bIDMode)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <param name="bIDMode">IDモード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void DrawObjectID(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight, bool bIDMode)
        {
            long lFromX = 0L;
            long lFromY = 0L;
            long lToX = 0L;
            long lToY = 0L;
            long lFromWidth = 0;
            long lFromHeight = 0;
            long lToWidth = 0;
            long lToHeight = 0;
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            if (false == DrawCheck(iX, iY, iWidth, iHeight))
            {// 描画範囲外の場合
                return;
            }

            GetPortID(ref csFromID, ref csToID);
            csFromPort = GetPort(csFromID);
            csToPort = GetPort(csToID);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McGraphicsTransElement)csFromPort).GetInnerPosition(ref lFromX, ref lFromY);
            }
            else
            {// 流入中継端子以外の場合
                csFromPort.GetPosition(ref lFromX, ref lFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                ((McGraphicsTransElement)csToPort).GetInnerPosition(ref lToX, ref lToY);
            }
            else
            {// 流出中継端子以外の場合
                csToPort.GetPosition(ref lToX, ref lToY);
            }
            csFromPort.GetElementSize(ref lFromWidth, ref lFromHeight);
            csToPort.GetElementSize(ref lToWidth, ref lToHeight);

            long lDispFromX = 0;
            long lDispFromY = 0;
            long lDispToX = 0;
            long lDispToY = 0;

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            else
            {// 流入中継端子以外の場合
                McViewTransFormer.ViewTrans(csFromPort.GetSymbolDrawKind(), lFromHeight, csFromPort.GetRotate(), lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }
            else
            {// 流出中継端子以外の場合
                McViewTransFormer.ViewTrans(csToPort.GetSymbolDrawKind(), lToHeight, csToPort.GetRotate(), lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }

            HySString csString = (HySString)GetID().GetString();
            if (bIDMode == false)
            {// IDモードがショートモードの場合
                if (csString.ToString().IndexOf('-') != -1)
                {// 分割出来る場合
                    csString = new HySString(csString.ToString().Substring(0, csString.ToString().IndexOf('-')));
                }
                else
                {// 分割出来ない場合
                    if (csString.ToString().Length > USER_MAKE_ID_SHORT_LENGTH)
                    {// IDの長さが既定値以上の場合
                        csString = new HySString(csString.ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH));
                    }
                }
            }

            int iOffSetX = -csString.ToString().Length / 2 * 4 - 4;
            int iOffSetY = -10;

            Font csFont = new Font("ＭＳ ゴシック", 9F);
            int iColor = csCustomInfo.GetIDDrawingColor();
            Brush csDrawBrush = new SolidBrush(ColorTranslator.FromWin32(iColor));

            csGraphics.DrawString(csString.ToString(), csFont, csDrawBrush, (lDispFromX + lDispToX) / 2 + iOffSetX - iImageX, (lDispFromY + lDispToY) / 2 + iOffSetY - iImageY);

            csFont.Dispose();
            csDrawBrush.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト名称描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObjectName(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void DrawObjectName(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight)
        {
            long lFromX = 0L;
            long lFromY = 0L;
            long lToX = 0L;
            long lToY = 0L;
            long lFromWidth = 0;
            long lFromHeight = 0;
            long lToWidth = 0;
            long lToHeight = 0;
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            if (false == DrawCheck(iX, iY, iWidth, iHeight))
            {// 描画範囲外の場合
                return;
            }

            GetPortID(ref csFromID, ref csToID);
            csFromPort = GetPort(csFromID);
            csToPort = GetPort(csToID);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McGraphicsTransElement)csFromPort).GetInnerPosition(ref lFromX, ref lFromY);
            }
            else
            {// 流入中継端子以外の場合
                csFromPort.GetPosition(ref lFromX, ref lFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                ((McGraphicsTransElement)csToPort).GetInnerPosition(ref lToX, ref lToY);
            }
            else
            {// 流出中継端子以外の場合
                csToPort.GetPosition(ref lToX, ref lToY);
            }
            csFromPort.GetElementSize(ref lFromWidth, ref lFromHeight);
            csToPort.GetElementSize(ref lToWidth, ref lToHeight);

            long lDispFromX = 0;
            long lDispFromY = 0;
            long lDispToX = 0;
            long lDispToY = 0;

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            else
            {// 流入中継端子以外の場合
                McViewTransFormer.ViewTrans(csFromPort.GetSymbolDrawKind(), lFromHeight, csFromPort.GetRotate(), lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }
            else
            {// 流出中継端子以外の場合
                McViewTransFormer.ViewTrans(csToPort.GetSymbolDrawKind(), lToHeight, csToPort.GetRotate(), lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }

            HySString csString = (HySString)GetID().GetString();
            if (((object)GetElementName() != null) &&
                (GetElementName().GetLength() != 0))
            {// 名称設定がある場合
                csString = GetElementName();
            }

            int iOffSetX = -20;
            int iOffSetY = 0;

            Font csFont = new Font("ＭＳ ゴシック", 9F);
            int iColor = csCustomInfo.GetNameDrawingColor();
            Brush csDrawBrush = new SolidBrush(ColorTranslator.FromWin32(iColor));

            csGraphics.DrawString(csString.ToString(), csFont, csDrawBrush, (lDispFromX + lDispToX) / 2 + iOffSetX - iImageX, (lDispFromY + lDispToY) / 2 + iOffSetY - iImageY);

            csFont.Dispose();
            csDrawBrush.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>セレクトマーク描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SelectDraw(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SelectDraw(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight)
        {
            long lFromX = 0L;
            long lFromY = 0L;
            long lToX = 0L;
            long lToY = 0L;
            long lFromWidth = 0;
            long lFromHeight = 0;
            long lToWidth = 0;
            long lToHeight = 0;
            HySIdentifier csFromID = null;
            HySIdentifier csToID = null;
            McGraphicsElement csFromPort = null;
            McGraphicsElement csToPort = null;

            if (false == DrawCheck(iX, iY, iWidth, iHeight))
            {// 描画範囲外の場合
                return;
            }

            GetPortID(ref csFromID, ref csToID);
            csFromPort = GetPort(csFromID);
            csToPort = GetPort(csToID);

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McGraphicsTransElement)csFromPort).GetInnerPosition(ref lFromX, ref lFromY);
            }
            else
            {// 流入中継端子以外の場合
                csFromPort.GetPosition(ref lFromX, ref lFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                ((McGraphicsTransElement)csToPort).GetInnerPosition(ref lToX, ref lToY);
            }
            else
            {// 流出中継端子以外の場合
                csToPort.GetPosition(ref lToX, ref lToY);
            }
            csFromPort.GetElementSize(ref lFromWidth, ref lFromHeight);
            csToPort.GetElementSize(ref lToWidth, ref lToHeight);

            long lDispFromX = 0;
            long lDispFromY = 0;
            long lDispToX = 0;
            long lDispToY = 0;

            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            else
            {// 流入中継端子以外の場合
                McViewTransFormer.ViewTrans(csFromPort.GetSymbolDrawKind(), lFromHeight, csFromPort.GetRotate(), lDispScale, lFromX, lFromY, ref lDispFromX, ref lDispFromY);
            }
            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
            {// 流出中継端子の場合
                McViewTransFormer.ViewTrans(lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }
            else
            {// 流出中継端子以外の場合
                McViewTransFormer.ViewTrans(csToPort.GetSymbolDrawKind(), lToHeight, csToPort.GetRotate(), lDispScale, lToX, lToY, ref lDispToX, ref lDispToY);
            }

            bool bModelFlg = false;
            if (this.GetModelInfo().GetLibraryID().ToString() != "")
            {// モデル設定ありの場合
                bModelFlg = true;
            }

            int iColor = csCustomInfo.GetSelectDrawingColor(bModelFlg);
            Pen csDrawPen = new Pen(ColorTranslator.FromWin32(iColor), 1.0F);

            lDispFromX -= iImageX;
            lDispFromY -= iImageY;
            lDispToX -= iImageX;
            lDispToY -= iImageY;

            int iLineThickness = csCustomInfo.GetDrawingThickness() / 2;
            if (iLineThickness == 0)
            {// 仮想接続線太さが０の場合
                iLineThickness = 1;
            }

            if (lDispFromX > lDispToX)
            {// 始点が右の場合
                if (lDispFromY > lDispToY)
                {// 始点が下の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX + iLineThickness, lDispFromY - iLineThickness, lDispToX + iLineThickness, lDispToY - iLineThickness);
                    csGraphics.DrawLine(csDrawPen, lDispFromX - iLineThickness, lDispFromY + iLineThickness, lDispToX - iLineThickness, lDispToY + iLineThickness);
                }
                else if (lDispFromY < lDispToY)
                {// 始点が上の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX - iLineThickness, lDispFromY - iLineThickness, lDispToX - iLineThickness, lDispToY - iLineThickness);
                    csGraphics.DrawLine(csDrawPen, lDispFromX + iLineThickness, lDispFromY + iLineThickness, lDispToX + iLineThickness, lDispToY + iLineThickness);
                }
                else
                {// 水平の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX, lDispFromY - iLineThickness, lDispToX, lDispToY - iLineThickness);
                    csGraphics.DrawLine(csDrawPen, lDispFromX, lDispFromY + iLineThickness, lDispToX, lDispToY + iLineThickness);
                }
            }
            else if (lDispFromX < lDispToX)
            {// 始点が左の場合
                if (lDispFromY < lDispToY)
                {// 始点が上の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX + iLineThickness, lDispFromY - iLineThickness, lDispToX + iLineThickness, lDispToY - iLineThickness);
                    csGraphics.DrawLine(csDrawPen, lDispFromX - iLineThickness, lDispFromY + iLineThickness, lDispToX - iLineThickness, lDispToY + iLineThickness);
                }
                else if (lDispFromY > lDispToY)
                {// 始点が下の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX - iLineThickness, lDispFromY - iLineThickness, lDispToX - iLineThickness, lDispToY - iLineThickness);
                    csGraphics.DrawLine(csDrawPen, lDispFromX + iLineThickness, lDispFromY + iLineThickness, lDispToX + iLineThickness, lDispToY + iLineThickness);
                }
                else
                {// 水平の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX, lDispFromY - iLineThickness, lDispToX, lDispToY - iLineThickness);
                    csGraphics.DrawLine(csDrawPen, lDispFromX, lDispFromY + iLineThickness, lDispToX, lDispToY + iLineThickness);
                }
            }
            else
            {// 垂直の場合
                if (lDispFromY != lDispToY)
                {// 水平以外の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX - iLineThickness, lDispFromY, lDispToX - iLineThickness, lDispToY);
                    csGraphics.DrawLine(csDrawPen, lDispFromX + iLineThickness, lDispFromY, lDispToX + iLineThickness, lDispToY);
                }
                else
                {// 水平の場合
                    csGraphics.DrawLine(csDrawPen, lDispFromX, lDispFromY, lDispToX, lDispToY);
                    csGraphics.DrawLine(csDrawPen, lDispFromX, lDispFromY, lDispToX, lDispToY);
                }
            }

            csDrawPen.Dispose();
        }


        // ================================================
        //   Undo/Redo用処理
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphicsElement csElement = CopyInfUsedByUndoRedoOnly(csCopyElement)</para>
        /// </example>
        /// <param name="csCopyElement">複製要素</param>
        /// <returns>McGraphicsElement 複製要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McGraphicsElement CopyInfUsedByUndoRedoOnly(McGraphicsElement csCopyElement)
        {
            if (csCopyElement == null)
            {// 複製要素がない場合
                csCopyElement = new McGraphicsLineElement();
            }

            base.CopyInfUsedByUndoRedoOnly(csCopyElement);

            return csCopyElement;
        }
    }
}
