﻿// <summary>ソースコード：ＨＹＭＣＯ描画端子</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Drawing;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>描画中継端子クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/27][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    [Serializable]
    public class McGraphicsTransElement : McGraphicsElement
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphicsTransElement csElement = new McGraphicsTransElement(eKind)</para>
        /// </example>
        /// <param name="eKind">シンボル描画種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphicsTransElement(McDefine.SymbolDrawKind eKind)
            : base(eKind, new HySObjectKind())
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>中継情報用ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTransID(csFromID,csToID)</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTransID(HySIdentifier csFromID, HySIdentifier csToID)
        {
            if (m_csViewerPort != null)
            {// 端子の場合
                ((McStructTransPort)m_csViewerPort).SetInnerPortID(csFromID, csToID);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>中継情報用ID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetTransID(ref csFromID, ref csToID)</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetTransID(ref HySIdentifier csFromID, ref HySIdentifier csToID)
        {
            if (m_csViewerPort != null)
            {// 端子の場合
                ((McStructTransPort)m_csViewerPort).GetInnerPortID(ref csFromID, ref csToID);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>描画位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetInnerPosition( lX, lY )</para>
        /// </example>
        /// <param name="lX">描画位置(X)</param>
        /// <param name="lY">描画位置(Y)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetInnerPosition(long lX, long lY)
        {
            if (m_csViewerPort != null)
            {// 端子の場合
                ((McStructTransPort)m_csViewerPort).SetInnerPosition(lX, lY);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>描画位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetInnerPosition(ref lX, ref lY)</para>
        /// </example>
        /// <param name="lX">描画位置(X)</param>
        /// <param name="lY">描画位置(Y)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetInnerPosition(ref long lX, ref long lY)
        {
            if (m_csViewerPort != null)
            {// 端子の場合
                ((McStructTransPort)m_csViewerPort).GetInnerPosition(ref lX, ref lY);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>指定位置エレメント有無チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ElementPositionCheck(Position_x, Position_y, lDispScale, bInnerFlg)</para>
        /// </example>
        /// <param name="Position_x">チェック位置X</param>
        /// <param name="Position_y">チェック位置Y</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>bool　true：指定位置該当　false：指定位置非該当</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool ElementPositionCheck(int Position_x, int Position_y, long lDispScale, bool bInnerFlg)
        {
            bool bRtnFlg = false;
            int iWidth = 0;
            int iHeight = 0;

            long lX = 0;
            long lY = 0;
            long lDispX = 0;
            long lDispY = 0;
            long lWidth = 0;
            long lHeight = 0;

            GetPosition(ref lX, ref lY);

            McDefine.SymbolDrawKind eDrawKind = GetSymbolDrawKind();
            GetElementSize(ref lWidth, ref lHeight);
            double dRotate = GetRotate();
            McViewTransFormer.ViewTrans(eDrawKind, lHeight, dRotate, lDispScale, lX, lY, ref lDispX, ref lDispY);

            if (bInnerFlg == true)
            {// グループ内の場合
                lX = 0;
                lY = 0;

                GetInnerPosition(ref lX, ref lY);

                McViewTransFormer.ViewTrans(lDispScale, lX, lY, ref lDispX, ref lDispY);
            }

            if ((dRotate % McDefine.HYM_DRAW_ANGLE_180) == 0.0)
            {// 向きが縦の場合
                iWidth = (int)lWidth;
                iHeight = (int)lHeight;
            }
            else
            {// 向きが横の場合
                iWidth = (int)lHeight;
                iHeight = (int)lWidth;
            }

            if ((Position_x >= lDispX - iWidth / 2) && (Position_y >= lDispY - iHeight / 2) &&
                (Position_x <= lDispX + iWidth / 2) && (Position_y <= lDispY + iHeight / 2))
            {// 指定位置該当の場合
                bRtnFlg = true;
            }

            return bRtnFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定範囲該当チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SelectedRangeCheck(iFromX, iFromY, iToX, iToY, lDispScale, bInnerFlg)</para>
        /// </example>
        /// <param name="iFromX">指定範囲FromX</param>
        /// <param name="iFromY">指定範囲FromY</param>
        /// <param name="iToX">指定範囲ToX</param>
        /// <param name="iToY">指定範囲ToY</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>bool　true：指定範囲該当　false：指定範囲非該当</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool SelectedRangeCheck(int iFromX, int iFromY, int iToX, int iToY, long lDispScale, bool bInnerFlg)
        {
            bool bRtnFlg = false;
            int iWidth = 0;
            int iHeight = 0;

            long lX = 0;
            long lY = 0;
            long lDispX = 0;
            long lDispY = 0;
            long lWidth = 0;
            long lHeight = 0;

            GetPosition(ref lX, ref lY);

            McDefine.SymbolDrawKind eDrawKind = GetSymbolDrawKind();
            GetElementSize(ref lWidth, ref lHeight);
            double dRotate = GetRotate();
            McViewTransFormer.ViewTrans(eDrawKind, lHeight, dRotate, lDispScale, lX, lY, ref lDispX, ref lDispY);

            if (bInnerFlg == true)
            {// グループ内の場合
                lX = 0;
                lY = 0;

                GetInnerPosition(ref lX, ref lY);

                McViewTransFormer.ViewTrans(lDispScale, lX, lY, ref lDispX, ref lDispY);
            }

            if ((dRotate % McDefine.HYM_DRAW_ANGLE_180) == 0.0)
            {// 向きが縦の場合
                iWidth = (int)lWidth;
                iHeight = (int)lWidth;
            }
            else
            {// 向きが横の場合
                iWidth = (int)lWidth;
                iHeight = (int)lWidth;
            }

            if ((iFromX <= lDispX - iWidth / 2) && (iFromY <= lDispY - iHeight / 2) &&
                (iToX >= lDispX + iWidth / 2) && (iToY >= lDispY + iHeight / 2))
            {// 指定範囲内の場合
                bRtnFlg = true;
            }

            return bRtnFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>描画範囲該当チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bFlg = DrawCheck(iX, iY, iWidth, iHeight, bInnerFlg)</para>
        /// </example>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>bool　true：描画範囲該当　false：描画範囲非該当</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool DrawCheck(int iX, int iY, int iWidth, int iHeight, bool bInnerFlg)
        {
            bool bRtnFlg = false;
            int iElementWidth = 0;
            int iElementHeight = 0;

            long lX = 0;
            long lY = 0;
            long lDispX = 0;
            long lDispY = 0;
            long lWidth = 0;
            long lHeight = 0;

            GetPosition(ref lX, ref lY);

            if (bInnerFlg == true)
            {// グループ内の場合
                lX = 0;
                lY = 0;

                GetInnerPosition(ref lX, ref lY);
            }
            lDispX = lX;
            lDispY = lY;

            double dRotate = GetRotate();
            GetElementSize(ref lWidth, ref lHeight);
            if ((dRotate % McDefine.HYM_DRAW_ANGLE_180) == 0.0)
            {// 向きが縦の場合
                iElementWidth = (int)lWidth;
                iElementHeight = (int)lHeight;
            }
            else
            {// 向きが横の場合
                iElementWidth = (int)lHeight;
                iElementHeight = (int)lWidth;
            }

            if ((iX < lDispX + iElementWidth / 2) && (iY < lDispY + iElementHeight / 2) &&
                (iX + iWidth > lDispX - iElementWidth / 2) && (iY + iHeight > lDispY - iElementHeight / 2))
            {// 描画範囲該当の場合
                bRtnFlg = true;
            }

            return bRtnFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObject(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight, bInnerFlg)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawObject(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight, bool bInnerFlg)
        {
            if (false == DrawCheck(iX, iY, iWidth, iHeight, bInnerFlg))
            {// 描画範囲外の場合
                return;
            }

            long lX = 0;
            long lY = 0;
            long lDispX = 0;
            long lDispY = 0;
            long lWidth = 0;
            long lHeight = 0;

            GetPosition(ref lX, ref lY);

            McDefine.SymbolDrawKind eDrawKind = GetSymbolDrawKind();
            GetElementSize(ref lWidth, ref lHeight);
            double dRotate = GetRotate();
            McViewTransFormer.ViewTrans(eDrawKind, lHeight, dRotate, lDispScale, lX, lY, ref lDispX, ref lDispY);

            if (bInnerFlg == true)
            {// グループ内の場合
                lX = 0;
                lY = 0;

                GetInnerPosition(ref lX, ref lY);

                McViewTransFormer.ViewTrans(lDispScale, lX, lY, ref lDispX, ref lDispY);
            }

            int iElementWidth = (int)lWidth;
            int iElementHeight = (int)lHeight;

            bool bModelFlg = false;
            if (this.GetModelInfo().GetLibraryID().ToString() != "")
            {// モデル設定ありの場合
                bModelFlg = true;
            }

            HySObjectKind csDrawSubKind = GetDrawSubKind();
            int iColor = csCustomInfo.GetDrawingColor(eDrawKind, csDrawSubKind, bModelFlg, bInnerFlg);
            Brush csDrawBrush = new SolidBrush(ColorTranslator.FromWin32(iColor));

            // 自身の描画
            if (eDrawKind == McDefine.SymbolDrawKind.HYM_TRANS_IN)
            {// 流入中継端子の場合
                ((McTransSymbolDraw)m_csDrawObject).DrawObject(csGraphics, lDispX - iImageX, lDispY - iImageY, iElementWidth, iElementHeight, dRotate, csDrawBrush, true, bInnerFlg);
            }
            else
            {// 流入中継端子以外の場合
                ((McTransSymbolDraw)m_csDrawObject).DrawObject(csGraphics, lDispX - iImageX, lDispY - iImageY, iElementWidth, iElementHeight, dRotate, csDrawBrush, false, bInnerFlg);
            }

            csDrawBrush.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>セレクトマーク描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SelectDraw(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight, bInnerFlg)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SelectDraw(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight, bool bInnerFlg)
        {
            if (false == DrawCheck(iX, iY, iWidth, iHeight, bInnerFlg))
            {// 描画範囲外の場合
                return;
            }

            long lX = 0;
            long lY = 0;
            long lDispX = 0;
            long lDispY = 0;
            long lWidth = 0;
            long lHeight = 0;

            GetPosition(ref lX, ref  lY);

            McDefine.SymbolDrawKind eDrawKind = GetSymbolDrawKind();
            GetElementSize(ref lWidth, ref lHeight);
            double dRotate = GetRotate();
            McViewTransFormer.ViewTrans(eDrawKind, lHeight, dRotate, lDispScale, lX, lY, ref lDispX, ref lDispY);

            if (bInnerFlg == true)
            {// グループ内の場合
                lX = 0;
                lY = 0;

                GetInnerPosition(ref lX, ref lY);

                McViewTransFormer.ViewTrans(lDispScale, lX, lY, ref lDispX, ref lDispY);
            }

            int iElementWidth = 0;
            int iElementHeight = 0;

            if ((dRotate % McDefine.HYM_DRAW_ANGLE_180) == 0.0)
            {// 向きが縦の場合
                iElementWidth = (int)lWidth;
                iElementHeight = (int)lHeight;
            }
            else
            {// 向きが横の場合
                iElementWidth = (int)lHeight;
                iElementHeight = (int)lWidth;
            }

            iElementWidth += 2;
            iElementHeight += 2;

            int iColor = csCustomInfo.GetSelectDrawingColor(true);
            Pen csDrawPen = new Pen(ColorTranslator.FromWin32(iColor), 1.0F);

            csGraphics.DrawRectangle(csDrawPen, lDispX - iElementWidth / 2 - iImageX, lDispY - iElementHeight / 2 - iImageY, iElementWidth / 2 * 2, iElementHeight / 2 * 2);

            csDrawPen.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクトID描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObjectID(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight, bIDMode, bInnerFlg)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <param name="bIDMode">IDモード</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawObjectID(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight, bool bIDMode, bool bInnerFlg)
        {
            if (false == DrawCheck(iX, iY, iWidth, iHeight, bInnerFlg))
            {// 描画範囲外の場合
                return;
            }

            long lX = 0;
            long lY = 0;
            long lDispX = 0;
            long lDispY = 0;
            long lWidth = 0;
            long lHeight = 0;

            GetPosition(ref lX, ref  lY);

            McDefine.SymbolDrawKind eDrawKind = GetSymbolDrawKind();
            GetElementSize(ref lWidth, ref lHeight);
            double dRotate = GetRotate();
            McViewTransFormer.ViewTrans(eDrawKind, lHeight, dRotate, lDispScale, lX, lY, ref lDispX, ref lDispY);

            if (bInnerFlg == true)
            {// グループ内の場合
                lX = 0;
                lY = 0;

                GetInnerPosition(ref lX, ref lY);

                McViewTransFormer.ViewTrans(lDispScale, lX, lY, ref lDispX, ref lDispY);
            }

            HySString csString = (HySString)GetID().GetString();
            if (bIDMode == false)
            {// IDモードがショートモードの場合
                if (csString.ToString().IndexOf('-') != -1)
                {// 分割出来る場合
                    csString = new HySString(csString.ToString().Substring(0, csString.ToString().IndexOf('-')));
                }
                else
                {// 分割出来ない場合
                    if (csString.ToString().Length > USER_MAKE_ID_SHORT_LENGTH)
                    {// IDの長さが既定値以上の場合
                        csString = new HySString(csString.ToString().Substring(0, USER_MAKE_ID_SHORT_LENGTH));
                    }
                }
            }

            Font csFont = new Font("ＭＳ ゴシック", 9F);
            int iOffSetX = 0;
            int iOffSetY = 0;

            if ((dRotate == McDefine.HYM_DRAW_ANGLE_0) ||
                (dRotate == McDefine.HYM_DRAW_ANGLE_90))
            {// 向きが上または右の場合
                iOffSetX = 5;
                iOffSetY = -15;
            }
            else if (dRotate == McDefine.HYM_DRAW_ANGLE_180)
            {// 向きが下の場合
                iOffSetX = 5;
                iOffSetY = 5;
            }
            else if (dRotate == McDefine.HYM_DRAW_ANGLE_270)
            {// 向きが左の場合
                iOffSetX = -15;
                iOffSetY = -15;
            }

            int iColor = csCustomInfo.GetIDDrawingColor();
            Brush csDrawBrush = new SolidBrush(ColorTranslator.FromWin32(iColor));

            csGraphics.DrawString(csString.ToString(), csFont, csDrawBrush, lDispX + iOffSetX - iImageX, lDispY + iOffSetY - iImageY);

            csFont.Dispose();
            csDrawBrush.Dispose();
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト名称描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObjectName(csGraphics, csCustomInfo, lDispScale, iImageX, iImageY, iX, iY, iWidth, iHeight, bInnerFlg)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="csCustomInfo">モデル編集画面カスタマイズ情報</param>
        /// <param name="lDispScale">画面表示拡大率</param>
        /// <param name="iImageX">画面表示座標X</param>
        /// <param name="iImageY">画面表示座標Y</param>
        /// <param name="iX">描画始点座標X</param>
        /// <param name="iY">描画始点座標Y</param>
        /// <param name="iWidth">編集領域（幅）</param>
        /// <param name="iHeight">編集領域（高さ）</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawObjectName(Graphics csGraphics, McCustomInfo csCustomInfo, long lDispScale, int iImageX, int iImageY, int iX, int iY, int iWidth, int iHeight, bool bInnerFlg)
        {
            if (false == DrawCheck(iX, iY, iWidth, iHeight, bInnerFlg))
            {// 描画範囲外の場合
                return;
            }

            long lX = 0;
            long lY = 0;
            long lDispX = 0;
            long lDispY = 0;
            long lWidth = 0;
            long lHeight = 0;

            GetPosition(ref lX, ref lY);

            McDefine.SymbolDrawKind eDrawKind = GetSymbolDrawKind();
            GetElementSize(ref lWidth, ref lHeight);
            double dRotate = GetRotate();
            McViewTransFormer.ViewTrans(eDrawKind, lHeight, dRotate, lDispScale, lX, lY, ref lDispX, ref lDispY);

            if (bInnerFlg == true)
            {// グループ内の場合
                lX = 0;
                lY = 0;

                GetInnerPosition(ref lX, ref lY);

                McViewTransFormer.ViewTrans(lDispScale, lX, lY, ref lDispX, ref lDispY);
            }

            HySString csString = new HySString();
            if (((object)GetElementName() != null) &&
                (GetElementName().GetLength() != 0))
            {// 名称設定がある場合
                csString = GetElementName();
            }

            Font csFont = new Font("ＭＳ ゴシック", 9F);
            int iOffSetX = -20;
            int iOffSetY = 0;

            int iColor = csCustomInfo.GetNameDrawingColor();
            Brush csDrawBrush = new SolidBrush(ColorTranslator.FromWin32(iColor));

            csGraphics.DrawString(csString.ToString(), csFont, csDrawBrush, lDispX + iOffSetX - iImageX, lDispY + iOffSetY - iImageY);

            csFont.Dispose();
            csDrawBrush.Dispose();
        }


        // ================================================
        //   Undo/Redo用処理
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphicsElement csElement = CopyInfUsedByUndoRedoOnly(csCopyElement)</para>
        /// </example>
        /// <param name="csCopyElement">複製要素</param>
        /// <returns>McGraphicsElement 複製要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McGraphicsElement CopyInfUsedByUndoRedoOnly(McGraphicsElement csCopyElement)
        {
            if (csCopyElement == null)
            {// 複製要素がない場合
                csCopyElement = new McGraphicsTransElement(GetSymbolDrawKind());
            }

            base.CopyInfUsedByUndoRedoOnly(csCopyElement);

            return csCopyElement;
        }
    }
}
