﻿// <summary>ソースコード：ＨＹＭＣＯ合流シンボル描画</summary>
// <author>CommonMP</author>

using System;
using System.Drawing;
using System.Drawing.Drawing2D;     // エイリアスの作成
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>合流シンボル描画クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/08][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    [Serializable]
    public class McJunctionSymbolDraw : McSymbolDraw
    {
        /// <summary>幅デフォルト値</summary>
        private static readonly long OBJECT_DEFAULT_SIZE_WIDTH = 15;
        /// <summary>高さデフォルト値</summary>
        private static readonly long OBJECT_DEFAULT_SIZE_HEIGHT = 15;
        /// <summary>デフォルト名称 「データマージ要素」</summary>
        private static readonly HySString OBJECT_DEFAULT_NAME = new HySString(Properties.McDotNetViewerResources.OBJECT_DEFAULT_NAME_MERGE);

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(幅)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultWidth</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long DefaultWidth
        {
            get
            {
                return OBJECT_DEFAULT_SIZE_WIDTH;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(高さ)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultHeight</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long DefaultHeight
        {
            get
            {
                return OBJECT_DEFAULT_SIZE_HEIGHT;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素デフォルト名称</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySString DefaultName</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySString DefaultName
        {
            get
            {
                return OBJECT_DEFAULT_NAME;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McJunctionSymbolDraw csSymbol = new McJunctionSymbolDraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McJunctionSymbolDraw()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObject(csGraphics,lDispX,lDispY,iWidth,iHeight,dRotate,csDrawBrush,csIconPath)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="lDispX">位置(X)</param>
        /// <param name="lDispY">位置(Y)</param>
        /// <param name="iWidth">要素サイズ(幅)</param>
        /// <param name="iHeight">要素サイズ(高さ)</param>
        /// <param name="dRotate">位置(回転)</param>
        /// <param name="csDrawBrush">描画色</param>
        /// <param name="csIconPath">アイコンファイルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void DrawObject(Graphics csGraphics, long lDispX, long lDispY, int iWidth, int iHeight, double dRotate, Brush csDrawBrush, HySString csIconPath)
        {
            csGraphics.FillEllipse(csDrawBrush, (int)lDispX - iWidth / 2, (int)lDispY - iHeight / 2, iWidth, iHeight);
            csGraphics.DrawEllipse(Pens.Black, (int)lDispX - iWidth / 2, (int)lDispY - iHeight / 2, iWidth, iHeight);

            Icon csIcon = new Icon(csIconPath.ToString());
            int iW;
            int iH;
            int iX;
            int iY;
            if ((dRotate == 0) || (dRotate == 180))
            {// 向きが上下の場合
                iW = iWidth * 2 / 5;
                iH = iHeight * 4 / 5;
            }
            else
            {// 向きが左右の場合
                iW = iHeight * 2 / 5;
                iH = iWidth * 4 / 5;
            }
            iX = (int)lDispX - iW / 2;
            iY = (int)lDispY - iH / 2;
            Rectangle csrect = new Rectangle(iX, iY, iW, iH);
            csGraphics.DrawIcon(csIcon, csrect);

            csIcon.Dispose();
        }
    }
}
