﻿// <summary>ソースコード：ＨＹＭＣＯ受信端子シンボル描画</summary>
// <author>CommonMP</author>

using System;
using System.Drawing;
using System.Drawing.Drawing2D;     // エイリアスの作成
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>受信端子シンボル描画クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    [Serializable]
    public class McReceiveSymbolDraw : McSymbolDraw
    {
        /// <summary>幅デフォルト値</summary>
        private static readonly long OBJECT_DEFAULT_SIZE_WIDTH = 10;
        /// <summary>高さデフォルト値</summary>
        private static readonly long OBJECT_DEFAULT_SIZE_HEIGHT = 10;
        /// <summary>デフォルト名称</summary>
        private static readonly HySString OBJECT_DEFAULT_NAME = new HySString("");

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(幅)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultWidth</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long DefaultWidth
        {
            get
            {
                return OBJECT_DEFAULT_SIZE_WIDTH;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(高さ)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultHeight</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long DefaultHeight
        {
            get
            {
                return OBJECT_DEFAULT_SIZE_HEIGHT;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素デフォルト名称</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySString DefaultName</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySString DefaultName
        {
            get
            {
                return OBJECT_DEFAULT_NAME;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McReceiveSymbolDraw csSymbol = new McReceiveSymbolDraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McReceiveSymbolDraw()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObject(csGraphics,lDispX,lDispY,iWidth,iHeight,dRotate,csDrawBrush,csIconPath)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="lDispX">位置(X)</param>
        /// <param name="lDispY">位置(Y)</param>
        /// <param name="iWidth">要素サイズ(幅)</param>
        /// <param name="iHeight">要素サイズ(高さ)</param>
        /// <param name="dRotate">位置(回転)</param>
        /// <param name="csDrawBrush">描画色</param>
        /// <param name="csIconPath">アイコンファイルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void DrawObject(Graphics csGraphics, long lDispX, long lDispY, int iWidth, int iHeight, double dRotate, Brush csDrawBrush, HySString csIconPath)
        {
            Point[] pPolygon = new Point[5];    // 配置グラフィックス座標
            Point pOriginPoint = new Point();   // 原点座標
            Matrix mMatrix1 = new Matrix();     // 変換マトリックス1
            Matrix mMatrix2 = new Matrix();     // 変換マトリックス2

            pPolygon[0].X = (int)lDispX;
            pPolygon[0].Y = (int)lDispY;
            pPolygon[1].X = (int)lDispX + iWidth / 2;
            pPolygon[1].Y = (int)lDispY - iHeight / 2;
            pPolygon[2].X = (int)lDispX + iWidth / 2;
            pPolygon[2].Y = (int)lDispY + iHeight / 2;
            pPolygon[3].X = (int)lDispX - iWidth / 2;
            pPolygon[3].Y = (int)lDispY + iHeight / 2;
            pPolygon[4].X = (int)lDispX - iWidth / 2;
            pPolygon[4].Y = (int)lDispY - iHeight / 2;

            // 回転
            if (dRotate != 0)
            {// 向きが上以外の場合
                pOriginPoint.X = (int)lDispX;
                pOriginPoint.Y = (int)lDispY;
                mMatrix1.Translate(-pOriginPoint.X, -pOriginPoint.Y, MatrixOrder.Append);   // 平行移動マトリックスの取得
                mMatrix1.Rotate((float)dRotate, MatrixOrder.Append);                        // 回転マトリックスの取得
                mMatrix1.TransformPoints(pPolygon);                                         // 座標の変換
                mMatrix2.Translate(pOriginPoint.X, pOriginPoint.Y, MatrixOrder.Append);     // 平行移動マトリックスの取得
                mMatrix2.TransformPoints(pPolygon);                                         // 座標の変換
            }

            csGraphics.FillPolygon(csDrawBrush, pPolygon);
            csGraphics.DrawPolygon(Pens.Black, pPolygon);

            mMatrix1.Dispose();
            mMatrix2.Dispose();
        }
    }
}
