﻿// <summary>ソースコード：ＨＹＭＣＯシンボル描画</summary>
// <author>CommonMP</author>

using System;
using System.Drawing;
using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;


namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>シンボル描画クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// <para>本クラスの派生クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public abstract class McSymbolDraw : HySRoot
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(幅)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultWidth</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract long DefaultWidth { get; }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(高さ)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultHeight</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract long DefaultHeight { get; }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素デフォルト名称</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySString DefaultName</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySString DefaultName { get; }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObject(csGraphics,lDispX,lDispY,iWidth,iHeight,dRotate,csDrawBrush,csIconPath)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="lDispX">位置(X)</param>
        /// <param name="lDispY">位置(Y)</param>
        /// <param name="iWidth">要素サイズ(幅)</param>
        /// <param name="iHeight">要素サイズ(高さ)</param>
        /// <param name="dRotate">位置(回転)</param>
        /// <param name="csDrawBrush">描画色</param>
        /// <param name="csIconPath">アイコンファイルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public void DrawObject(Graphics csGraphics, long lDispX, long lDispY, int iWidth, int iHeight, double dRotate, Brush csDrawBrush, HySString csIconPath);
    }
}
