﻿// <summary>ソースコード：ＨＹＭＣＯ中継端子シンボル描画</summary>
// <author>CommonMP</author>

using System;
using System.Drawing;
using System.Drawing.Drawing2D;     // エイリアスの作成
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>中継端子シンボル描画クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスはバージョンアップ互換性の対象外</para>
    /// </remarks>
    [Serializable]
    public class McTransSymbolDraw : McSymbolDraw
    {
        /// <summary>幅デフォルト値</summary>
        private static readonly long OBJECT_DEFAULT_SIZE_WIDTH = 10;
        /// <summary>高さデフォルト値</summary>
        private static readonly long OBJECT_DEFAULT_SIZE_HEIGHT = 10;
        /// <summary>デフォルト名称</summary>
        private static readonly HySString OBJECT_DEFAULT_NAME = new HySString("");

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(幅)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultWidth</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long DefaultWidth
        {
            get
            {
                return OBJECT_DEFAULT_SIZE_WIDTH;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素サイズ(高さ)デフォルト値</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long DefaultHeight</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long DefaultHeight
        {
            get
            {
                return OBJECT_DEFAULT_SIZE_HEIGHT;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素デフォルト名称</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySString DefaultName</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySString DefaultName
        {
            get
            {
                return OBJECT_DEFAULT_NAME;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McTransSymbolDraw csSymbol = new McTransSymbolDraw()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTransSymbolDraw()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObject(csGraphics,lDispX,lDispY,iWidth,iHeight,dRotate,csDrawBrush,csIconPath)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="lDispX">位置(X)</param>
        /// <param name="lDispY">位置(Y)</param>
        /// <param name="iWidth">要素サイズ(幅)</param>
        /// <param name="iHeight">要素サイズ(高さ)</param>
        /// <param name="dRotate">位置(回転)</param>
        /// <param name="csDrawBrush">描画色</param>
        /// <param name="csIconPath">アイコンファイルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void DrawObject(Graphics csGraphics, long lDispX, long lDispY, int iWidth, int iHeight, double dRotate, Brush csDrawBrush, HySString csIconPath)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawObject(csGraphics,lDispX,lDispY,iWidth,iHeight,dRotate,csDrawBrush,bInOutFlg,bInnerFlg)</para>
        /// </example>
        /// <param name="csGraphics">グラフィックス</param>
        /// <param name="lDispX">位置(X)</param>
        /// <param name="lDispY">位置(Y)</param>
        /// <param name="iWidth">要素サイズ(幅)</param>
        /// <param name="iHeight">要素サイズ(高さ)</param>
        /// <param name="dRotate">位置(回転)</param>
        /// <param name="csDrawBrush">描画色</param>
        /// <param name="bInOutFlg">入力／出力</param>
        /// <param name="bInnerFlg">グループ内中継端子指定　true:グループ内　false:グループ外</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawObject(Graphics csGraphics, long lDispX, long lDispY, int iWidth, int iHeight, double dRotate, Brush csDrawBrush, bool bInOutFlg, bool bInnerFlg)
        {
            Point[] pPolygon1 = new Point[5];  // 配置グラフィックス座標
            Point[] pPolygon2 = new Point[2];  // 配置グラフィックス座標
            Point pOriginPoint = new Point();  // 原点座標
            Matrix mMatrix1 = new Matrix();    // 変換マトリックス1
            Matrix mMatrix2 = new Matrix();    // 変換マトリックス2
            Matrix mMatrix3 = new Matrix();    // 変換マトリックス3
            Matrix mMatrix4 = new Matrix();    // 変換マトリックス4

            if (bInOutFlg == true)
            {// 入力の場合
                if (bInnerFlg == true)
                {// グループ内側の場合
                    csGraphics.FillEllipse(csDrawBrush, lDispX - iWidth / 2, lDispY - iHeight / 2, iWidth, iHeight);
                    csGraphics.DrawEllipse(Pens.Black, lDispX - iWidth / 2, lDispY - iHeight / 2, iWidth, iHeight);
                    csGraphics.FillEllipse(Brushes.Black, lDispX - iWidth / 10 * 2, lDispY - iHeight / 10 * 2, iWidth / 10 * 4, iHeight / 10 * 4);
                }
                else
                {// グループ外側の場合
                    pPolygon1[0].X = (int)lDispX;
                    pPolygon1[0].Y = (int)lDispY;
                    pPolygon1[1].X = (int)lDispX + iWidth / 2;
                    pPolygon1[1].Y = (int)lDispY - iHeight / 2;
                    pPolygon1[2].X = (int)lDispX + iWidth / 2;
                    pPolygon1[2].Y = (int)lDispY + iHeight / 2;
                    pPolygon1[3].X = (int)lDispX - iWidth / 2;
                    pPolygon1[3].Y = (int)lDispY + iHeight / 2;
                    pPolygon1[4].X = (int)lDispX - iWidth / 2;
                    pPolygon1[4].Y = (int)lDispY - iHeight / 2;

                    // 回転
                    if (dRotate != 0)
                    {// 向きが上以外の場合
                        pOriginPoint.X = (int)lDispX;
                        pOriginPoint.Y = (int)lDispY;
                        mMatrix1.Translate(-pOriginPoint.X, -pOriginPoint.Y, MatrixOrder.Append);   // 平行移動マトリックスの取得
                        mMatrix1.Rotate((float)dRotate, MatrixOrder.Append);                        // 回転マトリックスの取得
                        mMatrix1.TransformPoints(pPolygon1);                                        // 座標の変換
                        mMatrix2.Translate(pOriginPoint.X, pOriginPoint.Y, MatrixOrder.Append);     // 平行移動マトリックスの取得
                        mMatrix2.TransformPoints(pPolygon1);                                        // 座標の変換
                    }

                    csGraphics.FillPolygon(csDrawBrush, pPolygon1);
                    csGraphics.DrawPolygon(Pens.Black, pPolygon1);
                }
            }
            else
            {// 出力の場合
                if (bInnerFlg == true)
                {// グループ内側の場合
                    csGraphics.FillEllipse(csDrawBrush, lDispX - iWidth / 2, lDispY - iHeight / 2, iWidth, iHeight);
                    csGraphics.DrawEllipse(Pens.Black, lDispX - iWidth / 2, lDispY - iHeight / 2, iWidth, iHeight);
                    pPolygon2[0].X = (int)lDispX;
                    pPolygon2[0].Y = (int)lDispY - iHeight / 2;
                    pPolygon2[1].X = (int)lDispX;
                    pPolygon2[1].Y = (int)lDispY + iHeight / 2;
                    pOriginPoint.X = (int)lDispX;
                    pOriginPoint.Y = (int)lDispY;

                    // 回転
                    mMatrix1.Translate(-pOriginPoint.X, -pOriginPoint.Y, MatrixOrder.Append);   // 平行移動マトリックスの取得
                    mMatrix1.Rotate((float)45, MatrixOrder.Append);                             // 回転マトリックスの取得
                    mMatrix1.TransformPoints(pPolygon2);                                        // 座標の変換
                    mMatrix2.Translate(pOriginPoint.X, pOriginPoint.Y, MatrixOrder.Append);     // 平行移動マトリックスの取得
                    mMatrix2.TransformPoints(pPolygon2);                                        // 座標の変換

                    csGraphics.DrawLine(Pens.Black, pPolygon2[0], pPolygon2[1]);
                    int iTempY = pPolygon2[0].Y;
                    pPolygon2[0].Y = pPolygon2[1].Y;
                    pPolygon2[1].Y = iTempY;
                    csGraphics.DrawLine(Pens.Black, pPolygon2[0], pPolygon2[1]);
                }
                else
                {// グループ外側の場合
                    pPolygon1[0].X = (int)lDispX + iWidth / 2;
                    pPolygon1[0].Y = (int)lDispY;
                    pPolygon1[1].X = (int)lDispX + iWidth / 2;
                    pPolygon1[1].Y = (int)lDispY + iHeight / 2;
                    pPolygon1[2].X = (int)lDispX - iWidth / 2;
                    pPolygon1[2].Y = (int)lDispY + iHeight / 2;
                    pPolygon1[3].X = (int)lDispX - iWidth / 2;
                    pPolygon1[3].Y = (int)lDispY;
                    pPolygon1[4].X = (int)lDispX;
                    pPolygon1[4].Y = (int)lDispY - iHeight / 2;

                    // 回転
                    if (dRotate != 0)
                    {// 向きが上以外の場合
                        pOriginPoint.X = (int)lDispX;
                        pOriginPoint.Y = (int)lDispY;
                        mMatrix1.Translate(-pOriginPoint.X, -pOriginPoint.Y, MatrixOrder.Append);   // 平行移動マトリックスの取得
                        mMatrix1.Rotate((float)dRotate, MatrixOrder.Append);                        // 回転マトリックスの取得
                        mMatrix1.TransformPoints(pPolygon1);                                        // 座標の変換
                        mMatrix2.Translate(pOriginPoint.X, pOriginPoint.Y, MatrixOrder.Append);     // 平行移動マトリックスの取得
                        mMatrix2.TransformPoints(pPolygon1);                                        // 座標の変換
                    }

                    csGraphics.FillPolygon(csDrawBrush, pPolygon1);
                    csGraphics.DrawPolygon(Pens.Black, pPolygon1);
                }
            }

            mMatrix1.Dispose();
            mMatrix2.Dispose();
        }
    }
}
