﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト新規作成画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.Tool;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;    
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクト新規作成画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetNewProjectForm : HySDotNetForm
    {
        /// <summary>新規プロジェクト情報</summary>
        private McProjectInfData m_csNewPrjData;

        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetNewProjectForm";

        ///// <summary>エラーメッセージタイトル </summary>
        //static private readonly string ERROR_MSGBOX_TITLE = "エラー"; 

        /// <summary>
		/// メッセージボックスタイトル『プロジェクト管理機能』
        /// </summary>
        private static readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");

		///// <summary>メッセージ「期間入力異常」 </summary>
        //static private readonly string MSG_ERROR_PERIOD_DATE = "期間の指定が正しくありません。";
		/// <summary>メッセージボックスメッセージ『期間の指定が正しくありません』</summary>
		static private readonly string MSG_ERROR_PERIOD_DATE = HysMessage.GetString("HYS_MSG_WARNING_PERIOD_DATE");

		///// <summary>メッセージ「プロジェクト名入力異常」 </summary>
        //static private readonly string MSG_ERROR_PROJECT_NAME = "プロジェクト名に使用できない文字が含まれています。\n禁止文字　" + @"\ / : , ; * ? "" < > |";
		/// <summary>メッセージボックスメッセージ『プロジェクト名に使用できない文字が含まれています。禁止文字 \ / : , ; * ? | 』 </summary>
		static private readonly string MSG_ERROR_PROJECT_NAME = McMessage.GetString("MC_MSG_WARNING_PROJECT_NAME");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectForm csNewProjectForm = new McDotNetNewProjectForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McDotNetNewProjectForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectForm csNewProjectForm = new McDotNetNewProjectForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetNewProjectForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csNewPrjData = new McProjectInfData();
        }

        /// <summary><para>method outline</para>
        /// <para>作成ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Create_Button.Click += new System.EventHandler(this.Create);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        private void Create(object sender, EventArgs e)
        {
            // 期間入力チェック
            if (PeriodComboBox.SelectedIndex == 1)
            {
                long lYear = (long)(PeriodFromDateTimePicker.Value.Year);
                long lMonth = (long)(PeriodFromDateTimePicker.Value.Month);
                long lDate = (long)(PeriodFromDateTimePicker.Value.Day);
                HySTime csFromTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
                lYear = (long)(PeriodToDateTimePicker.Value.Year);
                lMonth = (long)(PeriodToDateTimePicker.Value.Month);
                lDate = (long)(PeriodToDateTimePicker.Value.Day);
                HySTime csToTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
                if ((csFromTime.Before(csToTime) == false) && (csFromTime.Equals(csToTime) == false))
                {
                    //MessageBox.Show(MSG_ERROR_PERIOD_DATE, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation); 
                    MessageBox.Show(MSG_ERROR_PERIOD_DATE,MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return;
                }
            }

            string sErrCharacter=@"\/:,;*?""<>|";
            if (ProjectNameBox.Text.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
            {
                //MessageBox.Show(MSG_ERROR_PROJECT_NAME, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);    
                MessageBox.Show(MSG_ERROR_PROJECT_NAME,MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }
         
            // 入力情報をメンバ変数に格納する
            GetInputData();

            //イベント生成
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_NEW_SIMULATOR_CREATE);
            if (false == this.PutEvent(csEventObj))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME,"Create", 
                   Properties.McDotNetViewerResources.STATEMENT_SIM_CREATE_ERR );
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Create", "PutEvent CMND_NEW_SIMULATOR_CREATE is failed.");
            }
            Close();
            
        }

        /// <summary><para>method outline</para>
        /// <para>キャンセルボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            // 処理（スクリーンクラスのPutEventをコールする）
            bRtn = m_csScreen.PutEvent(csEvent);

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetProjectData(McProjectInfData csPrjData): </para>
        /// </example>
        /// <param name="csPrjData">プロジェクト情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetProjectData(McProjectInfData csPrjData)
        {
            // 入力されたプロジェクト情報を設定する
            csPrjData.SetProjectGroupName(m_csNewPrjData.GetProjectGroupName());    // Ver1.1 追加
            csPrjData.SetProjectName(m_csNewPrjData.GetProjectName());
            csPrjData.SetAdminName(m_csNewPrjData.GetAdminName());
            csPrjData.SetModelType(m_csNewPrjData.GetModelType());
            csPrjData.SetModelTarget(m_csNewPrjData.GetModelTarget());
            csPrjData.SetModelCalcType(m_csNewPrjData.GetModelCalcType());
            csPrjData.SetModelSubject(m_csNewPrjData.GetModelSubject());
            csPrjData.SetModelSituation(m_csNewPrjData.GetModelSituation());
            csPrjData.SetModelPeriodType(m_csNewPrjData.GetModelPeriodType());
            csPrjData.SetModelPeriod(m_csNewPrjData.GetModelPeriod());
            csPrjData.SetThresholdCondition1(m_csNewPrjData.GetThresholdCondition1());
            csPrjData.SetThresholdCondition2(m_csNewPrjData.GetThresholdCondition2());
            csPrjData.SetThresholdCondition3(m_csNewPrjData.GetThresholdCondition3());
            csPrjData.SetThresholdCondition4(m_csNewPrjData.GetThresholdCondition4());
            csPrjData.SetThresholdCondition5(m_csNewPrjData.GetThresholdCondition5());
            csPrjData.SetCondition1(m_csNewPrjData.GetCondition1());
            csPrjData.SetCondition2(m_csNewPrjData.GetCondition2());
            csPrjData.SetCondition3(m_csNewPrjData.GetCondition3());
            csPrjData.SetCondition4(m_csNewPrjData.GetCondition4());
            csPrjData.SetCondition5(m_csNewPrjData.GetCondition5());
            csPrjData.SetCreateDate(m_csNewPrjData.GetCreateDate());
            csPrjData.SetComment(m_csNewPrjData.GetComment());
        }

        /// <summary><para>method outline:</para>
        /// <para>入力データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetInputData(); </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetInputData()
        {
// Ver1.1 追加 >>>
            //プロジェクトグループ名の取得
            m_csNewPrjData.SetProjectGroupName(new HySString(this.ProjectGroupBox.Text));
// Ver1.1 追加 <<<
            //プロジェクト名の取得
            m_csNewPrjData.SetProjectName(new HySString(this.ProjectNameBox.Text));
            //管理者名の取得
            m_csNewPrjData.SetAdminName(new HySString(this.AdminNameBox.Text));
            //種別の取得
            m_csNewPrjData.SetModelType(new HySString(this.KindBox.Text));
            //対象の取得
            m_csNewPrjData.SetModelTarget(new HySString(this.TargetBox.Text));
            //モデルの取得
            m_csNewPrjData.SetModelCalcType(new HySString(this.ModelBox.Text));
            //件名の取得
            m_csNewPrjData.SetModelSubject(new HySString(this.SubjectBox.Text));
            //ケース名の取得
            m_csNewPrjData.SetModelSituation(new HySString(this.CaseNameBox.Text));
            //期間種別・期間の取得
            if (PeriodComboBox.SelectedIndex == 2)
            {
                m_csNewPrjData.SetModelPeriodType(McProjectInfData.ModelPeriodType.REGULARITY);
                m_csNewPrjData.SetModelPeriod(null);
            }
            else if (PeriodComboBox.SelectedIndex == 1)
            {
                m_csNewPrjData.SetModelPeriodType(McProjectInfData.ModelPeriodType.PERIOD);
                long lFromYear = (long)(PeriodFromDateTimePicker.Value.Year);
                long lFromMonth = (long)(PeriodFromDateTimePicker.Value.Month);
                long lFromDate = (long)(PeriodFromDateTimePicker.Value.Day);
                long lToYear = (long)(PeriodToDateTimePicker.Value.Year);
                long lToMonth = (long)(PeriodToDateTimePicker.Value.Month);
                long lToDate = (long)(PeriodToDateTimePicker.Value.Day);
                m_csNewPrjData.SetModelPeriod(new McRange(HySCalendar.CreateTime(lFromYear, lFromMonth, lFromDate, 0L, 0L, 0L), HySCalendar.CreateTime(lToYear, lToMonth, lToDate, 0L, 0L, 0L)));
            }
            else
            {
                m_csNewPrjData.SetModelPeriodType(McProjectInfData.ModelPeriodType.NonType);
                m_csNewPrjData.SetModelPeriod(null);
            }
            //境界条件１の取得
            m_csNewPrjData.SetThresholdCondition1(new HySString(this.Boundaries1Box.Text));
            //境界条件２の取得
            m_csNewPrjData.SetThresholdCondition2(new HySString(this.Boundaries2Box.Text));
            //境界条件３の取得
            m_csNewPrjData.SetThresholdCondition3(new HySString(this.Boundaries3Box.Text));
            //境界条件４の取得
            m_csNewPrjData.SetThresholdCondition4(new HySString(this.Boundaries4Box.Text));
            //境界条件５の取得
            m_csNewPrjData.SetThresholdCondition5(new HySString(this.Boundaries5Box.Text));
            //条件１の取得
            m_csNewPrjData.SetCondition1(new HySString(this.Condition1Box.Text));
            //条件２の取得
            m_csNewPrjData.SetCondition2(new HySString(this.Condition2Box.Text));
            //条件３の取得
            m_csNewPrjData.SetCondition3(new HySString(this.Condition3Box.Text));
            //条件４の取得
            m_csNewPrjData.SetCondition4(new HySString(this.Condition4Box.Text));
            //条件５の取得
            m_csNewPrjData.SetCondition5(new HySString(this.Condition5Box.Text));
            //作成日の取得
            long lYear = (long)(CreateDateDtp.Value.Year);
            long lMonth = (long)(CreateDateDtp.Value.Month);
            long lDate = (long)(CreateDateDtp.Value.Day);
            m_csNewPrjData.SetCreateDate(HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L));
            //備考の取得
            m_csNewPrjData.SetComment(new HySString(this.CommentBox.Text));
        }

// Ver1.1 追加 >>>
        /// <summary><para>method outline</para>
        /// <para>プロジェクトグループ名ボックス入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectGroupBox.TextChanged += new System.EventHandler(this.ProjectGroup_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectGroup_TextChanged(object sender, EventArgs e)
        {
            ChangeCreateButtonEnabled();
        }
// Ver1.1 追加 <<<
        
        /// <summary><para>method outline</para>
        /// <para>プロジェクト名ボックス入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectNameBox.TextChanged += new System.EventHandler(this.ProjectName_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectName_TextChanged(object sender, EventArgs e)
        {
            ChangeCreateButtonEnabled();
        }

        /// <summary><para>method outline</para>
        /// <para>管理者名ボックス入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.AdminNameBox.TextChanged += new System.EventHandler(this.AdminName_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AdminName_TextChanged(object sender, EventArgs e)
        {
            ChangeCreateButtonEnabled();
        }

        /// <summary><para>method outline</para>
        /// <para>作成ボタン有効無効変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.CheckEssentialValue();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必須項目が入力されていないときに作成ボタンを押せなくする</para>
        /// </remarks>
        private void ChangeCreateButtonEnabled()
        {
            // プロジェクトグループ名とプロジェクト名称と管理者名が入力されてない場合は新規ボタンを非活性にする
            if ((AdminNameBox.Text != string.Empty) && (ProjectNameBox.Text != string.Empty) && (ProjectGroupBox.Text != string.Empty))     // Ver1.1 修正
            {
                Create_Button.Enabled = true;
            }
            else
            {
                Create_Button.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>期間種別選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PeriodComboBox_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PeriodComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (PeriodComboBox.SelectedIndex == 1)
            {
                PeriodFromDateTimePicker.Enabled = true;
                PeriodToDateTimePicker.Enabled = true;
            }
            else
            {
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0002,
                        ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}
