﻿// <summary>ソースコード：プロジェクト管理画面フォームクラス</summary>
// <remarks>
// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
// </remarks>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.IO;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクト管理画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][修正]
    /// </para>
    /// </remarks>
    public partial class McDotNetProjectCtlForm : HySDotNetForm
    {
        /// <summary><para>class outline:</para>
        /// <para>計算コントロールタブ情報クラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/02/11][新規作成]</para>
        /// </remarks>
        public class McSimulationTabInfo
        {
            /// <summary>ラジオボタン選択状態</summary>
            private long m_lSelectRadioBtnIndex;
            /// <summary>開始時刻(上段)</summary> 
            private DateTime m_csDayStartTime;
            /// <summary>終了時刻(上段)</summary>
            private DateTime m_csDayEndTime;
            /// <summary>開始時刻(下段)</summary>
            private DateTime m_csTermStartTime;
            /// <summary>計算期間値(下段)</summary>
            private string m_strTermEndTime;
            /// <summary>計算期間単位(下段)</summary>
            private string m_strTermUnit;
            /// <summary>中断時刻チェック</summary>
            private Boolean m_isSuspendCheck;
            /// <summary>中断時刻</summary>
            private DateTime m_csSuspendTime;
            /// <summary>タイムステップ値</summary>
            private string m_strTimeStep;
            /// <summary>タイムステップ単位</summary>
            private string m_strTimeStepUnit;

            /// <summary><para>method outline:</para>
            /// <para>デフォルトコンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>McSimulationTabInfo csSimuTabInfo = new McSimulationTabInfo();</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>McSimulationTabInfo 生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McSimulationTabInfo( )
            {
                m_lSelectRadioBtnIndex = 0;
                m_csDayStartTime = DateTime.Today;
                m_csDayEndTime = DateTime.Today;
                m_csTermStartTime = DateTime.Today;
                m_strTermEndTime = string.Empty;
                m_strTermUnit = STR_UNIT_SEC;
                m_isSuspendCheck = false;
                m_csSuspendTime = DateTime.Today;
                m_strTimeStep = string.Empty;
                m_strTimeStepUnit = STR_UNIT_SEC;
            }

            /// <summary><para>method outline:</para>
            /// <para>選択ラジオボタン状態取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>long lRtn = GetSelectRadioBtnIndex(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>選択ラジオボタン状態</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public long GetSelectRadioBtnIndex()
            {
                return m_lSelectRadioBtnIndex;
            }
            /// <summary><para>method outline:</para>
            /// <para>選択ラジオボタン状態設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetSelectRadioBtnIndex(lValue)</para>
            /// </example>
            /// <param name="lValue">選択ラジオボタン状態</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetSelectRadioBtnIndex(long lValue)
            {
                m_lSelectRadioBtnIndex = lValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>開始時刻(上段)取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>DateTime csDate = GetDayStartTime(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>開始時刻(上段)</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public DateTime GetDayStartTime()
            {
                return m_csDayStartTime;
            }
            /// <summary><para>method outline:</para>
            /// <para>開始時刻(上段)設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetDayStartTime(csValue)</para>
            /// </example>
            /// <param name="csValue">開始時刻(上段)</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetDayStartTime(DateTime csValue)
            {
                m_csDayStartTime = csValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>終了時刻(上段)取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>DateTime csDate = GetDayEndTime(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>終了時刻(上段)</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public DateTime GetDayEndTime()
            {
                return m_csDayEndTime;
            }
            /// <summary><para>method outline:</para>
            /// <para>終了時刻(上段)設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetDayEndTime(csValue)</para>
            /// </example>
            /// <param name="csValue">終了時刻(上段)</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetDayEndTime(DateTime csValue)
            {
                m_csDayEndTime = csValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>開始時刻(下段)取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>DateTime csDate = GetTermStartTime(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>開始時刻(下段)</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public DateTime GetTermStartTime()
            {
                return m_csTermStartTime;
            }
            /// <summary><para>method outline:</para>
            /// <para>開始時刻(下段)設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetTermStartTime(csValue)</para>
            /// </example>
            /// <param name="csValue">開始時刻(下段)</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetTermStartTime(DateTime csValue)
            {
                m_csTermStartTime = csValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>計算期間値(下段)取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>DateTime csDate = GetTermEndTime(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>計算期間値(下段)</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public string GetTermEndTime()
            {
                return m_strTermEndTime;
            }

            /// <summary><para>method outline:</para>
            /// <para>計算期間値(下段)設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetTermEndTime(csValue)</para>
            /// </example>
            /// <param name="strValue">計算期間値(下段)</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetTermEndTime(string strValue)
            {
                m_strTermEndTime = strValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>計算期間単位(下段)取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>string strUnit = GetTermUnit(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>計算期間単位(下段)</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public string GetTermUnit()
            {
                return m_strTermUnit;
            }
            /// <summary><para>method outline:</para>
            /// <para>計算期間単位(下段)設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetTermUnit(csValue)</para>
            /// </example>
            /// <param name="strValue">計算期間単位(下段)</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetTermUnit(string strValue)
            {
                m_strTermUnit = strValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>中断時刻チェック取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>bool bRtn = csSimuTabInfo.GetSuspendCheck(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>中断時刻チェック</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public Boolean GetSuspendCheck()
            {
                return m_isSuspendCheck;
            }
            /// <summary><para>method outline:</para>
            /// <para>中断時刻チェック設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetSuspendCheck(csValue)</para>
            /// </example>
            /// <param name="isValue">中断時刻チェック</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetSuspendCheck(Boolean isValue)
            {
                m_isSuspendCheck = isValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>中断時刻取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>DateTime csDate = GetSuspendTime(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>中断時刻</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public DateTime GetSuspendTime()
            {
                return m_csSuspendTime;
            }
            /// <summary><para>method outline:</para>
            /// <para>中断時刻設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetSuspendTime(csValue)</para>
            /// </example>
            /// <param name="csValue">中断時刻</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetSuspendTime(DateTime csValue)
            {
                m_csSuspendTime = csValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>タイムステップ値取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>string strTimeStep = GetTimeStep(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>中断時刻</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public string GetTimeStep()
            {
                return m_strTimeStep;
            }
            /// <summary><para>method outline:</para>
            /// <para>タイムステップ値設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetTimeStep(csValue)</para>
            /// </example>
            /// <param name="strValue">タイムステップ値</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetTimeStep(string strValue)
            {
                m_strTimeStep = strValue;
            }

            /// <summary><para>method outline:</para>
            /// <para>タイムステップ単位取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>string strUnit = csSimuTabInfo.GetTimeStep(　);</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>中断時刻</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public string GetTimeStepUnit()
            {
                return m_strTimeStepUnit;
            }
            /// <summary><para>method outline:</para>
            /// <para>タイムステップ単位設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetTimeStepUnit(csValue)</para>
            /// </example>
            /// <param name="strValue">タイムステップ単位</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetTimeStepUnit(string strValue)
            {
                m_strTimeStepUnit = strValue;
            }
        }

        /// <summary><para>class outline:</para>
        /// <para>プロジェクト状態クラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/05/18][新規作成]</para>
        /// </remarks>
        public class McProjectStatus
        {
            /// <summary>リセット実行中フラグ</summary>
            private bool m_bResetRunning;
            /// <summary>ビルド実行中フラグ</summary>
            private bool m_bBuildRunning;

            /// <summary><para>method outline:</para>
            /// <para>デフォルトコンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>McProjectStatus csProjectStatus = new McProjectStatus();</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McProjectStatus()
            {
                m_bResetRunning = false;
                m_bBuildRunning = false;
            }

            /// <summary><para>property outline:</para>
            /// <para>リセット実行中フラグの取得・設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>csPrjStatus.ResetRunning</para>
            /// </example>
            /// <value>リセット実行中フラグ</value>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public bool ResetRunning
            {
                get
                {
                    return m_bResetRunning;
                }
                set
                {
                    m_bResetRunning = value;
                }
            }

            /// <summary><para>property outline:</para>
            /// <para>ビルド実行中フラグの取得・設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>csPrjStatus.BuildRunning</para>
            /// </example>
            /// <value>ビルド実行中フラグ</value>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public bool BuildRunning
            {
                get
                {
                    return m_bBuildRunning;
                }
                set
                {
                    m_bBuildRunning = value;
                }
            }
        }

        /// <summary>新規作成画面</summary>
        private McDotNetNewProjectForm m_NewProjectForm;

        /// <summary>登録画面</summary>
        private McDotNetProjectRegistForm m_ProjectRegistForm;

        /// <summary>検索画面</summary>
        private McDotNetProjectSearchForm m_ProjectSearchForm;

        /// <summary>検索結果画面</summary>
        private McDotNetProjectSearchResultForm m_csProjectSearchResultForm;

        /// <summary>処理中画面</summary>
        private McDotNetProjectCtlProgressForm m_csProgressForm;

// Ver1.1 追加 >>>
        /// <summary>新規作成(ファイル形式用)画面</summary>
        private McDotNetNewProjectFileForm m_NewProjectFileForm;

        /// <summary>保存画面</summary>
        private McDotNetProjectSaveForm m_ProjectSaveForm;
// Ver1.1 追加 <<<

        /// <summary>データクラスインスタンス(アクティブプロジェクト)</summary>
        private McProjectInfData m_csProjectInfData;

        /// <summary>プロジェクト名管理ハッシュテーブル</summary>
        private Hashtable m_csPrjNameTbl;

        /// <summary>計算現在時刻</summary>
        private HySTime m_csCurrentTime;

        /// <summary>プロジェクト計算コントロール表示状態</summary>
        private HySString m_csSimuTabDispState;

        /// <summary>アクティブプロジェクト計算状態</summary>
        private McSimulationStatus m_csSimulationState;

        /// <summary>アクティブプロジェクト計算コントロールタブ情報</summary>
        private McSimulationTabInfo m_csSimuTabInfo;

        /// <summary>計算コントロールタブ情報ハッシュテーブル</summary>
        private Hashtable m_csSimuTabInfoTbl;

        /// <summary>プロジェクト状態ハッシュテーブル</summary>
        private Hashtable m_csProjectStatusTbl;

        /// <summary>データコンテナ管理ハッシュテーブル</summary>
        private Hashtable m_csDataContainerTbl;

        // 定数定義
        /// <summary>プロジェクト無し</summary>
        static public readonly HySString NO_ACTIVE_PROJECT = new HySString("");
        /// <summary>未計算</summary>
        static public readonly HySString SIMULATION_NOT_RUN = new HySString(Properties.McDotNetViewerResources.SIMULATION_NOT_RUN);
        /// <summary>計算中</summary>
        static public readonly HySString SIMULATION_RUN = new HySString(Properties.McDotNetViewerResources.SIMULATION_RUN);
        /// <summary>中断</summary>
        static public readonly HySString SIMULATION_SUSPEND = new HySString(Properties.McDotNetViewerResources.SIMULATION_SUSPEND);
        /// <summary>計算終了</summary>
        static public readonly HySString SIMULATION_FINISH = new HySString(Properties.McDotNetViewerResources.SIMULATION_FINISH);

        /// <summary>単位　秒</summary>
        static public readonly string STR_UNIT_SEC = Properties.McDotNetViewerResources.STR_UNIT_SEC;
        /// <summary>単位　分</summary>
        static public readonly string STR_UNIT_MIN = Properties.McDotNetViewerResources.STR_UNIT_MIN;
        /// <summary>単位　時</summary>
        static public readonly string STR_UNIT_HOUR = Properties.McDotNetViewerResources.STR_UNIT_HOUR;
        /// <summary>単位　日</summary>
        static public readonly string STR_UNIT_DAY = Properties.McDotNetViewerResources.STR_UNIT_DAY;

        /// <summary>単位変換計算用　1分=60秒</summary>
        static public readonly long SEC_PER_MIN = 60;
        /// <summary>単位変換計算用　1時間=60*60秒</summary>
        static public readonly long SEC_PER_HOUR = 60 * 60;
        /// <summary>単位変換計算用　1日=24*60*60秒</summary>
        static public readonly long SEC_PER_DAY = 24 * 60 * 60;

        /// <summary>プロジェクトプロパティ表示数 </summary>
        static private readonly int PROPERTY_NUM = 26;      // Ver1.1 変更

        /// <summary>プロジェクトプロパティ名称　「プロジェクトGr名」 </summary>
        static private readonly string PROPERTY_PRJGROUP = Properties.McDotNetViewerResources.PROPERTY_PRJGROUP;
        /// <summary>プロジェクトプロパティ名称　「プロジェクト名」 </summary>
        static private readonly string PROPERTY_PRJNAME = Properties.McDotNetViewerResources.PROPERTY_PRJNAME;
        /// <summary>プロジェクトプロパティ名称　「管理者名」 </summary>
        static private readonly string PROPERTY_ADMINNAME = Properties.McDotNetViewerResources.PROPERTY_ADMINNAME;
        /// <summary>プロジェクトプロパティ名称　「種別」 </summary>
        static private readonly string PROPERTY_KIND = Properties.McDotNetViewerResources.PROPERTY_KIND;
        /// <summary>プロジェクトプロパティ名称　「対象」 </summary>
        static private readonly string PROPERTY_TARGET = Properties.McDotNetViewerResources.PROPERTY_TARGET;
        /// <summary>プロジェクトプロパティ名称　「モデル」 </summary>
        static private readonly string PROPERTY_MODEL = Properties.McDotNetViewerResources.PROPERTY_MODEL;
        /// <summary>プロジェクトプロパティ名称　「件名」 </summary>
        static private readonly string PROPERTY_SUBJECT = Properties.McDotNetViewerResources.PROPERTY_SUBJECT;
        /// <summary>プロジェクトプロパティ名称　「ケース名」 </summary>
        static private readonly string PROPERTY_CASENAME = Properties.McDotNetViewerResources.PROPERTY_CASENAME;
        /// <summary>プロジェクトプロパティ名称　「期間」 </summary>
        static private readonly string PROPERTY_PERIOD = Properties.McDotNetViewerResources.PROPERTY_PERIOD;
        /// <summary>プロジェクトプロパティ名称　「境界条件１」 </summary>
        static private readonly string PROPERTY_BOUNDARIES1 = Properties.McDotNetViewerResources.PROPERTY_BOUNDARIES1;
        /// <summary>プロジェクトプロパティ名称　「境界条件２」 </summary>
        static private readonly string PROPERTY_BOUNDARIES2 = Properties.McDotNetViewerResources.PROPERTY_BOUNDARIES2;
        /// <summary>プロジェクトプロパティ名称　「境界条件３」 </summary>
        static private readonly string PROPERTY_BOUNDARIES3 = Properties.McDotNetViewerResources.PROPERTY_BOUNDARIES3;
        /// <summary>プロジェクトプロパティ名称　「境界条件４」 </summary>
        static private readonly string PROPERTY_BOUNDARIES4 = Properties.McDotNetViewerResources.PROPERTY_BOUNDARIES4;
        /// <summary>プロジェクトプロパティ名称　「境界条件５」 </summary>
        static private readonly string PROPERTY_BOUNDARIES5 = Properties.McDotNetViewerResources.PROPERTY_BOUNDARIES5;
        /// <summary>プロジェクトプロパティ名称　「条件１」 </summary>
        static private readonly string PROPERTY_CONDITION1 = Properties.McDotNetViewerResources.PROPERTY_CONDITION1;
        /// <summary>プロジェクトプロパティ名称　「条件２」 </summary>
        static private readonly string PROPERTY_CONDITION2 = Properties.McDotNetViewerResources.PROPERTY_CONDITION2;
        /// <summary>プロジェクトプロパティ名称　「条件３」 </summary>
        static private readonly string PROPERTY_CONDITION3 = Properties.McDotNetViewerResources.PROPERTY_CONDITION3;
        /// <summary>プロジェクトプロパティ名称　「条件４」 </summary>
        static private readonly string PROPERTY_CONDITION4 = Properties.McDotNetViewerResources.PROPERTY_CONDITION4;
        /// <summary>プロジェクトプロパティ名称　「条件５」 </summary>
        static private readonly string PROPERTY_CONDITION5 = Properties.McDotNetViewerResources.PROPERTY_CONDITION5;
        /// <summary>プロジェクトプロパティ名称　「計算開始時刻」 </summary>
        static private readonly string PROPERTY_STARTTIME = Properties.McDotNetViewerResources.PROPERTY_STARTTIME;
        /// <summary>プロジェクトプロパティ名称　「計算終了時刻」 </summary>
        static private readonly string PROPERTY_ENDTIME = Properties.McDotNetViewerResources.PROPERTY_ENDTIME;
        /// <summary>プロジェクトプロパティ名称　「計算中断時刻」 </summary>
        static private readonly string PROPERTY_SUSPENDTIME = Properties.McDotNetViewerResources.PROPERTY_SUSPENDTIME;
        /// <summary>プロジェクトプロパティ名称　「作成日」 </summary>
        static private readonly string PROPERTY_CREATEDATE = Properties.McDotNetViewerResources.PROPERTY_CREATEDATE;
        /// <summary>プロジェクトプロパティ名称　「登録日」 </summary>
        static private readonly string PROPERTY_REGISTDATE = Properties.McDotNetViewerResources.PROPERTY_REGISTDATE;
        /// <summary>プロジェクトプロパティ名称　「更新日」 </summary>
        static private readonly string PROPERTY_UPDATEDATE = Properties.McDotNetViewerResources.PROPERTY_UPDATEDATE;
        /// <summary>プロジェクトプロパティ名称　「備考」 </summary>
        static private readonly string PROPERTY_COMMENT = Properties.McDotNetViewerResources.PROPERTY_COMMENT;

        /// <summary>新規作成画面タイトル 「新しいプロジェクト」</summary>
        static private readonly string FORM_TITLE_NEW_PROJECT = Properties.McDotNetViewerResources.FORM_TITLE_NEW_PROJECT;
        /// <summary>登録画面タイトル 「登録 － 」</summary>
        static private readonly string FORM_TITLE_PROJECT_REGIST = Properties.McDotNetViewerResources.FORM_TITLE_PROJECT_REGIST;
        /// <summary>検索画面タイトル 「プロジェクトの検索」</summary>
        static private readonly string FORM_TITLE_PROJECT_SEARCH = Properties.McDotNetViewerResources.FORM_TITLE_PROJECT_SEARCH;
        /// <summary>検索結果一覧表示画面タイトル 「検索結果」</summary>
        static private readonly string FORM_TITLE_PROJECT_SEARCH_RESULT = Properties.McDotNetViewerResources.FORM_TITLE_PROJECT_SEARCH_RESULT;
        /// <summary>詳細画面タイトル 「プロジェクト詳細 － 」</summary>
        static private readonly string FORM_TITLE_PROJECT_DETAIL = Properties.McDotNetViewerResources.FORM_TITLE_PROJECT_DETAIL;
        /// <summary>保存画面タイトル 「保存 － 」</summary>
        static private readonly string FORM_TITLE_PROJECT_SAVE = Properties.McDotNetViewerResources.FORM_TITLE_PROJECT_SAVE;

		//*********************************************************************************************************************
		///// <summary>通常メッセージタイトル </summary>
        //static private readonly string MSGBOX_TITLE = "水・物質循環解析ソフトウェア共通基盤　CommonMP";
        ///// <summary>エラーメッセージタイトル </summary>
		//static private readonly string ERROR_MSGBOX_TITLE = "エラー";
        ///// <summary>メッセージ「検索結果0件」 </summary>
        //static private readonly string MSG_NO_SEARCH_RESULT = "該当するプロジェクトがありませんでした。";
        ///// <summary>メッセージ「計算終了確認」 </summary>
        //static private readonly string MSG_CONFILM_STOP = "計算を終了します。よろしいですか?";
        ///// <summary>メッセージ「計算リセット確認」 </summary>
        //static private readonly string MSG_CONFILM_RESET = "リセットを行います。よろしいですか?";
        ///// <summary>メッセージ「計算完了」 </summary>
        //static private readonly string MSG_COMPLETE_SIMULATION = "計算が完了しました。";
        ///// <summary>メッセージ「計算異常終了」 </summary>
        //static private readonly string MSG_ABEND_SIMULATION = "計算が異常終了しました。";
        ///// <summary>メッセージ「初期化異常」 </summary>
        //static private readonly string MSG_ABEND_INITIALIZE = "初期化に失敗しました。";
        ///// <summary>メッセージ「登録完了」 </summary>
        //static private readonly string MSG_COMPLETE_DB_REGIST = "登録が完了しました。";
        ///// <summary>メッセージ「計算やり直し」 </summary>
        //static private readonly string MSG_NOT_RESTART = "モデルに変更があったので、最初から計算をやり直します。";
        ///// <summary>メッセージ「プロジェクト名称表示用文字」</summary>
        //static private readonly string MSG_PROJECT_NAME_FOR_MESSAGE_FRONT = "プロジェクト：[";
        ///// <summary>メッセージ「プロジェクト名称表示用文字」</summary>
        //static private readonly string MSG_PROJECT_NAME_FOR_MESSAGE_BACK = "]の";
        ///// <summary>メッセージ「シミュレーション期間指定異常」 </summary>
        //static private readonly string MSG_ERROR_SIMU_TERM = "シミュレーション期間が正しくありません。";          
        ///// <summary>メッセージ「終了時刻設定異常」 </summary>
        //static private readonly string MSG_ERROR_SIMU_ENDTIME = "終了時刻設定が正しくありません。";                       
        ///// <summary>メッセージ「中断時刻設定異常」 </summary>
        //static private readonly string MSG_ERROR_SIMU_SUSPENDTIME = "中断時刻設定が正しくありません。";
        ///// <summary>メッセージ「モデル構築失敗」 </summary>
        //static private readonly string MSG_ERROR_MODEL_BUILD = "シミュレーションモデルの構築に失敗しました。";
        ///// <summary>メッセージ「計算開始失敗」 </summary>
        //static private readonly string MSG_ERROR_SIMU_RUN = "シミュレーション計算開始に失敗しました。";
        ///// <summary>メッセージ「登録失敗」 </summary>
        //static private readonly string MSG_ERROR_DB_REGIST = "プロジェクトの登録に失敗しました。";
        ///// <summary>メッセージ「削除失敗」 </summary>
        //static private readonly string MSG_ERROR_DB_DELETE = "プロジェクトの削除に失敗しました。";        
        ///// <summary>メッセージ「検索失敗」 </summary>
        //static private readonly string MSG_ERROR_DB_SEARCH_LIST = "プロジェクトの検索に失敗しました。";
        ///// <summary>メッセージ「プロジェクトデータ取得失敗」 </summary>
        //static private readonly string MSG_ERROR_DB_SEARCH_PRJDATA = "プロジェクトデータの取得に失敗しました。";
		//*********************************************************************************************************************
		/// <summary>タイトル『プロジェクト管理機能』</summary>
		static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");

		/// <summary>メッセージ『プロジェクトのインポートが完了しました(件数{0}件)』 </summary>
		static private readonly string MC_MSG_INFO_IMPORT_PROJECT = McMessage.GetString("MC_MSG_INFO_IMPORT_PROJECT");

		/// <summary>メッセージ『プロジェクトのインポートに失敗しました。』</summary>
		static private readonly string MC_MSG_ERR_IMPORT_ALL_PROJECT = McMessage.GetString("MC_MSG_ERR_IMPORT_ALL_PROJECT");

		/// <summary>メッセージ『プロジェクトのインポート中にエラーが発生じました。({0}件中{1}件登録)』</summary>
		static private readonly string MC_MSG_ERR_IMPORT_ANYONE_PROJECT = McMessage.GetString("MC_MSG_ERR_IMPORT_ANYONE_PROJECT");

		/// <summary>メッセージ『該当するプロジェクトがありませんでした。』</summary>
		static private readonly string MSG_NO_SEARCH_RESULT = McMessage.GetString("MC_MSG_INFO_NO_SEARCH_RESULT");

		/// <summary>メッセージ『プロジェクト内容が変更されたため、シュミレーションモデルを再構築します。』</summary>
		static private readonly string MSG_NOT_RESTART = McMessage.GetString("MC_MSG_INFO_REBUILD_MODEL");

		/// <summary>メッセージ『シュミレーション期間設定が正しくありません。』</summary>
		static private readonly string MSG_ERROR_SIMU_TERM = McMessage.GetString("MC_MSG_WARNING_SIMULATION_TERM");

		/// <summary>メッセージ『終了時刻設定が正しくありません。』</summary>                      
		static private readonly string MSG_ERROR_SIMU_ENDTIME = McMessage.GetString("MC_MSG_WARNING_SIMULATION_END_TIME");

		/// <summary>メッセージ『中断時刻設定が正しくありません。』</summary>
		static private readonly string MSG_ERROR_SIMU_SUSPENDTIME = McMessage.GetString("MC_MSG_WARNING_SIMULATION_SUSPEND_TIME");

		/// <summary>メッセージ『シュミレーションモデルの計算を停止します。よろしいですか？』</summary>
		static private readonly string MSG_CONFILM_STOP = McMessage.GetString("MC_MSG_QUESTION_CONFILM_STOP");

		/// <summary>メッセージ『シュミレーションモデルの計算結果をリセットします。よろしいですか？』 </summary>
		static private readonly string MSG_CONFILM_RESET = McMessage.GetString("MC_MSG_QUESTION_CONFILM_RESET");

		/// <summary>メッセージ『シュミレーションモデルの初期化に失敗しました。\nプロジェクト名：』 </summary>
		static private readonly string MSG_ABEND_INITIALIZE = McMessage.GetString("MC_MSG_ERROR_FORMAT_MODEL");

		/// <summary>メッセージ『シュミレーションモデルの計算が完了しました。\nプロジェクト名： 』</summary>
		static private readonly string MSG_COMPLETE_SIMULATION = McMessage.GetString("MC_MSG_INFO_COMPLETE_SIMULATION");

		/// <summary>メッセージ『プロジェクトの計算が異常終了しました。\nプロジェクト名：』</summary>
		static private readonly string MSG_ABEND_SIMULATION = McMessage.GetString("MC_MSG_ERR_ABEND_SIMULATION");

		/// <summary>メッセージ『プロジェクトのシュミレーションモデルの構築に失敗しました。\nプロジェクト名：』</summary>
		static private readonly string MSG_ERROR_MODEL_BUILD = McMessage.GetString("MC_MSG_ERR_BUILD_MODEL");

		/// <summary>メッセージ『シミュレーションモデルの計算開始に失敗しました。\nプロジェクト名：』 </summary>
		static private readonly string MSG_ERROR_SIMU_RUN = McMessage.GetString("MC_MSG_ERR_RUN_SIMULATION");
        
        /// <summary>メッセージ『プロジェクトの登録が完了しました。\nプロジェクト名：』</summary>
        static private readonly string MSG_COMPLETE_DB_REGIST = McMessage.GetString("MC_MSG_INFO_REGISTER_PROJECT");

        /// <summary>メッセージ『プロジェクトの登録に失敗しました。\nプロジェクト名：』 </summary>
        static private readonly string MSG_ERROR_DB_REGIST = McMessage.GetString("MC_MSG_ERR_REGISTER_PROJECT");

		/// <summary>メッセージ『プロジェクトの削除に失敗しました。』</summary>
        static private readonly string MSG_ERROR_DB_DELETE = McMessage.GetString("MC_MSG_ERR_DELETE_PROJECT");

		/// <summary>メッセージ『プロジェクトの検索に失敗しました。』</summary>
        static private readonly string MSG_ERROR_DB_SEARCH_LIST = McMessage.GetString("MC_MSG_ERR_SEARCH_LIST");

		/// <summary>メッセージ『プロジェクトデータの取得に失敗しました。』</summary>
        static private readonly string MSG_ERROR_DB_SEARCH_PRJDATA = McMessage.GetString("MC_MSG_ERR_SEARCH_PROJECT_DATA");

        /// <summary>メッセージ『同一IDのプロジェクトが既に開かれています。\nプロジェクト名：』</summary>
        static private readonly string MSG_ERROR_OPEN_PROJECT = McMessage.GetString("MC_MSG_WARNING_OPEN_PROJECT");

        /// <summary>メッセージ『プロジェクトの読み込みに失敗しました。』</summary>
        private static readonly string MC_MSG_ERR_READ_PROJECT = McMessage.GetString("MC_MSG_ERR_READ_PROJECT");

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加 プロジェクトに関するエラーメッセージ出力機能
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        //エラーメッセージ定義の追加
        /// <summary>メッセージ『指定されたプロジェクトは正しく保存されていません。』</summary>
        private static readonly string MC_MSG_ERROR_SAVE_PROJECT = McMessage.GetString("MC_MSG_ERROR_SAVE_PROJECT");

        //*********************************************************************************************************************

        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetProjectCtlForm";

        // スレッドタイマー
        /// <summary>スレッドタイマーインスタンス</summary>
        protected System.Threading.Timer m_csThreadTimerInstance = null;
        // スレッドタイマー方法1
        ///// <summary>スレッドタイマ処理デリゲート</summary>
        //delegate void SimuThreadTimer_Tick_Delegate(object obj);
        // スレッドタイマー方法2
        ///// <summary>タイマースレッド動作フラグ</summary>
        //bool m_bThreadflg = false;
        ///// <summary>Formクローズフラグ</summary>
        //bool m_bFormCloseflg = false;
        /// <summary>非同期動作追跡クラス</summary>
        AsyncOperation m_csAO = null;
        /// <summary>タイマーメソッドデリゲート</summary>
        System.Threading.SendOrPostCallback m_d_PostCallback = null;
        // バックグラウンド操作化
        /// <summary>外部データベースツール起動状態フラグ</summary>
        private bool m_bExtDBToolStateFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectCtlForm csDotNetForm = new McDotNetProjectCtlForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McDotNetProjectCtlForm()
        {
            InitializeComponent();
            m_csPrjNameTbl = new Hashtable();
            m_csSimuTabInfoTbl = new Hashtable();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectCtlForm csDotNetForm = new McDotNetProjectCtlForm(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetProjectCtlForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectCtlForm(HySScreen csScreen)
        {
            InitializeComponent();
            // スレッドタイマー
            System.Threading.TimerCallback timerDelegate = new System.Threading.TimerCallback(SimuThreadTimer_Tick);
            // 更新間隔（初期値）
            // タイマーインスタンス生成（まだ開始しない）
            m_csThreadTimerInstance = new System.Threading.Timer(timerDelegate, null, System.Threading.Timeout.Infinite, 1000);
            m_csAO = AsyncOperationManager.CreateOperation(this);
            m_d_PostCallback = new System.Threading.SendOrPostCallback(SimuThreadTimer_Work);
            //日時表示フォーマット設定
            String csCustomFormat = System.Threading.Thread.CurrentThread.CurrentUICulture.DateTimeFormat.ShortDatePattern.ToString() + " "
                                    + System.Threading.Thread.CurrentThread.CurrentUICulture.DateTimeFormat.LongTimePattern.ToString();
            SimuDayStartTimeDtp.CustomFormat = csCustomFormat;
            SimuDayEndTimeDtp.CustomFormat = csCustomFormat;
            SimuTermStartTimeDtp.CustomFormat = csCustomFormat;
            SimuSuspendTimeDtp.CustomFormat = csCustomFormat;

            m_csPrjNameTbl = new Hashtable();
            m_csSimuTabInfoTbl = new Hashtable();
            m_csDataContainerTbl = new Hashtable();
            m_csProjectStatusTbl = new Hashtable();
            m_csScreen = csScreen;
            m_csProjectInfData = null;
            m_csSimulationState = null;
            m_csSimuTabInfo = null;
            m_csCurrentTime = null;
            // プロジェクトプロパティ初期表示 
            InitPropertyGridView();

            UpdateSimulationTabStatus();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトプロパティ表示初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitPropertyGridView();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void InitPropertyGridView()
        {
            for (int i = 0; i < PROPERTY_NUM; i++)
            {
                ProjectDataGridView.Rows.Add();
            }

            ProjectDataGridView.Rows[0].Cells[0].Value = PROPERTY_PRJGROUP; // Ver1.1 追加
            ProjectDataGridView.Rows[1].Cells[0].Value = PROPERTY_PRJNAME;
            ProjectDataGridView.Rows[2].Cells[0].Value = PROPERTY_ADMINNAME;
            ProjectDataGridView.Rows[3].Cells[0].Value = PROPERTY_KIND;
            ProjectDataGridView.Rows[4].Cells[0].Value = PROPERTY_TARGET;
            ProjectDataGridView.Rows[5].Cells[0].Value = PROPERTY_MODEL;
            ProjectDataGridView.Rows[6].Cells[0].Value = PROPERTY_SUBJECT;
            ProjectDataGridView.Rows[7].Cells[0].Value = PROPERTY_CASENAME;
            ProjectDataGridView.Rows[8].Cells[0].Value = PROPERTY_PERIOD;
            ProjectDataGridView.Rows[9].Cells[0].Value = PROPERTY_BOUNDARIES1;
            ProjectDataGridView.Rows[10].Cells[0].Value = PROPERTY_BOUNDARIES2;
            ProjectDataGridView.Rows[11].Cells[0].Value = PROPERTY_BOUNDARIES3;
            ProjectDataGridView.Rows[12].Cells[0].Value = PROPERTY_BOUNDARIES4;
            ProjectDataGridView.Rows[13].Cells[0].Value = PROPERTY_BOUNDARIES5;
            ProjectDataGridView.Rows[14].Cells[0].Value = PROPERTY_CONDITION1;
            ProjectDataGridView.Rows[15].Cells[0].Value = PROPERTY_CONDITION2;
            ProjectDataGridView.Rows[16].Cells[0].Value = PROPERTY_CONDITION3;
            ProjectDataGridView.Rows[17].Cells[0].Value = PROPERTY_CONDITION4;
            ProjectDataGridView.Rows[18].Cells[0].Value = PROPERTY_CONDITION5;
            ProjectDataGridView.Rows[19].Cells[0].Value = PROPERTY_STARTTIME;
            ProjectDataGridView.Rows[20].Cells[0].Value = PROPERTY_ENDTIME;
            ProjectDataGridView.Rows[21].Cells[0].Value = PROPERTY_SUSPENDTIME;
            ProjectDataGridView.Rows[22].Cells[0].Value = PROPERTY_COMMENT;
            ProjectDataGridView.Rows[23].Cells[0].Value = PROPERTY_CREATEDATE;
            ProjectDataGridView.Rows[24].Cells[0].Value = PROPERTY_REGISTDATE;
            ProjectDataGridView.Rows[25].Cells[0].Value = PROPERTY_UPDATEDATE;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>[閉じる]ボタン無効</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateParams cp = CreateParams</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>新規ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NewProjectBtn.Click += new System.EventHandler(this.NewProject_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NewProject_Click(object sender, EventArgs e)
        {
            ShowNewProjectForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>新規作成画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowNewProjectForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowNewProjectForm()
        {
            m_NewProjectForm = new McDotNetNewProjectForm(m_csScreen);
            m_NewProjectForm.Text = FORM_TITLE_NEW_PROJECT;

            // 画面の表示
            m_NewProjectForm.ShowDialog();
        }

        /// <summary><para>method outline:</para>
        /// <para>登録ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>RegistrationProjectBtn.Click += new System.EventHandler(this.RegistrationProject_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RegistrationProject_Click(object sender, EventArgs e)
        {
            ShowProjectRegistForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト登録画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowProjectRegistForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowProjectRegistForm()
        {
            // 計算パラメータの保存
            SaveSimulationParameter();

            if (m_csProjectInfData != null)
            {
                m_ProjectRegistForm = new McDotNetProjectRegistForm(m_csScreen, m_csProjectInfData);
                m_ProjectRegistForm.Text = FORM_TITLE_PROJECT_REGIST + m_csProjectInfData.GetDispProjectName().ToString();
                m_ProjectRegistForm.ShowDialog();  // モーダルダイアログで表示する。
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトインポート結果表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeProjectImport() </para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>インポート完了または失敗メッセージを表示する</para>
        /// </remarks>
        public void NoticeProjectImport(HySEventObject csEvent)
        {
            long lEventNo = csEvent.GetEventNo();
            HySDataLinkedList csAllList = csEvent.GetData() as HySDataLinkedList;
            string strMsgText = string.Empty;
            MessageBoxIcon csMsgIcon = MessageBoxIcon.Information;

            // 処理中画面を閉じる
            CloseProgressForm();

            // 正常時
            if (lEventNo == HySEventObject.NOTICE_DB_OK)
            {
                //strMsgText = string.Format("プロジェクトのインポートが完了しました。(件数：{0}件)", csAllList.GetCount().ToString());
                strMsgText = string.Format(MC_MSG_INFO_IMPORT_PROJECT, csAllList.GetCount().ToString());
            }
            // 異常時
            else
            {
                HySDataLinkedList csImportList = csEvent.GetSubData() as HySDataLinkedList;
                if ((csAllList == null) || (csImportList == null))
                {
                    //strMsgText = "プロジェクトのインポートに失敗しました。";
                    strMsgText = MC_MSG_ERR_IMPORT_ALL_PROJECT;
                }
                else
                {
                    //strMsgText = string.Format("プロジェクトのインポート中にエラーが発生しました。({0}件中 {1}件登録)"
                    //                                , csAllList.GetCount().ToString(), csImportList.GetCount().ToString());
					strMsgText = string.Format(MC_MSG_ERR_IMPORT_ANYONE_PROJECT, 
                        csAllList.GetCount().ToString(), csImportList.GetCount().ToString());
                }
                csMsgIcon = MessageBoxIcon.Error;
            }
            //MessageBox.Show(strMsgText, "プロジェクトのインポート", MessageBoxButtons.OK, csMsgIcon);
            MessageBox.Show(strMsgText, MSGBOX_TITLE, MessageBoxButtons.OK, csMsgIcon);
        }

        /// <summary><para>method outline:</para>
        /// <para>処理中画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowProgressForm(lCallBackNumber) </para>
        /// </example>
        /// <param name="lCallBackNumber">メニューコールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowProgressForm(long lCallBackNumber)
        {
            // 処理中画面をモーダル表示する
            m_csProgressForm = new McDotNetProjectCtlProgressForm(lCallBackNumber);
            m_csProgressForm.ShowDialog();  
        }

        /// <summary><para>method outline:</para>
        /// <para>処理中画面を閉じる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CloseProgressForm </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseProgressForm()
        {
            if (m_csProgressForm != null)
            {
                m_csProgressForm.Close();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>検索ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SearchProjectBtn.Click += new System.EventHandler(this.SearchProject_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SearchProject_Click(object sender, EventArgs e)
        {
            // 検索結果応答を「プロジェクトオープン」に設定
            ((McDotNetProjectCtlScreen)m_csScreen).SetQueryResponceEvent(HySEventObject.CMND_NEW_SIMULATOR_CREATE);
            
            ShowProjectSearchForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト検索画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowProjectSearchForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowProjectSearchForm()
        {
            m_ProjectSearchForm = new McDotNetProjectSearchForm(m_csScreen);
            m_ProjectSearchForm.Text = FORM_TITLE_PROJECT_SEARCH;
            m_ProjectSearchForm.ShowDialog();  // モーダルダイアログで表示する。
        }

        /// <summary><para>method outline:</para>
        /// <para>詳細ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DetailBtn.Click += new System.EventHandler(this.Detail_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Detail_Click(object sender, EventArgs e)
        {
            ShowProjectDetailForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト詳細画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowProjectDetailForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowProjectDetailForm()
        {
            McDotNetProjectDetailForm m_csProjectDetail = new McDotNetProjectDetailForm(m_csProjectInfData);
            m_csProjectDetail.Text = FORM_TITLE_PROJECT_DETAIL + m_csProjectInfData.GetDispProjectName().ToString();
            m_csProjectDetail.ShowDialog();  // モーダルダイアログで表示する。
        }

        /// <summary><para>method outline:</para>
        /// <para> 検索結果一覧表示画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowProjectSearchResultForm(csStockDataList);</para>
        /// </example>
        /// <param name="csStockDataList">検索結果（プロジェクトリスト）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowProjectSearchResultForm(HySStockDataList csStockDataList)
        {
            // 検索結果が0件の場合はメッセージ表示
            if (csStockDataList.GetCount() == 0L)
            {
                MessageBox.Show(MSG_NO_SEARCH_RESULT, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            else
            {
                // 検索結果画面を表示
                m_csProjectSearchResultForm = new McDotNetProjectSearchResultForm(m_csScreen, csStockDataList, this); // 検索結果画面を生成
                m_csProjectSearchResultForm.Text = FORM_TITLE_PROJECT_SEARCH_RESULT;
                m_csProjectSearchResultForm.ShowDialog();  // モーダルダイアログで表示する。
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ビルド指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SimulationBuildOrder();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimulationBuildOrder()
        {
            // シミュレーションモデル構築開始指示イベント生成 
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_MODEL_CONSTRUCTION);
            csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
            csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
            if ( false == this.PutEvent(csEvent) )
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationBuildOrder",
                    Properties.McDotNetViewerResources.STATEMENT_IVENT_SONSTRUCT_ERR );
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationBuildOrder", "PutEvent CMND_MODEL_CONSTRUCTION is failed.");
                return;
            }
            PrjTabControl.Enabled = false;

            // ビルド実行中フラグを立てる
            McProjectStatus csPrjStatus = (McProjectStatus)m_csProjectStatusTbl[GetActiveProjectKey()];
            csPrjStatus.BuildRunning = true;

        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算開始指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SimulationStartOrder();</para>
        /// </example>
        /// <returns>true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean SimulationStartOrder()
        {
            // シミュレーション計算開始指示イベント生成 
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_START_SIMULATION);
            csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
            csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
            if (false == this.PutEvent(csEvent))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationStartOrder", 
                    Properties.McDotNetViewerResources.STATEMENT_SIM_START_ERR );
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationStartOrder", "PutEvent CMND_START_SIMULATION is failed.");
                return false;
            }
            PrjTabControl.Enabled = false;
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始・再開ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>RunBtn.Click += new System.EventHandler(SimuRun_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuRun_Click(object sender, EventArgs e)
        {
            SimulationRunOrder();
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算実行</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SimulationRunOrder();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        //public void SimulationRunOrder()
        public bool SimulationRunOrder()
        {
            // 計算ステータスクラスから要ビルドかどうかを判断する。
            if (m_csSimulationState.GetModelConStatus() == McSimulationStatus.ModelConstructionStatus.NOT_CONSTRUCTED)
            {
                // 入力データのチェック
                if (this.CheckSimulationInputData(null) == false)
                {
                    return false;
                }
                SimulationBuildOrder();
            }
            else if (m_csSimulationState.GetModelModStatus() == McSimulationStatus.ModelModificationStatus.MODIFIED_CONSTRUCTION_REQUIRED)
            {
                McSimulationStatus.CalculationStatus csCalcState = m_csSimulationState.GetCalcStatus();
                // 中断,計算終了の場合はメッセージ表示
                if ((csCalcState == McSimulationStatus.CalculationStatus.INTERRUPTED) ||
                    (csCalcState == McSimulationStatus.CalculationStatus.FINISHED))
                {
                    MessageBox.Show(MSG_NOT_RESTART, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information); 
                }
                // 入力データのチェック
                if (this.CheckSimulationInputData(null) == false)
                {
                    return false;
                }
                SimulationBuildOrder();
            }
            else
            {
                // 入力データのチェック(現在時刻指定有)
                if (this.CheckSimulationInputData(m_csCurrentTime) == false)
                {
                    return false;
                }
                PutEventSimuRun();
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算実行時イベント送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PutEventSimuRun();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventSimuRun()
        {

            HySEventObject csEvent = null;
            McSimulationStatus.CalculationStatus csCalcState = m_csSimulationState.GetCalcStatus();
            string strErrMsg;
            // 未計算,強制終了の場合は計算開始
            if ((csCalcState == McSimulationStatus.CalculationStatus.INITIAL) ||
                (csCalcState == McSimulationStatus.CalculationStatus.FINISHED_STOP))
            {
                // 初期化実行後、計算開始する必要があるので、
                // まずはシミュレーション計算初期化指示イベントを送信
                csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_INITIALIZE_SIMULATION);
               // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_SIM_INIT_ERR;
             // strErrMsg = "PutEvent CMND_INITIALIZE_SIMULATION is failed.";
            }
            else// 中断、計算終了の場合は計算再開
            {
                // シミュレーション計算再開指示イベントを送信
                csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_RESTART_SIMULATION);
                // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_SIM_RESTART_ERR;
               // strErrMsg = "PutEvent CMND_RESTART_SIMULATION is failed.";
            }

            // ID、シミュレータ種別の設定
            csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
            csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
            if (false == this.PutEvent(csEvent))
            {
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "PutEventSimuRun", strErrMsg);
                return;
            }

            PrjTabControl.Enabled = false;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブ入力データチェック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = CheckSimulationInputData();</para>
        /// </example>
        /// <param name="csCurrentTime">判定用現在時刻</param>
        /// <returns>true:=入力正常, false:=入力異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在時刻指定無しチェックのときは引数にnullを設定する</para>
        /// </remarks>
        private Boolean CheckSimulationInputData(HySTime csCurrentTime)
        {
            HySTime csStartTime = null;
            HySTime csEndTime = null;
            HySTime csSuspendTime = null;

            // 計算パラメータの取得
            GetSimulationParameter(ref csStartTime, ref csEndTime, ref csSuspendTime );

            // シミュレーション期間のチェック
            if (csEndTime.After(csStartTime) == false)
            {
                //MessageBox.Show(MSG_ERROR_SIMU_TERM, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                MessageBox.Show(MSG_ERROR_SIMU_TERM,MSGBOX_TITLE,MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
                return false;
            }
            // 計算現在時刻との比較
            else if ((csCurrentTime != null) && (csEndTime.Before(csCurrentTime) == true))
            {
                //MessageBox.Show(MSG_ERROR_SIMU_ENDTIME, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation); 
                MessageBox.Show(MSG_ERROR_SIMU_ENDTIME, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return false;
            }

            if (csSuspendTime != null)   // 中断時刻設定が有効な場合
            {
                // 中断時刻設定のチェック
                if (csSuspendTime.After(csStartTime) == false || csSuspendTime.Before(csEndTime) == false)
                {
                    //MessageBox.Show(MSG_ERROR_SIMU_SUSPENDTIME, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSG_ERROR_SIMU_SUSPENDTIME, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return false;
                }
                // 現在時刻より中断時刻が前の場合は無効
                if (csCurrentTime != null)
                {
                    if (csCurrentTime.After(csSuspendTime) == true || csCurrentTime.Equals(csSuspendTime) == true)
                    {
                        csSuspendTime = null;
                    }
                }
            }

            // アクティブプロジェクト情報にセット
            m_csProjectInfData.SetStartSimuTime(csStartTime);
            m_csProjectInfData.SetEndSimuTime(csEndTime);
            m_csProjectInfData.SetSuspendTime(csSuspendTime);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算中断ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SuspendBtn.Click += new System.EventHandler(this.SimuSuspend_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuSuspend_Click(object sender, EventArgs e)
        {
            SimulationSuspendOrder();
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算中断指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SimulationSuspendOrder();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimulationSuspendOrder()
        {
            //SimuTimer.Enabled = false;          // タイマストップ
            // スレッドタイマー
            m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            // シミュレーション計算中断指示イベント送信 
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_PAUSE_SIMULATION);
            csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
            csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
            if (false == this.PutEvent(csEvent))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationSuspendOrder", 
                    Properties.McDotNetViewerResources.STATEMENT_SIM_PASE_ERR );
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationSuspendOrder", "PutEvent CMND_PAUSE_SIMULATION is failed.");
                return;
            }
            PrjTabControl.Enabled = false;
       }

        /// <summary><para>method outline:</para>
        /// <para>計算停止ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StopBtn.Click += new System.EventHandler(this.SimuStop_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuStop_Click(object sender, EventArgs e)
        {
            SimulationStopOrder();
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算強制終了指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SimulationStopOrder();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimulationStopOrder()
        {   
            //停止確認ダイアログ
            if (MessageBox.Show(MSG_CONFILM_STOP, MSGBOX_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Question) == DialogResult.OK)
            {
                // タイマストップ
                //SimuTimer.Enabled = false;
                // スレッドタイマー
                m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
                // シミュレーション計算強制終了指示イベント送信 
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_STOP_SIMULATION);
                csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
                csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
                if (false == this.PutEvent(csEvent))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationStopOrder", 
                        Properties.McDotNetViewerResources.STATEMENT_SIM_STOP_ERR );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationStopOrder", "PutEvent CMND_STOP_SIMULATION is failed.");
                    return;
                }
                PrjTabControl.Enabled = false;
                // 処理追加
                // 中断時刻設定にて中断した場合、シミュレータ側は計算完了状態の為、
                // シミュレータ側からNoticeイベントがこないので画面側にてNoticeイベントを自身に送る
                m_csSimulationState.SetCalcStatus(McSimulationStatus.CalculationStatus.FINISHED_STOP);
                HySEventObject csOwnEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.NOTICE_STOP_SIMULATION);
                csOwnEvent.SetSuppID(m_csProjectInfData.GetProjectID());
                csOwnEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
                if (false == this.PutEvent(csOwnEvent))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationStopOrder",
                        Properties.McDotNetViewerResources.STATEMENT_SIM_STOP_NOTICE );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationStopOrder", "PutEvent NOTICE_STOP_SIMULATION is failed.");
                    return;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>計算リセットボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ResetBtn.Click += new System.EventHandler(this.SimuReset_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuReset_Click(object sender, EventArgs e)
        {
            SimulationResetOrder();
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算リセット指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SimulationResetOrder();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimulationResetOrder()
        {
            if (MessageBox.Show(MSG_CONFILM_RESET, MSGBOX_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Question) == DialogResult.OK)
            {
                // 入力データのチェック
                if (this.CheckSimulationInputData(null) == false)
                {
                    return;
                }
                // タイマストップ
                //SimuTimer.Enabled = false;
                // スレッドタイマー
                m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
                // シミュレーション計算初期化指示イベント送信
                if (true == PutEventSimuInitialize())
                {
                    PrjTabControl.Enabled = false;

                    // リセット実行中フラグを立てる
                    McProjectStatus csPrjStatus = (McProjectStatus)m_csProjectStatusTbl[GetActiveProjectKey()];
                    csPrjStatus.ResetRunning = true;
                }
           }
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算初期化イベント送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = PutEventSimuInitialize();</para>
        /// </example>
        /// <returns>true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean PutEventSimuInitialize()
        {
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_INITIALIZE_SIMULATION);
            csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
            csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
            if (false == this.PutEvent(csEvent))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "PutEventSimuInitialize", 
                     Properties.McDotNetViewerResources.STATEMENT_SIM_INIT_ERR );
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "PutEventSimuInitialize", "PutEvent CMND_INITIALIZE_SIMULATION is failed.");
                return false;
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>中断時刻チェックボックス変更時イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SuspnedCheckBox.CheckedChanged += new System.EventHandler(this.SuspnedCheckBox_CheckedChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SuspnedCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            // チェックボックスの選択状態と中断時刻入力有無の同期を取る
            SimuSuspendTimeDtp.Enabled = SuspendCheckBox.Checked;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト情報追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn =  AppendProjectInf(csEvent); </para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean AppendProjectInf(HySEventObject csEvent)
        {
            const string strMethodName = "AppendProjectInf";

            long lSubEventNo = csEvent.GetSubEventNo();
            HySID csID = csEvent.GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)csEvent.GetToSimKind();
            // プロジェクト識別用キー作成
            HySString csPrcID = (HySString)csID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcKey = csPrcKind + csPrcID;

            HySSimulationDataContainer csDataContainer  = (HySSimulationDataContainer)csEvent.GetData();
            McProjectInfData csProjectInfData = (McProjectInfData)csDataContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
            // 新規プロジェクト追加の場合
            if (lSubEventNo == McDefine.HYM_APPEND_EMPTY_PROJECTINF)
            {
                //if (m_NewProjectForm == null && m_NewProjectFileForm == null)   // Ver1.1 変更
                //{
                //    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName, "No New ProjectData");
                //    return false;
                //}
// Ver1.1 変更 >>>
                //// 新規作成画面で入力した情報をプロジェクト情報クラスに格納する。
                //m_NewProjectForm.GetProjectData(csProjectInfData);
                //m_NewProjectForm = null;

                // 新規作成画面で入力した情報をプロジェクト情報クラスに格納する。
                if (m_NewProjectForm != null)
                {// 新規作成画面
                    m_NewProjectForm.GetProjectData(csProjectInfData);
                }
                else if (m_NewProjectFileForm != null)
                {// 新規作成(ファイル形式用)画面
                    m_NewProjectFileForm.GetProjectData(csProjectInfData);
                }
                else if (m_NewProjectForm == null && m_NewProjectFileForm == null)
                {
                    // 起動時に新規プロジェクトを作成する場合
                    HySString csProjectGrName = new HySString("NewProjectGr");
                    HySString csProjectName = new HySString("NewProject");
                    HySString csAdminName = new HySString("NewProject");
                    csProjectInfData.SetProjectGroupName(csProjectGrName);
                    // 既に同一名称のプロジェクトが存在する場合、番号付与(上書き保存で既存ファイルがつぶされるのを防ぐ為)
                    HySString csSettingPrjName = this.MakeProjectNameAutomatically(csProjectGrName, csProjectName); 
                    csProjectInfData.SetProjectName(csSettingPrjName);
                    csProjectInfData.SetAdminName(csAdminName);
                    //種別の取得
                    csProjectInfData.SetModelType(new HySString(""));
                    //対象の取得
                    csProjectInfData.SetModelTarget(new HySString(""));
                    //モデルの取得
                    csProjectInfData.SetModelCalcType(new HySString(""));
                    //件名の取得
                    csProjectInfData.SetModelSubject(new HySString(""));
                    //ケース名の取得
                    csProjectInfData.SetModelSituation(new HySString(""));
                    //境界条件１の取得
                    csProjectInfData.SetThresholdCondition1(new HySString(""));
                    //境界条件２の取得
                    csProjectInfData.SetThresholdCondition2(new HySString(""));
                    //境界条件３の取得
                    csProjectInfData.SetThresholdCondition3(new HySString(""));
                    //境界条件４の取得
                    csProjectInfData.SetThresholdCondition4(new HySString(""));
                    //境界条件５の取得
                    csProjectInfData.SetThresholdCondition5(new HySString(""));
                    //条件１の取得
                    csProjectInfData.SetCondition1(new HySString(""));
                    //条件２の取得
                    csProjectInfData.SetCondition2(new HySString(""));
                    //条件３の取得
                    csProjectInfData.SetCondition3(new HySString(""));
                    //条件４の取得
                    csProjectInfData.SetCondition4(new HySString(""));
                    //条件５の取得
                    csProjectInfData.SetCondition5(new HySString(""));
                    //備考の取得
                    csProjectInfData.SetComment(new HySString(""));

                    // プロジェクトグループフォルダーの作成
                    HySEventObject csJobEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_NEW_SIMULATOR_CREATE, McDefine.HYMCO_PROJECT_NEW);
                    csJobEventObj.SetSubData(csProjectInfData);
                    m_csScreen.GetViewerJob().EventCallback(csJobEventObj);

                }
                m_NewProjectForm = null;
                m_NewProjectFileForm = null;
// Ver1.1 変更 <<<
            }
            else
            {   
                // 新規以外は保存済みとする。
                McSimulationStatus csSimuStatus = (McSimulationStatus)csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                csSimuStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.SAVED);
            }

            // タイムステップの初期値設定
            McStructInfo csStructInfo = (McStructInfo)csDataContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
            //csProjectInfData.SetDeltaTime(csStructInfo.RecommendDeltaTime());

            // データコンテナの時刻を初期化する
            csDataContainer.SetStartTime(csProjectInfData.GetStartSimuTime());
            csDataContainer.SetSimuTime(csProjectInfData.GetStartSimuTime());
            csDataContainer.SetGoalTime(csProjectInfData.GetEndSimuTime());
            csDataContainer.SetDeltaTime(csStructInfo.RecommendDeltaTime());
            
            // 各種管理情報への追加
            // 表示名称の設定
//            HySString csDispName = McViewerInfoManager.GetDispProjectName(csProjectInfData.GetProjectID(), csProjectInfData.GetProjectName());
            HySString csDispName = McViewerInfoManager.GetDispProjectName(csProjectInfData.GetProjectID(), csProjectInfData.GetProjectGroupName() + "_" + csProjectInfData.GetProjectName());
            csProjectInfData.SetDispProjectName(csDispName);
            // プロジェクト一覧コンボボックス
            ProjectComboBox.Items.Add(csDispName.ToString());
            // データコンテナ管理テーブル
            m_csDataContainerTbl[csPrcKey.ToString()] = csDataContainer;
            // プロジェクト名管理テーブル
            m_csPrjNameTbl[csProjectInfData.GetDispProjectName().ToString()] = csPrcKey;
            // プロジェクト状態管理テーブル
            m_csProjectStatusTbl[csPrcKey] = new McProjectStatus();

            // 計算コントロールタブ情報作成
            m_csSimuTabInfoTbl[csPrcKey.ToString()] = CreateSimulationTabInfo(csProjectInfData);

//★★★★★★★★★★★★★★★★★★★★★
            // 共通情報の登録　インスタンス識別子とプロジェクトグループの登録
            HySString csProjectGroupName = csProjectInfData.GetProjectGroupName(); //csProjectInfData から　プロジェクトグループを取得する
            HySCommonInfoHash.SetCorrespond(McDefine.PROJECT_GROUP_NAME, csID.ToString(), csProjectGroupName.ToString()); // 対応登録を行う
//★★★★★★★★★★★★★★★★★★★★★

            // プロジェクト情報追加完了報告イベント送信
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON, McDefine.HYM_APPEND_PROJECTINF_END);
            csEventObject.SetToSimKind(csSimKind);
            csEventObject.SetSuppID(csID);
            if (false == this.PutEvent(csEventObject))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName,
                    Properties.McDotNetViewerResources.STATEMENT_CMND_DISP_APPEND_ERR);
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName, "PutEvent CMND_DISPLY_COMMON(HYM_APPEND_PROJECTINF_END) is failed.");
                return false;
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション関連報告コールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CallBackSimulationNotice(csEvent); </para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean CallBackSimulationNotice(HySEventObject csEvent)
        {
            // イベント情報取り出し
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lSubEventNo = ((HySEventObject)csEvent).GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();

            // プロジェクト識別用キー作成
            HySString csPrcID = (HySString)csID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcKey = csPrcKind + csPrcID;

            StringBuilder strBuilder;   
            String msgboxMsg;           
            String strPrjName;          

            // モデル構築完了報告
            if ((lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION))
            {
                // δtの設定
                HySSimulationDataContainer csDataContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey.ToString()];
                McStructInfo csStructInfo = (McStructInfo)csDataContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
                //m_csProjectInfData.SetDeltaTime(csStructInfo.RecommendDeltaTime());

                McProjectStatus csPrjStatus = (McProjectStatus)m_csProjectStatusTbl[csPrcKey];
                if (csPrjStatus.BuildRunning == true)
                {   // ビルド実行中の場合
                    csPrjStatus.BuildRunning = false;
                    return PutEventSimuInitialize();
                }
                if (this.IsActiveProject(csID))
                {   // アクティブプロジェクトの場合
                    // 画面表示ステータスの更新
                    UpdateSimulationTabStatus();
                }

            }   
            // 計算開始報告
            // 計算中断報告
            // 計算強制終了報告
            else if ( (lEventNo == HySEventObject.NOTICE_START_SIMULATION)
                || (lEventNo == HySEventObject.NOTICE_STOP_SIMULATION)
                || (lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION)
                )
            {
                if (this.IsActiveProject(csID))
                {   // アクティブプロジェクトの場合
                    // 画面表示ステータスの更新
                    UpdateSimulationTabStatus();

                    // プロジェクトタブ更新
                    UpdateProjectTabStatus();
                }
            }
            // 計算初期化報告
            else if ((lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION))
            {

                McProjectStatus csPrjStatus = (McProjectStatus)m_csProjectStatusTbl[csPrcKey];
                if (csPrjStatus.ResetRunning == true)
                {   // リセット実行中の場合
                    if (this.IsActiveProject(csID))
                    {   // アクティブプロジェクトの場合
                        // 画面表示ステータスの更新
                        UpdateSimulationTabStatus();
                    }
                    csPrjStatus.ResetRunning = false;
                }
                else
                {
                    if (lSubEventNo == McDefine.HYM_OK_SUBEVENT)
                    {
                        // 初期化正常時
                        // 計算開始イベント送信
                        return SimulationStartOrder();
                    }
                    else
                    {
                        // 初期化異常時
                        // メッセージの表示
                        //String strPrjName = this.GetProjectNameForMessage(csPrcKey);
                        //MessageBox.Show(strPrjName + MSG_ABEND_INITIALIZE,                  
                        //                    MSGBOX_TITLE,
                        //                    MessageBoxButtons.OK, MessageBoxIcon.Error);

                        strPrjName = this.GetProjectNameForMessage(csPrcKey);
                        strBuilder=new StringBuilder(MSG_ABEND_INITIALIZE);
                        strBuilder.Append(strPrjName);
                        msgboxMsg = strBuilder.ToString();
                        MessageBox.Show(msgboxMsg, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);

                        // 初期化異常だから、ステータスは未計算状態にする
                        this.UpdateSimulationTabStatus();
                    }
                }             
            }
            // 計算完了報告
            else if (lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)
            {
                if (this.IsActiveProject(csID))
                {   // アクティブプロジェクトの場合
                    // 画面表示ステータスの更新
                    UpdateSimulationTabStatus();

                    // プロジェクトタブ更新
                    UpdateProjectTabStatus();
                }

                // 完了メッセージの表示
                //String strPrjName = this.GetProjectNameForMessage(csPrcKey);
                //MessageBox.Show(strPrjName + MSG_COMPLETE_SIMULATION,
                //                    MSGBOX_TITLE,
                //                    MessageBoxButtons.OK, MessageBoxIcon.Information);

                strPrjName = this.GetProjectNameForMessage(csPrcKey);
                strBuilder = new StringBuilder(MSG_COMPLETE_SIMULATION);
                strBuilder.Append(strPrjName);
                msgboxMsg = strBuilder.ToString();
                MessageBox.Show(this, msgboxMsg, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            else if (lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND)
            {   // 計算異常終了
                if (this.IsActiveProject(csID))
                {   // アクティブプロジェクトの場合
                    // 画面表示ステータスの更新
                    UpdateSimulationTabStatus();

                    // プロジェクトタブ更新
                    UpdateProjectTabStatus();
                }

                // 完了メッセージの表示
                //String strPrjName = this.GetProjectNameForMessage(csPrcKey);
                //MessageBox.Show(strPrjName + MSG_ABEND_SIMULATION,
                //                    MSGBOX_TITLE,
                //                    MessageBoxButtons.OK, MessageBoxIcon.Information);

                strPrjName = this.GetProjectNameForMessage(csPrcKey);
                strBuilder = new StringBuilder(MSG_ABEND_SIMULATION);
                strBuilder.Append(strPrjName);
                msgboxMsg = strBuilder.ToString();
                MessageBox.Show(msgboxMsg, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            // 計算状況報告
            else if (lEventNo == HySEventObject.NOTICE_REPORT_SIMU_PROGRESS)
            {

                if (this.IsActiveProject(csID))
                {   // アクティブプロジェクトの場合
                    m_csCurrentTime = (HySTime)csEvent.GetData();
                    //CurrentTimeBox.Text = HySCalendar.GetString(m_csCurrentTime, 0).ToString();
                    CurrentTimeBox.Text = HySCalendar.GetString(m_csCurrentTime, HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();

                    // 実行中プロジェクトの開始・終了時刻を取り込む 2009.2.25 Add
                    HySTime csStartTime = m_csProjectInfData.GetStartSimuTime();
                    HySTime csEndTime = m_csProjectInfData.GetEndSimuTime();
                    // 2009.2.25 Add

                    // プログレスバー更新
                    double dTotal = csEndTime.GetTime() - csStartTime.GetTime();
                    double dSpan = m_csCurrentTime.GetTime() - csStartTime.GetTime();
                    int iProgress = (int)(dSpan / dTotal * 100);

                    // 100%より大きく、または0%より小さくなった場合は補正する
                    if (iProgress > 100)
                    {
                        iProgress = 100;
                    }
                    else if (iProgress < 0)
                    {
                        iProgress = 0;
                    }

                    SimulationProgressBar.Value = iProgress;
                }

                // 強制停止時は内部的に現在時刻無しの状態とする
                if (m_csSimulationState.GetCalcStatus() == McSimulationStatus.CalculationStatus.FINISHED_STOP)
                {
                    m_csCurrentTime = null;
                }
            }
            // シミュレーションモデル構築エラー
            else if (lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)
            {
                
                McProjectStatus csPrjStatus = (McProjectStatus)m_csProjectStatusTbl[csPrcKey];
                if (csPrjStatus.BuildRunning == true)
                {   // ビルド実行中の場合
                    csPrjStatus.BuildRunning = false;

                    // 対象プロジェクトのメッセージを表示
                    //String strPrjName = this.GetProjectNameForMessage(csPrcKey);
                    //MessageBox.Show(strPrjName + MSG_ERROR_MODEL_BUILD,
                    //                    ERROR_MSGBOX_TITLE,
                    //                    MessageBoxButtons.OK,
                    //                    MessageBoxIcon.Exclamation);

                    strPrjName = this.GetProjectNameForMessage(csPrcKey);
                    strBuilder= new StringBuilder(MSG_ERROR_MODEL_BUILD);
                    strBuilder.Append(strPrjName);
                    msgboxMsg = strBuilder.ToString();
                    MessageBox.Show(msgboxMsg, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);

                    if (this.IsActiveProject(csID))
                    {   // アクティブプロジェクトの場合
                        // 画面表示ステータスの更新
                        UpdateSimulationTabStatus();
                    }
                }
                if (this.IsActiveProject(csID))
                {   // アクティブプロジェクトの場合
                    // 画面表示ステータスの更新
                    UpdateSimulationTabStatus();
                }
            }
            // シミュレーション計算開始エラー
            else if (lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION)
            {
                // 対象プロジェクトのメッセージを表示
                //String strPrjName = this.GetProjectNameForMessage(csPrcKey);
                //MessageBox.Show(strPrjName + MSG_ERROR_SIMU_RUN,
                //                    ERROR_MSGBOX_TITLE,
                //                    MessageBoxButtons.OK,
                //                    MessageBoxIcon.Exclamation);

                strPrjName = this.GetProjectNameForMessage(csPrcKey);
                strBuilder = new StringBuilder(MSG_ERROR_SIMU_RUN);
                strBuilder.Append(strPrjName);
                msgboxMsg = strBuilder.ToString();
                MessageBox.Show(msgboxMsg, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);

                if (this.IsActiveProject(csID))
                {   // アクティブプロジェクトの場合
                    // 画面表示ステータスの更新
                    UpdateSimulationTabStatus();
                }
            }

            return true;
        }


        /// <summary><para>method outline:</para>
        /// <para>DB関連報告コールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CallBackDBNotice(csEvent); </para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean CallBackDBNotice(HySEventObject csEvent)
        {
            const string strMethodName = "CallBackDBNotice";
            
            // イベント情報取り出し
            long lSubEventNo = csEvent.GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();

            StringBuilder strBuilder=null;
            string msgboxMsg;
            
            // 登録完了
            //if (lSubEventNo == McDefine.HYM_DB_REGISTER)
            if (lSubEventNo == McDefine.HYM_DB_REGISTER || lSubEventNo == McDefine.HYMCO_PROJECT_SAVE)  // Ver1.1 追加
            {
                // 登録完了メッセージ
                //String strPrjName = this.GetProjectNameForMessage((HySSimulationDataContainer)csEvent.GetData());
                //MessageBox.Show(strPrjName + MSG_COMPLETE_DB_REGIST,  
                //                    MSGBOX_TITLE,                     
                //                    MessageBoxButtons.OK,             
                //                    MessageBoxIcon.Information);      

                if (lSubEventNo == McDefine.HYM_DB_REGISTER)          // Ver1.1 変更
                {
                    String strPrjName = this.GetProjectNameForMessage((HySSimulationDataContainer)csEvent.GetData());
                    strBuilder = new StringBuilder(MSG_COMPLETE_DB_REGIST);
                    strBuilder.Append(strPrjName);
                    msgboxMsg = strBuilder.ToString();
                    MessageBox.Show(msgboxMsg, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                
                // 登録日、更新日の修正
                HySSimulationDataContainer csDataCont = (HySSimulationDataContainer)csEvent.GetData();
                McProjectInfData csPrjInf = (McProjectInfData)csDataCont.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                if (m_csProjectInfData != null)
                {
                    m_csProjectInfData.SetRegistDate(csPrjInf.GetRegistDate());
                    m_csProjectInfData.SetUpdateDate(csPrjInf.GetUpdateDate());

                    // 入力プロジェクト情報の画面反映
                    UpdateProjectProperty();
                }
            }
            // コピー登録完了
//            else if (lSubEventNo == McDefine.HYM_LIBRARY_COPY_REGISTER)
            else if (lSubEventNo == McDefine.HYM_LIBRARY_COPY_REGISTER || lSubEventNo == McDefine.HYMCO_PROJECT_SAVE_NEW)   // Ver1.1 追加
            {
                // 登録完了メッセージ
                //String strPrjName = this.GetProjectNameForMessage((HySSimulationDataContainer)csEvent.GetData());
                //MessageBox.Show(strPrjName + MSG_COMPLETE_DB_REGIST,
                //                    MSGBOX_TITLE,                   
                //                    MessageBoxButtons.OK,           
                //                    MessageBoxIcon.Information);    

                if (lSubEventNo == McDefine.HYM_LIBRARY_COPY_REGISTER)          // Ver1.1 変更
                {
                    String strPrjName = this.GetProjectNameForMessage((HySSimulationDataContainer)csEvent.GetData());
                    strBuilder = new StringBuilder(MSG_COMPLETE_DB_REGIST);
                    strBuilder.Append(strPrjName);
                    msgboxMsg = strBuilder.ToString();
                    MessageBox.Show(msgboxMsg, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
                }

                // 登録データコンテナ(付属データ)を使ってプロジェクトオープンイベントを送信
                HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_NEW_SIMULATOR_CREATE);
                csEventObject.SetData(csEvent.GetData());
                csEventObject.SetToSimKind(csEvent.GetToSimKind());
                if (false == this.PutEvent(csEventObject))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName,
                        Properties.McDotNetViewerResources.STATEMENT_SIM_CREATE_ERR);
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName, "PutEvent CMND_NEW_SIMULATOR_CREATE is failed.");
                    return false;
                }

                // 登録前プロジェクトのクローズイベント
                csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                csEventObject.SetSubEventNo(McDefine.HYMCO_FILE_CLOSE);
                // 受信イベントよりIDを取得
                csEventObject.SetSuppID(csEvent.GetSuppID());
                csEventObject.SetToSimKind(csEvent.GetToSimKind());
                if (false == this.PutEvent(csEventObject))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName, 
                        Properties.McDotNetViewerResources.STATEMENT_CMND_DISP_CLOSE_ERR );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName, "PutEvent CMND_DISPLY_COMMON(HYMCO_FILE_CLOSE) is failed.");
                    return false;
                }
                
            }

            // 削除完了(検索結果一覧画面へ)
            else if (lSubEventNo == HySLibraryMngDefine.DB_DELETE_DATA_LIST_BY_ID)
            {
                if (m_csProjectSearchResultForm != null)
                {
                    // 検索結果一覧表示画面にコールバック
                    m_csProjectSearchResultForm.CallBackNoticeDelete();
                }
            }
            // エクスポート完了(検索結果一覧画面へ)
            else if (lSubEventNo == McDefine.HYM_PRJDATA_EXPORT)
            {
                if (m_csProjectSearchResultForm != null)
                {
                    // 検索結果一覧表示画面にコールバック
                    m_csProjectSearchResultForm.CallBackNoticeExport();
                }
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>DBエラー報告コールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CallBackDBError(csEvent); </para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean CallBackDBError(HySEventObject csEvent)
        {
            // イベント情報取り出し
            long lSubEventNo = csEvent.GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();

            String msgboxMsg = null;                
            String strPrjName = null;               
            StringBuilder strBuilder = null;        

            // 登録失敗
            if (lSubEventNo == McDefine.HYM_DB_REGISTER)
            {
                // 登録失敗メッセージ表示
                //String strPrjName = this.GetProjectNameForMessage((HySSimulationDataContainer)csEvent.GetData());
                //MessageBox.Show(strPrjName + MSG_ERROR_DB_REGIST,
                //                    ERROR_MSGBOX_TITLE,
                //                    MessageBoxButtons.OK,
                //                    MessageBoxIcon.Exclamation);

                strPrjName = this.GetProjectNameForMessage((HySSimulationDataContainer)csEvent.GetData());
                strBuilder = new StringBuilder(MSG_ERROR_DB_REGIST);
                strBuilder.Append(strPrjName);
                msgboxMsg = strBuilder.ToString();
                MessageBox.Show(msgboxMsg,MSGBOX_TITLE,MessageBoxButtons.OK,MessageBoxIcon.Error);

                // 入力プロジェクト情報の画面反映
                UpdateProjectProperty();
            }
            // 削除失敗
            else if (lSubEventNo == HySLibraryMngDefine.DB_DELETE_DATA_LIST_BY_ID)
            {
                //MessageBox.Show(MSG_ERROR_DB_DELETE, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                MessageBox.Show(MSG_ERROR_DB_DELETE, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Error);    
            }
            // 検索(リスト)失敗
            else if (lSubEventNo == HySLibraryMngDefine.DB_QUERY_DATA_LIST)
            {
                //MessageBox.Show(MSG_ERROR_DB_SEARCH_LIST, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                MessageBox.Show(MSG_ERROR_DB_SEARCH_LIST, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            // 検索(個別)失敗
            else if (lSubEventNo == HySLibraryMngDefine.DB_QUERY_DATA)
            {
                //MessageBox.Show(MSG_ERROR_DB_SEARCH_PRJDATA, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                MessageBox.Show(MSG_ERROR_DB_SEARCH_PRJDATA, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>コンボボックス選択変更時イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectComboBox.SelectedIndexChanged += new System.EventHandler(this.ProjectComboBox_SelectedIndexChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            // 計算状態に応じて更新
            this.UpdateProjectTabStatus();
            //this.RegistrationProjectBtn.Enabled = true;
            //this.Save_Button.Enabled = true;     // Ver1.1 追加
            //this.NewSave_Button.Enabled = true;  // Ver1.1 追加
        }

        /// <summary><para>method outline:</para>
        /// <para>コンボボックス選択完了時イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectComboBox.SelectionChangeCommitted += new System.EventHandler(this.ProjectComboBox_SelectionChangeCommitted);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectComboBox_SelectionChangeCommitted(object sender, EventArgs e)
        {
            this.ActiveModelForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>表示更新チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckUpdate(csPrcKey);</para>
        /// </example>
        /// <param name="csPrcKey">ユニークキー</param>
        /// <returns>判定結果</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>true:要更新 false:否更新</para>
        /// </remarks>
        public Boolean CheckUpdate(HySString csPrcKey)
        {
            // 該当するプロジェクトデータを取得
            McProjectInfData csProjectInfData = GetProjectInfDataFromTbl(csPrcKey);

            // 該当するプロジェクトデータがない場合は更新できないので否更新とする
            if (csProjectInfData == null)
            {
                // ログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "McDotNetProjectCtlForm.CheckUpdate", 
                    Properties.McDotNetViewerResources.STATEMENT_TERGETID_NO );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "McDotNetProjectCtlForm.CheckUpdate", "TargetID McProjectInfData is not Found");
                return false;
            }
            // 現在表示中のプロジェクトと等しいかチェック
            if (csProjectInfData.Equals(m_csProjectInfData) == false)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>表示更新処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ShowUpdate(csPrcKey);</para>
        /// </example>
        /// <param name="csPrcKey">ユニークキー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowUpdate(HySString csPrcKey)
        {
            // 該当するプロジェクトデータをアクティブに設定
            m_csProjectInfData = GetProjectInfDataFromTbl(csPrcKey);

            // 該当するプロジェクト計算状態をアクティブに設定
            m_csSimulationState = GetSimulationStatusFromTbl(csPrcKey);

            // 該当する計算コントロールタブ情報をアクティブに設定
            m_csSimuTabInfo = (McSimulationTabInfo)m_csSimuTabInfoTbl[csPrcKey.ToString()];

            // プロジェクトプロパティの表示更新処理
            UpdateProjectProperty();

            // 計算コントロールタブ情報更新処理
            LoadSimulationTabInfo();

            // 計算コントロールタブステータス更新処理
            UpdateSimulationTabStatus();

            // プロジェクトタブ更新処理
            UpdateProjectTabStatus();

        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = DeleteProject(csPrcKey);</para>
        /// </example>
        /// <param name="csPrcKey">ユニークキー</param>
        /// <returns>true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean DeleteProject(HySString csPrcKey)
        {
            Boolean bRtn = true;
            ProjectComboBox.Enabled = false; // ST-0011
            // 該当するプロジェクトデータを取得 
            McProjectInfData csProjectInfData = GetProjectInfDataFromTbl(csPrcKey); // メンバ変数に格納
            // プロジェクト名称の取得
            string strPrjName = (csProjectInfData.GetDispProjectName()).ToString();

            // アクティブプロジェクトの識別用キー取得
            HySString actPrjID = this.GetActiveProjectKey();

            if (csPrcKey.Equals(actPrjID) == true)
            {   // アクティブプロジェクトの場合
                // プロジェクトプロパティの表示削除処理 
                for (int i = 0; i < ProjectDataGridView.RowCount; i++)
                {
                    ProjectDataGridView.Rows[i].Cells[1].Value = string.Empty;
                }
            }
            // プロジェクト一覧からの削除
            ProjectComboBox.Items.Remove(strPrjName);

            // 管理プロジェクトデータの削除 
            m_csPrjNameTbl.Remove(strPrjName);
            m_csDataContainerTbl.Remove(csPrcKey.ToString());
            m_csSimuTabInfoTbl.Remove(csPrcKey.ToString());
            m_csProjectStatusTbl.Remove(csPrcKey);
            m_csProjectInfData = null;
            m_csSimulationState = null;
            m_csSimuTabInfo = null;

            // 新しいアクティブプロジェクトの指定
            if (ProjectComboBox.Items.Count != 0)
            {
                ProjectComboBox.SelectedIndex = ProjectComboBox.Items.Count-1;
                bRtn = ActiveModelForm();
            }
            // アクティブプロジェクト無し
            else
            {
                UpdateSimulationTabStatus();
                this.RegistrationProjectBtn.Enabled = false;
                this.Save_Button.Enabled = false;     // Ver1.1 追加
                this.NewSave_Button.Enabled = false;  // Ver1.1 追加
            }
            ProjectComboBox.Enabled = true; // ST-0011
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル管理画面アクティブ化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ActiveModelForm()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean ActiveModelForm()
        {
            // 計算パラメータの保存
            SaveSimulationParameter();

            // プロジェクトIDの取得
            HySString csProjectKey = (HySString)m_csPrjNameTbl[ProjectComboBox.Text];

            // プロジェクト管理画面表示更新
            ShowUpdate(csProjectKey);

            // 選択したプロジェクト名に対応するモデル管理画面をアクティブにさせるイベント
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
            csEventObj.SetSubEventNo(McDefine.HYM_NOTICE_MODEL_SCREEN_ACTIVE);
            // 対象識別情報のセット 
            csEventObj.SetSuppID(m_csProjectInfData.GetProjectID());
            csEventObj.SetToSimKind(m_csProjectInfData.GetSimulatorKind());

            if (false == this.PutEvent(csEventObj))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "ActiveModelForm",
                    Properties.McDotNetViewerResources.STATEMENT_CMND_DISP_NOTICE_ERR);
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "ActiveModelForm", "PutEvent CMND_DISPLY_COMMON(HYM_NOTICE_MODEL_SCREEN_ACTIVE) is failed.");
                return false;
            }

            return true;
        }


        /// <summary><para>method outline:</para>
        /// <para>タイマイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.SimuTimer.Tick += new System.EventHandler(this.SimuTimer_Tick);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuTimer_Tick(object sender, EventArgs e)
        {
            SimulationReportOrder();
        }

        // スレッドタイマー
        # region 方法1
        ///// <summary><para>method outline:</para>
        ///// <para>タイマイベント</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>this.SimuTimer.Tick += new System.EventHandler(this.SimuTimer_Tick);</para>
        ///// </example>
        ///// <param name="obj">object</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //private void SimuThreadTimer_Tick(object obj)
        //{
        //    if (InvokeRequired == true)
        //    {
        //        SimuThreadTimer_Tick_Delegate d_SimuThreadTimer_Tick = new SimuThreadTimer_Tick_Delegate(SimuThreadTimer_Tick);
        //        object[] arg = new object[1];
        //        arg[0] = null;
        //        Invoke(d_SimuThreadTimer_Tick, arg);
        //        return;
        //    }
        //    SimulationReportOrder();
        //}
        # endregion
        # region 方法2
        /// <summary><para>method outline:</para>
        /// <para>スレッドタイマー処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventThreadTimer( obj ) </para>
        /// </example>
        /// <param name="obj"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuThreadTimer_Tick(object obj)
        {
            // 別スレッドから呼ばれる
            //m_bThreadflg = true;
            //if (m_bFormCloseflg == false)
            //{
            try
            {
                m_csAO.Post(m_d_PostCallback, null);
            }
            catch
            {
                // Formオブジェクトが破棄された後にスレッドタイマー処理（別スレッド）
                // からのコールによる例外発生を吸収する(フラグ処理は極力使用しない)
            }
            //}
            //m_bThreadflg = false;
        }
        /// <summary><para>method outline:</para>
        /// <para>タイマーからコールされる処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventThreadTimer( obj ) </para>
        /// </example>
        /// <param name="obj"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuThreadTimer_Work(object obj)
        {
            // Mainスレッドと同じ
            //if (m_bFormCloseflg == true)
            //{
            //    return;
            //}
            SimulationReportOrder();
        }
        # endregion

        /// <summary><para>method outline:</para>
        /// <para>計算進捗状況要求指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.SimulationReportOrder();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimulationReportOrder()
        {
            // 計算進捗状況要求イベント生成 
            if (m_csSimulationState.GetCalcStatus() != McSimulationStatus.CalculationStatus.INITIAL)
            {// アクティブプロジェクトが未計算以外の状態のとき進捗確認
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_REPORT_SIMU_PROGRESS);
                csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
                csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
                if (false == this.PutEvent(csEvent))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationReportOrder", 
                        Properties.McDotNetViewerResources.STATEMENT_SIM_REPORT_ERR );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SimulationReportOrder", "PutEvent CMND_REPORT_SIMU_PROGRESS is failed.");
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>シミュレーション期間設定ラジオボタン選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.SetupCheckBox.CheckedChanged += new System.EventHandler(this.SetupCheckBox_CheckedChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimulationRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            SelectSimulationTermCtl();
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション期間指定コントロール選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SelectSimulationTermCtl()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectSimulationTermCtl()
        {
            // ラジオボタンの選択状態にてシミュレーション期間指定用コントロールの
            // 有効無効を変化させる
            if (SimuDayRadioBtn.Checked)
            {
                // 日付指定が有効
                SimuDayStartTimeDtp.Enabled = true;
                SimuDayEndTimeDtp.Enabled = true;
                SimulationDayLabel.Enabled = true;

                SimuTermStartTimeDtp.Enabled = false;
                SimulationTermEndTime.Enabled = false;
                SimulationTermUnitBox.Enabled = false;
                SimulationTermLabel.Enabled = false;
            }
            else
            {
                // 時間指定が有効
                SimuDayStartTimeDtp.Enabled = false;
                SimuDayEndTimeDtp.Enabled = false;
                SimulationDayLabel.Enabled = false;

                SimuTermStartTimeDtp.Enabled = true;
                SimulationTermEndTime.Enabled = true;
                SimulationTermUnitBox.Enabled = true;
                SimulationTermLabel.Enabled = true;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>タブ選択時イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PrjTabControl.Selecting += new System.Windows.Forms.TabControlCancelEventHandler(this.PrjTabControl_Selecting);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjTabControl_Selecting(object sender, TabControlCancelEventArgs e)
        {
            // 計算中はプロジェクトタブを表示しない
            //if ((m_csSimuTabDispState == SIMULATION_RUN) && (e.TabPageIndex == 0))
            //{
            //    e.Cancel = true;
            //}
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトプロパティ表示更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>UpdateProjectProperty();</para>
        /// </example>
        ///  <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpdateProjectProperty()
        {
            // プロジェクト一覧から現在のプロジェクト名を選択
            ProjectComboBox.Text = (m_csProjectInfData.GetDispProjectName()).ToString();

            // プロジェクトプロパティの表示更新処理
            if ((object)m_csProjectInfData.GetProjectGroupName() != null)
            {
                // プロジェクトグループ名
                ProjectDataGridView.Rows[0].Cells[1].Value = (m_csProjectInfData.GetProjectGroupName()).ToString();
            }
            if ((object)m_csProjectInfData.GetProjectName() != null)
            {
                // プロジェクト名
                ProjectDataGridView.Rows[1].Cells[1].Value = (m_csProjectInfData.GetProjectName()).ToString();
            }
            if ((object)m_csProjectInfData.GetAdminName() != null)
            {
                // 管理者名
                ProjectDataGridView.Rows[2].Cells[1].Value = (m_csProjectInfData.GetAdminName()).ToString();
            }
            if ((object)m_csProjectInfData.GetModelType() != null)
            {
                // 種別
                ProjectDataGridView.Rows[3].Cells[1].Value = (m_csProjectInfData.GetModelType()).ToString();
            }
            if ((object)m_csProjectInfData.GetModelTarget() != null)
            {
                // 対象
                ProjectDataGridView.Rows[4].Cells[1].Value = (m_csProjectInfData.GetModelTarget()).ToString();
            }
            if ((object)m_csProjectInfData.GetModelCalcType() != null)
            {
                // モデル
                ProjectDataGridView.Rows[5].Cells[1].Value = (m_csProjectInfData.GetModelCalcType()).ToString();
            }
            if ((object)m_csProjectInfData.GetModelSubject() != null)
            {
                // 件名
                ProjectDataGridView.Rows[6].Cells[1].Value = (m_csProjectInfData.GetModelSubject()).ToString();
            }
            if ((object)m_csProjectInfData.GetModelSituation() != null)
            {
                // ケース名
                ProjectDataGridView.Rows[7].Cells[1].Value = (m_csProjectInfData.GetModelSituation()).ToString();
            }
            if (m_csProjectInfData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.REGULARITY)
            {
                // 定常
                //ProjectDataGridView.Rows[7].Cells[1].Value = "定常";
                ProjectDataGridView.Rows[8].Cells[1].Value = Properties.McDotNetViewerResources.DATE_ROUTINE;
            }
            else if (m_csProjectInfData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.PERIOD)
            {
                // 期間
                string strFrom = HySCalendar.GetString(((HySTime)m_csProjectInfData.GetModelPeriod().GetFrom()), HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                string strTo = HySCalendar.GetString(((HySTime)m_csProjectInfData.GetModelPeriod().GetTo()), HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                string strCreate = strFrom.Substring(0, strFrom.IndexOf(" ")) +
                    Properties.McDotNetViewerResources.DATE_TO +
                    strTo.Substring(0, strTo.IndexOf(" "));
                ProjectDataGridView.Rows[8].Cells[1].Value = strCreate;
            }
            if ((object)m_csProjectInfData.GetThresholdCondition1() != null)
            {
                // 境界条件１
                ProjectDataGridView.Rows[9].Cells[1].Value = (m_csProjectInfData.GetThresholdCondition1()).ToString();
            }
            if ((object)m_csProjectInfData.GetThresholdCondition2() != null)
            {
                // 境界条件２
                ProjectDataGridView.Rows[10].Cells[1].Value = (m_csProjectInfData.GetThresholdCondition2()).ToString();
            }
            if ((object)m_csProjectInfData.GetThresholdCondition3() != null)
            {
                // 境界条件３
                ProjectDataGridView.Rows[11].Cells[1].Value = (m_csProjectInfData.GetThresholdCondition3()).ToString();
            }
            if ((object)m_csProjectInfData.GetThresholdCondition4() != null)
            {
                // 境界条件４
                ProjectDataGridView.Rows[12].Cells[1].Value = (m_csProjectInfData.GetThresholdCondition4()).ToString();
            }
            if ((object)m_csProjectInfData.GetThresholdCondition5() != null)
            {
                // 境界条件５
                ProjectDataGridView.Rows[13].Cells[1].Value = (m_csProjectInfData.GetThresholdCondition5()).ToString();
            }
            if ((object)m_csProjectInfData.GetCondition1() != null)
            {
                // 条件１
                ProjectDataGridView.Rows[14].Cells[1].Value = (m_csProjectInfData.GetCondition1()).ToString();
            }
            if ((object)m_csProjectInfData.GetCondition2() != null)
            {
                // 条件２
                ProjectDataGridView.Rows[15].Cells[1].Value = (m_csProjectInfData.GetCondition2()).ToString();
            }
            if ((object)m_csProjectInfData.GetCondition3() != null)
            {
                // 条件３
                ProjectDataGridView.Rows[16].Cells[1].Value = (m_csProjectInfData.GetCondition3()).ToString();
            }
            if ((object)m_csProjectInfData.GetCondition4() != null)
            {
                // 条件４
                ProjectDataGridView.Rows[17].Cells[1].Value = (m_csProjectInfData.GetCondition4()).ToString();
            }
            if ((object)m_csProjectInfData.GetCondition5() != null)
            {
                // 条件５
                ProjectDataGridView.Rows[18].Cells[1].Value = (m_csProjectInfData.GetCondition5()).ToString();
            }
            if ((object)m_csProjectInfData.GetStartSimuTime() != null)
            {
                // 計算開始時刻
                //ProjectDataGridView.Rows[18].Cells[1].Value = (HySCalendar.ToString(m_csProjectInfData.GetStartSimuTime(), 0));
                ProjectDataGridView.Rows[19].Cells[1].Value = (HySCalendar.ToString(m_csProjectInfData.GetStartSimuTime(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
            }
            if ((object)m_csProjectInfData.GetEndSimuTime() != null)
            {
                // 計算終了時刻
                //ProjectDataGridView.Rows[19].Cells[1].Value = (HySCalendar.ToString(m_csProjectInfData.GetEndSimuTime(), 0));
                ProjectDataGridView.Rows[20].Cells[1].Value = (HySCalendar.ToString(m_csProjectInfData.GetEndSimuTime(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
            }
            if ((object)m_csProjectInfData.GetSuspendTime() != null)
            {
                // 計算中断時刻
                //ProjectDataGridView.Rows[20].Cells[1].Value = (HySCalendar.ToString(m_csProjectInfData.GetSuspendTime(), 0));
                ProjectDataGridView.Rows[21].Cells[1].Value = (HySCalendar.ToString(m_csProjectInfData.GetSuspendTime(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
            }
            if ((object)m_csProjectInfData.GetComment() != null)
            {
                // 備考
                ProjectDataGridView.Rows[22].Cells[1].Value = (m_csProjectInfData.GetComment()).ToString();
            }
            if ((object)m_csProjectInfData.GetCreateDate() != null)
            {
                // 作成日
                //string strCreate = (HySCalendar.ToString(m_csProjectInfData.GetCreateDate(), 0));
                string strCreate = (HySCalendar.ToString(m_csProjectInfData.GetCreateDate(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                ProjectDataGridView.Rows[23].Cells[1].Value = strCreate.Substring(0, strCreate.IndexOf(" "));
            }
            if ((object)m_csProjectInfData.GetRegistDate() != null)
            {
                // 登録日
                //string strRegist = (HySCalendar.ToString(m_csProjectInfData.GetRegistDate(), 0));
                string strRegist = (HySCalendar.ToString(m_csProjectInfData.GetRegistDate(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                ProjectDataGridView.Rows[24].Cells[1].Value = strRegist.Substring(0, strRegist.IndexOf(" "));
            }
            if ((object)m_csProjectInfData.GetUpdateDate() != null)
            {
                // 更新日
                //string strUpdate = (HySCalendar.ToString(m_csProjectInfData.GetUpdateDate(), 0));
                string strUpdate = (HySCalendar.ToString(m_csProjectInfData.GetUpdateDate(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                ProjectDataGridView.Rows[25].Cells[1].Value = strUpdate.Substring(0, strUpdate.IndexOf(" "));
            }
        }

        // バックグラウンド操作化
        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブステータス変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ChangeSimulationTabStatus();</para>
        /// </example>
        /// <param name="bflg">bool true:有効 false:無効</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ChangeSimulationTabStatus(bool bflg)
        {
            if (bflg == true)
            {
                m_bExtDBToolStateFlg = false;
                this.UpdateSimulationTabStatus();
            }
            else
            {
                m_bExtDBToolStateFlg = true;
                ChangeSimulationTabCtlEnabled(false, false, false, false, false, false, false);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>外部データベースツール起動状態取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetExtDBToolStatus();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:起動中 false:停止中</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetExtDBToolStatus()
        {
            return m_bExtDBToolStateFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブステータス更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>UpdateSimulationTabStatus();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void UpdateSimulationTabStatus()
        {
            //// バックグラウンド操作化
            //if (m_bExtDBToolStateFlg == true)
            //{
            //    return;
            //}
            // 計算コントロールタブステータスの設定
            SetStatus();
            // 画面に文字列を設定
            SimulationStatusBox.Text = m_csSimuTabDispState.ToString();


            // 未計算
            if (m_csSimuTabDispState == SIMULATION_NOT_RUN)
            {
                ChangeSimulationTabCtlEnabled(true, false, false, false, false, true, true);
                // 計算状況リセット
                SimulationProgressBar.Value = 0;
                CurrentTimeBox.Text = string.Empty;
                m_csCurrentTime = null;
            }
            // 計算中
            else if (m_csSimuTabDispState == SIMULATION_RUN)
            {
                ChangeSimulationTabCtlEnabled(false, true, true, false, true, false, false);
            }
            // 中断
            else if (m_csSimuTabDispState == SIMULATION_SUSPEND)
            {
                ChangeSimulationTabCtlEnabled(true, false, true, false, false, true, true);
                // 計算状況要求指示
                SimulationReportOrder();
            }
            // 計算完了
            else if (m_csSimuTabDispState == SIMULATION_FINISH)
            {
                ChangeSimulationTabCtlEnabled(true, false, false, true, false, true, true);
                // 計算状況要求指示
                SimulationReportOrder();

            }
            // 上記以外
            else 
            {
                ChangeSimulationTabCtlEnabled(false, false, false, false, false, false, false);
                // 計算状況リセット
                SimulationProgressBar.Value = 0;
                CurrentTimeBox.Text = string.Empty;
                m_csCurrentTime = null;
            }
            // イベント待ち状態の解除
            PrjTabControl.Enabled = true;

            // バックグラウンド操作化
            if (m_bExtDBToolStateFlg == true)
            {
                RunBtn.Enabled = false;
                SuspendBtn.Enabled = false;
                StopBtn.Enabled = false;
                ResetBtn.Enabled = false;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトタブステータス更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>UpdateProjectTabStatus();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void UpdateProjectTabStatus()
        {
            // 計算ステータスの設定
            SetStatus();

            // 未計算
            if (m_csSimuTabDispState == SIMULATION_NOT_RUN)
            {
                this.RegistrationProjectBtn.Enabled = true;
                this.Save_Button.Enabled = true;     // Ver1.1 追加
                this.NewSave_Button.Enabled = true;  // Ver1.1 追加
            }
            // 計算中
            else if (m_csSimuTabDispState == SIMULATION_RUN)
            {
                this.RegistrationProjectBtn.Enabled = false;
                this.Save_Button.Enabled = false;     // Ver1.1 追加
                this.NewSave_Button.Enabled = false;  // Ver1.1 追加
            }
            // 中断
            else if (m_csSimuTabDispState == SIMULATION_SUSPEND)
            {
                this.RegistrationProjectBtn.Enabled = true;
                this.Save_Button.Enabled = true;     // Ver1.1 追加
                this.NewSave_Button.Enabled = true;  // Ver1.1 追加
            }
            // 計算完了
            else if (m_csSimuTabDispState == SIMULATION_FINISH)
            {
                this.RegistrationProjectBtn.Enabled = true;
                this.Save_Button.Enabled = true;     // Ver1.1 追加
                this.NewSave_Button.Enabled = true;  // Ver1.1 追加
            }
            // 上記以外
            else
            {
                this.RegistrationProjectBtn.Enabled = false;
                this.Save_Button.Enabled = false;     // Ver1.1 追加
                this.NewSave_Button.Enabled = false;  // Ver1.1 追加
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブコントロール有効無効変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ChangeSimulationTabCtlEnabled(true, false, false, false, false, true, true ); </para>
        /// </example>
        /// <param name="isRunBtn">開始/再開ボタン有効無効可否</param>
        /// <param name="isSuspendBtn">中断ボタン有効無効可否</param>
        /// <param name="isStopBtn">終了ボタン有効無効可否</param>
        /// <param name="isResetBtn">リセットボタン有効無効可否</param>
        /// <param name="isTimer">タイマー有効無効可否</param>
        /// <param name="isSimuTermGrp">シミュレーション期間グループ有効無効可否</param>
        /// <param name="isSuspendTimeGrp">中断時刻グループ有効無効可否</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ChangeSimulationTabCtlEnabled(Boolean isRunBtn, Boolean isSuspendBtn, Boolean isStopBtn, Boolean isResetBtn,
                                                    Boolean isTimer, Boolean isSimuTermGrp, Boolean isSuspendTimeGrp)
        {
            // 受け取った引数により各コントロールの状態を変更する
            RunBtn.Enabled = isRunBtn;
            SuspendBtn.Enabled = isSuspendBtn;
            StopBtn.Enabled = isStopBtn;
            ResetBtn.Enabled = isResetBtn;
            //SimuTimer.Enabled = isTimer;
            // スレッドタイマー
            if (isTimer == true)
            {
                m_csThreadTimerInstance.Change(0, 500);
            }
            else
            {
                m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            }
            SimulationTermGroup.Enabled = isSimuTermGrp;
            // シミュレーション期間入力グループ有効無効変更
            ChangeSimulationTermGroup();
            SuspendTimeGroup.Enabled = isSuspendTimeGrp;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション期間入力グループ有効無効変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ChangeSimulationTermGroup(); </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ChangeSimulationTermGroup()
        {
            // 中断状態時のみ入力可能開始時刻を入力不可にする
            if (m_csSimuTabDispState == SIMULATION_SUSPEND)
            {
                if (SimuDayRadioBtn.Checked == true)
                {
                    SimuDayStartTimeDtp.Enabled = false;
                    SimuTermRadioBtn.Enabled = false;

                }
                else
                {
                    SimuTermStartTimeDtp.Enabled = false;
                    SimuDayRadioBtn.Enabled = false;
                }
            }
            // それ以外
            else
            {
                if (SimuDayRadioBtn.Checked == true)
                {
                    SimuDayStartTimeDtp.Enabled = true;
                    SimuTermRadioBtn.Enabled = true;

                }
                else
                {
                    SimuTermStartTimeDtp.Enabled = true;
                    SimuDayRadioBtn.Enabled = true;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>タイムステップ単位変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>TransTimeStepUnit(ref lTimeStep, ref strUnit);</para>
        /// </example>
        /// <param name="lTimeStep">タイムステップ値</param>
        /// <param name="strUnit">タイムステップ単位文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 受け取ったタイムステップ値（単位：秒）と単位文字列を
        /// 日、時、分、秒の中から整数値で表せる最大の単位に変換する
        /// </para>
        /// </remarks>
        private void TransTimeStepUnit(ref long lTimeStep, ref string strUnit)
        {
            // 単位文字列の設定（初期値：「秒」)
            strUnit = STR_UNIT_SEC;

            // 単位変換係数配列
            long[] lTransUnitArray = { SEC_PER_DAY,  // 秒/日
                                       SEC_PER_HOUR, // 秒/時
                                       SEC_PER_MIN   // 秒/分
                                      };
            // 単位文字列配列
            string[] strUnitArray = { STR_UNIT_DAY, // 「日」 
                                      STR_UNIT_HOUR,// 「時」
                                      STR_UNIT_MIN  // 「分」
                                    　};

            // 日,時,分の単位の整数で表せるかチェック
            for (int i = 0; i < lTransUnitArray.Length; i++)
            {
                // 変換係数で割り切れるかどうかを判定する
                if ((lTimeStep % lTransUnitArray[i]) == 0)
                {
                    strUnit = strUnitArray[i];
                    lTimeStep = lTimeStep / lTransUnitArray[i];
                    break;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻値の秒変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>TransTimeToSec(ref long lTimeValue, string strUnit);</para>
        /// </example>
        /// <param name="lTimeValue">時刻値</param>
        /// <param name="strUnit">単位文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TransTimeToSec(ref long lTimeValue, string strUnit)
        {
            // 単位「分」
            if (strUnit == STR_UNIT_MIN)
            {
                lTimeValue = lTimeValue * SEC_PER_MIN;
            }
            // 単位「時」
            else if (strUnit == STR_UNIT_HOUR)
            {
                lTimeValue = lTimeValue * SEC_PER_HOUR;
            }
            // 単位「日」
            else if (strUnit == STR_UNIT_DAY)
            {
                lTimeValue = lTimeValue * SEC_PER_DAY;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>タブ切り替えイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.PrjTabControl.SelectedIndexChanged += new System.EventHandler(this.TabControl_SelectedIndexChanged);</para>
        /// </example>
        /// <param name="sender">sender</param>
        /// <param name="e">e</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            // 計算パラメータの保存
            SaveSimulationParameter();
        }

        /// <summary><para>method outline:</para>
        /// <para>計算パラメータ保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SaveSimulationParameter();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SaveSimulationParameter()
        {
            HySTime csStartTime = null;
            HySTime csEndTime = null;
            HySTime csSuspendTime = null;

            // カレントプロジェクトがある場合には保存実行
            if (m_csProjectInfData != null)
            {
                // 計算コントロールタブの情報保存
                SaveSimulationTabInfo();

                // 計算パラメータの取得
                GetSimulationParameter(ref csStartTime, ref csEndTime, ref csSuspendTime);

                // アクティブデータクラスに保存
                m_csProjectInfData.SetStartSimuTime(csStartTime);
                m_csProjectInfData.SetEndSimuTime(csEndTime);
                m_csProjectInfData.SetSuspendTime(csSuspendTime);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>計算パラメータ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetSimulationParameter(ref csStartTime, ref csEndTime, ref csSuspendTime);</para>
        /// </example>
        /// <param name="csStartTime">開始時刻</param>
        /// <param name="csEndTime">終了時刻</param>
        /// <param name="csSuspendTime">中断時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetSimulationParameter(ref HySTime csStartTime, ref HySTime csEndTime, ref HySTime csSuspendTime)
        {
            if (SimuDayRadioBtn.Checked == true)// シミュレーション期間設定項目（上段）
            {
                // シミュレーション期間の取得(開始) 
                csStartTime = TransDateTimeToHySTime(SimuDayStartTimeDtp.Value);
                // シミュレーション期間の取得(終了) 
                csEndTime = TransDateTimeToHySTime(SimuDayEndTimeDtp.Value);

            }
            else                                 // シミュレーション期間設定項目（下段）
            {
                // シミュレーション期間の取得(開始) 
                csStartTime = TransDateTimeToHySTime(SimuTermStartTimeDtp.Value);
                // シミュレーション期間の取得(終了) 
                long lValue = 0;
                Int64.TryParse(SimulationTermEndTime.Text, out lValue);
                if (lValue < 0)// 0未満の場合
                {
                    lValue = 0;
                }
                TransTimeToSec(ref lValue, SimulationTermUnitBox.Text);
                csEndTime = new HySTime(lValue);
                csEndTime.Add(csStartTime);
            }

            if (SuspendCheckBox.Checked == true)   // 中断時刻設定が有効な場合
            {
                // 中断時刻の取得 
                csSuspendTime = TransDateTimeToHySTime(SimuSuspendTimeDtp.Value);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>DateTime型時刻変換処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime csTime = TransDateTimeToHySTime(DateTime csDate);</para>
        /// </example>
        /// <param name="csDate">csDate</param>
        /// <returns>日付クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySTime TransDateTimeToHySTime(DateTime csDate)
        {
            // 各値の取得
            long lYear = (long)csDate.Year;
            long lMonth = (long)csDate.Month;
            long lDate = (long)csDate.Day;
            long lHour = (long)csDate.Hour;
            long lMinute = (long)csDate.Minute;
            long lSecond = (long)csDate.Second;
            HySTime csTime = new HySTime(lHour, lMinute, lSecond);
            HySCalendar.SetTime(ref csTime, lYear, lMonth, lDate, lHour, lMinute, lSecond);

            return csTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトIDオープンチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = CheckProjectIsOpen(csPrcKey);</para>
        /// </example>
        /// <param name="csPrcKey">ユニークキー</param>
        /// <returns>判定結果</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>true:済オープン false:未オープン</para>
        /// </remarks>
        public Boolean CheckProjectIsOpen(HySString csPrcKey)
        {
            // プロジェクト取り込みシーケンス中であるか
            if (((McDotNetProjectCtlScreen)m_csScreen).IsIncorporateProject() == true)
            {
                // プロジェクト取り込みシーケンス中は未オープン扱い
                return false;
            }

            // データコンテナ管理テーブルから指定IDで情報を取得できるか
            if (m_csDataContainerTbl[csPrcKey.ToString()] == null)
            {
                // 未オープン
                return false;
            }
            else
            {
                // 済オープン
                return true;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ステータス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csStatus = GetStatus();</para>
        /// </example>
        /// <returns>ステータス文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetStatus()
        {
            //現在の計算ステータスを取得
            return m_csSimuTabDispState;
        }

        /// <summary><para>method outline:</para>
        /// <para>ステータス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStatus();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>アクティブプロジェクトの状態から現在の画面ステータスを設定する</para>
        /// </remarks>
        private void SetStatus()
        {
            // アクティブプロジェクト無し
            if (m_csSimulationState == null)
            {
                // 「プロジェクト無し」に設定
                m_csSimuTabDispState = NO_ACTIVE_PROJECT;
            }
            else
            {
                // 計算状態取得
                McSimulationStatus.CalculationStatus csCalcStatus = m_csSimulationState.GetCalcStatus();
                // 未計算
                if (csCalcStatus == McSimulationStatus.CalculationStatus.INITIAL)
                {
                    // 「未計算」に設定
                    m_csSimuTabDispState = SIMULATION_NOT_RUN;
                }
                // 計算中
                else if (csCalcStatus == McSimulationStatus.CalculationStatus.CALCULATING)
                {
                    // 「計算中」に設定
                    m_csSimuTabDispState = SIMULATION_RUN;
                }
                // 中断
                else if (csCalcStatus == McSimulationStatus.CalculationStatus.INTERRUPTED)
                {
                    // 「中断」に設定
                    m_csSimuTabDispState = SIMULATION_SUSPEND;
                }
                // 計算終了、計算強制終了
                else if ((csCalcStatus == McSimulationStatus.CalculationStatus.FINISHED)
                  || (csCalcStatus == McSimulationStatus.CalculationStatus.FINISHED_STOP))
                {
                    // 「計算終了」に設定
                    m_csSimuTabDispState = SIMULATION_FINISH;
                }
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブ情報作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSimulationTabInfo csSimuTabInfo = CreateSimulationTabInfo(csPrjInfData)</para>
        /// </example>
        /// <param name="csPrjInfData">プロジェクト情報</param>
        /// <returns>計算コントロールタブ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McSimulationTabInfo CreateSimulationTabInfo(McProjectInfData csPrjInfData)
        {
            McSimulationTabInfo csSimuTabInfo = new McSimulationTabInfo();
            string strWk;

            // 計算開始時刻(上段）
            if (csPrjInfData.GetStartSimuTime() != null)
            {
                strWk = HySCalendar.ToString( csPrjInfData.GetStartSimuTime(),0);
                csSimuTabInfo.SetDayStartTime(DateTime.Parse(strWk));
            }
            else
            {
                csSimuTabInfo.SetDayStartTime(DateTime.Today);
            }
            // 計算終了時刻(上段）
            if (csPrjInfData.GetEndSimuTime() != null)
            {
                strWk = HySCalendar.ToString(csPrjInfData.GetEndSimuTime(), 0);
                csSimuTabInfo.SetDayEndTime(DateTime.Parse(strWk));
            }
            else
            {
                csSimuTabInfo.SetDayEndTime(DateTime.Today);
            }

            // 下段の開始時刻は上段と合わせる
            csSimuTabInfo.SetTermStartTime(csSimuTabInfo.GetDayStartTime());

            // 中断時刻
            if (csPrjInfData.GetSuspendTime() != null)
            {
                // 中断時刻チェック
                csSimuTabInfo.SetSuspendCheck(true);
                // 中断時刻
                strWk = HySCalendar.ToString(csPrjInfData.GetSuspendTime(), 0);
                csSimuTabInfo.SetSuspendTime(DateTime.Parse(strWk));
            }
            else
            {
                // 中断時刻チェック
                csSimuTabInfo.SetSuspendCheck(false);
                // 中断時刻
                strWk = HySCalendar.ToString(csPrjInfData.GetSuspendTime(), 0);

                //csSimuTabInfo.SetSuspendTime( (DateTime.Today  ) );
                //DateTime csDatatime = DateTime.Now;
                //csSimuTabInfo.SetSuspendTime( new DateTime(csDatatime.Year, csDatatime.Month, csDatatime.Day, csDatatime.Hour + 1, 0, 0) );
                DateTime csDatatime = csSimuTabInfo.GetDayStartTime();
                DateTime csSuspDatatime = new DateTime(csDatatime.Year, csDatatime.Month, csDatatime.Day, csDatatime.Hour, 0, 0);
                csSimuTabInfo.SetSuspendTime(csSuspDatatime.AddHours(1));
            }
            /*
            // タイムステップ
            if (csPrjInfData.GetDeltaTime() != null)
            {
                long lTimeStep = (long)csPrjInfData.GetDeltaTime().GetTime();
                string strUnit = STR_UNIT_SEC;
                TransTimeStepUnit(ref lTimeStep, ref strUnit);

                csSimuTabInfo.SetTimeStep(lTimeStep.ToString());
                csSimuTabInfo.SetTimeStepUnit(strUnit);
            }
            */

            return csSimuTabInfo;

        }

        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブ情報保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SaveSimulationTabInfo();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SaveSimulationTabInfo()
        {
            // ラジオボタン選択状態
            if (SimuDayRadioBtn.Checked == true)
            {
                m_csSimuTabInfo.SetSelectRadioBtnIndex(0L);
            }
            else
            {
                m_csSimuTabInfo.SetSelectRadioBtnIndex(1L);
            }

            // 開始時刻（上段）
            m_csSimuTabInfo.SetDayStartTime( SimuDayStartTimeDtp.Value);
            // 終了時刻（上段）
            m_csSimuTabInfo.SetDayEndTime( SimuDayEndTimeDtp.Value);
            // 開始時刻（下段）
            m_csSimuTabInfo.SetTermStartTime( SimuTermStartTimeDtp.Value);
            // 計算期間値（下段）
            m_csSimuTabInfo.SetTermEndTime( SimulationTermEndTime.Text);
            // 計算期間単位（下段）
            m_csSimuTabInfo.SetTermUnit(SimulationTermUnitBox.Text);
            // 中断時刻チェック
            m_csSimuTabInfo.SetSuspendCheck(SuspendCheckBox.Checked);
            // 中断時刻
            m_csSimuTabInfo.SetSuspendTime(SimuSuspendTimeDtp.Value);
            // タイムステップ値
            m_csSimuTabInfo.SetTimeStep(TimeStepBox.Text);
            // タイムステップ単位
            m_csSimuTabInfo.SetTimeStepUnit(TimeStepUnitBox.Text);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算コントロールタブ情報反映</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>LoadSimulationTabInfo();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LoadSimulationTabInfo()
        {
            // ラジオボタン選択状態
            if (m_csSimuTabInfo.GetSelectRadioBtnIndex() == 0L)
            {
                SimuDayRadioBtn.Checked = true;
                SimuDayRadioBtn.Focus();
            }
            else
            {
                SimuTermRadioBtn.Checked = true;
                SimuTermRadioBtn.Focus();
            }

            // 開始時刻（上段）
            SimuDayStartTimeDtp.Value = m_csSimuTabInfo.GetDayStartTime();
            // 終了時刻（上段）
            SimuDayEndTimeDtp.Value  = m_csSimuTabInfo.GetDayEndTime();
            // 開始時刻（下段）
            SimuTermStartTimeDtp.Value = m_csSimuTabInfo.GetTermStartTime();
            // 計算期間値（下段）
            SimulationTermEndTime.Text = m_csSimuTabInfo.GetTermEndTime();
            // 計算期間単位（下段）
            SimulationTermUnitBox.Text = m_csSimuTabInfo.GetTermUnit();
            // 中断時刻チェック
            SuspendCheckBox.Checked = m_csSimuTabInfo.GetSuspendCheck();
            // 中断時刻
            SimuSuspendTimeDtp.Value = m_csSimuTabInfo.GetSuspendTime();
            // タイムステップ値
            TimeStepBox.Text = m_csSimuTabInfo.GetTimeStep();
            // タイムステップ単位
            TimeStepUnitBox.Text = m_csSimuTabInfo.GetTimeStepUnit();
        }

        /// <summary><para>method outline:</para>
        /// <para>管理テーブルからのプロジェクト情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McProjectInfData csPrjInfData = GetProjectInfDataFromTbl(csPrcKey);</para>
        /// </example>
        /// <param name="csPrcKey">ユニークキー</param>
        /// <returns>プロジェクト情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得に失敗した場合nullが返却される</para>
        /// </remarks>
        private McProjectInfData GetProjectInfDataFromTbl(HySString csPrcKey)
        {
            const string strMethodName = "GetProjectInfDataFromTbl";

            McProjectInfData csRtnPrjInf = null;
            HySSimulationDataContainer csDataCont = m_csDataContainerTbl[csPrcKey.ToString()] as HySSimulationDataContainer;
            if (csDataCont == null)
            {
               // ver1.5 エラートレース日本語対応
                string strErrMsg = Properties.McDotNetViewerResources.STATEMENT_SMSG_021 + "[" + csPrcKey.ToString() + "]";
               // string strErrMsg = "HySSimulationDataContainer is not found. key Value = [" + csPrcKey.ToString() + "]";
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName, strErrMsg);
            }
            else
            {
                csRtnPrjInf = csDataCont.GetData(McDefine.HYM_DATA_PROJECT_INFO) as McProjectInfData;
            }

            return csRtnPrjInf;
        }

        /// <summary><para>method outline:</para>
        /// <para>管理テーブルからのシミュレーション状態取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McProjectInfData csPrjInfData = GetProjectInfDataFromTbl(csPrcKey);</para>
        /// </example>
        /// <param name="csPrcKey">ユニークキー</param>
        /// <returns>シミュレーション状態</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得に失敗した場合nullが返却される</para>
        /// </remarks>
        private McSimulationStatus GetSimulationStatusFromTbl(HySString csPrcKey)
        {
            const string strMethodName = "GetSimulationStatusFromTbl";

            McSimulationStatus csRtnSimuState = null;
            HySSimulationDataContainer csDataCont = m_csDataContainerTbl[csPrcKey.ToString()] as HySSimulationDataContainer;
            if (csDataCont == null)
            {
              // ver1.5 エラートレース日本語対応
                string strErrMsg = Properties.McDotNetViewerResources.STATEMENT_SMSG_021 + "[" + csPrcKey.ToString() + "]";
               // string strErrMsg = "HySSimulationDataContainer is not found. key Value = [" + csPrcKey.ToString() + "]";
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, strMethodName, strErrMsg);
            }
            else
            {
                csRtnSimuState = csDataCont.GetData(McDefine.HYM_DATA_SIMULATION_INFO) as McSimulationStatus;
            }

            return csRtnSimuState;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }
        
        /// <summary><para>method outline:</para>
        /// <para>メッセージ表示用のプロジェクト名称を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csProjectName = GetProjectNameForMessage(csContainer);</para>
        /// </example>
        /// <param name="csPrcKey">プロジェクト識別子</param>
        /// <returns>プロジェクト名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロジェクト名称がある場合はメッセージ表示用の形式に変換し文字列が返却される。
        /// プロジェクト名称が無い場合は空文字が返却される。</para>
        /// </remarks>
        private String GetProjectNameForMessage(HySString csPrcKey)
        {
            HySSimulationDataContainer csContainer =
                    (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey.ToString()];
            if(csContainer == null)
            {   // 該当するプロジェクトが存在しない場合
                return new HySString("").ToString();
            }
            return GetProjectNameForMessage(csContainer);
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージ表示用のプロジェクト名称を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csProjectName = GetProjectNameForMessage(csContainer);</para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>プロジェクト名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロジェクト名称がある場合はメッセージ表示用の形式に変換し文字列が返却される。
        /// プロジェクト名称が無い場合は空文字が返却される。</para>
        /// </remarks>
        private String GetProjectNameForMessage(HySSimulationDataContainer csContainer)
        {
            String strPrjName = GetProjectName(csContainer);
            //if (strPrjName.Length != 0)
            //{   // プロジェクト名称がある場合
                //strPrjName = MSG_PROJECT_NAME_FOR_MESSAGE_FRONT + strPrjName + MSG_PROJECT_NAME_FOR_MESSAGE_BACK;
            //    strPrjName = strPrjName;
            //}

            return strPrjName;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名称を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csProjectName = GetProjectName(csContainer);</para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>プロジェクト名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示用プロジェクト名称が存在しない場合は、実際のプロジェクト名称が返却される。
        /// 実際のプロジェクト名称も存在しない場合は空文字が返却される。</para>
        /// </remarks>
        private String GetProjectName(HySSimulationDataContainer csContainer)
        {
            McProjectInfData csProjectInfo = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
            HySString csPrjName = new HySString("");

            // プロジェクトIDに対応するプロジェクトが開かれているか
            HySString csPrcKey = new HySString(csProjectInfo.GetSimulatorKind().ToString() + csProjectInfo.GetProjectID().ToString());
            if (m_csPrjNameTbl.ContainsValue(csPrcKey))
            {   // 開かれている場合
                csPrjName = csProjectInfo.GetDispProjectName();
                if ((object)csPrjName == null || csPrjName.GetLength() == 0)
                {   // 表示名称が無い場合
                    csPrjName = csProjectInfo.GetProjectName();
                }
            }
            else
            {   // 開かれていない場合
                // Ver1.1 変更 >>>
                //csPrjName = csProjectInfo.GetProjectName();
                if (csProjectInfo.GetProjectGroupName().Equal(new HySString("")) == true && csProjectInfo.GetProjectName().Equal(new HySString("")) == true)
                {// 名称無し
                    csPrjName = new HySString("");
                }
                else
                {// 名称有り
                    csPrjName = csProjectInfo.GetProjectGroupName() + "_" + csProjectInfo.GetProjectName();
                }
                // Ver1.1 変更 <<<
            }

            return csPrjName.ToString();
        }

        /// <summary><para>method outline:</para>
        /// <para>アクティブプロジェクトであるかを判定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool isActiveProject = IsActiveProject( ) </para>
        /// </example>
        /// <param name="csID">プロジェクト識別子</param>
        /// <returns>true:=アクティブプロジェクト, false:=非アクティブプロジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool IsActiveProject(HySID csID)
        {
            // アクティブプロジェクトID取得
            HySID actID = m_csProjectInfData.GetProjectID();
            return actID != null && csID.Equals(actID);
        }
        
        /// <summary><para>method outline:</para>
        /// <para>アクティブプロジェクトの識別用キーを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString actPrjKey = GetActiveProjectKey( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブプロジェクトの識別用キー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySString GetActiveProjectKey()
        {
            // プロジェクト情報からプロジェクトの識別用キーを作成する
            HySID csID = m_csProjectInfData.GetProjectID();
            HySObjectKind csSimKind = (HySObjectKind)m_csProjectInfData.GetSimulatorKind();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString actPrjID = (HySString)csID.GetString();
            return csPrcKind + actPrjID;
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0001,
                        ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }

// Ver1.1 追加 >>>
        /// <summary><para>method outline:</para>
        /// <para>開くボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NewProjectFileBtn.Click += new System.EventHandler(this.NewProjectFile_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OpenProject_Click(object sender, EventArgs e)
        {
            // 検索結果応答を「プロジェクトオープン」に設定
            ((McDotNetProjectCtlScreen)m_csScreen).SetQueryResponceEvent(HySEventObject.CMND_NEW_SIMULATOR_CREATE);

            OpenProject();
        }
        
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトファイルオープンメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = OpenProject() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long OpenProject()
        {
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加 プロジェクトの削除機能
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            McDotNetProjectFileDialog csOpenFileDlg = new McDotNetProjectFileDialog(
                                                            HySEnvInf.GetDataHomeDirectory(),
                                                            (Hashtable)m_csDataContainerTbl.Clone()
                                                            );


            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {// ファイル指定
                //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加 プロジェクトに関するエラーメッセージ出力機能
                //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
                // プロジェクトグループの妥当性確認
                // 実際のプロジェクトグループフォルダ名の確認
                HySString csGrFolderName_Test = csOpenFileDlg.GetProjectGroupName();
                // プロジェクトファイルの取得
                HySString csPrjFile_Test = new HySString(csOpenFileDlg.FileName);
                // プロジェクトファイル内のプロジェクトグループ名取得
                HySString csPrjGrName_Test = CheckProjectGroupeName(csPrjFile_Test);

                // プロジェクトグループフォルダ名とプロジェクトファイル内のプロジェクトグループ名の比較
                if (csGrFolderName_Test != csPrjGrName_Test)
                {
                    // 比較し異なればメッセージ(ダイアログ)表示
                    MessageBox.Show(MC_MSG_ERROR_SAVE_PROJECT, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }

                HySString csFileName = new HySString(csOpenFileDlg.FileName);

                HySFile csPrjFile = new HySFile(csOpenFileDlg.FileName);
                csPrjFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);

                try
                {
                    HySSimulationDataContainer csContainer = csPrjFile.DataRead() as HySSimulationDataContainer;
                    //csContainer = new HySSimulationDataContainer(m_csScreen.GetSimKind(), new HySID("") );

                    csPrjFile.Close();

                    if (csContainer != null)
                    {
                        McProjectInfData csProjectInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);

                        HySString csPrcID = (HySString)csProjectInf.GetProjectID().GetString();
                        HySString csPrcKind = (HySString)csProjectInf.GetSimulatorKind().GetString();
                        HySString csPrcKey = csPrcKind + csPrcID;
                        // 表示条件チェック
                        if (((McDotNetProjectCtlScreen)m_csScreen).IsIncorporateProject() == true)
                        {// プロジェクト取込
                            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                            csEventObj.SetData(csContainer);
                            csEventObj.SetSubEventNo(McDefine.HYM_INCORPORATE_PROJECT);
                            // アクティブプロジェクトのIDを設定
                            csEventObj.SetSuppID(((McDotNetViewerJob)m_csScreen.GetViewerJob()).GetActiveProject());

                            if (false == this.PutEvent(csEventObj))
                            {// 異常
                               // ver1.5 エラートレース日本語対応
                                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject", 
                                   Properties.McDotNetViewerResources.STATEMENT_SIM_CREATE_ERR );
                               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject", "CMND_NEW_SIMULATOR_CREATE is failed.");
                                return -1;
                            }
                        }
                        else
                        {// 開く
                            // プロジェクトIDの重複チェック
                            if (this.CheckProjectIsOpen(csPrcKey) == false)
                            {// 重複読込みチェック
                                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_NEW_SIMULATOR_CREATE);
                                csEventObj.SetData(csContainer);

                                //// メニューマスク＆マウスカーソル変更（時計マーク）
                                //((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
                                //((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.WaitCursor;
                                if (false == this.PutEvent(csEventObj))
                                {// 異常
                                   // ver1.5 エラートレース日本語対応
                                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject",
                                        Properties.McDotNetViewerResources.STATEMENT_SIM_CREATE_ERR );
                                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject", "CMND_NEW_SIMULATOR_CREATE is failed.");
                                    return -1;
                                }
                            }
                            else
                            {// 既に同一IDプロジェクト表示中
                                HySString msgboxMsg = new HySString(MSG_ERROR_OPEN_PROJECT);
                                msgboxMsg += csProjectInf.GetProjectName().ToString();
                                MessageBox.Show(msgboxMsg.ToString(), MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                                return -1;
                            }
                        }
                    }
                    else
                    {
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject", 
                            "HySSimulationDataContainer " + Properties.McDotNetViewerResources.STATEMENT_IS_NULL );
                       // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject", "HySSimulationDataContainer is null.");
                    }
                }
                catch (Exception ex)
                {
                    // 此処に、エラーログ等の処理を入れる
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject", 
                     Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH +  " HySSimulationDataContainer = csPrjFile.DataRead(). " + ":" + ex.Message + ex.StackTrace);
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "OpenProject", "catch exception from HySSimulationDataContainer = csPrjFile.DataRead(). " + ":" + ex.Message + ex.StackTrace);
                    MessageBox.Show(MC_MSG_ERR_READ_PROJECT, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                }

            }
            return 0;
        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加 プロジェクトに関するエラーメッセージ出力機能
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトファイル中のプロジェクトグループ名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CheckProjectGroupeName(fileName)</para>
        /// </example>
        /// <param name="fileName">プロジェクトファイル名</param>
        /// <returns>プロジェクトファイル中のプロジェクトグループ名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected static HySString CheckProjectGroupeName(HySString fileName)
        {
            // プロジェクトファイル内のプロジェクトグループ情報の確認
            HySFile csPrjFile_Test = new HySFile(fileName);
            // プロジェクトファイルを開く
            csPrjFile_Test.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            // プロジェクトファイルからプロジェクトグループ名を取得
            HySString csPrjGrName_Test = GetProjectGroupName(csPrjFile_Test.DataRead());
            // プロジェクトファイルを閉じる
            csPrjFile_Test.Close();

            // 取得したプロジェクトグループ名を返す
            return csPrjGrName_Test;

        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加 プロジェクトに関するエラーメッセージ出力機能
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>バイナリデータからのプロジェクトグループ名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetProjectGroupName(csPrjFile_Test) </para>
        /// </example>
        /// <param name="csPrjFile_Test">プロジェクトファイルデータ</param>
        /// <returns>プロジェクトグループ名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected static HySString GetProjectGroupName(HySDataRoot csPrjFile_Test)
        {
            HySString errorcode = new HySString("");
            // バイナリデータを変数に格納
            HySSimulationDataContainer ProjectContainerData = csPrjFile_Test as HySSimulationDataContainer;

            // バイナリデータの有無の確認
            if (null == ProjectContainerData)
            {
                // バイナリデータがない場合は空データを返す
                return errorcode;
            }
            // バイナリデータからプロジェクト情報を取得　
            McProjectInfData csProjectInfe_Test = (McProjectInfData)ProjectContainerData.GetData(McDefine.HYM_DATA_PROJECT_INFO);
            // プロジェクト情報からプロジェクトグループ名を取得
            HySString csPrjGrName_Test = csProjectInfe_Test.GetProjectGroupName();
            // プロジェクトグループ名を返す
            return csPrjGrName_Test;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>新規作成ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NewProjectFileBtn.Click += new System.EventHandler(this.NewProjectFile_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NewProjectFile_Click(object sender, EventArgs e)
        {
            ShowNewProjectFileForm();
        }
        
        /// <summary><para>method outline:</para>
        /// <para>新規作成(ファイル形式用)画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowNewProjectFileForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowNewProjectFileForm()
        {
            m_NewProjectFileForm = new McDotNetNewProjectFileForm(m_csScreen);
            m_NewProjectFileForm.Text = FORM_TITLE_NEW_PROJECT;

            // 画面の表示
            m_NewProjectFileForm.ShowDialog();
        }

        /// <summary><para>method outline:</para>
        /// <para>上書ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SaveProject_Click.Click += new System.EventHandler(this.SaveProject_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SaveProject_Click(object sender, EventArgs e)
        {
            // 計算パラメータの保存
            SaveSimulationParameter();
            // シミュレーションモデル構築開始指示イベント生成 
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_PROJECT_SAVE_ACT, McDefine.HYMCO_PROJECT_SAVE);
            if (false == this.PutEvent(csEvent))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SaveProject_Click",
                   Properties.McDotNetViewerResources.STATEMENT_CMND_MODEL_ERR);
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SaveProject_Click", "PutEvent CMND_MODEL_CONSTRUCTION is failed.");
                return;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>別名保存ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NewSaveProject_Click.Click += new System.EventHandler(this.NewSaveProject_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NewSaveProject_Click(object sender, EventArgs e)
        {
            // 保存画面の表示
            ShowProjectSaveForm();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト保存画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowProjectSaveForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowProjectSaveForm()
        {
            // 計算パラメータの保存
            SaveSimulationParameter();

            if (m_csProjectInfData != null)
            {// プロジェクト情報有り
                m_ProjectSaveForm = new McDotNetProjectSaveForm(m_csScreen, m_csProjectInfData);
                m_ProjectSaveForm.Text = FORM_TITLE_PROJECT_SAVE + m_csProjectInfData.GetDispProjectName().ToString();
                m_ProjectSaveForm.ShowDialog();  // モーダルダイアログで表示する。
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名称自動生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MakeProjectNameAutomatically(csFolderName, csFileName);</para>
        /// </example>
        /// <param name="csFolderName">プロジェクトGrフォルダ名</param>
        /// <param name="csFileName">プロジェクトファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>既に同一名称のファイルが存在する場合はファイル名に付番したものを返す</para>
        /// </remarks>
        public HySString MakeProjectNameAutomatically(HySString csFolderName, HySString csFileName)
        {
            try
            {
                HySString csFilePath = HySEnvInf.GetDataHomeDirectory() + "\\" + csFolderName + "\\" + csFileName + ".cmprj";
                HySString csFolderPath = HySEnvInf.GetDataHomeDirectory() + "\\" + csFolderName + "\\";
                HySFile csFile = new HySFile(csFilePath);
                if (!csFile.Exist())
                {
                    // 存在しなければ入力プロジェクト名称をそのまま返す
                    return csFileName;
                }
                // 存在する場合
                // ファイル検索
                DirectoryInfo csDir = new DirectoryInfo(csFolderPath.ToString());
                FileInfo[] csFiles = csDir.GetFiles(csFileName.ToString() + "(*)" + ".cmprj");
                if (csFiles.Length == 0)
                {
                    // 付番されているファイルは無い（初回なので1を付番）
                    return csFileName + "(" + "1" + ")";
                }
                // 同一ファイルが存在し付番されているファイルがある
                long lMax = 0;
                long lNo = 0;
                Regex csRege = new Regex(@".*\((?<num>.*)\)");
                foreach (System.IO.FileInfo f in csFiles)
                {
                    // ファイルから付番値を取り出して最大値+1を付番
                    Match csMatch = csRege.Match(System.IO.Path.GetFileNameWithoutExtension(f.FullName));
                    Int64.TryParse(csMatch.Groups["num"].Value, out lNo);
                    if (lMax < lNo)
                    {
                        lMax = lNo;
                    }
                }
                lMax += 1;
                return csFileName + "(" + lMax.ToString() + ")";
            }
            catch(Exception ex)
            {
                // 例外発生時は入力プロジェクト名称をそのまま返す
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDotNetProjectCtlForm", "MakeProjectNameAutomatically", 
                   Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH + ex.ToString());
               // HySLog.LogOut(HySLog.ONLINE, "McDotNetProjectCtlForm", "MakeProjectNameAutomatically", "例外発生: " + ex.ToString());
                return csFileName;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>管理プロジェクト名称チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = IsManageProject(sDispProjectName);</para>
        /// </example>
        /// <param name="sDispProjectName">表示プロジェクト名称</param>
        /// <returns>=true:有り、=false:無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル管理されたプロジェクト名かチェックする</para>
        /// </remarks>
        public bool IsManageProject(string sDispProjectName)
        {
            bool bRtn = false;

            foreach (string sKey in m_csPrjNameTbl.Keys)
            {
                if (sKey.Equals(sDispProjectName, StringComparison.OrdinalIgnoreCase) == true)
                {// 既に作成済み
                    bRtn = true;
                    break;
                }
            }

            return bRtn;
        }
// Ver1.1 追加 <<<
        /// <summary><para>method outline:</para>
        /// <para>画面通知捕捉処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="m">Windowsメッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void WndProc(ref Message m)
        {
            const int WM_SYSCOMMAND = 0x0112;
            const int SC_MINIMIZE = 0xF020;
            const int SC_MAXIMIZE = 0xF030;
            // 最小化を検出し、最小化前の配置・形状情報を保存しておく
            if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MINIMIZE)
            {
                // 配置情報を保存
                Properties.Settings.Default.ProjectLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.ProjectClientSize = this.ClientSize;
            }
            else if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MAXIMIZE)
            {
                // Do Nothing
            }
            base.WndProc(ref m);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面クローズ時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.McDotNetProjectCtlForm_FormClosing);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetProjectCtlForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            // ウィンドウ情報を保存
            Properties.Settings.Default.ProjectWindowState = this.WindowState;
            if (this.WindowState == FormWindowState.Normal)
            {// 通常表示状態の場合(最小化状態の場合は、WndProc()にて保存済)
                // 配置情報を保存
                Properties.Settings.Default.ProjectLocation = this.Location;
                // 形状情報を保存
                Properties.Settings.Default.ProjectClientSize = this.ClientSize;
            }
            // 表示状態を保存
            if (this.Owner.WindowState != FormWindowState.Minimized)
            {
                Properties.Settings.Default.ProjectVisible = this.Visible;
            }
            // 外部ファイルに保存
            Properties.Settings.Default.Save();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ロード時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Load += new System.EventHandler(this.McDotNetProjectCtlForm_Load);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetProjectCtlForm_Load(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.ProjectLocation.X != -1 && Properties.Settings.Default.ProjectLocation.Y != -1)
            {
                // 保存情報をもとに配置情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.Location = Properties.Settings.Default.ProjectLocation;
            }
            if (Properties.Settings.Default.ProjectClientSize.Height != -1 && Properties.Settings.Default.ProjectClientSize.Width != -1)
            {
                // 保存情報をもとに形状情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.ClientSize = Properties.Settings.Default.ProjectClientSize;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Shown += new System.EventHandler(this.McDotNetProjectCtlForm_Shown);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetProjectCtlForm_Shown(object sender, EventArgs e)
        {
            long lCallBackNo = 70300;
            // 初回はデフォルト表示
            // 保存情報をもとに表示状態を復元
            this.Visible = Properties.Settings.Default.ProjectVisible;
            if (this.Visible == false)
            {
                // チェックオン状態の変更
                HySDotNetMainForm csMainForm = (HySDotNetMainForm)this.Owner;
                csMainForm.SetCheckOnFlg(lCallBackNo, false);
            }
            // 保存情報をもとにウィンドウ状態を復元
            //this.WindowState = Properties.Settings.Default.ProjectWindowState;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが閉じた後に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClosedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormClosedEvent(object sender, FormClosedEventArgs e)
        {
            //m_bFormCloseflg = true;
            // タイマの停止
            m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            // 非同期操作の終了
            m_csAO.OperationCompleted();
            // タイマの破棄
            m_csThreadTimerInstance.Dispose();
        }
    }
}


