// <summary>ソースコード：プロジェクト管理処理中画面フォームクラス</summary>
// <author>CommonMP</author>using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYMCO.Interface;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{

    /// <summary><para>class outline:</para>
    /// <para>プロジェクト管理処理中画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/22][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectCtlProgressForm : HySDotNetForm
    {

        /// <summary>タイトル「インポート」 </summary>
        static private readonly string TITLE_PROJDATA_IMPORT = Properties.McDotNetViewerResources.TITLE_PROJDATA_IMPORT;    //"プロジェクトのインポート"
        /// <summary>タイトル「エクスポート」 </summary>
        static private readonly string TITLE_PROJDATA_DEFAULT = Properties.McDotNetViewerResources.TITLE_PROJDATA_DEFAULT;  //"処理中"

        /// <summary>本文「インポート」 </summary>
        static private readonly string TEXT_PROJDATA_IMPORT = Properties.McDotNetViewerResources.TEXT_PROJDATA_IMPORT;  //"プロジェクトのインポート処理中"
        /// <summary>本文「デフォルト」 </summary>
        static private readonly string TEXT_PROJDATA_DEFAULT = Properties.McDotNetViewerResources.TEXT_PROJDATA_DEFAULT;    //"処理中"

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectCtlProgressForm csForm = new McDotNetProjectCtlProgressForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlProgressForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McDotNetProjectCtlProgressForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectCtlProgressForm csForm = new McDotNetProjectCtlProgressForm(lCallbackNumber);</para>
        /// </example>
        /// <param name="lCallbackNumber">メニューコールバック番号</param>
        /// <returns>McDotNetProjectCtlProgressForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectCtlProgressForm(long lCallbackNumber)
        {
            InitializeComponent();

            // 画面情報設定
            SetDialogInfo(lCallbackNumber);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDialogInfo(long lCallbackNumber);</para>
        /// </example>
        /// <param name="lCallbackNumber">メニューコールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetDialogInfo(long lCallbackNumber)
        {
            // メニューコールバック番号に対応する
            // テキストを設定する
            if (lCallbackNumber == McDefine.HYMCO_DB_IMPORT)
            {   // インポート
                this.Text = TITLE_PROJDATA_IMPORT;
                ProgressDlgText.Text = TEXT_PROJDATA_IMPORT;
                ProgressDlgText.Location = new Point(59, 26);
            }
            else
            {   // それ以外の場合
                this.Text = TITLE_PROJDATA_DEFAULT;
                ProgressDlgText.Text = TEXT_PROJDATA_DEFAULT;
            }
        }
    }
}

