﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト詳細画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクト詳細画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectDetailForm : HySDotNetForm
    {
        //定数定義
        /// <summary>プロパティ表示数 </summary>
        protected static readonly int PROPERTY_NUM = 11;

        /// <summary>プロジェクトプロパティ名称　「プロジェクト名」 </summary>
        static private readonly string PROPERTY_PRJNAME = Properties.McDotNetViewerResources.PROPERTY_PRJNAME;
        /// <summary>プロジェクトプロパティ名称　「管理者名」 </summary>
        static private readonly string PROPERTY_ADMINNAME = Properties.McDotNetViewerResources.PROPERTY_ADMINNAME;
        /// <summary>プロジェクトプロパティ名称　「キー1」 </summary>
        static private readonly string PROPERTY_KEYONE = Properties.McDotNetViewerResources.PROPERTY_KEYONE;
        /// <summary>プロジェクトプロパティ名称　「キー2」 </summary>
        static private readonly string PROPERTY_KEYTWO = Properties.McDotNetViewerResources.PROPERTY_KEYTWO;
        /// <summary>プロジェクトプロパティ名称　「計算開始時刻」 </summary>
        static private readonly string PROPERTY_STARTTIME = Properties.McDotNetViewerResources.PROPERTY_STARTTIME;
        /// <summary>プロジェクトプロパティ名称　「計算終了時刻」 </summary>
        static private readonly string PROPERTY_ENDTIME = Properties.McDotNetViewerResources.PROPERTY_ENDTIME;
        /// <summary>プロジェクトプロパティ名称　「計算中断時刻」 </summary>
        static private readonly string PROPERTY_SUSPENDTIME = Properties.McDotNetViewerResources.PROPERTY_SUSPENDTIME;
        ///// <summary>プロジェクトプロパティ名称　「タイムステップ」 </summary>
        //static private readonly string PROPERTY_DELTATIME = "タイムステップ";
        /// <summary>プロジェクトプロパティ名称　「備考」 </summary>
        static private readonly string PROPERTY_COMMENT = Properties.McDotNetViewerResources.PROPERTY_COMMENT;
        /// <summary>プロジェクトプロパティ名称　「作成日」 </summary>
        static private readonly string PROPERTY_CREATEDATE = Properties.McDotNetViewerResources.PROPERTY_CREATEDATE;
        /// <summary>プロジェクトプロパティ名称　「登録日」 </summary>
        static private readonly string PROPERTY_REGISTDATE = Properties.McDotNetViewerResources.PROPERTY_REGISTDATE;
        /// <summary>プロジェクトプロパティ名称　「更新日」 </summary>
        static private readonly string PROPERTY_UPDATEDATE = Properties.McDotNetViewerResources.PROPERTY_UPDATEDATE;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectDetailForm csProjectDetail = new McDotNetProjectDetailForm( csFormData );</para>
        /// </example>
        /// <param name="csPrjData">プロジェクト管理データクラス</param>
        /// <returns>McDotNetProjectDetailForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectDetailForm(McProjectInfData csPrjData)
        {
            InitializeComponent();

            // プロジェクトプロパティ初期表示
            for (int i = 0; i < PROPERTY_NUM; i++)
            {
                ProjectDataGridView.Rows.Add();
            }
            // 項目名称の設定
            ProjectDataGridView.Rows[0].Cells[0].Value = PROPERTY_PRJNAME;      //プロジェクト名
            ProjectDataGridView.Rows[1].Cells[0].Value = PROPERTY_ADMINNAME;    //管理者名
            ProjectDataGridView.Rows[2].Cells[0].Value = PROPERTY_KEYONE;       //キー1
            ProjectDataGridView.Rows[3].Cells[0].Value = PROPERTY_KEYTWO;       //キー2
            ProjectDataGridView.Rows[4].Cells[0].Value = PROPERTY_STARTTIME;    //計算開始時刻
            ProjectDataGridView.Rows[5].Cells[0].Value = PROPERTY_ENDTIME;      //計算終了時刻
            ProjectDataGridView.Rows[6].Cells[0].Value = PROPERTY_SUSPENDTIME;  //計算中断時刻
            ProjectDataGridView.Rows[7].Cells[0].Value = PROPERTY_COMMENT;      //備考
            ProjectDataGridView.Rows[8].Cells[0].Value = PROPERTY_CREATEDATE;   //作成日
            ProjectDataGridView.Rows[9].Cells[0].Value = PROPERTY_REGISTDATE;   //登録日
            ProjectDataGridView.Rows[10].Cells[0].Value = PROPERTY_UPDATEDATE;   //更新日

            // プロジェクト情報の表示設定
            SetProjectInfo(csPrjData);

        }

        /// <summary><para>method outline</para>
        /// <para>詳細情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProjectInfo( csPrjData );</para>
        /// </example>
        /// <param name="csPrjData">プロジェクト管理データクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetProjectInfo(McProjectInfData csPrjData)
        {
            // 詳細情報を画面に設定する
            if ((object)csPrjData.GetProjectName() != null)
            {
                // プロジェクト名
                ProjectDataGridView.Rows[0].Cells[1].Value = (csPrjData.GetProjectName()).ToString();
            }
            if ((object)csPrjData.GetAdminName() != null)
            {
                // 管理者名
                ProjectDataGridView.Rows[1].Cells[1].Value = (csPrjData.GetAdminName()).ToString();
            }
            /*
            if ((object)csPrjData.GetKeyOne() != null)
            {
                // キー1
                ProjectDataGridView.Rows[2].Cells[1].Value = (csPrjData.GetKeyOne()).ToString();
            }
            if ((object)csPrjData.GetKeyTwo() != null)
            {
                // キー2
                ProjectDataGridView.Rows[3].Cells[1].Value = (csPrjData.GetKeyTwo()).ToString();
            }
            */
            if ((object)csPrjData.GetStartSimuTime() != null)
            {
                // 計算開始時刻
                ProjectDataGridView.Rows[4].Cells[1].Value = (HySCalendar.ToString(csPrjData.GetStartSimuTime(), 0));
            }
            if ((object)csPrjData.GetEndSimuTime() != null)
            {
                // 計算終了時刻
                ProjectDataGridView.Rows[5].Cells[1].Value = (HySCalendar.ToString(csPrjData.GetEndSimuTime(), 0));
            }
            if ((object)csPrjData.GetSuspendTime() != null)
            {
                // 計算中断時刻
                ProjectDataGridView.Rows[6].Cells[1].Value = (HySCalendar.ToString(csPrjData.GetSuspendTime(), 0));
            }
            if ((object)csPrjData.GetComment() != null)
            {
                // 備考
                ProjectDataGridView.Rows[7].Cells[1].Value = (csPrjData.GetComment()).ToString();
            }
            if ((object)csPrjData.GetCreateDate() != null)
            {
                // 作成日
                string strCreate = (HySCalendar.ToString(csPrjData.GetCreateDate(), 0));
                ProjectDataGridView.Rows[8].Cells[1].Value = strCreate.Substring(0, strCreate.IndexOf(" "));
            }
            if ((object)csPrjData.GetRegistDate() != null)
            {
                // 登録日
                string strRegist = (HySCalendar.ToString(csPrjData.GetRegistDate(), 0));
                ProjectDataGridView.Rows[9].Cells[1].Value = strRegist.Substring(0, strRegist.IndexOf(" "));
            }
            if ((object)csPrjData.GetUpdateDate() != null)
            {
                // 更新日
                string strUpdate = (HySCalendar.ToString(csPrjData.GetUpdateDate(), 0));
                ProjectDataGridView.Rows[10].Cells[1].Value = strUpdate.Substring(0, strUpdate.IndexOf(" "));
            }
        }

        /// <summary><para>method outline</para>
        /// <para>閉じるボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.CloseButton.Click += new System.EventHandler(this.CloseButton_Click);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Close(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary><para>method outline</para>
        /// <para>タイムステップ変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>string sTimeStep = TimeStepToString(csTime);</para>
        /// </example>
        /// <param name="csTime">タイムステップ(日付クラス)</param>
        /// <returns>タイムステップ文字列(String文字列)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 日、時、分、秒の中で整数値で表せる最大の単位にてタイムステップ値(秒)を
        /// 文字列に変換する
        /// </para>
        /// </remarks>
        private string TimeStepToString(HySTime csTime)
        {
            // タイムステップ値(単位：秒)を取得する
            long lTimeStep = (long)csTime.GetTime();
            // 単位文字列の設定（初期値：「秒」)
            string strUnit = McDotNetProjectCtlForm.STR_UNIT_SEC;

            // 単位変換係数配列
            long[] lTransUnitArray = { McDotNetProjectCtlForm.SEC_PER_DAY,  // 秒/日
                                       McDotNetProjectCtlForm.SEC_PER_HOUR, // 秒/時
                                       McDotNetProjectCtlForm.SEC_PER_MIN   // 秒/分
                                      };
            // 単位文字列配列
            string[] strUnitArray = { McDotNetProjectCtlForm.STR_UNIT_DAY, // 「日」 
                                      McDotNetProjectCtlForm.STR_UNIT_HOUR,// 「時」
                                      McDotNetProjectCtlForm.STR_UNIT_MIN  // 「分」
                                    　};

            // 日,時,分の単位の整数で表せるかチェック
            for (int i = 0; i < lTransUnitArray.Length; i++)
            {
                if ((lTimeStep % lTransUnitArray[i]) == 0)
                {
                    strUnit = strUnitArray[i];
                    lTimeStep = lTimeStep / lTransUnitArray[i];
                    break;
                }
            }

            // 文字列を作成する
            StringBuilder strRtn = new StringBuilder();
            strRtn.Append(lTimeStep);
            strRtn.Append(strUnit);
            return strRtn.ToString();
        }
    }
}