﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクトファイル名選択画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクトファイル名選択画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/16][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectFileDialog : HySDotNetForm
    {
        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string CLASS_NAME = "McDotNetProjectFileDialog";

        /// <summary>
        /// メッセージボックスタイトル『プロジェクト管理機能』
        /// </summary>
        private static readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");
        /// <summary>未入力[プロジェクトグループ名]</summary>
        private static readonly string MSG_IMPUT_DATA_PGROUP = McMessage.GetString("MC_MSG_CHECK_IMPUT_DATA_PGROUP");
        /// <summary>未入力[プロジェクト名]</summary>
        private static readonly string MSG_IMPUT_DATA_PROJECT = McMessage.GetString("MC_MSG_CHECK_IMPUT_DATA_PROJECT");
        /// <summary>指定ファイル無し</summary>
        private static readonly string MSG_NOT_FILE = McMessage.GetString("MC_MSG_CHECK_NOT_FILE");

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加 プロジェクトの削除機能
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary>メッセージ『選択したファイルを削除します。』</summary>
        private static readonly string MSG_FILE_DELETE = McMessage.GetString("MC_MSG_SELECTED_FILE_DELETE");
        /// <summary>メッセージ『プロジェクトファイルが見つかりません。』</summary>
        private static readonly string MSG_NOT_FIND_FILE = McMessage.GetString("MC_MSG_NOT_FIND_FILE");
        /// <summary>メッセージ『ファイルを削除することができません。』</summary>
        private static readonly string MSG_NOT_DELETE_FILE = McMessage.GetString("MC_MSG_NOT_DELETE_FILE");
        /// <summary>『ファイル名：』</summary>
        private static readonly string MSG_FILENAME = McMessage.GetString("MC_MSG_FILENAME");
        /// <summary>『メッセージ：』</summary>
        private static readonly string MSG_MESSAGE = McMessage.GetString("MC_MSG_MESSAGE");
        /// <summary>メッセージ『選択したプロジェクトファイルを削除しました。』</summary>
        private static readonly string MSG_PROJECTEFILE_DELET = McMessage.GetString("MC_MSG_SELECTED_PROJECTFILE_DELETE");
        /// <summary>データコンテナ管理ハッシュテーブル</summary>
        private Hashtable m_csDataContainerTbl; // 既に開いているプロジェクトを認識するために利用する
        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetProjectFileDialog";

        /// <summary>基準パス</summary>
        private HySString m_csFilePath = null;
        /// <summary>プロジェクトグループ名称</summary>
        private HySString m_csProjectGroupName = null;
        /// <summary>プロジェクト名称</summary>
        private HySString m_csProjectName = null;

        /// <summary>ファイルパス</summary>
        public string FileName = null;

        /// <summary>動作モード</summary>
        private int m_iMode = 0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectFileDialog csProjectFileDialog = new McDotNetProjectFileDialog();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McDotNetProjectFileDialog()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectFileForm csNewProjectFileForm = new McDotNetNewProjectFileForm(csFilePath);</para>
        /// </example>
        /// <param name="csFilePath">基準パス</param>
        /// <returns>McDotNetNewProjectFileForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ファイル名を選択する場合に使用</para>
        /// </remarks>
        public McDotNetProjectFileDialog(HySString csFilePath)
        {
            InitializeComponent();
            Init(csFilePath);

            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加 プロジェクトの削除機能
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            m_csDataContainerTbl = null;
        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加 プロジェクトの削除機能
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectFileForm csNewProjectFileForm = new McDotNetNewProjectFileForm(csFilePath);</para>
        /// </example>
        /// <param name="csFilePath">基準パス</param>
        /// <param name="csDataContainerTbl">データコンテナ管理ハッシュテーブル</param>
        /// <returns>McDotNetNewProjectFileForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ファイル名を選択する場合に使用</para>
        /// </remarks>
        public McDotNetProjectFileDialog(HySString csFilePath, Hashtable csDataContainerTbl)
        {
            InitializeComponent();
            Init(csFilePath);

            m_csDataContainerTbl = csDataContainerTbl;
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectFileDialog csProjectFileDialog = new McDotNetProjectFileDialog(csFilePath,csProjectGroupName,csProjectName);</para>
        /// </example>
        /// <param name="csFilePath">基準パス</param>
        /// <param name="csProjectGroupName">プロジェクトグループ</param>
        /// <param name="csProjectName">プロジェクト名</param>
        /// <returns>McDotNetProjectFileDialog 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>グループ名・プロジェクト名指定用に使用</para>
        /// </remarks>
        public McDotNetProjectFileDialog(HySString csFilePath, HySString csProjectGroupName, HySString csProjectName)
        {
            InitializeComponent();
            m_iMode = 1;
            Init(csFilePath);
            m_csProjectGroupName = csProjectGroupName;
            m_csProjectName = csProjectName;
            if ((object)m_csProjectGroupName != null)
            {
                for (int i = 0; i < ProjectGroup_ListBox.Items.Count; i++)
                {
                    if (m_csProjectGroupName.CompareTo(new HySString(ProjectGroup_ListBox.Items[i].ToString())) == 0)
                    {// 該当ある場合は、リスト選択状態とする
                        ProjectGroup_ListBox.SelectedIndex = i;
                        break;
                    }
                }

                ProjectGroup_TextBox.Text = csProjectGroupName.ToString();
            }
            if ((object)m_csProjectName != null)
            {
                ProjectName_TextBox.Text = csProjectName.ToString();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Init(csFilePath);</para>
        /// </example>
        /// <param name="csFilePath">標準パス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Init(HySString csFilePath)
        {
            m_csFilePath = csFilePath;
            if ((object)m_csFilePath != null)
            {
                DataPath_TextBox.Text = m_csFilePath.ToString();
                Load_ProjectGroupName(m_csFilePath);
            }

            McFileComboBoxItem csItem = new McFileComboBoxItem(Properties.McDotNetViewerResources.FILE_DLG_FILTER_ALLFILES_NAME, "*");
            File_ComboBox.Items.Add(csItem);
            csItem = new McFileComboBoxItem(Properties.McDotNetViewerResources.FILE_DLG_FILTER_CMPPRJCT_NAME, "*.cmprj");
            File_ComboBox.Items.Add(csItem);

            File_ComboBox.Text = csItem.Name;
        }


        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Load_ProjectGroupName(csFilePath);</para>
        /// </example>
        /// <param name="csFilePath">標準パス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Load_ProjectGroupName(HySString csFilePath)
        {
            DirectoryInfo selectedDir = new DirectoryInfo(csFilePath.ToString());   // データホームディレクトリ

            if (selectedDir.Exists) //ディレクトリが存在すればノードに追加
            {
                DirectoryInfo[] subDirInfo = selectedDir.GetDirectories();  // プロジェクトグループディレクトリ取得

                foreach (DirectoryInfo di in subDirInfo)
                {// プロジェクトグループディレクトリを格納
                    try
                    {
                        ProjectGroup_ListBox.Items.Add(di.Name);
                    }
                    catch (Exception ex)
                    {
                       // ver1.5 エラートレース日本語対応
                       // HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, "Load_ProjectGroupName", "プロジェクトグループ設定で例外発生:" + Environment.NewLine + ex.ToString());
                        HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, "Load_ProjectGroupName",
                            Properties.McDotNetViewerResources.STATEMENT_PROJ_GROUPSET_NG + Environment.NewLine + ex.ToString());
                    }
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>プロジェクトグループ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectGroup_ListBox.SelectIndexChanged += new System.EventHandler(this.Select_ProjectGroup);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Select_ProjectGroup(object sender, EventArgs e)
        {

            if (((ListBox)sender).SelectedItem == null)
            {// 未指定
                return;
            }

            String sPath = null;
            string csFilter = "*";

            sPath = m_csFilePath.ToString() + "\\" + ((ListBox)sender).SelectedItem.ToString();
            DirectoryInfo csSelectedDir = new DirectoryInfo(sPath);

            if (File_ComboBox.SelectedItem != null)
            {
                csFilter = ((McFileComboBoxItem)File_ComboBox.SelectedItem).Value;
            }

            ProjectFile_ListBox.Items.Clear();

            if (csSelectedDir != null)//＋マークによるノード展開でデフォルトのA:\アクセス回避
            {
                if (csSelectedDir.Exists)
                {

                    try
                    {
                        DirectoryInfo[] subDirInfo = csSelectedDir.GetDirectories(csFilter);
                        foreach (DirectoryInfo csDirInfo in subDirInfo)
                        {
                                ProjectFile_ListBox.Items.Add(csDirInfo.Name);
                        }

                        foreach (FileInfo csFileInfo in csSelectedDir.GetFiles(csFilter))
                        {
                            ProjectFile_ListBox.Items.Add(csFileInfo.Name);
                        }
                    }
                    catch (Exception ex)
                    {
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, "Select_ProjectGroup",
                            Properties.McDotNetViewerResources.STATEMENT_PROJ_GROUPSEL_NG + Environment.NewLine + ex.ToString());
                       // HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, "Select_ProjectGroup", "プロジェクトグループ選択で例外発生:" + Environment.NewLine + ex.ToString());
                    }
                }
            }

            ProjectGroup_TextBox.Text = ((ListBox)sender).SelectedItem.ToString();

        }

        /// <summary><para>method outline</para>
        /// <para>プロジェクトファイル選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectFile_ListBox.SelectIndexChanged += new System.EventHandler(this.Select_ProjectFile);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Select_ProjectFile(object sender, EventArgs e)
        {
            if (((ListBox)sender).SelectedItem == null)
            {// 未指定
                return;
            }

            String csFileName = null;

            csFileName = ((ListBox)sender).SelectedItem.ToString();
            if (csFileName.LastIndexOf(".cmprj") > 0)
            {
                ProjectName_TextBox.Text = csFileName;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>開くボタン</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Open_Button.Click += new System.EventHandler(this.OpenFile);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OpenFile(object sender, EventArgs e)
        {
            int iLength = 0;

            String csProjectGruopName = ProjectGroup_TextBox.Text;
            String csProjectName = ProjectName_TextBox.Text;

            iLength = csProjectName.LastIndexOf(".cmprj");
            if (iLength > 0 && csProjectName.Length == (iLength + 6))
            {// ファイル拡張子カット
                csProjectName = csProjectName.Substring(0, iLength);
            }

            if (csProjectGruopName.CompareTo("") != 0 && csProjectName.CompareTo("") != 0)
            {// 入力情報有り
                m_csProjectGroupName = new HySString(csProjectGruopName);
                m_csProjectName = new HySString(csProjectName);

                this.FileName = m_csFilePath.ToString() + "\\" + csProjectGruopName + "\\" + csProjectName + ".cmprj";

                if (m_iMode == 0 && File.Exists(this.FileName) == false)
                {// 該当ファイル無し
                    MessageBox.Show(MSG_NOT_FILE, MSGBOX_TITLE);
                    return;
                }

                this.DialogResult = DialogResult.OK;
                this.Close();
            }
            else
            {// 入力項目不足
                if (csProjectGruopName.CompareTo("") == 0)
                {// プロジェクトグループ未入力
                    MessageBox.Show(MSG_IMPUT_DATA_PGROUP, MSGBOX_TITLE);
                }
                else
                {// プロジェクト名未入力
                    MessageBox.Show(MSG_IMPUT_DATA_PROJECT, MSGBOX_TITLE);
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>キャンセルボタン</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>プロジェクトグループ名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectGroupName = GetProjectGroupName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectGroupName()
        {
            return m_csProjectGroupName;
        }
        
        /// <summary><para>method outline</para>
        /// <para>プロジェクト名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectName = GetProjectName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectName()
        {
            return m_csProjectName;
        }

        /// <summary><para>method outline</para>
        /// <para>コンボボックス選択(クリック)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.File_ComboBox.SelectedIndexChanged += new System.EventHandler(this.File_ComboBox_SelectedIndexChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void File_ComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int iSelectIndex = 0;   // 選択インデックス番号

            iSelectIndex = ProjectGroup_ListBox.SelectedIndex;
            if (iSelectIndex != -1)
            {// 選択有り
                ProjectGroup_ListBox.SetSelected(iSelectIndex, true);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>コンボボックス選択（ダブルクリック）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectFile_ListBox.DoubleClick += new System.EventHandler(this.ProjectFile_DoubleClick);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectFile_DoubleClick(object sender, EventArgs e)
        {
            if (m_iMode == 1)
            {// 無効とする。
                return;
            }

            String csFileName = null;
            String csProjectGruopName = null;

            if (((ListBox)sender).SelectedItem == null)
            {// 未指定
                return;
            }

            csFileName = ((ListBox)sender).SelectedItem.ToString();
            if (csFileName.LastIndexOf(".cmprj") > 0)
            {
                if (ProjectGroup_ListBox.SelectedItem != null)
                {
                    csProjectGruopName = ProjectGroup_ListBox.SelectedItem.ToString();
                    this.FileName = m_csFilePath.ToString() + "\\" + csProjectGruopName + "\\" + csFileName;

                    m_csProjectGroupName = new HySString(csProjectGruopName);
                    m_csProjectName = new HySString(csFileName);

                    this.DialogResult = DialogResult.OK;
                    this.Close();
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0012, null);
        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加 プロジェクトの削除機能
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

        private void contextMenuStrip1_Opening(object sender, CancelEventArgs e)
        {
            this.deleteToolStripMenuItem.Enabled = false;
            
            if (null == this.ProjectFile_ListBox.SelectedItem)
            {
                return;
            }

            string selectedFileName = this.ProjectFile_ListBox.SelectedItem.ToString();
            if (0 >= selectedFileName.LastIndexOf(".cmprj"))
            {
                return;

            }

            this.deleteToolStripMenuItem.Enabled = true;
        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加 プロジェクトの削除機能
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string selectedFileName = this.ProjectFile_ListBox.SelectedItem.ToString();
            string projectName = this.ProjectGroup_TextBox.Text.ToString();

            if (0 >= selectedFileName.Length || 0 >= projectName.Length)
            {
                return;
            }

            if (0 >= selectedFileName.LastIndexOf(".cmprj"))
            {
                return;

            }
            
            string projectFilePath = m_csFilePath.ToString() + "\\" + projectName + "\\" + selectedFileName;

            try
            {
                if (!File.Exists(projectFilePath))
                {
                    throw new FileNotFoundException(MSG_NOT_FIND_FILE, projectFilePath);
                }
            }
            catch (Exception exception)
            {
                string message;
                message = MSG_NOT_DELETE_FILE + "\r\n" + MSG_FILENAME + projectFilePath + "\r\n" + MSG_MESSAGE + exception.Message;
                MessageBox.Show(message, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                ProjectFile_ListBox.Items.RemoveAt(ProjectFile_ListBox.SelectedIndex);
                ProjectName_TextBox.Text = string.Empty;
                return;
            }

            HySFile csPrjFile = new HySFile(projectFilePath);
            csPrjFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);

            try
            {
                HySSimulationDataContainer csContainer = csPrjFile.DataRead() as HySSimulationDataContainer;

                csPrjFile.Close();

                if (null != csContainer)
                {
                    McProjectInfData csProjectInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);

                    HySString csPrcID = (HySString)csProjectInf.GetProjectID().GetString();
                    HySString csPrcKind = (HySString)csProjectInf.GetSimulatorKind().GetString();
                    HySString csPrcKey = csPrcKind + csPrcID;

                    if (null != m_csDataContainerTbl[csPrcKey.ToString()])
                    {
                        // ファイルオープン済
                        MessageBox.Show(MSG_NOT_DELETE_FILE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        return;
                    }
                }
                else
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "deleteToolStripMenuItem_Click", 
                        "HySSimulationDataContainer" + Properties.McDotNetViewerResources.STATEMENT_IS_NULL );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "deleteToolStripMenuItem_Click", "HySSimulationDataContainer is null.");
                    MessageBox.Show(MSG_NOT_DELETE_FILE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "deleteToolStripMenuItem_Click", 
                    Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH 
                    + " HySSimulationDataContainer = csPrjFile.DataRead(). " + ":" + ex.Message + ex.StackTrace);
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "deleteToolStripMenuItem_Click", "catch exception from HySSimulationDataContainer = csPrjFile.DataRead(). " + ":" + ex.Message + ex.StackTrace);
                MessageBox.Show(MSG_NOT_DELETE_FILE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            DialogResult result;
            result = MessageBox.Show(MSG_FILE_DELETE, MSGBOX_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Question);
            if (DialogResult.OK != result)
            {
                return;    
            }

            File.Delete(projectFilePath);
            result = MessageBox.Show(MSG_PROJECTEFILE_DELET, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
            ProjectFile_ListBox.Items.RemoveAt( ProjectFile_ListBox.SelectedIndex );
            ProjectName_TextBox.Text = string.Empty;

        }

    }

    /// <summary><para>class outline:</para>
    /// <para>コンボボックス登録アイテム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/16][新規作成]</para>
    /// </remarks>
    public class McFileComboBoxItem
    {
        /// <summary>表示名称</summary>
        private string m_sName = "";
        /// <summary>値</summary>
        private string m_sValue = "";

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McFileComboBoxItem(sName, sValue);</para>
        /// </example>
        /// <param name="sName">表示名称</param>
        /// <param name="sValue">設定値</param>
        /// <returns>McFileComboBoxItem 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McFileComboBoxItem(string sName, string sValue)
        {
            m_sName = sName;
            m_sValue = sValue;
        }

        /// <summary><para>method outline</para>
        /// <para>表示値セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>sName = Name;</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string Name
        {
            get
            {
                return m_sName;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>表示値セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>sValue = Value;</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string Value
        {
            get
            {
                return m_sValue;
            }
        }


        /// <summary><para>method outline</para>
        /// <para>表示値セット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>sName = ToString();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override string ToString()
        {
            return m_sName;
        }
    }

}
